// components/services/storage/public/mojom/indexed_db_control.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace storage {
namespace mojom {
namespace internal {
class IndexedDBStorageUsageInfo_Data;
class IndexedDBStoragePolicyUpdate_Data;

struct ForceCloseReason_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  IndexedDBStorageUsageInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IndexedDBStorageUsageInfo_Data));
      new (data()) IndexedDBStorageUsageInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IndexedDBStorageUsageInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IndexedDBStorageUsageInfo_Data>(index_);
    }
    IndexedDBStorageUsageInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  uint64_t size_in_bytes;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified_time;

 private:
  IndexedDBStorageUsageInfo_Data();
  ~IndexedDBStorageUsageInfo_Data() = delete;
};
static_assert(sizeof(IndexedDBStorageUsageInfo_Data) == 32,
              "Bad sizeof(IndexedDBStorageUsageInfo_Data)");
// Used by IndexedDBStorageUsageInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IndexedDBStorageUsageInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IndexedDBStorageUsageInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IndexedDBStorageUsageInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    IndexedDBStorageUsageInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IndexedDBStorageUsageInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  IndexedDBStoragePolicyUpdate_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(IndexedDBStoragePolicyUpdate_Data));
      new (data()) IndexedDBStoragePolicyUpdate_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    IndexedDBStoragePolicyUpdate_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<IndexedDBStoragePolicyUpdate_Data>(index_);
    }
    IndexedDBStoragePolicyUpdate_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  uint8_t purge_on_shutdown : 1;
  uint8_t padfinal_[7];

 private:
  IndexedDBStoragePolicyUpdate_Data();
  ~IndexedDBStoragePolicyUpdate_Data() = delete;
};
static_assert(sizeof(IndexedDBStoragePolicyUpdate_Data) == 24,
              "Bad sizeof(IndexedDBStoragePolicyUpdate_Data)");
// Used by IndexedDBStoragePolicyUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IndexedDBStoragePolicyUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IndexedDBStoragePolicyUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IndexedDBStoragePolicyUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    IndexedDBStoragePolicyUpdate_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IndexedDBStoragePolicyUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_INTERNAL_H_