// components/services/storage/public/mojom/indexed_db_control_test.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-shared.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class MockFailureInjectorProxy;

template <typename ImplRefTraits>
class MockFailureInjectorStub;

class MockFailureInjectorRequestValidator;
class MockFailureInjectorResponseValidator;


class  MockFailureInjector
    : public MockFailureInjectorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MockFailureInjectorInterfaceBase;
  using Proxy_ = MockFailureInjectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = MockFailureInjectorStub<ImplRefTraits>;

  using RequestValidator_ = MockFailureInjectorRequestValidator;
  using ResponseValidator_ = MockFailureInjectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFailOperationMinVersion = 0,
  };
  virtual ~MockFailureInjector() {}


  using FailOperationCallback = base::OnceCallback<void()>;
  
  virtual void FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num, FailOperationCallback callback) = 0;
};

class IndexedDBControlTestProxy;

template <typename ImplRefTraits>
class IndexedDBControlTestStub;

class IndexedDBControlTestRequestValidator;
class IndexedDBControlTestResponseValidator;


class  IndexedDBControlTest
    : public IndexedDBControlTestInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = IndexedDBControlTestInterfaceBase;
  using Proxy_ = IndexedDBControlTestProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBControlTestStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBControlTestRequestValidator;
  using ResponseValidator_ = IndexedDBControlTestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBaseDataPathForTestingMinVersion = 0,
    kGetFilePathForTestingMinVersion = 0,
    kResetCachesForTestingMinVersion = 0,
    kForceSchemaDowngradeForTestingMinVersion = 0,
    kHasV2SchemaCorruptionForTestingMinVersion = 0,
    kWriteToIndexedDBForTestingMinVersion = 0,
    kGetBlobCountForTestingMinVersion = 0,
    kGetNextBlobNumberForTestingMinVersion = 0,
    kGetPathForBlobForTestingMinVersion = 0,
    kCompactBackingStoreForTestingMinVersion = 0,
    kBindMockFailureSingletonForTestingMinVersion = 0,
    kGetDatabaseKeysForTestingMinVersion = 0,
  };
  virtual ~IndexedDBControlTest() {}


  using GetBaseDataPathForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  
  virtual void GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) = 0;


  using GetFilePathForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  
  virtual void GetFilePathForTesting(const ::url::Origin& origin, GetFilePathForTestingCallback callback) = 0;


  using ResetCachesForTestingCallback = base::OnceCallback<void()>;
  
  virtual void ResetCachesForTesting(ResetCachesForTestingCallback callback) = 0;


  using ForceSchemaDowngradeForTestingCallback = base::OnceCallback<void(bool)>;
  
  virtual void ForceSchemaDowngradeForTesting(const ::url::Origin& origin, ForceSchemaDowngradeForTestingCallback callback) = 0;


  using HasV2SchemaCorruptionForTestingCallback = base::OnceCallback<void(V2SchemaCorruptionStatus)>;
  
  virtual void HasV2SchemaCorruptionForTesting(const ::url::Origin& origin, HasV2SchemaCorruptionForTestingCallback callback) = 0;


  using WriteToIndexedDBForTestingCallback = base::OnceCallback<void()>;
  
  virtual void WriteToIndexedDBForTesting(const ::url::Origin& origin, const std::string& key, const std::string& value, WriteToIndexedDBForTestingCallback callback) = 0;


  using GetBlobCountForTestingCallback = base::OnceCallback<void(int64_t)>;
  
  virtual void GetBlobCountForTesting(const ::url::Origin& origin, GetBlobCountForTestingCallback callback) = 0;


  using GetNextBlobNumberForTestingCallback = base::OnceCallback<void(int64_t)>;
  
  virtual void GetNextBlobNumberForTesting(const ::url::Origin& origin, int64_t database_id, GetNextBlobNumberForTestingCallback callback) = 0;


  using GetPathForBlobForTestingCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  
  virtual void GetPathForBlobForTesting(const ::url::Origin& origin, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) = 0;


  using CompactBackingStoreForTestingCallback = base::OnceCallback<void()>;
  
  virtual void CompactBackingStoreForTesting(const ::url::Origin& origin, CompactBackingStoreForTestingCallback callback) = 0;

  
  virtual void BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) = 0;


  using GetDatabaseKeysForTestingCallback = base::OnceCallback<void(const std::string&, const std::string&)>;
  
  virtual void GetDatabaseKeysForTesting(GetDatabaseKeysForTestingCallback callback) = 0;
};



class  MockFailureInjectorProxy
    : public MockFailureInjector {
 public:
  using InterfaceType = MockFailureInjector;

  explicit MockFailureInjectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FailOperation(FailClass failure_class, FailMethod failure_method, int32_t instance_num, int32_t call_num, FailOperationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  IndexedDBControlTestProxy
    : public IndexedDBControlTest {
 public:
  using InterfaceType = IndexedDBControlTest;

  explicit IndexedDBControlTestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBaseDataPathForTesting(GetBaseDataPathForTestingCallback callback) final;
  
  void GetFilePathForTesting(const ::url::Origin& origin, GetFilePathForTestingCallback callback) final;
  
  void ResetCachesForTesting(ResetCachesForTestingCallback callback) final;
  
  void ForceSchemaDowngradeForTesting(const ::url::Origin& origin, ForceSchemaDowngradeForTestingCallback callback) final;
  
  void HasV2SchemaCorruptionForTesting(const ::url::Origin& origin, HasV2SchemaCorruptionForTestingCallback callback) final;
  
  void WriteToIndexedDBForTesting(const ::url::Origin& origin, const std::string& key, const std::string& value, WriteToIndexedDBForTestingCallback callback) final;
  
  void GetBlobCountForTesting(const ::url::Origin& origin, GetBlobCountForTestingCallback callback) final;
  
  void GetNextBlobNumberForTesting(const ::url::Origin& origin, int64_t database_id, GetNextBlobNumberForTestingCallback callback) final;
  
  void GetPathForBlobForTesting(const ::url::Origin& origin, int64_t database_id, int64_t blob_number, GetPathForBlobForTestingCallback callback) final;
  
  void CompactBackingStoreForTesting(const ::url::Origin& origin, CompactBackingStoreForTestingCallback callback) final;
  
  void BindMockFailureSingletonForTesting(::mojo::PendingReceiver<MockFailureInjector> receiver) final;
  
  void GetDatabaseKeysForTesting(GetDatabaseKeysForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MockFailureInjectorStubDispatch {
 public:
  static bool Accept(MockFailureInjector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MockFailureInjector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MockFailureInjector>>
class MockFailureInjectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MockFailureInjectorStub() {}
  ~MockFailureInjectorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MockFailureInjectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MockFailureInjectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBControlTestStubDispatch {
 public:
  static bool Accept(IndexedDBControlTest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBControlTest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBControlTest>>
class IndexedDBControlTestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBControlTestStub() {}
  ~IndexedDBControlTestStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlTestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlTestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MockFailureInjectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlTestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MockFailureInjectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlTestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_TEST_MOJOM_H_