// components/services/storage/public/mojom/service_worker_database.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {









class  ServiceWorkerRegistrationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRegistrationData, T>::value>;
  using DataView = ServiceWorkerRegistrationDataDataView;
  using Data_ = internal::ServiceWorkerRegistrationData_Data;

  template <typename... Args>
  static ServiceWorkerRegistrationDataPtr New(Args&&... args) {
    return ServiceWorkerRegistrationDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRegistrationDataPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRegistrationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRegistrationData>::Convert(*this);
  }


  ServiceWorkerRegistrationData();

  ServiceWorkerRegistrationData(
      int64_t registration_id,
      const ::GURL& scope,
      const ::GURL& script,
      ::blink::mojom::ScriptType script_type,
      ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache,
      int64_t version_id,
      bool is_active,
      bool has_fetch_handler,
      ::base::Time last_update_check,
      ::base::Time script_response_time,
      const base::Optional<base::flat_map<std::string, std::vector<std::string>>>& origin_trial_tokens,
      ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state,
      std::vector<::blink::mojom::WebFeature> used_features,
      int64_t resources_total_size_bytes,
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy);

  ~ServiceWorkerRegistrationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRegistrationDataPtr>
  ServiceWorkerRegistrationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRegistrationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRegistrationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRegistrationData_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerRegistrationData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRegistrationData_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t registration_id;
  
  ::GURL scope;
  
  ::GURL script;
  
  ::blink::mojom::ScriptType script_type;
  
  ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache;
  
  int64_t version_id;
  
  bool is_active;
  
  bool has_fetch_handler;
  
  ::base::Time last_update_check;
  
  ::base::Time script_response_time;
  
  base::Optional<base::flat_map<std::string, std::vector<std::string>>> origin_trial_tokens;
  
  ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state;
  
  std::vector<::blink::mojom::WebFeature> used_features;
  
  int64_t resources_total_size_bytes;
  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceWorkerResourceRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerResourceRecord, T>::value>;
  using DataView = ServiceWorkerResourceRecordDataView;
  using Data_ = internal::ServiceWorkerResourceRecord_Data;

  template <typename... Args>
  static ServiceWorkerResourceRecordPtr New(Args&&... args) {
    return ServiceWorkerResourceRecordPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerResourceRecordPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerResourceRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerResourceRecord>::Convert(*this);
  }


  ServiceWorkerResourceRecord();

  ServiceWorkerResourceRecord(
      int64_t resource_id,
      const ::GURL& url,
      int64_t size_bytes);

  ~ServiceWorkerResourceRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerResourceRecordPtr>
  ServiceWorkerResourceRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerResourceRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerResourceRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerResourceRecord_UnserializedMessageContext<
            UserType, ServiceWorkerResourceRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerResourceRecord::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerResourceRecord::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerResourceRecord_UnserializedMessageContext<
            UserType, ServiceWorkerResourceRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerResourceRecord::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t resource_id;
  
  ::GURL url;
  
  int64_t size_bytes;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerRegistrationDataPtr ServiceWorkerRegistrationData::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(scope),
      mojo::Clone(script),
      mojo::Clone(script_type),
      mojo::Clone(update_via_cache),
      mojo::Clone(version_id),
      mojo::Clone(is_active),
      mojo::Clone(has_fetch_handler),
      mojo::Clone(last_update_check),
      mojo::Clone(script_response_time),
      mojo::Clone(origin_trial_tokens),
      mojo::Clone(navigation_preload_state),
      mojo::Clone(used_features),
      mojo::Clone(resources_total_size_bytes),
      mojo::Clone(cross_origin_embedder_policy)
  );
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>*>
bool ServiceWorkerRegistrationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->script, other_struct.script))
    return false;
  if (!mojo::Equals(this->script_type, other_struct.script_type))
    return false;
  if (!mojo::Equals(this->update_via_cache, other_struct.update_via_cache))
    return false;
  if (!mojo::Equals(this->version_id, other_struct.version_id))
    return false;
  if (!mojo::Equals(this->is_active, other_struct.is_active))
    return false;
  if (!mojo::Equals(this->has_fetch_handler, other_struct.has_fetch_handler))
    return false;
  if (!mojo::Equals(this->last_update_check, other_struct.last_update_check))
    return false;
  if (!mojo::Equals(this->script_response_time, other_struct.script_response_time))
    return false;
  if (!mojo::Equals(this->origin_trial_tokens, other_struct.origin_trial_tokens))
    return false;
  if (!mojo::Equals(this->navigation_preload_state, other_struct.navigation_preload_state))
    return false;
  if (!mojo::Equals(this->used_features, other_struct.used_features))
    return false;
  if (!mojo::Equals(this->resources_total_size_bytes, other_struct.resources_total_size_bytes))
    return false;
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  return true;
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.registration_id, rhs.registration_id))
    return true;
  if (std::less<>{}(rhs.registration_id, lhs.registration_id))
    return false;
  if (std::less<>{}(lhs.scope, rhs.scope))
    return true;
  if (std::less<>{}(rhs.scope, lhs.scope))
    return false;
  if (std::less<>{}(lhs.script, rhs.script))
    return true;
  if (std::less<>{}(rhs.script, lhs.script))
    return false;
  if (std::less<>{}(lhs.script_type, rhs.script_type))
    return true;
  if (std::less<>{}(rhs.script_type, lhs.script_type))
    return false;
  if (std::less<>{}(lhs.update_via_cache, rhs.update_via_cache))
    return true;
  if (std::less<>{}(rhs.update_via_cache, lhs.update_via_cache))
    return false;
  if (std::less<>{}(lhs.version_id, rhs.version_id))
    return true;
  if (std::less<>{}(rhs.version_id, lhs.version_id))
    return false;
  if (std::less<>{}(lhs.is_active, rhs.is_active))
    return true;
  if (std::less<>{}(rhs.is_active, lhs.is_active))
    return false;
  if (std::less<>{}(lhs.has_fetch_handler, rhs.has_fetch_handler))
    return true;
  if (std::less<>{}(rhs.has_fetch_handler, lhs.has_fetch_handler))
    return false;
  if (std::less<>{}(lhs.last_update_check, rhs.last_update_check))
    return true;
  if (std::less<>{}(rhs.last_update_check, lhs.last_update_check))
    return false;
  if (std::less<>{}(lhs.script_response_time, rhs.script_response_time))
    return true;
  if (std::less<>{}(rhs.script_response_time, lhs.script_response_time))
    return false;
  if (std::less<>{}(lhs.origin_trial_tokens, rhs.origin_trial_tokens))
    return true;
  if (std::less<>{}(rhs.origin_trial_tokens, lhs.origin_trial_tokens))
    return false;
  if (std::less<>{}(lhs.navigation_preload_state, rhs.navigation_preload_state))
    return true;
  if (std::less<>{}(rhs.navigation_preload_state, lhs.navigation_preload_state))
    return false;
  if (std::less<>{}(lhs.used_features, rhs.used_features))
    return true;
  if (std::less<>{}(rhs.used_features, lhs.used_features))
    return false;
  if (std::less<>{}(lhs.resources_total_size_bytes, rhs.resources_total_size_bytes))
    return true;
  if (std::less<>{}(rhs.resources_total_size_bytes, lhs.resources_total_size_bytes))
    return false;
  if (std::less<>{}(lhs.cross_origin_embedder_policy, rhs.cross_origin_embedder_policy))
    return true;
  if (std::less<>{}(rhs.cross_origin_embedder_policy, lhs.cross_origin_embedder_policy))
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerResourceRecordPtr ServiceWorkerResourceRecord::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(url),
      mojo::Clone(size_bytes)
  );
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>*>
bool ServiceWorkerResourceRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size_bytes, other_struct.size_bytes))
    return false;
  return true;
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resource_id, rhs.resource_id))
    return true;
  if (std::less<>{}(rhs.resource_id, lhs.resource_id))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.size_bytes, rhs.size_bytes))
    return true;
  if (std::less<>{}(rhs.size_bytes, lhs.size_bytes))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerRegistrationData::DataView,
                                         ::storage::mojom::ServiceWorkerRegistrationDataPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerRegistrationDataPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::registration_id) registration_id(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->registration_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::scope)& scope(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->scope;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::script)& script(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::script_type) script_type(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script_type;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::update_via_cache) update_via_cache(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->update_via_cache;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::version_id) version_id(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->version_id;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::is_active) is_active(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->is_active;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::has_fetch_handler) has_fetch_handler(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->has_fetch_handler;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::last_update_check)& last_update_check(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->last_update_check;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::script_response_time)& script_response_time(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script_response_time;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::origin_trial_tokens)& origin_trial_tokens(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->origin_trial_tokens;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::navigation_preload_state)& navigation_preload_state(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->navigation_preload_state;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::used_features)& used_features(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->used_features;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::resources_total_size_bytes) resources_total_size_bytes(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->resources_total_size_bytes;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static bool Read(::storage::mojom::ServiceWorkerRegistrationData::DataView input, ::storage::mojom::ServiceWorkerRegistrationDataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerResourceRecord::DataView,
                                         ::storage::mojom::ServiceWorkerResourceRecordPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerResourceRecordPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerResourceRecord::resource_id) resource_id(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->resource_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerResourceRecord::url)& url(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->url;
  }

  static decltype(::storage::mojom::ServiceWorkerResourceRecord::size_bytes) size_bytes(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->size_bytes;
  }

  static bool Read(::storage::mojom::ServiceWorkerResourceRecord::DataView input, ::storage::mojom::ServiceWorkerResourceRecordPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_