// components/services/storage/public/mojom/service_worker_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-forward.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class ServiceWorkerLiveVersionRefProxy;

template <typename ImplRefTraits>
class ServiceWorkerLiveVersionRefStub;

class ServiceWorkerLiveVersionRefRequestValidator;


class  ServiceWorkerLiveVersionRef
    : public ServiceWorkerLiveVersionRefInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerLiveVersionRefInterfaceBase;
  using Proxy_ = ServiceWorkerLiveVersionRefProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerLiveVersionRefStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerLiveVersionRefRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };
  virtual ~ServiceWorkerLiveVersionRef() {}
};

class ServiceWorkerDataPipeStateNotifierProxy;

template <typename ImplRefTraits>
class ServiceWorkerDataPipeStateNotifierStub;

class ServiceWorkerDataPipeStateNotifierRequestValidator;


class  ServiceWorkerDataPipeStateNotifier
    : public ServiceWorkerDataPipeStateNotifierInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerDataPipeStateNotifierInterfaceBase;
  using Proxy_ = ServiceWorkerDataPipeStateNotifierProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerDataPipeStateNotifierStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerDataPipeStateNotifierRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompleteMinVersion = 0,
  };
  virtual ~ServiceWorkerDataPipeStateNotifier() {}

  
  virtual void OnComplete(int32_t status) = 0;
};

class ServiceWorkerResourceReaderProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceReaderStub;

class ServiceWorkerResourceReaderRequestValidator;
class ServiceWorkerResourceReaderResponseValidator;


class  ServiceWorkerResourceReader
    : public ServiceWorkerResourceReaderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerResourceReaderInterfaceBase;
  using Proxy_ = ServiceWorkerResourceReaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceReaderStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceReaderRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceReaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadResponseHeadMinVersion = 0,
    kReadDataMinVersion = 0,
  };
  virtual ~ServiceWorkerResourceReader() {}


  using ReadResponseHeadCallback = base::OnceCallback<void(int32_t, ::network::mojom::URLResponseHeadPtr, base::Optional<::mojo_base::BigBuffer>)>;
  
  virtual void ReadResponseHead(ReadResponseHeadCallback callback) = 0;


  using ReadDataCallback = base::OnceCallback<void(::mojo::ScopedDataPipeConsumerHandle)>;
  
  virtual void ReadData(int64_t size, ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> notifier, ReadDataCallback callback) = 0;
};

class ServiceWorkerResourceWriterProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceWriterStub;

class ServiceWorkerResourceWriterRequestValidator;
class ServiceWorkerResourceWriterResponseValidator;


class  ServiceWorkerResourceWriter
    : public ServiceWorkerResourceWriterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerResourceWriterInterfaceBase;
  using Proxy_ = ServiceWorkerResourceWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceWriterStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceWriterRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteResponseHeadMinVersion = 0,
    kWriteDataMinVersion = 0,
  };
  virtual ~ServiceWorkerResourceWriter() {}


  using WriteResponseHeadCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) = 0;


  using WriteDataCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) = 0;
};

class ServiceWorkerResourceMetadataWriterProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceMetadataWriterStub;

class ServiceWorkerResourceMetadataWriterRequestValidator;
class ServiceWorkerResourceMetadataWriterResponseValidator;


class  ServiceWorkerResourceMetadataWriter
    : public ServiceWorkerResourceMetadataWriterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerResourceMetadataWriterInterfaceBase;
  using Proxy_ = ServiceWorkerResourceMetadataWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceMetadataWriterStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceMetadataWriterRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceMetadataWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteMetadataMinVersion = 0,
  };
  virtual ~ServiceWorkerResourceMetadataWriter() {}


  using WriteMetadataCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) = 0;
};

class ServiceWorkerStorageControlProxy;

template <typename ImplRefTraits>
class ServiceWorkerStorageControlStub;

class ServiceWorkerStorageControlRequestValidator;
class ServiceWorkerStorageControlResponseValidator;


class  ServiceWorkerStorageControl
    : public ServiceWorkerStorageControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerStorageControlInterfaceBase;
  using Proxy_ = ServiceWorkerStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerStorageControlRequestValidator;
  using ResponseValidator_ = ServiceWorkerStorageControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisableMinVersion = 0,
    kDeleteMinVersion = 0,
    kGetRegisteredOriginsMinVersion = 0,
    kFindRegistrationForClientUrlMinVersion = 0,
    kFindRegistrationForScopeMinVersion = 0,
    kFindRegistrationForIdMinVersion = 0,
    kGetRegistrationsForOriginMinVersion = 0,
    kGetUsageForOriginMinVersion = 0,
    kGetAllRegistrationsDeprecatedMinVersion = 0,
    kStoreRegistrationMinVersion = 0,
    kDeleteRegistrationMinVersion = 0,
    kUpdateToActiveStateMinVersion = 0,
    kUpdateLastUpdateCheckTimeMinVersion = 0,
    kUpdateNavigationPreloadEnabledMinVersion = 0,
    kUpdateNavigationPreloadHeaderMinVersion = 0,
    kGetNewRegistrationIdMinVersion = 0,
    kGetNewVersionIdMinVersion = 0,
    kGetNewResourceIdMinVersion = 0,
    kCreateResourceReaderMinVersion = 0,
    kCreateResourceWriterMinVersion = 0,
    kCreateResourceMetadataWriterMinVersion = 0,
    kStoreUncommittedResourceIdMinVersion = 0,
    kDoomUncommittedResourcesMinVersion = 0,
    kGetUserDataMinVersion = 0,
    kStoreUserDataMinVersion = 0,
    kClearUserDataMinVersion = 0,
    kGetUserDataByKeyPrefixMinVersion = 0,
    kGetUserKeysAndDataByKeyPrefixMinVersion = 0,
    kClearUserDataByKeyPrefixesMinVersion = 0,
    kGetUserDataForAllRegistrationsMinVersion = 0,
    kGetUserDataForAllRegistrationsByKeyPrefixMinVersion = 0,
    kClearUserDataForAllRegistrationsByKeyPrefixMinVersion = 0,
    kPerformStorageCleanupMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
  };
  virtual ~ServiceWorkerStorageControl() {}

  
  virtual void Disable() = 0;


  using DeleteCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void Delete(DeleteCallback callback) = 0;


  using GetRegisteredOriginsCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;
  
  virtual void GetRegisteredOrigins(GetRegisteredOriginsCallback callback) = 0;


  using FindRegistrationForClientUrlCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;
  
  virtual void FindRegistrationForClientUrl(const ::GURL& client_url, FindRegistrationForClientUrlCallback callback) = 0;


  using FindRegistrationForScopeCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;
  
  virtual void FindRegistrationForScope(const ::GURL& scope, FindRegistrationForScopeCallback callback) = 0;


  using FindRegistrationForIdCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;
  
  virtual void FindRegistrationForId(int64_t registration_id, const base::Optional<::url::Origin>& origin, FindRegistrationForIdCallback callback) = 0;


  using GetRegistrationsForOriginCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerFindRegistrationResultPtr>)>;
  
  virtual void GetRegistrationsForOrigin(const ::url::Origin& origin, GetRegistrationsForOriginCallback callback) = 0;


  using GetUsageForOriginCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, int64_t)>;
  
  virtual void GetUsageForOrigin(const ::url::Origin& origin, GetUsageForOriginCallback callback) = 0;


  using GetAllRegistrationsDeprecatedCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>)>;
  
  virtual void GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) = 0;


  using StoreRegistrationCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) = 0;


  using DeleteRegistrationCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerStorageOriginState)>;
  
  virtual void DeleteRegistration(int64_t registration_id, const ::GURL& origin, DeleteRegistrationCallback callback) = 0;


  using UpdateToActiveStateCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void UpdateToActiveState(int64_t registration_id, const ::GURL& origin, UpdateToActiveStateCallback callback) = 0;


  using UpdateLastUpdateCheckTimeCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void UpdateLastUpdateCheckTime(int64_t registration_id, const ::GURL& origin, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) = 0;


  using UpdateNavigationPreloadEnabledCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void UpdateNavigationPreloadEnabled(int64_t registration_id, const ::GURL& origin, bool enable, UpdateNavigationPreloadEnabledCallback callback) = 0;


  using UpdateNavigationPreloadHeaderCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void UpdateNavigationPreloadHeader(int64_t registration_id, const ::GURL& origin, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) = 0;


  using GetNewRegistrationIdCallback = base::OnceCallback<void(int64_t)>;
  
  virtual void GetNewRegistrationId(GetNewRegistrationIdCallback callback) = 0;


  using GetNewVersionIdCallback = base::OnceCallback<void(int64_t, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>)>;
  
  virtual void GetNewVersionId(GetNewVersionIdCallback callback) = 0;


  using GetNewResourceIdCallback = base::OnceCallback<void(int64_t)>;
  
  virtual void GetNewResourceId(GetNewResourceIdCallback callback) = 0;

  
  virtual void CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) = 0;

  
  virtual void CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) = 0;

  
  virtual void CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) = 0;


  using StoreUncommittedResourceIdCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void StoreUncommittedResourceId(int64_t resource_id, const ::GURL& origin, StoreUncommittedResourceIdCallback callback) = 0;


  using DoomUncommittedResourcesCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) = 0;


  using GetUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;
  
  virtual void GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) = 0;


  using StoreUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void StoreUserData(int64_t registration_id, const ::url::Origin& origin, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) = 0;


  using ClearUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) = 0;


  using GetUserDataByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;
  
  virtual void GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) = 0;


  using GetUserKeysAndDataByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const base::flat_map<std::string, std::string>&)>;
  
  virtual void GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) = 0;


  using ClearUserDataByKeyPrefixesCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) = 0;


  using GetUserDataForAllRegistrationsCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;
  
  virtual void GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) = 0;


  using GetUserDataForAllRegistrationsByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;
  
  virtual void GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) = 0;


  using ClearUserDataForAllRegistrationsByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  
  virtual void ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) = 0;


  using PerformStorageCleanupCallback = base::OnceCallback<void()>;
  
  virtual void PerformStorageCleanup(PerformStorageCleanupCallback callback) = 0;

  
  virtual void ApplyPolicyUpdates(std::vector<::storage::mojom::LocalStoragePolicyUpdatePtr> policy_updates) = 0;
};



class  ServiceWorkerLiveVersionRefProxy
    : public ServiceWorkerLiveVersionRef {
 public:
  using InterfaceType = ServiceWorkerLiveVersionRef;

  explicit ServiceWorkerLiveVersionRefProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerDataPipeStateNotifierProxy
    : public ServiceWorkerDataPipeStateNotifier {
 public:
  using InterfaceType = ServiceWorkerDataPipeStateNotifier;

  explicit ServiceWorkerDataPipeStateNotifierProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnComplete(int32_t status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceReaderProxy
    : public ServiceWorkerResourceReader {
 public:
  using InterfaceType = ServiceWorkerResourceReader;

  explicit ServiceWorkerResourceReaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadResponseHead(ReadResponseHeadCallback callback) final;
  
  void ReadData(int64_t size, ::mojo::PendingRemote<ServiceWorkerDataPipeStateNotifier> notifier, ReadDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceWriterProxy
    : public ServiceWorkerResourceWriter {
 public:
  using InterfaceType = ServiceWorkerResourceWriter;

  explicit ServiceWorkerResourceWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) final;
  
  void WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceMetadataWriterProxy
    : public ServiceWorkerResourceMetadataWriter {
 public:
  using InterfaceType = ServiceWorkerResourceMetadataWriter;

  explicit ServiceWorkerResourceMetadataWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerStorageControlProxy
    : public ServiceWorkerStorageControl {
 public:
  using InterfaceType = ServiceWorkerStorageControl;

  explicit ServiceWorkerStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Disable() final;
  
  void Delete(DeleteCallback callback) final;
  
  void GetRegisteredOrigins(GetRegisteredOriginsCallback callback) final;
  
  void FindRegistrationForClientUrl(const ::GURL& client_url, FindRegistrationForClientUrlCallback callback) final;
  
  void FindRegistrationForScope(const ::GURL& scope, FindRegistrationForScopeCallback callback) final;
  
  void FindRegistrationForId(int64_t registration_id, const base::Optional<::url::Origin>& origin, FindRegistrationForIdCallback callback) final;
  
  void GetRegistrationsForOrigin(const ::url::Origin& origin, GetRegistrationsForOriginCallback callback) final;
  
  void GetUsageForOrigin(const ::url::Origin& origin, GetUsageForOriginCallback callback) final;
  
  void GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) final;
  
  void StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) final;
  
  void DeleteRegistration(int64_t registration_id, const ::GURL& origin, DeleteRegistrationCallback callback) final;
  
  void UpdateToActiveState(int64_t registration_id, const ::GURL& origin, UpdateToActiveStateCallback callback) final;
  
  void UpdateLastUpdateCheckTime(int64_t registration_id, const ::GURL& origin, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) final;
  
  void UpdateNavigationPreloadEnabled(int64_t registration_id, const ::GURL& origin, bool enable, UpdateNavigationPreloadEnabledCallback callback) final;
  
  void UpdateNavigationPreloadHeader(int64_t registration_id, const ::GURL& origin, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) final;
  
  void GetNewRegistrationId(GetNewRegistrationIdCallback callback) final;
  
  void GetNewVersionId(GetNewVersionIdCallback callback) final;
  
  void GetNewResourceId(GetNewResourceIdCallback callback) final;
  
  void CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) final;
  
  void CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) final;
  
  void CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) final;
  
  void StoreUncommittedResourceId(int64_t resource_id, const ::GURL& origin, StoreUncommittedResourceIdCallback callback) final;
  
  void DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) final;
  
  void GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) final;
  
  void StoreUserData(int64_t registration_id, const ::url::Origin& origin, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) final;
  
  void ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) final;
  
  void GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) final;
  
  void GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) final;
  
  void ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) final;
  
  void GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) final;
  
  void GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) final;
  
  void ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) final;
  
  void PerformStorageCleanup(PerformStorageCleanupCallback callback) final;
  
  void ApplyPolicyUpdates(std::vector<::storage::mojom::LocalStoragePolicyUpdatePtr> policy_updates) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ServiceWorkerLiveVersionRefStubDispatch {
 public:
  static bool Accept(ServiceWorkerLiveVersionRef* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerLiveVersionRef* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerLiveVersionRef>>
class ServiceWorkerLiveVersionRefStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerLiveVersionRefStub() {}
  ~ServiceWorkerLiveVersionRefStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerLiveVersionRefStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerLiveVersionRefStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerDataPipeStateNotifierStubDispatch {
 public:
  static bool Accept(ServiceWorkerDataPipeStateNotifier* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerDataPipeStateNotifier* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerDataPipeStateNotifier>>
class ServiceWorkerDataPipeStateNotifierStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerDataPipeStateNotifierStub() {}
  ~ServiceWorkerDataPipeStateNotifierStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerDataPipeStateNotifierStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerDataPipeStateNotifierStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceReaderStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceReader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceReader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceReader>>
class ServiceWorkerResourceReaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceReaderStub() {}
  ~ServiceWorkerResourceReaderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceReaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceReaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceWriterStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceWriter>>
class ServiceWorkerResourceWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceWriterStub() {}
  ~ServiceWorkerResourceWriterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceMetadataWriterStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceMetadataWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceMetadataWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceMetadataWriter>>
class ServiceWorkerResourceMetadataWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceMetadataWriterStub() {}
  ~ServiceWorkerResourceMetadataWriterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceMetadataWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceMetadataWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerStorageControlStubDispatch {
 public:
  static bool Accept(ServiceWorkerStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerStorageControl>>
class ServiceWorkerStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStorageControlStub() {}
  ~ServiceWorkerStorageControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerLiveVersionRefRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerDataPipeStateNotifierRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceReaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceMetadataWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceReaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceMetadataWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerStorageControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  ServiceWorkerUserData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerUserData, T>::value>;
  using DataView = ServiceWorkerUserDataDataView;
  using Data_ = internal::ServiceWorkerUserData_Data;

  template <typename... Args>
  static ServiceWorkerUserDataPtr New(Args&&... args) {
    return ServiceWorkerUserDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerUserDataPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerUserDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerUserData>::Convert(*this);
  }


  ServiceWorkerUserData();

  ServiceWorkerUserData(
      int64_t registration_id,
      const std::string& key,
      const std::string& value);

  ~ServiceWorkerUserData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerUserDataPtr>
  ServiceWorkerUserDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerUserData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerUserData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerUserData_UnserializedMessageContext<
            UserType, ServiceWorkerUserData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerUserData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerUserData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerUserData_UnserializedMessageContext<
            UserType, ServiceWorkerUserData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerUserData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t registration_id;
  
  std::string key;
  
  std::string value;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ServiceWorkerFindRegistrationResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerFindRegistrationResult, T>::value>;
  using DataView = ServiceWorkerFindRegistrationResultDataView;
  using Data_ = internal::ServiceWorkerFindRegistrationResult_Data;

  template <typename... Args>
  static ServiceWorkerFindRegistrationResultPtr New(Args&&... args) {
    return ServiceWorkerFindRegistrationResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerFindRegistrationResultPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerFindRegistrationResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerFindRegistrationResult>::Convert(*this);
  }


  ServiceWorkerFindRegistrationResult();

  ServiceWorkerFindRegistrationResult(
      ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference,
      ::storage::mojom::ServiceWorkerRegistrationDataPtr registration,
      std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources);

  ~ServiceWorkerFindRegistrationResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerFindRegistrationResultPtr>
  ServiceWorkerFindRegistrationResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerFindRegistrationResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerFindRegistrationResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerFindRegistrationResult_UnserializedMessageContext<
            UserType, ServiceWorkerFindRegistrationResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerFindRegistrationResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerFindRegistrationResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerFindRegistrationResult_UnserializedMessageContext<
            UserType, ServiceWorkerFindRegistrationResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerFindRegistrationResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference;
  
  ::storage::mojom::ServiceWorkerRegistrationDataPtr registration;
  
  std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerFindRegistrationResult);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ServiceWorkerFindRegistrationResultPtr ServiceWorkerFindRegistrationResult::Clone() const {
  return New(
      mojo::Clone(version_reference),
      mojo::Clone(registration),
      mojo::Clone(resources)
  );
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>*>
bool ServiceWorkerFindRegistrationResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version_reference, other_struct.version_reference))
    return false;
  if (!mojo::Equals(this->registration, other_struct.registration))
    return false;
  if (!mojo::Equals(this->resources, other_struct.resources))
    return false;
  return true;
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.version_reference, rhs.version_reference))
    return true;
  if (std::less<>{}(rhs.version_reference, lhs.version_reference))
    return false;
  if (std::less<>{}(lhs.registration, rhs.registration))
    return true;
  if (std::less<>{}(rhs.registration, lhs.registration))
    return false;
  if (std::less<>{}(lhs.resources, rhs.resources))
    return true;
  if (std::less<>{}(rhs.resources, lhs.resources))
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerUserDataPtr ServiceWorkerUserData::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>*>
bool ServiceWorkerUserData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.registration_id, rhs.registration_id))
    return true;
  if (std::less<>{}(rhs.registration_id, lhs.registration_id))
    return false;
  if (std::less<>{}(lhs.key, rhs.key))
    return true;
  if (std::less<>{}(rhs.key, lhs.key))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResult::DataView,
                                         ::storage::mojom::ServiceWorkerFindRegistrationResultPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output) { output->reset(); }

  static  decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::version_reference)& version_reference(
       ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->version_reference;
  }

  static const decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::registration)& registration(
      const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->registration;
  }

  static const decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::resources)& resources(
      const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->resources;
  }

  static bool Read(::storage::mojom::ServiceWorkerFindRegistrationResult::DataView input, ::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerUserData::DataView,
                                         ::storage::mojom::ServiceWorkerUserDataPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerUserDataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerUserDataPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerUserData::registration_id) registration_id(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->registration_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerUserData::key)& key(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->key;
  }

  static const decltype(::storage::mojom::ServiceWorkerUserData::value)& value(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->value;
  }

  static bool Read(::storage::mojom::ServiceWorkerUserData::DataView input, ::storage::mojom::ServiceWorkerUserDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_