// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Browser_h
#define content_protocol_Browser_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Browser {
using BrowserContextID = String;
using PermissionType = String;
using PermissionSetting = String;
class PermissionDescriptor;
class Bucket;
class Histogram;

// ------------- Forward and enum declarations.

namespace PermissionTypeEnum {
CONTENT_EXPORT extern const char AccessibilityEvents[];
CONTENT_EXPORT extern const char AudioCapture[];
CONTENT_EXPORT extern const char BackgroundSync[];
CONTENT_EXPORT extern const char BackgroundFetch[];
CONTENT_EXPORT extern const char ClipboardReadWrite[];
CONTENT_EXPORT extern const char ClipboardSanitizedWrite[];
CONTENT_EXPORT extern const char DurableStorage[];
CONTENT_EXPORT extern const char Flash[];
CONTENT_EXPORT extern const char Geolocation[];
CONTENT_EXPORT extern const char Midi[];
CONTENT_EXPORT extern const char MidiSysex[];
CONTENT_EXPORT extern const char Nfc[];
CONTENT_EXPORT extern const char Notifications[];
CONTENT_EXPORT extern const char PaymentHandler[];
CONTENT_EXPORT extern const char PeriodicBackgroundSync[];
CONTENT_EXPORT extern const char ProtectedMediaIdentifier[];
CONTENT_EXPORT extern const char Sensors[];
CONTENT_EXPORT extern const char VideoCapture[];
CONTENT_EXPORT extern const char IdleDetection[];
CONTENT_EXPORT extern const char WakeLockScreen[];
CONTENT_EXPORT extern const char WakeLockSystem[];
} // namespace PermissionTypeEnum

namespace PermissionSettingEnum {
CONTENT_EXPORT extern const char Granted[];
CONTENT_EXPORT extern const char Denied[];
CONTENT_EXPORT extern const char Prompt[];
} // namespace PermissionSettingEnum

namespace SetDownloadBehavior {
namespace BehaviorEnum {
CONTENT_EXPORT extern const char* Deny;
CONTENT_EXPORT extern const char* Allow;
CONTENT_EXPORT extern const char* AllowAndName;
CONTENT_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

// ------------- Type and builder declarations.

class CONTENT_EXPORT PermissionDescriptor : public ::crdtp::ProtocolObject<PermissionDescriptor> {
public:
    ~PermissionDescriptor() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    bool HasSysex() { return m_sysex.isJust(); }
    bool GetSysex(bool defaultValue) { return m_sysex.isJust() ? m_sysex.fromJust() : defaultValue; }
    void SetSysex(bool value) { m_sysex = value; }

    bool HasUserVisibleOnly() { return m_userVisibleOnly.isJust(); }
    bool GetUserVisibleOnly(bool defaultValue) { return m_userVisibleOnly.isJust() ? m_userVisibleOnly.fromJust() : defaultValue; }
    void SetUserVisibleOnly(bool value) { m_userVisibleOnly = value; }

    bool HasAllowWithoutSanitization() { return m_allowWithoutSanitization.isJust(); }
    bool GetAllowWithoutSanitization(bool defaultValue) { return m_allowWithoutSanitization.isJust() ? m_allowWithoutSanitization.fromJust() : defaultValue; }
    void SetAllowWithoutSanitization(bool value) { m_allowWithoutSanitization = value; }

    template<int STATE>
    class PermissionDescriptorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            AllFieldsSet = (NameSet | 0)};


        PermissionDescriptorBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        PermissionDescriptorBuilder<STATE>& SetSysex(bool value)
        {
            m_result->SetSysex(value);
            return *this;
        }

        PermissionDescriptorBuilder<STATE>& SetUserVisibleOnly(bool value)
        {
            m_result->SetUserVisibleOnly(value);
            return *this;
        }

        PermissionDescriptorBuilder<STATE>& SetAllowWithoutSanitization(bool value)
        {
            m_result->SetAllowWithoutSanitization(value);
            return *this;
        }

        std::unique_ptr<PermissionDescriptor> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PermissionDescriptor;
        PermissionDescriptorBuilder() : m_result(new PermissionDescriptor()) { }

        template<int STEP> PermissionDescriptorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PermissionDescriptorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::PermissionDescriptor> m_result;
    };

    static PermissionDescriptorBuilder<0> Create()
    {
        return PermissionDescriptorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PermissionDescriptor()
    {
    }

    String m_name;
    Maybe<bool> m_sysex;
    Maybe<bool> m_userVisibleOnly;
    Maybe<bool> m_allowWithoutSanitization;
};


class CONTENT_EXPORT Bucket : public ::crdtp::ProtocolObject<Bucket> {
public:
    ~Bucket() override { }

    int GetLow() { return m_low; }
    void SetLow(int value) { m_low = value; }

    int GetHigh() { return m_high; }
    void SetHigh(int value) { m_high = value; }

    int GetCount() { return m_count; }
    void SetCount(int value) { m_count = value; }

    template<int STATE>
    class BucketBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LowSet = 1 << 1,
            HighSet = 1 << 2,
            CountSet = 1 << 3,
            AllFieldsSet = (LowSet | HighSet | CountSet | 0)};


        BucketBuilder<STATE | LowSet>& SetLow(int value)
        {
            static_assert(!(STATE & LowSet), "property low should not be set yet");
            m_result->SetLow(value);
            return castState<LowSet>();
        }

        BucketBuilder<STATE | HighSet>& SetHigh(int value)
        {
            static_assert(!(STATE & HighSet), "property high should not be set yet");
            m_result->SetHigh(value);
            return castState<HighSet>();
        }

        BucketBuilder<STATE | CountSet>& SetCount(int value)
        {
            static_assert(!(STATE & CountSet), "property count should not be set yet");
            m_result->SetCount(value);
            return castState<CountSet>();
        }

        std::unique_ptr<Bucket> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Bucket;
        BucketBuilder() : m_result(new Bucket()) { }

        template<int STEP> BucketBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BucketBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::Bucket> m_result;
    };

    static BucketBuilder<0> Create()
    {
        return BucketBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Bucket()
    {
          m_low = 0;
          m_high = 0;
          m_count = 0;
    }

    int m_low;
    int m_high;
    int m_count;
};


class CONTENT_EXPORT Histogram : public ::crdtp::ProtocolObject<Histogram> {
public:
    ~Histogram() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    int GetSum() { return m_sum; }
    void SetSum(int value) { m_sum = value; }

    int GetCount() { return m_count; }
    void SetCount(int value) { m_count = value; }

    protocol::Array<protocol::Browser::Bucket>* GetBuckets() { return m_buckets.get(); }
    void SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value) { m_buckets = std::move(value); }

    template<int STATE>
    class HistogramBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            SumSet = 1 << 2,
            CountSet = 1 << 3,
            BucketsSet = 1 << 4,
            AllFieldsSet = (NameSet | SumSet | CountSet | BucketsSet | 0)};


        HistogramBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        HistogramBuilder<STATE | SumSet>& SetSum(int value)
        {
            static_assert(!(STATE & SumSet), "property sum should not be set yet");
            m_result->SetSum(value);
            return castState<SumSet>();
        }

        HistogramBuilder<STATE | CountSet>& SetCount(int value)
        {
            static_assert(!(STATE & CountSet), "property count should not be set yet");
            m_result->SetCount(value);
            return castState<CountSet>();
        }

        HistogramBuilder<STATE | BucketsSet>& SetBuckets(std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> value)
        {
            static_assert(!(STATE & BucketsSet), "property buckets should not be set yet");
            m_result->SetBuckets(std::move(value));
            return castState<BucketsSet>();
        }

        std::unique_ptr<Histogram> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Histogram;
        HistogramBuilder() : m_result(new Histogram()) { }

        template<int STEP> HistogramBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HistogramBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::Histogram> m_result;
    };

    static HistogramBuilder<0> Create()
    {
        return HistogramBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Histogram()
    {
          m_sum = 0;
          m_count = 0;
    }

    String m_name;
    int m_sum;
    int m_count;
    std::unique_ptr<protocol::Array<protocol::Browser::Bucket>> m_buckets;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetPermission(std::unique_ptr<protocol::Browser::PermissionDescriptor> in_permission, const String& in_setting, Maybe<String> in_origin, Maybe<String> in_browserContextId) = 0;
    virtual DispatchResponse GrantPermissions(std::unique_ptr<protocol::Array<String>> in_permissions, Maybe<String> in_origin, Maybe<String> in_browserContextId) = 0;
    virtual DispatchResponse ResetPermissions(Maybe<String> in_browserContextId) = 0;
    virtual DispatchResponse SetDownloadBehavior(const String& in_behavior, Maybe<String> in_browserContextId, Maybe<String> in_downloadPath) = 0;
    virtual DispatchResponse Crash() = 0;
    virtual DispatchResponse CrashGpuProcess() = 0;
    virtual DispatchResponse GetVersion(String* out_protocolVersion, String* out_product, String* out_revision, String* out_userAgent, String* out_jsVersion) = 0;
    virtual DispatchResponse GetBrowserCommandLine(std::unique_ptr<protocol::Array<String>>* out_arguments) = 0;
    virtual DispatchResponse GetHistograms(Maybe<String> in_query, Maybe<bool> in_delta, std::unique_ptr<protocol::Array<protocol::Browser::Histogram>>* out_histograms) = 0;
    virtual DispatchResponse GetHistogram(const String& in_name, Maybe<bool> in_delta, std::unique_ptr<protocol::Browser::Histogram>* out_histogram) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Browser
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Browser_h)
