// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/emulation.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Emulation {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Emulation";
const char Metainfo::commandPrefix[] = "Emulation.";
const char Metainfo::version[] = "1.3";


const char* ScreenOrientation::TypeEnum::PortraitPrimary = "portraitPrimary";
const char* ScreenOrientation::TypeEnum::PortraitSecondary = "portraitSecondary";
const char* ScreenOrientation::TypeEnum::LandscapePrimary = "landscapePrimary";
const char* ScreenOrientation::TypeEnum::LandscapeSecondary = "landscapeSecondary";
CRDTP_BEGIN_DESERIALIZER(ScreenOrientation)
    CRDTP_DESERIALIZE_FIELD("angle", m_angle),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScreenOrientation)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("angle", m_angle);
CRDTP_END_SERIALIZER();



const char* DisplayFeature::OrientationEnum::Vertical = "vertical";
const char* DisplayFeature::OrientationEnum::Horizontal = "horizontal";
CRDTP_BEGIN_DESERIALIZER(DisplayFeature)
    CRDTP_DESERIALIZE_FIELD("maskLength", m_maskLength),
    CRDTP_DESERIALIZE_FIELD("offset", m_offset),
    CRDTP_DESERIALIZE_FIELD("orientation", m_orientation),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DisplayFeature)
    CRDTP_SERIALIZE_FIELD("orientation", m_orientation);
    CRDTP_SERIALIZE_FIELD("offset", m_offset);
    CRDTP_SERIALIZE_FIELD("maskLength", m_maskLength);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(UserAgentBrandVersion)
    CRDTP_DESERIALIZE_FIELD("brand", m_brand),
    CRDTP_DESERIALIZE_FIELD("version", m_version),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UserAgentBrandVersion)
    CRDTP_SERIALIZE_FIELD("brand", m_brand);
    CRDTP_SERIALIZE_FIELD("version", m_version);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(UserAgentMetadata)
    CRDTP_DESERIALIZE_FIELD("architecture", m_architecture),
    CRDTP_DESERIALIZE_FIELD("brands", m_brands),
    CRDTP_DESERIALIZE_FIELD("fullVersion", m_fullVersion),
    CRDTP_DESERIALIZE_FIELD("mobile", m_mobile),
    CRDTP_DESERIALIZE_FIELD("model", m_model),
    CRDTP_DESERIALIZE_FIELD("platform", m_platform),
    CRDTP_DESERIALIZE_FIELD("platformVersion", m_platformVersion),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UserAgentMetadata)
    CRDTP_SERIALIZE_FIELD("brands", m_brands);
    CRDTP_SERIALIZE_FIELD("fullVersion", m_fullVersion);
    CRDTP_SERIALIZE_FIELD("platform", m_platform);
    CRDTP_SERIALIZE_FIELD("platformVersion", m_platformVersion);
    CRDTP_SERIALIZE_FIELD("architecture", m_architecture);
    CRDTP_SERIALIZE_FIELD("model", m_model);
    CRDTP_SERIALIZE_FIELD("mobile", m_mobile);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
const char* None = "none";
const char* Achromatopsia = "achromatopsia";
const char* BlurredVision = "blurredVision";
const char* Deuteranopia = "deuteranopia";
const char* Protanopia = "protanopia";
const char* Tritanopia = "tritanopia";
} // namespace TypeEnum
} // namespace SetEmulatedVisionDeficiency

// ------------- Frontend notifications.

void Frontend::VirtualTimeBudgetExpired()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Emulation.virtualTimeBudgetExpired"));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void canEmulate(const crdtp::Dispatchable& dispatchable);
    void clearDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable);
    void clearGeolocationOverride(const crdtp::Dispatchable& dispatchable);
    void setFocusEmulationEnabled(const crdtp::Dispatchable& dispatchable);
    void setDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable);
    void setEmitTouchEventsForMouse(const crdtp::Dispatchable& dispatchable);
    void setGeolocationOverride(const crdtp::Dispatchable& dispatchable);
    void setIdleOverride(const crdtp::Dispatchable& dispatchable);
    void clearIdleOverride(const crdtp::Dispatchable& dispatchable);
    void setVisibleSize(const crdtp::Dispatchable& dispatchable);
    void setUserAgentOverride(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("canEmulate"),
          &DomainDispatcherImpl::canEmulate
    },
    {
          crdtp::SpanFrom("clearDeviceMetricsOverride"),
          &DomainDispatcherImpl::clearDeviceMetricsOverride
    },
    {
          crdtp::SpanFrom("clearGeolocationOverride"),
          &DomainDispatcherImpl::clearGeolocationOverride
    },
    {
          crdtp::SpanFrom("clearIdleOverride"),
          &DomainDispatcherImpl::clearIdleOverride
    },
    {
          crdtp::SpanFrom("setDeviceMetricsOverride"),
          &DomainDispatcherImpl::setDeviceMetricsOverride
    },
    {
          crdtp::SpanFrom("setEmitTouchEventsForMouse"),
          &DomainDispatcherImpl::setEmitTouchEventsForMouse
    },
    {
          crdtp::SpanFrom("setFocusEmulationEnabled"),
          &DomainDispatcherImpl::setFocusEmulationEnabled
    },
    {
          crdtp::SpanFrom("setGeolocationOverride"),
          &DomainDispatcherImpl::setGeolocationOverride
    },
    {
          crdtp::SpanFrom("setIdleOverride"),
          &DomainDispatcherImpl::setIdleOverride
    },
    {
          crdtp::SpanFrom("setUserAgentOverride"),
          &DomainDispatcherImpl::setUserAgentOverride
    },
    {
          crdtp::SpanFrom("setVisibleSize"),
          &DomainDispatcherImpl::setVisibleSize
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::canEmulate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    bool out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->CanEmulate(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.canEmulate"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::clearDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ClearDeviceMetricsOverride();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::clearGeolocationOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ClearGeolocationOverride();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.clearGeolocationOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setFocusEmulationEnabledParams : public crdtp::DeserializableProtocolObject<setFocusEmulationEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFocusEmulationEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFocusEmulationEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFocusEmulationEnabledParams params;
    setFocusEmulationEnabledParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetFocusEmulationEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setFocusEmulationEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDeviceMetricsOverrideParams : public crdtp::DeserializableProtocolObject<setDeviceMetricsOverrideParams> {
    int width;
    int height;
    double deviceScaleFactor;
    bool mobile;
    Maybe<double> scale;
    Maybe<int> screenWidth;
    Maybe<int> screenHeight;
    Maybe<int> positionX;
    Maybe<int> positionY;
    Maybe<bool> dontSetVisibleSize;
    Maybe<protocol::Emulation::ScreenOrientation> screenOrientation;
    Maybe<protocol::Page::Viewport> viewport;
    Maybe<protocol::Emulation::DisplayFeature> displayFeature;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDeviceMetricsOverrideParams)
    CRDTP_DESERIALIZE_FIELD("deviceScaleFactor", deviceScaleFactor),
    CRDTP_DESERIALIZE_FIELD_OPT("displayFeature", displayFeature),
    CRDTP_DESERIALIZE_FIELD_OPT("dontSetVisibleSize", dontSetVisibleSize),
    CRDTP_DESERIALIZE_FIELD("height", height),
    CRDTP_DESERIALIZE_FIELD("mobile", mobile),
    CRDTP_DESERIALIZE_FIELD_OPT("positionX", positionX),
    CRDTP_DESERIALIZE_FIELD_OPT("positionY", positionY),
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
    CRDTP_DESERIALIZE_FIELD_OPT("screenHeight", screenHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("screenOrientation", screenOrientation),
    CRDTP_DESERIALIZE_FIELD_OPT("screenWidth", screenWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("viewport", viewport),
    CRDTP_DESERIALIZE_FIELD("width", width),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDeviceMetricsOverrideParams params;
    setDeviceMetricsOverrideParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetDeviceMetricsOverride(params.width, params.height, params.deviceScaleFactor, params.mobile, std::move(params.scale), std::move(params.screenWidth), std::move(params.screenHeight), std::move(params.positionX), std::move(params.positionY), std::move(params.dontSetVisibleSize), std::move(params.screenOrientation), std::move(params.viewport), std::move(params.displayFeature));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setEmitTouchEventsForMouseParams : public crdtp::DeserializableProtocolObject<setEmitTouchEventsForMouseParams> {
    bool enabled;
    Maybe<String> configuration;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEmitTouchEventsForMouseParams)
    CRDTP_DESERIALIZE_FIELD_OPT("configuration", configuration),
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEmitTouchEventsForMouse(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEmitTouchEventsForMouseParams params;
    setEmitTouchEventsForMouseParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetEmitTouchEventsForMouse(params.enabled, std::move(params.configuration));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setEmitTouchEventsForMouse"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setGeolocationOverrideParams : public crdtp::DeserializableProtocolObject<setGeolocationOverrideParams> {
    Maybe<double> latitude;
    Maybe<double> longitude;
    Maybe<double> accuracy;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setGeolocationOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("accuracy", accuracy),
    CRDTP_DESERIALIZE_FIELD_OPT("latitude", latitude),
    CRDTP_DESERIALIZE_FIELD_OPT("longitude", longitude),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setGeolocationOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setGeolocationOverrideParams params;
    setGeolocationOverrideParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetGeolocationOverride(std::move(params.latitude), std::move(params.longitude), std::move(params.accuracy));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setGeolocationOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setIdleOverrideParams : public crdtp::DeserializableProtocolObject<setIdleOverrideParams> {
    bool isUserActive;
    bool isScreenUnlocked;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setIdleOverrideParams)
    CRDTP_DESERIALIZE_FIELD("isScreenUnlocked", isScreenUnlocked),
    CRDTP_DESERIALIZE_FIELD("isUserActive", isUserActive),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setIdleOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setIdleOverrideParams params;
    setIdleOverrideParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetIdleOverride(params.isUserActive, params.isScreenUnlocked);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setIdleOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::clearIdleOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ClearIdleOverride();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.clearIdleOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setVisibleSizeParams : public crdtp::DeserializableProtocolObject<setVisibleSizeParams> {
    int width;
    int height;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setVisibleSizeParams)
    CRDTP_DESERIALIZE_FIELD("height", height),
    CRDTP_DESERIALIZE_FIELD("width", width),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setVisibleSize(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setVisibleSizeParams params;
    setVisibleSizeParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetVisibleSize(params.width, params.height);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setVisibleSize"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setUserAgentOverrideParams : public crdtp::DeserializableProtocolObject<setUserAgentOverrideParams> {
    String userAgent;
    Maybe<String> acceptLanguage;
    Maybe<String> platform;
    Maybe<protocol::Emulation::UserAgentMetadata> userAgentMetadata;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setUserAgentOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("acceptLanguage", acceptLanguage),
    CRDTP_DESERIALIZE_FIELD_OPT("platform", platform),
    CRDTP_DESERIALIZE_FIELD("userAgent", userAgent),
    CRDTP_DESERIALIZE_FIELD_OPT("userAgentMetadata", userAgentMetadata),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setUserAgentOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setUserAgentOverrideParams params;
    setUserAgentOverrideParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetUserAgentOverride(params.userAgent, std::move(params.acceptLanguage), std::move(params.platform), std::move(params.userAgentMetadata));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setUserAgentOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Emulation"), SortedRedirects(), std::move(dispatcher));
}

} // Emulation
} // namespace content
} // namespace protocol
