// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/page.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Page {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Page";
const char Metainfo::commandPrefix[] = "Page.";
const char Metainfo::version[] = "1.3";


namespace TransitionTypeEnum {
const char Link[] = "link";
const char Typed[] = "typed";
const char Address_bar[] = "address_bar";
const char Auto_bookmark[] = "auto_bookmark";
const char Auto_subframe[] = "auto_subframe";
const char Manual_subframe[] = "manual_subframe";
const char Generated[] = "generated";
const char Auto_toplevel[] = "auto_toplevel";
const char Form_submit[] = "form_submit";
const char Reload[] = "reload";
const char Keyword[] = "keyword";
const char Keyword_generated[] = "keyword_generated";
const char Other[] = "other";
} // namespace TransitionTypeEnum


CRDTP_BEGIN_DESERIALIZER(NavigationEntry)
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("title", m_title),
    CRDTP_DESERIALIZE_FIELD("transitionType", m_transitionType),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
    CRDTP_DESERIALIZE_FIELD("userTypedURL", m_userTypedURL),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NavigationEntry)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("userTypedURL", m_userTypedURL);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("transitionType", m_transitionType);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScreencastFrameMetadata)
    CRDTP_DESERIALIZE_FIELD("deviceHeight", m_deviceHeight),
    CRDTP_DESERIALIZE_FIELD("deviceWidth", m_deviceWidth),
    CRDTP_DESERIALIZE_FIELD("offsetTop", m_offsetTop),
    CRDTP_DESERIALIZE_FIELD("pageScaleFactor", m_pageScaleFactor),
    CRDTP_DESERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX),
    CRDTP_DESERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY),
    CRDTP_DESERIALIZE_FIELD_OPT("timestamp", m_timestamp),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScreencastFrameMetadata)
    CRDTP_SERIALIZE_FIELD("offsetTop", m_offsetTop);
    CRDTP_SERIALIZE_FIELD("pageScaleFactor", m_pageScaleFactor);
    CRDTP_SERIALIZE_FIELD("deviceWidth", m_deviceWidth);
    CRDTP_SERIALIZE_FIELD("deviceHeight", m_deviceHeight);
    CRDTP_SERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX);
    CRDTP_SERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY);
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
CRDTP_END_SERIALIZER();


namespace DialogTypeEnum {
const char Alert[] = "alert";
const char Confirm[] = "confirm";
const char Prompt[] = "prompt";
const char Beforeunload[] = "beforeunload";
} // namespace DialogTypeEnum


CRDTP_BEGIN_DESERIALIZER(AppManifestError)
    CRDTP_DESERIALIZE_FIELD("column", m_column),
    CRDTP_DESERIALIZE_FIELD("critical", m_critical),
    CRDTP_DESERIALIZE_FIELD("line", m_line),
    CRDTP_DESERIALIZE_FIELD("message", m_message),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AppManifestError)
    CRDTP_SERIALIZE_FIELD("message", m_message);
    CRDTP_SERIALIZE_FIELD("critical", m_critical);
    CRDTP_SERIALIZE_FIELD("line", m_line);
    CRDTP_SERIALIZE_FIELD("column", m_column);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AppManifestParsedProperties)
    CRDTP_DESERIALIZE_FIELD("scope", m_scope),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AppManifestParsedProperties)
    CRDTP_SERIALIZE_FIELD("scope", m_scope);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Viewport)
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD("scale", m_scale),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
    CRDTP_DESERIALIZE_FIELD("x", m_x),
    CRDTP_DESERIALIZE_FIELD("y", m_y),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Viewport)
    CRDTP_SERIALIZE_FIELD("x", m_x);
    CRDTP_SERIALIZE_FIELD("y", m_y);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
    CRDTP_SERIALIZE_FIELD("scale", m_scale);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InstallabilityErrorArgument)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InstallabilityErrorArgument)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InstallabilityError)
    CRDTP_DESERIALIZE_FIELD("errorArguments", m_errorArguments),
    CRDTP_DESERIALIZE_FIELD("errorId", m_errorId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InstallabilityError)
    CRDTP_SERIALIZE_FIELD("errorId", m_errorId);
    CRDTP_SERIALIZE_FIELD("errorArguments", m_errorArguments);
CRDTP_END_SERIALIZER();


namespace ReferrerPolicyEnum {
const char NoReferrer[] = "noReferrer";
const char NoReferrerWhenDowngrade[] = "noReferrerWhenDowngrade";
const char Origin[] = "origin";
const char OriginWhenCrossOrigin[] = "originWhenCrossOrigin";
const char SameOrigin[] = "sameOrigin";
const char StrictOrigin[] = "strictOrigin";
const char StrictOriginWhenCrossOrigin[] = "strictOriginWhenCrossOrigin";
const char UnsafeUrl[] = "unsafeUrl";
} // namespace ReferrerPolicyEnum


// ------------- Enum values from params.


namespace CaptureScreenshot {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace FormatEnum
} // namespace CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
const char* Mhtml = "mhtml";
} // namespace FormatEnum
} // namespace CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
const char* ReturnAsBase64 = "ReturnAsBase64";
const char* ReturnAsStream = "ReturnAsStream";
} // namespace TransferModeEnum
} // namespace PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
const char* Deny = "deny";
const char* Allow = "allow";
const char* Default = "default";
} // namespace BehaviorEnum
} // namespace SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace FormatEnum
} // namespace StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
const char* Frozen = "frozen";
const char* Active = "active";
} // namespace StateEnum
} // namespace SetWebLifecycleState

namespace FileChooserOpened {
namespace ModeEnum {
const char* SelectSingle = "selectSingle";
const char* SelectMultiple = "selectMultiple";
} // namespace ModeEnum
} // namespace FileChooserOpened

namespace DownloadProgress {
namespace StateEnum {
const char* InProgress = "inProgress";
const char* Completed = "completed";
const char* Canceled = "canceled";
} // namespace StateEnum
} // namespace DownloadProgress

// ------------- Frontend notifications.

void Frontend::DownloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("suggestedFilename"), suggestedFilename);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadWillBegin", serializer.Finish()));
}

void Frontend::DownloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("totalBytes"), totalBytes);
    serializer.AddField(crdtp::MakeSpan("receivedBytes"), receivedBytes);
    serializer.AddField(crdtp::MakeSpan("state"), state);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadProgress", serializer.Finish()));
}

void Frontend::InterstitialHidden()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.interstitialHidden"));
}

void Frontend::InterstitialShown()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.interstitialShown"));
}

void Frontend::JavascriptDialogClosed(bool result, const String& userInput)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("result"), result);
    serializer.AddField(crdtp::MakeSpan("userInput"), userInput);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.javascriptDialogClosed", serializer.Finish()));
}

void Frontend::JavascriptDialogOpening(const String& url, const String& message, const String& type, bool hasBrowserHandler, Maybe<String> defaultPrompt)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("message"), message);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("hasBrowserHandler"), hasBrowserHandler);
    serializer.AddField(crdtp::MakeSpan("defaultPrompt"), defaultPrompt);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.javascriptDialogOpening", serializer.Finish()));
}

void Frontend::ScreencastFrame(const Binary& data, std::unique_ptr<protocol::Page::ScreencastFrameMetadata> metadata, int sessionId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("data"), data);
    serializer.AddField(crdtp::MakeSpan("metadata"), metadata);
    serializer.AddField(crdtp::MakeSpan("sessionId"), sessionId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.screencastFrame", serializer.Finish()));
}

void Frontend::ScreencastVisibilityChanged(bool visible)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("visible"), visible);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.screencastVisibilityChanged", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void bringToFront(const crdtp::Dispatchable& dispatchable);
    void captureScreenshot(const crdtp::Dispatchable& dispatchable);
    void captureSnapshot(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getAppManifest(const crdtp::Dispatchable& dispatchable);
    void getInstallabilityErrors(const crdtp::Dispatchable& dispatchable);
    void getManifestIcons(const crdtp::Dispatchable& dispatchable);
    void getNavigationHistory(const crdtp::Dispatchable& dispatchable);
    void resetNavigationHistory(const crdtp::Dispatchable& dispatchable);
    void handleJavaScriptDialog(const crdtp::Dispatchable& dispatchable);
    void navigate(const crdtp::Dispatchable& dispatchable);
    void navigateToHistoryEntry(const crdtp::Dispatchable& dispatchable);
    void printToPDF(const crdtp::Dispatchable& dispatchable);
    void reload(const crdtp::Dispatchable& dispatchable);
    void screencastFrameAck(const crdtp::Dispatchable& dispatchable);
    void setDownloadBehavior(const crdtp::Dispatchable& dispatchable);
    void startScreencast(const crdtp::Dispatchable& dispatchable);
    void stopLoading(const crdtp::Dispatchable& dispatchable);
    void crash(const crdtp::Dispatchable& dispatchable);
    void close(const crdtp::Dispatchable& dispatchable);
    void setWebLifecycleState(const crdtp::Dispatchable& dispatchable);
    void stopScreencast(const crdtp::Dispatchable& dispatchable);
    void addCompilationCache(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("addCompilationCache"),
          &DomainDispatcherImpl::addCompilationCache
    },
    {
          crdtp::SpanFrom("bringToFront"),
          &DomainDispatcherImpl::bringToFront
    },
    {
          crdtp::SpanFrom("captureScreenshot"),
          &DomainDispatcherImpl::captureScreenshot
    },
    {
          crdtp::SpanFrom("captureSnapshot"),
          &DomainDispatcherImpl::captureSnapshot
    },
    {
          crdtp::SpanFrom("close"),
          &DomainDispatcherImpl::close
    },
    {
          crdtp::SpanFrom("crash"),
          &DomainDispatcherImpl::crash
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getAppManifest"),
          &DomainDispatcherImpl::getAppManifest
    },
    {
          crdtp::SpanFrom("getInstallabilityErrors"),
          &DomainDispatcherImpl::getInstallabilityErrors
    },
    {
          crdtp::SpanFrom("getManifestIcons"),
          &DomainDispatcherImpl::getManifestIcons
    },
    {
          crdtp::SpanFrom("getNavigationHistory"),
          &DomainDispatcherImpl::getNavigationHistory
    },
    {
          crdtp::SpanFrom("handleJavaScriptDialog"),
          &DomainDispatcherImpl::handleJavaScriptDialog
    },
    {
          crdtp::SpanFrom("navigate"),
          &DomainDispatcherImpl::navigate
    },
    {
          crdtp::SpanFrom("navigateToHistoryEntry"),
          &DomainDispatcherImpl::navigateToHistoryEntry
    },
    {
          crdtp::SpanFrom("printToPDF"),
          &DomainDispatcherImpl::printToPDF
    },
    {
          crdtp::SpanFrom("reload"),
          &DomainDispatcherImpl::reload
    },
    {
          crdtp::SpanFrom("resetNavigationHistory"),
          &DomainDispatcherImpl::resetNavigationHistory
    },
    {
          crdtp::SpanFrom("screencastFrameAck"),
          &DomainDispatcherImpl::screencastFrameAck
    },
    {
          crdtp::SpanFrom("setDownloadBehavior"),
          &DomainDispatcherImpl::setDownloadBehavior
    },
    {
          crdtp::SpanFrom("setWebLifecycleState"),
          &DomainDispatcherImpl::setWebLifecycleState
    },
    {
          crdtp::SpanFrom("startScreencast"),
          &DomainDispatcherImpl::startScreencast
    },
    {
          crdtp::SpanFrom("stopLoading"),
          &DomainDispatcherImpl::stopLoading
    },
    {
          crdtp::SpanFrom("stopScreencast"),
          &DomainDispatcherImpl::stopScreencast
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::bringToFront(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->BringToFront();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.bringToFront"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class CaptureScreenshotCallbackImpl : public Backend::CaptureScreenshotCallback, public DomainDispatcher::Callback {
public:
    CaptureScreenshotCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.captureScreenshot"), message) { }

    void sendSuccess(const Binary& data) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct captureScreenshotParams : public crdtp::DeserializableProtocolObject<captureScreenshotParams> {
    Maybe<String> format;
    Maybe<int> quality;
    Maybe<protocol::Page::Viewport> clip;
    Maybe<bool> fromSurface;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(captureScreenshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("clip", clip),
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
    CRDTP_DESERIALIZE_FIELD_OPT("fromSurface", fromSurface),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::captureScreenshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    captureScreenshotParams params;
    captureScreenshotParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->CaptureScreenshot(std::move(params.format), std::move(params.quality), std::move(params.clip), std::move(params.fromSurface), std::make_unique<CaptureScreenshotCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class CaptureSnapshotCallbackImpl : public Backend::CaptureSnapshotCallback, public DomainDispatcher::Callback {
public:
    CaptureSnapshotCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.captureSnapshot"), message) { }

    void sendSuccess(const String& data) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct captureSnapshotParams : public crdtp::DeserializableProtocolObject<captureSnapshotParams> {
    Maybe<String> format;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(captureSnapshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::captureSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    captureSnapshotParams params;
    captureSnapshotParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->CaptureSnapshot(std::move(params.format), std::make_unique<CaptureSnapshotCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class GetAppManifestCallbackImpl : public Backend::GetAppManifestCallback, public DomainDispatcher::Callback {
public:
    GetAppManifestCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getAppManifest"), message) { }

    void sendSuccess(const String& url, std::unique_ptr<protocol::Array<protocol::Page::AppManifestError>> errors, Maybe<String> data, Maybe<protocol::Page::AppManifestParsedProperties> parsed) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("url"), url);
        serializer.AddField(crdtp::MakeSpan("errors"), errors);
        serializer.AddField(crdtp::MakeSpan("data"), data);
        serializer.AddField(crdtp::MakeSpan("parsed"), parsed);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getAppManifest(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    m_backend->GetAppManifest(std::make_unique<GetAppManifestCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetInstallabilityErrorsCallbackImpl : public Backend::GetInstallabilityErrorsCallback, public DomainDispatcher::Callback {
public:
    GetInstallabilityErrorsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getInstallabilityErrors"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityError>> installabilityErrors) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("installabilityErrors"), installabilityErrors);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getInstallabilityErrors(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    m_backend->GetInstallabilityErrors(std::make_unique<GetInstallabilityErrorsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetManifestIconsCallbackImpl : public Backend::GetManifestIconsCallback, public DomainDispatcher::Callback {
public:
    GetManifestIconsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getManifestIcons"), message) { }

    void sendSuccess(Maybe<Binary> primaryIcon) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("primaryIcon"), primaryIcon);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getManifestIcons(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    m_backend->GetManifestIcons(std::make_unique<GetManifestIconsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::getNavigationHistory(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    int out_currentIndex;
    std::unique_ptr<protocol::Array<protocol::Page::NavigationEntry>> out_entries;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetNavigationHistory(&out_currentIndex, &out_entries);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getNavigationHistory"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("currentIndex"), out_currentIndex);
          serializer.AddField(crdtp::MakeSpan("entries"), out_entries);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::resetNavigationHistory(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ResetNavigationHistory();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.resetNavigationHistory"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct handleJavaScriptDialogParams : public crdtp::DeserializableProtocolObject<handleJavaScriptDialogParams> {
    bool accept;
    Maybe<String> promptText;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(handleJavaScriptDialogParams)
    CRDTP_DESERIALIZE_FIELD("accept", accept),
    CRDTP_DESERIALIZE_FIELD_OPT("promptText", promptText),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::handleJavaScriptDialog(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    handleJavaScriptDialogParams params;
    handleJavaScriptDialogParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->HandleJavaScriptDialog(params.accept, std::move(params.promptText));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.handleJavaScriptDialog"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class NavigateCallbackImpl : public Backend::NavigateCallback, public DomainDispatcher::Callback {
public:
    NavigateCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.navigate"), message) { }

    void sendSuccess(const String& frameId, Maybe<String> loaderId, Maybe<String> errorText) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
        serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
        serializer.AddField(crdtp::MakeSpan("errorText"), errorText);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct navigateParams : public crdtp::DeserializableProtocolObject<navigateParams> {
    String url;
    Maybe<String> referrer;
    Maybe<String> transitionType;
    Maybe<String> frameId;
    Maybe<String> referrerPolicy;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(navigateParams)
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("referrer", referrer),
    CRDTP_DESERIALIZE_FIELD_OPT("referrerPolicy", referrerPolicy),
    CRDTP_DESERIALIZE_FIELD_OPT("transitionType", transitionType),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::navigate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    navigateParams params;
    navigateParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->Navigate(params.url, std::move(params.referrer), std::move(params.transitionType), std::move(params.frameId), std::move(params.referrerPolicy), std::make_unique<NavigateCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct navigateToHistoryEntryParams : public crdtp::DeserializableProtocolObject<navigateToHistoryEntryParams> {
    int entryId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(navigateToHistoryEntryParams)
    CRDTP_DESERIALIZE_FIELD("entryId", entryId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::navigateToHistoryEntry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    navigateToHistoryEntryParams params;
    navigateToHistoryEntryParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->NavigateToHistoryEntry(params.entryId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.navigateToHistoryEntry"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class PrintToPDFCallbackImpl : public Backend::PrintToPDFCallback, public DomainDispatcher::Callback {
public:
    PrintToPDFCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.printToPDF"), message) { }

    void sendSuccess(const Binary& data, Maybe<String> stream) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("data"), data);
        serializer.AddField(crdtp::MakeSpan("stream"), stream);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct printToPDFParams : public crdtp::DeserializableProtocolObject<printToPDFParams> {
    Maybe<bool> landscape;
    Maybe<bool> displayHeaderFooter;
    Maybe<bool> printBackground;
    Maybe<double> scale;
    Maybe<double> paperWidth;
    Maybe<double> paperHeight;
    Maybe<double> marginTop;
    Maybe<double> marginBottom;
    Maybe<double> marginLeft;
    Maybe<double> marginRight;
    Maybe<String> pageRanges;
    Maybe<bool> ignoreInvalidPageRanges;
    Maybe<String> headerTemplate;
    Maybe<String> footerTemplate;
    Maybe<bool> preferCSSPageSize;
    Maybe<String> transferMode;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(printToPDFParams)
    CRDTP_DESERIALIZE_FIELD_OPT("displayHeaderFooter", displayHeaderFooter),
    CRDTP_DESERIALIZE_FIELD_OPT("footerTemplate", footerTemplate),
    CRDTP_DESERIALIZE_FIELD_OPT("headerTemplate", headerTemplate),
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreInvalidPageRanges", ignoreInvalidPageRanges),
    CRDTP_DESERIALIZE_FIELD_OPT("landscape", landscape),
    CRDTP_DESERIALIZE_FIELD_OPT("marginBottom", marginBottom),
    CRDTP_DESERIALIZE_FIELD_OPT("marginLeft", marginLeft),
    CRDTP_DESERIALIZE_FIELD_OPT("marginRight", marginRight),
    CRDTP_DESERIALIZE_FIELD_OPT("marginTop", marginTop),
    CRDTP_DESERIALIZE_FIELD_OPT("pageRanges", pageRanges),
    CRDTP_DESERIALIZE_FIELD_OPT("paperHeight", paperHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("paperWidth", paperWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("preferCSSPageSize", preferCSSPageSize),
    CRDTP_DESERIALIZE_FIELD_OPT("printBackground", printBackground),
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
    CRDTP_DESERIALIZE_FIELD_OPT("transferMode", transferMode),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::printToPDF(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    printToPDFParams params;
    printToPDFParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->PrintToPDF(std::move(params.landscape), std::move(params.displayHeaderFooter), std::move(params.printBackground), std::move(params.scale), std::move(params.paperWidth), std::move(params.paperHeight), std::move(params.marginTop), std::move(params.marginBottom), std::move(params.marginLeft), std::move(params.marginRight), std::move(params.pageRanges), std::move(params.ignoreInvalidPageRanges), std::move(params.headerTemplate), std::move(params.footerTemplate), std::move(params.preferCSSPageSize), std::move(params.transferMode), std::make_unique<PrintToPDFCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class ReloadCallbackImpl : public Backend::ReloadCallback, public DomainDispatcher::Callback {
public:
    ReloadCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.reload"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct reloadParams : public crdtp::DeserializableProtocolObject<reloadParams> {
    Maybe<bool> ignoreCache;
    Maybe<String> scriptToEvaluateOnLoad;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(reloadParams)
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreCache", ignoreCache),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptToEvaluateOnLoad", scriptToEvaluateOnLoad),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::reload(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    reloadParams params;
    reloadParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->Reload(std::move(params.ignoreCache), std::move(params.scriptToEvaluateOnLoad), std::make_unique<ReloadCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct screencastFrameAckParams : public crdtp::DeserializableProtocolObject<screencastFrameAckParams> {
    int sessionId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(screencastFrameAckParams)
    CRDTP_DESERIALIZE_FIELD("sessionId", sessionId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::screencastFrameAck(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    screencastFrameAckParams params;
    screencastFrameAckParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ScreencastFrameAck(params.sessionId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.screencastFrameAck"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDownloadBehaviorParams : public crdtp::DeserializableProtocolObject<setDownloadBehaviorParams> {
    String behavior;
    Maybe<String> downloadPath;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDownloadBehaviorParams)
    CRDTP_DESERIALIZE_FIELD("behavior", behavior),
    CRDTP_DESERIALIZE_FIELD_OPT("downloadPath", downloadPath),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDownloadBehavior(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDownloadBehaviorParams params;
    setDownloadBehaviorParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetDownloadBehavior(params.behavior, std::move(params.downloadPath));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setDownloadBehavior"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct startScreencastParams : public crdtp::DeserializableProtocolObject<startScreencastParams> {
    Maybe<String> format;
    Maybe<int> quality;
    Maybe<int> maxWidth;
    Maybe<int> maxHeight;
    Maybe<int> everyNthFrame;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(startScreencastParams)
    CRDTP_DESERIALIZE_FIELD_OPT("everyNthFrame", everyNthFrame),
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
    CRDTP_DESERIALIZE_FIELD_OPT("maxHeight", maxHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("maxWidth", maxWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::startScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    startScreencastParams params;
    startScreencastParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StartScreencast(std::move(params.format), std::move(params.quality), std::move(params.maxWidth), std::move(params.maxHeight), std::move(params.everyNthFrame));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.startScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopLoading(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StopLoading();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopLoading"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::crash(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Crash();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.crash"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::close(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Close();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.close"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setWebLifecycleStateParams : public crdtp::DeserializableProtocolObject<setWebLifecycleStateParams> {
    String state;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setWebLifecycleStateParams)
    CRDTP_DESERIALIZE_FIELD("state", state),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setWebLifecycleState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setWebLifecycleStateParams params;
    setWebLifecycleStateParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetWebLifecycleState(params.state);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setWebLifecycleState"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StopScreencast();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct addCompilationCacheParams : public crdtp::DeserializableProtocolObject<addCompilationCacheParams> {
    String url;
    Binary data;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addCompilationCacheParams)
    CRDTP_DESERIALIZE_FIELD("data", data),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addCompilationCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addCompilationCacheParams params;
    addCompilationCacheParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->AddCompilationCache(params.url, params.data);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.addCompilationCache"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Page.clearDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.clearDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.clearDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.clearGeolocationOverride"), crdtp::SpanFrom("Emulation.clearGeolocationOverride") },
          { crdtp::SpanFrom("Page.deleteCookie"), crdtp::SpanFrom("Network.deleteCookie") },
          { crdtp::SpanFrom("Page.getCookies"), crdtp::SpanFrom("Network.getCookies") },
          { crdtp::SpanFrom("Page.setDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.setDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.setDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.setGeolocationOverride"), crdtp::SpanFrom("Emulation.setGeolocationOverride") },
          { crdtp::SpanFrom("Page.setTouchEmulationEnabled"), crdtp::SpanFrom("Emulation.setTouchEmulationEnabled") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Page"), SortedRedirects(), std::move(dispatcher));
}

} // Page
} // namespace content
} // namespace protocol
