// content/common/navigation_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/navigation_client.mojom-shared.h"
#include "content/common/navigation_client.mojom-forward.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "content/common/frame_messages.mojom.h"
#include "content/common/navigation_params.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class NavigationClientProxy;

template <typename ImplRefTraits>
class NavigationClientStub;

class NavigationClientRequestValidator;
class NavigationClientResponseValidator;


class CONTENT_EXPORT NavigationClient
    : public NavigationClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NavigationClientInterfaceBase;
  using Proxy_ = NavigationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigationClientStub<ImplRefTraits>;

  using RequestValidator_ = NavigationClientRequestValidator;
  using ResponseValidator_ = NavigationClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitNavigationMinVersion = 0,
    kCommitFailedNavigationMinVersion = 0,
  };
  virtual ~NavigationClient() {}


  using CommitNavigationCallback = base::OnceCallback<void(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;
  
  virtual void CommitNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, base::Optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> prefetch_loader_factory, const ::base::UnguessableToken& devtools_navigation_token, CommitNavigationCallback callback) = 0;


  using CommitFailedNavigationCallback = base::OnceCallback<void(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr)>;
  
  virtual void CommitFailedNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, const ::net::ResolveErrorInfo& resolve_error_info, const base::Optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, CommitFailedNavigationCallback callback) = 0;
};



class CONTENT_EXPORT NavigationClientProxy
    : public NavigationClient {
 public:
  using InterfaceType = NavigationClient;

  explicit NavigationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, ::network::mojom::URLResponseHeadPtr response_head, ::mojo::ScopedDataPipeConsumerHandle response_body, ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, base::Optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> prefetch_loader_factory, const ::base::UnguessableToken& devtools_navigation_token, CommitNavigationCallback callback) final;
  
  void CommitFailedNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, bool has_stale_copy_in_cache, int32_t error_code, const ::net::ResolveErrorInfo& resolve_error_info, const base::Optional<std::string>& error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, CommitFailedNavigationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT NavigationClientStubDispatch {
 public:
  static bool Accept(NavigationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigationClient>>
class NavigationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigationClientStub() {}
  ~NavigationClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT NavigationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT NavigationClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_H_