// content/common/navigation_params.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_H_
#define CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/navigation_params.mojom-shared.h"
#include "content/common/navigation_params.mojom-forward.h"
#include "content/common/prefetched_signed_exchange_info.mojom.h"
#include "content/public/common/was_activated_option.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-forward.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/content_param_traits.h"
#include "content/common/navigation_params.h"
#include "content/public/common/impression.h"
#include "content/public/common/navigation_policy.h"
#include "content/public/common/page_state.h"
#include "third_party/blink/public/platform/web_mixed_content_context_type.h"
#include "ui/base/page_transition_types.h"
#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {



















class CONTENT_EXPORT InitiatorCSPInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InitiatorCSPInfo, T>::value>;
  using DataView = InitiatorCSPInfoDataView;
  using Data_ = internal::InitiatorCSPInfo_Data;

  template <typename... Args>
  static InitiatorCSPInfoPtr New(Args&&... args) {
    return InitiatorCSPInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InitiatorCSPInfoPtr From(const U& u) {
    return mojo::TypeConverter<InitiatorCSPInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InitiatorCSPInfo>::Convert(*this);
  }


  InitiatorCSPInfo();

  InitiatorCSPInfo(
      ::network::mojom::CSPDisposition should_check_main_world_csp,
      std::vector<::network::mojom::ContentSecurityPolicyPtr> initiator_csp,
      ::network::mojom::CSPSourcePtr initiator_self_source);

  ~InitiatorCSPInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InitiatorCSPInfoPtr>
  InitiatorCSPInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InitiatorCSPInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InitiatorCSPInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InitiatorCSPInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InitiatorCSPInfo_UnserializedMessageContext<
            UserType, InitiatorCSPInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<InitiatorCSPInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return InitiatorCSPInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InitiatorCSPInfo_UnserializedMessageContext<
            UserType, InitiatorCSPInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InitiatorCSPInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::CSPDisposition should_check_main_world_csp;
  
  std::vector<::network::mojom::ContentSecurityPolicyPtr> initiator_csp;
  
  ::network::mojom::CSPSourcePtr initiator_self_source;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(InitiatorCSPInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InitiatorCSPInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InitiatorCSPInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InitiatorCSPInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InitiatorCSPInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT BeginNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginNavigationParams, T>::value>;
  using DataView = BeginNavigationParamsDataView;
  using Data_ = internal::BeginNavigationParams_Data;

  template <typename... Args>
  static BeginNavigationParamsPtr New(Args&&... args) {
    return BeginNavigationParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<BeginNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginNavigationParams>::Convert(*this);
  }


  BeginNavigationParams();

  BeginNavigationParams(
      int32_t initiator_routing_id,
      const std::string& headers,
      int32_t load_flags,
      bool skip_service_worker,
      ::blink::mojom::RequestContextType request_context_type,
      ::network::mojom::RequestDestination request_destination,
      ::blink::WebMixedContentContextType mixed_content_context_type,
      bool is_form_submission,
      bool was_initiated_by_link_click,
      const ::GURL& searchable_form_url,
      const std::string& searchable_form_encoding,
      const ::GURL& client_side_redirect_url,
      base::Optional<::base::Value> devtools_initiator,
      bool force_ignore_site_for_cookies,
      ::network::mojom::TrustTokenParamsPtr trust_token_params,
      const base::Optional<::content::Impression>& impression,
      ::base::TimeTicks before_unload_start,
      ::base::TimeTicks before_unload_end);

  ~BeginNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginNavigationParamsPtr>
  BeginNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginNavigationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginNavigationParams_UnserializedMessageContext<
            UserType, BeginNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BeginNavigationParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BeginNavigationParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginNavigationParams_UnserializedMessageContext<
            UserType, BeginNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginNavigationParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t initiator_routing_id;
  
  std::string headers;
  
  int32_t load_flags;
  
  bool skip_service_worker;
  
  ::blink::mojom::RequestContextType request_context_type;
  
  ::network::mojom::RequestDestination request_destination;
  
  ::blink::WebMixedContentContextType mixed_content_context_type;
  
  bool is_form_submission;
  
  bool was_initiated_by_link_click;
  
  ::GURL searchable_form_url;
  
  std::string searchable_form_encoding;
  
  ::GURL client_side_redirect_url;
  
  base::Optional<::base::Value> devtools_initiator;
  
  bool force_ignore_site_for_cookies;
  
  ::network::mojom::TrustTokenParamsPtr trust_token_params;
  
  base::Optional<::content::Impression> impression;
  
  ::base::TimeTicks before_unload_start;
  
  ::base::TimeTicks before_unload_end;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BeginNavigationParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CommonNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommonNavigationParams, T>::value>;
  using DataView = CommonNavigationParamsDataView;
  using Data_ = internal::CommonNavigationParams_Data;

  template <typename... Args>
  static CommonNavigationParamsPtr New(Args&&... args) {
    return CommonNavigationParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommonNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CommonNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommonNavigationParams>::Convert(*this);
  }


  CommonNavigationParams();

  CommonNavigationParams(
      const ::GURL& url,
      const base::Optional<::url::Origin>& initiator_origin,
      ::blink::mojom::ReferrerPtr referrer,
      ::ui::PageTransition transition,
      NavigationType navigation_type,
      const ::content::NavigationDownloadPolicy& download_policy,
      bool should_replace_current_entry,
      const ::GURL& base_url_for_data_url,
      const ::GURL& history_url_for_data_url,
      int32_t previews_state,
      ::base::TimeTicks navigation_start,
      const std::string& method,
      ::scoped_refptr<::network::ResourceRequestBody> post_data,
      ::network::mojom::SourceLocationPtr source_location,
      bool started_from_context_menu,
      bool has_user_gesture,
      bool text_fragment_token,
      InitiatorCSPInfoPtr initiator_csp_info,
      std::vector<int32_t> initiator_origin_trial_features,
      const std::string& href_translate,
      bool is_history_navigation_in_new_child_frame,
      ::base::TimeTicks input_start);

  ~CommonNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommonNavigationParamsPtr>
  CommonNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommonNavigationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommonNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommonNavigationParams_UnserializedMessageContext<
            UserType, CommonNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CommonNavigationParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CommonNavigationParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommonNavigationParams_UnserializedMessageContext<
            UserType, CommonNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommonNavigationParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL url;
  
  base::Optional<::url::Origin> initiator_origin;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::ui::PageTransition transition;
  
  NavigationType navigation_type;
  
  ::content::NavigationDownloadPolicy download_policy;
  
  bool should_replace_current_entry;
  
  ::GURL base_url_for_data_url;
  
  ::GURL history_url_for_data_url;
  
  int32_t previews_state;
  
  ::base::TimeTicks navigation_start;
  
  std::string method;
  
  ::scoped_refptr<::network::ResourceRequestBody> post_data;
  
  ::network::mojom::SourceLocationPtr source_location;
  
  bool started_from_context_menu;
  
  bool has_user_gesture;
  
  bool text_fragment_token;
  
  InitiatorCSPInfoPtr initiator_csp_info;
  
  std::vector<int32_t> initiator_origin_trial_features;
  
  std::string href_translate;
  
  bool is_history_navigation_in_new_child_frame;
  
  ::base::TimeTicks input_start;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CommonNavigationParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT NavigationTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationTiming, T>::value>;
  using DataView = NavigationTimingDataView;
  using Data_ = internal::NavigationTiming_Data;

  template <typename... Args>
  static NavigationTimingPtr New(Args&&... args) {
    return NavigationTimingPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationTimingPtr From(const U& u) {
    return mojo::TypeConverter<NavigationTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationTiming>::Convert(*this);
  }


  NavigationTiming();

  NavigationTiming(
      ::base::TimeTicks redirect_start,
      ::base::TimeTicks redirect_end,
      ::base::TimeTicks fetch_start);

  ~NavigationTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationTimingPtr>
  NavigationTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationTiming_UnserializedMessageContext<
            UserType, NavigationTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NavigationTiming::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NavigationTiming::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationTiming_UnserializedMessageContext<
            UserType, NavigationTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationTiming::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeTicks redirect_start;
  
  ::base::TimeTicks redirect_end;
  
  ::base::TimeTicks fetch_start;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT OldPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OldPageInfo, T>::value>;
  using DataView = OldPageInfoDataView;
  using Data_ = internal::OldPageInfo_Data;

  template <typename... Args>
  static OldPageInfoPtr New(Args&&... args) {
    return OldPageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OldPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<OldPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OldPageInfo>::Convert(*this);
  }


  OldPageInfo();

  OldPageInfo(
      int32_t routing_id_for_old_main_frame,
      ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page);

  ~OldPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OldPageInfoPtr>
  OldPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OldPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OldPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OldPageInfo_UnserializedMessageContext<
            UserType, OldPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<OldPageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return OldPageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OldPageInfo_UnserializedMessageContext<
            UserType, OldPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OldPageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t routing_id_for_old_main_frame;
  
  ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(OldPageInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CommitNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommitNavigationParams, T>::value>;
  using DataView = CommitNavigationParamsDataView;
  using Data_ = internal::CommitNavigationParams_Data;

  template <typename... Args>
  static CommitNavigationParamsPtr New(Args&&... args) {
    return CommitNavigationParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommitNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CommitNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommitNavigationParams>::Convert(*this);
  }


  CommitNavigationParams();

  CommitNavigationParams(
      const base::Optional<::url::Origin>& origin_to_commit,
      bool is_overriding_user_agent,
      std::vector<::GURL> redirects,
      std::vector<::network::mojom::URLResponseHeadPtr> redirect_response,
      std::vector<::net::RedirectInfo> redirect_infos,
      const std::string& post_content_type,
      const ::GURL& original_url,
      const std::string& original_method,
      bool can_load_local_resources,
      const ::content::PageState& page_state,
      int32_t nav_entry_id,
      const base::flat_map<std::string, bool>& subframe_unique_names,
      bool intended_as_new_entry,
      int32_t pending_history_list_offset,
      int32_t current_history_list_offset,
      int32_t current_history_list_length,
      bool was_discarded,
      bool is_view_source,
      bool should_clear_history_list,
      NavigationTimingPtr navigation_timing,
      const base::Optional<::base::UnguessableToken>& appcache_host_id,
      ::content::mojom::WasActivatedOption was_activated,
      const ::base::UnguessableToken& navigation_token,
      std::vector<::content::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges,
      bool is_browser_initiated,
      ::network::mojom::IPAddressSpace ip_address_space,
      const ::GURL& web_bundle_physical_url,
      const ::GURL& web_bundle_claimed_url,
      int64_t document_ukm_source_id,
      const base::Optional<::blink::FramePolicy>& frame_policy,
      std::vector<std::string> force_enabled_origin_trials,
      bool origin_isolated,
      std::vector<::network::mojom::WebClientHintsType> enabled_client_hints,
      bool is_cross_browsing_instance,
      std::vector<std::string> forced_content_security_policies,
      OldPageInfoPtr old_page_info);

  ~CommitNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommitNavigationParamsPtr>
  CommitNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitNavigationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommitNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommitNavigationParams_UnserializedMessageContext<
            UserType, CommitNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CommitNavigationParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CommitNavigationParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommitNavigationParams_UnserializedMessageContext<
            UserType, CommitNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommitNavigationParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::url::Origin> origin_to_commit;
  
  bool is_overriding_user_agent;
  
  std::vector<::GURL> redirects;
  
  std::vector<::network::mojom::URLResponseHeadPtr> redirect_response;
  
  std::vector<::net::RedirectInfo> redirect_infos;
  
  std::string post_content_type;
  
  ::GURL original_url;
  
  std::string original_method;
  
  bool can_load_local_resources;
  
  ::content::PageState page_state;
  
  int32_t nav_entry_id;
  
  base::flat_map<std::string, bool> subframe_unique_names;
  
  bool intended_as_new_entry;
  
  int32_t pending_history_list_offset;
  
  int32_t current_history_list_offset;
  
  int32_t current_history_list_length;
  
  bool was_discarded;
  
  bool is_view_source;
  
  bool should_clear_history_list;
  
  NavigationTimingPtr navigation_timing;
  
  base::Optional<::base::UnguessableToken> appcache_host_id;
  
  ::content::mojom::WasActivatedOption was_activated;
  
  ::base::UnguessableToken navigation_token;
  
  std::vector<::content::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges;
  
  bool is_browser_initiated;
  
  ::network::mojom::IPAddressSpace ip_address_space;
  
  ::GURL web_bundle_physical_url;
  
  ::GURL web_bundle_claimed_url;
  
  int64_t document_ukm_source_id;
  
  base::Optional<::blink::FramePolicy> frame_policy;
  
  std::vector<std::string> force_enabled_origin_trials;
  
  bool origin_isolated;
  
  std::vector<::network::mojom::WebClientHintsType> enabled_client_hints;
  
  bool is_cross_browsing_instance;
  
  std::vector<std::string> forced_content_security_policies;
  
  OldPageInfoPtr old_page_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CommitNavigationParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
InitiatorCSPInfoPtr InitiatorCSPInfo::Clone() const {
  return New(
      mojo::Clone(should_check_main_world_csp),
      mojo::Clone(initiator_csp),
      mojo::Clone(initiator_self_source)
  );
}

template <typename T, InitiatorCSPInfo::EnableIfSame<T>*>
bool InitiatorCSPInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->should_check_main_world_csp, other_struct.should_check_main_world_csp))
    return false;
  if (!mojo::Equals(this->initiator_csp, other_struct.initiator_csp))
    return false;
  if (!mojo::Equals(this->initiator_self_source, other_struct.initiator_self_source))
    return false;
  return true;
}

template <typename T, InitiatorCSPInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.should_check_main_world_csp, rhs.should_check_main_world_csp))
    return true;
  if (std::less<>{}(rhs.should_check_main_world_csp, lhs.should_check_main_world_csp))
    return false;
  if (std::less<>{}(lhs.initiator_csp, rhs.initiator_csp))
    return true;
  if (std::less<>{}(rhs.initiator_csp, lhs.initiator_csp))
    return false;
  if (std::less<>{}(lhs.initiator_self_source, rhs.initiator_self_source))
    return true;
  if (std::less<>{}(rhs.initiator_self_source, lhs.initiator_self_source))
    return false;
  return false;
}
template <typename StructPtrType>
BeginNavigationParamsPtr BeginNavigationParams::Clone() const {
  return New(
      mojo::Clone(initiator_routing_id),
      mojo::Clone(headers),
      mojo::Clone(load_flags),
      mojo::Clone(skip_service_worker),
      mojo::Clone(request_context_type),
      mojo::Clone(request_destination),
      mojo::Clone(mixed_content_context_type),
      mojo::Clone(is_form_submission),
      mojo::Clone(was_initiated_by_link_click),
      mojo::Clone(searchable_form_url),
      mojo::Clone(searchable_form_encoding),
      mojo::Clone(client_side_redirect_url),
      mojo::Clone(devtools_initiator),
      mojo::Clone(force_ignore_site_for_cookies),
      mojo::Clone(trust_token_params),
      mojo::Clone(impression),
      mojo::Clone(before_unload_start),
      mojo::Clone(before_unload_end)
  );
}

template <typename T, BeginNavigationParams::EnableIfSame<T>*>
bool BeginNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->initiator_routing_id, other_struct.initiator_routing_id))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->load_flags, other_struct.load_flags))
    return false;
  if (!mojo::Equals(this->skip_service_worker, other_struct.skip_service_worker))
    return false;
  if (!mojo::Equals(this->request_context_type, other_struct.request_context_type))
    return false;
  if (!mojo::Equals(this->request_destination, other_struct.request_destination))
    return false;
  if (!mojo::Equals(this->mixed_content_context_type, other_struct.mixed_content_context_type))
    return false;
  if (!mojo::Equals(this->is_form_submission, other_struct.is_form_submission))
    return false;
  if (!mojo::Equals(this->was_initiated_by_link_click, other_struct.was_initiated_by_link_click))
    return false;
  if (!mojo::Equals(this->searchable_form_url, other_struct.searchable_form_url))
    return false;
  if (!mojo::Equals(this->searchable_form_encoding, other_struct.searchable_form_encoding))
    return false;
  if (!mojo::Equals(this->client_side_redirect_url, other_struct.client_side_redirect_url))
    return false;
  if (!mojo::Equals(this->devtools_initiator, other_struct.devtools_initiator))
    return false;
  if (!mojo::Equals(this->force_ignore_site_for_cookies, other_struct.force_ignore_site_for_cookies))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->before_unload_start, other_struct.before_unload_start))
    return false;
  if (!mojo::Equals(this->before_unload_end, other_struct.before_unload_end))
    return false;
  return true;
}

template <typename T, BeginNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.initiator_routing_id, rhs.initiator_routing_id))
    return true;
  if (std::less<>{}(rhs.initiator_routing_id, lhs.initiator_routing_id))
    return false;
  if (std::less<>{}(lhs.headers, rhs.headers))
    return true;
  if (std::less<>{}(rhs.headers, lhs.headers))
    return false;
  if (std::less<>{}(lhs.load_flags, rhs.load_flags))
    return true;
  if (std::less<>{}(rhs.load_flags, lhs.load_flags))
    return false;
  if (std::less<>{}(lhs.skip_service_worker, rhs.skip_service_worker))
    return true;
  if (std::less<>{}(rhs.skip_service_worker, lhs.skip_service_worker))
    return false;
  if (std::less<>{}(lhs.request_context_type, rhs.request_context_type))
    return true;
  if (std::less<>{}(rhs.request_context_type, lhs.request_context_type))
    return false;
  if (std::less<>{}(lhs.request_destination, rhs.request_destination))
    return true;
  if (std::less<>{}(rhs.request_destination, lhs.request_destination))
    return false;
  if (std::less<>{}(lhs.mixed_content_context_type, rhs.mixed_content_context_type))
    return true;
  if (std::less<>{}(rhs.mixed_content_context_type, lhs.mixed_content_context_type))
    return false;
  if (std::less<>{}(lhs.is_form_submission, rhs.is_form_submission))
    return true;
  if (std::less<>{}(rhs.is_form_submission, lhs.is_form_submission))
    return false;
  if (std::less<>{}(lhs.was_initiated_by_link_click, rhs.was_initiated_by_link_click))
    return true;
  if (std::less<>{}(rhs.was_initiated_by_link_click, lhs.was_initiated_by_link_click))
    return false;
  if (std::less<>{}(lhs.searchable_form_url, rhs.searchable_form_url))
    return true;
  if (std::less<>{}(rhs.searchable_form_url, lhs.searchable_form_url))
    return false;
  if (std::less<>{}(lhs.searchable_form_encoding, rhs.searchable_form_encoding))
    return true;
  if (std::less<>{}(rhs.searchable_form_encoding, lhs.searchable_form_encoding))
    return false;
  if (std::less<>{}(lhs.client_side_redirect_url, rhs.client_side_redirect_url))
    return true;
  if (std::less<>{}(rhs.client_side_redirect_url, lhs.client_side_redirect_url))
    return false;
  if (std::less<>{}(lhs.devtools_initiator, rhs.devtools_initiator))
    return true;
  if (std::less<>{}(rhs.devtools_initiator, lhs.devtools_initiator))
    return false;
  if (std::less<>{}(lhs.force_ignore_site_for_cookies, rhs.force_ignore_site_for_cookies))
    return true;
  if (std::less<>{}(rhs.force_ignore_site_for_cookies, lhs.force_ignore_site_for_cookies))
    return false;
  if (std::less<>{}(lhs.trust_token_params, rhs.trust_token_params))
    return true;
  if (std::less<>{}(rhs.trust_token_params, lhs.trust_token_params))
    return false;
  if (std::less<>{}(lhs.impression, rhs.impression))
    return true;
  if (std::less<>{}(rhs.impression, lhs.impression))
    return false;
  if (std::less<>{}(lhs.before_unload_start, rhs.before_unload_start))
    return true;
  if (std::less<>{}(rhs.before_unload_start, lhs.before_unload_start))
    return false;
  if (std::less<>{}(lhs.before_unload_end, rhs.before_unload_end))
    return true;
  if (std::less<>{}(rhs.before_unload_end, lhs.before_unload_end))
    return false;
  return false;
}
template <typename StructPtrType>
CommonNavigationParamsPtr CommonNavigationParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(initiator_origin),
      mojo::Clone(referrer),
      mojo::Clone(transition),
      mojo::Clone(navigation_type),
      mojo::Clone(download_policy),
      mojo::Clone(should_replace_current_entry),
      mojo::Clone(base_url_for_data_url),
      mojo::Clone(history_url_for_data_url),
      mojo::Clone(previews_state),
      mojo::Clone(navigation_start),
      mojo::Clone(method),
      mojo::Clone(post_data),
      mojo::Clone(source_location),
      mojo::Clone(started_from_context_menu),
      mojo::Clone(has_user_gesture),
      mojo::Clone(text_fragment_token),
      mojo::Clone(initiator_csp_info),
      mojo::Clone(initiator_origin_trial_features),
      mojo::Clone(href_translate),
      mojo::Clone(is_history_navigation_in_new_child_frame),
      mojo::Clone(input_start)
  );
}

template <typename T, CommonNavigationParams::EnableIfSame<T>*>
bool CommonNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->transition, other_struct.transition))
    return false;
  if (!mojo::Equals(this->navigation_type, other_struct.navigation_type))
    return false;
  if (!mojo::Equals(this->download_policy, other_struct.download_policy))
    return false;
  if (!mojo::Equals(this->should_replace_current_entry, other_struct.should_replace_current_entry))
    return false;
  if (!mojo::Equals(this->base_url_for_data_url, other_struct.base_url_for_data_url))
    return false;
  if (!mojo::Equals(this->history_url_for_data_url, other_struct.history_url_for_data_url))
    return false;
  if (!mojo::Equals(this->previews_state, other_struct.previews_state))
    return false;
  if (!mojo::Equals(this->navigation_start, other_struct.navigation_start))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->post_data, other_struct.post_data))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  if (!mojo::Equals(this->started_from_context_menu, other_struct.started_from_context_menu))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->text_fragment_token, other_struct.text_fragment_token))
    return false;
  if (!mojo::Equals(this->initiator_csp_info, other_struct.initiator_csp_info))
    return false;
  if (!mojo::Equals(this->initiator_origin_trial_features, other_struct.initiator_origin_trial_features))
    return false;
  if (!mojo::Equals(this->href_translate, other_struct.href_translate))
    return false;
  if (!mojo::Equals(this->is_history_navigation_in_new_child_frame, other_struct.is_history_navigation_in_new_child_frame))
    return false;
  if (!mojo::Equals(this->input_start, other_struct.input_start))
    return false;
  return true;
}

template <typename T, CommonNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.initiator_origin, rhs.initiator_origin))
    return true;
  if (std::less<>{}(rhs.initiator_origin, lhs.initiator_origin))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.transition, rhs.transition))
    return true;
  if (std::less<>{}(rhs.transition, lhs.transition))
    return false;
  if (std::less<>{}(lhs.navigation_type, rhs.navigation_type))
    return true;
  if (std::less<>{}(rhs.navigation_type, lhs.navigation_type))
    return false;
  if (std::less<>{}(lhs.download_policy, rhs.download_policy))
    return true;
  if (std::less<>{}(rhs.download_policy, lhs.download_policy))
    return false;
  if (std::less<>{}(lhs.should_replace_current_entry, rhs.should_replace_current_entry))
    return true;
  if (std::less<>{}(rhs.should_replace_current_entry, lhs.should_replace_current_entry))
    return false;
  if (std::less<>{}(lhs.base_url_for_data_url, rhs.base_url_for_data_url))
    return true;
  if (std::less<>{}(rhs.base_url_for_data_url, lhs.base_url_for_data_url))
    return false;
  if (std::less<>{}(lhs.history_url_for_data_url, rhs.history_url_for_data_url))
    return true;
  if (std::less<>{}(rhs.history_url_for_data_url, lhs.history_url_for_data_url))
    return false;
  if (std::less<>{}(lhs.previews_state, rhs.previews_state))
    return true;
  if (std::less<>{}(rhs.previews_state, lhs.previews_state))
    return false;
  if (std::less<>{}(lhs.navigation_start, rhs.navigation_start))
    return true;
  if (std::less<>{}(rhs.navigation_start, lhs.navigation_start))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.post_data, rhs.post_data))
    return true;
  if (std::less<>{}(rhs.post_data, lhs.post_data))
    return false;
  if (std::less<>{}(lhs.source_location, rhs.source_location))
    return true;
  if (std::less<>{}(rhs.source_location, lhs.source_location))
    return false;
  if (std::less<>{}(lhs.started_from_context_menu, rhs.started_from_context_menu))
    return true;
  if (std::less<>{}(rhs.started_from_context_menu, lhs.started_from_context_menu))
    return false;
  if (std::less<>{}(lhs.has_user_gesture, rhs.has_user_gesture))
    return true;
  if (std::less<>{}(rhs.has_user_gesture, lhs.has_user_gesture))
    return false;
  if (std::less<>{}(lhs.text_fragment_token, rhs.text_fragment_token))
    return true;
  if (std::less<>{}(rhs.text_fragment_token, lhs.text_fragment_token))
    return false;
  if (std::less<>{}(lhs.initiator_csp_info, rhs.initiator_csp_info))
    return true;
  if (std::less<>{}(rhs.initiator_csp_info, lhs.initiator_csp_info))
    return false;
  if (std::less<>{}(lhs.initiator_origin_trial_features, rhs.initiator_origin_trial_features))
    return true;
  if (std::less<>{}(rhs.initiator_origin_trial_features, lhs.initiator_origin_trial_features))
    return false;
  if (std::less<>{}(lhs.href_translate, rhs.href_translate))
    return true;
  if (std::less<>{}(rhs.href_translate, lhs.href_translate))
    return false;
  if (std::less<>{}(lhs.is_history_navigation_in_new_child_frame, rhs.is_history_navigation_in_new_child_frame))
    return true;
  if (std::less<>{}(rhs.is_history_navigation_in_new_child_frame, lhs.is_history_navigation_in_new_child_frame))
    return false;
  if (std::less<>{}(lhs.input_start, rhs.input_start))
    return true;
  if (std::less<>{}(rhs.input_start, lhs.input_start))
    return false;
  return false;
}
template <typename StructPtrType>
NavigationTimingPtr NavigationTiming::Clone() const {
  return New(
      mojo::Clone(redirect_start),
      mojo::Clone(redirect_end),
      mojo::Clone(fetch_start)
  );
}

template <typename T, NavigationTiming::EnableIfSame<T>*>
bool NavigationTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->redirect_start, other_struct.redirect_start))
    return false;
  if (!mojo::Equals(this->redirect_end, other_struct.redirect_end))
    return false;
  if (!mojo::Equals(this->fetch_start, other_struct.fetch_start))
    return false;
  return true;
}

template <typename T, NavigationTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.redirect_start, rhs.redirect_start))
    return true;
  if (std::less<>{}(rhs.redirect_start, lhs.redirect_start))
    return false;
  if (std::less<>{}(lhs.redirect_end, rhs.redirect_end))
    return true;
  if (std::less<>{}(rhs.redirect_end, lhs.redirect_end))
    return false;
  if (std::less<>{}(lhs.fetch_start, rhs.fetch_start))
    return true;
  if (std::less<>{}(rhs.fetch_start, lhs.fetch_start))
    return false;
  return false;
}
template <typename StructPtrType>
OldPageInfoPtr OldPageInfo::Clone() const {
  return New(
      mojo::Clone(routing_id_for_old_main_frame),
      mojo::Clone(new_lifecycle_state_for_old_page)
  );
}

template <typename T, OldPageInfo::EnableIfSame<T>*>
bool OldPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id_for_old_main_frame, other_struct.routing_id_for_old_main_frame))
    return false;
  if (!mojo::Equals(this->new_lifecycle_state_for_old_page, other_struct.new_lifecycle_state_for_old_page))
    return false;
  return true;
}

template <typename T, OldPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.routing_id_for_old_main_frame, rhs.routing_id_for_old_main_frame))
    return true;
  if (std::less<>{}(rhs.routing_id_for_old_main_frame, lhs.routing_id_for_old_main_frame))
    return false;
  if (std::less<>{}(lhs.new_lifecycle_state_for_old_page, rhs.new_lifecycle_state_for_old_page))
    return true;
  if (std::less<>{}(rhs.new_lifecycle_state_for_old_page, lhs.new_lifecycle_state_for_old_page))
    return false;
  return false;
}
template <typename StructPtrType>
CommitNavigationParamsPtr CommitNavigationParams::Clone() const {
  return New(
      mojo::Clone(origin_to_commit),
      mojo::Clone(is_overriding_user_agent),
      mojo::Clone(redirects),
      mojo::Clone(redirect_response),
      mojo::Clone(redirect_infos),
      mojo::Clone(post_content_type),
      mojo::Clone(original_url),
      mojo::Clone(original_method),
      mojo::Clone(can_load_local_resources),
      mojo::Clone(page_state),
      mojo::Clone(nav_entry_id),
      mojo::Clone(subframe_unique_names),
      mojo::Clone(intended_as_new_entry),
      mojo::Clone(pending_history_list_offset),
      mojo::Clone(current_history_list_offset),
      mojo::Clone(current_history_list_length),
      mojo::Clone(was_discarded),
      mojo::Clone(is_view_source),
      mojo::Clone(should_clear_history_list),
      mojo::Clone(navigation_timing),
      mojo::Clone(appcache_host_id),
      mojo::Clone(was_activated),
      mojo::Clone(navigation_token),
      mojo::Clone(prefetched_signed_exchanges),
      mojo::Clone(is_browser_initiated),
      mojo::Clone(ip_address_space),
      mojo::Clone(web_bundle_physical_url),
      mojo::Clone(web_bundle_claimed_url),
      mojo::Clone(document_ukm_source_id),
      mojo::Clone(frame_policy),
      mojo::Clone(force_enabled_origin_trials),
      mojo::Clone(origin_isolated),
      mojo::Clone(enabled_client_hints),
      mojo::Clone(is_cross_browsing_instance),
      mojo::Clone(forced_content_security_policies),
      mojo::Clone(old_page_info)
  );
}

template <typename T, CommitNavigationParams::EnableIfSame<T>*>
bool CommitNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin_to_commit, other_struct.origin_to_commit))
    return false;
  if (!mojo::Equals(this->is_overriding_user_agent, other_struct.is_overriding_user_agent))
    return false;
  if (!mojo::Equals(this->redirects, other_struct.redirects))
    return false;
  if (!mojo::Equals(this->redirect_response, other_struct.redirect_response))
    return false;
  if (!mojo::Equals(this->redirect_infos, other_struct.redirect_infos))
    return false;
  if (!mojo::Equals(this->post_content_type, other_struct.post_content_type))
    return false;
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->original_method, other_struct.original_method))
    return false;
  if (!mojo::Equals(this->can_load_local_resources, other_struct.can_load_local_resources))
    return false;
  if (!mojo::Equals(this->page_state, other_struct.page_state))
    return false;
  if (!mojo::Equals(this->nav_entry_id, other_struct.nav_entry_id))
    return false;
  if (!mojo::Equals(this->subframe_unique_names, other_struct.subframe_unique_names))
    return false;
  if (!mojo::Equals(this->intended_as_new_entry, other_struct.intended_as_new_entry))
    return false;
  if (!mojo::Equals(this->pending_history_list_offset, other_struct.pending_history_list_offset))
    return false;
  if (!mojo::Equals(this->current_history_list_offset, other_struct.current_history_list_offset))
    return false;
  if (!mojo::Equals(this->current_history_list_length, other_struct.current_history_list_length))
    return false;
  if (!mojo::Equals(this->was_discarded, other_struct.was_discarded))
    return false;
  if (!mojo::Equals(this->is_view_source, other_struct.is_view_source))
    return false;
  if (!mojo::Equals(this->should_clear_history_list, other_struct.should_clear_history_list))
    return false;
  if (!mojo::Equals(this->navigation_timing, other_struct.navigation_timing))
    return false;
  if (!mojo::Equals(this->appcache_host_id, other_struct.appcache_host_id))
    return false;
  if (!mojo::Equals(this->was_activated, other_struct.was_activated))
    return false;
  if (!mojo::Equals(this->navigation_token, other_struct.navigation_token))
    return false;
  if (!mojo::Equals(this->prefetched_signed_exchanges, other_struct.prefetched_signed_exchanges))
    return false;
  if (!mojo::Equals(this->is_browser_initiated, other_struct.is_browser_initiated))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  if (!mojo::Equals(this->web_bundle_physical_url, other_struct.web_bundle_physical_url))
    return false;
  if (!mojo::Equals(this->web_bundle_claimed_url, other_struct.web_bundle_claimed_url))
    return false;
  if (!mojo::Equals(this->document_ukm_source_id, other_struct.document_ukm_source_id))
    return false;
  if (!mojo::Equals(this->frame_policy, other_struct.frame_policy))
    return false;
  if (!mojo::Equals(this->force_enabled_origin_trials, other_struct.force_enabled_origin_trials))
    return false;
  if (!mojo::Equals(this->origin_isolated, other_struct.origin_isolated))
    return false;
  if (!mojo::Equals(this->enabled_client_hints, other_struct.enabled_client_hints))
    return false;
  if (!mojo::Equals(this->is_cross_browsing_instance, other_struct.is_cross_browsing_instance))
    return false;
  if (!mojo::Equals(this->forced_content_security_policies, other_struct.forced_content_security_policies))
    return false;
  if (!mojo::Equals(this->old_page_info, other_struct.old_page_info))
    return false;
  return true;
}

template <typename T, CommitNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin_to_commit, rhs.origin_to_commit))
    return true;
  if (std::less<>{}(rhs.origin_to_commit, lhs.origin_to_commit))
    return false;
  if (std::less<>{}(lhs.is_overriding_user_agent, rhs.is_overriding_user_agent))
    return true;
  if (std::less<>{}(rhs.is_overriding_user_agent, lhs.is_overriding_user_agent))
    return false;
  if (std::less<>{}(lhs.redirects, rhs.redirects))
    return true;
  if (std::less<>{}(rhs.redirects, lhs.redirects))
    return false;
  if (std::less<>{}(lhs.redirect_response, rhs.redirect_response))
    return true;
  if (std::less<>{}(rhs.redirect_response, lhs.redirect_response))
    return false;
  if (std::less<>{}(lhs.redirect_infos, rhs.redirect_infos))
    return true;
  if (std::less<>{}(rhs.redirect_infos, lhs.redirect_infos))
    return false;
  if (std::less<>{}(lhs.post_content_type, rhs.post_content_type))
    return true;
  if (std::less<>{}(rhs.post_content_type, lhs.post_content_type))
    return false;
  if (std::less<>{}(lhs.original_url, rhs.original_url))
    return true;
  if (std::less<>{}(rhs.original_url, lhs.original_url))
    return false;
  if (std::less<>{}(lhs.original_method, rhs.original_method))
    return true;
  if (std::less<>{}(rhs.original_method, lhs.original_method))
    return false;
  if (std::less<>{}(lhs.can_load_local_resources, rhs.can_load_local_resources))
    return true;
  if (std::less<>{}(rhs.can_load_local_resources, lhs.can_load_local_resources))
    return false;
  if (std::less<>{}(lhs.page_state, rhs.page_state))
    return true;
  if (std::less<>{}(rhs.page_state, lhs.page_state))
    return false;
  if (std::less<>{}(lhs.nav_entry_id, rhs.nav_entry_id))
    return true;
  if (std::less<>{}(rhs.nav_entry_id, lhs.nav_entry_id))
    return false;
  if (std::less<>{}(lhs.subframe_unique_names, rhs.subframe_unique_names))
    return true;
  if (std::less<>{}(rhs.subframe_unique_names, lhs.subframe_unique_names))
    return false;
  if (std::less<>{}(lhs.intended_as_new_entry, rhs.intended_as_new_entry))
    return true;
  if (std::less<>{}(rhs.intended_as_new_entry, lhs.intended_as_new_entry))
    return false;
  if (std::less<>{}(lhs.pending_history_list_offset, rhs.pending_history_list_offset))
    return true;
  if (std::less<>{}(rhs.pending_history_list_offset, lhs.pending_history_list_offset))
    return false;
  if (std::less<>{}(lhs.current_history_list_offset, rhs.current_history_list_offset))
    return true;
  if (std::less<>{}(rhs.current_history_list_offset, lhs.current_history_list_offset))
    return false;
  if (std::less<>{}(lhs.current_history_list_length, rhs.current_history_list_length))
    return true;
  if (std::less<>{}(rhs.current_history_list_length, lhs.current_history_list_length))
    return false;
  if (std::less<>{}(lhs.was_discarded, rhs.was_discarded))
    return true;
  if (std::less<>{}(rhs.was_discarded, lhs.was_discarded))
    return false;
  if (std::less<>{}(lhs.is_view_source, rhs.is_view_source))
    return true;
  if (std::less<>{}(rhs.is_view_source, lhs.is_view_source))
    return false;
  if (std::less<>{}(lhs.should_clear_history_list, rhs.should_clear_history_list))
    return true;
  if (std::less<>{}(rhs.should_clear_history_list, lhs.should_clear_history_list))
    return false;
  if (std::less<>{}(lhs.navigation_timing, rhs.navigation_timing))
    return true;
  if (std::less<>{}(rhs.navigation_timing, lhs.navigation_timing))
    return false;
  if (std::less<>{}(lhs.appcache_host_id, rhs.appcache_host_id))
    return true;
  if (std::less<>{}(rhs.appcache_host_id, lhs.appcache_host_id))
    return false;
  if (std::less<>{}(lhs.was_activated, rhs.was_activated))
    return true;
  if (std::less<>{}(rhs.was_activated, lhs.was_activated))
    return false;
  if (std::less<>{}(lhs.navigation_token, rhs.navigation_token))
    return true;
  if (std::less<>{}(rhs.navigation_token, lhs.navigation_token))
    return false;
  if (std::less<>{}(lhs.prefetched_signed_exchanges, rhs.prefetched_signed_exchanges))
    return true;
  if (std::less<>{}(rhs.prefetched_signed_exchanges, lhs.prefetched_signed_exchanges))
    return false;
  if (std::less<>{}(lhs.is_browser_initiated, rhs.is_browser_initiated))
    return true;
  if (std::less<>{}(rhs.is_browser_initiated, lhs.is_browser_initiated))
    return false;
  if (std::less<>{}(lhs.ip_address_space, rhs.ip_address_space))
    return true;
  if (std::less<>{}(rhs.ip_address_space, lhs.ip_address_space))
    return false;
  if (std::less<>{}(lhs.web_bundle_physical_url, rhs.web_bundle_physical_url))
    return true;
  if (std::less<>{}(rhs.web_bundle_physical_url, lhs.web_bundle_physical_url))
    return false;
  if (std::less<>{}(lhs.web_bundle_claimed_url, rhs.web_bundle_claimed_url))
    return true;
  if (std::less<>{}(rhs.web_bundle_claimed_url, lhs.web_bundle_claimed_url))
    return false;
  if (std::less<>{}(lhs.document_ukm_source_id, rhs.document_ukm_source_id))
    return true;
  if (std::less<>{}(rhs.document_ukm_source_id, lhs.document_ukm_source_id))
    return false;
  if (std::less<>{}(lhs.frame_policy, rhs.frame_policy))
    return true;
  if (std::less<>{}(rhs.frame_policy, lhs.frame_policy))
    return false;
  if (std::less<>{}(lhs.force_enabled_origin_trials, rhs.force_enabled_origin_trials))
    return true;
  if (std::less<>{}(rhs.force_enabled_origin_trials, lhs.force_enabled_origin_trials))
    return false;
  if (std::less<>{}(lhs.origin_isolated, rhs.origin_isolated))
    return true;
  if (std::less<>{}(rhs.origin_isolated, lhs.origin_isolated))
    return false;
  if (std::less<>{}(lhs.enabled_client_hints, rhs.enabled_client_hints))
    return true;
  if (std::less<>{}(rhs.enabled_client_hints, lhs.enabled_client_hints))
    return false;
  if (std::less<>{}(lhs.is_cross_browsing_instance, rhs.is_cross_browsing_instance))
    return true;
  if (std::less<>{}(rhs.is_cross_browsing_instance, lhs.is_cross_browsing_instance))
    return false;
  if (std::less<>{}(lhs.forced_content_security_policies, rhs.forced_content_security_policies))
    return true;
  if (std::less<>{}(rhs.forced_content_security_policies, lhs.forced_content_security_policies))
    return false;
  if (std::less<>{}(lhs.old_page_info, rhs.old_page_info))
    return true;
  if (std::less<>{}(rhs.old_page_info, lhs.old_page_info))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::InitiatorCSPInfo::DataView,
                                         ::content::mojom::InitiatorCSPInfoPtr> {
  static bool IsNull(const ::content::mojom::InitiatorCSPInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::InitiatorCSPInfoPtr* output) { output->reset(); }

  static decltype(::content::mojom::InitiatorCSPInfo::should_check_main_world_csp) should_check_main_world_csp(
      const ::content::mojom::InitiatorCSPInfoPtr& input) {
    return input->should_check_main_world_csp;
  }

  static const decltype(::content::mojom::InitiatorCSPInfo::initiator_csp)& initiator_csp(
      const ::content::mojom::InitiatorCSPInfoPtr& input) {
    return input->initiator_csp;
  }

  static const decltype(::content::mojom::InitiatorCSPInfo::initiator_self_source)& initiator_self_source(
      const ::content::mojom::InitiatorCSPInfoPtr& input) {
    return input->initiator_self_source;
  }

  static bool Read(::content::mojom::InitiatorCSPInfo::DataView input, ::content::mojom::InitiatorCSPInfoPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::BeginNavigationParams::DataView,
                                         ::content::mojom::BeginNavigationParamsPtr> {
  static bool IsNull(const ::content::mojom::BeginNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::BeginNavigationParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::BeginNavigationParams::initiator_routing_id) initiator_routing_id(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->initiator_routing_id;
  }

  static const decltype(::content::mojom::BeginNavigationParams::headers)& headers(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->headers;
  }

  static decltype(::content::mojom::BeginNavigationParams::load_flags) load_flags(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->load_flags;
  }

  static decltype(::content::mojom::BeginNavigationParams::skip_service_worker) skip_service_worker(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->skip_service_worker;
  }

  static decltype(::content::mojom::BeginNavigationParams::request_context_type) request_context_type(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->request_context_type;
  }

  static decltype(::content::mojom::BeginNavigationParams::request_destination) request_destination(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->request_destination;
  }

  static decltype(::content::mojom::BeginNavigationParams::mixed_content_context_type) mixed_content_context_type(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->mixed_content_context_type;
  }

  static decltype(::content::mojom::BeginNavigationParams::is_form_submission) is_form_submission(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->is_form_submission;
  }

  static decltype(::content::mojom::BeginNavigationParams::was_initiated_by_link_click) was_initiated_by_link_click(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->was_initiated_by_link_click;
  }

  static const decltype(::content::mojom::BeginNavigationParams::searchable_form_url)& searchable_form_url(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->searchable_form_url;
  }

  static const decltype(::content::mojom::BeginNavigationParams::searchable_form_encoding)& searchable_form_encoding(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->searchable_form_encoding;
  }

  static const decltype(::content::mojom::BeginNavigationParams::client_side_redirect_url)& client_side_redirect_url(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->client_side_redirect_url;
  }

  static const decltype(::content::mojom::BeginNavigationParams::devtools_initiator)& devtools_initiator(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->devtools_initiator;
  }

  static decltype(::content::mojom::BeginNavigationParams::force_ignore_site_for_cookies) force_ignore_site_for_cookies(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->force_ignore_site_for_cookies;
  }

  static const decltype(::content::mojom::BeginNavigationParams::trust_token_params)& trust_token_params(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->trust_token_params;
  }

  static const decltype(::content::mojom::BeginNavigationParams::impression)& impression(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::content::mojom::BeginNavigationParams::before_unload_start)& before_unload_start(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->before_unload_start;
  }

  static const decltype(::content::mojom::BeginNavigationParams::before_unload_end)& before_unload_end(
      const ::content::mojom::BeginNavigationParamsPtr& input) {
    return input->before_unload_end;
  }

  static bool Read(::content::mojom::BeginNavigationParams::DataView input, ::content::mojom::BeginNavigationParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CommonNavigationParams::DataView,
                                         ::content::mojom::CommonNavigationParamsPtr> {
  static bool IsNull(const ::content::mojom::CommonNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CommonNavigationParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CommonNavigationParams::url)& url(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->url;
  }

  static const decltype(::content::mojom::CommonNavigationParams::initiator_origin)& initiator_origin(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::content::mojom::CommonNavigationParams::referrer)& referrer(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->referrer;
  }

  static decltype(::content::mojom::CommonNavigationParams::transition) transition(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->transition;
  }

  static decltype(::content::mojom::CommonNavigationParams::navigation_type) navigation_type(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->navigation_type;
  }

  static const decltype(::content::mojom::CommonNavigationParams::download_policy)& download_policy(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->download_policy;
  }

  static decltype(::content::mojom::CommonNavigationParams::should_replace_current_entry) should_replace_current_entry(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->should_replace_current_entry;
  }

  static const decltype(::content::mojom::CommonNavigationParams::base_url_for_data_url)& base_url_for_data_url(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->base_url_for_data_url;
  }

  static const decltype(::content::mojom::CommonNavigationParams::history_url_for_data_url)& history_url_for_data_url(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->history_url_for_data_url;
  }

  static decltype(::content::mojom::CommonNavigationParams::previews_state) previews_state(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->previews_state;
  }

  static const decltype(::content::mojom::CommonNavigationParams::navigation_start)& navigation_start(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->navigation_start;
  }

  static const decltype(::content::mojom::CommonNavigationParams::method)& method(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->method;
  }

  static  decltype(::content::mojom::CommonNavigationParams::post_data)& post_data(
       ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->post_data;
  }

  static const decltype(::content::mojom::CommonNavigationParams::source_location)& source_location(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->source_location;
  }

  static decltype(::content::mojom::CommonNavigationParams::started_from_context_menu) started_from_context_menu(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->started_from_context_menu;
  }

  static decltype(::content::mojom::CommonNavigationParams::has_user_gesture) has_user_gesture(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::content::mojom::CommonNavigationParams::text_fragment_token) text_fragment_token(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->text_fragment_token;
  }

  static const decltype(::content::mojom::CommonNavigationParams::initiator_csp_info)& initiator_csp_info(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_csp_info;
  }

  static const decltype(::content::mojom::CommonNavigationParams::initiator_origin_trial_features)& initiator_origin_trial_features(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_origin_trial_features;
  }

  static const decltype(::content::mojom::CommonNavigationParams::href_translate)& href_translate(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->href_translate;
  }

  static decltype(::content::mojom::CommonNavigationParams::is_history_navigation_in_new_child_frame) is_history_navigation_in_new_child_frame(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->is_history_navigation_in_new_child_frame;
  }

  static const decltype(::content::mojom::CommonNavigationParams::input_start)& input_start(
      const ::content::mojom::CommonNavigationParamsPtr& input) {
    return input->input_start;
  }

  static bool Read(::content::mojom::CommonNavigationParams::DataView input, ::content::mojom::CommonNavigationParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::NavigationTiming::DataView,
                                         ::content::mojom::NavigationTimingPtr> {
  static bool IsNull(const ::content::mojom::NavigationTimingPtr& input) { return !input; }
  static void SetToNull(::content::mojom::NavigationTimingPtr* output) { output->reset(); }

  static const decltype(::content::mojom::NavigationTiming::redirect_start)& redirect_start(
      const ::content::mojom::NavigationTimingPtr& input) {
    return input->redirect_start;
  }

  static const decltype(::content::mojom::NavigationTiming::redirect_end)& redirect_end(
      const ::content::mojom::NavigationTimingPtr& input) {
    return input->redirect_end;
  }

  static const decltype(::content::mojom::NavigationTiming::fetch_start)& fetch_start(
      const ::content::mojom::NavigationTimingPtr& input) {
    return input->fetch_start;
  }

  static bool Read(::content::mojom::NavigationTiming::DataView input, ::content::mojom::NavigationTimingPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::OldPageInfo::DataView,
                                         ::content::mojom::OldPageInfoPtr> {
  static bool IsNull(const ::content::mojom::OldPageInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::OldPageInfoPtr* output) { output->reset(); }

  static decltype(::content::mojom::OldPageInfo::routing_id_for_old_main_frame) routing_id_for_old_main_frame(
      const ::content::mojom::OldPageInfoPtr& input) {
    return input->routing_id_for_old_main_frame;
  }

  static const decltype(::content::mojom::OldPageInfo::new_lifecycle_state_for_old_page)& new_lifecycle_state_for_old_page(
      const ::content::mojom::OldPageInfoPtr& input) {
    return input->new_lifecycle_state_for_old_page;
  }

  static bool Read(::content::mojom::OldPageInfo::DataView input, ::content::mojom::OldPageInfoPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CommitNavigationParams::DataView,
                                         ::content::mojom::CommitNavigationParamsPtr> {
  static bool IsNull(const ::content::mojom::CommitNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CommitNavigationParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CommitNavigationParams::origin_to_commit)& origin_to_commit(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->origin_to_commit;
  }

  static decltype(::content::mojom::CommitNavigationParams::is_overriding_user_agent) is_overriding_user_agent(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->is_overriding_user_agent;
  }

  static const decltype(::content::mojom::CommitNavigationParams::redirects)& redirects(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->redirects;
  }

  static const decltype(::content::mojom::CommitNavigationParams::redirect_response)& redirect_response(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->redirect_response;
  }

  static const decltype(::content::mojom::CommitNavigationParams::redirect_infos)& redirect_infos(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->redirect_infos;
  }

  static const decltype(::content::mojom::CommitNavigationParams::post_content_type)& post_content_type(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->post_content_type;
  }

  static const decltype(::content::mojom::CommitNavigationParams::original_url)& original_url(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->original_url;
  }

  static const decltype(::content::mojom::CommitNavigationParams::original_method)& original_method(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->original_method;
  }

  static decltype(::content::mojom::CommitNavigationParams::can_load_local_resources) can_load_local_resources(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->can_load_local_resources;
  }

  static const decltype(::content::mojom::CommitNavigationParams::page_state)& page_state(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->page_state;
  }

  static decltype(::content::mojom::CommitNavigationParams::nav_entry_id) nav_entry_id(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->nav_entry_id;
  }

  static const decltype(::content::mojom::CommitNavigationParams::subframe_unique_names)& subframe_unique_names(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->subframe_unique_names;
  }

  static decltype(::content::mojom::CommitNavigationParams::intended_as_new_entry) intended_as_new_entry(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->intended_as_new_entry;
  }

  static decltype(::content::mojom::CommitNavigationParams::pending_history_list_offset) pending_history_list_offset(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->pending_history_list_offset;
  }

  static decltype(::content::mojom::CommitNavigationParams::current_history_list_offset) current_history_list_offset(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->current_history_list_offset;
  }

  static decltype(::content::mojom::CommitNavigationParams::current_history_list_length) current_history_list_length(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->current_history_list_length;
  }

  static decltype(::content::mojom::CommitNavigationParams::was_discarded) was_discarded(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->was_discarded;
  }

  static decltype(::content::mojom::CommitNavigationParams::is_view_source) is_view_source(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->is_view_source;
  }

  static decltype(::content::mojom::CommitNavigationParams::should_clear_history_list) should_clear_history_list(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->should_clear_history_list;
  }

  static const decltype(::content::mojom::CommitNavigationParams::navigation_timing)& navigation_timing(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_timing;
  }

  static const decltype(::content::mojom::CommitNavigationParams::appcache_host_id)& appcache_host_id(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->appcache_host_id;
  }

  static decltype(::content::mojom::CommitNavigationParams::was_activated) was_activated(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->was_activated;
  }

  static const decltype(::content::mojom::CommitNavigationParams::navigation_token)& navigation_token(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_token;
  }

  static  decltype(::content::mojom::CommitNavigationParams::prefetched_signed_exchanges)& prefetched_signed_exchanges(
       ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->prefetched_signed_exchanges;
  }

  static decltype(::content::mojom::CommitNavigationParams::is_browser_initiated) is_browser_initiated(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->is_browser_initiated;
  }

  static decltype(::content::mojom::CommitNavigationParams::ip_address_space) ip_address_space(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->ip_address_space;
  }

  static const decltype(::content::mojom::CommitNavigationParams::web_bundle_physical_url)& web_bundle_physical_url(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->web_bundle_physical_url;
  }

  static const decltype(::content::mojom::CommitNavigationParams::web_bundle_claimed_url)& web_bundle_claimed_url(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->web_bundle_claimed_url;
  }

  static decltype(::content::mojom::CommitNavigationParams::document_ukm_source_id) document_ukm_source_id(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->document_ukm_source_id;
  }

  static const decltype(::content::mojom::CommitNavigationParams::frame_policy)& frame_policy(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->frame_policy;
  }

  static const decltype(::content::mojom::CommitNavigationParams::force_enabled_origin_trials)& force_enabled_origin_trials(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->force_enabled_origin_trials;
  }

  static decltype(::content::mojom::CommitNavigationParams::origin_isolated) origin_isolated(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->origin_isolated;
  }

  static const decltype(::content::mojom::CommitNavigationParams::enabled_client_hints)& enabled_client_hints(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->enabled_client_hints;
  }

  static decltype(::content::mojom::CommitNavigationParams::is_cross_browsing_instance) is_cross_browsing_instance(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->is_cross_browsing_instance;
  }

  static const decltype(::content::mojom::CommitNavigationParams::forced_content_security_policies)& forced_content_security_policies(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->forced_content_security_policies;
  }

  static const decltype(::content::mojom::CommitNavigationParams::old_page_info)& old_page_info(
      const ::content::mojom::CommitNavigationParamsPtr& input) {
    return input->old_page_info;
  }

  static bool Read(::content::mojom::CommitNavigationParams::DataView input, ::content::mojom::CommitNavigationParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_H_