// media/mojo/mojom/audio_data_pipe.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/audio_data_pipe.mojom-shared.h"
#include "media/mojo/mojom/audio_data_pipe.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {









class  ReadWriteAudioDataPipe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadWriteAudioDataPipe, T>::value>;
  using DataView = ReadWriteAudioDataPipeDataView;
  using Data_ = internal::ReadWriteAudioDataPipe_Data;

  template <typename... Args>
  static ReadWriteAudioDataPipePtr New(Args&&... args) {
    return ReadWriteAudioDataPipePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadWriteAudioDataPipePtr From(const U& u) {
    return mojo::TypeConverter<ReadWriteAudioDataPipePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadWriteAudioDataPipe>::Convert(*this);
  }


  ReadWriteAudioDataPipe();

  ReadWriteAudioDataPipe(
      ::base::UnsafeSharedMemoryRegion shared_memory,
      ::mojo::PlatformHandle socket);

  ~ReadWriteAudioDataPipe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadWriteAudioDataPipePtr>
  ReadWriteAudioDataPipePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadWriteAudioDataPipe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadWriteAudioDataPipe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadWriteAudioDataPipe_UnserializedMessageContext<
            UserType, ReadWriteAudioDataPipe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ReadWriteAudioDataPipe::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ReadWriteAudioDataPipe::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadWriteAudioDataPipe_UnserializedMessageContext<
            UserType, ReadWriteAudioDataPipe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadWriteAudioDataPipe::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::UnsafeSharedMemoryRegion shared_memory;
  
  ::mojo::PlatformHandle socket;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ReadWriteAudioDataPipe);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ReadOnlyAudioDataPipe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadOnlyAudioDataPipe, T>::value>;
  using DataView = ReadOnlyAudioDataPipeDataView;
  using Data_ = internal::ReadOnlyAudioDataPipe_Data;

  template <typename... Args>
  static ReadOnlyAudioDataPipePtr New(Args&&... args) {
    return ReadOnlyAudioDataPipePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadOnlyAudioDataPipePtr From(const U& u) {
    return mojo::TypeConverter<ReadOnlyAudioDataPipePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadOnlyAudioDataPipe>::Convert(*this);
  }


  ReadOnlyAudioDataPipe();

  ReadOnlyAudioDataPipe(
      ::base::ReadOnlySharedMemoryRegion shared_memory,
      ::mojo::PlatformHandle socket);

  ~ReadOnlyAudioDataPipe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadOnlyAudioDataPipePtr>
  ReadOnlyAudioDataPipePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadOnlyAudioDataPipe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadOnlyAudioDataPipe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadOnlyAudioDataPipe_UnserializedMessageContext<
            UserType, ReadOnlyAudioDataPipe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ReadOnlyAudioDataPipe::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ReadOnlyAudioDataPipe::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadOnlyAudioDataPipe_UnserializedMessageContext<
            UserType, ReadOnlyAudioDataPipe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadOnlyAudioDataPipe::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion shared_memory;
  
  ::mojo::PlatformHandle socket;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ReadOnlyAudioDataPipe);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadWriteAudioDataPipePtr ReadWriteAudioDataPipe::Clone() const {
  return New(
      mojo::Clone(shared_memory),
      mojo::Clone(socket)
  );
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>*>
bool ReadWriteAudioDataPipe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_memory, other_struct.shared_memory))
    return false;
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  return true;
}

template <typename T, ReadWriteAudioDataPipe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.shared_memory, rhs.shared_memory))
    return true;
  if (std::less<>{}(rhs.shared_memory, lhs.shared_memory))
    return false;
  if (std::less<>{}(lhs.socket, rhs.socket))
    return true;
  if (std::less<>{}(rhs.socket, lhs.socket))
    return false;
  return false;
}
template <typename StructPtrType>
ReadOnlyAudioDataPipePtr ReadOnlyAudioDataPipe::Clone() const {
  return New(
      mojo::Clone(shared_memory),
      mojo::Clone(socket)
  );
}

template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>*>
bool ReadOnlyAudioDataPipe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_memory, other_struct.shared_memory))
    return false;
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  return true;
}

template <typename T, ReadOnlyAudioDataPipe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.shared_memory, rhs.shared_memory))
    return true;
  if (std::less<>{}(rhs.shared_memory, lhs.shared_memory))
    return false;
  if (std::less<>{}(lhs.socket, rhs.socket))
    return true;
  if (std::less<>{}(rhs.socket, lhs.socket))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::ReadWriteAudioDataPipe::DataView,
                                         ::media::mojom::ReadWriteAudioDataPipePtr> {
  static bool IsNull(const ::media::mojom::ReadWriteAudioDataPipePtr& input) { return !input; }
  static void SetToNull(::media::mojom::ReadWriteAudioDataPipePtr* output) { output->reset(); }

  static  decltype(::media::mojom::ReadWriteAudioDataPipe::shared_memory)& shared_memory(
       ::media::mojom::ReadWriteAudioDataPipePtr& input) {
    return input->shared_memory;
  }

  static  decltype(::media::mojom::ReadWriteAudioDataPipe::socket)& socket(
       ::media::mojom::ReadWriteAudioDataPipePtr& input) {
    return input->socket;
  }

  static bool Read(::media::mojom::ReadWriteAudioDataPipe::DataView input, ::media::mojom::ReadWriteAudioDataPipePtr* output);
};


template <>
struct  StructTraits<::media::mojom::ReadOnlyAudioDataPipe::DataView,
                                         ::media::mojom::ReadOnlyAudioDataPipePtr> {
  static bool IsNull(const ::media::mojom::ReadOnlyAudioDataPipePtr& input) { return !input; }
  static void SetToNull(::media::mojom::ReadOnlyAudioDataPipePtr* output) { output->reset(); }

  static  decltype(::media::mojom::ReadOnlyAudioDataPipe::shared_memory)& shared_memory(
       ::media::mojom::ReadOnlyAudioDataPipePtr& input) {
    return input->shared_memory;
  }

  static  decltype(::media::mojom::ReadOnlyAudioDataPipe::socket)& socket(
       ::media::mojom::ReadOnlyAudioDataPipePtr& input) {
    return input->socket;
  }

  static bool Read(::media::mojom::ReadOnlyAudioDataPipe::DataView input, ::media::mojom::ReadOnlyAudioDataPipePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_H_