// mojo/public/interfaces/bindings/pipe_control_messages.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared.h"
#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-forward.h"
#include <string>
#include <vector>




#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace mojo {
namespace pipe_control {






class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) DisconnectReason {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisconnectReason, T>::value>;
  using DataView = DisconnectReasonDataView;
  using Data_ = internal::DisconnectReason_Data;

  template <typename... Args>
  static DisconnectReasonPtr New(Args&&... args) {
    return DisconnectReasonPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisconnectReasonPtr From(const U& u) {
    return mojo::TypeConverter<DisconnectReasonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisconnectReason>::Convert(*this);
  }


  DisconnectReason();

  DisconnectReason(
      uint32_t custom_reason,
      const std::string& description);

  ~DisconnectReason();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisconnectReasonPtr>
  DisconnectReasonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisconnectReason::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisconnectReason::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisconnectReason::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisconnectReason_UnserializedMessageContext<
            UserType, DisconnectReason::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DisconnectReason::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DisconnectReason::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisconnectReason_UnserializedMessageContext<
            UserType, DisconnectReason::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisconnectReason::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t custom_reason;
  
  std::string description;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisconnectReason::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisconnectReason::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisconnectReason::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisconnectReason::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeInput {
 public:
  using DataView = RunOrClosePipeInputDataView;
  using Data_ = internal::RunOrClosePipeInput_Data;
  using Tag = Data_::RunOrClosePipeInput_Tag;

  static RunOrClosePipeInputPtr New() {
    return RunOrClosePipeInputPtr(base::in_place);
  }
  // Construct an instance holding |peer_associated_endpoint_closed_event|.
  static RunOrClosePipeInputPtr
  NewPeerAssociatedEndpointClosedEvent(
      PeerAssociatedEndpointClosedEventPtr peer_associated_endpoint_closed_event) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_peer_associated_endpoint_closed_event(std::move(peer_associated_endpoint_closed_event));
    return result;
  }
  // Construct an instance holding |pause_until_flush_completes|.
  static RunOrClosePipeInputPtr
  NewPauseUntilFlushCompletes(
      PauseUntilFlushCompletesPtr pause_until_flush_completes) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_pause_until_flush_completes(std::move(pause_until_flush_completes));
    return result;
  }
  // Construct an instance holding |flush_async|.
  static RunOrClosePipeInputPtr
  NewFlushAsync(
      FlushAsyncPtr flush_async) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_flush_async(std::move(flush_async));
    return result;
  }

  template <typename U>
  static RunOrClosePipeInputPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeInput>::Convert(*this);
  }

  RunOrClosePipeInput();
  ~RunOrClosePipeInput();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunOrClosePipeInputPtr>
  RunOrClosePipeInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOrClosePipeInput>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_peer_associated_endpoint_closed_event() const { return tag_ == Tag::PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT; }

  
  PeerAssociatedEndpointClosedEventPtr& get_peer_associated_endpoint_closed_event() const {
    DCHECK(tag_ == Tag::PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT);
    return *(data_.peer_associated_endpoint_closed_event);
  }

  
  void set_peer_associated_endpoint_closed_event(
      PeerAssociatedEndpointClosedEventPtr peer_associated_endpoint_closed_event);
  
  bool is_pause_until_flush_completes() const { return tag_ == Tag::PAUSE_UNTIL_FLUSH_COMPLETES; }

  
  PauseUntilFlushCompletesPtr& get_pause_until_flush_completes() const {
    DCHECK(tag_ == Tag::PAUSE_UNTIL_FLUSH_COMPLETES);
    return *(data_.pause_until_flush_completes);
  }

  
  void set_pause_until_flush_completes(
      PauseUntilFlushCompletesPtr pause_until_flush_completes);
  
  bool is_flush_async() const { return tag_ == Tag::FLUSH_ASYNC; }

  
  FlushAsyncPtr& get_flush_async() const {
    DCHECK(tag_ == Tag::FLUSH_ASYNC);
    return *(data_.flush_async);
  }

  
  void set_flush_async(
      FlushAsyncPtr flush_async);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeInput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunOrClosePipeInput::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    PeerAssociatedEndpointClosedEventPtr* peer_associated_endpoint_closed_event;
    PauseUntilFlushCompletesPtr* pause_until_flush_completes;
    FlushAsyncPtr* flush_async;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunOrClosePipeMessageParams, T>::value>;
  using DataView = RunOrClosePipeMessageParamsDataView;
  using Data_ = internal::RunOrClosePipeMessageParams_Data;

  template <typename... Args>
  static RunOrClosePipeMessageParamsPtr New(Args&&... args) {
    return RunOrClosePipeMessageParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunOrClosePipeMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeMessageParams>::Convert(*this);
  }


  RunOrClosePipeMessageParams();

  explicit RunOrClosePipeMessageParams(
      RunOrClosePipeInputPtr input);

  ~RunOrClosePipeMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunOrClosePipeMessageParamsPtr>
  RunOrClosePipeMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOrClosePipeMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunOrClosePipeMessageParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  RunOrClosePipeInputPtr input;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RunOrClosePipeMessageParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) PeerAssociatedEndpointClosedEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PeerAssociatedEndpointClosedEvent, T>::value>;
  using DataView = PeerAssociatedEndpointClosedEventDataView;
  using Data_ = internal::PeerAssociatedEndpointClosedEvent_Data;

  template <typename... Args>
  static PeerAssociatedEndpointClosedEventPtr New(Args&&... args) {
    return PeerAssociatedEndpointClosedEventPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PeerAssociatedEndpointClosedEventPtr From(const U& u) {
    return mojo::TypeConverter<PeerAssociatedEndpointClosedEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PeerAssociatedEndpointClosedEvent>::Convert(*this);
  }


  PeerAssociatedEndpointClosedEvent();

  PeerAssociatedEndpointClosedEvent(
      uint32_t id,
      DisconnectReasonPtr disconnect_reason);

  ~PeerAssociatedEndpointClosedEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PeerAssociatedEndpointClosedEventPtr>
  PeerAssociatedEndpointClosedEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PeerAssociatedEndpointClosedEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PeerAssociatedEndpointClosedEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PeerAssociatedEndpointClosedEvent_UnserializedMessageContext<
            UserType, PeerAssociatedEndpointClosedEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PeerAssociatedEndpointClosedEvent::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PeerAssociatedEndpointClosedEvent::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PeerAssociatedEndpointClosedEvent_UnserializedMessageContext<
            UserType, PeerAssociatedEndpointClosedEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PeerAssociatedEndpointClosedEvent::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t id;
  
  DisconnectReasonPtr disconnect_reason;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PeerAssociatedEndpointClosedEvent);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) PauseUntilFlushCompletes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PauseUntilFlushCompletes, T>::value>;
  using DataView = PauseUntilFlushCompletesDataView;
  using Data_ = internal::PauseUntilFlushCompletes_Data;

  template <typename... Args>
  static PauseUntilFlushCompletesPtr New(Args&&... args) {
    return PauseUntilFlushCompletesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PauseUntilFlushCompletesPtr From(const U& u) {
    return mojo::TypeConverter<PauseUntilFlushCompletesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PauseUntilFlushCompletes>::Convert(*this);
  }


  PauseUntilFlushCompletes();

  explicit PauseUntilFlushCompletes(
      ::mojo::ScopedMessagePipeHandle flush_pipe);

  ~PauseUntilFlushCompletes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PauseUntilFlushCompletesPtr>
  PauseUntilFlushCompletesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PauseUntilFlushCompletes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PauseUntilFlushCompletes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PauseUntilFlushCompletes_UnserializedMessageContext<
            UserType, PauseUntilFlushCompletes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PauseUntilFlushCompletes::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PauseUntilFlushCompletes::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PauseUntilFlushCompletes_UnserializedMessageContext<
            UserType, PauseUntilFlushCompletes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PauseUntilFlushCompletes::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::ScopedMessagePipeHandle flush_pipe;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PauseUntilFlushCompletes);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) FlushAsync {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FlushAsync, T>::value>;
  using DataView = FlushAsyncDataView;
  using Data_ = internal::FlushAsync_Data;

  template <typename... Args>
  static FlushAsyncPtr New(Args&&... args) {
    return FlushAsyncPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FlushAsyncPtr From(const U& u) {
    return mojo::TypeConverter<FlushAsyncPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FlushAsync>::Convert(*this);
  }


  FlushAsync();

  explicit FlushAsync(
      ::mojo::ScopedMessagePipeHandle flusher_pipe);

  ~FlushAsync();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FlushAsyncPtr>
  FlushAsyncPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FlushAsync::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FlushAsync::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FlushAsync::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FlushAsync_UnserializedMessageContext<
            UserType, FlushAsync::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FlushAsync::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FlushAsync::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FlushAsync_UnserializedMessageContext<
            UserType, FlushAsync::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FlushAsync::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::ScopedMessagePipeHandle flusher_pipe;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FlushAsync);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FlushAsync::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FlushAsync::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FlushAsync::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FlushAsync::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
RunOrClosePipeInputPtr RunOrClosePipeInput::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT:
      rv->set_peer_associated_endpoint_closed_event(mojo::Clone(*data_.peer_associated_endpoint_closed_event));
      break;
    case Tag::PAUSE_UNTIL_FLUSH_COMPLETES:
      rv->set_pause_until_flush_completes(mojo::Clone(*data_.pause_until_flush_completes));
      break;
    case Tag::FLUSH_ASYNC:
      rv->set_flush_async(mojo::Clone(*data_.flush_async));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunOrClosePipeInput>::value>::type*>
bool RunOrClosePipeInput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT:
      return mojo::Equals(*(data_.peer_associated_endpoint_closed_event), *(other.data_.peer_associated_endpoint_closed_event));
    case Tag::PAUSE_UNTIL_FLUSH_COMPLETES:
      return mojo::Equals(*(data_.pause_until_flush_completes), *(other.data_.pause_until_flush_completes));
    case Tag::FLUSH_ASYNC:
      return mojo::Equals(*(data_.flush_async), *(other.data_.flush_async));
  }

  return false;
}
template <typename StructPtrType>
RunOrClosePipeMessageParamsPtr RunOrClosePipeMessageParams::Clone() const {
  return New(
      mojo::Clone(input)
  );
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool RunOrClosePipeMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  return true;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.input, rhs.input))
    return true;
  if (std::less<>{}(rhs.input, lhs.input))
    return false;
  return false;
}
template <typename StructPtrType>
DisconnectReasonPtr DisconnectReason::Clone() const {
  return New(
      mojo::Clone(custom_reason),
      mojo::Clone(description)
  );
}

template <typename T, DisconnectReason::EnableIfSame<T>*>
bool DisconnectReason::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->custom_reason, other_struct.custom_reason))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, DisconnectReason::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.custom_reason, rhs.custom_reason))
    return true;
  if (std::less<>{}(rhs.custom_reason, lhs.custom_reason))
    return false;
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  return false;
}
template <typename StructPtrType>
PeerAssociatedEndpointClosedEventPtr PeerAssociatedEndpointClosedEvent::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(disconnect_reason)
  );
}

template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>*>
bool PeerAssociatedEndpointClosedEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->disconnect_reason, other_struct.disconnect_reason))
    return false;
  return true;
}

template <typename T, PeerAssociatedEndpointClosedEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.disconnect_reason, rhs.disconnect_reason))
    return true;
  if (std::less<>{}(rhs.disconnect_reason, lhs.disconnect_reason))
    return false;
  return false;
}
template <typename StructPtrType>
PauseUntilFlushCompletesPtr PauseUntilFlushCompletes::Clone() const {
  return New(
      mojo::Clone(flush_pipe)
  );
}

template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>*>
bool PauseUntilFlushCompletes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->flush_pipe, other_struct.flush_pipe))
    return false;
  return true;
}

template <typename T, PauseUntilFlushCompletes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.flush_pipe, rhs.flush_pipe))
    return true;
  if (std::less<>{}(rhs.flush_pipe, lhs.flush_pipe))
    return false;
  return false;
}
template <typename StructPtrType>
FlushAsyncPtr FlushAsync::Clone() const {
  return New(
      mojo::Clone(flusher_pipe)
  );
}

template <typename T, FlushAsync::EnableIfSame<T>*>
bool FlushAsync::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->flusher_pipe, other_struct.flusher_pipe))
    return false;
  return true;
}

template <typename T, FlushAsync::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.flusher_pipe, rhs.flusher_pipe))
    return true;
  if (std::less<>{}(rhs.flusher_pipe, lhs.flusher_pipe))
    return false;
  return false;
}


}  // namespace pipe_control
}  // namespace mojo

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::pipe_control::RunOrClosePipeMessageParams::DataView,
                                         ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr> {
  static bool IsNull(const ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::RunOrClosePipeMessageParamsPtr* output) { output->reset(); }

  static  decltype(::mojo::pipe_control::RunOrClosePipeMessageParams::input)& input(
       ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr& input) {
    return input->input;
  }

  static bool Read(::mojo::pipe_control::RunOrClosePipeMessageParams::DataView input, ::mojo::pipe_control::RunOrClosePipeMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::pipe_control::DisconnectReason::DataView,
                                         ::mojo::pipe_control::DisconnectReasonPtr> {
  static bool IsNull(const ::mojo::pipe_control::DisconnectReasonPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::DisconnectReasonPtr* output) { output->reset(); }

  static decltype(::mojo::pipe_control::DisconnectReason::custom_reason) custom_reason(
      const ::mojo::pipe_control::DisconnectReasonPtr& input) {
    return input->custom_reason;
  }

  static const decltype(::mojo::pipe_control::DisconnectReason::description)& description(
      const ::mojo::pipe_control::DisconnectReasonPtr& input) {
    return input->description;
  }

  static bool Read(::mojo::pipe_control::DisconnectReason::DataView input, ::mojo::pipe_control::DisconnectReasonPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::DataView,
                                         ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr> {
  static bool IsNull(const ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr* output) { output->reset(); }

  static decltype(::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::id) id(
      const ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr& input) {
    return input->id;
  }

  static const decltype(::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::disconnect_reason)& disconnect_reason(
      const ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr& input) {
    return input->disconnect_reason;
  }

  static bool Read(::mojo::pipe_control::PeerAssociatedEndpointClosedEvent::DataView input, ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::pipe_control::PauseUntilFlushCompletes::DataView,
                                         ::mojo::pipe_control::PauseUntilFlushCompletesPtr> {
  static bool IsNull(const ::mojo::pipe_control::PauseUntilFlushCompletesPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::PauseUntilFlushCompletesPtr* output) { output->reset(); }

  static  decltype(::mojo::pipe_control::PauseUntilFlushCompletes::flush_pipe)& flush_pipe(
       ::mojo::pipe_control::PauseUntilFlushCompletesPtr& input) {
    return input->flush_pipe;
  }

  static bool Read(::mojo::pipe_control::PauseUntilFlushCompletes::DataView input, ::mojo::pipe_control::PauseUntilFlushCompletesPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::pipe_control::FlushAsync::DataView,
                                         ::mojo::pipe_control::FlushAsyncPtr> {
  static bool IsNull(const ::mojo::pipe_control::FlushAsyncPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::FlushAsyncPtr* output) { output->reset(); }

  static  decltype(::mojo::pipe_control::FlushAsync::flusher_pipe)& flusher_pipe(
       ::mojo::pipe_control::FlushAsyncPtr& input) {
    return input->flusher_pipe;
  }

  static bool Read(::mojo::pipe_control::FlushAsync::DataView input, ::mojo::pipe_control::FlushAsyncPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::pipe_control::RunOrClosePipeInput::DataView,
                                        ::mojo::pipe_control::RunOrClosePipeInputPtr> {
  static bool IsNull(const ::mojo::pipe_control::RunOrClosePipeInputPtr& input) { return !input; }
  static void SetToNull(::mojo::pipe_control::RunOrClosePipeInputPtr* output) { output->reset(); }

  static ::mojo::pipe_control::RunOrClosePipeInput::Tag GetTag(const ::mojo::pipe_control::RunOrClosePipeInputPtr& input) {
    return input->which();
  }

  static const ::mojo::pipe_control::PeerAssociatedEndpointClosedEventPtr& peer_associated_endpoint_closed_event(const ::mojo::pipe_control::RunOrClosePipeInputPtr& input) {
    return input->get_peer_associated_endpoint_closed_event();
  }

  static  ::mojo::pipe_control::PauseUntilFlushCompletesPtr& pause_until_flush_completes( ::mojo::pipe_control::RunOrClosePipeInputPtr& input) {
    return input->get_pause_until_flush_completes();
  }

  static  ::mojo::pipe_control::FlushAsyncPtr& flush_async( ::mojo::pipe_control::RunOrClosePipeInputPtr& input) {
    return input->get_flush_async();
  }

  static bool Read(::mojo::pipe_control::RunOrClosePipeInput::DataView input, ::mojo::pipe_control::RunOrClosePipeInputPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_H_