// qtwebengine/common/media/webrtc_logging.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SHARED_H_
#define QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "qtwebengine/common/media/webrtc_logging.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace chrome {
namespace mojom {
class WebRtcLoggingMessageDataView;



}  // namespace mojom
}  // namespace chrome

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::WebRtcLoggingMessageDataView> {
  using Data = ::chrome::mojom::internal::WebRtcLoggingMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome {
namespace mojom {
// Interface base classes. They are used for type safety check.
class WebRtcLoggingClientInterfaceBase {};

using WebRtcLoggingClientPtrDataView =
    mojo::InterfacePtrDataView<WebRtcLoggingClientInterfaceBase>;
using WebRtcLoggingClientRequestDataView =
    mojo::InterfaceRequestDataView<WebRtcLoggingClientInterfaceBase>;
using WebRtcLoggingClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebRtcLoggingClientInterfaceBase>;
using WebRtcLoggingClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebRtcLoggingClientInterfaceBase>;
class WebRtcLoggingAgentInterfaceBase {};

using WebRtcLoggingAgentPtrDataView =
    mojo::InterfacePtrDataView<WebRtcLoggingAgentInterfaceBase>;
using WebRtcLoggingAgentRequestDataView =
    mojo::InterfaceRequestDataView<WebRtcLoggingAgentInterfaceBase>;
using WebRtcLoggingAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebRtcLoggingAgentInterfaceBase>;
using WebRtcLoggingAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebRtcLoggingAgentInterfaceBase>;


class WebRtcLoggingMessageDataView {
 public:
  WebRtcLoggingMessageDataView() {}

  WebRtcLoggingMessageDataView(
      internal::WebRtcLoggingMessage_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebRtcLoggingMessage_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace chrome

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::WebRtcLoggingMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::WebRtcLoggingMessageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::chrome::mojom::internal::WebRtcLoggingMessage_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    typename decltype((*output)->timestamp)::BaseType::BufferWriter
        timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_timestamp, buffer, &timestamp_writer, context);
    (*output)->timestamp.Set(
        timestamp_writer.is_null() ? nullptr : timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in WebRtcLoggingMessage struct");
    decltype(Traits::data(input)) in_data = Traits::data(input);
    typename decltype((*output)->data)::BaseType::BufferWriter
        data_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_data, buffer, &data_writer, context);
    (*output)->data.Set(
        data_writer.is_null() ? nullptr : data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in WebRtcLoggingMessage struct");
  }

  static bool Deserialize(::chrome::mojom::internal::WebRtcLoggingMessage_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::WebRtcLoggingMessageDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome {
namespace mojom {

inline void WebRtcLoggingMessageDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void WebRtcLoggingMessageDataView::GetDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace chrome

#endif  // QTWEBENGINE_COMMON_MEDIA_WEBRTC_LOGGING_MOJOM_SHARED_H_