// services/media_session/public/mojom/media_controller.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace media_session {
namespace mojom {
namespace internal {
class  MediaControllerManager_CreateMediaControllerForSession_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerManager_CreateMediaControllerForSession_Params_Data));
      new (data()) MediaControllerManager_CreateMediaControllerForSession_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerManager_CreateMediaControllerForSession_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerManager_CreateMediaControllerForSession_Params_Data>(index_);
    }
    MediaControllerManager_CreateMediaControllerForSession_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> request_id;

 private:
  MediaControllerManager_CreateMediaControllerForSession_Params_Data();
  ~MediaControllerManager_CreateMediaControllerForSession_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_CreateMediaControllerForSession_Params_Data) == 24,
              "Bad sizeof(MediaControllerManager_CreateMediaControllerForSession_Params_Data)");
class  MediaControllerManager_CreateActiveMediaController_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerManager_CreateActiveMediaController_Params_Data));
      new (data()) MediaControllerManager_CreateActiveMediaController_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerManager_CreateActiveMediaController_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerManager_CreateActiveMediaController_Params_Data>(index_);
    }
    MediaControllerManager_CreateActiveMediaController_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  MediaControllerManager_CreateActiveMediaController_Params_Data();
  ~MediaControllerManager_CreateActiveMediaController_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_CreateActiveMediaController_Params_Data) == 16,
              "Bad sizeof(MediaControllerManager_CreateActiveMediaController_Params_Data)");
class  MediaControllerManager_SuspendAllSessions_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerManager_SuspendAllSessions_Params_Data));
      new (data()) MediaControllerManager_SuspendAllSessions_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerManager_SuspendAllSessions_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerManager_SuspendAllSessions_Params_Data>(index_);
    }
    MediaControllerManager_SuspendAllSessions_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaControllerManager_SuspendAllSessions_Params_Data();
  ~MediaControllerManager_SuspendAllSessions_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_SuspendAllSessions_Params_Data) == 8,
              "Bad sizeof(MediaControllerManager_SuspendAllSessions_Params_Data)");
class  MediaController_Suspend_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_Suspend_Params_Data));
      new (data()) MediaController_Suspend_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_Suspend_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_Suspend_Params_Data>(index_);
    }
    MediaController_Suspend_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_Suspend_Params_Data();
  ~MediaController_Suspend_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Suspend_Params_Data) == 8,
              "Bad sizeof(MediaController_Suspend_Params_Data)");
class  MediaController_Resume_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_Resume_Params_Data));
      new (data()) MediaController_Resume_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_Resume_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_Resume_Params_Data>(index_);
    }
    MediaController_Resume_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_Resume_Params_Data();
  ~MediaController_Resume_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Resume_Params_Data) == 8,
              "Bad sizeof(MediaController_Resume_Params_Data)");
class  MediaController_Stop_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_Stop_Params_Data));
      new (data()) MediaController_Stop_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_Stop_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_Stop_Params_Data>(index_);
    }
    MediaController_Stop_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_Stop_Params_Data();
  ~MediaController_Stop_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Stop_Params_Data) == 8,
              "Bad sizeof(MediaController_Stop_Params_Data)");
class  MediaController_ToggleSuspendResume_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_ToggleSuspendResume_Params_Data));
      new (data()) MediaController_ToggleSuspendResume_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_ToggleSuspendResume_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_ToggleSuspendResume_Params_Data>(index_);
    }
    MediaController_ToggleSuspendResume_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_ToggleSuspendResume_Params_Data();
  ~MediaController_ToggleSuspendResume_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ToggleSuspendResume_Params_Data) == 8,
              "Bad sizeof(MediaController_ToggleSuspendResume_Params_Data)");
class  MediaController_AddObserver_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_AddObserver_Params_Data));
      new (data()) MediaController_AddObserver_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_AddObserver_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_AddObserver_Params_Data>(index_);
    }
    MediaController_AddObserver_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data observer;

 private:
  MediaController_AddObserver_Params_Data();
  ~MediaController_AddObserver_Params_Data() = delete;
};
static_assert(sizeof(MediaController_AddObserver_Params_Data) == 16,
              "Bad sizeof(MediaController_AddObserver_Params_Data)");
class  MediaController_PreviousTrack_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_PreviousTrack_Params_Data));
      new (data()) MediaController_PreviousTrack_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_PreviousTrack_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_PreviousTrack_Params_Data>(index_);
    }
    MediaController_PreviousTrack_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_PreviousTrack_Params_Data();
  ~MediaController_PreviousTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaController_PreviousTrack_Params_Data) == 8,
              "Bad sizeof(MediaController_PreviousTrack_Params_Data)");
class  MediaController_NextTrack_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_NextTrack_Params_Data));
      new (data()) MediaController_NextTrack_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_NextTrack_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_NextTrack_Params_Data>(index_);
    }
    MediaController_NextTrack_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_NextTrack_Params_Data();
  ~MediaController_NextTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaController_NextTrack_Params_Data) == 8,
              "Bad sizeof(MediaController_NextTrack_Params_Data)");
class  MediaController_Seek_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_Seek_Params_Data));
      new (data()) MediaController_Seek_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_Seek_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_Seek_Params_Data>(index_);
    }
    MediaController_Seek_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  MediaController_Seek_Params_Data();
  ~MediaController_Seek_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Seek_Params_Data) == 16,
              "Bad sizeof(MediaController_Seek_Params_Data)");
class  MediaController_ObserveImages_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_ObserveImages_Params_Data));
      new (data()) MediaController_ObserveImages_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_ObserveImages_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_ObserveImages_Params_Data>(index_);
    }
    MediaController_ObserveImages_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t minimum_size_px;
  int32_t desired_size_px;
  mojo::internal::Interface_Data observer;
  uint8_t padfinal_[4];

 private:
  MediaController_ObserveImages_Params_Data();
  ~MediaController_ObserveImages_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ObserveImages_Params_Data) == 32,
              "Bad sizeof(MediaController_ObserveImages_Params_Data)");
class  MediaController_SeekTo_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_SeekTo_Params_Data));
      new (data()) MediaController_SeekTo_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_SeekTo_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_SeekTo_Params_Data>(index_);
    }
    MediaController_SeekTo_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  MediaController_SeekTo_Params_Data();
  ~MediaController_SeekTo_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SeekTo_Params_Data) == 16,
              "Bad sizeof(MediaController_SeekTo_Params_Data)");
class  MediaController_ScrubTo_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_ScrubTo_Params_Data));
      new (data()) MediaController_ScrubTo_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_ScrubTo_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_ScrubTo_Params_Data>(index_);
    }
    MediaController_ScrubTo_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  MediaController_ScrubTo_Params_Data();
  ~MediaController_ScrubTo_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ScrubTo_Params_Data) == 16,
              "Bad sizeof(MediaController_ScrubTo_Params_Data)");
class  MediaController_EnterPictureInPicture_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_EnterPictureInPicture_Params_Data));
      new (data()) MediaController_EnterPictureInPicture_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_EnterPictureInPicture_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_EnterPictureInPicture_Params_Data>(index_);
    }
    MediaController_EnterPictureInPicture_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_EnterPictureInPicture_Params_Data();
  ~MediaController_EnterPictureInPicture_Params_Data() = delete;
};
static_assert(sizeof(MediaController_EnterPictureInPicture_Params_Data) == 8,
              "Bad sizeof(MediaController_EnterPictureInPicture_Params_Data)");
class  MediaController_ExitPictureInPicture_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_ExitPictureInPicture_Params_Data));
      new (data()) MediaController_ExitPictureInPicture_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_ExitPictureInPicture_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_ExitPictureInPicture_Params_Data>(index_);
    }
    MediaController_ExitPictureInPicture_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  MediaController_ExitPictureInPicture_Params_Data();
  ~MediaController_ExitPictureInPicture_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ExitPictureInPicture_Params_Data) == 8,
              "Bad sizeof(MediaController_ExitPictureInPicture_Params_Data)");
class  MediaController_SetAudioSinkId_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaController_SetAudioSinkId_Params_Data));
      new (data()) MediaController_SetAudioSinkId_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaController_SetAudioSinkId_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaController_SetAudioSinkId_Params_Data>(index_);
    }
    MediaController_SetAudioSinkId_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;

 private:
  MediaController_SetAudioSinkId_Params_Data();
  ~MediaController_SetAudioSinkId_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SetAudioSinkId_Params_Data) == 16,
              "Bad sizeof(MediaController_SetAudioSinkId_Params_Data)");
class  MediaControllerObserver_MediaSessionInfoChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerObserver_MediaSessionInfoChanged_Params_Data));
      new (data()) MediaControllerObserver_MediaSessionInfoChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerObserver_MediaSessionInfoChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerObserver_MediaSessionInfoChanged_Params_Data>(index_);
    }
    MediaControllerObserver_MediaSessionInfoChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaSessionInfo_Data> info;

 private:
  MediaControllerObserver_MediaSessionInfoChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionInfoChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionInfoChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionInfoChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionMetadataChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerObserver_MediaSessionMetadataChanged_Params_Data));
      new (data()) MediaControllerObserver_MediaSessionMetadataChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerObserver_MediaSessionMetadataChanged_Params_Data>(index_);
    }
    MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaMetadata_Data> metadata;

 private:
  MediaControllerObserver_MediaSessionMetadataChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionMetadataChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionMetadataChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionMetadataChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionActionsChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerObserver_MediaSessionActionsChanged_Params_Data));
      new (data()) MediaControllerObserver_MediaSessionActionsChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerObserver_MediaSessionActionsChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerObserver_MediaSessionActionsChanged_Params_Data>(index_);
    }
    MediaControllerObserver_MediaSessionActionsChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> action;

 private:
  MediaControllerObserver_MediaSessionActionsChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionActionsChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionActionsChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionActionsChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerObserver_MediaSessionChanged_Params_Data));
      new (data()) MediaControllerObserver_MediaSessionChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerObserver_MediaSessionChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerObserver_MediaSessionChanged_Params_Data>(index_);
    }
    MediaControllerObserver_MediaSessionChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> request_id;

 private:
  MediaControllerObserver_MediaSessionChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionPositionChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerObserver_MediaSessionPositionChanged_Params_Data));
      new (data()) MediaControllerObserver_MediaSessionPositionChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerObserver_MediaSessionPositionChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerObserver_MediaSessionPositionChanged_Params_Data>(index_);
    }
    MediaControllerObserver_MediaSessionPositionChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaPosition_Data> position;

 private:
  MediaControllerObserver_MediaSessionPositionChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionPositionChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionPositionChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionPositionChanged_Params_Data)");
class  MediaControllerImageObserver_MediaControllerImageChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MediaControllerImageObserver_MediaControllerImageChanged_Params_Data));
      new (data()) MediaControllerImageObserver_MediaControllerImageChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MediaControllerImageObserver_MediaControllerImageChanged_Params_Data>(index_);
    }
    MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media_session::mojom::internal::MediaImageBitmap_Data> bitmap;

 private:
  MediaControllerImageObserver_MediaControllerImageChanged_Params_Data();
  ~MediaControllerImageObserver_MediaControllerImageChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerImageObserver_MediaControllerImageChanged_Params_Data) == 24,
              "Bad sizeof(MediaControllerImageObserver_MediaControllerImageChanged_Params_Data)");

}  // namespace internal


class MediaControllerManager_CreateMediaControllerForSession_ParamsDataView {
 public:
  MediaControllerManager_CreateMediaControllerForSession_ParamsDataView() {}

  MediaControllerManager_CreateMediaControllerForSession_ParamsDataView(
      internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerManager_CreateActiveMediaController_ParamsDataView {
 public:
  MediaControllerManager_CreateActiveMediaController_ParamsDataView() {}

  MediaControllerManager_CreateActiveMediaController_ParamsDataView(
      internal::MediaControllerManager_CreateActiveMediaController_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaControllerManager_CreateActiveMediaController_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerManager_SuspendAllSessions_ParamsDataView {
 public:
  MediaControllerManager_SuspendAllSessions_ParamsDataView() {}

  MediaControllerManager_SuspendAllSessions_ParamsDataView(
      internal::MediaControllerManager_SuspendAllSessions_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaControllerManager_SuspendAllSessions_Params_Data* data_ = nullptr;
};



class MediaController_Suspend_ParamsDataView {
 public:
  MediaController_Suspend_ParamsDataView() {}

  MediaController_Suspend_ParamsDataView(
      internal::MediaController_Suspend_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Suspend_Params_Data* data_ = nullptr;
};



class MediaController_Resume_ParamsDataView {
 public:
  MediaController_Resume_ParamsDataView() {}

  MediaController_Resume_ParamsDataView(
      internal::MediaController_Resume_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Resume_Params_Data* data_ = nullptr;
};



class MediaController_Stop_ParamsDataView {
 public:
  MediaController_Stop_ParamsDataView() {}

  MediaController_Stop_ParamsDataView(
      internal::MediaController_Stop_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Stop_Params_Data* data_ = nullptr;
};



class MediaController_ToggleSuspendResume_ParamsDataView {
 public:
  MediaController_ToggleSuspendResume_ParamsDataView() {}

  MediaController_ToggleSuspendResume_ParamsDataView(
      internal::MediaController_ToggleSuspendResume_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ToggleSuspendResume_Params_Data* data_ = nullptr;
};



class MediaController_AddObserver_ParamsDataView {
 public:
  MediaController_AddObserver_ParamsDataView() {}

  MediaController_AddObserver_ParamsDataView(
      internal::MediaController_AddObserver_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerObserverInterfaceBase>>(
            &data_->observer, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaController_AddObserver_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaController_PreviousTrack_ParamsDataView {
 public:
  MediaController_PreviousTrack_ParamsDataView() {}

  MediaController_PreviousTrack_ParamsDataView(
      internal::MediaController_PreviousTrack_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_PreviousTrack_Params_Data* data_ = nullptr;
};



class MediaController_NextTrack_ParamsDataView {
 public:
  MediaController_NextTrack_ParamsDataView() {}

  MediaController_NextTrack_ParamsDataView(
      internal::MediaController_NextTrack_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_NextTrack_Params_Data* data_ = nullptr;
};



class MediaController_Seek_ParamsDataView {
 public:
  MediaController_Seek_ParamsDataView() {}

  MediaController_Seek_ParamsDataView(
      internal::MediaController_Seek_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaController_Seek_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaController_ObserveImages_ParamsDataView {
 public:
  MediaController_ObserveImages_ParamsDataView() {}

  MediaController_ObserveImages_ParamsDataView(
      internal::MediaController_ObserveImages_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionImageType>(
        data_value, output);
  }

  ::media_session::mojom::MediaSessionImageType type() const {
    return static_cast<::media_session::mojom::MediaSessionImageType>(data_->type);
  }
  int32_t minimum_size_px() const {
    return data_->minimum_size_px;
  }
  int32_t desired_size_px() const {
    return data_->desired_size_px;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerImageObserverInterfaceBase>>(
            &data_->observer, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaController_ObserveImages_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaController_SeekTo_ParamsDataView {
 public:
  MediaController_SeekTo_ParamsDataView() {}

  MediaController_SeekTo_ParamsDataView(
      internal::MediaController_SeekTo_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaController_SeekTo_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaController_ScrubTo_ParamsDataView {
 public:
  MediaController_ScrubTo_ParamsDataView() {}

  MediaController_ScrubTo_ParamsDataView(
      internal::MediaController_ScrubTo_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaController_ScrubTo_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaController_EnterPictureInPicture_ParamsDataView {
 public:
  MediaController_EnterPictureInPicture_ParamsDataView() {}

  MediaController_EnterPictureInPicture_ParamsDataView(
      internal::MediaController_EnterPictureInPicture_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_EnterPictureInPicture_Params_Data* data_ = nullptr;
};



class MediaController_ExitPictureInPicture_ParamsDataView {
 public:
  MediaController_ExitPictureInPicture_ParamsDataView() {}

  MediaController_ExitPictureInPicture_ParamsDataView(
      internal::MediaController_ExitPictureInPicture_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ExitPictureInPicture_Params_Data* data_ = nullptr;
};



class MediaController_SetAudioSinkId_ParamsDataView {
 public:
  MediaController_SetAudioSinkId_ParamsDataView() {}

  MediaController_SetAudioSinkId_ParamsDataView(
      internal::MediaController_SetAudioSinkId_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaController_SetAudioSinkId_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView() {}

  MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::media_session::mojom::MediaSessionInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaSessionInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView() {}

  MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMetadataDataView(
      ::media_session::mojom::MediaMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaMetadataDataView, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaMetadataDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView() {}

  MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerObserver_MediaSessionChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionChanged_ParamsDataView() {}

  MediaControllerObserver_MediaSessionChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestId` instead "
    "of `ReadRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView() {}

  MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPositionDataView(
      ::media_session::mojom::MediaPositionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaPositionDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaPositionDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView {
 public:
  MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView() {}

  MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView(
      internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionImageType>(
        data_value, output);
  }

  ::media_session::mojom::MediaSessionImageType type() const {
    return static_cast<::media_session::mojom::MediaSessionImageType>(data_->type);
  }
  inline void GetBitmapDataView(
      ::media_session::mojom::MediaImageBitmapDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaImageBitmapDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaImageBitmapDataView>(
        pointer, output, context_);
  }
 private:
  internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void MediaControllerManager_CreateMediaControllerForSession_ParamsDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}




















inline void MediaController_Seek_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}




inline void MediaController_SeekTo_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}


inline void MediaController_ScrubTo_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}






inline void MediaController_SetAudioSinkId_ParamsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView::GetInfoDataView(
    ::media_session::mojom::MediaSessionInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::media_session::mojom::MediaSessionInfoDataView(pointer, context_);
}


inline void MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView::GetMetadataDataView(
    ::media_session::mojom::MediaMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::media_session::mojom::MediaMetadataDataView(pointer, context_);
}


inline void MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView::GetActionDataView(
    mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>* output) {
  auto pointer = data_->action.Get();
  *output = mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>(pointer, context_);
}


inline void MediaControllerObserver_MediaSessionChanged_ParamsDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView::GetPositionDataView(
    ::media_session::mojom::MediaPositionDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::media_session::mojom::MediaPositionDataView(pointer, context_);
}


inline void MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView::GetBitmapDataView(
    ::media_session::mojom::MediaImageBitmapDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::media_session::mojom::MediaImageBitmapDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace media_session

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_