// services/network/public/mojom/data_pipe_getter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DATA_PIPE_GETTER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DATA_PIPE_GETTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class DataPipeGetterProxy;

template <typename ImplRefTraits>
class DataPipeGetterStub;

class DataPipeGetterRequestValidator;
class DataPipeGetterResponseValidator;


class  DataPipeGetter
    : public DataPipeGetterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DataPipeGetterInterfaceBase;
  using Proxy_ = DataPipeGetterProxy;

  template <typename ImplRefTraits>
  using Stub_ = DataPipeGetterStub<ImplRefTraits>;

  using RequestValidator_ = DataPipeGetterRequestValidator;
  using ResponseValidator_ = DataPipeGetterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kCloneMinVersion = 0,
  };
  virtual ~DataPipeGetter() {}


  using ReadCallback = base::OnceCallback<void(int32_t, uint64_t)>;
  
  virtual void Read(::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<DataPipeGetter> receiver) = 0;
};



class  DataPipeGetterProxy
    : public DataPipeGetter {
 public:
  using InterfaceType = DataPipeGetter;

  explicit DataPipeGetterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<DataPipeGetter> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DataPipeGetterStubDispatch {
 public:
  static bool Accept(DataPipeGetter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DataPipeGetter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DataPipeGetter>>
class DataPipeGetterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DataPipeGetterStub() {}
  ~DataPipeGetterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataPipeGetterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataPipeGetterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DataPipeGetterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DataPipeGetterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DATA_PIPE_GETTER_MOJOM_H_