// services/network/public/mojom/isolation_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-forward.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/isolation_info_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {








class  IsolationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IsolationInfo, T>::value>;
  using DataView = IsolationInfoDataView;
  using Data_ = internal::IsolationInfo_Data;

  template <typename... Args>
  static IsolationInfoPtr New(Args&&... args) {
    return IsolationInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IsolationInfoPtr From(const U& u) {
    return mojo::TypeConverter<IsolationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IsolationInfo>::Convert(*this);
  }


  IsolationInfo();

  IsolationInfo(
      IsolationInfoRedirectMode redirect_mode,
      const base::Optional<::url::Origin>& top_frame_origin,
      const base::Optional<::url::Origin>& frame_origin,
      bool opaque_and_non_transient,
      const ::net::SiteForCookies& site_for_cookies);

  ~IsolationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IsolationInfoPtr>
  IsolationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IsolationInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IsolationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IsolationInfo_UnserializedMessageContext<
            UserType, IsolationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IsolationInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return IsolationInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IsolationInfo_UnserializedMessageContext<
            UserType, IsolationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IsolationInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  IsolationInfoRedirectMode redirect_mode;
  
  base::Optional<::url::Origin> top_frame_origin;
  
  base::Optional<::url::Origin> frame_origin;
  
  bool opaque_and_non_transient;
  
  ::net::SiteForCookies site_for_cookies;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IsolationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IsolationInfoPtr IsolationInfo::Clone() const {
  return New(
      mojo::Clone(redirect_mode),
      mojo::Clone(top_frame_origin),
      mojo::Clone(frame_origin),
      mojo::Clone(opaque_and_non_transient),
      mojo::Clone(site_for_cookies)
  );
}

template <typename T, IsolationInfo::EnableIfSame<T>*>
bool IsolationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->redirect_mode, other_struct.redirect_mode))
    return false;
  if (!mojo::Equals(this->top_frame_origin, other_struct.top_frame_origin))
    return false;
  if (!mojo::Equals(this->frame_origin, other_struct.frame_origin))
    return false;
  if (!mojo::Equals(this->opaque_and_non_transient, other_struct.opaque_and_non_transient))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  return true;
}

template <typename T, IsolationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.redirect_mode, rhs.redirect_mode))
    return true;
  if (std::less<>{}(rhs.redirect_mode, lhs.redirect_mode))
    return false;
  if (std::less<>{}(lhs.top_frame_origin, rhs.top_frame_origin))
    return true;
  if (std::less<>{}(rhs.top_frame_origin, lhs.top_frame_origin))
    return false;
  if (std::less<>{}(lhs.frame_origin, rhs.frame_origin))
    return true;
  if (std::less<>{}(rhs.frame_origin, lhs.frame_origin))
    return false;
  if (std::less<>{}(lhs.opaque_and_non_transient, rhs.opaque_and_non_transient))
    return true;
  if (std::less<>{}(rhs.opaque_and_non_transient, lhs.opaque_and_non_transient))
    return false;
  if (std::less<>{}(lhs.site_for_cookies, rhs.site_for_cookies))
    return true;
  if (std::less<>{}(rhs.site_for_cookies, lhs.site_for_cookies))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::IsolationInfo::DataView,
                                         ::network::mojom::IsolationInfoPtr> {
  static bool IsNull(const ::network::mojom::IsolationInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::IsolationInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::IsolationInfo::redirect_mode) redirect_mode(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->redirect_mode;
  }

  static const decltype(::network::mojom::IsolationInfo::top_frame_origin)& top_frame_origin(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->top_frame_origin;
  }

  static const decltype(::network::mojom::IsolationInfo::frame_origin)& frame_origin(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->frame_origin;
  }

  static decltype(::network::mojom::IsolationInfo::opaque_and_non_transient) opaque_and_non_transient(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->opaque_and_non_transient;
  }

  static const decltype(::network::mojom::IsolationInfo::site_for_cookies)& site_for_cookies(
      const ::network::mojom::IsolationInfoPtr& input) {
    return input->site_for_cookies;
  }

  static bool Read(::network::mojom::IsolationInfo::DataView input, ::network::mojom::IsolationInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_H_