// services/network/public/mojom/parsed_headers.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/parsed_headers.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/parsed_headers.mojom-params-data.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-message-ids.h"

#include "services/network/public/mojom/parsed_headers.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ParsedHeaders::ParsedHeaders()
    : content_security_policy(),
      allow_csp_from(),
      cross_origin_embedder_policy(),
      cross_origin_opener_policy(),
      origin_isolation(false),
      accept_ch(),
      accept_ch_lifetime() {}

ParsedHeaders::ParsedHeaders(
    WTF::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policy_in,
    ::network::mojom::blink::AllowCSPFromHeaderValuePtr allow_csp_from_in,
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    const ::network::CrossOriginOpenerPolicy& cross_origin_opener_policy_in,
    bool origin_isolation_in,
    base::Optional<WTF::Vector<::network::mojom::blink::WebClientHintsType>> accept_ch_in,
    ::base::TimeDelta accept_ch_lifetime_in)
    : content_security_policy(std::move(content_security_policy_in)),
      allow_csp_from(std::move(allow_csp_from_in)),
      cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      cross_origin_opener_policy(std::move(cross_origin_opener_policy_in)),
      origin_isolation(std::move(origin_isolation_in)),
      accept_ch(std::move(accept_ch_in)),
      accept_ch_lifetime(std::move(accept_ch_lifetime_in)) {}

ParsedHeaders::~ParsedHeaders() = default;

void ParsedHeaders::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("content_security_policy");
  for (const auto& item0 : this->content_security_policy) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("allow_csp_from", base::trace_event::ValueToString(this->allow_csp_from, "<value of type ::network::mojom::blink::AllowCSPFromHeaderValuePtr>"));
  value->SetString("cross_origin_embedder_policy", base::trace_event::ValueToString(this->cross_origin_embedder_policy, "<value of type const ::network::CrossOriginEmbedderPolicy&>"));
  value->SetString("cross_origin_opener_policy", base::trace_event::ValueToString(this->cross_origin_opener_policy, "<value of type const ::network::CrossOriginOpenerPolicy&>"));
  value->SetBoolean("origin_isolation", this->origin_isolation);
  if (this->accept_ch.has_value()) {
    value->BeginArray("accept_ch");
    for (const auto& item0 : this->accept_ch.value()) {
      value->AppendString(base::trace_event::ValueToString(item0));
    }
    value->EndArray();
  } else {
    value->SetString("accept_ch", "base::nullopt");
  }
  value->SetString("accept_ch_lifetime", base::trace_event::ValueToString(this->accept_ch_lifetime, "<value of type ::base::TimeDelta>"));
}

bool ParsedHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ParsedHeaders::DataView, ::network::mojom::blink::ParsedHeadersPtr>::Read(
    ::network::mojom::blink::ParsedHeaders::DataView input,
    ::network::mojom::blink::ParsedHeadersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ParsedHeadersPtr result(::network::mojom::blink::ParsedHeaders::New());
  
      if (success && !input.ReadContentSecurityPolicy(&result->content_security_policy))
        success = false;
      if (success && !input.ReadAllowCspFrom(&result->allow_csp_from))
        success = false;
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success && !input.ReadCrossOriginOpenerPolicy(&result->cross_origin_opener_policy))
        success = false;
      if (success)
        result->origin_isolation = input.origin_isolation();
      if (success && !input.ReadAcceptCh(&result->accept_ch))
        success = false;
      if (success && !input.ReadAcceptChLifetime(&result->accept_ch_lifetime))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif