// services/network/public/mojom/url_response_head.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "services/network/public/mojom/origin_policy_manager.mojom.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {








class  URLResponseHead {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLResponseHead, T>::value>;
  using DataView = URLResponseHeadDataView;
  using Data_ = internal::URLResponseHead_Data;

  template <typename... Args>
  static URLResponseHeadPtr New(Args&&... args) {
    return URLResponseHeadPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLResponseHeadPtr From(const U& u) {
    return mojo::TypeConverter<URLResponseHeadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLResponseHead>::Convert(*this);
  }


  URLResponseHead();

  URLResponseHead(
      ::base::Time request_time,
      ::base::Time response_time,
      const ::scoped_refptr<::net::HttpResponseHeaders>& headers,
      const std::string& mime_type,
      const std::string& charset,
      ::net::ct::CTPolicyCompliance ct_policy_compliance,
      int64_t content_length,
      int64_t encoded_data_length,
      int64_t encoded_body_length,
      bool network_accessed,
      int64_t appcache_id,
      const ::GURL& appcache_manifest_url,
      const ::net::LoadTimingInfo& load_timing,
      ::network::mojom::HttpRawRequestResponseInfoPtr raw_request_response_info,
      bool was_fetched_via_spdy,
      bool was_alpn_negotiated,
      bool was_alternate_protocol_available,
      ::net::HttpResponseInfo::ConnectionInfo connection_info,
      const std::string& alpn_negotiated_protocol,
      const ::net::IPEndPoint& remote_endpoint,
      bool was_fetched_via_cache,
      const ::net::ProxyServer& proxy_server,
      bool was_fetched_via_service_worker,
      ::network::mojom::FetchResponseSource service_worker_response_source,
      bool was_fallback_required_by_service_worker,
      std::vector<::GURL> url_list_via_service_worker,
      ::network::mojom::FetchResponseType response_type,
      int64_t padding,
      const std::string& cache_storage_cache_name,
      uint32_t cert_status,
      const base::Optional<::net::SSLInfo>& ssl_info,
      std::vector<std::string> cors_exposed_header_names,
      bool did_service_worker_navigation_preload,
      bool should_report_corb_blocking,
      bool async_revalidation_requested,
      bool did_mime_sniff,
      bool is_signed_exchange_inner_response,
      bool was_in_prefetch_cache,
      bool was_cookie_in_request,
      bool intercepted_by_plugin,
      bool is_legacy_tls_version,
      bool has_range_requested,
      bool timing_allow_passed,
      const base::Optional<::net::AuthChallengeInfo>& auth_challenge_info,
      ::base::TimeTicks request_start,
      ::base::TimeTicks response_start,
      ::network::mojom::ParsedHeadersPtr parsed_headers,
      const base::Optional<::network::OriginPolicy>& origin_policy,
      const base::Optional<::base::UnguessableToken>& recursive_prefetch_token);

  ~URLResponseHead();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLResponseHeadPtr>
  URLResponseHeadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLResponseHead::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLResponseHead::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLResponseHead_UnserializedMessageContext<
            UserType, URLResponseHead::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLResponseHead::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return URLResponseHead::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLResponseHead_UnserializedMessageContext<
            UserType, URLResponseHead::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLResponseHead::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::Time request_time;
  
  ::base::Time response_time;
  
  ::scoped_refptr<::net::HttpResponseHeaders> headers;
  
  std::string mime_type;
  
  std::string charset;
  
  ::net::ct::CTPolicyCompliance ct_policy_compliance;
  
  int64_t content_length;
  
  int64_t encoded_data_length;
  
  int64_t encoded_body_length;
  
  bool network_accessed;
  
  int64_t appcache_id;
  
  ::GURL appcache_manifest_url;
  
  ::net::LoadTimingInfo load_timing;
  
  ::network::mojom::HttpRawRequestResponseInfoPtr raw_request_response_info;
  
  bool was_fetched_via_spdy;
  
  bool was_alpn_negotiated;
  
  bool was_alternate_protocol_available;
  
  ::net::HttpResponseInfo::ConnectionInfo connection_info;
  
  std::string alpn_negotiated_protocol;
  
  ::net::IPEndPoint remote_endpoint;
  
  bool was_fetched_via_cache;
  
  ::net::ProxyServer proxy_server;
  
  bool was_fetched_via_service_worker;
  
  ::network::mojom::FetchResponseSource service_worker_response_source;
  
  bool was_fallback_required_by_service_worker;
  
  std::vector<::GURL> url_list_via_service_worker;
  
  ::network::mojom::FetchResponseType response_type;
  
  int64_t padding;
  
  std::string cache_storage_cache_name;
  
  uint32_t cert_status;
  
  base::Optional<::net::SSLInfo> ssl_info;
  
  std::vector<std::string> cors_exposed_header_names;
  
  bool did_service_worker_navigation_preload;
  
  bool should_report_corb_blocking;
  
  bool async_revalidation_requested;
  
  bool did_mime_sniff;
  
  bool is_signed_exchange_inner_response;
  
  bool was_in_prefetch_cache;
  
  bool was_cookie_in_request;
  
  bool intercepted_by_plugin;
  
  bool is_legacy_tls_version;
  
  bool has_range_requested;
  
  bool timing_allow_passed;
  
  base::Optional<::net::AuthChallengeInfo> auth_challenge_info;
  
  ::base::TimeTicks request_start;
  
  ::base::TimeTicks response_start;
  
  ::network::mojom::ParsedHeadersPtr parsed_headers;
  
  base::Optional<::network::OriginPolicy> origin_policy;
  
  base::Optional<::base::UnguessableToken> recursive_prefetch_token;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLResponseHead);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLResponseHead::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
URLResponseHeadPtr URLResponseHead::Clone() const {
  return New(
      mojo::Clone(request_time),
      mojo::Clone(response_time),
      mojo::Clone(headers),
      mojo::Clone(mime_type),
      mojo::Clone(charset),
      mojo::Clone(ct_policy_compliance),
      mojo::Clone(content_length),
      mojo::Clone(encoded_data_length),
      mojo::Clone(encoded_body_length),
      mojo::Clone(network_accessed),
      mojo::Clone(appcache_id),
      mojo::Clone(appcache_manifest_url),
      mojo::Clone(load_timing),
      mojo::Clone(raw_request_response_info),
      mojo::Clone(was_fetched_via_spdy),
      mojo::Clone(was_alpn_negotiated),
      mojo::Clone(was_alternate_protocol_available),
      mojo::Clone(connection_info),
      mojo::Clone(alpn_negotiated_protocol),
      mojo::Clone(remote_endpoint),
      mojo::Clone(was_fetched_via_cache),
      mojo::Clone(proxy_server),
      mojo::Clone(was_fetched_via_service_worker),
      mojo::Clone(service_worker_response_source),
      mojo::Clone(was_fallback_required_by_service_worker),
      mojo::Clone(url_list_via_service_worker),
      mojo::Clone(response_type),
      mojo::Clone(padding),
      mojo::Clone(cache_storage_cache_name),
      mojo::Clone(cert_status),
      mojo::Clone(ssl_info),
      mojo::Clone(cors_exposed_header_names),
      mojo::Clone(did_service_worker_navigation_preload),
      mojo::Clone(should_report_corb_blocking),
      mojo::Clone(async_revalidation_requested),
      mojo::Clone(did_mime_sniff),
      mojo::Clone(is_signed_exchange_inner_response),
      mojo::Clone(was_in_prefetch_cache),
      mojo::Clone(was_cookie_in_request),
      mojo::Clone(intercepted_by_plugin),
      mojo::Clone(is_legacy_tls_version),
      mojo::Clone(has_range_requested),
      mojo::Clone(timing_allow_passed),
      mojo::Clone(auth_challenge_info),
      mojo::Clone(request_start),
      mojo::Clone(response_start),
      mojo::Clone(parsed_headers),
      mojo::Clone(origin_policy),
      mojo::Clone(recursive_prefetch_token)
  );
}

template <typename T, URLResponseHead::EnableIfSame<T>*>
bool URLResponseHead::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_time, other_struct.request_time))
    return false;
  if (!mojo::Equals(this->response_time, other_struct.response_time))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->charset, other_struct.charset))
    return false;
  if (!mojo::Equals(this->ct_policy_compliance, other_struct.ct_policy_compliance))
    return false;
  if (!mojo::Equals(this->content_length, other_struct.content_length))
    return false;
  if (!mojo::Equals(this->encoded_data_length, other_struct.encoded_data_length))
    return false;
  if (!mojo::Equals(this->encoded_body_length, other_struct.encoded_body_length))
    return false;
  if (!mojo::Equals(this->network_accessed, other_struct.network_accessed))
    return false;
  if (!mojo::Equals(this->appcache_id, other_struct.appcache_id))
    return false;
  if (!mojo::Equals(this->appcache_manifest_url, other_struct.appcache_manifest_url))
    return false;
  if (!mojo::Equals(this->load_timing, other_struct.load_timing))
    return false;
  if (!mojo::Equals(this->raw_request_response_info, other_struct.raw_request_response_info))
    return false;
  if (!mojo::Equals(this->was_fetched_via_spdy, other_struct.was_fetched_via_spdy))
    return false;
  if (!mojo::Equals(this->was_alpn_negotiated, other_struct.was_alpn_negotiated))
    return false;
  if (!mojo::Equals(this->was_alternate_protocol_available, other_struct.was_alternate_protocol_available))
    return false;
  if (!mojo::Equals(this->connection_info, other_struct.connection_info))
    return false;
  if (!mojo::Equals(this->alpn_negotiated_protocol, other_struct.alpn_negotiated_protocol))
    return false;
  if (!mojo::Equals(this->remote_endpoint, other_struct.remote_endpoint))
    return false;
  if (!mojo::Equals(this->was_fetched_via_cache, other_struct.was_fetched_via_cache))
    return false;
  if (!mojo::Equals(this->proxy_server, other_struct.proxy_server))
    return false;
  if (!mojo::Equals(this->was_fetched_via_service_worker, other_struct.was_fetched_via_service_worker))
    return false;
  if (!mojo::Equals(this->service_worker_response_source, other_struct.service_worker_response_source))
    return false;
  if (!mojo::Equals(this->was_fallback_required_by_service_worker, other_struct.was_fallback_required_by_service_worker))
    return false;
  if (!mojo::Equals(this->url_list_via_service_worker, other_struct.url_list_via_service_worker))
    return false;
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->padding, other_struct.padding))
    return false;
  if (!mojo::Equals(this->cache_storage_cache_name, other_struct.cache_storage_cache_name))
    return false;
  if (!mojo::Equals(this->cert_status, other_struct.cert_status))
    return false;
  if (!mojo::Equals(this->ssl_info, other_struct.ssl_info))
    return false;
  if (!mojo::Equals(this->cors_exposed_header_names, other_struct.cors_exposed_header_names))
    return false;
  if (!mojo::Equals(this->did_service_worker_navigation_preload, other_struct.did_service_worker_navigation_preload))
    return false;
  if (!mojo::Equals(this->should_report_corb_blocking, other_struct.should_report_corb_blocking))
    return false;
  if (!mojo::Equals(this->async_revalidation_requested, other_struct.async_revalidation_requested))
    return false;
  if (!mojo::Equals(this->did_mime_sniff, other_struct.did_mime_sniff))
    return false;
  if (!mojo::Equals(this->is_signed_exchange_inner_response, other_struct.is_signed_exchange_inner_response))
    return false;
  if (!mojo::Equals(this->was_in_prefetch_cache, other_struct.was_in_prefetch_cache))
    return false;
  if (!mojo::Equals(this->was_cookie_in_request, other_struct.was_cookie_in_request))
    return false;
  if (!mojo::Equals(this->intercepted_by_plugin, other_struct.intercepted_by_plugin))
    return false;
  if (!mojo::Equals(this->is_legacy_tls_version, other_struct.is_legacy_tls_version))
    return false;
  if (!mojo::Equals(this->has_range_requested, other_struct.has_range_requested))
    return false;
  if (!mojo::Equals(this->timing_allow_passed, other_struct.timing_allow_passed))
    return false;
  if (!mojo::Equals(this->auth_challenge_info, other_struct.auth_challenge_info))
    return false;
  if (!mojo::Equals(this->request_start, other_struct.request_start))
    return false;
  if (!mojo::Equals(this->response_start, other_struct.response_start))
    return false;
  if (!mojo::Equals(this->parsed_headers, other_struct.parsed_headers))
    return false;
  if (!mojo::Equals(this->origin_policy, other_struct.origin_policy))
    return false;
  if (!mojo::Equals(this->recursive_prefetch_token, other_struct.recursive_prefetch_token))
    return false;
  return true;
}

template <typename T, URLResponseHead::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_time, rhs.request_time))
    return true;
  if (std::less<>{}(rhs.request_time, lhs.request_time))
    return false;
  if (std::less<>{}(lhs.response_time, rhs.response_time))
    return true;
  if (std::less<>{}(rhs.response_time, lhs.response_time))
    return false;
  if (std::less<>{}(lhs.headers, rhs.headers))
    return true;
  if (std::less<>{}(rhs.headers, lhs.headers))
    return false;
  if (std::less<>{}(lhs.mime_type, rhs.mime_type))
    return true;
  if (std::less<>{}(rhs.mime_type, lhs.mime_type))
    return false;
  if (std::less<>{}(lhs.charset, rhs.charset))
    return true;
  if (std::less<>{}(rhs.charset, lhs.charset))
    return false;
  if (std::less<>{}(lhs.ct_policy_compliance, rhs.ct_policy_compliance))
    return true;
  if (std::less<>{}(rhs.ct_policy_compliance, lhs.ct_policy_compliance))
    return false;
  if (std::less<>{}(lhs.content_length, rhs.content_length))
    return true;
  if (std::less<>{}(rhs.content_length, lhs.content_length))
    return false;
  if (std::less<>{}(lhs.encoded_data_length, rhs.encoded_data_length))
    return true;
  if (std::less<>{}(rhs.encoded_data_length, lhs.encoded_data_length))
    return false;
  if (std::less<>{}(lhs.encoded_body_length, rhs.encoded_body_length))
    return true;
  if (std::less<>{}(rhs.encoded_body_length, lhs.encoded_body_length))
    return false;
  if (std::less<>{}(lhs.network_accessed, rhs.network_accessed))
    return true;
  if (std::less<>{}(rhs.network_accessed, lhs.network_accessed))
    return false;
  if (std::less<>{}(lhs.appcache_id, rhs.appcache_id))
    return true;
  if (std::less<>{}(rhs.appcache_id, lhs.appcache_id))
    return false;
  if (std::less<>{}(lhs.appcache_manifest_url, rhs.appcache_manifest_url))
    return true;
  if (std::less<>{}(rhs.appcache_manifest_url, lhs.appcache_manifest_url))
    return false;
  if (std::less<>{}(lhs.load_timing, rhs.load_timing))
    return true;
  if (std::less<>{}(rhs.load_timing, lhs.load_timing))
    return false;
  if (std::less<>{}(lhs.raw_request_response_info, rhs.raw_request_response_info))
    return true;
  if (std::less<>{}(rhs.raw_request_response_info, lhs.raw_request_response_info))
    return false;
  if (std::less<>{}(lhs.was_fetched_via_spdy, rhs.was_fetched_via_spdy))
    return true;
  if (std::less<>{}(rhs.was_fetched_via_spdy, lhs.was_fetched_via_spdy))
    return false;
  if (std::less<>{}(lhs.was_alpn_negotiated, rhs.was_alpn_negotiated))
    return true;
  if (std::less<>{}(rhs.was_alpn_negotiated, lhs.was_alpn_negotiated))
    return false;
  if (std::less<>{}(lhs.was_alternate_protocol_available, rhs.was_alternate_protocol_available))
    return true;
  if (std::less<>{}(rhs.was_alternate_protocol_available, lhs.was_alternate_protocol_available))
    return false;
  if (std::less<>{}(lhs.connection_info, rhs.connection_info))
    return true;
  if (std::less<>{}(rhs.connection_info, lhs.connection_info))
    return false;
  if (std::less<>{}(lhs.alpn_negotiated_protocol, rhs.alpn_negotiated_protocol))
    return true;
  if (std::less<>{}(rhs.alpn_negotiated_protocol, lhs.alpn_negotiated_protocol))
    return false;
  if (std::less<>{}(lhs.remote_endpoint, rhs.remote_endpoint))
    return true;
  if (std::less<>{}(rhs.remote_endpoint, lhs.remote_endpoint))
    return false;
  if (std::less<>{}(lhs.was_fetched_via_cache, rhs.was_fetched_via_cache))
    return true;
  if (std::less<>{}(rhs.was_fetched_via_cache, lhs.was_fetched_via_cache))
    return false;
  if (std::less<>{}(lhs.proxy_server, rhs.proxy_server))
    return true;
  if (std::less<>{}(rhs.proxy_server, lhs.proxy_server))
    return false;
  if (std::less<>{}(lhs.was_fetched_via_service_worker, rhs.was_fetched_via_service_worker))
    return true;
  if (std::less<>{}(rhs.was_fetched_via_service_worker, lhs.was_fetched_via_service_worker))
    return false;
  if (std::less<>{}(lhs.service_worker_response_source, rhs.service_worker_response_source))
    return true;
  if (std::less<>{}(rhs.service_worker_response_source, lhs.service_worker_response_source))
    return false;
  if (std::less<>{}(lhs.was_fallback_required_by_service_worker, rhs.was_fallback_required_by_service_worker))
    return true;
  if (std::less<>{}(rhs.was_fallback_required_by_service_worker, lhs.was_fallback_required_by_service_worker))
    return false;
  if (std::less<>{}(lhs.url_list_via_service_worker, rhs.url_list_via_service_worker))
    return true;
  if (std::less<>{}(rhs.url_list_via_service_worker, lhs.url_list_via_service_worker))
    return false;
  if (std::less<>{}(lhs.response_type, rhs.response_type))
    return true;
  if (std::less<>{}(rhs.response_type, lhs.response_type))
    return false;
  if (std::less<>{}(lhs.padding, rhs.padding))
    return true;
  if (std::less<>{}(rhs.padding, lhs.padding))
    return false;
  if (std::less<>{}(lhs.cache_storage_cache_name, rhs.cache_storage_cache_name))
    return true;
  if (std::less<>{}(rhs.cache_storage_cache_name, lhs.cache_storage_cache_name))
    return false;
  if (std::less<>{}(lhs.cert_status, rhs.cert_status))
    return true;
  if (std::less<>{}(rhs.cert_status, lhs.cert_status))
    return false;
  if (std::less<>{}(lhs.ssl_info, rhs.ssl_info))
    return true;
  if (std::less<>{}(rhs.ssl_info, lhs.ssl_info))
    return false;
  if (std::less<>{}(lhs.cors_exposed_header_names, rhs.cors_exposed_header_names))
    return true;
  if (std::less<>{}(rhs.cors_exposed_header_names, lhs.cors_exposed_header_names))
    return false;
  if (std::less<>{}(lhs.did_service_worker_navigation_preload, rhs.did_service_worker_navigation_preload))
    return true;
  if (std::less<>{}(rhs.did_service_worker_navigation_preload, lhs.did_service_worker_navigation_preload))
    return false;
  if (std::less<>{}(lhs.should_report_corb_blocking, rhs.should_report_corb_blocking))
    return true;
  if (std::less<>{}(rhs.should_report_corb_blocking, lhs.should_report_corb_blocking))
    return false;
  if (std::less<>{}(lhs.async_revalidation_requested, rhs.async_revalidation_requested))
    return true;
  if (std::less<>{}(rhs.async_revalidation_requested, lhs.async_revalidation_requested))
    return false;
  if (std::less<>{}(lhs.did_mime_sniff, rhs.did_mime_sniff))
    return true;
  if (std::less<>{}(rhs.did_mime_sniff, lhs.did_mime_sniff))
    return false;
  if (std::less<>{}(lhs.is_signed_exchange_inner_response, rhs.is_signed_exchange_inner_response))
    return true;
  if (std::less<>{}(rhs.is_signed_exchange_inner_response, lhs.is_signed_exchange_inner_response))
    return false;
  if (std::less<>{}(lhs.was_in_prefetch_cache, rhs.was_in_prefetch_cache))
    return true;
  if (std::less<>{}(rhs.was_in_prefetch_cache, lhs.was_in_prefetch_cache))
    return false;
  if (std::less<>{}(lhs.was_cookie_in_request, rhs.was_cookie_in_request))
    return true;
  if (std::less<>{}(rhs.was_cookie_in_request, lhs.was_cookie_in_request))
    return false;
  if (std::less<>{}(lhs.intercepted_by_plugin, rhs.intercepted_by_plugin))
    return true;
  if (std::less<>{}(rhs.intercepted_by_plugin, lhs.intercepted_by_plugin))
    return false;
  if (std::less<>{}(lhs.is_legacy_tls_version, rhs.is_legacy_tls_version))
    return true;
  if (std::less<>{}(rhs.is_legacy_tls_version, lhs.is_legacy_tls_version))
    return false;
  if (std::less<>{}(lhs.has_range_requested, rhs.has_range_requested))
    return true;
  if (std::less<>{}(rhs.has_range_requested, lhs.has_range_requested))
    return false;
  if (std::less<>{}(lhs.timing_allow_passed, rhs.timing_allow_passed))
    return true;
  if (std::less<>{}(rhs.timing_allow_passed, lhs.timing_allow_passed))
    return false;
  if (std::less<>{}(lhs.auth_challenge_info, rhs.auth_challenge_info))
    return true;
  if (std::less<>{}(rhs.auth_challenge_info, lhs.auth_challenge_info))
    return false;
  if (std::less<>{}(lhs.request_start, rhs.request_start))
    return true;
  if (std::less<>{}(rhs.request_start, lhs.request_start))
    return false;
  if (std::less<>{}(lhs.response_start, rhs.response_start))
    return true;
  if (std::less<>{}(rhs.response_start, lhs.response_start))
    return false;
  if (std::less<>{}(lhs.parsed_headers, rhs.parsed_headers))
    return true;
  if (std::less<>{}(rhs.parsed_headers, lhs.parsed_headers))
    return false;
  if (std::less<>{}(lhs.origin_policy, rhs.origin_policy))
    return true;
  if (std::less<>{}(rhs.origin_policy, lhs.origin_policy))
    return false;
  if (std::less<>{}(lhs.recursive_prefetch_token, rhs.recursive_prefetch_token))
    return true;
  if (std::less<>{}(rhs.recursive_prefetch_token, lhs.recursive_prefetch_token))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::URLResponseHead::DataView,
                                         ::network::mojom::URLResponseHeadPtr> {
  static bool IsNull(const ::network::mojom::URLResponseHeadPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLResponseHeadPtr* output) { output->reset(); }

  static const decltype(::network::mojom::URLResponseHead::request_time)& request_time(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_time;
  }

  static const decltype(::network::mojom::URLResponseHead::response_time)& response_time(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_time;
  }

  static const decltype(::network::mojom::URLResponseHead::headers)& headers(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::URLResponseHead::mime_type)& mime_type(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->mime_type;
  }

  static const decltype(::network::mojom::URLResponseHead::charset)& charset(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->charset;
  }

  static decltype(::network::mojom::URLResponseHead::ct_policy_compliance) ct_policy_compliance(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->ct_policy_compliance;
  }

  static decltype(::network::mojom::URLResponseHead::content_length) content_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->content_length;
  }

  static decltype(::network::mojom::URLResponseHead::encoded_data_length) encoded_data_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->encoded_data_length;
  }

  static decltype(::network::mojom::URLResponseHead::encoded_body_length) encoded_body_length(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->encoded_body_length;
  }

  static decltype(::network::mojom::URLResponseHead::network_accessed) network_accessed(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->network_accessed;
  }

  static decltype(::network::mojom::URLResponseHead::appcache_id) appcache_id(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->appcache_id;
  }

  static const decltype(::network::mojom::URLResponseHead::appcache_manifest_url)& appcache_manifest_url(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->appcache_manifest_url;
  }

  static const decltype(::network::mojom::URLResponseHead::load_timing)& load_timing(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->load_timing;
  }

  static const decltype(::network::mojom::URLResponseHead::raw_request_response_info)& raw_request_response_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->raw_request_response_info;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_spdy) was_fetched_via_spdy(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_spdy;
  }

  static decltype(::network::mojom::URLResponseHead::was_alpn_negotiated) was_alpn_negotiated(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_alpn_negotiated;
  }

  static decltype(::network::mojom::URLResponseHead::was_alternate_protocol_available) was_alternate_protocol_available(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_alternate_protocol_available;
  }

  static decltype(::network::mojom::URLResponseHead::connection_info) connection_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->connection_info;
  }

  static const decltype(::network::mojom::URLResponseHead::alpn_negotiated_protocol)& alpn_negotiated_protocol(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->alpn_negotiated_protocol;
  }

  static const decltype(::network::mojom::URLResponseHead::remote_endpoint)& remote_endpoint(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->remote_endpoint;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_cache) was_fetched_via_cache(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_cache;
  }

  static const decltype(::network::mojom::URLResponseHead::proxy_server)& proxy_server(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->proxy_server;
  }

  static decltype(::network::mojom::URLResponseHead::was_fetched_via_service_worker) was_fetched_via_service_worker(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fetched_via_service_worker;
  }

  static decltype(::network::mojom::URLResponseHead::service_worker_response_source) service_worker_response_source(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->service_worker_response_source;
  }

  static decltype(::network::mojom::URLResponseHead::was_fallback_required_by_service_worker) was_fallback_required_by_service_worker(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_fallback_required_by_service_worker;
  }

  static const decltype(::network::mojom::URLResponseHead::url_list_via_service_worker)& url_list_via_service_worker(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->url_list_via_service_worker;
  }

  static decltype(::network::mojom::URLResponseHead::response_type) response_type(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_type;
  }

  static decltype(::network::mojom::URLResponseHead::padding) padding(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->padding;
  }

  static const decltype(::network::mojom::URLResponseHead::cache_storage_cache_name)& cache_storage_cache_name(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cache_storage_cache_name;
  }

  static decltype(::network::mojom::URLResponseHead::cert_status) cert_status(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cert_status;
  }

  static const decltype(::network::mojom::URLResponseHead::ssl_info)& ssl_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->ssl_info;
  }

  static const decltype(::network::mojom::URLResponseHead::cors_exposed_header_names)& cors_exposed_header_names(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->cors_exposed_header_names;
  }

  static decltype(::network::mojom::URLResponseHead::did_service_worker_navigation_preload) did_service_worker_navigation_preload(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->did_service_worker_navigation_preload;
  }

  static decltype(::network::mojom::URLResponseHead::should_report_corb_blocking) should_report_corb_blocking(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->should_report_corb_blocking;
  }

  static decltype(::network::mojom::URLResponseHead::async_revalidation_requested) async_revalidation_requested(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->async_revalidation_requested;
  }

  static decltype(::network::mojom::URLResponseHead::did_mime_sniff) did_mime_sniff(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->did_mime_sniff;
  }

  static decltype(::network::mojom::URLResponseHead::is_signed_exchange_inner_response) is_signed_exchange_inner_response(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_signed_exchange_inner_response;
  }

  static decltype(::network::mojom::URLResponseHead::was_in_prefetch_cache) was_in_prefetch_cache(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_in_prefetch_cache;
  }

  static decltype(::network::mojom::URLResponseHead::was_cookie_in_request) was_cookie_in_request(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->was_cookie_in_request;
  }

  static decltype(::network::mojom::URLResponseHead::intercepted_by_plugin) intercepted_by_plugin(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->intercepted_by_plugin;
  }

  static decltype(::network::mojom::URLResponseHead::is_legacy_tls_version) is_legacy_tls_version(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->is_legacy_tls_version;
  }

  static decltype(::network::mojom::URLResponseHead::has_range_requested) has_range_requested(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->has_range_requested;
  }

  static decltype(::network::mojom::URLResponseHead::timing_allow_passed) timing_allow_passed(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->timing_allow_passed;
  }

  static const decltype(::network::mojom::URLResponseHead::auth_challenge_info)& auth_challenge_info(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->auth_challenge_info;
  }

  static const decltype(::network::mojom::URLResponseHead::request_start)& request_start(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->request_start;
  }

  static const decltype(::network::mojom::URLResponseHead::response_start)& response_start(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->response_start;
  }

  static const decltype(::network::mojom::URLResponseHead::parsed_headers)& parsed_headers(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->parsed_headers;
  }

  static const decltype(::network::mojom::URLResponseHead::origin_policy)& origin_policy(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->origin_policy;
  }

  static const decltype(::network::mojom::URLResponseHead::recursive_prefetch_token)& recursive_prefetch_token(
      const ::network::mojom::URLResponseHeadPtr& input) {
    return input->recursive_prefetch_token;
  }

  static bool Read(::network::mojom::URLResponseHead::DataView input, ::network::mojom::URLResponseHeadPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_H_