// services/tracing/public/mojom/perfetto_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/perfetto/include/perfetto/ext/tracing/core/commit_data_request.h"
#include "third_party/perfetto/include/perfetto/tracing/core/chrome_config.h"
#include "third_party/perfetto/include/perfetto/tracing/core/data_source_config.h"
#include "third_party/perfetto/include/perfetto/tracing/core/data_source_descriptor.h"
#include "third_party/perfetto/include/perfetto/tracing/core/trace_config.h"
#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace tracing {
namespace mojom {

class ProducerHostProxy;

template <typename ImplRefTraits>
class ProducerHostStub;

class ProducerHostRequestValidator;
class ProducerHostResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHost
    : public ProducerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProducerHostInterfaceBase;
  using Proxy_ = ProducerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProducerHostStub<ImplRefTraits>;

  using RequestValidator_ = ProducerHostRequestValidator;
  using ResponseValidator_ = ProducerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitDataMinVersion = 0,
    kRegisterDataSourceMinVersion = 0,
    kRegisterTraceWriterMinVersion = 0,
    kUnregisterTraceWriterMinVersion = 0,
  };
  virtual ~ProducerHost() {}


  using CommitDataCallback = base::OnceCallback<void()>;
  
  virtual void CommitData(const ::perfetto::CommitDataRequest& data_request, CommitDataCallback callback) = 0;

  
  virtual void RegisterDataSource(const ::perfetto::DataSourceDescriptor& registration_info) = 0;

  
  virtual void RegisterTraceWriter(uint32_t writer_id, uint32_t target_buffer) = 0;

  
  virtual void UnregisterTraceWriter(uint32_t writer_id) = 0;
};

class ProducerClientProxy;

template <typename ImplRefTraits>
class ProducerClientStub;

class ProducerClientRequestValidator;
class ProducerClientResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClient
    : public ProducerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProducerClientInterfaceBase;
  using Proxy_ = ProducerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProducerClientStub<ImplRefTraits>;

  using RequestValidator_ = ProducerClientRequestValidator;
  using ResponseValidator_ = ProducerClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnTracingStartMinVersion = 0,
    kStartDataSourceMinVersion = 0,
    kStopDataSourceMinVersion = 0,
    kFlushMinVersion = 0,
    kClearIncrementalStateMinVersion = 0,
  };
  virtual ~ProducerClient() {}

  
  virtual void OnTracingStart() = 0;


  using StartDataSourceCallback = base::OnceCallback<void()>;
  
  virtual void StartDataSource(uint64_t id, const ::perfetto::DataSourceConfig& data_source_config, StartDataSourceCallback callback) = 0;


  using StopDataSourceCallback = base::OnceCallback<void()>;
  
  virtual void StopDataSource(uint64_t id, StopDataSourceCallback callback) = 0;

  
  virtual void Flush(uint64_t flush_request_id, const std::vector<uint64_t>& data_source_ids) = 0;

  
  virtual void ClearIncrementalState() = 0;
};

class PerfettoServiceProxy;

template <typename ImplRefTraits>
class PerfettoServiceStub;

class PerfettoServiceRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoService
    : public PerfettoServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PerfettoServiceInterfaceBase;
  using Proxy_ = PerfettoServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PerfettoServiceStub<ImplRefTraits>;

  using RequestValidator_ = PerfettoServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectToProducerHostMinVersion = 0,
  };
  virtual ~PerfettoService() {}

  
  virtual void ConnectToProducerHost(::mojo::PendingRemote<ProducerClient> producer_client, ::mojo::PendingReceiver<ProducerHost> producer_host_receiver, ::mojo::ScopedSharedBufferHandle shared_memory, uint64_t shared_memory_buffer_page_size_bytes) = 0;
};

class ConsumerHostProxy;

template <typename ImplRefTraits>
class ConsumerHostStub;

class ConsumerHostRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHost
    : public ConsumerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ConsumerHostInterfaceBase;
  using Proxy_ = ConsumerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConsumerHostStub<ImplRefTraits>;

  using RequestValidator_ = ConsumerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEnableTracingMinVersion = 0,
  };
  virtual ~ConsumerHost() {}

  
  virtual void EnableTracing(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::perfetto::TraceConfig& config, TracingClientPriority priority) = 0;
};

class TracingSessionHostProxy;

template <typename ImplRefTraits>
class TracingSessionHostStub;

class TracingSessionHostRequestValidator;
class TracingSessionHostResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHost
    : public TracingSessionHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = TracingSessionHostInterfaceBase;
  using Proxy_ = TracingSessionHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracingSessionHostStub<ImplRefTraits>;

  using RequestValidator_ = TracingSessionHostRequestValidator;
  using ResponseValidator_ = TracingSessionHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kChangeTraceConfigMinVersion = 0,
    kDisableTracingMinVersion = 0,
    kReadBuffersMinVersion = 0,
    kRequestBufferUsageMinVersion = 0,
    kDisableTracingAndEmitJsonMinVersion = 0,
  };
  virtual ~TracingSessionHost() {}

  
  virtual void ChangeTraceConfig(const ::perfetto::TraceConfig& config) = 0;

  
  virtual void DisableTracing() = 0;


  using ReadBuffersCallback = base::OnceCallback<void()>;
  
  virtual void ReadBuffers(::mojo::ScopedDataPipeProducerHandle stream, ReadBuffersCallback callback) = 0;


  using RequestBufferUsageCallback = base::OnceCallback<void(bool, float, bool)>;
  
  virtual void RequestBufferUsage(RequestBufferUsageCallback callback) = 0;


  using DisableTracingAndEmitJsonCallback = base::OnceCallback<void()>;
  
  virtual void DisableTracingAndEmitJson(const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) = 0;
};

class TracingSessionClientProxy;

template <typename ImplRefTraits>
class TracingSessionClientStub;

class TracingSessionClientRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClient
    : public TracingSessionClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = TracingSessionClientInterfaceBase;
  using Proxy_ = TracingSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracingSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = TracingSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTracingEnabledMinVersion = 0,
    kOnTracingDisabledMinVersion = 0,
  };
  virtual ~TracingSessionClient() {}

  
  virtual void OnTracingEnabled() = 0;

  
  virtual void OnTracingDisabled() = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostProxy
    : public ProducerHost {
 public:
  using InterfaceType = ProducerHost;

  explicit ProducerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitData(const ::perfetto::CommitDataRequest& data_request, CommitDataCallback callback) final;
  
  void RegisterDataSource(const ::perfetto::DataSourceDescriptor& registration_info) final;
  
  void RegisterTraceWriter(uint32_t writer_id, uint32_t target_buffer) final;
  
  void UnregisterTraceWriter(uint32_t writer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientProxy
    : public ProducerClient {
 public:
  using InterfaceType = ProducerClient;

  explicit ProducerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTracingStart() final;
  
  void StartDataSource(uint64_t id, const ::perfetto::DataSourceConfig& data_source_config, StartDataSourceCallback callback) final;
  
  void StopDataSource(uint64_t id, StopDataSourceCallback callback) final;
  
  void Flush(uint64_t flush_request_id, const std::vector<uint64_t>& data_source_ids) final;
  
  void ClearIncrementalState() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceProxy
    : public PerfettoService {
 public:
  using InterfaceType = PerfettoService;

  explicit PerfettoServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToProducerHost(::mojo::PendingRemote<ProducerClient> producer_client, ::mojo::PendingReceiver<ProducerHost> producer_host_receiver, ::mojo::ScopedSharedBufferHandle shared_memory, uint64_t shared_memory_buffer_page_size_bytes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostProxy
    : public ConsumerHost {
 public:
  using InterfaceType = ConsumerHost;

  explicit ConsumerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableTracing(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::perfetto::TraceConfig& config, TracingClientPriority priority) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostProxy
    : public TracingSessionHost {
 public:
  using InterfaceType = TracingSessionHost;

  explicit TracingSessionHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChangeTraceConfig(const ::perfetto::TraceConfig& config) final;
  
  void DisableTracing() final;
  
  void ReadBuffers(::mojo::ScopedDataPipeProducerHandle stream, ReadBuffersCallback callback) final;
  
  void RequestBufferUsage(RequestBufferUsageCallback callback) final;
  
  void DisableTracingAndEmitJson(const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientProxy
    : public TracingSessionClient {
 public:
  using InterfaceType = TracingSessionClient;

  explicit TracingSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTracingEnabled() final;
  
  void OnTracingDisabled() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostStubDispatch {
 public:
  static bool Accept(ProducerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProducerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProducerHost>>
class ProducerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProducerHostStub() {}
  ~ProducerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientStubDispatch {
 public:
  static bool Accept(ProducerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProducerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProducerClient>>
class ProducerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProducerClientStub() {}
  ~ProducerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProducerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceStubDispatch {
 public:
  static bool Accept(PerfettoService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PerfettoService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PerfettoService>>
class PerfettoServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PerfettoServiceStub() {}
  ~PerfettoServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PerfettoServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PerfettoServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostStubDispatch {
 public:
  static bool Accept(ConsumerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ConsumerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ConsumerHost>>
class ConsumerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConsumerHostStub() {}
  ~ConsumerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConsumerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConsumerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostStubDispatch {
 public:
  static bool Accept(TracingSessionHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracingSessionHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracingSessionHost>>
class TracingSessionHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracingSessionHostStub() {}
  ~TracingSessionHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientStubDispatch {
 public:
  static bool Accept(TracingSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracingSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracingSessionClient>>
class TracingSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracingSessionClientStub() {}
  ~TracingSessionClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracingSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(TRACING_MOJOM) ChunksToMove {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunksToMove, T>::value>;
  using DataView = ChunksToMoveDataView;
  using Data_ = internal::ChunksToMove_Data;

  template <typename... Args>
  static ChunksToMovePtr New(Args&&... args) {
    return ChunksToMovePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunksToMovePtr From(const U& u) {
    return mojo::TypeConverter<ChunksToMovePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunksToMove>::Convert(*this);
  }


  ChunksToMove();

  ChunksToMove(
      uint32_t page,
      uint32_t chunk,
      uint32_t target_buffer);

  ~ChunksToMove();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunksToMovePtr>
  ChunksToMovePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToMove::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunksToMove::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunksToMove_UnserializedMessageContext<
            UserType, ChunksToMove::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChunksToMove::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ChunksToMove::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunksToMove_UnserializedMessageContext<
            UserType, ChunksToMove::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunksToMove::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t page;
  
  uint32_t chunk;
  
  uint32_t target_buffer;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunksToMove::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) ChunkPatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunkPatch, T>::value>;
  using DataView = ChunkPatchDataView;
  using Data_ = internal::ChunkPatch_Data;

  template <typename... Args>
  static ChunkPatchPtr New(Args&&... args) {
    return ChunkPatchPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunkPatchPtr From(const U& u) {
    return mojo::TypeConverter<ChunkPatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunkPatch>::Convert(*this);
  }


  ChunkPatch();

  ChunkPatch(
      uint32_t offset,
      const std::string& data);

  ~ChunkPatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunkPatchPtr>
  ChunkPatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunkPatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunkPatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunkPatch_UnserializedMessageContext<
            UserType, ChunkPatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChunkPatch::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ChunkPatch::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunkPatch_UnserializedMessageContext<
            UserType, ChunkPatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunkPatch::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t offset;
  
  std::string data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunkPatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(TRACING_MOJOM) ChromeConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeConfig, T>::value>;
  using DataView = ChromeConfigDataView;
  using Data_ = internal::ChromeConfig_Data;

  template <typename... Args>
  static ChromeConfigPtr New(Args&&... args) {
    return ChromeConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeConfigPtr From(const U& u) {
    return mojo::TypeConverter<ChromeConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeConfig>::Convert(*this);
  }


  ChromeConfig();

  ChromeConfig(
      const std::string& trace_config,
      bool privacy_filtering_enabled);

  ~ChromeConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeConfigPtr>
  ChromeConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeConfig_UnserializedMessageContext<
            UserType, ChromeConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChromeConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ChromeConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeConfig_UnserializedMessageContext<
            UserType, ChromeConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string trace_config;
  
  bool privacy_filtering_enabled;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(TRACING_MOJOM) DataSourceRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSourceRegistration, T>::value>;
  using DataView = DataSourceRegistrationDataView;
  using Data_ = internal::DataSourceRegistration_Data;

  template <typename... Args>
  static DataSourceRegistrationPtr New(Args&&... args) {
    return DataSourceRegistrationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourceRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<DataSourceRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSourceRegistration>::Convert(*this);
  }


  DataSourceRegistration();

  DataSourceRegistration(
      const std::string& name,
      bool will_notify_on_start,
      bool will_notify_on_stop,
      bool handles_incremental_state_clear);

  ~DataSourceRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourceRegistrationPtr>
  DataSourceRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceRegistration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSourceRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSourceRegistration_UnserializedMessageContext<
            UserType, DataSourceRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DataSourceRegistration::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DataSourceRegistration::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSourceRegistration_UnserializedMessageContext<
            UserType, DataSourceRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSourceRegistration::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  bool will_notify_on_start;
  
  bool will_notify_on_stop;
  
  bool handles_incremental_state_clear;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSourceRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) BufferConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BufferConfig, T>::value>;
  using DataView = BufferConfigDataView;
  using Data_ = internal::BufferConfig_Data;

  template <typename... Args>
  static BufferConfigPtr New(Args&&... args) {
    return BufferConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BufferConfigPtr From(const U& u) {
    return mojo::TypeConverter<BufferConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BufferConfig>::Convert(*this);
  }


  BufferConfig();

  BufferConfig(
      uint32_t size_kb,
      ::perfetto::TraceConfig::BufferConfig::FillPolicy fill_policy);

  ~BufferConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BufferConfigPtr>
  BufferConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BufferConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BufferConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BufferConfig_UnserializedMessageContext<
            UserType, BufferConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BufferConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BufferConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BufferConfig_UnserializedMessageContext<
            UserType, BufferConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BufferConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t size_kb;
  
  ::perfetto::TraceConfig::BufferConfig::FillPolicy fill_policy;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BufferConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(TRACING_MOJOM) IncrementalStateConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IncrementalStateConfig, T>::value>;
  using DataView = IncrementalStateConfigDataView;
  using Data_ = internal::IncrementalStateConfig_Data;

  template <typename... Args>
  static IncrementalStateConfigPtr New(Args&&... args) {
    return IncrementalStateConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IncrementalStateConfigPtr From(const U& u) {
    return mojo::TypeConverter<IncrementalStateConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IncrementalStateConfig>::Convert(*this);
  }


  IncrementalStateConfig();

  explicit IncrementalStateConfig(
      uint32_t clear_period_ms);

  ~IncrementalStateConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IncrementalStateConfigPtr>
  IncrementalStateConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IncrementalStateConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IncrementalStateConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IncrementalStateConfig_UnserializedMessageContext<
            UserType, IncrementalStateConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IncrementalStateConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return IncrementalStateConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IncrementalStateConfig_UnserializedMessageContext<
            UserType, IncrementalStateConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IncrementalStateConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t clear_period_ms;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(TRACING_MOJOM) ChunksToPatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChunksToPatch, T>::value>;
  using DataView = ChunksToPatchDataView;
  using Data_ = internal::ChunksToPatch_Data;

  template <typename... Args>
  static ChunksToPatchPtr New(Args&&... args) {
    return ChunksToPatchPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChunksToPatchPtr From(const U& u) {
    return mojo::TypeConverter<ChunksToPatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChunksToPatch>::Convert(*this);
  }


  ChunksToPatch();

  ChunksToPatch(
      uint32_t target_buffer,
      uint32_t writer_id,
      uint32_t chunk_id,
      std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch> patches,
      bool has_more_patches);

  ~ChunksToPatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChunksToPatchPtr>
  ChunksToPatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChunksToPatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChunksToPatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChunksToPatch_UnserializedMessageContext<
            UserType, ChunksToPatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChunksToPatch::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ChunksToPatch::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChunksToPatch_UnserializedMessageContext<
            UserType, ChunksToPatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChunksToPatch::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t target_buffer;
  
  uint32_t writer_id;
  
  uint32_t chunk_id;
  
  std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch> patches;
  
  bool has_more_patches;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChunksToPatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) CommitDataRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommitDataRequest, T>::value>;
  using DataView = CommitDataRequestDataView;
  using Data_ = internal::CommitDataRequest_Data;

  template <typename... Args>
  static CommitDataRequestPtr New(Args&&... args) {
    return CommitDataRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommitDataRequestPtr From(const U& u) {
    return mojo::TypeConverter<CommitDataRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommitDataRequest>::Convert(*this);
  }


  CommitDataRequest();

  CommitDataRequest(
      std::vector<::perfetto::CommitDataRequest::ChunksToMove> chunks_to_move,
      std::vector<ChunksToPatchPtr> chunks_to_patch,
      uint64_t flush_request_id);

  ~CommitDataRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommitDataRequestPtr>
  CommitDataRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommitDataRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommitDataRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommitDataRequest_UnserializedMessageContext<
            UserType, CommitDataRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CommitDataRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CommitDataRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommitDataRequest_UnserializedMessageContext<
            UserType, CommitDataRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommitDataRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::perfetto::CommitDataRequest::ChunksToMove> chunks_to_move;
  
  std::vector<ChunksToPatchPtr> chunks_to_patch;
  
  uint64_t flush_request_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CommitDataRequest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommitDataRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(TRACING_MOJOM) DataSourceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSourceConfig, T>::value>;
  using DataView = DataSourceConfigDataView;
  using Data_ = internal::DataSourceConfig_Data;

  template <typename... Args>
  static DataSourceConfigPtr New(Args&&... args) {
    return DataSourceConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourceConfigPtr From(const U& u) {
    return mojo::TypeConverter<DataSourceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSourceConfig>::Convert(*this);
  }


  DataSourceConfig();

  DataSourceConfig(
      const std::string& name,
      uint32_t target_buffer,
      uint32_t trace_duration_ms,
      uint64_t tracing_session_id,
      const ::perfetto::ChromeConfig& chrome_config,
      const std::string& legacy_config);

  ~DataSourceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourceConfigPtr>
  DataSourceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSourceConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSourceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSourceConfig_UnserializedMessageContext<
            UserType, DataSourceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DataSourceConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DataSourceConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSourceConfig_UnserializedMessageContext<
            UserType, DataSourceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSourceConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  uint32_t target_buffer;
  
  uint32_t trace_duration_ms;
  
  uint64_t tracing_session_id;
  
  ::perfetto::ChromeConfig chrome_config;
  
  std::string legacy_config;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSourceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(TRACING_MOJOM) DataSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataSource, T>::value>;
  using DataView = DataSourceDataView;
  using Data_ = internal::DataSource_Data;

  template <typename... Args>
  static DataSourcePtr New(Args&&... args) {
    return DataSourcePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataSourcePtr From(const U& u) {
    return mojo::TypeConverter<DataSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataSource>::Convert(*this);
  }


  DataSource();

  DataSource(
      const ::perfetto::DataSourceConfig& config,
      std::vector<std::string> producer_name_filter);

  ~DataSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataSourcePtr>
  DataSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataSource_UnserializedMessageContext<
            UserType, DataSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DataSource::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DataSource::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataSource_UnserializedMessageContext<
            UserType, DataSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataSource::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::perfetto::DataSourceConfig config;
  
  std::vector<std::string> producer_name_filter;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoBuiltinDataSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerfettoBuiltinDataSource, T>::value>;
  using DataView = PerfettoBuiltinDataSourceDataView;
  using Data_ = internal::PerfettoBuiltinDataSource_Data;

  template <typename... Args>
  static PerfettoBuiltinDataSourcePtr New(Args&&... args) {
    return PerfettoBuiltinDataSourcePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerfettoBuiltinDataSourcePtr From(const U& u) {
    return mojo::TypeConverter<PerfettoBuiltinDataSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerfettoBuiltinDataSource>::Convert(*this);
  }


  PerfettoBuiltinDataSource();

  PerfettoBuiltinDataSource(
      bool disable_clock_snapshotting,
      bool disable_trace_config,
      bool disable_system_info,
      bool disable_service_events,
      int32_t primary_trace_clock_id);

  ~PerfettoBuiltinDataSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerfettoBuiltinDataSourcePtr>
  PerfettoBuiltinDataSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerfettoBuiltinDataSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerfettoBuiltinDataSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerfettoBuiltinDataSource_UnserializedMessageContext<
            UserType, PerfettoBuiltinDataSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PerfettoBuiltinDataSource::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PerfettoBuiltinDataSource::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerfettoBuiltinDataSource_UnserializedMessageContext<
            UserType, PerfettoBuiltinDataSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerfettoBuiltinDataSource::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool disable_clock_snapshotting;
  
  bool disable_trace_config;
  
  bool disable_system_info;
  
  bool disable_service_events;
  
  int32_t primary_trace_clock_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(TRACING_MOJOM) TraceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TraceConfig, T>::value>;
  using DataView = TraceConfigDataView;
  using Data_ = internal::TraceConfig_Data;

  template <typename... Args>
  static TraceConfigPtr New(Args&&... args) {
    return TraceConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TraceConfigPtr From(const U& u) {
    return mojo::TypeConverter<TraceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TraceConfig>::Convert(*this);
  }


  TraceConfig();

  TraceConfig(
      std::vector<DataSourcePtr> data_sources,
      const ::perfetto::TraceConfig::BuiltinDataSource& perfetto_builtin_data_source,
      std::vector<BufferConfigPtr> buffers,
      const ::perfetto::TraceConfig::IncrementalStateConfig& incremental_state_config,
      uint32_t duration_ms);

  ~TraceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TraceConfigPtr>
  TraceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TraceConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TraceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TraceConfig_UnserializedMessageContext<
            UserType, TraceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TraceConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return TraceConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TraceConfig_UnserializedMessageContext<
            UserType, TraceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TraceConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<DataSourcePtr> data_sources;
  
  ::perfetto::TraceConfig::BuiltinDataSource perfetto_builtin_data_source;
  
  std::vector<BufferConfigPtr> buffers;
  
  ::perfetto::TraceConfig::IncrementalStateConfig incremental_state_config;
  
  uint32_t duration_ms;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TraceConfig);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TraceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ChunksToMovePtr ChunksToMove::Clone() const {
  return New(
      mojo::Clone(page),
      mojo::Clone(chunk),
      mojo::Clone(target_buffer)
  );
}

template <typename T, ChunksToMove::EnableIfSame<T>*>
bool ChunksToMove::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page, other_struct.page))
    return false;
  if (!mojo::Equals(this->chunk, other_struct.chunk))
    return false;
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  return true;
}

template <typename T, ChunksToMove::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.page, rhs.page))
    return true;
  if (std::less<>{}(rhs.page, lhs.page))
    return false;
  if (std::less<>{}(lhs.chunk, rhs.chunk))
    return true;
  if (std::less<>{}(rhs.chunk, lhs.chunk))
    return false;
  if (std::less<>{}(lhs.target_buffer, rhs.target_buffer))
    return true;
  if (std::less<>{}(rhs.target_buffer, lhs.target_buffer))
    return false;
  return false;
}
template <typename StructPtrType>
ChunkPatchPtr ChunkPatch::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(data)
  );
}

template <typename T, ChunkPatch::EnableIfSame<T>*>
bool ChunkPatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, ChunkPatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  return false;
}
template <typename StructPtrType>
ChunksToPatchPtr ChunksToPatch::Clone() const {
  return New(
      mojo::Clone(target_buffer),
      mojo::Clone(writer_id),
      mojo::Clone(chunk_id),
      mojo::Clone(patches),
      mojo::Clone(has_more_patches)
  );
}

template <typename T, ChunksToPatch::EnableIfSame<T>*>
bool ChunksToPatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  if (!mojo::Equals(this->writer_id, other_struct.writer_id))
    return false;
  if (!mojo::Equals(this->chunk_id, other_struct.chunk_id))
    return false;
  if (!mojo::Equals(this->patches, other_struct.patches))
    return false;
  if (!mojo::Equals(this->has_more_patches, other_struct.has_more_patches))
    return false;
  return true;
}

template <typename T, ChunksToPatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.target_buffer, rhs.target_buffer))
    return true;
  if (std::less<>{}(rhs.target_buffer, lhs.target_buffer))
    return false;
  if (std::less<>{}(lhs.writer_id, rhs.writer_id))
    return true;
  if (std::less<>{}(rhs.writer_id, lhs.writer_id))
    return false;
  if (std::less<>{}(lhs.chunk_id, rhs.chunk_id))
    return true;
  if (std::less<>{}(rhs.chunk_id, lhs.chunk_id))
    return false;
  if (std::less<>{}(lhs.patches, rhs.patches))
    return true;
  if (std::less<>{}(rhs.patches, lhs.patches))
    return false;
  if (std::less<>{}(lhs.has_more_patches, rhs.has_more_patches))
    return true;
  if (std::less<>{}(rhs.has_more_patches, lhs.has_more_patches))
    return false;
  return false;
}
template <typename StructPtrType>
CommitDataRequestPtr CommitDataRequest::Clone() const {
  return New(
      mojo::Clone(chunks_to_move),
      mojo::Clone(chunks_to_patch),
      mojo::Clone(flush_request_id)
  );
}

template <typename T, CommitDataRequest::EnableIfSame<T>*>
bool CommitDataRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->chunks_to_move, other_struct.chunks_to_move))
    return false;
  if (!mojo::Equals(this->chunks_to_patch, other_struct.chunks_to_patch))
    return false;
  if (!mojo::Equals(this->flush_request_id, other_struct.flush_request_id))
    return false;
  return true;
}

template <typename T, CommitDataRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.chunks_to_move, rhs.chunks_to_move))
    return true;
  if (std::less<>{}(rhs.chunks_to_move, lhs.chunks_to_move))
    return false;
  if (std::less<>{}(lhs.chunks_to_patch, rhs.chunks_to_patch))
    return true;
  if (std::less<>{}(rhs.chunks_to_patch, lhs.chunks_to_patch))
    return false;
  if (std::less<>{}(lhs.flush_request_id, rhs.flush_request_id))
    return true;
  if (std::less<>{}(rhs.flush_request_id, lhs.flush_request_id))
    return false;
  return false;
}
template <typename StructPtrType>
ChromeConfigPtr ChromeConfig::Clone() const {
  return New(
      mojo::Clone(trace_config),
      mojo::Clone(privacy_filtering_enabled)
  );
}

template <typename T, ChromeConfig::EnableIfSame<T>*>
bool ChromeConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trace_config, other_struct.trace_config))
    return false;
  if (!mojo::Equals(this->privacy_filtering_enabled, other_struct.privacy_filtering_enabled))
    return false;
  return true;
}

template <typename T, ChromeConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.trace_config, rhs.trace_config))
    return true;
  if (std::less<>{}(rhs.trace_config, lhs.trace_config))
    return false;
  if (std::less<>{}(lhs.privacy_filtering_enabled, rhs.privacy_filtering_enabled))
    return true;
  if (std::less<>{}(rhs.privacy_filtering_enabled, lhs.privacy_filtering_enabled))
    return false;
  return false;
}
template <typename StructPtrType>
DataSourceConfigPtr DataSourceConfig::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(target_buffer),
      mojo::Clone(trace_duration_ms),
      mojo::Clone(tracing_session_id),
      mojo::Clone(chrome_config),
      mojo::Clone(legacy_config)
  );
}

template <typename T, DataSourceConfig::EnableIfSame<T>*>
bool DataSourceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->target_buffer, other_struct.target_buffer))
    return false;
  if (!mojo::Equals(this->trace_duration_ms, other_struct.trace_duration_ms))
    return false;
  if (!mojo::Equals(this->tracing_session_id, other_struct.tracing_session_id))
    return false;
  if (!mojo::Equals(this->chrome_config, other_struct.chrome_config))
    return false;
  if (!mojo::Equals(this->legacy_config, other_struct.legacy_config))
    return false;
  return true;
}

template <typename T, DataSourceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.target_buffer, rhs.target_buffer))
    return true;
  if (std::less<>{}(rhs.target_buffer, lhs.target_buffer))
    return false;
  if (std::less<>{}(lhs.trace_duration_ms, rhs.trace_duration_ms))
    return true;
  if (std::less<>{}(rhs.trace_duration_ms, lhs.trace_duration_ms))
    return false;
  if (std::less<>{}(lhs.tracing_session_id, rhs.tracing_session_id))
    return true;
  if (std::less<>{}(rhs.tracing_session_id, lhs.tracing_session_id))
    return false;
  if (std::less<>{}(lhs.chrome_config, rhs.chrome_config))
    return true;
  if (std::less<>{}(rhs.chrome_config, lhs.chrome_config))
    return false;
  if (std::less<>{}(lhs.legacy_config, rhs.legacy_config))
    return true;
  if (std::less<>{}(rhs.legacy_config, lhs.legacy_config))
    return false;
  return false;
}
template <typename StructPtrType>
DataSourceRegistrationPtr DataSourceRegistration::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(will_notify_on_start),
      mojo::Clone(will_notify_on_stop),
      mojo::Clone(handles_incremental_state_clear)
  );
}

template <typename T, DataSourceRegistration::EnableIfSame<T>*>
bool DataSourceRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->will_notify_on_start, other_struct.will_notify_on_start))
    return false;
  if (!mojo::Equals(this->will_notify_on_stop, other_struct.will_notify_on_stop))
    return false;
  if (!mojo::Equals(this->handles_incremental_state_clear, other_struct.handles_incremental_state_clear))
    return false;
  return true;
}

template <typename T, DataSourceRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.will_notify_on_start, rhs.will_notify_on_start))
    return true;
  if (std::less<>{}(rhs.will_notify_on_start, lhs.will_notify_on_start))
    return false;
  if (std::less<>{}(lhs.will_notify_on_stop, rhs.will_notify_on_stop))
    return true;
  if (std::less<>{}(rhs.will_notify_on_stop, lhs.will_notify_on_stop))
    return false;
  if (std::less<>{}(lhs.handles_incremental_state_clear, rhs.handles_incremental_state_clear))
    return true;
  if (std::less<>{}(rhs.handles_incremental_state_clear, lhs.handles_incremental_state_clear))
    return false;
  return false;
}
template <typename StructPtrType>
BufferConfigPtr BufferConfig::Clone() const {
  return New(
      mojo::Clone(size_kb),
      mojo::Clone(fill_policy)
  );
}

template <typename T, BufferConfig::EnableIfSame<T>*>
bool BufferConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size_kb, other_struct.size_kb))
    return false;
  if (!mojo::Equals(this->fill_policy, other_struct.fill_policy))
    return false;
  return true;
}

template <typename T, BufferConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.size_kb, rhs.size_kb))
    return true;
  if (std::less<>{}(rhs.size_kb, lhs.size_kb))
    return false;
  if (std::less<>{}(lhs.fill_policy, rhs.fill_policy))
    return true;
  if (std::less<>{}(rhs.fill_policy, lhs.fill_policy))
    return false;
  return false;
}
template <typename StructPtrType>
DataSourcePtr DataSource::Clone() const {
  return New(
      mojo::Clone(config),
      mojo::Clone(producer_name_filter)
  );
}

template <typename T, DataSource::EnableIfSame<T>*>
bool DataSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  if (!mojo::Equals(this->producer_name_filter, other_struct.producer_name_filter))
    return false;
  return true;
}

template <typename T, DataSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.config, rhs.config))
    return true;
  if (std::less<>{}(rhs.config, lhs.config))
    return false;
  if (std::less<>{}(lhs.producer_name_filter, rhs.producer_name_filter))
    return true;
  if (std::less<>{}(rhs.producer_name_filter, lhs.producer_name_filter))
    return false;
  return false;
}
template <typename StructPtrType>
PerfettoBuiltinDataSourcePtr PerfettoBuiltinDataSource::Clone() const {
  return New(
      mojo::Clone(disable_clock_snapshotting),
      mojo::Clone(disable_trace_config),
      mojo::Clone(disable_system_info),
      mojo::Clone(disable_service_events),
      mojo::Clone(primary_trace_clock_id)
  );
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>*>
bool PerfettoBuiltinDataSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disable_clock_snapshotting, other_struct.disable_clock_snapshotting))
    return false;
  if (!mojo::Equals(this->disable_trace_config, other_struct.disable_trace_config))
    return false;
  if (!mojo::Equals(this->disable_system_info, other_struct.disable_system_info))
    return false;
  if (!mojo::Equals(this->disable_service_events, other_struct.disable_service_events))
    return false;
  if (!mojo::Equals(this->primary_trace_clock_id, other_struct.primary_trace_clock_id))
    return false;
  return true;
}

template <typename T, PerfettoBuiltinDataSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.disable_clock_snapshotting, rhs.disable_clock_snapshotting))
    return true;
  if (std::less<>{}(rhs.disable_clock_snapshotting, lhs.disable_clock_snapshotting))
    return false;
  if (std::less<>{}(lhs.disable_trace_config, rhs.disable_trace_config))
    return true;
  if (std::less<>{}(rhs.disable_trace_config, lhs.disable_trace_config))
    return false;
  if (std::less<>{}(lhs.disable_system_info, rhs.disable_system_info))
    return true;
  if (std::less<>{}(rhs.disable_system_info, lhs.disable_system_info))
    return false;
  if (std::less<>{}(lhs.disable_service_events, rhs.disable_service_events))
    return true;
  if (std::less<>{}(rhs.disable_service_events, lhs.disable_service_events))
    return false;
  if (std::less<>{}(lhs.primary_trace_clock_id, rhs.primary_trace_clock_id))
    return true;
  if (std::less<>{}(rhs.primary_trace_clock_id, lhs.primary_trace_clock_id))
    return false;
  return false;
}
template <typename StructPtrType>
IncrementalStateConfigPtr IncrementalStateConfig::Clone() const {
  return New(
      mojo::Clone(clear_period_ms)
  );
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>*>
bool IncrementalStateConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->clear_period_ms, other_struct.clear_period_ms))
    return false;
  return true;
}

template <typename T, IncrementalStateConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.clear_period_ms, rhs.clear_period_ms))
    return true;
  if (std::less<>{}(rhs.clear_period_ms, lhs.clear_period_ms))
    return false;
  return false;
}
template <typename StructPtrType>
TraceConfigPtr TraceConfig::Clone() const {
  return New(
      mojo::Clone(data_sources),
      mojo::Clone(perfetto_builtin_data_source),
      mojo::Clone(buffers),
      mojo::Clone(incremental_state_config),
      mojo::Clone(duration_ms)
  );
}

template <typename T, TraceConfig::EnableIfSame<T>*>
bool TraceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_sources, other_struct.data_sources))
    return false;
  if (!mojo::Equals(this->perfetto_builtin_data_source, other_struct.perfetto_builtin_data_source))
    return false;
  if (!mojo::Equals(this->buffers, other_struct.buffers))
    return false;
  if (!mojo::Equals(this->incremental_state_config, other_struct.incremental_state_config))
    return false;
  if (!mojo::Equals(this->duration_ms, other_struct.duration_ms))
    return false;
  return true;
}

template <typename T, TraceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.data_sources, rhs.data_sources))
    return true;
  if (std::less<>{}(rhs.data_sources, lhs.data_sources))
    return false;
  if (std::less<>{}(lhs.perfetto_builtin_data_source, rhs.perfetto_builtin_data_source))
    return true;
  if (std::less<>{}(rhs.perfetto_builtin_data_source, lhs.perfetto_builtin_data_source))
    return false;
  if (std::less<>{}(lhs.buffers, rhs.buffers))
    return true;
  if (std::less<>{}(rhs.buffers, lhs.buffers))
    return false;
  if (std::less<>{}(lhs.incremental_state_config, rhs.incremental_state_config))
    return true;
  if (std::less<>{}(rhs.incremental_state_config, lhs.incremental_state_config))
    return false;
  if (std::less<>{}(lhs.duration_ms, rhs.duration_ms))
    return true;
  if (std::less<>{}(rhs.duration_ms, lhs.duration_ms))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace tracing

namespace mojo {


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunksToMove::DataView,
                                         ::tracing::mojom::ChunksToMovePtr> {
  static bool IsNull(const ::tracing::mojom::ChunksToMovePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunksToMovePtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunksToMove::page) page(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->page;
  }

  static decltype(::tracing::mojom::ChunksToMove::chunk) chunk(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->chunk;
  }

  static decltype(::tracing::mojom::ChunksToMove::target_buffer) target_buffer(
      const ::tracing::mojom::ChunksToMovePtr& input) {
    return input->target_buffer;
  }

  static bool Read(::tracing::mojom::ChunksToMove::DataView input, ::tracing::mojom::ChunksToMovePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunkPatch::DataView,
                                         ::tracing::mojom::ChunkPatchPtr> {
  static bool IsNull(const ::tracing::mojom::ChunkPatchPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunkPatchPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunkPatch::offset) offset(
      const ::tracing::mojom::ChunkPatchPtr& input) {
    return input->offset;
  }

  static const decltype(::tracing::mojom::ChunkPatch::data)& data(
      const ::tracing::mojom::ChunkPatchPtr& input) {
    return input->data;
  }

  static bool Read(::tracing::mojom::ChunkPatch::DataView input, ::tracing::mojom::ChunkPatchPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChunksToPatch::DataView,
                                         ::tracing::mojom::ChunksToPatchPtr> {
  static bool IsNull(const ::tracing::mojom::ChunksToPatchPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChunksToPatchPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::ChunksToPatch::target_buffer) target_buffer(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->target_buffer;
  }

  static decltype(::tracing::mojom::ChunksToPatch::writer_id) writer_id(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->writer_id;
  }

  static decltype(::tracing::mojom::ChunksToPatch::chunk_id) chunk_id(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->chunk_id;
  }

  static const decltype(::tracing::mojom::ChunksToPatch::patches)& patches(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->patches;
  }

  static decltype(::tracing::mojom::ChunksToPatch::has_more_patches) has_more_patches(
      const ::tracing::mojom::ChunksToPatchPtr& input) {
    return input->has_more_patches;
  }

  static bool Read(::tracing::mojom::ChunksToPatch::DataView input, ::tracing::mojom::ChunksToPatchPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::CommitDataRequest::DataView,
                                         ::tracing::mojom::CommitDataRequestPtr> {
  static bool IsNull(const ::tracing::mojom::CommitDataRequestPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::CommitDataRequestPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::CommitDataRequest::chunks_to_move)& chunks_to_move(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->chunks_to_move;
  }

  static const decltype(::tracing::mojom::CommitDataRequest::chunks_to_patch)& chunks_to_patch(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->chunks_to_patch;
  }

  static decltype(::tracing::mojom::CommitDataRequest::flush_request_id) flush_request_id(
      const ::tracing::mojom::CommitDataRequestPtr& input) {
    return input->flush_request_id;
  }

  static bool Read(::tracing::mojom::CommitDataRequest::DataView input, ::tracing::mojom::CommitDataRequestPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ChromeConfig::DataView,
                                         ::tracing::mojom::ChromeConfigPtr> {
  static bool IsNull(const ::tracing::mojom::ChromeConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ChromeConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::ChromeConfig::trace_config)& trace_config(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->trace_config;
  }

  static decltype(::tracing::mojom::ChromeConfig::privacy_filtering_enabled) privacy_filtering_enabled(
      const ::tracing::mojom::ChromeConfigPtr& input) {
    return input->privacy_filtering_enabled;
  }

  static bool Read(::tracing::mojom::ChromeConfig::DataView input, ::tracing::mojom::ChromeConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSourceConfig::DataView,
                                         ::tracing::mojom::DataSourceConfigPtr> {
  static bool IsNull(const ::tracing::mojom::DataSourceConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourceConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSourceConfig::name)& name(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->name;
  }

  static decltype(::tracing::mojom::DataSourceConfig::target_buffer) target_buffer(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->target_buffer;
  }

  static decltype(::tracing::mojom::DataSourceConfig::trace_duration_ms) trace_duration_ms(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->trace_duration_ms;
  }

  static decltype(::tracing::mojom::DataSourceConfig::tracing_session_id) tracing_session_id(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->tracing_session_id;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::chrome_config)& chrome_config(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->chrome_config;
  }

  static const decltype(::tracing::mojom::DataSourceConfig::legacy_config)& legacy_config(
      const ::tracing::mojom::DataSourceConfigPtr& input) {
    return input->legacy_config;
  }

  static bool Read(::tracing::mojom::DataSourceConfig::DataView input, ::tracing::mojom::DataSourceConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSourceRegistration::DataView,
                                         ::tracing::mojom::DataSourceRegistrationPtr> {
  static bool IsNull(const ::tracing::mojom::DataSourceRegistrationPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourceRegistrationPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSourceRegistration::name)& name(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->name;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::will_notify_on_start) will_notify_on_start(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->will_notify_on_start;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::will_notify_on_stop) will_notify_on_stop(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->will_notify_on_stop;
  }

  static decltype(::tracing::mojom::DataSourceRegistration::handles_incremental_state_clear) handles_incremental_state_clear(
      const ::tracing::mojom::DataSourceRegistrationPtr& input) {
    return input->handles_incremental_state_clear;
  }

  static bool Read(::tracing::mojom::DataSourceRegistration::DataView input, ::tracing::mojom::DataSourceRegistrationPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::BufferConfig::DataView,
                                         ::tracing::mojom::BufferConfigPtr> {
  static bool IsNull(const ::tracing::mojom::BufferConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::BufferConfigPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::BufferConfig::size_kb) size_kb(
      const ::tracing::mojom::BufferConfigPtr& input) {
    return input->size_kb;
  }

  static decltype(::tracing::mojom::BufferConfig::fill_policy) fill_policy(
      const ::tracing::mojom::BufferConfigPtr& input) {
    return input->fill_policy;
  }

  static bool Read(::tracing::mojom::BufferConfig::DataView input, ::tracing::mojom::BufferConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::DataSource::DataView,
                                         ::tracing::mojom::DataSourcePtr> {
  static bool IsNull(const ::tracing::mojom::DataSourcePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::DataSourcePtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::DataSource::config)& config(
      const ::tracing::mojom::DataSourcePtr& input) {
    return input->config;
  }

  static const decltype(::tracing::mojom::DataSource::producer_name_filter)& producer_name_filter(
      const ::tracing::mojom::DataSourcePtr& input) {
    return input->producer_name_filter;
  }

  static bool Read(::tracing::mojom::DataSource::DataView input, ::tracing::mojom::DataSourcePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::PerfettoBuiltinDataSource::DataView,
                                         ::tracing::mojom::PerfettoBuiltinDataSourcePtr> {
  static bool IsNull(const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::PerfettoBuiltinDataSourcePtr* output) { output->reset(); }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_clock_snapshotting) disable_clock_snapshotting(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_clock_snapshotting;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_trace_config) disable_trace_config(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_trace_config;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_system_info) disable_system_info(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_system_info;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::disable_service_events) disable_service_events(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->disable_service_events;
  }

  static decltype(::tracing::mojom::PerfettoBuiltinDataSource::primary_trace_clock_id) primary_trace_clock_id(
      const ::tracing::mojom::PerfettoBuiltinDataSourcePtr& input) {
    return input->primary_trace_clock_id;
  }

  static bool Read(::tracing::mojom::PerfettoBuiltinDataSource::DataView input, ::tracing::mojom::PerfettoBuiltinDataSourcePtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::IncrementalStateConfig::DataView,
                                         ::tracing::mojom::IncrementalStateConfigPtr> {
  static bool IsNull(const ::tracing::mojom::IncrementalStateConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::IncrementalStateConfigPtr* output) { output->reset(); }

  static decltype(::tracing::mojom::IncrementalStateConfig::clear_period_ms) clear_period_ms(
      const ::tracing::mojom::IncrementalStateConfigPtr& input) {
    return input->clear_period_ms;
  }

  static bool Read(::tracing::mojom::IncrementalStateConfig::DataView input, ::tracing::mojom::IncrementalStateConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::TraceConfig::DataView,
                                         ::tracing::mojom::TraceConfigPtr> {
  static bool IsNull(const ::tracing::mojom::TraceConfigPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::TraceConfigPtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::TraceConfig::data_sources)& data_sources(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->data_sources;
  }

  static const decltype(::tracing::mojom::TraceConfig::perfetto_builtin_data_source)& perfetto_builtin_data_source(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->perfetto_builtin_data_source;
  }

  static const decltype(::tracing::mojom::TraceConfig::buffers)& buffers(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->buffers;
  }

  static const decltype(::tracing::mojom::TraceConfig::incremental_state_config)& incremental_state_config(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->incremental_state_config;
  }

  static decltype(::tracing::mojom::TraceConfig::duration_ms) duration_ms(
      const ::tracing::mojom::TraceConfigPtr& input) {
    return input->duration_ms;
  }

  static bool Read(::tracing::mojom::TraceConfig::DataView input, ::tracing::mojom::TraceConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_H_