// services/video_capture/public/mojom/video_source.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_source.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/video_source.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_source.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_source.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char PushVideoStreamSubscription::Name_[] = "video_capture.mojom.PushVideoStreamSubscription";

class PushVideoStreamSubscription_Suspend_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_Suspend_ForwardToCallback(
      PushVideoStreamSubscription::SuspendCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::SuspendCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_Suspend_ForwardToCallback);
};

class PushVideoStreamSubscription_GetPhotoState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_GetPhotoState_ForwardToCallback(
      PushVideoStreamSubscription::GetPhotoStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::GetPhotoStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_GetPhotoState_ForwardToCallback);
};

class PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback(
      PushVideoStreamSubscription::SetPhotoOptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::SetPhotoOptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback);
};

class PushVideoStreamSubscription_TakePhoto_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_TakePhoto_ForwardToCallback(
      PushVideoStreamSubscription::TakePhotoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::TakePhotoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_TakePhoto_ForwardToCallback);
};

class PushVideoStreamSubscription_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushVideoStreamSubscription_Close_ForwardToCallback(
      PushVideoStreamSubscription::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PushVideoStreamSubscription::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_Close_ForwardToCallback);
};

PushVideoStreamSubscriptionProxy::PushVideoStreamSubscriptionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PushVideoStreamSubscriptionProxy::Activate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::Activate");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Activate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Activate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Activate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PushVideoStreamSubscriptionProxy::Suspend(
    SuspendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::Suspend");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Suspend_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Suspend_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Suspend");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_Suspend_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushVideoStreamSubscriptionProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::Resume");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Resume_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Resume_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PushVideoStreamSubscriptionProxy::GetPhotoState(
    GetPhotoStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::GetPhotoState");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_GetPhotoState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_GetPhotoState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("GetPhotoState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_GetPhotoState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushVideoStreamSubscriptionProxy::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr in_settings, SetPhotoOptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_settings.is_null()) {
        raw_value->SetString("settings", "nullptr");
      } else {
        raw_value->BeginDictionary("settings");
        in_settings->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_SetPhotoOptions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->settings)::BaseType::BufferWriter
      settings_writer;
  mojo::internal::Serialize<::media::mojom::PhotoSettingsDataView>(
      in_settings, buffer, &settings_writer, &serialization_context);
  params->settings.Set(
      settings_writer.is_null() ? nullptr : settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in PushVideoStreamSubscription.SetPhotoOptions request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("SetPhotoOptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushVideoStreamSubscriptionProxy::TakePhoto(
    TakePhotoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::TakePhoto");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_TakePhoto_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_TakePhoto_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("TakePhoto");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_TakePhoto_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PushVideoStreamSubscriptionProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::PushVideoStreamSubscription::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Close_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushVideoStreamSubscription_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PushVideoStreamSubscription_Suspend_ProxyToResponder {
 public:
  static PushVideoStreamSubscription::SuspendCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushVideoStreamSubscription_Suspend_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_Suspend_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushVideoStreamSubscription_Suspend_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_Suspend_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushVideoStreamSubscription_Suspend_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::SuspendCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_Suspend_ProxyToResponder);
};

bool PushVideoStreamSubscription_Suspend_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::PushVideoStreamSubscription::SuspendCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PushVideoStreamSubscription_Suspend_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PushVideoStreamSubscription_Suspend_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::SuspendCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Suspend_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::SuspendCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Suspend");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_GetPhotoState_ProxyToResponder {
 public:
  static PushVideoStreamSubscription::GetPhotoStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushVideoStreamSubscription_GetPhotoState_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_GetPhotoState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_GetPhotoState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushVideoStreamSubscription_GetPhotoState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::GetPhotoStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::PhotoStatePtr in_capabilities);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_GetPhotoState_ProxyToResponder);
};

bool PushVideoStreamSubscription_GetPhotoState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::PushVideoStreamSubscription::GetPhotoStateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::media::mojom::PhotoStatePtr p_capabilities{};
  PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_capabilities));
  return true;
}

void PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::Run(
    ::media::mojom::PhotoStatePtr in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::GetPhotoStateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_capabilities.is_null()) {
        raw_value->SetString("capabilities", "nullptr");
      } else {
        raw_value->BeginDictionary("capabilities");
        in_capabilities->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_GetPhotoState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->capabilities)::BaseType::BufferWriter
      capabilities_writer;
  mojo::internal::Serialize<::media::mojom::PhotoStateDataView>(
      in_capabilities, buffer, &capabilities_writer, &serialization_context);
  params->capabilities.Set(
      capabilities_writer.is_null() ? nullptr : capabilities_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::GetPhotoStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("GetPhotoState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder {
 public:
  static PushVideoStreamSubscription::SetPhotoOptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::SetPhotoOptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder);
};

bool PushVideoStreamSubscription_SetPhotoOptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptionsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  PushVideoStreamSubscription_SetPhotoOptions_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptionsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_SetPhotoOptions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("SetPhotoOptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_TakePhoto_ProxyToResponder {
 public:
  static PushVideoStreamSubscription::TakePhotoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushVideoStreamSubscription_TakePhoto_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_TakePhoto_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushVideoStreamSubscription_TakePhoto_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_TakePhoto_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushVideoStreamSubscription_TakePhoto_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::TakePhotoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::BlobPtr in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_TakePhoto_ProxyToResponder);
};

bool PushVideoStreamSubscription_TakePhoto_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::PushVideoStreamSubscription::TakePhotoCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::media::mojom::BlobPtr p_blob{};
  PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void PushVideoStreamSubscription_TakePhoto_ProxyToResponder::Run(
    ::media::mojom::BlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::TakePhotoCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_blob.is_null()) {
        raw_value->SetString("blob", "nullptr");
      } else {
        raw_value->BeginDictionary("blob");
        in_blob->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_TakePhoto_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->blob)::BaseType::BufferWriter
      blob_writer;
  mojo::internal::Serialize<::media::mojom::BlobDataView>(
      in_blob, buffer, &blob_writer, &serialization_context);
  params->blob.Set(
      blob_writer.is_null() ? nullptr : blob_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::TakePhotoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("TakePhoto");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushVideoStreamSubscription_Close_ProxyToResponder {
 public:
  static PushVideoStreamSubscription::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PushVideoStreamSubscription_Close_ProxyToResponder> proxy(
        new PushVideoStreamSubscription_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PushVideoStreamSubscription_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushVideoStreamSubscription_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PushVideoStreamSubscription_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PushVideoStreamSubscription::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PushVideoStreamSubscription_Close_ProxyToResponder);
};

bool PushVideoStreamSubscription_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::PushVideoStreamSubscription::CloseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PushVideoStreamSubscription_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushVideoStreamSubscription_Close_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PushVideoStreamSubscription_Close_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushVideoStreamSubscription::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PushVideoStreamSubscription_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPushVideoStreamSubscription_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::PushVideoStreamSubscription_Close_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::PushVideoStreamSubscription::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushVideoStreamSubscription::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PushVideoStreamSubscriptionStubDispatch::Accept(
    PushVideoStreamSubscription* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPushVideoStreamSubscription_Activate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Activate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::Activate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PushVideoStreamSubscription_Activate_Params_Data* params =
          reinterpret_cast<internal::PushVideoStreamSubscription_Activate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_Activate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Activate();
      return true;
    }
    case internal::kPushVideoStreamSubscription_Suspend_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PushVideoStreamSubscription_Resume_Params_Data* params =
          reinterpret_cast<internal::PushVideoStreamSubscription_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_Resume_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume();
      return true;
    }
    case internal::kPushVideoStreamSubscription_GetPhotoState_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_SetPhotoOptions_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_TakePhoto_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool PushVideoStreamSubscriptionStubDispatch::AcceptWithResponder(
    PushVideoStreamSubscription* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPushVideoStreamSubscription_Activate_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_Suspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Suspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::Suspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushVideoStreamSubscription_Suspend_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_Suspend_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_Suspend_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 1, false);
        return false;
      }
      PushVideoStreamSubscription::SuspendCallback callback =
          PushVideoStreamSubscription_Suspend_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(std::move(callback));
      return true;
    }
    case internal::kPushVideoStreamSubscription_Resume_Name: {
      break;
    }
    case internal::kPushVideoStreamSubscription_GetPhotoState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::GetPhotoState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::GetPhotoState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushVideoStreamSubscription_GetPhotoState_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_GetPhotoState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_GetPhotoState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 3, false);
        return false;
      }
      PushVideoStreamSubscription::GetPhotoStateCallback callback =
          PushVideoStreamSubscription_GetPhotoState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPhotoState(std::move(callback));
      return true;
    }
    case internal::kPushVideoStreamSubscription_SetPhotoOptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::SetPhotoOptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PhotoSettingsPtr p_settings{};
      PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 4, false);
        return false;
      }
      PushVideoStreamSubscription::SetPhotoOptionsCallback callback =
          PushVideoStreamSubscription_SetPhotoOptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPhotoOptions(
std::move(p_settings), std::move(callback));
      return true;
    }
    case internal::kPushVideoStreamSubscription_TakePhoto_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::TakePhoto",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::TakePhoto");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushVideoStreamSubscription_TakePhoto_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_TakePhoto_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_TakePhoto_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 5, false);
        return false;
      }
      PushVideoStreamSubscription::TakePhotoCallback callback =
          PushVideoStreamSubscription_TakePhoto_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakePhoto(std::move(callback));
      return true;
    }
    case internal::kPushVideoStreamSubscription_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::PushVideoStreamSubscription::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::PushVideoStreamSubscription::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PushVideoStreamSubscription_Close_Params_Data* params =
          reinterpret_cast<
              internal::PushVideoStreamSubscription_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PushVideoStreamSubscription_Close_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushVideoStreamSubscription::Name_, 6, false);
        return false;
      }
      PushVideoStreamSubscription::CloseCallback callback =
          PushVideoStreamSubscription_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPushVideoStreamSubscriptionValidationInfo[] = {
    {internal::kPushVideoStreamSubscription_Activate_Name,
     {&internal::PushVideoStreamSubscription_Activate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPushVideoStreamSubscription_Suspend_Name,
     {&internal::PushVideoStreamSubscription_Suspend_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data::Validate}},
    {internal::kPushVideoStreamSubscription_Resume_Name,
     {&internal::PushVideoStreamSubscription_Resume_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPushVideoStreamSubscription_GetPhotoState_Name,
     {&internal::PushVideoStreamSubscription_GetPhotoState_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::Validate}},
    {internal::kPushVideoStreamSubscription_SetPhotoOptions_Name,
     {&internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::Validate}},
    {internal::kPushVideoStreamSubscription_TakePhoto_Name,
     {&internal::PushVideoStreamSubscription_TakePhoto_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::Validate}},
    {internal::kPushVideoStreamSubscription_Close_Name,
     {&internal::PushVideoStreamSubscription_Close_Params_Data::Validate,
      &internal::PushVideoStreamSubscription_Close_ResponseParams_Data::Validate}},
};

bool PushVideoStreamSubscriptionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::PushVideoStreamSubscription::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPushVideoStreamSubscriptionValidationInfo);
}

bool PushVideoStreamSubscriptionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::PushVideoStreamSubscription::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPushVideoStreamSubscriptionValidationInfo);

}
const char VideoSource::Name_[] = "video_capture.mojom.VideoSource";

class VideoSource_CreatePushSubscription_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSource_CreatePushSubscription_ForwardToCallback(
      VideoSource::CreatePushSubscriptionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoSource::CreatePushSubscriptionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoSource_CreatePushSubscription_ForwardToCallback);
};

VideoSourceProxy::VideoSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoSourceProxy::CreatePushSubscription(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> in_subscriber, const ::media::VideoCaptureParams& in_requested_settings, bool in_force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> in_subscription, CreatePushSubscriptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoSource::CreatePushSubscription", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("subscriber", in_subscriber.is_valid());
      raw_value->SetString("requested_settings", base::trace_event::ValueToString(in_requested_settings, "<value of type const ::media::VideoCaptureParams&>"));
      raw_value->SetBoolean("force_reopen_with_new_settings", in_force_reopen_with_new_settings);
      raw_value->SetBoolean("subscription", in_subscription.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSource_CreatePushSubscription_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::VideoSource_CreatePushSubscription_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
      in_subscriber, &params->subscriber, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscriber),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscriber in VideoSource.CreatePushSubscription request");
  typename decltype(params->requested_settings)::BaseType::BufferWriter
      requested_settings_writer;
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_requested_settings, buffer, &requested_settings_writer, &serialization_context);
  params->requested_settings.Set(
      requested_settings_writer.is_null() ? nullptr : requested_settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_settings in VideoSource.CreatePushSubscription request");
  params->force_reopen_with_new_settings = in_force_reopen_with_new_settings;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::PushVideoStreamSubscriptionInterfaceBase>>(
      in_subscription, &params->subscription, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->subscription),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid subscription in VideoSource.CreatePushSubscription request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("CreatePushSubscription");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSource_CreatePushSubscription_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VideoSource_CreatePushSubscription_ProxyToResponder {
 public:
  static VideoSource::CreatePushSubscriptionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoSource_CreatePushSubscription_ProxyToResponder> proxy(
        new VideoSource_CreatePushSubscription_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoSource_CreatePushSubscription_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSource_CreatePushSubscription_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoSource_CreatePushSubscription_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoSource::CreatePushSubscriptionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreatePushSubscriptionResultCode in_result_code, const ::media::VideoCaptureParams& in_settings_source_was_opened_with);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoSource_CreatePushSubscription_ProxyToResponder);
};

bool VideoSource_CreatePushSubscription_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::VideoSource::CreatePushSubscriptionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VideoSource_CreatePushSubscription_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSource_CreatePushSubscription_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CreatePushSubscriptionResultCode p_result_code{};
  ::media::VideoCaptureParams p_settings_source_was_opened_with{};
  VideoSource_CreatePushSubscription_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (success && !input_data_view.ReadSettingsSourceWasOpenedWith(&p_settings_source_was_opened_with))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSource::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result_code), 
std::move(p_settings_source_was_opened_with));
  return true;
}

void VideoSource_CreatePushSubscription_ProxyToResponder::Run(
    CreatePushSubscriptionResultCode in_result_code, const ::media::VideoCaptureParams& in_settings_source_was_opened_with) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::VideoSource::CreatePushSubscriptionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result_code", base::trace_event::ValueToString(in_result_code));
      raw_value->SetString("settings_source_was_opened_with", base::trace_event::ValueToString(in_settings_source_was_opened_with, "<value of type const ::media::VideoCaptureParams&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSource_CreatePushSubscription_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::VideoSource_CreatePushSubscription_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::video_capture::mojom::CreatePushSubscriptionResultCode>(
      in_result_code, &params->result_code);
  typename decltype(params->settings_source_was_opened_with)::BaseType::BufferWriter
      settings_source_was_opened_with_writer;
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_settings_source_was_opened_with, buffer, &settings_source_was_opened_with_writer, &serialization_context);
  params->settings_source_was_opened_with.Set(
      settings_source_was_opened_with_writer.is_null() ? nullptr : settings_source_was_opened_with_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings_source_was_opened_with.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings_source_was_opened_with in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::VideoSource::CreatePushSubscriptionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSource::Name_);
  message.set_method_name("CreatePushSubscription");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoSourceStubDispatch::Accept(
    VideoSource* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kVideoSource_CreatePushSubscription_Name: {
      break;
    }
  }
  return false;
}

// static
bool VideoSourceStubDispatch::AcceptWithResponder(
    VideoSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoSource_CreatePushSubscription_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSource::CreatePushSubscription",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSource::CreatePushSubscription");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoSource_CreatePushSubscription_Params_Data* params =
          reinterpret_cast<
              internal::VideoSource_CreatePushSubscription_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> p_subscriber{};
      ::media::VideoCaptureParams p_requested_settings{};
      bool p_force_reopen_with_new_settings{};
      ::mojo::PendingReceiver<PushVideoStreamSubscription> p_subscription{};
      VideoSource_CreatePushSubscription_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_subscriber =
            input_data_view.TakeSubscriber<decltype(p_subscriber)>();
      }
      if (success && !input_data_view.ReadRequestedSettings(&p_requested_settings))
        success = false;
      if (success)
        p_force_reopen_with_new_settings = input_data_view.force_reopen_with_new_settings();
      if (success) {
        p_subscription =
            input_data_view.TakeSubscription<decltype(p_subscription)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSource::Name_, 0, false);
        return false;
      }
      VideoSource::CreatePushSubscriptionCallback callback =
          VideoSource_CreatePushSubscription_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePushSubscription(
std::move(p_subscriber), 
std::move(p_requested_settings), 
std::move(p_force_reopen_with_new_settings), 
std::move(p_subscription), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoSourceValidationInfo[] = {
    {internal::kVideoSource_CreatePushSubscription_Name,
     {&internal::VideoSource_CreatePushSubscription_Params_Data::Validate,
      &internal::VideoSource_CreatePushSubscription_ResponseParams_Data::Validate}},
};

bool VideoSourceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSource::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoSourceValidationInfo);
}

bool VideoSourceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSource::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoSourceValidationInfo);

}
}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif