// third_party/blink/public/mojom/contacts/contacts_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTACTS_CONTACTS_MANAGER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTACTS_CONTACTS_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/contacts/contacts_manager.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class ContactIconBlobDataView;

class ContactInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ContactIconBlobDataView> {
  using Data = ::blink::mojom::internal::ContactIconBlob_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ContactInfoDataView> {
  using Data = ::blink::mojom::internal::ContactInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class ContactsManagerInterfaceBase {};

using ContactsManagerPtrDataView =
    mojo::InterfacePtrDataView<ContactsManagerInterfaceBase>;
using ContactsManagerRequestDataView =
    mojo::InterfaceRequestDataView<ContactsManagerInterfaceBase>;
using ContactsManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContactsManagerInterfaceBase>;
using ContactsManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContactsManagerInterfaceBase>;


class ContactIconBlobDataView {
 public:
  ContactIconBlobDataView() {}

  ContactIconBlobDataView(
      internal::ContactIconBlob_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::ContactIconBlob_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ContactInfoDataView {
 public:
  ContactInfoDataView() {}

  ContactInfoDataView(
      internal::ContactInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetEmailDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEmail(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `email` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmail` instead "
    "of `ReadEmail if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetTelDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `tel` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTel` instead "
    "of `ReadTel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tel.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetAddressDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAddress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>, UserType>(),
    "Attempting to read the optional `address` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAddress` instead "
    "of `ReadAddress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>>(
        pointer, output, context_);
  }
  inline void GetIconDataView(
      mojo::ArrayDataView<ContactIconBlobDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::ContactIconBlobDataView>, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ContactIconBlobDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ContactInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContactIconBlobDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContactIconBlobDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ContactIconBlob_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    typename decltype((*output)->mime_type)::BaseType::BufferWriter
        mime_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, buffer, &mime_type_writer, context);
    (*output)->mime_type.Set(
        mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in ContactIconBlob struct");
    decltype(Traits::data(input)) in_data = Traits::data(input);
    typename decltype((*output)->data)::BaseType::BufferWriter
        data_writer;
    const mojo::internal::ContainerValidateParams data_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_data, buffer, &data_writer, &data_validate_params,
        context);
    (*output)->data.Set(
        data_writer.is_null() ? nullptr : data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in ContactIconBlob struct");
  }

  static bool Deserialize(::blink::mojom::internal::ContactIconBlob_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContactIconBlobDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContactInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContactInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ContactInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    const mojo::internal::ContainerValidateParams name_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_name, buffer, &name_writer, &name_validate_params,
        context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    decltype(Traits::email(input)) in_email = Traits::email(input);
    typename decltype((*output)->email)::BaseType::BufferWriter
        email_writer;
    const mojo::internal::ContainerValidateParams email_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_email, buffer, &email_writer, &email_validate_params,
        context);
    (*output)->email.Set(
        email_writer.is_null() ? nullptr : email_writer.data());
    decltype(Traits::tel(input)) in_tel = Traits::tel(input);
    typename decltype((*output)->tel)::BaseType::BufferWriter
        tel_writer;
    const mojo::internal::ContainerValidateParams tel_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_tel, buffer, &tel_writer, &tel_validate_params,
        context);
    (*output)->tel.Set(
        tel_writer.is_null() ? nullptr : tel_writer.data());
    decltype(Traits::address(input)) in_address = Traits::address(input);
    typename decltype((*output)->address)::BaseType::BufferWriter
        address_writer;
    const mojo::internal::ContainerValidateParams address_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>>(
        in_address, buffer, &address_writer, &address_validate_params,
        context);
    (*output)->address.Set(
        address_writer.is_null() ? nullptr : address_writer.data());
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    typename decltype((*output)->icon)::BaseType::BufferWriter
        icon_writer;
    const mojo::internal::ContainerValidateParams icon_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ContactIconBlobDataView>>(
        in_icon, buffer, &icon_writer, &icon_validate_params,
        context);
    (*output)->icon.Set(
        icon_writer.is_null() ? nullptr : icon_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::ContactInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContactInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ContactIconBlobDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ContactIconBlobDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void ContactInfoDataView::GetNameDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->name.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void ContactInfoDataView::GetEmailDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->email.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void ContactInfoDataView::GetTelDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->tel.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void ContactInfoDataView::GetAddressDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>* output) {
  auto pointer = data_->address.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentAddressDataView>(pointer, context_);
}
inline void ContactInfoDataView::GetIconDataView(
    mojo::ArrayDataView<ContactIconBlobDataView>* output) {
  auto pointer = data_->icon.Get();
  *output = mojo::ArrayDataView<ContactIconBlobDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTACTS_CONTACTS_MANAGER_MOJOM_SHARED_H_