// third_party/blink/public/mojom/frame/frame_owner_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/scroll/scrollbar_mode.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/frame/frame_owner_properties_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"




namespace WTF {
struct blink_mojom_internal_ColorScheme_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ColorScheme& value) {
    using utype = std::underlying_type<::blink::mojom::ColorScheme>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ColorScheme& left, const ::blink::mojom::ColorScheme& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ColorScheme>
    : public GenericHashTraits<::blink::mojom::ColorScheme> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ColorScheme& value) {
    return value == static_cast<::blink::mojom::ColorScheme>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ColorScheme& slot, bool) {
    slot = static_cast<::blink::mojom::ColorScheme>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ColorScheme& value) {
    return value == static_cast<::blink::mojom::ColorScheme>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {








class CORE_EXPORT FrameOwnerProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameOwnerProperties, T>::value>;
  using DataView = FrameOwnerPropertiesDataView;
  using Data_ = internal::FrameOwnerProperties_Data;

  template <typename... Args>
  static FrameOwnerPropertiesPtr New(Args&&... args) {
    return FrameOwnerPropertiesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameOwnerPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<FrameOwnerPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameOwnerProperties>::Convert(*this);
  }


  FrameOwnerProperties();

  FrameOwnerProperties(
      const WTF::String& name,
      ::blink::mojom::blink::ScrollbarMode scrollbar_mode,
      int32_t margin_width,
      int32_t margin_height,
      bool allow_fullscreen,
      bool allow_payment_request,
      bool is_display_none,
      ::blink::ColorScheme color_scheme,
      const WTF::String& required_csp);

  ~FrameOwnerProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameOwnerPropertiesPtr>
  FrameOwnerPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameOwnerProperties::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameOwnerProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameOwnerProperties_UnserializedMessageContext<
            UserType, FrameOwnerProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FrameOwnerProperties::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FrameOwnerProperties::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameOwnerProperties_UnserializedMessageContext<
            UserType, FrameOwnerProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameOwnerProperties::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String name;
  
  ::blink::mojom::blink::ScrollbarMode scrollbar_mode;
  
  int32_t margin_width;
  
  int32_t margin_height;
  
  bool allow_fullscreen;
  
  bool allow_payment_request;
  
  bool is_display_none;
  
  ::blink::ColorScheme color_scheme;
  
  WTF::String required_csp;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameOwnerPropertiesPtr FrameOwnerProperties::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(scrollbar_mode),
      mojo::Clone(margin_width),
      mojo::Clone(margin_height),
      mojo::Clone(allow_fullscreen),
      mojo::Clone(allow_payment_request),
      mojo::Clone(is_display_none),
      mojo::Clone(color_scheme),
      mojo::Clone(required_csp)
  );
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>*>
bool FrameOwnerProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->scrollbar_mode, other_struct.scrollbar_mode))
    return false;
  if (!mojo::Equals(this->margin_width, other_struct.margin_width))
    return false;
  if (!mojo::Equals(this->margin_height, other_struct.margin_height))
    return false;
  if (!mojo::Equals(this->allow_fullscreen, other_struct.allow_fullscreen))
    return false;
  if (!mojo::Equals(this->allow_payment_request, other_struct.allow_payment_request))
    return false;
  if (!mojo::Equals(this->is_display_none, other_struct.is_display_none))
    return false;
  if (!mojo::Equals(this->color_scheme, other_struct.color_scheme))
    return false;
  if (!mojo::Equals(this->required_csp, other_struct.required_csp))
    return false;
  return true;
}

template <typename T, FrameOwnerProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.scrollbar_mode, rhs.scrollbar_mode))
    return true;
  if (std::less<>{}(rhs.scrollbar_mode, lhs.scrollbar_mode))
    return false;
  if (std::less<>{}(lhs.margin_width, rhs.margin_width))
    return true;
  if (std::less<>{}(rhs.margin_width, lhs.margin_width))
    return false;
  if (std::less<>{}(lhs.margin_height, rhs.margin_height))
    return true;
  if (std::less<>{}(rhs.margin_height, lhs.margin_height))
    return false;
  if (std::less<>{}(lhs.allow_fullscreen, rhs.allow_fullscreen))
    return true;
  if (std::less<>{}(rhs.allow_fullscreen, lhs.allow_fullscreen))
    return false;
  if (std::less<>{}(lhs.allow_payment_request, rhs.allow_payment_request))
    return true;
  if (std::less<>{}(rhs.allow_payment_request, lhs.allow_payment_request))
    return false;
  if (std::less<>{}(lhs.is_display_none, rhs.is_display_none))
    return true;
  if (std::less<>{}(rhs.is_display_none, lhs.is_display_none))
    return false;
  if (std::less<>{}(lhs.color_scheme, rhs.color_scheme))
    return true;
  if (std::less<>{}(rhs.color_scheme, lhs.color_scheme))
    return false;
  if (std::less<>{}(lhs.required_csp, rhs.required_csp))
    return true;
  if (std::less<>{}(rhs.required_csp, lhs.required_csp))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FrameOwnerProperties::DataView,
                                         ::blink::mojom::blink::FrameOwnerPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameOwnerPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FrameOwnerProperties::name)& name(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::scrollbar_mode) scrollbar_mode(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->scrollbar_mode;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::margin_width) margin_width(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->margin_width;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::margin_height) margin_height(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->margin_height;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::allow_fullscreen) allow_fullscreen(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->allow_fullscreen;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::allow_payment_request) allow_payment_request(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->allow_payment_request;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::is_display_none) is_display_none(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->is_display_none;
  }

  static decltype(::blink::mojom::blink::FrameOwnerProperties::color_scheme) color_scheme(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->color_scheme;
  }

  static const decltype(::blink::mojom::blink::FrameOwnerProperties::required_csp)& required_csp(
      const ::blink::mojom::blink::FrameOwnerPropertiesPtr& input) {
    return input->required_csp;
  }

  static bool Read(::blink::mojom::blink::FrameOwnerProperties::DataView input, ::blink::mojom::blink::FrameOwnerPropertiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_BLINK_H_