// third_party/blink/public/mojom/messaging/cloneable_message.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/messaging/cloneable_message.h"
#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT CloneableMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CloneableMessage, T>::value>;
  using DataView = CloneableMessageDataView;
  using Data_ = internal::CloneableMessage_Data;

  template <typename... Args>
  static CloneableMessagePtr New(Args&&... args) {
    return CloneableMessagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CloneableMessagePtr From(const U& u) {
    return mojo::TypeConverter<CloneableMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CloneableMessage>::Convert(*this);
  }


  CloneableMessage();

  CloneableMessage(
      ::mojo_base::BigBuffer encoded_message,
      std::vector<::blink::mojom::SerializedBlobPtr> blobs,
      const base::Optional<::url::Origin>& sender_origin,
      uint64_t stack_trace_id,
      int64_t stack_trace_debugger_id_first,
      int64_t stack_trace_debugger_id_second,
      bool stack_trace_should_pause,
      const base::Optional<::base::UnguessableToken>& locked_agent_cluster_id,
      std::vector<::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken>> native_file_system_tokens);

  ~CloneableMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CloneableMessagePtr>
  CloneableMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CloneableMessage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CloneableMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CloneableMessage_UnserializedMessageContext<
            UserType, CloneableMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CloneableMessage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CloneableMessage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CloneableMessage_UnserializedMessageContext<
            UserType, CloneableMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CloneableMessage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo_base::BigBuffer encoded_message;
  
  std::vector<::blink::mojom::SerializedBlobPtr> blobs;
  
  base::Optional<::url::Origin> sender_origin;
  
  uint64_t stack_trace_id;
  
  int64_t stack_trace_debugger_id_first;
  
  int64_t stack_trace_debugger_id_second;
  
  bool stack_trace_should_pause;
  
  base::Optional<::base::UnguessableToken> locked_agent_cluster_id;
  
  std::vector<::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken>> native_file_system_tokens;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CloneableMessage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CloneableMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CloneableMessagePtr CloneableMessage::Clone() const {
  return New(
      mojo::Clone(encoded_message),
      mojo::Clone(blobs),
      mojo::Clone(sender_origin),
      mojo::Clone(stack_trace_id),
      mojo::Clone(stack_trace_debugger_id_first),
      mojo::Clone(stack_trace_debugger_id_second),
      mojo::Clone(stack_trace_should_pause),
      mojo::Clone(locked_agent_cluster_id),
      mojo::Clone(native_file_system_tokens)
  );
}

template <typename T, CloneableMessage::EnableIfSame<T>*>
bool CloneableMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encoded_message, other_struct.encoded_message))
    return false;
  if (!mojo::Equals(this->blobs, other_struct.blobs))
    return false;
  if (!mojo::Equals(this->sender_origin, other_struct.sender_origin))
    return false;
  if (!mojo::Equals(this->stack_trace_id, other_struct.stack_trace_id))
    return false;
  if (!mojo::Equals(this->stack_trace_debugger_id_first, other_struct.stack_trace_debugger_id_first))
    return false;
  if (!mojo::Equals(this->stack_trace_debugger_id_second, other_struct.stack_trace_debugger_id_second))
    return false;
  if (!mojo::Equals(this->stack_trace_should_pause, other_struct.stack_trace_should_pause))
    return false;
  if (!mojo::Equals(this->locked_agent_cluster_id, other_struct.locked_agent_cluster_id))
    return false;
  if (!mojo::Equals(this->native_file_system_tokens, other_struct.native_file_system_tokens))
    return false;
  return true;
}

template <typename T, CloneableMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.encoded_message, rhs.encoded_message))
    return true;
  if (std::less<>{}(rhs.encoded_message, lhs.encoded_message))
    return false;
  if (std::less<>{}(lhs.blobs, rhs.blobs))
    return true;
  if (std::less<>{}(rhs.blobs, lhs.blobs))
    return false;
  if (std::less<>{}(lhs.sender_origin, rhs.sender_origin))
    return true;
  if (std::less<>{}(rhs.sender_origin, lhs.sender_origin))
    return false;
  if (std::less<>{}(lhs.stack_trace_id, rhs.stack_trace_id))
    return true;
  if (std::less<>{}(rhs.stack_trace_id, lhs.stack_trace_id))
    return false;
  if (std::less<>{}(lhs.stack_trace_debugger_id_first, rhs.stack_trace_debugger_id_first))
    return true;
  if (std::less<>{}(rhs.stack_trace_debugger_id_first, lhs.stack_trace_debugger_id_first))
    return false;
  if (std::less<>{}(lhs.stack_trace_debugger_id_second, rhs.stack_trace_debugger_id_second))
    return true;
  if (std::less<>{}(rhs.stack_trace_debugger_id_second, lhs.stack_trace_debugger_id_second))
    return false;
  if (std::less<>{}(lhs.stack_trace_should_pause, rhs.stack_trace_should_pause))
    return true;
  if (std::less<>{}(rhs.stack_trace_should_pause, lhs.stack_trace_should_pause))
    return false;
  if (std::less<>{}(lhs.locked_agent_cluster_id, rhs.locked_agent_cluster_id))
    return true;
  if (std::less<>{}(rhs.locked_agent_cluster_id, lhs.locked_agent_cluster_id))
    return false;
  if (std::less<>{}(lhs.native_file_system_tokens, rhs.native_file_system_tokens))
    return true;
  if (std::less<>{}(rhs.native_file_system_tokens, lhs.native_file_system_tokens))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CloneableMessage::DataView,
                                         ::blink::mojom::CloneableMessagePtr> {
  static bool IsNull(const ::blink::mojom::CloneableMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CloneableMessagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::CloneableMessage::encoded_message)& encoded_message(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->encoded_message;
  }

  static  decltype(::blink::mojom::CloneableMessage::blobs)& blobs(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->blobs;
  }

  static const decltype(::blink::mojom::CloneableMessage::sender_origin)& sender_origin(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->sender_origin;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_id) stack_trace_id(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_id;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_debugger_id_first) stack_trace_debugger_id_first(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_debugger_id_first;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_debugger_id_second) stack_trace_debugger_id_second(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_debugger_id_second;
  }

  static decltype(::blink::mojom::CloneableMessage::stack_trace_should_pause) stack_trace_should_pause(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->stack_trace_should_pause;
  }

  static const decltype(::blink::mojom::CloneableMessage::locked_agent_cluster_id)& locked_agent_cluster_id(
      const ::blink::mojom::CloneableMessagePtr& input) {
    return input->locked_agent_cluster_id;
  }

  static  decltype(::blink::mojom::CloneableMessage::native_file_system_tokens)& native_file_system_tokens(
       ::blink::mojom::CloneableMessagePtr& input) {
    return input->native_file_system_tokens;
  }

  static bool Read(::blink::mojom::CloneableMessage::DataView input, ::blink::mojom::CloneableMessagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_H_