// third_party/blink/public/mojom/payments/payment_app.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom-blink-forward.h"
#include "components/payments/mojom/payment_request_data.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct payments_mojom_internal_PaymentHandlerStatus_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::PaymentHandlerStatus& value) {
    using utype = std::underlying_type<::payments::mojom::PaymentHandlerStatus>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::PaymentHandlerStatus& left, const ::payments::mojom::PaymentHandlerStatus& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::PaymentHandlerStatus>
    : public GenericHashTraits<::payments::mojom::PaymentHandlerStatus> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::PaymentHandlerStatus& value) {
    return value == static_cast<::payments::mojom::PaymentHandlerStatus>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::PaymentHandlerStatus& slot, bool) {
    slot = static_cast<::payments::mojom::PaymentHandlerStatus>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::PaymentHandlerStatus& value) {
    return value == static_cast<::payments::mojom::PaymentHandlerStatus>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct payments_mojom_internal_CanMakePaymentEventResponseType_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::CanMakePaymentEventResponseType& value) {
    using utype = std::underlying_type<::payments::mojom::CanMakePaymentEventResponseType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::CanMakePaymentEventResponseType& left, const ::payments::mojom::CanMakePaymentEventResponseType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::CanMakePaymentEventResponseType>
    : public GenericHashTraits<::payments::mojom::CanMakePaymentEventResponseType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::CanMakePaymentEventResponseType& value) {
    return value == static_cast<::payments::mojom::CanMakePaymentEventResponseType>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::CanMakePaymentEventResponseType& slot, bool) {
    slot = static_cast<::payments::mojom::CanMakePaymentEventResponseType>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::CanMakePaymentEventResponseType& value) {
    return value == static_cast<::payments::mojom::CanMakePaymentEventResponseType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct payments_mojom_internal_PaymentEventResponseType_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::PaymentEventResponseType& value) {
    using utype = std::underlying_type<::payments::mojom::PaymentEventResponseType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::PaymentEventResponseType& left, const ::payments::mojom::PaymentEventResponseType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::PaymentEventResponseType>
    : public GenericHashTraits<::payments::mojom::PaymentEventResponseType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::PaymentEventResponseType& value) {
    return value == static_cast<::payments::mojom::PaymentEventResponseType>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::PaymentEventResponseType& slot, bool) {
    slot = static_cast<::payments::mojom::PaymentEventResponseType>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::PaymentEventResponseType& value) {
    return value == static_cast<::payments::mojom::PaymentEventResponseType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct payments_mojom_internal_PaymentDelegation_DataHashFn {
  static unsigned GetHash(const ::payments::mojom::PaymentDelegation& value) {
    using utype = std::underlying_type<::payments::mojom::PaymentDelegation>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::payments::mojom::PaymentDelegation& left, const ::payments::mojom::PaymentDelegation& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::payments::mojom::PaymentDelegation>
    : public GenericHashTraits<::payments::mojom::PaymentDelegation> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::payments::mojom::PaymentDelegation& value) {
    return value == static_cast<::payments::mojom::PaymentDelegation>(-1000000);
  }
  static void ConstructDeletedValue(::payments::mojom::PaymentDelegation& slot, bool) {
    slot = static_cast<::payments::mojom::PaymentDelegation>(-1000001);
  }
  static bool IsDeletedValue(const ::payments::mojom::PaymentDelegation& value) {
    return value == static_cast<::payments::mojom::PaymentDelegation>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace payments {
namespace mojom {
namespace blink {

class PaymentManagerProxy;

template <typename ImplRefTraits>
class PaymentManagerStub;

class PaymentManagerRequestValidator;
class PaymentManagerResponseValidator;


class PLATFORM_EXPORT PaymentManager
    : public PaymentManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PaymentManagerInterfaceBase;
  using Proxy_ = PaymentManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentManagerStub<ImplRefTraits>;

  using RequestValidator_ = PaymentManagerRequestValidator;
  using ResponseValidator_ = PaymentManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitMinVersion = 0,
    kDeletePaymentInstrumentMinVersion = 0,
    kGetPaymentInstrumentMinVersion = 0,
    kKeysOfPaymentInstrumentsMinVersion = 0,
    kHasPaymentInstrumentMinVersion = 0,
    kSetPaymentInstrumentMinVersion = 0,
    kClearPaymentInstrumentsMinVersion = 0,
    kSetUserHintMinVersion = 0,
    kEnableDelegationsMinVersion = 0,
  };
  virtual ~PaymentManager() {}

  
  virtual void Init(const ::blink::KURL& context_url, const WTF::String& service_worker_scope) = 0;


  using DeletePaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  
  virtual void DeletePaymentInstrument(const WTF::String& instrument_key, DeletePaymentInstrumentCallback callback) = 0;


  using GetPaymentInstrumentCallback = base::OnceCallback<void(PaymentInstrumentPtr, PaymentHandlerStatus)>;
  
  virtual void GetPaymentInstrument(const WTF::String& instrument_key, GetPaymentInstrumentCallback callback) = 0;


  using KeysOfPaymentInstrumentsCallback = base::OnceCallback<void(const WTF::Vector<WTF::String>&, PaymentHandlerStatus)>;
  
  virtual void KeysOfPaymentInstruments(KeysOfPaymentInstrumentsCallback callback) = 0;


  using HasPaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  
  virtual void HasPaymentInstrument(const WTF::String& instrument_key, HasPaymentInstrumentCallback callback) = 0;


  using SetPaymentInstrumentCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  
  virtual void SetPaymentInstrument(const WTF::String& instrument_key, PaymentInstrumentPtr instrument, SetPaymentInstrumentCallback callback) = 0;


  using ClearPaymentInstrumentsCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  
  virtual void ClearPaymentInstruments(ClearPaymentInstrumentsCallback callback) = 0;

  
  virtual void SetUserHint(const WTF::String& user_hint) = 0;


  using EnableDelegationsCallback = base::OnceCallback<void(PaymentHandlerStatus)>;
  
  virtual void EnableDelegations(const WTF::Vector<PaymentDelegation>& delegations, EnableDelegationsCallback callback) = 0;
};

class PaymentHandlerResponseCallbackProxy;

template <typename ImplRefTraits>
class PaymentHandlerResponseCallbackStub;

class PaymentHandlerResponseCallbackRequestValidator;


class PLATFORM_EXPORT PaymentHandlerResponseCallback
    : public PaymentHandlerResponseCallbackInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PaymentHandlerResponseCallbackInterfaceBase;
  using Proxy_ = PaymentHandlerResponseCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentHandlerResponseCallbackStub<ImplRefTraits>;

  using RequestValidator_ = PaymentHandlerResponseCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseForAbortPaymentMinVersion = 0,
    kOnResponseForCanMakePaymentMinVersion = 0,
    kOnResponseForPaymentRequestMinVersion = 0,
  };
  virtual ~PaymentHandlerResponseCallback() {}

  
  virtual void OnResponseForAbortPayment(bool payment_aborted) = 0;

  
  virtual void OnResponseForCanMakePayment(CanMakePaymentResponsePtr response) = 0;

  
  virtual void OnResponseForPaymentRequest(PaymentHandlerResponsePtr response) = 0;
};



class PLATFORM_EXPORT PaymentManagerProxy
    : public PaymentManager {
 public:
  using InterfaceType = PaymentManager;

  explicit PaymentManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Init(const ::blink::KURL& context_url, const WTF::String& service_worker_scope) final;
  
  void DeletePaymentInstrument(const WTF::String& instrument_key, DeletePaymentInstrumentCallback callback) final;
  
  void GetPaymentInstrument(const WTF::String& instrument_key, GetPaymentInstrumentCallback callback) final;
  
  void KeysOfPaymentInstruments(KeysOfPaymentInstrumentsCallback callback) final;
  
  void HasPaymentInstrument(const WTF::String& instrument_key, HasPaymentInstrumentCallback callback) final;
  
  void SetPaymentInstrument(const WTF::String& instrument_key, PaymentInstrumentPtr instrument, SetPaymentInstrumentCallback callback) final;
  
  void ClearPaymentInstruments(ClearPaymentInstrumentsCallback callback) final;
  
  void SetUserHint(const WTF::String& user_hint) final;
  
  void EnableDelegations(const WTF::Vector<PaymentDelegation>& delegations, EnableDelegationsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PaymentHandlerResponseCallbackProxy
    : public PaymentHandlerResponseCallback {
 public:
  using InterfaceType = PaymentHandlerResponseCallback;

  explicit PaymentHandlerResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponseForAbortPayment(bool payment_aborted) final;
  
  void OnResponseForCanMakePayment(CanMakePaymentResponsePtr response) final;
  
  void OnResponseForPaymentRequest(PaymentHandlerResponsePtr response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PaymentManagerStubDispatch {
 public:
  static bool Accept(PaymentManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentManager>>
class PaymentManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentManagerStub() {}
  ~PaymentManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PaymentHandlerResponseCallbackStubDispatch {
 public:
  static bool Accept(PaymentHandlerResponseCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentHandlerResponseCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentHandlerResponseCallback>>
class PaymentHandlerResponseCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentHandlerResponseCallbackStub() {}
  ~PaymentHandlerResponseCallbackStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerResponseCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerResponseCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PaymentManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PaymentHandlerResponseCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PaymentManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT CanMakePaymentResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanMakePaymentResponse, T>::value>;
  using DataView = CanMakePaymentResponseDataView;
  using Data_ = internal::CanMakePaymentResponse_Data;

  template <typename... Args>
  static CanMakePaymentResponsePtr New(Args&&... args) {
    return CanMakePaymentResponsePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanMakePaymentResponsePtr From(const U& u) {
    return mojo::TypeConverter<CanMakePaymentResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanMakePaymentResponse>::Convert(*this);
  }


  CanMakePaymentResponse();

  CanMakePaymentResponse(
      CanMakePaymentEventResponseType response_type,
      bool can_make_payment,
      bool ready_for_minimal_ui,
      const WTF::String& account_balance);

  ~CanMakePaymentResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanMakePaymentResponsePtr>
  CanMakePaymentResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentResponse::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanMakePaymentResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanMakePaymentResponse_UnserializedMessageContext<
            UserType, CanMakePaymentResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CanMakePaymentResponse::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return CanMakePaymentResponse::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanMakePaymentResponse_UnserializedMessageContext<
            UserType, CanMakePaymentResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanMakePaymentResponse::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  CanMakePaymentEventResponseType response_type;
  
  bool can_make_payment;
  
  bool ready_for_minimal_ui;
  
  WTF::String account_balance;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT PaymentInstrument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentInstrument, T>::value>;
  using DataView = PaymentInstrumentDataView;
  using Data_ = internal::PaymentInstrument_Data;

  template <typename... Args>
  static PaymentInstrumentPtr New(Args&&... args) {
    return PaymentInstrumentPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentInstrumentPtr From(const U& u) {
    return mojo::TypeConverter<PaymentInstrumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentInstrument>::Convert(*this);
  }


  PaymentInstrument();

  PaymentInstrument(
      const WTF::String& name,
      WTF::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons,
      const WTF::String& method,
      const WTF::String& stringified_capabilities,
      WTF::Vector<::payments::mojom::blink::BasicCardNetwork> supported_networks);

  ~PaymentInstrument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentInstrumentPtr>
  PaymentInstrumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentInstrument::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentInstrument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentInstrument_UnserializedMessageContext<
            UserType, PaymentInstrument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentInstrument::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentInstrument::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentInstrument_UnserializedMessageContext<
            UserType, PaymentInstrument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentInstrument::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String name;
  
  WTF::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons;
  
  WTF::String method;
  
  WTF::String stringified_capabilities;
  
  WTF::Vector<::payments::mojom::blink::BasicCardNetwork> supported_networks;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PaymentInstrument);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentInstrument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CanMakePaymentEventData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanMakePaymentEventData, T>::value>;
  using DataView = CanMakePaymentEventDataDataView;
  using Data_ = internal::CanMakePaymentEventData_Data;

  template <typename... Args>
  static CanMakePaymentEventDataPtr New(Args&&... args) {
    return CanMakePaymentEventDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanMakePaymentEventDataPtr From(const U& u) {
    return mojo::TypeConverter<CanMakePaymentEventDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanMakePaymentEventData>::Convert(*this);
  }


  CanMakePaymentEventData();

  CanMakePaymentEventData(
      const ::blink::KURL& top_origin,
      const ::blink::KURL& payment_request_origin,
      WTF::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data,
      WTF::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers,
      const WTF::String& currency);

  ~CanMakePaymentEventData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanMakePaymentEventDataPtr>
  CanMakePaymentEventDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanMakePaymentEventData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanMakePaymentEventData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanMakePaymentEventData_UnserializedMessageContext<
            UserType, CanMakePaymentEventData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CanMakePaymentEventData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return CanMakePaymentEventData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanMakePaymentEventData_UnserializedMessageContext<
            UserType, CanMakePaymentEventData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanMakePaymentEventData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL top_origin;
  
  ::blink::KURL payment_request_origin;
  
  WTF::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data;
  
  WTF::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers;
  
  WTF::String currency;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CanMakePaymentEventData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PaymentRequestEventData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentRequestEventData, T>::value>;
  using DataView = PaymentRequestEventDataDataView;
  using Data_ = internal::PaymentRequestEventData_Data;

  template <typename... Args>
  static PaymentRequestEventDataPtr New(Args&&... args) {
    return PaymentRequestEventDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentRequestEventDataPtr From(const U& u) {
    return mojo::TypeConverter<PaymentRequestEventDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentRequestEventData>::Convert(*this);
  }


  PaymentRequestEventData();

  PaymentRequestEventData(
      const ::blink::KURL& top_origin,
      const ::blink::KURL& payment_request_origin,
      const WTF::String& payment_request_id,
      WTF::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data,
      ::payments::mojom::blink::PaymentCurrencyAmountPtr total,
      WTF::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers,
      const WTF::String& instrument_key,
      ::payments::mojom::blink::PaymentOptionsPtr payment_options,
      base::Optional<WTF::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options,
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerHost> payment_handler_host);

  ~PaymentRequestEventData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentRequestEventDataPtr>
  PaymentRequestEventDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentRequestEventData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentRequestEventData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentRequestEventData_UnserializedMessageContext<
            UserType, PaymentRequestEventData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentRequestEventData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentRequestEventData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentRequestEventData_UnserializedMessageContext<
            UserType, PaymentRequestEventData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentRequestEventData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL top_origin;
  
  ::blink::KURL payment_request_origin;
  
  WTF::String payment_request_id;
  
  WTF::Vector<::payments::mojom::blink::PaymentMethodDataPtr> method_data;
  
  ::payments::mojom::blink::PaymentCurrencyAmountPtr total;
  
  WTF::Vector<::payments::mojom::blink::PaymentDetailsModifierPtr> modifiers;
  
  WTF::String instrument_key;
  
  ::payments::mojom::blink::PaymentOptionsPtr payment_options;
  
  base::Optional<WTF::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options;
  
  ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerHost> payment_handler_host;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PaymentRequestEventData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PaymentHandlerResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentHandlerResponse, T>::value>;
  using DataView = PaymentHandlerResponseDataView;
  using Data_ = internal::PaymentHandlerResponse_Data;

  template <typename... Args>
  static PaymentHandlerResponsePtr New(Args&&... args) {
    return PaymentHandlerResponsePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentHandlerResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaymentHandlerResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentHandlerResponse>::Convert(*this);
  }


  PaymentHandlerResponse();

  PaymentHandlerResponse(
      const WTF::String& method_name,
      const WTF::String& stringified_details,
      PaymentEventResponseType response_type,
      const WTF::String& payer_name,
      const WTF::String& payer_email,
      const WTF::String& payer_phone,
      ::payments::mojom::blink::PaymentAddressPtr shipping_address,
      const WTF::String& shipping_option);

  ~PaymentHandlerResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentHandlerResponsePtr>
  PaymentHandlerResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentHandlerResponse::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentHandlerResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentHandlerResponse_UnserializedMessageContext<
            UserType, PaymentHandlerResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentHandlerResponse::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentHandlerResponse::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentHandlerResponse_UnserializedMessageContext<
            UserType, PaymentHandlerResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentHandlerResponse::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String method_name;
  
  WTF::String stringified_details;
  
  PaymentEventResponseType response_type;
  
  WTF::String payer_name;
  
  WTF::String payer_email;
  
  WTF::String payer_phone;
  
  ::payments::mojom::blink::PaymentAddressPtr shipping_address;
  
  WTF::String shipping_option;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerResponse);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaymentInstrumentPtr PaymentInstrument::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(icons),
      mojo::Clone(method),
      mojo::Clone(stringified_capabilities),
      mojo::Clone(supported_networks)
  );
}

template <typename T, PaymentInstrument::EnableIfSame<T>*>
bool PaymentInstrument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->stringified_capabilities, other_struct.stringified_capabilities))
    return false;
  if (!mojo::Equals(this->supported_networks, other_struct.supported_networks))
    return false;
  return true;
}

template <typename T, PaymentInstrument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.icons, rhs.icons))
    return true;
  if (std::less<>{}(rhs.icons, lhs.icons))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.stringified_capabilities, rhs.stringified_capabilities))
    return true;
  if (std::less<>{}(rhs.stringified_capabilities, lhs.stringified_capabilities))
    return false;
  if (std::less<>{}(lhs.supported_networks, rhs.supported_networks))
    return true;
  if (std::less<>{}(rhs.supported_networks, lhs.supported_networks))
    return false;
  return false;
}
template <typename StructPtrType>
CanMakePaymentEventDataPtr CanMakePaymentEventData::Clone() const {
  return New(
      mojo::Clone(top_origin),
      mojo::Clone(payment_request_origin),
      mojo::Clone(method_data),
      mojo::Clone(modifiers),
      mojo::Clone(currency)
  );
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>*>
bool CanMakePaymentEventData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_origin, other_struct.top_origin))
    return false;
  if (!mojo::Equals(this->payment_request_origin, other_struct.payment_request_origin))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->currency, other_struct.currency))
    return false;
  return true;
}

template <typename T, CanMakePaymentEventData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.top_origin, rhs.top_origin))
    return true;
  if (std::less<>{}(rhs.top_origin, lhs.top_origin))
    return false;
  if (std::less<>{}(lhs.payment_request_origin, rhs.payment_request_origin))
    return true;
  if (std::less<>{}(rhs.payment_request_origin, lhs.payment_request_origin))
    return false;
  if (std::less<>{}(lhs.method_data, rhs.method_data))
    return true;
  if (std::less<>{}(rhs.method_data, lhs.method_data))
    return false;
  if (std::less<>{}(lhs.modifiers, rhs.modifiers))
    return true;
  if (std::less<>{}(rhs.modifiers, lhs.modifiers))
    return false;
  if (std::less<>{}(lhs.currency, rhs.currency))
    return true;
  if (std::less<>{}(rhs.currency, lhs.currency))
    return false;
  return false;
}
template <typename StructPtrType>
PaymentRequestEventDataPtr PaymentRequestEventData::Clone() const {
  return New(
      mojo::Clone(top_origin),
      mojo::Clone(payment_request_origin),
      mojo::Clone(payment_request_id),
      mojo::Clone(method_data),
      mojo::Clone(total),
      mojo::Clone(modifiers),
      mojo::Clone(instrument_key),
      mojo::Clone(payment_options),
      mojo::Clone(shipping_options),
      mojo::Clone(payment_handler_host)
  );
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>*>
bool PaymentRequestEventData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_origin, other_struct.top_origin))
    return false;
  if (!mojo::Equals(this->payment_request_origin, other_struct.payment_request_origin))
    return false;
  if (!mojo::Equals(this->payment_request_id, other_struct.payment_request_id))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->instrument_key, other_struct.instrument_key))
    return false;
  if (!mojo::Equals(this->payment_options, other_struct.payment_options))
    return false;
  if (!mojo::Equals(this->shipping_options, other_struct.shipping_options))
    return false;
  if (!mojo::Equals(this->payment_handler_host, other_struct.payment_handler_host))
    return false;
  return true;
}

template <typename T, PaymentRequestEventData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.top_origin, rhs.top_origin))
    return true;
  if (std::less<>{}(rhs.top_origin, lhs.top_origin))
    return false;
  if (std::less<>{}(lhs.payment_request_origin, rhs.payment_request_origin))
    return true;
  if (std::less<>{}(rhs.payment_request_origin, lhs.payment_request_origin))
    return false;
  if (std::less<>{}(lhs.payment_request_id, rhs.payment_request_id))
    return true;
  if (std::less<>{}(rhs.payment_request_id, lhs.payment_request_id))
    return false;
  if (std::less<>{}(lhs.method_data, rhs.method_data))
    return true;
  if (std::less<>{}(rhs.method_data, lhs.method_data))
    return false;
  if (std::less<>{}(lhs.total, rhs.total))
    return true;
  if (std::less<>{}(rhs.total, lhs.total))
    return false;
  if (std::less<>{}(lhs.modifiers, rhs.modifiers))
    return true;
  if (std::less<>{}(rhs.modifiers, lhs.modifiers))
    return false;
  if (std::less<>{}(lhs.instrument_key, rhs.instrument_key))
    return true;
  if (std::less<>{}(rhs.instrument_key, lhs.instrument_key))
    return false;
  if (std::less<>{}(lhs.payment_options, rhs.payment_options))
    return true;
  if (std::less<>{}(rhs.payment_options, lhs.payment_options))
    return false;
  if (std::less<>{}(lhs.shipping_options, rhs.shipping_options))
    return true;
  if (std::less<>{}(rhs.shipping_options, lhs.shipping_options))
    return false;
  if (std::less<>{}(lhs.payment_handler_host, rhs.payment_handler_host))
    return true;
  if (std::less<>{}(rhs.payment_handler_host, lhs.payment_handler_host))
    return false;
  return false;
}
template <typename StructPtrType>
CanMakePaymentResponsePtr CanMakePaymentResponse::Clone() const {
  return New(
      mojo::Clone(response_type),
      mojo::Clone(can_make_payment),
      mojo::Clone(ready_for_minimal_ui),
      mojo::Clone(account_balance)
  );
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>*>
bool CanMakePaymentResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->can_make_payment, other_struct.can_make_payment))
    return false;
  if (!mojo::Equals(this->ready_for_minimal_ui, other_struct.ready_for_minimal_ui))
    return false;
  if (!mojo::Equals(this->account_balance, other_struct.account_balance))
    return false;
  return true;
}

template <typename T, CanMakePaymentResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.response_type, rhs.response_type))
    return true;
  if (std::less<>{}(rhs.response_type, lhs.response_type))
    return false;
  if (std::less<>{}(lhs.can_make_payment, rhs.can_make_payment))
    return true;
  if (std::less<>{}(rhs.can_make_payment, lhs.can_make_payment))
    return false;
  if (std::less<>{}(lhs.ready_for_minimal_ui, rhs.ready_for_minimal_ui))
    return true;
  if (std::less<>{}(rhs.ready_for_minimal_ui, lhs.ready_for_minimal_ui))
    return false;
  if (std::less<>{}(lhs.account_balance, rhs.account_balance))
    return true;
  if (std::less<>{}(rhs.account_balance, lhs.account_balance))
    return false;
  return false;
}
template <typename StructPtrType>
PaymentHandlerResponsePtr PaymentHandlerResponse::Clone() const {
  return New(
      mojo::Clone(method_name),
      mojo::Clone(stringified_details),
      mojo::Clone(response_type),
      mojo::Clone(payer_name),
      mojo::Clone(payer_email),
      mojo::Clone(payer_phone),
      mojo::Clone(shipping_address),
      mojo::Clone(shipping_option)
  );
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>*>
bool PaymentHandlerResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method_name, other_struct.method_name))
    return false;
  if (!mojo::Equals(this->stringified_details, other_struct.stringified_details))
    return false;
  if (!mojo::Equals(this->response_type, other_struct.response_type))
    return false;
  if (!mojo::Equals(this->payer_name, other_struct.payer_name))
    return false;
  if (!mojo::Equals(this->payer_email, other_struct.payer_email))
    return false;
  if (!mojo::Equals(this->payer_phone, other_struct.payer_phone))
    return false;
  if (!mojo::Equals(this->shipping_address, other_struct.shipping_address))
    return false;
  if (!mojo::Equals(this->shipping_option, other_struct.shipping_option))
    return false;
  return true;
}

template <typename T, PaymentHandlerResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.method_name, rhs.method_name))
    return true;
  if (std::less<>{}(rhs.method_name, lhs.method_name))
    return false;
  if (std::less<>{}(lhs.stringified_details, rhs.stringified_details))
    return true;
  if (std::less<>{}(rhs.stringified_details, lhs.stringified_details))
    return false;
  if (std::less<>{}(lhs.response_type, rhs.response_type))
    return true;
  if (std::less<>{}(rhs.response_type, lhs.response_type))
    return false;
  if (std::less<>{}(lhs.payer_name, rhs.payer_name))
    return true;
  if (std::less<>{}(rhs.payer_name, lhs.payer_name))
    return false;
  if (std::less<>{}(lhs.payer_email, rhs.payer_email))
    return true;
  if (std::less<>{}(rhs.payer_email, lhs.payer_email))
    return false;
  if (std::less<>{}(lhs.payer_phone, rhs.payer_phone))
    return true;
  if (std::less<>{}(rhs.payer_phone, lhs.payer_phone))
    return false;
  if (std::less<>{}(lhs.shipping_address, rhs.shipping_address))
    return true;
  if (std::less<>{}(rhs.shipping_address, lhs.shipping_address))
    return false;
  if (std::less<>{}(lhs.shipping_option, rhs.shipping_option))
    return true;
  if (std::less<>{}(rhs.shipping_option, lhs.shipping_option))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentInstrument::DataView,
                                         ::payments::mojom::blink::PaymentInstrumentPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentInstrumentPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentInstrumentPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentInstrument::name)& name(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->name;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::icons)& icons(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->icons;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::method)& method(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->method;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::stringified_capabilities)& stringified_capabilities(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->stringified_capabilities;
  }

  static const decltype(::payments::mojom::blink::PaymentInstrument::supported_networks)& supported_networks(
      const ::payments::mojom::blink::PaymentInstrumentPtr& input) {
    return input->supported_networks;
  }

  static bool Read(::payments::mojom::blink::PaymentInstrument::DataView input, ::payments::mojom::blink::PaymentInstrumentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::CanMakePaymentEventData::DataView,
                                         ::payments::mojom::blink::CanMakePaymentEventDataPtr> {
  static bool IsNull(const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::CanMakePaymentEventDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::top_origin)& top_origin(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->top_origin;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::payment_request_origin)& payment_request_origin(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->payment_request_origin;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::method_data)& method_data(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->method_data;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::modifiers)& modifiers(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->modifiers;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentEventData::currency)& currency(
      const ::payments::mojom::blink::CanMakePaymentEventDataPtr& input) {
    return input->currency;
  }

  static bool Read(::payments::mojom::blink::CanMakePaymentEventData::DataView input, ::payments::mojom::blink::CanMakePaymentEventDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentRequestEventData::DataView,
                                         ::payments::mojom::blink::PaymentRequestEventDataPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentRequestEventDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::top_origin)& top_origin(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->top_origin;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_request_origin)& payment_request_origin(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_request_origin;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_request_id)& payment_request_id(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_request_id;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::method_data)& method_data(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->method_data;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::total)& total(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::modifiers)& modifiers(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->modifiers;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::instrument_key)& instrument_key(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->instrument_key;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::payment_options)& payment_options(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_options;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestEventData::shipping_options)& shipping_options(
      const ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->shipping_options;
  }

  static  decltype(::payments::mojom::blink::PaymentRequestEventData::payment_handler_host)& payment_handler_host(
       ::payments::mojom::blink::PaymentRequestEventDataPtr& input) {
    return input->payment_handler_host;
  }

  static bool Read(::payments::mojom::blink::PaymentRequestEventData::DataView input, ::payments::mojom::blink::PaymentRequestEventDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::CanMakePaymentResponse::DataView,
                                         ::payments::mojom::blink::CanMakePaymentResponsePtr> {
  static bool IsNull(const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::CanMakePaymentResponsePtr* output) { output->reset(); }

  static decltype(::payments::mojom::blink::CanMakePaymentResponse::response_type) response_type(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->response_type;
  }

  static decltype(::payments::mojom::blink::CanMakePaymentResponse::can_make_payment) can_make_payment(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->can_make_payment;
  }

  static decltype(::payments::mojom::blink::CanMakePaymentResponse::ready_for_minimal_ui) ready_for_minimal_ui(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->ready_for_minimal_ui;
  }

  static const decltype(::payments::mojom::blink::CanMakePaymentResponse::account_balance)& account_balance(
      const ::payments::mojom::blink::CanMakePaymentResponsePtr& input) {
    return input->account_balance;
  }

  static bool Read(::payments::mojom::blink::CanMakePaymentResponse::DataView input, ::payments::mojom::blink::CanMakePaymentResponsePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentHandlerResponse::DataView,
                                         ::payments::mojom::blink::PaymentHandlerResponsePtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentHandlerResponsePtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::method_name)& method_name(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->method_name;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::stringified_details)& stringified_details(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->stringified_details;
  }

  static decltype(::payments::mojom::blink::PaymentHandlerResponse::response_type) response_type(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->response_type;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_name)& payer_name(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_name;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_email)& payer_email(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_email;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::payer_phone)& payer_phone(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->payer_phone;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::shipping_address)& shipping_address(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->shipping_address;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerResponse::shipping_option)& shipping_option(
      const ::payments::mojom::blink::PaymentHandlerResponsePtr& input) {
    return input->shipping_option;
  }

  static bool Read(::payments::mojom::blink::PaymentHandlerResponse::DataView input, ::payments::mojom::blink::PaymentHandlerResponsePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_H_