// ui/accessibility/mojom/ax_node_data.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_INTERNAL_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "ui/accessibility/ax_enums.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace ax {
namespace mojom {
namespace internal {
class AXNodeData_Data;

#pragma pack(push, 1)
class  AXNodeData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AXNodeData_Data));
      new (data()) AXNodeData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AXNodeData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AXNodeData_Data>(index_);
    }
    AXNodeData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t role;
  uint32_t state;
  uint8_t pad2_[4];
  uint64_t actions;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<mojo::internal::String_Data>>> string_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, int32_t>> int_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, float>> float_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, bool>> bool_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>>>> intlist_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>>>> stringlist_attributes;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::String_Data>>> html_attributes;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> child_ids;
  mojo::internal::Pointer<::ax::mojom::internal::AXRelativeBounds_Data> relative_bounds;

 private:
  AXNodeData_Data();
  ~AXNodeData_Data() = delete;
};
static_assert(sizeof(AXNodeData_Data) == 104,
              "Bad sizeof(AXNodeData_Data)");
// Used by AXNodeData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AXNodeData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AXNodeData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AXNodeData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AXNodeData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AXNodeData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_INTERNAL_H_