#pragma once



// libDaisy = 0x80410501 - 0x804105ff

// Error codes
enum CellDaisyError : u32
{
	CELL_DAISY_ERROR_NO_BEGIN = 0x80410501,
	CELL_DAISY_ERROR_INVALID_PORT_ATTACH = 0x80410502,
	CELL_DAISY_ERROR_NOT_IMPLEMENTED = 0x80410503,
	CELL_DAISY_ERROR_AGAIN = 0x80410511,
	CELL_DAISY_ERROR_INVAL = 0x80410512,
	CELL_DAISY_ERROR_PERM = 0x80410509,
	CELL_DAISY_ERROR_BUSY = 0x8041051A,
	CELL_DAISY_ERROR_STAT = 0x8041050F,
};

// Return codes
enum
{
	QUEUE_IS_BUSY = 2,
	TERMINATED = 3,
	GLUE_ACTIVE = 4,
};

// Assertations
enum
{
	CELL_DAISY_MIN_QUEUE_SIZE = 1,
	CELL_DAISY_MAX_LOCAL_QUEUE_SIZE = 32,
	CELL_DAISY_MAX_ATO_QUEUE_SIZE = 32,
	CELL_DAISY_MAX_SNR_QUEUE_SIZE = 12,
	CELL_DAISY_MIN_ENTRY_SIZE = 16,
	CELL_DAISY_MAX_ENTRY_SIZE = (16*1024),
	CELL_DAISY_MAX_DMA_TAG = 31,

	// CELL_DAISY_ENTRY_SIZE(x)
	// CELL_DAISY_EA_ATOMIC(x)
	// CELL_DAISY_EA_DMA(x)
};

// Definitions
// The following are prefixed with DAISY_ to prevent name conflits
enum
{
	// Queue IO
	DAISY_OUTPUT,
	DAISY_INPUT,

	// Block Mode
	DAISY_NOT_STALL = 0,
	DAISY_STALL = 1,

	// Queue Status
	DAISY_PTR_UNAVAILABLE = 0x40000001,
	DAISY_PTR_TERMINATED = 0x40000002,

	// Buffer Mode
	DAISY_COPY = 0,
	DAISY_REFERENCE = 1,

	// Constructor Mode
	DAISY_NO_PARAMETER = 0,
	DAISY_PARAMETER = 1,

	// Glue Mode
	DAISY_ONE_PORT = 1,
	DAISY_TWO_PORT = 2,

	// Queue Mode
	DAISY_IN_ORDER,
	DAISY_OUT_OF_ORDER,

	// Buffer Type
	DAISY_BUFFER_TYPE_REMOTE = 1,
	DAISY_BUFFER_TYPE_LOCAL = 2,

	// Queue Control Type
	DAISY_QCTL_TYPE_ATOMIC = 1,
	DAISY_QCTL_TYPE_LOCAL = 2,
	DAISY_QCTL_TYPE_SIGNAL_NOTIFICATION = 3,
};
