import { BlockObjectResponse, CommentObjectResponse, DatabaseObjectResponse, DataSourceObjectResponse, EquationRichTextItemResponse, ListDataSourceTemplatesResponse, MentionRichTextItemResponse, PageObjectResponse, PartialBlockObjectResponse, PartialCommentObjectResponse, PartialDatabaseObjectResponse, PartialDataSourceObjectResponse, PartialPageObjectResponse, PartialUserObjectResponse, RichTextItemResponse, RichTextItemResponseCommon, TextRichTextItemResponse, UserObjectResponse } from "./api-endpoints";
import type Client from "./Client";
interface PaginatedArgs {
    start_cursor?: string;
}
type PaginatedList<T> = {
    object: "list";
    results: T[];
    next_cursor: string | null;
    has_more: boolean;
};
/**
 * Returns an async iterator over the results of any paginated Notion API.
 *
 * Example (given a notion Client called `notion`):
 *
 * ```
 * for await (const block of iteratePaginatedAPI(notion.blocks.children.list, {
 *   block_id: parentBlockId,
 * })) {
 *   // Do something with block.
 * }
 * ```
 *
 * @param listFn A bound function on the Notion client that represents a conforming paginated
 *   API. Example: `notion.blocks.children.list`.
 * @param firstPageArgs Arguments that should be passed to the API on the first and subsequent
 *   calls to the API. Any necessary `next_cursor` will be automatically populated by
 *   this function. Example: `{ block_id: "<my block id>" }`
 */
export declare function iteratePaginatedAPI<Args extends PaginatedArgs, Item>(listFn: (args: Args) => Promise<PaginatedList<Item>>, firstPageArgs: Args): AsyncIterableIterator<Item>;
/**
 * Collect all of the results of paginating an API into an in-memory array.
 *
 * Example (given a notion Client called `notion`):
 *
 * ```
 * const blocks = await collectPaginatedAPI(notion.blocks.children.list, {
 *   block_id: parentBlockId,
 * })
 * // Do something with blocks.
 * ```
 *
 * @param listFn A bound function on the Notion client that represents a conforming paginated
 *   API. Example: `notion.blocks.children.list`.
 * @param firstPageArgs Arguments that should be passed to the API on the first and subsequent
 *   calls to the API. Any necessary `next_cursor` will be automatically populated by
 *   this function. Example: `{ block_id: "<my block id>" }`
 */
export declare function collectPaginatedAPI<Args extends PaginatedArgs, Item>(listFn: (args: Args) => Promise<PaginatedList<Item>>, firstPageArgs: Args): Promise<Item[]>;
type DataSourceTemplate = ListDataSourceTemplatesResponse["templates"][number];
interface ListDataSourceTemplatesArgs extends PaginatedArgs {
    data_source_id: string;
    name?: string;
    page_size?: number;
}
/**
 * Returns an async iterator over data source templates.
 *
 * Example (given a notion Client called `notion`):
 *
 * ```
 * for await (const template of iterateDataSourceTemplates(notion, {
 *   data_source_id: dataSourceId,
 * })) {
 *   console.log(template.name, template.is_default)
 * }
 * ```
 *
 * @param client A Notion client instance.
 * @param args Arguments including the data_source_id and optional start_cursor.
 */
export declare function iterateDataSourceTemplates(client: Client, args: ListDataSourceTemplatesArgs): AsyncIterableIterator<DataSourceTemplate>;
/**
 * Collect all data source templates into an in-memory array.
 *
 * Example (given a notion Client called `notion`):
 *
 * ```
 * const templates = await collectDataSourceTemplates(notion, {
 *   data_source_id: dataSourceId,
 * })
 * // Do something with templates.
 * ```
 *
 * @param client A Notion client instance.
 * @param args Arguments including the data_source_id and optional start_cursor.
 */
export declare function collectDataSourceTemplates(client: Client, args: ListDataSourceTemplatesArgs): Promise<DataSourceTemplate[]>;
type ObjectResponse = PageObjectResponse | PartialPageObjectResponse | DataSourceObjectResponse | PartialDataSourceObjectResponse | DatabaseObjectResponse | PartialDatabaseObjectResponse | BlockObjectResponse | PartialBlockObjectResponse;
/**
 * @returns `true` if `response` is a full `BlockObjectResponse`.
 */
export declare function isFullBlock(response: ObjectResponse): response is BlockObjectResponse;
/**
 * @returns `true` if `response` is a full `PageObjectResponse`.
 */
export declare function isFullPage(response: ObjectResponse): response is PageObjectResponse;
/**
 * @returns `true` if `response` is a full `DataSourceObjectResponse`.
 */
export declare function isFullDataSource(response: ObjectResponse): response is DataSourceObjectResponse;
/**
 * @returns `true` if `response` is a full `DatabaseObjectResponse`.
 */
export declare function isFullDatabase(response: ObjectResponse): response is DatabaseObjectResponse;
/**
 * @returns `true` if `response` is a full `DataSourceObjectResponse` or a full
 * `PageObjectResponse`.
 *
 * Can be used on the results of the list response from `queryDataSource` or
 * `search` APIs.
 */
export declare function isFullPageOrDataSource(response: ObjectResponse): response is DataSourceObjectResponse | PageObjectResponse;
/**
 * @returns `true` if `response` is a full `UserObjectResponse`.
 */
export declare function isFullUser(response: UserObjectResponse | PartialUserObjectResponse): response is UserObjectResponse;
/**
 * @returns `true` if `response` is a full `CommentObjectResponse`.
 */
export declare function isFullComment(response: CommentObjectResponse | PartialCommentObjectResponse): response is CommentObjectResponse;
/**
 * @returns `true` if `richText` is a `TextRichTextItemResponse`.
 */
export declare function isTextRichTextItemResponse(richText: RichTextItemResponse): richText is RichTextItemResponseCommon & TextRichTextItemResponse;
/**
 * @returns `true` if `richText` is an `EquationRichTextItemResponse`.
 */
export declare function isEquationRichTextItemResponse(richText: RichTextItemResponse): richText is RichTextItemResponseCommon & EquationRichTextItemResponse;
/**
 * @returns `true` if `richText` is an `MentionRichTextItemResponse`.
 */
export declare function isMentionRichTextItemResponse(richText: RichTextItemResponse): richText is RichTextItemResponseCommon & MentionRichTextItemResponse;
/**
 * Extracts a Notion ID from a Notion URL or returns the input if it's already a valid ID.
 *
 * Prioritizes path IDs over query parameters to avoid extracting view IDs instead of database IDs.
 *
 * @param urlOrId A Notion URL or ID string
 * @returns The extracted UUID in standard format (with hyphens) or null if invalid
 *
 * @example
 * ```typescript
 * // Database URL with view ID - extracts database ID, not view ID
 * extractNotionId('https://notion.so/workspace/DB-abc123def456789012345678901234ab?v=viewid123')
 * // Returns: 'abc123de-f456-7890-1234-5678901234ab' (database ID)
 *
 * // Already formatted UUID
 * extractNotionId('12345678-1234-1234-1234-123456789abc')
 * // Returns: '12345678-1234-1234-1234-123456789abc'
 * ```
 */
export declare function extractNotionId(urlOrId: string): string | null;
/**
 * Extracts a database ID from a Notion database URL.
 * Convenience wrapper around `extractNotionId`.
 */
export declare function extractDatabaseId(databaseUrl: string): string | null;
/**
 * Extracts a page ID from a Notion page URL.
 * Convenience wrapper around `extractNotionId`.
 */
export declare function extractPageId(pageUrl: string): string | null;
/**
 * Extracts a block ID from a Notion URL with a block fragment.
 * Looks for #block-<id> or #<id> patterns.
 */
export declare function extractBlockId(urlWithBlock: string): string | null;
export {};
//# sourceMappingURL=helpers.d.ts.map