"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bezierCurveSpeed = exports.bezierCurve = exports.overshoot = exports.clamp = exports.generateBezierAnchors = exports.randomVectorOnLine = exports.randomNumberRange = exports.setMagnitude = exports.unit = exports.magnitude = exports.perpendicular = exports.direction = exports.scale = exports.add = exports.mult = exports.div = exports.sub = exports.origin = void 0;
var bezier_js_1 = require("bezier-js");
exports.origin = { x: 0, y: 0 };
// maybe i should've just imported a vector library lol
var sub = function (a, b) { return ({ x: a.x - b.x, y: a.y - b.y }); };
exports.sub = sub;
var div = function (a, b) { return ({ x: a.x / b, y: a.y / b }); };
exports.div = div;
var mult = function (a, b) { return ({ x: a.x * b, y: a.y * b }); };
exports.mult = mult;
var add = function (a, b) { return ({ x: a.x + b.x, y: a.y + b.y }); };
exports.add = add;
var scale = function (value, range1, range2) {
    return (value - range1[0]) * (range2[1] - range2[0]) / (range1[1] - range1[0]) + range2[0];
};
exports.scale = scale;
var direction = function (a, b) { return (0, exports.sub)(b, a); };
exports.direction = direction;
var perpendicular = function (a) { return ({ x: a.y, y: -1 * a.x }); };
exports.perpendicular = perpendicular;
var magnitude = function (a) {
    return Math.sqrt(Math.pow(a.x, 2) + Math.pow(a.y, 2));
};
exports.magnitude = magnitude;
var unit = function (a) { return (0, exports.div)(a, (0, exports.magnitude)(a)); };
exports.unit = unit;
var setMagnitude = function (a, amount) {
    return (0, exports.mult)((0, exports.unit)(a), amount);
};
exports.setMagnitude = setMagnitude;
var randomNumberRange = function (min, max) {
    return Math.random() * (max - min) + min;
};
exports.randomNumberRange = randomNumberRange;
var randomVectorOnLine = function (a, b) {
    var vec = (0, exports.direction)(a, b);
    var multiplier = Math.random();
    return (0, exports.add)(a, (0, exports.mult)(vec, multiplier));
};
exports.randomVectorOnLine = randomVectorOnLine;
var randomNormalLine = function (a, b, range) {
    var randMid = (0, exports.randomVectorOnLine)(a, b);
    var normalV = (0, exports.setMagnitude)((0, exports.perpendicular)((0, exports.direction)(a, randMid)), range);
    return [randMid, normalV];
};
var generateBezierAnchors = function (a, b, spread) {
    var side = Math.round(Math.random()) === 1 ? 1 : -1;
    var calc = function () {
        var _a = __read(randomNormalLine(a, b, spread), 2), randMid = _a[0], normalV = _a[1];
        var choice = (0, exports.mult)(normalV, side);
        return (0, exports.randomVectorOnLine)(randMid, (0, exports.add)(randMid, choice));
    };
    return [calc(), calc()].sort(function (a, b) { return a.x - b.x; });
};
exports.generateBezierAnchors = generateBezierAnchors;
var clamp = function (target, min, max) {
    return Math.min(max, Math.max(min, target));
};
exports.clamp = clamp;
var overshoot = function (coordinate, radius) {
    var a = Math.random() * 2 * Math.PI;
    var rad = radius * Math.sqrt(Math.random());
    var vector = { x: rad * Math.cos(a), y: rad * Math.sin(a) };
    return (0, exports.add)(coordinate, vector);
};
exports.overshoot = overshoot;
var bezierCurve = function (start, finish, 
/**
 * Default is length from start to finish, clamped to 2 < x < 200
 */
spreadOverride) {
    // could be played around with
    var MIN_SPREAD = 2;
    var MAX_SPREAD = 200;
    var vec = (0, exports.direction)(start, finish);
    var length = (0, exports.magnitude)(vec);
    var spread = spreadOverride !== null && spreadOverride !== void 0 ? spreadOverride : (0, exports.clamp)(length, MIN_SPREAD, MAX_SPREAD);
    var anchors = (0, exports.generateBezierAnchors)(start, finish, spread);
    return new (bezier_js_1.Bezier.bind.apply(bezier_js_1.Bezier, __spreadArray(__spreadArray([void 0, start], __read(anchors), false), [finish], false)))();
};
exports.bezierCurve = bezierCurve;
var bezierCurveSpeed = function (t, P0, P1, P2, P3) {
    var B1 = 3 * Math.pow((1 - t), 2) * (P1.x - P0.x) + 6 * (1 - t) * t * (P2.x - P1.x) + 3 * Math.pow(t, 2) * (P3.x - P2.x);
    var B2 = 3 * Math.pow((1 - t), 2) * (P1.y - P0.y) + 6 * (1 - t) * t * (P2.y - P1.y) + 3 * Math.pow(t, 2) * (P3.y - P2.y);
    return Math.sqrt(Math.pow(B1, 2) + Math.pow(B2, 2));
};
exports.bezierCurveSpeed = bezierCurveSpeed;
