import { proto } from "../proto.mjs";
import protobuf from "protobufjs";

//#region src/lib/encode.ts
function encode(data, type) {
	return new Promise((resolve, reject) => {
		const root = protobuf.parse(proto).root;
		const messageType = root.lookupType(`mixi.${type}`);
		const errMsg = messageType.verify(data);
		if (errMsg) {
			reject(new Error(errMsg));
			return;
		}
		resolve(messageType.encode(data).finish());
	});
}

//#endregion
export { encode };