"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/util/jsonp.ts
var jsonp_exports = {};
__export(jsonp_exports, {
  jsonp: () => jsonp
});
module.exports = __toCommonJS(jsonp_exports);
var count = 0;
var noop = function() {
};
function jsonp(url, { prefix = "__jp", param = "callback", timeout = 15e3 } = {}) {
  return new Promise(function(resolve, reject) {
    const targetChild = document.getElementsByTagName("script").item(0);
    const target = targetChild?.parentNode ?? document.head;
    const id = `${prefix}${count++}`;
    const cleanup = function() {
      if (script && script.parentNode) {
        script.parentNode.removeChild(script);
      }
      window[id] = noop;
      if (timer) {
        clearTimeout(timer);
      }
    };
    const timer = timeout > 0 ? setTimeout(() => {
      cleanup();
      reject(new Error("Timeout"));
    }, timeout) : void 0;
    const callback = (data) => {
      cleanup();
      resolve(data);
    };
    window[id] = callback;
    const script = document.createElement("script");
    const urlObj = new URL(url);
    urlObj.searchParams.set(param, id);
    script.setAttribute("src", urlObj.toString());
    target.insertBefore(script, targetChild);
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  jsonp
});
//# sourceMappingURL=jsonp.cjs.map