var _arrayReduce = /*#__PURE__*/require("./internal/_arrayReduce.js");
var _curry2 = /*#__PURE__*/require("./internal/_curry2.js");
var _dispatchable = /*#__PURE__*/require("./internal/_dispatchable.js");
var _filter = /*#__PURE__*/require("./internal/_filter.js");
var _filterMap = /*#__PURE__*/require("./internal/_filterMap.js");
var _isMap = /*#__PURE__*/require("./internal/_isMap.js");
var _isObject = /*#__PURE__*/require("./internal/_isObject.js");
var _xfilter = /*#__PURE__*/require("./internal/_xfilter.js");
var keys = /*#__PURE__*/require("./keys.js");
/**
 * Takes a predicate and a `Filterable`, and returns a new filterable of the
 * same type containing the members of the given filterable which satisfy the
 * given predicate. Filterable objects include plain objects, Maps, or any object
 * that has a filter method such as `Array`.
 *
 * Dispatches to the `filter` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @category Object
 * @sig Filterable f => (a -> Boolean) -> f a -> f a
 * @param {Function} pred
 * @param {Array} filterable
 * @return {Array} Filterable
 * @see R.reject, R.transduce, R.addIndex
 * @example
 *
 *      const isEven = n => n % 2 === 0;
 *
 *      R.filter(isEven, [1, 2, 3, 4]); //=> [2, 4]
 *
 *      R.filter(isEven, {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, d: 4}
 */
var filter = /*#__PURE__*/_curry2( /*#__PURE__*/_dispatchable(['fantasy-land/filter', 'filter'], _xfilter, function (pred, filterable) {
  return _isObject(filterable) ? _arrayReduce(function (acc, key) {
    if (pred(filterable[key])) {
      acc[key] = filterable[key];
    }
    return acc;
  }, {}, keys(filterable)) : _isMap(filterable) ? _filterMap(pred, filterable) :
  // else
  _filter(pred, filterable);
}));
module.exports = filter;