
// This file is autogenerated. All changes will be overwritten.
import { BigInteger } from 'big-integer';
import {EntityLike,MessageIDLike} from "../define";
import { CustomMessage } from "./custom/message";


export namespace Api {
  type AnyLiteral = Record<string, any> | void;
  type Reader = any; // To be defined.
  type Client = any; // To be defined.
  type Utils = any; // To be defined.
  type X = unknown;
  type Type = unknown;
  type Bool = boolean;
  type int = number;
  type double = number;
  type float = number;
  type int128 = BigInteger;
  type int256 = BigInteger;
  type long = BigInteger;
  type bytes = Buffer;
  class VirtualClass<Args extends AnyLiteral> {
    static CONSTRUCTOR_ID: number;
    static SUBCLASS_OF_ID: number;
    static className: string;
    static classType: 'constructor' | 'request';
    static serializeBytes(data: Buffer | string): Buffer;
    static serializeDate(date: Date | number): Buffer;
    getBytes():Buffer;
    CONSTRUCTOR_ID: number;
    SUBCLASS_OF_ID: number;
    className: string;
    classType: 'constructor' | 'request';
    constructor(args: Args);
    originalArgs: Args;
    toJSON(): Args;
  }
  class Request<Args, Response> extends VirtualClass<Partial<Args>> {
    static readResult(reader: Reader): Buffer;
    resolve(client: Client, utils: Utils): Promise<void>;
    __response: Response;
  }
  export class InputPeerEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2134579434;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerEmpty";
  static fromReader(reader: Reader): InputPeerEmpty;
}
  export class InputPeerSelf extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2107670217;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerSelf";
  static fromReader(reader: Reader): InputPeerSelf;
}
  export class InputPeerChat extends VirtualClass<{
    chatId: long;
  }> {
  CONSTRUCTOR_ID: 900291769;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerChat";
  static fromReader(reader: Reader): InputPeerChat;
    chatId: long;
  }
  export class InputPeerUser extends VirtualClass<{
    userId: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3723011404;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerUser";
  static fromReader(reader: Reader): InputPeerUser;
    userId: long;
    accessHash: long;
  }
  export class InputPeerChannel extends VirtualClass<{
    channelId: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 666680316;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerChannel";
  static fromReader(reader: Reader): InputPeerChannel;
    channelId: long;
    accessHash: long;
  }
  export class InputPeerUserFromMessage extends VirtualClass<{
    peer: Api.TypeInputPeer;
    msgId: int;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 2826635804;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerUserFromMessage";
  static fromReader(reader: Reader): InputPeerUserFromMessage;
    peer: Api.TypeInputPeer;
    msgId: int;
    userId: long;
  }
  export class InputPeerChannelFromMessage extends VirtualClass<{
    peer: Api.TypeInputPeer;
    msgId: int;
    channelId: long;
  }> {
  CONSTRUCTOR_ID: 3173648448;
  SUBCLASS_OF_ID: 3374092470;
  classType: "constructor";
  className: "InputPeerChannelFromMessage";
  static fromReader(reader: Reader): InputPeerChannelFromMessage;
    peer: Api.TypeInputPeer;
    msgId: int;
    channelId: long;
  }
  export class InputUserEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3112732367;
  SUBCLASS_OF_ID: 3865689926;
  classType: "constructor";
  className: "InputUserEmpty";
  static fromReader(reader: Reader): InputUserEmpty;
}
  export class InputUserSelf extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4156666175;
  SUBCLASS_OF_ID: 3865689926;
  classType: "constructor";
  className: "InputUserSelf";
  static fromReader(reader: Reader): InputUserSelf;
}
  export class InputUser extends VirtualClass<{
    userId: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 4061223110;
  SUBCLASS_OF_ID: 3865689926;
  classType: "constructor";
  className: "InputUser";
  static fromReader(reader: Reader): InputUser;
    userId: long;
    accessHash: long;
  }
  export class InputUserFromMessage extends VirtualClass<{
    peer: Api.TypeInputPeer;
    msgId: int;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 497305826;
  SUBCLASS_OF_ID: 3865689926;
  classType: "constructor";
  className: "InputUserFromMessage";
  static fromReader(reader: Reader): InputUserFromMessage;
    peer: Api.TypeInputPeer;
    msgId: int;
    userId: long;
  }
  export class InputPhoneContact extends VirtualClass<{
    clientId: long;
    phone: string;
    firstName: string;
    lastName: string;
  }> {
  CONSTRUCTOR_ID: 4086478836;
  SUBCLASS_OF_ID: 2926144130;
  classType: "constructor";
  className: "InputPhoneContact";
  static fromReader(reader: Reader): InputPhoneContact;
    clientId: long;
    phone: string;
    firstName: string;
    lastName: string;
  }
  export class InputFile extends VirtualClass<{
    id: long;
    parts: int;
    name: string;
    md5Checksum: string;
  }> {
  CONSTRUCTOR_ID: 4113560191;
  SUBCLASS_OF_ID: 3882180383;
  classType: "constructor";
  className: "InputFile";
  static fromReader(reader: Reader): InputFile;
    id: long;
    parts: int;
    name: string;
    md5Checksum: string;
  }
  export class InputFileBig extends VirtualClass<{
    id: long;
    parts: int;
    name: string;
  }> {
  CONSTRUCTOR_ID: 4199484341;
  SUBCLASS_OF_ID: 3882180383;
  classType: "constructor";
  className: "InputFileBig";
  static fromReader(reader: Reader): InputFileBig;
    id: long;
    parts: int;
    name: string;
  }
  export class InputFileStoryDocument extends VirtualClass<{
    id: Api.TypeInputDocument;
  }> {
  CONSTRUCTOR_ID: 1658620744;
  SUBCLASS_OF_ID: 3882180383;
  classType: "constructor";
  className: "InputFileStoryDocument";
  static fromReader(reader: Reader): InputFileStoryDocument;
    id: Api.TypeInputDocument;
  }
  export class InputMediaEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2523198847;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaEmpty";
  static fromReader(reader: Reader): InputMediaEmpty;
}
  export class InputMediaUploadedPhoto extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    file: Api.TypeInputFile;
    stickers?: Api.TypeInputDocument[];
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 505969924;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaUploadedPhoto";
  static fromReader(reader: Reader): InputMediaUploadedPhoto;
    // flags: null;
    spoiler?: boolean;
    file: Api.TypeInputFile;
    stickers?: Api.TypeInputDocument[];
    ttlSeconds?: int;
  }
  export class InputMediaPhoto extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    id: Api.TypeInputPhoto;
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 3015312949;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaPhoto";
  static fromReader(reader: Reader): InputMediaPhoto;
    // flags: null;
    spoiler?: boolean;
    id: Api.TypeInputPhoto;
    ttlSeconds?: int;
  }
  export class InputMediaGeoPoint extends VirtualClass<{
    geoPoint: Api.TypeInputGeoPoint;
  }> {
  CONSTRUCTOR_ID: 4190388548;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaGeoPoint";
  static fromReader(reader: Reader): InputMediaGeoPoint;
    geoPoint: Api.TypeInputGeoPoint;
  }
  export class InputMediaContact extends VirtualClass<{
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
  }> {
  CONSTRUCTOR_ID: 4171988475;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaContact";
  static fromReader(reader: Reader): InputMediaContact;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
  }
  export class InputMediaUploadedDocument extends VirtualClass<{
    // flags: null;
    nosoundVideo?: boolean;
    forceFile?: boolean;
    spoiler?: boolean;
    file: Api.TypeInputFile;
    thumb?: Api.TypeInputFile;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
    stickers?: Api.TypeInputDocument[];
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 58495792;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaUploadedDocument";
  static fromReader(reader: Reader): InputMediaUploadedDocument;
    // flags: null;
    nosoundVideo?: boolean;
    forceFile?: boolean;
    spoiler?: boolean;
    file: Api.TypeInputFile;
    thumb?: Api.TypeInputFile;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
    stickers?: Api.TypeInputDocument[];
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
  }
  export class InputMediaDocument extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    id: Api.TypeInputDocument;
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
    query?: string;
  }> {
  CONSTRUCTOR_ID: 2826320565;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaDocument";
  static fromReader(reader: Reader): InputMediaDocument;
    // flags: null;
    spoiler?: boolean;
    id: Api.TypeInputDocument;
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
    query?: string;
  }
  export class InputMediaVenue extends VirtualClass<{
    geoPoint: Api.TypeInputGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }> {
  CONSTRUCTOR_ID: 3242007569;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaVenue";
  static fromReader(reader: Reader): InputMediaVenue;
    geoPoint: Api.TypeInputGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }
  export class InputMediaPhotoExternal extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    url: string;
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 3854302746;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaPhotoExternal";
  static fromReader(reader: Reader): InputMediaPhotoExternal;
    // flags: null;
    spoiler?: boolean;
    url: string;
    ttlSeconds?: int;
  }
  export class InputMediaDocumentExternal extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    url: string;
    ttlSeconds?: int;
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
  }> {
  CONSTRUCTOR_ID: 2006319353;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaDocumentExternal";
  static fromReader(reader: Reader): InputMediaDocumentExternal;
    // flags: null;
    spoiler?: boolean;
    url: string;
    ttlSeconds?: int;
    videoCover?: Api.TypeInputPhoto;
    videoTimestamp?: int;
  }
  export class InputMediaGame extends VirtualClass<{
    id: Api.TypeInputGame;
  }> {
  CONSTRUCTOR_ID: 3544138739;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaGame";
  static fromReader(reader: Reader): InputMediaGame;
    id: Api.TypeInputGame;
  }
  export class InputMediaInvoice extends VirtualClass<{
    // flags: null;
    title: string;
    description: string;
    photo?: Api.TypeInputWebDocument;
    invoice: Api.TypeInvoice;
    payload: bytes;
    provider?: string;
    providerData: Api.TypeDataJSON;
    startParam?: string;
    extendedMedia?: Api.TypeInputMedia;
  }> {
  CONSTRUCTOR_ID: 1080028941;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaInvoice";
  static fromReader(reader: Reader): InputMediaInvoice;
    // flags: null;
    title: string;
    description: string;
    photo?: Api.TypeInputWebDocument;
    invoice: Api.TypeInvoice;
    payload: bytes;
    provider?: string;
    providerData: Api.TypeDataJSON;
    startParam?: string;
    extendedMedia?: Api.TypeInputMedia;
  }
  export class InputMediaGeoLive extends VirtualClass<{
    // flags: null;
    stopped?: boolean;
    geoPoint: Api.TypeInputGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
  }> {
  CONSTRUCTOR_ID: 2535434307;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaGeoLive";
  static fromReader(reader: Reader): InputMediaGeoLive;
    // flags: null;
    stopped?: boolean;
    geoPoint: Api.TypeInputGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
  }
  export class InputMediaPoll extends VirtualClass<{
    // flags: null;
    poll: Api.TypePoll;
    correctAnswers?: bytes[];
    solution?: string;
    solutionEntities?: Api.TypeMessageEntity[];
  }> {
  CONSTRUCTOR_ID: 261416433;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaPoll";
  static fromReader(reader: Reader): InputMediaPoll;
    // flags: null;
    poll: Api.TypePoll;
    correctAnswers?: bytes[];
    solution?: string;
    solutionEntities?: Api.TypeMessageEntity[];
  }
  export class InputMediaDice extends VirtualClass<{
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 3866083195;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaDice";
  static fromReader(reader: Reader): InputMediaDice;
    emoticon: string;
  }
  export class InputMediaStory extends VirtualClass<{
    peer: Api.TypeInputPeer;
    id: int;
  }> {
  CONSTRUCTOR_ID: 2315114360;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaStory";
  static fromReader(reader: Reader): InputMediaStory;
    peer: Api.TypeInputPeer;
    id: int;
  }
  export class InputMediaWebPage extends VirtualClass<{
    // flags: null;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    optional?: boolean;
    url: string;
  }> {
  CONSTRUCTOR_ID: 3256584265;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaWebPage";
  static fromReader(reader: Reader): InputMediaWebPage;
    // flags: null;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    optional?: boolean;
    url: string;
  }
  export class InputMediaPaidMedia extends VirtualClass<{
    // flags: null;
    starsAmount: long;
    extendedMedia: Api.TypeInputMedia[];
    payload?: string;
  }> {
  CONSTRUCTOR_ID: 3289396102;
  SUBCLASS_OF_ID: 4210575092;
  classType: "constructor";
  className: "InputMediaPaidMedia";
  static fromReader(reader: Reader): InputMediaPaidMedia;
    // flags: null;
    starsAmount: long;
    extendedMedia: Api.TypeInputMedia[];
    payload?: string;
  }
  export class InputChatPhotoEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 480546647;
  SUBCLASS_OF_ID: 3572182388;
  classType: "constructor";
  className: "InputChatPhotoEmpty";
  static fromReader(reader: Reader): InputChatPhotoEmpty;
}
  export class InputChatUploadedPhoto extends VirtualClass<{
    // flags: null;
    file?: Api.TypeInputFile;
    video?: Api.TypeInputFile;
    videoStartTs?: double;
    videoEmojiMarkup?: Api.TypeVideoSize;
  }> {
  CONSTRUCTOR_ID: 3184373440;
  SUBCLASS_OF_ID: 3572182388;
  classType: "constructor";
  className: "InputChatUploadedPhoto";
  static fromReader(reader: Reader): InputChatUploadedPhoto;
    // flags: null;
    file?: Api.TypeInputFile;
    video?: Api.TypeInputFile;
    videoStartTs?: double;
    videoEmojiMarkup?: Api.TypeVideoSize;
  }
  export class InputChatPhoto extends VirtualClass<{
    id: Api.TypeInputPhoto;
  }> {
  CONSTRUCTOR_ID: 2303962423;
  SUBCLASS_OF_ID: 3572182388;
  classType: "constructor";
  className: "InputChatPhoto";
  static fromReader(reader: Reader): InputChatPhoto;
    id: Api.TypeInputPhoto;
  }
  export class InputGeoPointEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3837862870;
  SUBCLASS_OF_ID: 70308389;
  classType: "constructor";
  className: "InputGeoPointEmpty";
  static fromReader(reader: Reader): InputGeoPointEmpty;
}
  export class InputGeoPoint extends VirtualClass<{
    // flags: null;
    lat: double;
    long: double;
    accuracyRadius?: int;
  }> {
  CONSTRUCTOR_ID: 1210199983;
  SUBCLASS_OF_ID: 70308389;
  classType: "constructor";
  className: "InputGeoPoint";
  static fromReader(reader: Reader): InputGeoPoint;
    // flags: null;
    lat: double;
    long: double;
    accuracyRadius?: int;
  }
  export class InputPhotoEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 483901197;
  SUBCLASS_OF_ID: 2221106144;
  classType: "constructor";
  className: "InputPhotoEmpty";
  static fromReader(reader: Reader): InputPhotoEmpty;
}
  export class InputPhoto extends VirtualClass<{
    id: long;
    accessHash: long;
    fileReference: bytes;
  }> {
  CONSTRUCTOR_ID: 1001634122;
  SUBCLASS_OF_ID: 2221106144;
  classType: "constructor";
  className: "InputPhoto";
  static fromReader(reader: Reader): InputPhoto;
    id: long;
    accessHash: long;
    fileReference: bytes;
  }
  export class InputFileLocation extends VirtualClass<{
    volumeId: long;
    localId: int;
    secret: long;
    fileReference: bytes;
  }> {
  CONSTRUCTOR_ID: 3755650017;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputFileLocation";
  static fromReader(reader: Reader): InputFileLocation;
    volumeId: long;
    localId: int;
    secret: long;
    fileReference: bytes;
  }
  export class InputEncryptedFileLocation extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 4112735573;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputEncryptedFileLocation";
  static fromReader(reader: Reader): InputEncryptedFileLocation;
    id: long;
    accessHash: long;
  }
  export class InputDocumentFileLocation extends VirtualClass<{
    id: long;
    accessHash: long;
    fileReference: bytes;
    thumbSize: string;
  }> {
  CONSTRUCTOR_ID: 3134223748;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputDocumentFileLocation";
  static fromReader(reader: Reader): InputDocumentFileLocation;
    id: long;
    accessHash: long;
    fileReference: bytes;
    thumbSize: string;
  }
  export class InputSecureFileLocation extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3418877480;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputSecureFileLocation";
  static fromReader(reader: Reader): InputSecureFileLocation;
    id: long;
    accessHash: long;
  }
  export class InputTakeoutFileLocation extends VirtualClass<void> {
  CONSTRUCTOR_ID: 700340377;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputTakeoutFileLocation";
  static fromReader(reader: Reader): InputTakeoutFileLocation;
}
  export class InputPhotoFileLocation extends VirtualClass<{
    id: long;
    accessHash: long;
    fileReference: bytes;
    thumbSize: string;
  }> {
  CONSTRUCTOR_ID: 1075322878;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputPhotoFileLocation";
  static fromReader(reader: Reader): InputPhotoFileLocation;
    id: long;
    accessHash: long;
    fileReference: bytes;
    thumbSize: string;
  }
  export class InputPhotoLegacyFileLocation extends VirtualClass<{
    id: long;
    accessHash: long;
    fileReference: bytes;
    volumeId: long;
    localId: int;
    secret: long;
  }> {
  CONSTRUCTOR_ID: 3627312883;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputPhotoLegacyFileLocation";
  static fromReader(reader: Reader): InputPhotoLegacyFileLocation;
    id: long;
    accessHash: long;
    fileReference: bytes;
    volumeId: long;
    localId: int;
    secret: long;
  }
  export class InputPeerPhotoFileLocation extends VirtualClass<{
    // flags: null;
    big?: boolean;
    peer: Api.TypeInputPeer;
    photoId: long;
  }> {
  CONSTRUCTOR_ID: 925204121;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputPeerPhotoFileLocation";
  static fromReader(reader: Reader): InputPeerPhotoFileLocation;
    // flags: null;
    big?: boolean;
    peer: Api.TypeInputPeer;
    photoId: long;
  }
  export class InputStickerSetThumb extends VirtualClass<{
    stickerset: Api.TypeInputStickerSet;
    thumbVersion: int;
  }> {
  CONSTRUCTOR_ID: 2642736091;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputStickerSetThumb";
  static fromReader(reader: Reader): InputStickerSetThumb;
    stickerset: Api.TypeInputStickerSet;
    thumbVersion: int;
  }
  export class InputGroupCallStream extends VirtualClass<{
    // flags: null;
    call: Api.TypeInputGroupCall;
    timeMs: long;
    scale: int;
    videoChannel?: int;
    videoQuality?: int;
  }> {
  CONSTRUCTOR_ID: 93890858;
  SUBCLASS_OF_ID: 354669666;
  classType: "constructor";
  className: "InputGroupCallStream";
  static fromReader(reader: Reader): InputGroupCallStream;
    // flags: null;
    call: Api.TypeInputGroupCall;
    timeMs: long;
    scale: int;
    videoChannel?: int;
    videoQuality?: int;
  }
  export class PeerUser extends VirtualClass<{
    userId: long;
  }> {
  CONSTRUCTOR_ID: 1498486562;
  SUBCLASS_OF_ID: 47470215;
  classType: "constructor";
  className: "PeerUser";
  static fromReader(reader: Reader): PeerUser;
    userId: long;
  }
  export class PeerChat extends VirtualClass<{
    chatId: long;
  }> {
  CONSTRUCTOR_ID: 918946202;
  SUBCLASS_OF_ID: 47470215;
  classType: "constructor";
  className: "PeerChat";
  static fromReader(reader: Reader): PeerChat;
    chatId: long;
  }
  export class PeerChannel extends VirtualClass<{
    channelId: long;
  }> {
  CONSTRUCTOR_ID: 2728736542;
  SUBCLASS_OF_ID: 47470215;
  classType: "constructor";
  className: "PeerChannel";
  static fromReader(reader: Reader): PeerChannel;
    channelId: long;
  }
  export class UserEmpty extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 3552332666;
  SUBCLASS_OF_ID: 765557111;
  classType: "constructor";
  className: "UserEmpty";
  static fromReader(reader: Reader): UserEmpty;
    id: long;
  }
  export class User extends VirtualClass<{
    // flags: null;
    self?: boolean;
    contact?: boolean;
    mutualContact?: boolean;
    deleted?: boolean;
    bot?: boolean;
    botChatHistory?: boolean;
    botNochats?: boolean;
    verified?: boolean;
    restricted?: boolean;
    min?: boolean;
    botInlineGeo?: boolean;
    support?: boolean;
    scam?: boolean;
    applyMinPhoto?: boolean;
    fake?: boolean;
    botAttachMenu?: boolean;
    premium?: boolean;
    attachMenuEnabled?: boolean;
    // flags2: null;
    botCanEdit?: boolean;
    closeFriend?: boolean;
    storiesHidden?: boolean;
    storiesUnavailable?: boolean;
    contactRequirePremium?: boolean;
    botBusiness?: boolean;
    botHasMainApp?: boolean;
    id: long;
    accessHash?: long;
    firstName?: string;
    lastName?: string;
    username?: string;
    phone?: string;
    photo?: Api.TypeUserProfilePhoto;
    status?: Api.TypeUserStatus;
    botInfoVersion?: int;
    restrictionReason?: Api.TypeRestrictionReason[];
    botInlinePlaceholder?: string;
    langCode?: string;
    emojiStatus?: Api.TypeEmojiStatus;
    usernames?: Api.TypeUsername[];
    storiesMaxId?: int;
    color?: Api.TypePeerColor;
    profileColor?: Api.TypePeerColor;
    botActiveUsers?: int;
    botVerificationIcon?: long;
  }> {
  CONSTRUCTOR_ID: 1262928766;
  SUBCLASS_OF_ID: 765557111;
  classType: "constructor";
  className: "User";
  static fromReader(reader: Reader): User;
    // flags: null;
    self?: boolean;
    contact?: boolean;
    mutualContact?: boolean;
    deleted?: boolean;
    bot?: boolean;
    botChatHistory?: boolean;
    botNochats?: boolean;
    verified?: boolean;
    restricted?: boolean;
    min?: boolean;
    botInlineGeo?: boolean;
    support?: boolean;
    scam?: boolean;
    applyMinPhoto?: boolean;
    fake?: boolean;
    botAttachMenu?: boolean;
    premium?: boolean;
    attachMenuEnabled?: boolean;
    // flags2: null;
    botCanEdit?: boolean;
    closeFriend?: boolean;
    storiesHidden?: boolean;
    storiesUnavailable?: boolean;
    contactRequirePremium?: boolean;
    botBusiness?: boolean;
    botHasMainApp?: boolean;
    id: long;
    accessHash?: long;
    firstName?: string;
    lastName?: string;
    username?: string;
    phone?: string;
    photo?: Api.TypeUserProfilePhoto;
    status?: Api.TypeUserStatus;
    botInfoVersion?: int;
    restrictionReason?: Api.TypeRestrictionReason[];
    botInlinePlaceholder?: string;
    langCode?: string;
    emojiStatus?: Api.TypeEmojiStatus;
    usernames?: Api.TypeUsername[];
    storiesMaxId?: int;
    color?: Api.TypePeerColor;
    profileColor?: Api.TypePeerColor;
    botActiveUsers?: int;
    botVerificationIcon?: long;
  }
  export class UserProfilePhotoEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1326562017;
  SUBCLASS_OF_ID: 3325267837;
  classType: "constructor";
  className: "UserProfilePhotoEmpty";
  static fromReader(reader: Reader): UserProfilePhotoEmpty;
}
  export class UserProfilePhoto extends VirtualClass<{
    // flags: null;
    hasVideo?: boolean;
    personal?: boolean;
    photoId: long;
    strippedThumb?: bytes;
    dcId: int;
  }> {
  CONSTRUCTOR_ID: 2194798342;
  SUBCLASS_OF_ID: 3325267837;
  classType: "constructor";
  className: "UserProfilePhoto";
  static fromReader(reader: Reader): UserProfilePhoto;
    // flags: null;
    hasVideo?: boolean;
    personal?: boolean;
    photoId: long;
    strippedThumb?: bytes;
    dcId: int;
  }
  export class UserStatusEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 164646985;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusEmpty";
  static fromReader(reader: Reader): UserStatusEmpty;
}
  export class UserStatusOnline extends VirtualClass<{
    expires: int;
  }> {
  CONSTRUCTOR_ID: 3988339017;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusOnline";
  static fromReader(reader: Reader): UserStatusOnline;
    expires: int;
  }
  export class UserStatusOffline extends VirtualClass<{
    wasOnline: int;
  }> {
  CONSTRUCTOR_ID: 9203775;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusOffline";
  static fromReader(reader: Reader): UserStatusOffline;
    wasOnline: int;
  }
  export class UserStatusRecently extends VirtualClass<{
    // flags: null;
    byMe?: boolean;
  }> {
  CONSTRUCTOR_ID: 2065268168;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusRecently";
  static fromReader(reader: Reader): UserStatusRecently;
    // flags: null;
    byMe?: boolean;
  }
  export class UserStatusLastWeek extends VirtualClass<{
    // flags: null;
    byMe?: boolean;
  }> {
  CONSTRUCTOR_ID: 1410997530;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusLastWeek";
  static fromReader(reader: Reader): UserStatusLastWeek;
    // flags: null;
    byMe?: boolean;
  }
  export class UserStatusLastMonth extends VirtualClass<{
    // flags: null;
    byMe?: boolean;
  }> {
  CONSTRUCTOR_ID: 1703516023;
  SUBCLASS_OF_ID: 1527477310;
  classType: "constructor";
  className: "UserStatusLastMonth";
  static fromReader(reader: Reader): UserStatusLastMonth;
    // flags: null;
    byMe?: boolean;
  }
  export class ChatEmpty extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 693512293;
  SUBCLASS_OF_ID: 3316604308;
  classType: "constructor";
  className: "ChatEmpty";
  static fromReader(reader: Reader): ChatEmpty;
    id: long;
  }
  export class Chat extends VirtualClass<{
    // flags: null;
    creator?: boolean;
    left?: boolean;
    deactivated?: boolean;
    callActive?: boolean;
    callNotEmpty?: boolean;
    noforwards?: boolean;
    id: long;
    title: string;
    photo: Api.TypeChatPhoto;
    participantsCount: int;
    date: int;
    version: int;
    migratedTo?: Api.TypeInputChannel;
    adminRights?: Api.TypeChatAdminRights;
    defaultBannedRights?: Api.TypeChatBannedRights;
  }> {
  CONSTRUCTOR_ID: 1103884886;
  SUBCLASS_OF_ID: 3316604308;
  classType: "constructor";
  className: "Chat";
  static fromReader(reader: Reader): Chat;
    // flags: null;
    creator?: boolean;
    left?: boolean;
    deactivated?: boolean;
    callActive?: boolean;
    callNotEmpty?: boolean;
    noforwards?: boolean;
    id: long;
    title: string;
    photo: Api.TypeChatPhoto;
    participantsCount: int;
    date: int;
    version: int;
    migratedTo?: Api.TypeInputChannel;
    adminRights?: Api.TypeChatAdminRights;
    defaultBannedRights?: Api.TypeChatBannedRights;
  }
  export class ChatForbidden extends VirtualClass<{
    id: long;
    title: string;
  }> {
  CONSTRUCTOR_ID: 1704108455;
  SUBCLASS_OF_ID: 3316604308;
  classType: "constructor";
  className: "ChatForbidden";
  static fromReader(reader: Reader): ChatForbidden;
    id: long;
    title: string;
  }
  export class Channel extends VirtualClass<{
    // flags: null;
    creator?: boolean;
    left?: boolean;
    broadcast?: boolean;
    verified?: boolean;
    megagroup?: boolean;
    restricted?: boolean;
    signatures?: boolean;
    min?: boolean;
    scam?: boolean;
    hasLink?: boolean;
    hasGeo?: boolean;
    slowmodeEnabled?: boolean;
    callActive?: boolean;
    callNotEmpty?: boolean;
    fake?: boolean;
    gigagroup?: boolean;
    noforwards?: boolean;
    joinToSend?: boolean;
    joinRequest?: boolean;
    forum?: boolean;
    // flags2: null;
    storiesHidden?: boolean;
    storiesHiddenMin?: boolean;
    storiesUnavailable?: boolean;
    signatureProfiles?: boolean;
    id: long;
    accessHash?: long;
    title: string;
    username?: string;
    photo: Api.TypeChatPhoto;
    date: int;
    restrictionReason?: Api.TypeRestrictionReason[];
    adminRights?: Api.TypeChatAdminRights;
    bannedRights?: Api.TypeChatBannedRights;
    defaultBannedRights?: Api.TypeChatBannedRights;
    participantsCount?: int;
    usernames?: Api.TypeUsername[];
    storiesMaxId?: int;
    color?: Api.TypePeerColor;
    profileColor?: Api.TypePeerColor;
    emojiStatus?: Api.TypeEmojiStatus;
    level?: int;
    subscriptionUntilDate?: int;
    botVerificationIcon?: long;
  }> {
  CONSTRUCTOR_ID: 3758725303;
  SUBCLASS_OF_ID: 3316604308;
  classType: "constructor";
  className: "Channel";
  static fromReader(reader: Reader): Channel;
    // flags: null;
    creator?: boolean;
    left?: boolean;
    broadcast?: boolean;
    verified?: boolean;
    megagroup?: boolean;
    restricted?: boolean;
    signatures?: boolean;
    min?: boolean;
    scam?: boolean;
    hasLink?: boolean;
    hasGeo?: boolean;
    slowmodeEnabled?: boolean;
    callActive?: boolean;
    callNotEmpty?: boolean;
    fake?: boolean;
    gigagroup?: boolean;
    noforwards?: boolean;
    joinToSend?: boolean;
    joinRequest?: boolean;
    forum?: boolean;
    // flags2: null;
    storiesHidden?: boolean;
    storiesHiddenMin?: boolean;
    storiesUnavailable?: boolean;
    signatureProfiles?: boolean;
    id: long;
    accessHash?: long;
    title: string;
    username?: string;
    photo: Api.TypeChatPhoto;
    date: int;
    restrictionReason?: Api.TypeRestrictionReason[];
    adminRights?: Api.TypeChatAdminRights;
    bannedRights?: Api.TypeChatBannedRights;
    defaultBannedRights?: Api.TypeChatBannedRights;
    participantsCount?: int;
    usernames?: Api.TypeUsername[];
    storiesMaxId?: int;
    color?: Api.TypePeerColor;
    profileColor?: Api.TypePeerColor;
    emojiStatus?: Api.TypeEmojiStatus;
    level?: int;
    subscriptionUntilDate?: int;
    botVerificationIcon?: long;
  }
  export class ChannelForbidden extends VirtualClass<{
    // flags: null;
    broadcast?: boolean;
    megagroup?: boolean;
    id: long;
    accessHash: long;
    title: string;
    untilDate?: int;
  }> {
  CONSTRUCTOR_ID: 399807445;
  SUBCLASS_OF_ID: 3316604308;
  classType: "constructor";
  className: "ChannelForbidden";
  static fromReader(reader: Reader): ChannelForbidden;
    // flags: null;
    broadcast?: boolean;
    megagroup?: boolean;
    id: long;
    accessHash: long;
    title: string;
    untilDate?: int;
  }
  export class ChatFull extends VirtualClass<{
    // flags: null;
    canSetUsername?: boolean;
    hasScheduled?: boolean;
    translationsDisabled?: boolean;
    id: long;
    about: string;
    participants: Api.TypeChatParticipants;
    chatPhoto?: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    exportedInvite?: Api.TypeExportedChatInvite;
    botInfo?: Api.TypeBotInfo[];
    pinnedMsgId?: int;
    folderId?: int;
    call?: Api.TypeInputGroupCall;
    ttlPeriod?: int;
    groupcallDefaultJoinAs?: Api.TypePeer;
    themeEmoticon?: string;
    requestsPending?: int;
    recentRequesters?: long[];
    availableReactions?: Api.TypeChatReactions;
    reactionsLimit?: int;
  }> {
  CONSTRUCTOR_ID: 640893467;
  SUBCLASS_OF_ID: 3566872215;
  classType: "constructor";
  className: "ChatFull";
  static fromReader(reader: Reader): ChatFull;
    // flags: null;
    canSetUsername?: boolean;
    hasScheduled?: boolean;
    translationsDisabled?: boolean;
    id: long;
    about: string;
    participants: Api.TypeChatParticipants;
    chatPhoto?: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    exportedInvite?: Api.TypeExportedChatInvite;
    botInfo?: Api.TypeBotInfo[];
    pinnedMsgId?: int;
    folderId?: int;
    call?: Api.TypeInputGroupCall;
    ttlPeriod?: int;
    groupcallDefaultJoinAs?: Api.TypePeer;
    themeEmoticon?: string;
    requestsPending?: int;
    recentRequesters?: long[];
    availableReactions?: Api.TypeChatReactions;
    reactionsLimit?: int;
  }
  export class ChannelFull extends VirtualClass<{
    // flags: null;
    canViewParticipants?: boolean;
    canSetUsername?: boolean;
    canSetStickers?: boolean;
    hiddenPrehistory?: boolean;
    canSetLocation?: boolean;
    hasScheduled?: boolean;
    canViewStats?: boolean;
    blocked?: boolean;
    // flags2: null;
    canDeleteChannel?: boolean;
    antispam?: boolean;
    participantsHidden?: boolean;
    translationsDisabled?: boolean;
    storiesPinnedAvailable?: boolean;
    viewForumAsMessages?: boolean;
    restrictedSponsored?: boolean;
    canViewRevenue?: boolean;
    paidMediaAllowed?: boolean;
    canViewStarsRevenue?: boolean;
    paidReactionsAvailable?: boolean;
    stargiftsAvailable?: boolean;
    id: long;
    about: string;
    participantsCount?: int;
    adminsCount?: int;
    kickedCount?: int;
    bannedCount?: int;
    onlineCount?: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    chatPhoto: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    exportedInvite?: Api.TypeExportedChatInvite;
    botInfo: Api.TypeBotInfo[];
    migratedFromChatId?: long;
    migratedFromMaxId?: int;
    pinnedMsgId?: int;
    stickerset?: Api.TypeStickerSet;
    availableMinId?: int;
    folderId?: int;
    linkedChatId?: long;
    location?: Api.TypeChannelLocation;
    slowmodeSeconds?: int;
    slowmodeNextSendDate?: int;
    statsDc?: int;
    pts: int;
    call?: Api.TypeInputGroupCall;
    ttlPeriod?: int;
    pendingSuggestions?: string[];
    groupcallDefaultJoinAs?: Api.TypePeer;
    themeEmoticon?: string;
    requestsPending?: int;
    recentRequesters?: long[];
    defaultSendAs?: Api.TypePeer;
    availableReactions?: Api.TypeChatReactions;
    reactionsLimit?: int;
    stories?: Api.TypePeerStories;
    wallpaper?: Api.TypeWallPaper;
    boostsApplied?: int;
    boostsUnrestrict?: int;
    emojiset?: Api.TypeStickerSet;
    botVerification?: Api.TypeBotVerification;
    stargiftsCount?: int;
  }> {
  CONSTRUCTOR_ID: 1389789291;
  SUBCLASS_OF_ID: 3566872215;
  classType: "constructor";
  className: "ChannelFull";
  static fromReader(reader: Reader): ChannelFull;
    // flags: null;
    canViewParticipants?: boolean;
    canSetUsername?: boolean;
    canSetStickers?: boolean;
    hiddenPrehistory?: boolean;
    canSetLocation?: boolean;
    hasScheduled?: boolean;
    canViewStats?: boolean;
    blocked?: boolean;
    // flags2: null;
    canDeleteChannel?: boolean;
    antispam?: boolean;
    participantsHidden?: boolean;
    translationsDisabled?: boolean;
    storiesPinnedAvailable?: boolean;
    viewForumAsMessages?: boolean;
    restrictedSponsored?: boolean;
    canViewRevenue?: boolean;
    paidMediaAllowed?: boolean;
    canViewStarsRevenue?: boolean;
    paidReactionsAvailable?: boolean;
    stargiftsAvailable?: boolean;
    id: long;
    about: string;
    participantsCount?: int;
    adminsCount?: int;
    kickedCount?: int;
    bannedCount?: int;
    onlineCount?: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    chatPhoto: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    exportedInvite?: Api.TypeExportedChatInvite;
    botInfo: Api.TypeBotInfo[];
    migratedFromChatId?: long;
    migratedFromMaxId?: int;
    pinnedMsgId?: int;
    stickerset?: Api.TypeStickerSet;
    availableMinId?: int;
    folderId?: int;
    linkedChatId?: long;
    location?: Api.TypeChannelLocation;
    slowmodeSeconds?: int;
    slowmodeNextSendDate?: int;
    statsDc?: int;
    pts: int;
    call?: Api.TypeInputGroupCall;
    ttlPeriod?: int;
    pendingSuggestions?: string[];
    groupcallDefaultJoinAs?: Api.TypePeer;
    themeEmoticon?: string;
    requestsPending?: int;
    recentRequesters?: long[];
    defaultSendAs?: Api.TypePeer;
    availableReactions?: Api.TypeChatReactions;
    reactionsLimit?: int;
    stories?: Api.TypePeerStories;
    wallpaper?: Api.TypeWallPaper;
    boostsApplied?: int;
    boostsUnrestrict?: int;
    emojiset?: Api.TypeStickerSet;
    botVerification?: Api.TypeBotVerification;
    stargiftsCount?: int;
  }
  export class ChatParticipant extends VirtualClass<{
    userId: long;
    inviterId: long;
    date: int;
  }> {
  CONSTRUCTOR_ID: 3224190983;
  SUBCLASS_OF_ID: 2105307014;
  classType: "constructor";
  className: "ChatParticipant";
  static fromReader(reader: Reader): ChatParticipant;
    userId: long;
    inviterId: long;
    date: int;
  }
  export class ChatParticipantCreator extends VirtualClass<{
    userId: long;
  }> {
  CONSTRUCTOR_ID: 3832270564;
  SUBCLASS_OF_ID: 2105307014;
  classType: "constructor";
  className: "ChatParticipantCreator";
  static fromReader(reader: Reader): ChatParticipantCreator;
    userId: long;
  }
  export class ChatParticipantAdmin extends VirtualClass<{
    userId: long;
    inviterId: long;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2694004571;
  SUBCLASS_OF_ID: 2105307014;
  classType: "constructor";
  className: "ChatParticipantAdmin";
  static fromReader(reader: Reader): ChatParticipantAdmin;
    userId: long;
    inviterId: long;
    date: int;
  }
  export class ChatParticipantsForbidden extends VirtualClass<{
    // flags: null;
    chatId: long;
    selfParticipant?: Api.TypeChatParticipant;
  }> {
  CONSTRUCTOR_ID: 2271466465;
  SUBCLASS_OF_ID: 531142001;
  classType: "constructor";
  className: "ChatParticipantsForbidden";
  static fromReader(reader: Reader): ChatParticipantsForbidden;
    // flags: null;
    chatId: long;
    selfParticipant?: Api.TypeChatParticipant;
  }
  export class ChatParticipants extends VirtualClass<{
    chatId: long;
    participants: Api.TypeChatParticipant[];
    version: int;
  }> {
  CONSTRUCTOR_ID: 1018991608;
  SUBCLASS_OF_ID: 531142001;
  classType: "constructor";
  className: "ChatParticipants";
  static fromReader(reader: Reader): ChatParticipants;
    chatId: long;
    participants: Api.TypeChatParticipant[];
    version: int;
  }
  export class ChatPhotoEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 935395612;
  SUBCLASS_OF_ID: 2889794789;
  classType: "constructor";
  className: "ChatPhotoEmpty";
  static fromReader(reader: Reader): ChatPhotoEmpty;
}
  export class ChatPhoto extends VirtualClass<{
    // flags: null;
    hasVideo?: boolean;
    photoId: long;
    strippedThumb?: bytes;
    dcId: int;
  }> {
  CONSTRUCTOR_ID: 476978193;
  SUBCLASS_OF_ID: 2889794789;
  classType: "constructor";
  className: "ChatPhoto";
  static fromReader(reader: Reader): ChatPhoto;
    // flags: null;
    hasVideo?: boolean;
    photoId: long;
    strippedThumb?: bytes;
    dcId: int;
  }
  export class MessageEmpty extends VirtualClass<{
    // flags: null;
    id: int;
    peerId?: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 2426849924;
  SUBCLASS_OF_ID: 2030045667;
  classType: "constructor";
  className: "MessageEmpty";
  static fromReader(reader: Reader): MessageEmpty;
    // flags: null;
    id: int;
    peerId?: Api.TypePeer;
  }
  export class Message extends CustomMessage {
  CONSTRUCTOR_ID: 2533211113;
  SUBCLASS_OF_ID: 2030045667;
  classType: "request";
  className: "Message";
  static fromReader(reader: Reader): Message;
    }
  export class MessageService extends CustomMessage {
  CONSTRUCTOR_ID: 3553789248;
  SUBCLASS_OF_ID: 2030045667;
  classType: "request";
  className: "MessageService";
  static fromReader(reader: Reader): MessageService;
    }
  export class MessageMediaEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1038967584;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaEmpty";
  static fromReader(reader: Reader): MessageMediaEmpty;
}
  export class MessageMediaPhoto extends VirtualClass<{
    // flags: null;
    spoiler?: boolean;
    photo?: Api.TypePhoto;
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 1766936791;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaPhoto";
  static fromReader(reader: Reader): MessageMediaPhoto;
    // flags: null;
    spoiler?: boolean;
    photo?: Api.TypePhoto;
    ttlSeconds?: int;
  }
  export class MessageMediaGeo extends VirtualClass<{
    geo: Api.TypeGeoPoint;
  }> {
  CONSTRUCTOR_ID: 1457575028;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaGeo";
  static fromReader(reader: Reader): MessageMediaGeo;
    geo: Api.TypeGeoPoint;
  }
  export class MessageMediaContact extends VirtualClass<{
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 1882335561;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaContact";
  static fromReader(reader: Reader): MessageMediaContact;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    userId: long;
  }
  export class MessageMediaUnsupported extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2676290718;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaUnsupported";
  static fromReader(reader: Reader): MessageMediaUnsupported;
}
  export class MessageMediaDocument extends VirtualClass<{
    // flags: null;
    nopremium?: boolean;
    spoiler?: boolean;
    video?: boolean;
    round?: boolean;
    voice?: boolean;
    document?: Api.TypeDocument;
    altDocuments?: Api.TypeDocument[];
    videoCover?: Api.TypePhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
  }> {
  CONSTRUCTOR_ID: 1389939929;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaDocument";
  static fromReader(reader: Reader): MessageMediaDocument;
    // flags: null;
    nopremium?: boolean;
    spoiler?: boolean;
    video?: boolean;
    round?: boolean;
    voice?: boolean;
    document?: Api.TypeDocument;
    altDocuments?: Api.TypeDocument[];
    videoCover?: Api.TypePhoto;
    videoTimestamp?: int;
    ttlSeconds?: int;
  }
  export class MessageMediaWebPage extends VirtualClass<{
    // flags: null;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    manual?: boolean;
    safe?: boolean;
    webpage: Api.TypeWebPage;
  }> {
  CONSTRUCTOR_ID: 3723562043;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaWebPage";
  static fromReader(reader: Reader): MessageMediaWebPage;
    // flags: null;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    manual?: boolean;
    safe?: boolean;
    webpage: Api.TypeWebPage;
  }
  export class MessageMediaVenue extends VirtualClass<{
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }> {
  CONSTRUCTOR_ID: 784356159;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaVenue";
  static fromReader(reader: Reader): MessageMediaVenue;
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }
  export class MessageMediaGame extends VirtualClass<{
    game: Api.TypeGame;
  }> {
  CONSTRUCTOR_ID: 4256272392;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaGame";
  static fromReader(reader: Reader): MessageMediaGame;
    game: Api.TypeGame;
  }
  export class MessageMediaInvoice extends VirtualClass<{
    // flags: null;
    shippingAddressRequested?: boolean;
    test?: boolean;
    title: string;
    description: string;
    photo?: Api.TypeWebDocument;
    receiptMsgId?: int;
    currency: string;
    totalAmount: long;
    startParam: string;
    extendedMedia?: Api.TypeMessageExtendedMedia;
  }> {
  CONSTRUCTOR_ID: 4138027219;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaInvoice";
  static fromReader(reader: Reader): MessageMediaInvoice;
    // flags: null;
    shippingAddressRequested?: boolean;
    test?: boolean;
    title: string;
    description: string;
    photo?: Api.TypeWebDocument;
    receiptMsgId?: int;
    currency: string;
    totalAmount: long;
    startParam: string;
    extendedMedia?: Api.TypeMessageExtendedMedia;
  }
  export class MessageMediaGeoLive extends VirtualClass<{
    // flags: null;
    geo: Api.TypeGeoPoint;
    heading?: int;
    period: int;
    proximityNotificationRadius?: int;
  }> {
  CONSTRUCTOR_ID: 3108030054;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaGeoLive";
  static fromReader(reader: Reader): MessageMediaGeoLive;
    // flags: null;
    geo: Api.TypeGeoPoint;
    heading?: int;
    period: int;
    proximityNotificationRadius?: int;
  }
  export class MessageMediaPoll extends VirtualClass<{
    poll: Api.TypePoll;
    results: Api.TypePollResults;
  }> {
  CONSTRUCTOR_ID: 1272375192;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaPoll";
  static fromReader(reader: Reader): MessageMediaPoll;
    poll: Api.TypePoll;
    results: Api.TypePollResults;
  }
  export class MessageMediaDice extends VirtualClass<{
    value: int;
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 1065280907;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaDice";
  static fromReader(reader: Reader): MessageMediaDice;
    value: int;
    emoticon: string;
  }
  export class MessageMediaStory extends VirtualClass<{
    // flags: null;
    viaMention?: boolean;
    peer: Api.TypePeer;
    id: int;
    story?: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 1758159491;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaStory";
  static fromReader(reader: Reader): MessageMediaStory;
    // flags: null;
    viaMention?: boolean;
    peer: Api.TypePeer;
    id: int;
    story?: Api.TypeStoryItem;
  }
  export class MessageMediaGiveaway extends VirtualClass<{
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    channels: long[];
    countriesIso2?: string[];
    prizeDescription?: string;
    quantity: int;
    months?: int;
    stars?: long;
    untilDate: int;
  }> {
  CONSTRUCTOR_ID: 2852600811;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaGiveaway";
  static fromReader(reader: Reader): MessageMediaGiveaway;
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    channels: long[];
    countriesIso2?: string[];
    prizeDescription?: string;
    quantity: int;
    months?: int;
    stars?: long;
    untilDate: int;
  }
  export class MessageMediaGiveawayResults extends VirtualClass<{
    // flags: null;
    onlyNewSubscribers?: boolean;
    refunded?: boolean;
    channelId: long;
    additionalPeersCount?: int;
    launchMsgId: int;
    winnersCount: int;
    unclaimedCount: int;
    winners: long[];
    months?: int;
    stars?: long;
    prizeDescription?: string;
    untilDate: int;
  }> {
  CONSTRUCTOR_ID: 3467263649;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaGiveawayResults";
  static fromReader(reader: Reader): MessageMediaGiveawayResults;
    // flags: null;
    onlyNewSubscribers?: boolean;
    refunded?: boolean;
    channelId: long;
    additionalPeersCount?: int;
    launchMsgId: int;
    winnersCount: int;
    unclaimedCount: int;
    winners: long[];
    months?: int;
    stars?: long;
    prizeDescription?: string;
    untilDate: int;
  }
  export class MessageMediaPaidMedia extends VirtualClass<{
    starsAmount: long;
    extendedMedia: Api.TypeMessageExtendedMedia[];
  }> {
  CONSTRUCTOR_ID: 2827297937;
  SUBCLASS_OF_ID: 1198308914;
  classType: "constructor";
  className: "MessageMediaPaidMedia";
  static fromReader(reader: Reader): MessageMediaPaidMedia;
    starsAmount: long;
    extendedMedia: Api.TypeMessageExtendedMedia[];
  }
  export class MessageActionEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3064919984;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionEmpty";
  static fromReader(reader: Reader): MessageActionEmpty;
}
  export class MessageActionChatCreate extends VirtualClass<{
    title: string;
    users: long[];
  }> {
  CONSTRUCTOR_ID: 3175599021;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatCreate";
  static fromReader(reader: Reader): MessageActionChatCreate;
    title: string;
    users: long[];
  }
  export class MessageActionChatEditTitle extends VirtualClass<{
    title: string;
  }> {
  CONSTRUCTOR_ID: 3047280218;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatEditTitle";
  static fromReader(reader: Reader): MessageActionChatEditTitle;
    title: string;
  }
  export class MessageActionChatEditPhoto extends VirtualClass<{
    photo: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 2144015272;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatEditPhoto";
  static fromReader(reader: Reader): MessageActionChatEditPhoto;
    photo: Api.TypePhoto;
  }
  export class MessageActionChatDeletePhoto extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2514746351;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatDeletePhoto";
  static fromReader(reader: Reader): MessageActionChatDeletePhoto;
}
  export class MessageActionChatAddUser extends VirtualClass<{
    users: long[];
  }> {
  CONSTRUCTOR_ID: 365886720;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatAddUser";
  static fromReader(reader: Reader): MessageActionChatAddUser;
    users: long[];
  }
  export class MessageActionChatDeleteUser extends VirtualClass<{
    userId: long;
  }> {
  CONSTRUCTOR_ID: 2755604684;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatDeleteUser";
  static fromReader(reader: Reader): MessageActionChatDeleteUser;
    userId: long;
  }
  export class MessageActionChatJoinedByLink extends VirtualClass<{
    inviterId: long;
  }> {
  CONSTRUCTOR_ID: 51520707;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatJoinedByLink";
  static fromReader(reader: Reader): MessageActionChatJoinedByLink;
    inviterId: long;
  }
  export class MessageActionChannelCreate extends VirtualClass<{
    title: string;
  }> {
  CONSTRUCTOR_ID: 2513611922;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChannelCreate";
  static fromReader(reader: Reader): MessageActionChannelCreate;
    title: string;
  }
  export class MessageActionChatMigrateTo extends VirtualClass<{
    channelId: long;
  }> {
  CONSTRUCTOR_ID: 3775102866;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatMigrateTo";
  static fromReader(reader: Reader): MessageActionChatMigrateTo;
    channelId: long;
  }
  export class MessageActionChannelMigrateFrom extends VirtualClass<{
    title: string;
    chatId: long;
  }> {
  CONSTRUCTOR_ID: 3929622761;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChannelMigrateFrom";
  static fromReader(reader: Reader): MessageActionChannelMigrateFrom;
    title: string;
    chatId: long;
  }
  export class MessageActionPinMessage extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2495428845;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPinMessage";
  static fromReader(reader: Reader): MessageActionPinMessage;
}
  export class MessageActionHistoryClear extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2679813636;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionHistoryClear";
  static fromReader(reader: Reader): MessageActionHistoryClear;
}
  export class MessageActionGameScore extends VirtualClass<{
    gameId: long;
    score: int;
  }> {
  CONSTRUCTOR_ID: 2460428406;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGameScore";
  static fromReader(reader: Reader): MessageActionGameScore;
    gameId: long;
    score: int;
  }
  export class MessageActionPaymentSentMe extends VirtualClass<{
    // flags: null;
    recurringInit?: boolean;
    recurringUsed?: boolean;
    currency: string;
    totalAmount: long;
    payload: bytes;
    info?: Api.TypePaymentRequestedInfo;
    shippingOptionId?: string;
    charge: Api.TypePaymentCharge;
    subscriptionUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 4288679116;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPaymentSentMe";
  static fromReader(reader: Reader): MessageActionPaymentSentMe;
    // flags: null;
    recurringInit?: boolean;
    recurringUsed?: boolean;
    currency: string;
    totalAmount: long;
    payload: bytes;
    info?: Api.TypePaymentRequestedInfo;
    shippingOptionId?: string;
    charge: Api.TypePaymentCharge;
    subscriptionUntilDate?: int;
  }
  export class MessageActionPaymentSent extends VirtualClass<{
    // flags: null;
    recurringInit?: boolean;
    recurringUsed?: boolean;
    currency: string;
    totalAmount: long;
    invoiceSlug?: string;
    subscriptionUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 3324293486;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPaymentSent";
  static fromReader(reader: Reader): MessageActionPaymentSent;
    // flags: null;
    recurringInit?: boolean;
    recurringUsed?: boolean;
    currency: string;
    totalAmount: long;
    invoiceSlug?: string;
    subscriptionUntilDate?: int;
  }
  export class MessageActionPhoneCall extends VirtualClass<{
    // flags: null;
    video?: boolean;
    callId: long;
    reason?: Api.TypePhoneCallDiscardReason;
    duration?: int;
  }> {
  CONSTRUCTOR_ID: 2162236031;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPhoneCall";
  static fromReader(reader: Reader): MessageActionPhoneCall;
    // flags: null;
    video?: boolean;
    callId: long;
    reason?: Api.TypePhoneCallDiscardReason;
    duration?: int;
  }
  export class MessageActionScreenshotTaken extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1200788123;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionScreenshotTaken";
  static fromReader(reader: Reader): MessageActionScreenshotTaken;
}
  export class MessageActionCustomAction extends VirtualClass<{
    message: string;
  }> {
  CONSTRUCTOR_ID: 4209418070;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionCustomAction";
  static fromReader(reader: Reader): MessageActionCustomAction;
    message: string;
  }
  export class MessageActionBotAllowed extends VirtualClass<{
    // flags: null;
    attachMenu?: boolean;
    fromRequest?: boolean;
    domain?: string;
    app?: Api.TypeBotApp;
  }> {
  CONSTRUCTOR_ID: 3306608249;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionBotAllowed";
  static fromReader(reader: Reader): MessageActionBotAllowed;
    // flags: null;
    attachMenu?: boolean;
    fromRequest?: boolean;
    domain?: string;
    app?: Api.TypeBotApp;
  }
  export class MessageActionSecureValuesSentMe extends VirtualClass<{
    values: Api.TypeSecureValue[];
    credentials: Api.TypeSecureCredentialsEncrypted;
  }> {
  CONSTRUCTOR_ID: 455635795;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSecureValuesSentMe";
  static fromReader(reader: Reader): MessageActionSecureValuesSentMe;
    values: Api.TypeSecureValue[];
    credentials: Api.TypeSecureCredentialsEncrypted;
  }
  export class MessageActionSecureValuesSent extends VirtualClass<{
    types: Api.TypeSecureValueType[];
  }> {
  CONSTRUCTOR_ID: 3646710100;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSecureValuesSent";
  static fromReader(reader: Reader): MessageActionSecureValuesSent;
    types: Api.TypeSecureValueType[];
  }
  export class MessageActionContactSignUp extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4092747638;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionContactSignUp";
  static fromReader(reader: Reader): MessageActionContactSignUp;
}
  export class MessageActionGeoProximityReached extends VirtualClass<{
    fromId: Api.TypePeer;
    toId: Api.TypePeer;
    distance: int;
  }> {
  CONSTRUCTOR_ID: 2564871831;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGeoProximityReached";
  static fromReader(reader: Reader): MessageActionGeoProximityReached;
    fromId: Api.TypePeer;
    toId: Api.TypePeer;
    distance: int;
  }
  export class MessageActionGroupCall extends VirtualClass<{
    // flags: null;
    call: Api.TypeInputGroupCall;
    duration?: int;
  }> {
  CONSTRUCTOR_ID: 2047704898;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGroupCall";
  static fromReader(reader: Reader): MessageActionGroupCall;
    // flags: null;
    call: Api.TypeInputGroupCall;
    duration?: int;
  }
  export class MessageActionInviteToGroupCall extends VirtualClass<{
    call: Api.TypeInputGroupCall;
    users: long[];
  }> {
  CONSTRUCTOR_ID: 1345295095;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionInviteToGroupCall";
  static fromReader(reader: Reader): MessageActionInviteToGroupCall;
    call: Api.TypeInputGroupCall;
    users: long[];
  }
  export class MessageActionSetMessagesTTL extends VirtualClass<{
    // flags: null;
    period: int;
    autoSettingFrom?: long;
  }> {
  CONSTRUCTOR_ID: 1007897979;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSetMessagesTTL";
  static fromReader(reader: Reader): MessageActionSetMessagesTTL;
    // flags: null;
    period: int;
    autoSettingFrom?: long;
  }
  export class MessageActionGroupCallScheduled extends VirtualClass<{
    call: Api.TypeInputGroupCall;
    scheduleDate: int;
  }> {
  CONSTRUCTOR_ID: 3013637729;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGroupCallScheduled";
  static fromReader(reader: Reader): MessageActionGroupCallScheduled;
    call: Api.TypeInputGroupCall;
    scheduleDate: int;
  }
  export class MessageActionSetChatTheme extends VirtualClass<{
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 2860016453;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSetChatTheme";
  static fromReader(reader: Reader): MessageActionSetChatTheme;
    emoticon: string;
  }
  export class MessageActionChatJoinedByRequest extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3955008459;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionChatJoinedByRequest";
  static fromReader(reader: Reader): MessageActionChatJoinedByRequest;
}
  export class MessageActionWebViewDataSentMe extends VirtualClass<{
    text: string;
    data: string;
  }> {
  CONSTRUCTOR_ID: 1205698681;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionWebViewDataSentMe";
  static fromReader(reader: Reader): MessageActionWebViewDataSentMe;
    text: string;
    data: string;
  }
  export class MessageActionWebViewDataSent extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 3032714421;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionWebViewDataSent";
  static fromReader(reader: Reader): MessageActionWebViewDataSent;
    text: string;
  }
  export class MessageActionGiftPremium extends VirtualClass<{
    // flags: null;
    currency: string;
    amount: long;
    months: int;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    message?: Api.TypeTextWithEntities;
  }> {
  CONSTRUCTOR_ID: 1818391802;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGiftPremium";
  static fromReader(reader: Reader): MessageActionGiftPremium;
    // flags: null;
    currency: string;
    amount: long;
    months: int;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    message?: Api.TypeTextWithEntities;
  }
  export class MessageActionTopicCreate extends VirtualClass<{
    // flags: null;
    title: string;
    iconColor: int;
    iconEmojiId?: long;
  }> {
  CONSTRUCTOR_ID: 228168278;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionTopicCreate";
  static fromReader(reader: Reader): MessageActionTopicCreate;
    // flags: null;
    title: string;
    iconColor: int;
    iconEmojiId?: long;
  }
  export class MessageActionTopicEdit extends VirtualClass<{
    // flags: null;
    title?: string;
    iconEmojiId?: long;
    closed?: Bool;
    hidden?: Bool;
  }> {
  CONSTRUCTOR_ID: 3230943264;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionTopicEdit";
  static fromReader(reader: Reader): MessageActionTopicEdit;
    // flags: null;
    title?: string;
    iconEmojiId?: long;
    closed?: Bool;
    hidden?: Bool;
  }
  export class MessageActionSuggestProfilePhoto extends VirtualClass<{
    photo: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 1474192222;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSuggestProfilePhoto";
  static fromReader(reader: Reader): MessageActionSuggestProfilePhoto;
    photo: Api.TypePhoto;
  }
  export class MessageActionRequestedPeer extends VirtualClass<{
    buttonId: int;
    peers: Api.TypePeer[];
  }> {
  CONSTRUCTOR_ID: 827428507;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionRequestedPeer";
  static fromReader(reader: Reader): MessageActionRequestedPeer;
    buttonId: int;
    peers: Api.TypePeer[];
  }
  export class MessageActionSetChatWallPaper extends VirtualClass<{
    // flags: null;
    same?: boolean;
    forBoth?: boolean;
    wallpaper: Api.TypeWallPaper;
  }> {
  CONSTRUCTOR_ID: 1348510708;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionSetChatWallPaper";
  static fromReader(reader: Reader): MessageActionSetChatWallPaper;
    // flags: null;
    same?: boolean;
    forBoth?: boolean;
    wallpaper: Api.TypeWallPaper;
  }
  export class MessageActionGiftCode extends VirtualClass<{
    // flags: null;
    viaGiveaway?: boolean;
    unclaimed?: boolean;
    boostPeer?: Api.TypePeer;
    months: int;
    slug: string;
    currency?: string;
    amount?: long;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    message?: Api.TypeTextWithEntities;
  }> {
  CONSTRUCTOR_ID: 1456486804;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGiftCode";
  static fromReader(reader: Reader): MessageActionGiftCode;
    // flags: null;
    viaGiveaway?: boolean;
    unclaimed?: boolean;
    boostPeer?: Api.TypePeer;
    months: int;
    slug: string;
    currency?: string;
    amount?: long;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    message?: Api.TypeTextWithEntities;
  }
  export class MessageActionGiveawayLaunch extends VirtualClass<{
    // flags: null;
    stars?: long;
  }> {
  CONSTRUCTOR_ID: 2819576292;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGiveawayLaunch";
  static fromReader(reader: Reader): MessageActionGiveawayLaunch;
    // flags: null;
    stars?: long;
  }
  export class MessageActionGiveawayResults extends VirtualClass<{
    // flags: null;
    stars?: boolean;
    winnersCount: int;
    unclaimedCount: int;
  }> {
  CONSTRUCTOR_ID: 2279797077;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGiveawayResults";
  static fromReader(reader: Reader): MessageActionGiveawayResults;
    // flags: null;
    stars?: boolean;
    winnersCount: int;
    unclaimedCount: int;
  }
  export class MessageActionBoostApply extends VirtualClass<{
    boosts: int;
  }> {
  CONSTRUCTOR_ID: 3422726765;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionBoostApply";
  static fromReader(reader: Reader): MessageActionBoostApply;
    boosts: int;
  }
  export class MessageActionRequestedPeerSentMe extends VirtualClass<{
    buttonId: int;
    peers: Api.TypeRequestedPeer[];
  }> {
  CONSTRUCTOR_ID: 2477987912;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionRequestedPeerSentMe";
  static fromReader(reader: Reader): MessageActionRequestedPeerSentMe;
    buttonId: int;
    peers: Api.TypeRequestedPeer[];
  }
  export class MessageActionPaymentRefunded extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    currency: string;
    totalAmount: long;
    payload?: bytes;
    charge: Api.TypePaymentCharge;
  }> {
  CONSTRUCTOR_ID: 1102307842;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPaymentRefunded";
  static fromReader(reader: Reader): MessageActionPaymentRefunded;
    // flags: null;
    peer: Api.TypePeer;
    currency: string;
    totalAmount: long;
    payload?: bytes;
    charge: Api.TypePaymentCharge;
  }
  export class MessageActionGiftStars extends VirtualClass<{
    // flags: null;
    currency: string;
    amount: long;
    stars: long;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    transactionId?: string;
  }> {
  CONSTRUCTOR_ID: 1171632161;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionGiftStars";
  static fromReader(reader: Reader): MessageActionGiftStars;
    // flags: null;
    currency: string;
    amount: long;
    stars: long;
    cryptoCurrency?: string;
    cryptoAmount?: long;
    transactionId?: string;
  }
  export class MessageActionPrizeStars extends VirtualClass<{
    // flags: null;
    unclaimed?: boolean;
    stars: long;
    transactionId: string;
    boostPeer: Api.TypePeer;
    giveawayMsgId: int;
  }> {
  CONSTRUCTOR_ID: 2953594786;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionPrizeStars";
  static fromReader(reader: Reader): MessageActionPrizeStars;
    // flags: null;
    unclaimed?: boolean;
    stars: long;
    transactionId: string;
    boostPeer: Api.TypePeer;
    giveawayMsgId: int;
  }
  export class MessageActionStarGift extends VirtualClass<{
    // flags: null;
    nameHidden?: boolean;
    saved?: boolean;
    converted?: boolean;
    upgraded?: boolean;
    refunded?: boolean;
    canUpgrade?: boolean;
    gift: Api.TypeStarGift;
    message?: Api.TypeTextWithEntities;
    convertStars?: long;
    upgradeMsgId?: int;
    upgradeStars?: long;
    fromId?: Api.TypePeer;
    peer?: Api.TypePeer;
    savedId?: long;
  }> {
  CONSTRUCTOR_ID: 1192749220;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionStarGift";
  static fromReader(reader: Reader): MessageActionStarGift;
    // flags: null;
    nameHidden?: boolean;
    saved?: boolean;
    converted?: boolean;
    upgraded?: boolean;
    refunded?: boolean;
    canUpgrade?: boolean;
    gift: Api.TypeStarGift;
    message?: Api.TypeTextWithEntities;
    convertStars?: long;
    upgradeMsgId?: int;
    upgradeStars?: long;
    fromId?: Api.TypePeer;
    peer?: Api.TypePeer;
    savedId?: long;
  }
  export class MessageActionStarGiftUnique extends VirtualClass<{
    // flags: null;
    upgrade?: boolean;
    transferred?: boolean;
    saved?: boolean;
    refunded?: boolean;
    gift: Api.TypeStarGift;
    canExportAt?: int;
    transferStars?: long;
    fromId?: Api.TypePeer;
    peer?: Api.TypePeer;
    savedId?: long;
  }> {
  CONSTRUCTOR_ID: 2900347777;
  SUBCLASS_OF_ID: 2256589094;
  classType: "constructor";
  className: "MessageActionStarGiftUnique";
  static fromReader(reader: Reader): MessageActionStarGiftUnique;
    // flags: null;
    upgrade?: boolean;
    transferred?: boolean;
    saved?: boolean;
    refunded?: boolean;
    gift: Api.TypeStarGift;
    canExportAt?: int;
    transferStars?: long;
    fromId?: Api.TypePeer;
    peer?: Api.TypePeer;
    savedId?: long;
  }
  export class Dialog extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    unreadMark?: boolean;
    viewForumAsMessages?: boolean;
    peer: Api.TypePeer;
    topMessage: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    unreadMentionsCount: int;
    unreadReactionsCount: int;
    notifySettings: Api.TypePeerNotifySettings;
    pts?: int;
    draft?: Api.TypeDraftMessage;
    folderId?: int;
    ttlPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 3582593222;
  SUBCLASS_OF_ID: 1120787796;
  classType: "constructor";
  className: "Dialog";
  static fromReader(reader: Reader): Dialog;
    // flags: null;
    pinned?: boolean;
    unreadMark?: boolean;
    viewForumAsMessages?: boolean;
    peer: Api.TypePeer;
    topMessage: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    unreadMentionsCount: int;
    unreadReactionsCount: int;
    notifySettings: Api.TypePeerNotifySettings;
    pts?: int;
    draft?: Api.TypeDraftMessage;
    folderId?: int;
    ttlPeriod?: int;
  }
  export class DialogFolder extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    folder: Api.TypeFolder;
    peer: Api.TypePeer;
    topMessage: int;
    unreadMutedPeersCount: int;
    unreadUnmutedPeersCount: int;
    unreadMutedMessagesCount: int;
    unreadUnmutedMessagesCount: int;
  }> {
  CONSTRUCTOR_ID: 1908216652;
  SUBCLASS_OF_ID: 1120787796;
  classType: "constructor";
  className: "DialogFolder";
  static fromReader(reader: Reader): DialogFolder;
    // flags: null;
    pinned?: boolean;
    folder: Api.TypeFolder;
    peer: Api.TypePeer;
    topMessage: int;
    unreadMutedPeersCount: int;
    unreadUnmutedPeersCount: int;
    unreadMutedMessagesCount: int;
    unreadUnmutedMessagesCount: int;
  }
  export class PhotoEmpty extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 590459437;
  SUBCLASS_OF_ID: 3581324060;
  classType: "constructor";
  className: "PhotoEmpty";
  static fromReader(reader: Reader): PhotoEmpty;
    id: long;
  }
  export class Photo extends VirtualClass<{
    // flags: null;
    hasStickers?: boolean;
    id: long;
    accessHash: long;
    fileReference: bytes;
    date: int;
    sizes: Api.TypePhotoSize[];
    videoSizes?: Api.TypeVideoSize[];
    dcId: int;
  }> {
  CONSTRUCTOR_ID: 4212750949;
  SUBCLASS_OF_ID: 3581324060;
  classType: "constructor";
  className: "Photo";
  static fromReader(reader: Reader): Photo;
    // flags: null;
    hasStickers?: boolean;
    id: long;
    accessHash: long;
    fileReference: bytes;
    date: int;
    sizes: Api.TypePhotoSize[];
    videoSizes?: Api.TypeVideoSize[];
    dcId: int;
  }
  export class PhotoSizeEmpty extends VirtualClass<{
    type: string;
  }> {
  CONSTRUCTOR_ID: 236446268;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoSizeEmpty";
  static fromReader(reader: Reader): PhotoSizeEmpty;
    type: string;
  }
  export class PhotoSize extends VirtualClass<{
    type: string;
    w: int;
    h: int;
    size: int;
  }> {
  CONSTRUCTOR_ID: 1976012384;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoSize";
  static fromReader(reader: Reader): PhotoSize;
    type: string;
    w: int;
    h: int;
    size: int;
  }
  export class PhotoCachedSize extends VirtualClass<{
    type: string;
    w: int;
    h: int;
    bytes: bytes;
  }> {
  CONSTRUCTOR_ID: 35527382;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoCachedSize";
  static fromReader(reader: Reader): PhotoCachedSize;
    type: string;
    w: int;
    h: int;
    bytes: bytes;
  }
  export class PhotoStrippedSize extends VirtualClass<{
    type: string;
    bytes: bytes;
  }> {
  CONSTRUCTOR_ID: 3769678894;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoStrippedSize";
  static fromReader(reader: Reader): PhotoStrippedSize;
    type: string;
    bytes: bytes;
  }
  export class PhotoSizeProgressive extends VirtualClass<{
    type: string;
    w: int;
    h: int;
    sizes: int[];
  }> {
  CONSTRUCTOR_ID: 4198431637;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoSizeProgressive";
  static fromReader(reader: Reader): PhotoSizeProgressive;
    type: string;
    w: int;
    h: int;
    sizes: int[];
  }
  export class PhotoPathSize extends VirtualClass<{
    type: string;
    bytes: bytes;
  }> {
  CONSTRUCTOR_ID: 3626061121;
  SUBCLASS_OF_ID: 399256025;
  classType: "constructor";
  className: "PhotoPathSize";
  static fromReader(reader: Reader): PhotoPathSize;
    type: string;
    bytes: bytes;
  }
  export class GeoPointEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 286776671;
  SUBCLASS_OF_ID: 3591430509;
  classType: "constructor";
  className: "GeoPointEmpty";
  static fromReader(reader: Reader): GeoPointEmpty;
}
  export class GeoPoint extends VirtualClass<{
    // flags: null;
    long: double;
    lat: double;
    accessHash: long;
    accuracyRadius?: int;
  }> {
  CONSTRUCTOR_ID: 2997024355;
  SUBCLASS_OF_ID: 3591430509;
  classType: "constructor";
  className: "GeoPoint";
  static fromReader(reader: Reader): GeoPoint;
    // flags: null;
    long: double;
    lat: double;
    accessHash: long;
    accuracyRadius?: int;
  }
  export class InputNotifyPeer extends VirtualClass<{
    peer: Api.TypeInputPeer;
  }> {
  CONSTRUCTOR_ID: 3099351820;
  SUBCLASS_OF_ID: 1486362133;
  classType: "constructor";
  className: "InputNotifyPeer";
  static fromReader(reader: Reader): InputNotifyPeer;
    peer: Api.TypeInputPeer;
  }
  export class InputNotifyUsers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 423314455;
  SUBCLASS_OF_ID: 1486362133;
  classType: "constructor";
  className: "InputNotifyUsers";
  static fromReader(reader: Reader): InputNotifyUsers;
}
  export class InputNotifyChats extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1251338318;
  SUBCLASS_OF_ID: 1486362133;
  classType: "constructor";
  className: "InputNotifyChats";
  static fromReader(reader: Reader): InputNotifyChats;
}
  export class InputNotifyBroadcasts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2983951486;
  SUBCLASS_OF_ID: 1486362133;
  classType: "constructor";
  className: "InputNotifyBroadcasts";
  static fromReader(reader: Reader): InputNotifyBroadcasts;
}
  export class InputNotifyForumTopic extends VirtualClass<{
    peer: Api.TypeInputPeer;
    topMsgId: int;
  }> {
  CONSTRUCTOR_ID: 1548122514;
  SUBCLASS_OF_ID: 1486362133;
  classType: "constructor";
  className: "InputNotifyForumTopic";
  static fromReader(reader: Reader): InputNotifyForumTopic;
    peer: Api.TypeInputPeer;
    topMsgId: int;
  }
  export class InputPeerNotifySettings extends VirtualClass<{
    // flags: null;
    showPreviews?: Bool;
    silent?: Bool;
    muteUntil?: int;
    sound?: Api.TypeNotificationSound;
    storiesMuted?: Bool;
    storiesHideSender?: Bool;
    storiesSound?: Api.TypeNotificationSound;
  }> {
  CONSTRUCTOR_ID: 3402328802;
  SUBCLASS_OF_ID: 2430274317;
  classType: "constructor";
  className: "InputPeerNotifySettings";
  static fromReader(reader: Reader): InputPeerNotifySettings;
    // flags: null;
    showPreviews?: Bool;
    silent?: Bool;
    muteUntil?: int;
    sound?: Api.TypeNotificationSound;
    storiesMuted?: Bool;
    storiesHideSender?: Bool;
    storiesSound?: Api.TypeNotificationSound;
  }
  export class PeerNotifySettings extends VirtualClass<{
    // flags: null;
    showPreviews?: Bool;
    silent?: Bool;
    muteUntil?: int;
    iosSound?: Api.TypeNotificationSound;
    androidSound?: Api.TypeNotificationSound;
    otherSound?: Api.TypeNotificationSound;
    storiesMuted?: Bool;
    storiesHideSender?: Bool;
    storiesIosSound?: Api.TypeNotificationSound;
    storiesAndroidSound?: Api.TypeNotificationSound;
    storiesOtherSound?: Api.TypeNotificationSound;
  }> {
  CONSTRUCTOR_ID: 2573347852;
  SUBCLASS_OF_ID: 3475030132;
  classType: "constructor";
  className: "PeerNotifySettings";
  static fromReader(reader: Reader): PeerNotifySettings;
    // flags: null;
    showPreviews?: Bool;
    silent?: Bool;
    muteUntil?: int;
    iosSound?: Api.TypeNotificationSound;
    androidSound?: Api.TypeNotificationSound;
    otherSound?: Api.TypeNotificationSound;
    storiesMuted?: Bool;
    storiesHideSender?: Bool;
    storiesIosSound?: Api.TypeNotificationSound;
    storiesAndroidSound?: Api.TypeNotificationSound;
    storiesOtherSound?: Api.TypeNotificationSound;
  }
  export class PeerSettings extends VirtualClass<{
    // flags: null;
    reportSpam?: boolean;
    addContact?: boolean;
    blockContact?: boolean;
    shareContact?: boolean;
    needContactsException?: boolean;
    reportGeo?: boolean;
    autoarchived?: boolean;
    inviteMembers?: boolean;
    requestChatBroadcast?: boolean;
    businessBotPaused?: boolean;
    businessBotCanReply?: boolean;
    geoDistance?: int;
    requestChatTitle?: string;
    requestChatDate?: int;
    businessBotId?: long;
    businessBotManageUrl?: string;
  }> {
  CONSTRUCTOR_ID: 2899733598;
  SUBCLASS_OF_ID: 4138180484;
  classType: "constructor";
  className: "PeerSettings";
  static fromReader(reader: Reader): PeerSettings;
    // flags: null;
    reportSpam?: boolean;
    addContact?: boolean;
    blockContact?: boolean;
    shareContact?: boolean;
    needContactsException?: boolean;
    reportGeo?: boolean;
    autoarchived?: boolean;
    inviteMembers?: boolean;
    requestChatBroadcast?: boolean;
    businessBotPaused?: boolean;
    businessBotCanReply?: boolean;
    geoDistance?: int;
    requestChatTitle?: string;
    requestChatDate?: int;
    businessBotId?: long;
    businessBotManageUrl?: string;
  }
  export class WallPaper extends VirtualClass<{
    id: long;
    // flags: null;
    creator?: boolean;
    default?: boolean;
    pattern?: boolean;
    dark?: boolean;
    accessHash: long;
    slug: string;
    document: Api.TypeDocument;
    settings?: Api.TypeWallPaperSettings;
  }> {
  CONSTRUCTOR_ID: 2755118061;
  SUBCLASS_OF_ID: 2527250827;
  classType: "constructor";
  className: "WallPaper";
  static fromReader(reader: Reader): WallPaper;
    id: long;
    // flags: null;
    creator?: boolean;
    default?: boolean;
    pattern?: boolean;
    dark?: boolean;
    accessHash: long;
    slug: string;
    document: Api.TypeDocument;
    settings?: Api.TypeWallPaperSettings;
  }
  export class WallPaperNoFile extends VirtualClass<{
    id: long;
    // flags: null;
    default?: boolean;
    dark?: boolean;
    settings?: Api.TypeWallPaperSettings;
  }> {
  CONSTRUCTOR_ID: 3766501654;
  SUBCLASS_OF_ID: 2527250827;
  classType: "constructor";
  className: "WallPaperNoFile";
  static fromReader(reader: Reader): WallPaperNoFile;
    id: long;
    // flags: null;
    default?: boolean;
    dark?: boolean;
    settings?: Api.TypeWallPaperSettings;
  }
  export class InputReportReasonSpam extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1490799288;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonSpam";
  static fromReader(reader: Reader): InputReportReasonSpam;
}
  export class InputReportReasonViolence extends VirtualClass<void> {
  CONSTRUCTOR_ID: 505595789;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonViolence";
  static fromReader(reader: Reader): InputReportReasonViolence;
}
  export class InputReportReasonPornography extends VirtualClass<void> {
  CONSTRUCTOR_ID: 777640226;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonPornography";
  static fromReader(reader: Reader): InputReportReasonPornography;
}
  export class InputReportReasonChildAbuse extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2918469347;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonChildAbuse";
  static fromReader(reader: Reader): InputReportReasonChildAbuse;
}
  export class InputReportReasonOther extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3252986545;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonOther";
  static fromReader(reader: Reader): InputReportReasonOther;
}
  export class InputReportReasonCopyright extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2609510714;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonCopyright";
  static fromReader(reader: Reader): InputReportReasonCopyright;
}
  export class InputReportReasonGeoIrrelevant extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3688169197;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonGeoIrrelevant";
  static fromReader(reader: Reader): InputReportReasonGeoIrrelevant;
}
  export class InputReportReasonFake extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4124956391;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonFake";
  static fromReader(reader: Reader): InputReportReasonFake;
}
  export class InputReportReasonIllegalDrugs extends VirtualClass<void> {
  CONSTRUCTOR_ID: 177124030;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonIllegalDrugs";
  static fromReader(reader: Reader): InputReportReasonIllegalDrugs;
}
  export class InputReportReasonPersonalDetails extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2663876157;
  SUBCLASS_OF_ID: 2214706471;
  classType: "constructor";
  className: "InputReportReasonPersonalDetails";
  static fromReader(reader: Reader): InputReportReasonPersonalDetails;
}
  export class UserFull extends VirtualClass<{
    // flags: null;
    blocked?: boolean;
    phoneCallsAvailable?: boolean;
    phoneCallsPrivate?: boolean;
    canPinMessage?: boolean;
    hasScheduled?: boolean;
    videoCallsAvailable?: boolean;
    voiceMessagesForbidden?: boolean;
    translationsDisabled?: boolean;
    storiesPinnedAvailable?: boolean;
    blockedMyStoriesFrom?: boolean;
    wallpaperOverridden?: boolean;
    contactRequirePremium?: boolean;
    readDatesPrivate?: boolean;
    // flags2: null;
    sponsoredEnabled?: boolean;
    canViewRevenue?: boolean;
    botCanManageEmojiStatus?: boolean;
    id: long;
    about?: string;
    settings: Api.TypePeerSettings;
    personalPhoto?: Api.TypePhoto;
    profilePhoto?: Api.TypePhoto;
    fallbackPhoto?: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    botInfo?: Api.TypeBotInfo;
    pinnedMsgId?: int;
    commonChatsCount: int;
    folderId?: int;
    ttlPeriod?: int;
    themeEmoticon?: string;
    privateForwardName?: string;
    botGroupAdminRights?: Api.TypeChatAdminRights;
    botBroadcastAdminRights?: Api.TypeChatAdminRights;
    premiumGifts?: Api.TypePremiumGiftOption[];
    wallpaper?: Api.TypeWallPaper;
    stories?: Api.TypePeerStories;
    businessWorkHours?: Api.TypeBusinessWorkHours;
    businessLocation?: Api.TypeBusinessLocation;
    businessGreetingMessage?: Api.TypeBusinessGreetingMessage;
    businessAwayMessage?: Api.TypeBusinessAwayMessage;
    businessIntro?: Api.TypeBusinessIntro;
    birthday?: Api.TypeBirthday;
    personalChannelId?: long;
    personalChannelMessage?: int;
    stargiftsCount?: int;
    starrefProgram?: Api.TypeStarRefProgram;
    botVerification?: Api.TypeBotVerification;
  }> {
  CONSTRUCTOR_ID: 1301765052;
  SUBCLASS_OF_ID: 524706233;
  classType: "constructor";
  className: "UserFull";
  static fromReader(reader: Reader): UserFull;
    // flags: null;
    blocked?: boolean;
    phoneCallsAvailable?: boolean;
    phoneCallsPrivate?: boolean;
    canPinMessage?: boolean;
    hasScheduled?: boolean;
    videoCallsAvailable?: boolean;
    voiceMessagesForbidden?: boolean;
    translationsDisabled?: boolean;
    storiesPinnedAvailable?: boolean;
    blockedMyStoriesFrom?: boolean;
    wallpaperOverridden?: boolean;
    contactRequirePremium?: boolean;
    readDatesPrivate?: boolean;
    // flags2: null;
    sponsoredEnabled?: boolean;
    canViewRevenue?: boolean;
    botCanManageEmojiStatus?: boolean;
    id: long;
    about?: string;
    settings: Api.TypePeerSettings;
    personalPhoto?: Api.TypePhoto;
    profilePhoto?: Api.TypePhoto;
    fallbackPhoto?: Api.TypePhoto;
    notifySettings: Api.TypePeerNotifySettings;
    botInfo?: Api.TypeBotInfo;
    pinnedMsgId?: int;
    commonChatsCount: int;
    folderId?: int;
    ttlPeriod?: int;
    themeEmoticon?: string;
    privateForwardName?: string;
    botGroupAdminRights?: Api.TypeChatAdminRights;
    botBroadcastAdminRights?: Api.TypeChatAdminRights;
    premiumGifts?: Api.TypePremiumGiftOption[];
    wallpaper?: Api.TypeWallPaper;
    stories?: Api.TypePeerStories;
    businessWorkHours?: Api.TypeBusinessWorkHours;
    businessLocation?: Api.TypeBusinessLocation;
    businessGreetingMessage?: Api.TypeBusinessGreetingMessage;
    businessAwayMessage?: Api.TypeBusinessAwayMessage;
    businessIntro?: Api.TypeBusinessIntro;
    birthday?: Api.TypeBirthday;
    personalChannelId?: long;
    personalChannelMessage?: int;
    stargiftsCount?: int;
    starrefProgram?: Api.TypeStarRefProgram;
    botVerification?: Api.TypeBotVerification;
  }
  export class Contact extends VirtualClass<{
    userId: long;
    mutual: Bool;
  }> {
  CONSTRUCTOR_ID: 341499403;
  SUBCLASS_OF_ID: 2212487076;
  classType: "constructor";
  className: "Contact";
  static fromReader(reader: Reader): Contact;
    userId: long;
    mutual: Bool;
  }
  export class ImportedContact extends VirtualClass<{
    userId: long;
    clientId: long;
  }> {
  CONSTRUCTOR_ID: 3242081360;
  SUBCLASS_OF_ID: 3041246170;
  classType: "constructor";
  className: "ImportedContact";
  static fromReader(reader: Reader): ImportedContact;
    userId: long;
    clientId: long;
  }
  export class ContactStatus extends VirtualClass<{
    userId: long;
    status: Api.TypeUserStatus;
  }> {
  CONSTRUCTOR_ID: 383348795;
  SUBCLASS_OF_ID: 1757468492;
  classType: "constructor";
  className: "ContactStatus";
  static fromReader(reader: Reader): ContactStatus;
    userId: long;
    status: Api.TypeUserStatus;
  }
  export class InputMessagesFilterEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1474492012;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterEmpty";
  static fromReader(reader: Reader): InputMessagesFilterEmpty;
}
  export class InputMessagesFilterPhotos extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2517214492;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterPhotos";
  static fromReader(reader: Reader): InputMessagesFilterPhotos;
}
  export class InputMessagesFilterVideo extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2680163941;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterVideo";
  static fromReader(reader: Reader): InputMessagesFilterVideo;
}
  export class InputMessagesFilterPhotoVideo extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1458172132;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterPhotoVideo";
  static fromReader(reader: Reader): InputMessagesFilterPhotoVideo;
}
  export class InputMessagesFilterDocument extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2665345416;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterDocument";
  static fromReader(reader: Reader): InputMessagesFilterDocument;
}
  export class InputMessagesFilterUrl extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2129714567;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterUrl";
  static fromReader(reader: Reader): InputMessagesFilterUrl;
}
  export class InputMessagesFilterGif extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4291323271;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterGif";
  static fromReader(reader: Reader): InputMessagesFilterGif;
}
  export class InputMessagesFilterVoice extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1358283666;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterVoice";
  static fromReader(reader: Reader): InputMessagesFilterVoice;
}
  export class InputMessagesFilterMusic extends VirtualClass<void> {
  CONSTRUCTOR_ID: 928101534;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterMusic";
  static fromReader(reader: Reader): InputMessagesFilterMusic;
}
  export class InputMessagesFilterChatPhotos extends VirtualClass<void> {
  CONSTRUCTOR_ID: 975236280;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterChatPhotos";
  static fromReader(reader: Reader): InputMessagesFilterChatPhotos;
}
  export class InputMessagesFilterPhoneCalls extends VirtualClass<{
    // flags: null;
    missed?: boolean;
  }> {
  CONSTRUCTOR_ID: 2160695144;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterPhoneCalls";
  static fromReader(reader: Reader): InputMessagesFilterPhoneCalls;
    // flags: null;
    missed?: boolean;
  }
  export class InputMessagesFilterRoundVoice extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2054952868;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterRoundVoice";
  static fromReader(reader: Reader): InputMessagesFilterRoundVoice;
}
  export class InputMessagesFilterRoundVideo extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3041516115;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterRoundVideo";
  static fromReader(reader: Reader): InputMessagesFilterRoundVideo;
}
  export class InputMessagesFilterMyMentions extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3254314650;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterMyMentions";
  static fromReader(reader: Reader): InputMessagesFilterMyMentions;
}
  export class InputMessagesFilterGeo extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3875695885;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterGeo";
  static fromReader(reader: Reader): InputMessagesFilterGeo;
}
  export class InputMessagesFilterContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3764575107;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterContacts";
  static fromReader(reader: Reader): InputMessagesFilterContacts;
}
  export class InputMessagesFilterPinned extends VirtualClass<void> {
  CONSTRUCTOR_ID: 464520273;
  SUBCLASS_OF_ID: 2318855188;
  classType: "constructor";
  className: "InputMessagesFilterPinned";
  static fromReader(reader: Reader): InputMessagesFilterPinned;
}
  export class UpdateNewMessage extends VirtualClass<{
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 522914557;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewMessage";
  static fromReader(reader: Reader): UpdateNewMessage;
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateMessageID extends VirtualClass<{
    id: int;
    randomId?: long;
  }> {
  CONSTRUCTOR_ID: 1318109142;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMessageID";
  static fromReader(reader: Reader): UpdateMessageID;
    id: int;
    randomId?: long;
  }
  export class UpdateDeleteMessages extends VirtualClass<{
    messages: int[];
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 2718806245;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDeleteMessages";
  static fromReader(reader: Reader): UpdateDeleteMessages;
    messages: int[];
    pts: int;
    ptsCount: int;
  }
  export class UpdateUserTyping extends VirtualClass<{
    userId: long;
    action: Api.TypeSendMessageAction;
  }> {
  CONSTRUCTOR_ID: 3223225727;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUserTyping";
  static fromReader(reader: Reader): UpdateUserTyping;
    userId: long;
    action: Api.TypeSendMessageAction;
  }
  export class UpdateChatUserTyping extends VirtualClass<{
    chatId: long;
    fromId: Api.TypePeer;
    action: Api.TypeSendMessageAction;
  }> {
  CONSTRUCTOR_ID: 2202565360;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatUserTyping";
  static fromReader(reader: Reader): UpdateChatUserTyping;
    chatId: long;
    fromId: Api.TypePeer;
    action: Api.TypeSendMessageAction;
  }
  export class UpdateChatParticipants extends VirtualClass<{
    participants: Api.TypeChatParticipants;
  }> {
  CONSTRUCTOR_ID: 125178264;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatParticipants";
  static fromReader(reader: Reader): UpdateChatParticipants;
    participants: Api.TypeChatParticipants;
  }
  export class UpdateUserStatus extends VirtualClass<{
    userId: long;
    status: Api.TypeUserStatus;
  }> {
  CONSTRUCTOR_ID: 3854432478;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUserStatus";
  static fromReader(reader: Reader): UpdateUserStatus;
    userId: long;
    status: Api.TypeUserStatus;
  }
  export class UpdateUserName extends VirtualClass<{
    userId: long;
    firstName: string;
    lastName: string;
    usernames: Api.TypeUsername[];
  }> {
  CONSTRUCTOR_ID: 2810480932;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUserName";
  static fromReader(reader: Reader): UpdateUserName;
    userId: long;
    firstName: string;
    lastName: string;
    usernames: Api.TypeUsername[];
  }
  export class UpdateNewAuthorization extends VirtualClass<{
    // flags: null;
    unconfirmed?: boolean;
    hash: long;
    date?: int;
    device?: string;
    location?: string;
  }> {
  CONSTRUCTOR_ID: 2303831023;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewAuthorization";
  static fromReader(reader: Reader): UpdateNewAuthorization;
    // flags: null;
    unconfirmed?: boolean;
    hash: long;
    date?: int;
    device?: string;
    location?: string;
  }
  export class UpdateNewEncryptedMessage extends VirtualClass<{
    message: Api.TypeEncryptedMessage;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 314359194;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewEncryptedMessage";
  static fromReader(reader: Reader): UpdateNewEncryptedMessage;
    message: Api.TypeEncryptedMessage;
    qts: int;
  }
  export class UpdateEncryptedChatTyping extends VirtualClass<{
    chatId: int;
  }> {
  CONSTRUCTOR_ID: 386986326;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateEncryptedChatTyping";
  static fromReader(reader: Reader): UpdateEncryptedChatTyping;
    chatId: int;
  }
  export class UpdateEncryption extends VirtualClass<{
    chat: Api.TypeEncryptedChat;
    date: int;
  }> {
  CONSTRUCTOR_ID: 3030575245;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateEncryption";
  static fromReader(reader: Reader): UpdateEncryption;
    chat: Api.TypeEncryptedChat;
    date: int;
  }
  export class UpdateEncryptedMessagesRead extends VirtualClass<{
    chatId: int;
    maxDate: int;
    date: int;
  }> {
  CONSTRUCTOR_ID: 956179895;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateEncryptedMessagesRead";
  static fromReader(reader: Reader): UpdateEncryptedMessagesRead;
    chatId: int;
    maxDate: int;
    date: int;
  }
  export class UpdateChatParticipantAdd extends VirtualClass<{
    chatId: long;
    userId: long;
    inviterId: long;
    date: int;
    version: int;
  }> {
  CONSTRUCTOR_ID: 1037718609;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatParticipantAdd";
  static fromReader(reader: Reader): UpdateChatParticipantAdd;
    chatId: long;
    userId: long;
    inviterId: long;
    date: int;
    version: int;
  }
  export class UpdateChatParticipantDelete extends VirtualClass<{
    chatId: long;
    userId: long;
    version: int;
  }> {
  CONSTRUCTOR_ID: 3811523959;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatParticipantDelete";
  static fromReader(reader: Reader): UpdateChatParticipantDelete;
    chatId: long;
    userId: long;
    version: int;
  }
  export class UpdateDcOptions extends VirtualClass<{
    dcOptions: Api.TypeDcOption[];
  }> {
  CONSTRUCTOR_ID: 2388564083;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDcOptions";
  static fromReader(reader: Reader): UpdateDcOptions;
    dcOptions: Api.TypeDcOption[];
  }
  export class UpdateNotifySettings extends VirtualClass<{
    peer: Api.TypeNotifyPeer;
    notifySettings: Api.TypePeerNotifySettings;
  }> {
  CONSTRUCTOR_ID: 3200411887;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNotifySettings";
  static fromReader(reader: Reader): UpdateNotifySettings;
    peer: Api.TypeNotifyPeer;
    notifySettings: Api.TypePeerNotifySettings;
  }
  export class UpdateServiceNotification extends VirtualClass<{
    // flags: null;
    popup?: boolean;
    invertMedia?: boolean;
    inboxDate?: int;
    type: string;
    message: string;
    media: Api.TypeMessageMedia;
    entities: Api.TypeMessageEntity[];
  }> {
  CONSTRUCTOR_ID: 3957614617;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateServiceNotification";
  static fromReader(reader: Reader): UpdateServiceNotification;
    // flags: null;
    popup?: boolean;
    invertMedia?: boolean;
    inboxDate?: int;
    type: string;
    message: string;
    media: Api.TypeMessageMedia;
    entities: Api.TypeMessageEntity[];
  }
  export class UpdatePrivacy extends VirtualClass<{
    key: Api.TypePrivacyKey;
    rules: Api.TypePrivacyRule[];
  }> {
  CONSTRUCTOR_ID: 3996854058;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePrivacy";
  static fromReader(reader: Reader): UpdatePrivacy;
    key: Api.TypePrivacyKey;
    rules: Api.TypePrivacyRule[];
  }
  export class UpdateUserPhone extends VirtualClass<{
    userId: long;
    phone: string;
  }> {
  CONSTRUCTOR_ID: 88680979;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUserPhone";
  static fromReader(reader: Reader): UpdateUserPhone;
    userId: long;
    phone: string;
  }
  export class UpdateReadHistoryInbox extends VirtualClass<{
    // flags: null;
    folderId?: int;
    peer: Api.TypePeer;
    maxId: int;
    stillUnreadCount: int;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 2627162079;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadHistoryInbox";
  static fromReader(reader: Reader): UpdateReadHistoryInbox;
    // flags: null;
    folderId?: int;
    peer: Api.TypePeer;
    maxId: int;
    stillUnreadCount: int;
    pts: int;
    ptsCount: int;
  }
  export class UpdateReadHistoryOutbox extends VirtualClass<{
    peer: Api.TypePeer;
    maxId: int;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 791617983;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadHistoryOutbox";
  static fromReader(reader: Reader): UpdateReadHistoryOutbox;
    peer: Api.TypePeer;
    maxId: int;
    pts: int;
    ptsCount: int;
  }
  export class UpdateWebPage extends VirtualClass<{
    webpage: Api.TypeWebPage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 2139689491;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateWebPage";
  static fromReader(reader: Reader): UpdateWebPage;
    webpage: Api.TypeWebPage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateReadMessagesContents extends VirtualClass<{
    // flags: null;
    messages: int[];
    pts: int;
    ptsCount: int;
    date?: int;
  }> {
  CONSTRUCTOR_ID: 4163006849;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadMessagesContents";
  static fromReader(reader: Reader): UpdateReadMessagesContents;
    // flags: null;
    messages: int[];
    pts: int;
    ptsCount: int;
    date?: int;
  }
  export class UpdateChannelTooLong extends VirtualClass<{
    // flags: null;
    channelId: long;
    pts?: int;
  }> {
  CONSTRUCTOR_ID: 277713951;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelTooLong";
  static fromReader(reader: Reader): UpdateChannelTooLong;
    // flags: null;
    channelId: long;
    pts?: int;
  }
  export class UpdateChannel extends VirtualClass<{
    channelId: long;
  }> {
  CONSTRUCTOR_ID: 1666927625;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannel";
  static fromReader(reader: Reader): UpdateChannel;
    channelId: long;
  }
  export class UpdateNewChannelMessage extends VirtualClass<{
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 1656358105;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewChannelMessage";
  static fromReader(reader: Reader): UpdateNewChannelMessage;
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateReadChannelInbox extends VirtualClass<{
    // flags: null;
    folderId?: int;
    channelId: long;
    maxId: int;
    stillUnreadCount: int;
    pts: int;
  }> {
  CONSTRUCTOR_ID: 2452516368;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadChannelInbox";
  static fromReader(reader: Reader): UpdateReadChannelInbox;
    // flags: null;
    folderId?: int;
    channelId: long;
    maxId: int;
    stillUnreadCount: int;
    pts: int;
  }
  export class UpdateDeleteChannelMessages extends VirtualClass<{
    channelId: long;
    messages: int[];
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 3274529554;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDeleteChannelMessages";
  static fromReader(reader: Reader): UpdateDeleteChannelMessages;
    channelId: long;
    messages: int[];
    pts: int;
    ptsCount: int;
  }
  export class UpdateChannelMessageViews extends VirtualClass<{
    channelId: long;
    id: int;
    views: int;
  }> {
  CONSTRUCTOR_ID: 4062620680;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelMessageViews";
  static fromReader(reader: Reader): UpdateChannelMessageViews;
    channelId: long;
    id: int;
    views: int;
  }
  export class UpdateChatParticipantAdmin extends VirtualClass<{
    chatId: long;
    userId: long;
    isAdmin: Bool;
    version: int;
  }> {
  CONSTRUCTOR_ID: 3620364706;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatParticipantAdmin";
  static fromReader(reader: Reader): UpdateChatParticipantAdmin;
    chatId: long;
    userId: long;
    isAdmin: Bool;
    version: int;
  }
  export class UpdateNewStickerSet extends VirtualClass<{
    stickerset: messages.TypeStickerSet;
  }> {
  CONSTRUCTOR_ID: 1753886890;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewStickerSet";
  static fromReader(reader: Reader): UpdateNewStickerSet;
    stickerset: messages.TypeStickerSet;
  }
  export class UpdateStickerSetsOrder extends VirtualClass<{
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
    order: long[];
  }> {
  CONSTRUCTOR_ID: 196268545;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStickerSetsOrder";
  static fromReader(reader: Reader): UpdateStickerSetsOrder;
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
    order: long[];
  }
  export class UpdateStickerSets extends VirtualClass<{
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
  }> {
  CONSTRUCTOR_ID: 834816008;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStickerSets";
  static fromReader(reader: Reader): UpdateStickerSets;
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
  }
  export class UpdateSavedGifs extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2473931806;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSavedGifs";
  static fromReader(reader: Reader): UpdateSavedGifs;
}
  export class UpdateBotInlineQuery extends VirtualClass<{
    // flags: null;
    queryId: long;
    userId: long;
    query: string;
    geo?: Api.TypeGeoPoint;
    peerType?: Api.TypeInlineQueryPeerType;
    offset: string;
  }> {
  CONSTRUCTOR_ID: 1232025500;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotInlineQuery";
  static fromReader(reader: Reader): UpdateBotInlineQuery;
    // flags: null;
    queryId: long;
    userId: long;
    query: string;
    geo?: Api.TypeGeoPoint;
    peerType?: Api.TypeInlineQueryPeerType;
    offset: string;
  }
  export class UpdateBotInlineSend extends VirtualClass<{
    // flags: null;
    userId: long;
    query: string;
    geo?: Api.TypeGeoPoint;
    id: string;
    msgId?: Api.TypeInputBotInlineMessageID;
  }> {
  CONSTRUCTOR_ID: 317794823;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotInlineSend";
  static fromReader(reader: Reader): UpdateBotInlineSend;
    // flags: null;
    userId: long;
    query: string;
    geo?: Api.TypeGeoPoint;
    id: string;
    msgId?: Api.TypeInputBotInlineMessageID;
  }
  export class UpdateEditChannelMessage extends VirtualClass<{
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 457133559;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateEditChannelMessage";
  static fromReader(reader: Reader): UpdateEditChannelMessage;
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateBotCallbackQuery extends VirtualClass<{
    // flags: null;
    queryId: long;
    userId: long;
    peer: Api.TypePeer;
    msgId: int;
    chatInstance: long;
    data?: bytes;
    gameShortName?: string;
  }> {
  CONSTRUCTOR_ID: 3117401229;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotCallbackQuery";
  static fromReader(reader: Reader): UpdateBotCallbackQuery;
    // flags: null;
    queryId: long;
    userId: long;
    peer: Api.TypePeer;
    msgId: int;
    chatInstance: long;
    data?: bytes;
    gameShortName?: string;
  }
  export class UpdateEditMessage extends VirtualClass<{
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 3825430691;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateEditMessage";
  static fromReader(reader: Reader): UpdateEditMessage;
    message: Api.TypeMessage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateInlineBotCallbackQuery extends VirtualClass<{
    // flags: null;
    queryId: long;
    userId: long;
    msgId: Api.TypeInputBotInlineMessageID;
    chatInstance: long;
    data?: bytes;
    gameShortName?: string;
  }> {
  CONSTRUCTOR_ID: 1763610706;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateInlineBotCallbackQuery";
  static fromReader(reader: Reader): UpdateInlineBotCallbackQuery;
    // flags: null;
    queryId: long;
    userId: long;
    msgId: Api.TypeInputBotInlineMessageID;
    chatInstance: long;
    data?: bytes;
    gameShortName?: string;
  }
  export class UpdateReadChannelOutbox extends VirtualClass<{
    channelId: long;
    maxId: int;
  }> {
  CONSTRUCTOR_ID: 3076495785;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadChannelOutbox";
  static fromReader(reader: Reader): UpdateReadChannelOutbox;
    channelId: long;
    maxId: int;
  }
  export class UpdateDraftMessage extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    topMsgId?: int;
    draft: Api.TypeDraftMessage;
  }> {
  CONSTRUCTOR_ID: 457829485;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDraftMessage";
  static fromReader(reader: Reader): UpdateDraftMessage;
    // flags: null;
    peer: Api.TypePeer;
    topMsgId?: int;
    draft: Api.TypeDraftMessage;
  }
  export class UpdateReadFeaturedStickers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1461528386;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadFeaturedStickers";
  static fromReader(reader: Reader): UpdateReadFeaturedStickers;
}
  export class UpdateRecentStickers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2588027936;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateRecentStickers";
  static fromReader(reader: Reader): UpdateRecentStickers;
}
  export class UpdateConfig extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2720652550;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateConfig";
  static fromReader(reader: Reader): UpdateConfig;
}
  export class UpdatePtsChanged extends VirtualClass<void> {
  CONSTRUCTOR_ID: 861169551;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePtsChanged";
  static fromReader(reader: Reader): UpdatePtsChanged;
}
  export class UpdateChannelWebPage extends VirtualClass<{
    channelId: long;
    webpage: Api.TypeWebPage;
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 791390623;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelWebPage";
  static fromReader(reader: Reader): UpdateChannelWebPage;
    channelId: long;
    webpage: Api.TypeWebPage;
    pts: int;
    ptsCount: int;
  }
  export class UpdateDialogPinned extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    folderId?: int;
    peer: Api.TypeDialogPeer;
  }> {
  CONSTRUCTOR_ID: 1852826908;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDialogPinned";
  static fromReader(reader: Reader): UpdateDialogPinned;
    // flags: null;
    pinned?: boolean;
    folderId?: int;
    peer: Api.TypeDialogPeer;
  }
  export class UpdatePinnedDialogs extends VirtualClass<{
    // flags: null;
    folderId?: int;
    order?: Api.TypeDialogPeer[];
  }> {
  CONSTRUCTOR_ID: 4195302562;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePinnedDialogs";
  static fromReader(reader: Reader): UpdatePinnedDialogs;
    // flags: null;
    folderId?: int;
    order?: Api.TypeDialogPeer[];
  }
  export class UpdateBotWebhookJSON extends VirtualClass<{
    data: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 2199371971;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotWebhookJSON";
  static fromReader(reader: Reader): UpdateBotWebhookJSON;
    data: Api.TypeDataJSON;
  }
  export class UpdateBotWebhookJSONQuery extends VirtualClass<{
    queryId: long;
    data: Api.TypeDataJSON;
    timeout: int;
  }> {
  CONSTRUCTOR_ID: 2610053286;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotWebhookJSONQuery";
  static fromReader(reader: Reader): UpdateBotWebhookJSONQuery;
    queryId: long;
    data: Api.TypeDataJSON;
    timeout: int;
  }
  export class UpdateBotShippingQuery extends VirtualClass<{
    queryId: long;
    userId: long;
    payload: bytes;
    shippingAddress: Api.TypePostAddress;
  }> {
  CONSTRUCTOR_ID: 3048144253;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotShippingQuery";
  static fromReader(reader: Reader): UpdateBotShippingQuery;
    queryId: long;
    userId: long;
    payload: bytes;
    shippingAddress: Api.TypePostAddress;
  }
  export class UpdateBotPrecheckoutQuery extends VirtualClass<{
    // flags: null;
    queryId: long;
    userId: long;
    payload: bytes;
    info?: Api.TypePaymentRequestedInfo;
    shippingOptionId?: string;
    currency: string;
    totalAmount: long;
  }> {
  CONSTRUCTOR_ID: 2359990934;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotPrecheckoutQuery";
  static fromReader(reader: Reader): UpdateBotPrecheckoutQuery;
    // flags: null;
    queryId: long;
    userId: long;
    payload: bytes;
    info?: Api.TypePaymentRequestedInfo;
    shippingOptionId?: string;
    currency: string;
    totalAmount: long;
  }
  export class UpdatePhoneCall extends VirtualClass<{
    phoneCall: Api.TypePhoneCall;
  }> {
  CONSTRUCTOR_ID: 2869914398;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePhoneCall";
  static fromReader(reader: Reader): UpdatePhoneCall;
    phoneCall: Api.TypePhoneCall;
  }
  export class UpdateLangPackTooLong extends VirtualClass<{
    langCode: string;
  }> {
  CONSTRUCTOR_ID: 1180041828;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateLangPackTooLong";
  static fromReader(reader: Reader): UpdateLangPackTooLong;
    langCode: string;
  }
  export class UpdateLangPack extends VirtualClass<{
    difference: Api.TypeLangPackDifference;
  }> {
  CONSTRUCTOR_ID: 1442983757;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateLangPack";
  static fromReader(reader: Reader): UpdateLangPack;
    difference: Api.TypeLangPackDifference;
  }
  export class UpdateFavedStickers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3843135853;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateFavedStickers";
  static fromReader(reader: Reader): UpdateFavedStickers;
}
  export class UpdateChannelReadMessagesContents extends VirtualClass<{
    // flags: null;
    channelId: long;
    topMsgId?: int;
    messages: int[];
  }> {
  CONSTRUCTOR_ID: 3928556893;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelReadMessagesContents";
  static fromReader(reader: Reader): UpdateChannelReadMessagesContents;
    // flags: null;
    channelId: long;
    topMsgId?: int;
    messages: int[];
  }
  export class UpdateContactsReset extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1887741886;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateContactsReset";
  static fromReader(reader: Reader): UpdateContactsReset;
}
  export class UpdateChannelAvailableMessages extends VirtualClass<{
    channelId: long;
    availableMinId: int;
  }> {
  CONSTRUCTOR_ID: 2990524056;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelAvailableMessages";
  static fromReader(reader: Reader): UpdateChannelAvailableMessages;
    channelId: long;
    availableMinId: int;
  }
  export class UpdateDialogUnreadMark extends VirtualClass<{
    // flags: null;
    unread?: boolean;
    peer: Api.TypeDialogPeer;
  }> {
  CONSTRUCTOR_ID: 3781450179;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDialogUnreadMark";
  static fromReader(reader: Reader): UpdateDialogUnreadMark;
    // flags: null;
    unread?: boolean;
    peer: Api.TypeDialogPeer;
  }
  export class UpdateMessagePoll extends VirtualClass<{
    // flags: null;
    pollId: long;
    poll?: Api.TypePoll;
    results: Api.TypePollResults;
  }> {
  CONSTRUCTOR_ID: 2896258427;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMessagePoll";
  static fromReader(reader: Reader): UpdateMessagePoll;
    // flags: null;
    pollId: long;
    poll?: Api.TypePoll;
    results: Api.TypePollResults;
  }
  export class UpdateChatDefaultBannedRights extends VirtualClass<{
    peer: Api.TypePeer;
    defaultBannedRights: Api.TypeChatBannedRights;
    version: int;
  }> {
  CONSTRUCTOR_ID: 1421875280;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatDefaultBannedRights";
  static fromReader(reader: Reader): UpdateChatDefaultBannedRights;
    peer: Api.TypePeer;
    defaultBannedRights: Api.TypeChatBannedRights;
    version: int;
  }
  export class UpdateFolderPeers extends VirtualClass<{
    folderPeers: Api.TypeFolderPeer[];
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 422972864;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateFolderPeers";
  static fromReader(reader: Reader): UpdateFolderPeers;
    folderPeers: Api.TypeFolderPeer[];
    pts: int;
    ptsCount: int;
  }
  export class UpdatePeerSettings extends VirtualClass<{
    peer: Api.TypePeer;
    settings: Api.TypePeerSettings;
  }> {
  CONSTRUCTOR_ID: 1786671974;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePeerSettings";
  static fromReader(reader: Reader): UpdatePeerSettings;
    peer: Api.TypePeer;
    settings: Api.TypePeerSettings;
  }
  export class UpdatePeerLocated extends VirtualClass<{
    peers: Api.TypePeerLocated[];
  }> {
  CONSTRUCTOR_ID: 3031420848;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePeerLocated";
  static fromReader(reader: Reader): UpdatePeerLocated;
    peers: Api.TypePeerLocated[];
  }
  export class UpdateNewScheduledMessage extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 967122427;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewScheduledMessage";
  static fromReader(reader: Reader): UpdateNewScheduledMessage;
    message: Api.TypeMessage;
  }
  export class UpdateDeleteScheduledMessages extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    messages: int[];
    sentMessages?: int[];
  }> {
  CONSTRUCTOR_ID: 4071037315;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDeleteScheduledMessages";
  static fromReader(reader: Reader): UpdateDeleteScheduledMessages;
    // flags: null;
    peer: Api.TypePeer;
    messages: int[];
    sentMessages?: int[];
  }
  export class UpdateTheme extends VirtualClass<{
    theme: Api.TypeTheme;
  }> {
  CONSTRUCTOR_ID: 2182544291;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateTheme";
  static fromReader(reader: Reader): UpdateTheme;
    theme: Api.TypeTheme;
  }
  export class UpdateGeoLiveViewed extends VirtualClass<{
    peer: Api.TypePeer;
    msgId: int;
  }> {
  CONSTRUCTOR_ID: 2267003193;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateGeoLiveViewed";
  static fromReader(reader: Reader): UpdateGeoLiveViewed;
    peer: Api.TypePeer;
    msgId: int;
  }
  export class UpdateLoginToken extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1448076945;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateLoginToken";
  static fromReader(reader: Reader): UpdateLoginToken;
}
  export class UpdateMessagePollVote extends VirtualClass<{
    pollId: long;
    peer: Api.TypePeer;
    options: bytes[];
    qts: int;
  }> {
  CONSTRUCTOR_ID: 619974263;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMessagePollVote";
  static fromReader(reader: Reader): UpdateMessagePollVote;
    pollId: long;
    peer: Api.TypePeer;
    options: bytes[];
    qts: int;
  }
  export class UpdateDialogFilter extends VirtualClass<{
    // flags: null;
    id: int;
    filter?: Api.TypeDialogFilter;
  }> {
  CONSTRUCTOR_ID: 654302845;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDialogFilter";
  static fromReader(reader: Reader): UpdateDialogFilter;
    // flags: null;
    id: int;
    filter?: Api.TypeDialogFilter;
  }
  export class UpdateDialogFilterOrder extends VirtualClass<{
    order: int[];
  }> {
  CONSTRUCTOR_ID: 2782339333;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDialogFilterOrder";
  static fromReader(reader: Reader): UpdateDialogFilterOrder;
    order: int[];
  }
  export class UpdateDialogFilters extends VirtualClass<void> {
  CONSTRUCTOR_ID: 889491791;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDialogFilters";
  static fromReader(reader: Reader): UpdateDialogFilters;
}
  export class UpdatePhoneCallSignalingData extends VirtualClass<{
    phoneCallId: long;
    data: bytes;
  }> {
  CONSTRUCTOR_ID: 643940105;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePhoneCallSignalingData";
  static fromReader(reader: Reader): UpdatePhoneCallSignalingData;
    phoneCallId: long;
    data: bytes;
  }
  export class UpdateChannelMessageForwards extends VirtualClass<{
    channelId: long;
    id: int;
    forwards: int;
  }> {
  CONSTRUCTOR_ID: 3533318132;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelMessageForwards";
  static fromReader(reader: Reader): UpdateChannelMessageForwards;
    channelId: long;
    id: int;
    forwards: int;
  }
  export class UpdateReadChannelDiscussionInbox extends VirtualClass<{
    // flags: null;
    channelId: long;
    topMsgId: int;
    readMaxId: int;
    broadcastId?: long;
    broadcastPost?: int;
  }> {
  CONSTRUCTOR_ID: 3601962310;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadChannelDiscussionInbox";
  static fromReader(reader: Reader): UpdateReadChannelDiscussionInbox;
    // flags: null;
    channelId: long;
    topMsgId: int;
    readMaxId: int;
    broadcastId?: long;
    broadcastPost?: int;
  }
  export class UpdateReadChannelDiscussionOutbox extends VirtualClass<{
    channelId: long;
    topMsgId: int;
    readMaxId: int;
  }> {
  CONSTRUCTOR_ID: 1767677564;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadChannelDiscussionOutbox";
  static fromReader(reader: Reader): UpdateReadChannelDiscussionOutbox;
    channelId: long;
    topMsgId: int;
    readMaxId: int;
  }
  export class UpdatePeerBlocked extends VirtualClass<{
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    peerId: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 3957356370;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePeerBlocked";
  static fromReader(reader: Reader): UpdatePeerBlocked;
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    peerId: Api.TypePeer;
  }
  export class UpdateChannelUserTyping extends VirtualClass<{
    // flags: null;
    channelId: long;
    topMsgId?: int;
    fromId: Api.TypePeer;
    action: Api.TypeSendMessageAction;
  }> {
  CONSTRUCTOR_ID: 2357774627;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelUserTyping";
  static fromReader(reader: Reader): UpdateChannelUserTyping;
    // flags: null;
    channelId: long;
    topMsgId?: int;
    fromId: Api.TypePeer;
    action: Api.TypeSendMessageAction;
  }
  export class UpdatePinnedMessages extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    peer: Api.TypePeer;
    messages: int[];
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 3984976565;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePinnedMessages";
  static fromReader(reader: Reader): UpdatePinnedMessages;
    // flags: null;
    pinned?: boolean;
    peer: Api.TypePeer;
    messages: int[];
    pts: int;
    ptsCount: int;
  }
  export class UpdatePinnedChannelMessages extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    channelId: long;
    messages: int[];
    pts: int;
    ptsCount: int;
  }> {
  CONSTRUCTOR_ID: 1538885128;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePinnedChannelMessages";
  static fromReader(reader: Reader): UpdatePinnedChannelMessages;
    // flags: null;
    pinned?: boolean;
    channelId: long;
    messages: int[];
    pts: int;
    ptsCount: int;
  }
  export class UpdateChat extends VirtualClass<{
    chatId: long;
  }> {
  CONSTRUCTOR_ID: 4170869326;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChat";
  static fromReader(reader: Reader): UpdateChat;
    chatId: long;
  }
  export class UpdateGroupCallParticipants extends VirtualClass<{
    call: Api.TypeInputGroupCall;
    participants: Api.TypeGroupCallParticipant[];
    version: int;
  }> {
  CONSTRUCTOR_ID: 4075543374;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateGroupCallParticipants";
  static fromReader(reader: Reader): UpdateGroupCallParticipants;
    call: Api.TypeInputGroupCall;
    participants: Api.TypeGroupCallParticipant[];
    version: int;
  }
  export class UpdateGroupCall extends VirtualClass<{
    // flags: null;
    chatId?: long;
    call: Api.TypeGroupCall;
  }> {
  CONSTRUCTOR_ID: 2547401537;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateGroupCall";
  static fromReader(reader: Reader): UpdateGroupCall;
    // flags: null;
    chatId?: long;
    call: Api.TypeGroupCall;
  }
  export class UpdatePeerHistoryTTL extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    ttlPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 3147544997;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePeerHistoryTTL";
  static fromReader(reader: Reader): UpdatePeerHistoryTTL;
    // flags: null;
    peer: Api.TypePeer;
    ttlPeriod?: int;
  }
  export class UpdateChatParticipant extends VirtualClass<{
    // flags: null;
    chatId: long;
    date: int;
    actorId: long;
    userId: long;
    prevParticipant?: Api.TypeChatParticipant;
    newParticipant?: Api.TypeChatParticipant;
    invite?: Api.TypeExportedChatInvite;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 3498534458;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChatParticipant";
  static fromReader(reader: Reader): UpdateChatParticipant;
    // flags: null;
    chatId: long;
    date: int;
    actorId: long;
    userId: long;
    prevParticipant?: Api.TypeChatParticipant;
    newParticipant?: Api.TypeChatParticipant;
    invite?: Api.TypeExportedChatInvite;
    qts: int;
  }
  export class UpdateChannelParticipant extends VirtualClass<{
    // flags: null;
    viaChatlist?: boolean;
    channelId: long;
    date: int;
    actorId: long;
    userId: long;
    prevParticipant?: Api.TypeChannelParticipant;
    newParticipant?: Api.TypeChannelParticipant;
    invite?: Api.TypeExportedChatInvite;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2556246715;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelParticipant";
  static fromReader(reader: Reader): UpdateChannelParticipant;
    // flags: null;
    viaChatlist?: boolean;
    channelId: long;
    date: int;
    actorId: long;
    userId: long;
    prevParticipant?: Api.TypeChannelParticipant;
    newParticipant?: Api.TypeChannelParticipant;
    invite?: Api.TypeExportedChatInvite;
    qts: int;
  }
  export class UpdateBotStopped extends VirtualClass<{
    userId: long;
    date: int;
    stopped: Bool;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 3297184329;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotStopped";
  static fromReader(reader: Reader): UpdateBotStopped;
    userId: long;
    date: int;
    stopped: Bool;
    qts: int;
  }
  export class UpdateGroupCallConnection extends VirtualClass<{
    // flags: null;
    presentation?: boolean;
    params: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 192428418;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateGroupCallConnection";
  static fromReader(reader: Reader): UpdateGroupCallConnection;
    // flags: null;
    presentation?: boolean;
    params: Api.TypeDataJSON;
  }
  export class UpdateBotCommands extends VirtualClass<{
    peer: Api.TypePeer;
    botId: long;
    commands: Api.TypeBotCommand[];
  }> {
  CONSTRUCTOR_ID: 1299263278;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotCommands";
  static fromReader(reader: Reader): UpdateBotCommands;
    peer: Api.TypePeer;
    botId: long;
    commands: Api.TypeBotCommand[];
  }
  export class UpdatePendingJoinRequests extends VirtualClass<{
    peer: Api.TypePeer;
    requestsPending: int;
    recentRequesters: long[];
  }> {
  CONSTRUCTOR_ID: 1885586395;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePendingJoinRequests";
  static fromReader(reader: Reader): UpdatePendingJoinRequests;
    peer: Api.TypePeer;
    requestsPending: int;
    recentRequesters: long[];
  }
  export class UpdateBotChatInviteRequester extends VirtualClass<{
    peer: Api.TypePeer;
    date: int;
    userId: long;
    about: string;
    invite: Api.TypeExportedChatInvite;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 299870598;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotChatInviteRequester";
  static fromReader(reader: Reader): UpdateBotChatInviteRequester;
    peer: Api.TypePeer;
    date: int;
    userId: long;
    about: string;
    invite: Api.TypeExportedChatInvite;
    qts: int;
  }
  export class UpdateMessageReactions extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    msgId: int;
    topMsgId?: int;
    reactions: Api.TypeMessageReactions;
  }> {
  CONSTRUCTOR_ID: 1578843320;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMessageReactions";
  static fromReader(reader: Reader): UpdateMessageReactions;
    // flags: null;
    peer: Api.TypePeer;
    msgId: int;
    topMsgId?: int;
    reactions: Api.TypeMessageReactions;
  }
  export class UpdateAttachMenuBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 397910539;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateAttachMenuBots";
  static fromReader(reader: Reader): UpdateAttachMenuBots;
}
  export class UpdateWebViewResultSent extends VirtualClass<{
    queryId: long;
  }> {
  CONSTRUCTOR_ID: 361936797;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateWebViewResultSent";
  static fromReader(reader: Reader): UpdateWebViewResultSent;
    queryId: long;
  }
  export class UpdateBotMenuButton extends VirtualClass<{
    botId: long;
    button: Api.TypeBotMenuButton;
  }> {
  CONSTRUCTOR_ID: 347625491;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotMenuButton";
  static fromReader(reader: Reader): UpdateBotMenuButton;
    botId: long;
    button: Api.TypeBotMenuButton;
  }
  export class UpdateSavedRingtones extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1960361625;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSavedRingtones";
  static fromReader(reader: Reader): UpdateSavedRingtones;
}
  export class UpdateTranscribedAudio extends VirtualClass<{
    // flags: null;
    pending?: boolean;
    peer: Api.TypePeer;
    msgId: int;
    transcriptionId: long;
    text: string;
  }> {
  CONSTRUCTOR_ID: 8703322;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateTranscribedAudio";
  static fromReader(reader: Reader): UpdateTranscribedAudio;
    // flags: null;
    pending?: boolean;
    peer: Api.TypePeer;
    msgId: int;
    transcriptionId: long;
    text: string;
  }
  export class UpdateReadFeaturedEmojiStickers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4216080748;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadFeaturedEmojiStickers";
  static fromReader(reader: Reader): UpdateReadFeaturedEmojiStickers;
}
  export class UpdateUserEmojiStatus extends VirtualClass<{
    userId: long;
    emojiStatus: Api.TypeEmojiStatus;
  }> {
  CONSTRUCTOR_ID: 674706841;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUserEmojiStatus";
  static fromReader(reader: Reader): UpdateUserEmojiStatus;
    userId: long;
    emojiStatus: Api.TypeEmojiStatus;
  }
  export class UpdateRecentEmojiStatuses extends VirtualClass<void> {
  CONSTRUCTOR_ID: 821314523;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateRecentEmojiStatuses";
  static fromReader(reader: Reader): UpdateRecentEmojiStatuses;
}
  export class UpdateRecentReactions extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1870160884;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateRecentReactions";
  static fromReader(reader: Reader): UpdateRecentReactions;
}
  export class UpdateMoveStickerSetToTop extends VirtualClass<{
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
    stickerset: long;
  }> {
  CONSTRUCTOR_ID: 2264715141;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMoveStickerSetToTop";
  static fromReader(reader: Reader): UpdateMoveStickerSetToTop;
    // flags: null;
    masks?: boolean;
    emojis?: boolean;
    stickerset: long;
  }
  export class UpdateMessageExtendedMedia extends VirtualClass<{
    peer: Api.TypePeer;
    msgId: int;
    extendedMedia: Api.TypeMessageExtendedMedia[];
  }> {
  CONSTRUCTOR_ID: 3584300836;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateMessageExtendedMedia";
  static fromReader(reader: Reader): UpdateMessageExtendedMedia;
    peer: Api.TypePeer;
    msgId: int;
    extendedMedia: Api.TypeMessageExtendedMedia[];
  }
  export class UpdateChannelPinnedTopic extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    channelId: long;
    topicId: int;
  }> {
  CONSTRUCTOR_ID: 422509539;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelPinnedTopic";
  static fromReader(reader: Reader): UpdateChannelPinnedTopic;
    // flags: null;
    pinned?: boolean;
    channelId: long;
    topicId: int;
  }
  export class UpdateChannelPinnedTopics extends VirtualClass<{
    // flags: null;
    channelId: long;
    order?: int[];
  }> {
  CONSTRUCTOR_ID: 4263085570;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelPinnedTopics";
  static fromReader(reader: Reader): UpdateChannelPinnedTopics;
    // flags: null;
    channelId: long;
    order?: int[];
  }
  export class UpdateUser extends VirtualClass<{
    userId: long;
  }> {
  CONSTRUCTOR_ID: 542282808;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateUser";
  static fromReader(reader: Reader): UpdateUser;
    userId: long;
  }
  export class UpdateAutoSaveSettings extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3959795863;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateAutoSaveSettings";
  static fromReader(reader: Reader): UpdateAutoSaveSettings;
}
  export class UpdateStory extends VirtualClass<{
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 1974712216;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStory";
  static fromReader(reader: Reader): UpdateStory;
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }
  export class UpdateReadStories extends VirtualClass<{
    peer: Api.TypePeer;
    maxId: int;
  }> {
  CONSTRUCTOR_ID: 4149121835;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateReadStories";
  static fromReader(reader: Reader): UpdateReadStories;
    peer: Api.TypePeer;
    maxId: int;
  }
  export class UpdateStoryID extends VirtualClass<{
    id: int;
    randomId?: long;
  }> {
  CONSTRUCTOR_ID: 468923833;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStoryID";
  static fromReader(reader: Reader): UpdateStoryID;
    id: int;
    randomId?: long;
  }
  export class UpdateStoriesStealthMode extends VirtualClass<{
    stealthMode: Api.TypeStoriesStealthMode;
  }> {
  CONSTRUCTOR_ID: 738741697;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStoriesStealthMode";
  static fromReader(reader: Reader): UpdateStoriesStealthMode;
    stealthMode: Api.TypeStoriesStealthMode;
  }
  export class UpdateSentStoryReaction extends VirtualClass<{
    peer: Api.TypePeer;
    storyId: int;
    reaction: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 2103604867;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSentStoryReaction";
  static fromReader(reader: Reader): UpdateSentStoryReaction;
    peer: Api.TypePeer;
    storyId: int;
    reaction: Api.TypeReaction;
  }
  export class UpdateBotChatBoost extends VirtualClass<{
    peer: Api.TypePeer;
    boost: Api.TypeBoost;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2421019804;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotChatBoost";
  static fromReader(reader: Reader): UpdateBotChatBoost;
    peer: Api.TypePeer;
    boost: Api.TypeBoost;
    qts: int;
  }
  export class UpdateChannelViewForumAsMessages extends VirtualClass<{
    channelId: long;
    enabled: Bool;
  }> {
  CONSTRUCTOR_ID: 129403168;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateChannelViewForumAsMessages";
  static fromReader(reader: Reader): UpdateChannelViewForumAsMessages;
    channelId: long;
    enabled: Bool;
  }
  export class UpdatePeerWallpaper extends VirtualClass<{
    // flags: null;
    wallpaperOverridden?: boolean;
    peer: Api.TypePeer;
    wallpaper?: Api.TypeWallPaper;
  }> {
  CONSTRUCTOR_ID: 2923368477;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePeerWallpaper";
  static fromReader(reader: Reader): UpdatePeerWallpaper;
    // flags: null;
    wallpaperOverridden?: boolean;
    peer: Api.TypePeer;
    wallpaper?: Api.TypeWallPaper;
  }
  export class UpdateBotMessageReaction extends VirtualClass<{
    peer: Api.TypePeer;
    msgId: int;
    date: int;
    actor: Api.TypePeer;
    oldReactions: Api.TypeReaction[];
    newReactions: Api.TypeReaction[];
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2887898062;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotMessageReaction";
  static fromReader(reader: Reader): UpdateBotMessageReaction;
    peer: Api.TypePeer;
    msgId: int;
    date: int;
    actor: Api.TypePeer;
    oldReactions: Api.TypeReaction[];
    newReactions: Api.TypeReaction[];
    qts: int;
  }
  export class UpdateBotMessageReactions extends VirtualClass<{
    peer: Api.TypePeer;
    msgId: int;
    date: int;
    reactions: Api.TypeReactionCount[];
    qts: int;
  }> {
  CONSTRUCTOR_ID: 164329305;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotMessageReactions";
  static fromReader(reader: Reader): UpdateBotMessageReactions;
    peer: Api.TypePeer;
    msgId: int;
    date: int;
    reactions: Api.TypeReactionCount[];
    qts: int;
  }
  export class UpdateSavedDialogPinned extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    peer: Api.TypeDialogPeer;
  }> {
  CONSTRUCTOR_ID: 2930744948;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSavedDialogPinned";
  static fromReader(reader: Reader): UpdateSavedDialogPinned;
    // flags: null;
    pinned?: boolean;
    peer: Api.TypeDialogPeer;
  }
  export class UpdatePinnedSavedDialogs extends VirtualClass<{
    // flags: null;
    order?: Api.TypeDialogPeer[];
  }> {
  CONSTRUCTOR_ID: 1751942566;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePinnedSavedDialogs";
  static fromReader(reader: Reader): UpdatePinnedSavedDialogs;
    // flags: null;
    order?: Api.TypeDialogPeer[];
  }
  export class UpdateSavedReactionTags extends VirtualClass<void> {
  CONSTRUCTOR_ID: 969307186;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSavedReactionTags";
  static fromReader(reader: Reader): UpdateSavedReactionTags;
}
  export class UpdateSmsJob extends VirtualClass<{
    jobId: string;
  }> {
  CONSTRUCTOR_ID: 4049758676;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateSmsJob";
  static fromReader(reader: Reader): UpdateSmsJob;
    jobId: string;
  }
  export class UpdateQuickReplies extends VirtualClass<{
    quickReplies: Api.TypeQuickReply[];
  }> {
  CONSTRUCTOR_ID: 4182182578;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateQuickReplies";
  static fromReader(reader: Reader): UpdateQuickReplies;
    quickReplies: Api.TypeQuickReply[];
  }
  export class UpdateNewQuickReply extends VirtualClass<{
    quickReply: Api.TypeQuickReply;
  }> {
  CONSTRUCTOR_ID: 4114458391;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewQuickReply";
  static fromReader(reader: Reader): UpdateNewQuickReply;
    quickReply: Api.TypeQuickReply;
  }
  export class UpdateDeleteQuickReply extends VirtualClass<{
    shortcutId: int;
  }> {
  CONSTRUCTOR_ID: 1407644140;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDeleteQuickReply";
  static fromReader(reader: Reader): UpdateDeleteQuickReply;
    shortcutId: int;
  }
  export class UpdateQuickReplyMessage extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 1040518415;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateQuickReplyMessage";
  static fromReader(reader: Reader): UpdateQuickReplyMessage;
    message: Api.TypeMessage;
  }
  export class UpdateDeleteQuickReplyMessages extends VirtualClass<{
    shortcutId: int;
    messages: int[];
  }> {
  CONSTRUCTOR_ID: 1450174413;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateDeleteQuickReplyMessages";
  static fromReader(reader: Reader): UpdateDeleteQuickReplyMessages;
    shortcutId: int;
    messages: int[];
  }
  export class UpdateBotBusinessConnect extends VirtualClass<{
    connection: Api.TypeBotBusinessConnection;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2330315130;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotBusinessConnect";
  static fromReader(reader: Reader): UpdateBotBusinessConnect;
    connection: Api.TypeBotBusinessConnection;
    qts: int;
  }
  export class UpdateBotNewBusinessMessage extends VirtualClass<{
    // flags: null;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2648388732;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotNewBusinessMessage";
  static fromReader(reader: Reader): UpdateBotNewBusinessMessage;
    // flags: null;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    qts: int;
  }
  export class UpdateBotEditBusinessMessage extends VirtualClass<{
    // flags: null;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 132077692;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotEditBusinessMessage";
  static fromReader(reader: Reader): UpdateBotEditBusinessMessage;
    // flags: null;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    qts: int;
  }
  export class UpdateBotDeleteBusinessMessage extends VirtualClass<{
    connectionId: string;
    peer: Api.TypePeer;
    messages: int[];
    qts: int;
  }> {
  CONSTRUCTOR_ID: 2687146030;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotDeleteBusinessMessage";
  static fromReader(reader: Reader): UpdateBotDeleteBusinessMessage;
    connectionId: string;
    peer: Api.TypePeer;
    messages: int[];
    qts: int;
  }
  export class UpdateNewStoryReaction extends VirtualClass<{
    storyId: int;
    peer: Api.TypePeer;
    reaction: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 405070859;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateNewStoryReaction";
  static fromReader(reader: Reader): UpdateNewStoryReaction;
    storyId: int;
    peer: Api.TypePeer;
    reaction: Api.TypeReaction;
  }
  export class UpdateBroadcastRevenueTransactions extends VirtualClass<{
    peer: Api.TypePeer;
    balances: Api.TypeBroadcastRevenueBalances;
  }> {
  CONSTRUCTOR_ID: 3755565557;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBroadcastRevenueTransactions";
  static fromReader(reader: Reader): UpdateBroadcastRevenueTransactions;
    peer: Api.TypePeer;
    balances: Api.TypeBroadcastRevenueBalances;
  }
  export class UpdateStarsBalance extends VirtualClass<{
    balance: Api.TypeStarsAmount;
  }> {
  CONSTRUCTOR_ID: 1317053305;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStarsBalance";
  static fromReader(reader: Reader): UpdateStarsBalance;
    balance: Api.TypeStarsAmount;
  }
  export class UpdateBusinessBotCallbackQuery extends VirtualClass<{
    // flags: null;
    queryId: long;
    userId: long;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    chatInstance: long;
    data?: bytes;
  }> {
  CONSTRUCTOR_ID: 513998247;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBusinessBotCallbackQuery";
  static fromReader(reader: Reader): UpdateBusinessBotCallbackQuery;
    // flags: null;
    queryId: long;
    userId: long;
    connectionId: string;
    message: Api.TypeMessage;
    replyToMessage?: Api.TypeMessage;
    chatInstance: long;
    data?: bytes;
  }
  export class UpdateStarsRevenueStatus extends VirtualClass<{
    peer: Api.TypePeer;
    status: Api.TypeStarsRevenueStatus;
  }> {
  CONSTRUCTOR_ID: 2776936473;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateStarsRevenueStatus";
  static fromReader(reader: Reader): UpdateStarsRevenueStatus;
    peer: Api.TypePeer;
    status: Api.TypeStarsRevenueStatus;
  }
  export class UpdateBotPurchasedPaidMedia extends VirtualClass<{
    userId: long;
    payload: string;
    qts: int;
  }> {
  CONSTRUCTOR_ID: 675009298;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdateBotPurchasedPaidMedia";
  static fromReader(reader: Reader): UpdateBotPurchasedPaidMedia;
    userId: long;
    payload: string;
    qts: int;
  }
  export class UpdatePaidReactionPrivacy extends VirtualClass<{
    private: Bool;
  }> {
  CONSTRUCTOR_ID: 1372224236;
  SUBCLASS_OF_ID: 2676568142;
  classType: "constructor";
  className: "UpdatePaidReactionPrivacy";
  static fromReader(reader: Reader): UpdatePaidReactionPrivacy;
    private: Bool;
  }
  export class UpdatesTooLong extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3809980286;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdatesTooLong";
  static fromReader(reader: Reader): UpdatesTooLong;
}
  export class UpdateShortMessage extends VirtualClass<{
    // flags: null;
    out?: boolean;
    mentioned?: boolean;
    mediaUnread?: boolean;
    silent?: boolean;
    id: int;
    userId: long;
    message: string;
    pts: int;
    ptsCount: int;
    date: int;
    fwdFrom?: Api.TypeMessageFwdHeader;
    viaBotId?: long;
    replyTo?: Api.TypeMessageReplyHeader;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 826001400;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdateShortMessage";
  static fromReader(reader: Reader): UpdateShortMessage;
    // flags: null;
    out?: boolean;
    mentioned?: boolean;
    mediaUnread?: boolean;
    silent?: boolean;
    id: int;
    userId: long;
    message: string;
    pts: int;
    ptsCount: int;
    date: int;
    fwdFrom?: Api.TypeMessageFwdHeader;
    viaBotId?: long;
    replyTo?: Api.TypeMessageReplyHeader;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }
  export class UpdateShortChatMessage extends VirtualClass<{
    // flags: null;
    out?: boolean;
    mentioned?: boolean;
    mediaUnread?: boolean;
    silent?: boolean;
    id: int;
    fromId: long;
    chatId: long;
    message: string;
    pts: int;
    ptsCount: int;
    date: int;
    fwdFrom?: Api.TypeMessageFwdHeader;
    viaBotId?: long;
    replyTo?: Api.TypeMessageReplyHeader;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 1299050149;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdateShortChatMessage";
  static fromReader(reader: Reader): UpdateShortChatMessage;
    // flags: null;
    out?: boolean;
    mentioned?: boolean;
    mediaUnread?: boolean;
    silent?: boolean;
    id: int;
    fromId: long;
    chatId: long;
    message: string;
    pts: int;
    ptsCount: int;
    date: int;
    fwdFrom?: Api.TypeMessageFwdHeader;
    viaBotId?: long;
    replyTo?: Api.TypeMessageReplyHeader;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }
  export class UpdateShort extends VirtualClass<{
    update: Api.TypeUpdate;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2027216577;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdateShort";
  static fromReader(reader: Reader): UpdateShort;
    update: Api.TypeUpdate;
    date: int;
  }
  export class UpdatesCombined extends VirtualClass<{
    updates: Api.TypeUpdate[];
    users: Api.TypeUser[];
    chats: Api.TypeChat[];
    date: int;
    seqStart: int;
    seq: int;
  }> {
  CONSTRUCTOR_ID: 1918567619;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdatesCombined";
  static fromReader(reader: Reader): UpdatesCombined;
    updates: Api.TypeUpdate[];
    users: Api.TypeUser[];
    chats: Api.TypeChat[];
    date: int;
    seqStart: int;
    seq: int;
  }
  export class Updates extends VirtualClass<{
    updates: Api.TypeUpdate[];
    users: Api.TypeUser[];
    chats: Api.TypeChat[];
    date: int;
    seq: int;
  }> {
  CONSTRUCTOR_ID: 1957577280;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "Updates";
  static fromReader(reader: Reader): Updates;
    updates: Api.TypeUpdate[];
    users: Api.TypeUser[];
    chats: Api.TypeChat[];
    date: int;
    seq: int;
  }
  export class UpdateShortSentMessage extends VirtualClass<{
    // flags: null;
    out?: boolean;
    id: int;
    pts: int;
    ptsCount: int;
    date: int;
    media?: Api.TypeMessageMedia;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 2417352961;
  SUBCLASS_OF_ID: 2331323052;
  classType: "constructor";
  className: "UpdateShortSentMessage";
  static fromReader(reader: Reader): UpdateShortSentMessage;
    // flags: null;
    out?: boolean;
    id: int;
    pts: int;
    ptsCount: int;
    date: int;
    media?: Api.TypeMessageMedia;
    entities?: Api.TypeMessageEntity[];
    ttlPeriod?: int;
  }
  export class DcOption extends VirtualClass<{
    // flags: null;
    ipv6?: boolean;
    mediaOnly?: boolean;
    tcpoOnly?: boolean;
    cdn?: boolean;
    static?: boolean;
    thisPortOnly?: boolean;
    id: int;
    ipAddress: string;
    port: int;
    secret?: bytes;
  }> {
  CONSTRUCTOR_ID: 414687501;
  SUBCLASS_OF_ID: 2655248675;
  classType: "constructor";
  className: "DcOption";
  static fromReader(reader: Reader): DcOption;
    // flags: null;
    ipv6?: boolean;
    mediaOnly?: boolean;
    tcpoOnly?: boolean;
    cdn?: boolean;
    static?: boolean;
    thisPortOnly?: boolean;
    id: int;
    ipAddress: string;
    port: int;
    secret?: bytes;
  }
  export class Config extends VirtualClass<{
    // flags: null;
    defaultP2pContacts?: boolean;
    preloadFeaturedStickers?: boolean;
    revokePmInbox?: boolean;
    blockedMode?: boolean;
    forceTryIpv6?: boolean;
    date: int;
    expires: int;
    testMode: Bool;
    thisDc: int;
    dcOptions: Api.TypeDcOption[];
    dcTxtDomainName: string;
    chatSizeMax: int;
    megagroupSizeMax: int;
    forwardedCountMax: int;
    onlineUpdatePeriodMs: int;
    offlineBlurTimeoutMs: int;
    offlineIdleTimeoutMs: int;
    onlineCloudTimeoutMs: int;
    notifyCloudDelayMs: int;
    notifyDefaultDelayMs: int;
    pushChatPeriodMs: int;
    pushChatLimit: int;
    editTimeLimit: int;
    revokeTimeLimit: int;
    revokePmTimeLimit: int;
    ratingEDecay: int;
    stickersRecentLimit: int;
    channelsReadMediaPeriod: int;
    tmpSessions?: int;
    callReceiveTimeoutMs: int;
    callRingTimeoutMs: int;
    callConnectTimeoutMs: int;
    callPacketTimeoutMs: int;
    meUrlPrefix: string;
    autoupdateUrlPrefix?: string;
    gifSearchUsername?: string;
    venueSearchUsername?: string;
    imgSearchUsername?: string;
    staticMapsProvider?: string;
    captionLengthMax: int;
    messageLengthMax: int;
    webfileDcId: int;
    suggestedLangCode?: string;
    langPackVersion?: int;
    baseLangPackVersion?: int;
    reactionsDefault?: Api.TypeReaction;
    autologinToken?: string;
  }> {
  CONSTRUCTOR_ID: 3424265246;
  SUBCLASS_OF_ID: 3542493770;
  classType: "constructor";
  className: "Config";
  static fromReader(reader: Reader): Config;
    // flags: null;
    defaultP2pContacts?: boolean;
    preloadFeaturedStickers?: boolean;
    revokePmInbox?: boolean;
    blockedMode?: boolean;
    forceTryIpv6?: boolean;
    date: int;
    expires: int;
    testMode: Bool;
    thisDc: int;
    dcOptions: Api.TypeDcOption[];
    dcTxtDomainName: string;
    chatSizeMax: int;
    megagroupSizeMax: int;
    forwardedCountMax: int;
    onlineUpdatePeriodMs: int;
    offlineBlurTimeoutMs: int;
    offlineIdleTimeoutMs: int;
    onlineCloudTimeoutMs: int;
    notifyCloudDelayMs: int;
    notifyDefaultDelayMs: int;
    pushChatPeriodMs: int;
    pushChatLimit: int;
    editTimeLimit: int;
    revokeTimeLimit: int;
    revokePmTimeLimit: int;
    ratingEDecay: int;
    stickersRecentLimit: int;
    channelsReadMediaPeriod: int;
    tmpSessions?: int;
    callReceiveTimeoutMs: int;
    callRingTimeoutMs: int;
    callConnectTimeoutMs: int;
    callPacketTimeoutMs: int;
    meUrlPrefix: string;
    autoupdateUrlPrefix?: string;
    gifSearchUsername?: string;
    venueSearchUsername?: string;
    imgSearchUsername?: string;
    staticMapsProvider?: string;
    captionLengthMax: int;
    messageLengthMax: int;
    webfileDcId: int;
    suggestedLangCode?: string;
    langPackVersion?: int;
    baseLangPackVersion?: int;
    reactionsDefault?: Api.TypeReaction;
    autologinToken?: string;
  }
  export class NearestDc extends VirtualClass<{
    country: string;
    thisDc: int;
    nearestDc: int;
  }> {
  CONSTRUCTOR_ID: 2384074613;
  SUBCLASS_OF_ID: 947323999;
  classType: "constructor";
  className: "NearestDc";
  static fromReader(reader: Reader): NearestDc;
    country: string;
    thisDc: int;
    nearestDc: int;
  }
  export class EncryptedChatEmpty extends VirtualClass<{
    id: int;
  }> {
  CONSTRUCTOR_ID: 2877210784;
  SUBCLASS_OF_ID: 1831379834;
  classType: "constructor";
  className: "EncryptedChatEmpty";
  static fromReader(reader: Reader): EncryptedChatEmpty;
    id: int;
  }
  export class EncryptedChatWaiting extends VirtualClass<{
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
  }> {
  CONSTRUCTOR_ID: 1722964307;
  SUBCLASS_OF_ID: 1831379834;
  classType: "constructor";
  className: "EncryptedChatWaiting";
  static fromReader(reader: Reader): EncryptedChatWaiting;
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
  }
  export class EncryptedChatRequested extends VirtualClass<{
    // flags: null;
    folderId?: int;
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gA: bytes;
  }> {
  CONSTRUCTOR_ID: 1223809356;
  SUBCLASS_OF_ID: 1831379834;
  classType: "constructor";
  className: "EncryptedChatRequested";
  static fromReader(reader: Reader): EncryptedChatRequested;
    // flags: null;
    folderId?: int;
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gA: bytes;
  }
  export class EncryptedChat extends VirtualClass<{
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAOrB: bytes;
    keyFingerprint: long;
  }> {
  CONSTRUCTOR_ID: 1643173063;
  SUBCLASS_OF_ID: 1831379834;
  classType: "constructor";
  className: "EncryptedChat";
  static fromReader(reader: Reader): EncryptedChat;
    id: int;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAOrB: bytes;
    keyFingerprint: long;
  }
  export class EncryptedChatDiscarded extends VirtualClass<{
    // flags: null;
    historyDeleted?: boolean;
    id: int;
  }> {
  CONSTRUCTOR_ID: 505183301;
  SUBCLASS_OF_ID: 1831379834;
  classType: "constructor";
  className: "EncryptedChatDiscarded";
  static fromReader(reader: Reader): EncryptedChatDiscarded;
    // flags: null;
    historyDeleted?: boolean;
    id: int;
  }
  export class InputEncryptedChat extends VirtualClass<{
    chatId: int;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 4047615457;
  SUBCLASS_OF_ID: 1819674304;
  classType: "constructor";
  className: "InputEncryptedChat";
  static fromReader(reader: Reader): InputEncryptedChat;
    chatId: int;
    accessHash: long;
  }
  export class EncryptedFileEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3256830334;
  SUBCLASS_OF_ID: 2217371584;
  classType: "constructor";
  className: "EncryptedFileEmpty";
  static fromReader(reader: Reader): EncryptedFileEmpty;
}
  export class EncryptedFile extends VirtualClass<{
    id: long;
    accessHash: long;
    size: long;
    dcId: int;
    keyFingerprint: int;
  }> {
  CONSTRUCTOR_ID: 2818608344;
  SUBCLASS_OF_ID: 2217371584;
  classType: "constructor";
  className: "EncryptedFile";
  static fromReader(reader: Reader): EncryptedFile;
    id: long;
    accessHash: long;
    size: long;
    dcId: int;
    keyFingerprint: int;
  }
  export class InputEncryptedFileEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 406307684;
  SUBCLASS_OF_ID: 2239021690;
  classType: "constructor";
  className: "InputEncryptedFileEmpty";
  static fromReader(reader: Reader): InputEncryptedFileEmpty;
}
  export class InputEncryptedFileUploaded extends VirtualClass<{
    id: long;
    parts: int;
    md5Checksum: string;
    keyFingerprint: int;
  }> {
  CONSTRUCTOR_ID: 1690108678;
  SUBCLASS_OF_ID: 2239021690;
  classType: "constructor";
  className: "InputEncryptedFileUploaded";
  static fromReader(reader: Reader): InputEncryptedFileUploaded;
    id: long;
    parts: int;
    md5Checksum: string;
    keyFingerprint: int;
  }
  export class InputEncryptedFile extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 1511503333;
  SUBCLASS_OF_ID: 2239021690;
  classType: "constructor";
  className: "InputEncryptedFile";
  static fromReader(reader: Reader): InputEncryptedFile;
    id: long;
    accessHash: long;
  }
  export class InputEncryptedFileBigUploaded extends VirtualClass<{
    id: long;
    parts: int;
    keyFingerprint: int;
  }> {
  CONSTRUCTOR_ID: 767652808;
  SUBCLASS_OF_ID: 2239021690;
  classType: "constructor";
  className: "InputEncryptedFileBigUploaded";
  static fromReader(reader: Reader): InputEncryptedFileBigUploaded;
    id: long;
    parts: int;
    keyFingerprint: int;
  }
  export class EncryptedMessage extends VirtualClass<{
    randomId?: long;
    chatId: int;
    date: int;
    bytes: bytes;
    file: Api.TypeEncryptedFile;
  }> {
  CONSTRUCTOR_ID: 3977822488;
  SUBCLASS_OF_ID: 597634641;
  classType: "constructor";
  className: "EncryptedMessage";
  static fromReader(reader: Reader): EncryptedMessage;
    randomId?: long;
    chatId: int;
    date: int;
    bytes: bytes;
    file: Api.TypeEncryptedFile;
  }
  export class EncryptedMessageService extends VirtualClass<{
    randomId?: long;
    chatId: int;
    date: int;
    bytes: bytes;
  }> {
  CONSTRUCTOR_ID: 594758406;
  SUBCLASS_OF_ID: 597634641;
  classType: "constructor";
  className: "EncryptedMessageService";
  static fromReader(reader: Reader): EncryptedMessageService;
    randomId?: long;
    chatId: int;
    date: int;
    bytes: bytes;
  }
  export class InputDocumentEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1928391342;
  SUBCLASS_OF_ID: 4081048424;
  classType: "constructor";
  className: "InputDocumentEmpty";
  static fromReader(reader: Reader): InputDocumentEmpty;
}
  export class InputDocument extends VirtualClass<{
    id: long;
    accessHash: long;
    fileReference: bytes;
  }> {
  CONSTRUCTOR_ID: 448771445;
  SUBCLASS_OF_ID: 4081048424;
  classType: "constructor";
  className: "InputDocument";
  static fromReader(reader: Reader): InputDocument;
    id: long;
    accessHash: long;
    fileReference: bytes;
  }
  export class DocumentEmpty extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 922273905;
  SUBCLASS_OF_ID: 555739168;
  classType: "constructor";
  className: "DocumentEmpty";
  static fromReader(reader: Reader): DocumentEmpty;
    id: long;
  }
  export class Document extends VirtualClass<{
    // flags: null;
    id: long;
    accessHash: long;
    fileReference: bytes;
    date: int;
    mimeType: string;
    size: long;
    thumbs?: Api.TypePhotoSize[];
    videoThumbs?: Api.TypeVideoSize[];
    dcId: int;
    attributes: Api.TypeDocumentAttribute[];
  }> {
  CONSTRUCTOR_ID: 2413085912;
  SUBCLASS_OF_ID: 555739168;
  classType: "constructor";
  className: "Document";
  static fromReader(reader: Reader): Document;
    // flags: null;
    id: long;
    accessHash: long;
    fileReference: bytes;
    date: int;
    mimeType: string;
    size: long;
    thumbs?: Api.TypePhotoSize[];
    videoThumbs?: Api.TypeVideoSize[];
    dcId: int;
    attributes: Api.TypeDocumentAttribute[];
  }
  export class NotifyPeer extends VirtualClass<{
    peer: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 2681474008;
  SUBCLASS_OF_ID: 3756548142;
  classType: "constructor";
  className: "NotifyPeer";
  static fromReader(reader: Reader): NotifyPeer;
    peer: Api.TypePeer;
  }
  export class NotifyUsers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3033021260;
  SUBCLASS_OF_ID: 3756548142;
  classType: "constructor";
  className: "NotifyUsers";
  static fromReader(reader: Reader): NotifyUsers;
}
  export class NotifyChats extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3221737155;
  SUBCLASS_OF_ID: 3756548142;
  classType: "constructor";
  className: "NotifyChats";
  static fromReader(reader: Reader): NotifyChats;
}
  export class NotifyBroadcasts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3591563503;
  SUBCLASS_OF_ID: 3756548142;
  classType: "constructor";
  className: "NotifyBroadcasts";
  static fromReader(reader: Reader): NotifyBroadcasts;
}
  export class NotifyForumTopic extends VirtualClass<{
    peer: Api.TypePeer;
    topMsgId: int;
  }> {
  CONSTRUCTOR_ID: 577659656;
  SUBCLASS_OF_ID: 3756548142;
  classType: "constructor";
  className: "NotifyForumTopic";
  static fromReader(reader: Reader): NotifyForumTopic;
    peer: Api.TypePeer;
    topMsgId: int;
  }
  export class SendMessageTypingAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 381645902;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageTypingAction";
  static fromReader(reader: Reader): SendMessageTypingAction;
}
  export class SendMessageCancelAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4250847477;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageCancelAction";
  static fromReader(reader: Reader): SendMessageCancelAction;
}
  export class SendMessageRecordVideoAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2710034031;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageRecordVideoAction";
  static fromReader(reader: Reader): SendMessageRecordVideoAction;
}
  export class SendMessageUploadVideoAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 3916839660;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageUploadVideoAction";
  static fromReader(reader: Reader): SendMessageUploadVideoAction;
    progress: int;
  }
  export class SendMessageRecordAudioAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3576656887;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageRecordAudioAction";
  static fromReader(reader: Reader): SendMessageRecordAudioAction;
}
  export class SendMessageUploadAudioAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 4082227115;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageUploadAudioAction";
  static fromReader(reader: Reader): SendMessageUploadAudioAction;
    progress: int;
  }
  export class SendMessageUploadPhotoAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 3520285222;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageUploadPhotoAction";
  static fromReader(reader: Reader): SendMessageUploadPhotoAction;
    progress: int;
  }
  export class SendMessageUploadDocumentAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 2852968932;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageUploadDocumentAction";
  static fromReader(reader: Reader): SendMessageUploadDocumentAction;
    progress: int;
  }
  export class SendMessageGeoLocationAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 393186209;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageGeoLocationAction";
  static fromReader(reader: Reader): SendMessageGeoLocationAction;
}
  export class SendMessageChooseContactAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1653390447;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageChooseContactAction";
  static fromReader(reader: Reader): SendMessageChooseContactAction;
}
  export class SendMessageGamePlayAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3714748232;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageGamePlayAction";
  static fromReader(reader: Reader): SendMessageGamePlayAction;
}
  export class SendMessageRecordRoundAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2297593788;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageRecordRoundAction";
  static fromReader(reader: Reader): SendMessageRecordRoundAction;
}
  export class SendMessageUploadRoundAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 608050278;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageUploadRoundAction";
  static fromReader(reader: Reader): SendMessageUploadRoundAction;
    progress: int;
  }
  export class SpeakingInGroupCallAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3643548293;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SpeakingInGroupCallAction";
  static fromReader(reader: Reader): SpeakingInGroupCallAction;
}
  export class SendMessageHistoryImportAction extends VirtualClass<{
    progress: int;
  }> {
  CONSTRUCTOR_ID: 3688534598;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageHistoryImportAction";
  static fromReader(reader: Reader): SendMessageHistoryImportAction;
    progress: int;
  }
  export class SendMessageChooseStickerAction extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2958739121;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageChooseStickerAction";
  static fromReader(reader: Reader): SendMessageChooseStickerAction;
}
  export class SendMessageEmojiInteraction extends VirtualClass<{
    emoticon: string;
    msgId: int;
    interaction: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 630664139;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageEmojiInteraction";
  static fromReader(reader: Reader): SendMessageEmojiInteraction;
    emoticon: string;
    msgId: int;
    interaction: Api.TypeDataJSON;
  }
  export class SendMessageEmojiInteractionSeen extends VirtualClass<{
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 3060109358;
  SUBCLASS_OF_ID: 548588577;
  classType: "constructor";
  className: "SendMessageEmojiInteractionSeen";
  static fromReader(reader: Reader): SendMessageEmojiInteractionSeen;
    emoticon: string;
  }
  export class InputPrivacyKeyStatusTimestamp extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1335282456;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyStatusTimestamp";
  static fromReader(reader: Reader): InputPrivacyKeyStatusTimestamp;
}
  export class InputPrivacyKeyChatInvite extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3187344422;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyChatInvite";
  static fromReader(reader: Reader): InputPrivacyKeyChatInvite;
}
  export class InputPrivacyKeyPhoneCall extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4206550111;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyPhoneCall";
  static fromReader(reader: Reader): InputPrivacyKeyPhoneCall;
}
  export class InputPrivacyKeyPhoneP2P extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3684593874;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyPhoneP2P";
  static fromReader(reader: Reader): InputPrivacyKeyPhoneP2P;
}
  export class InputPrivacyKeyForwards extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2765966344;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyForwards";
  static fromReader(reader: Reader): InputPrivacyKeyForwards;
}
  export class InputPrivacyKeyProfilePhoto extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1461304012;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyProfilePhoto";
  static fromReader(reader: Reader): InputPrivacyKeyProfilePhoto;
}
  export class InputPrivacyKeyPhoneNumber extends VirtualClass<void> {
  CONSTRUCTOR_ID: 55761658;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyPhoneNumber";
  static fromReader(reader: Reader): InputPrivacyKeyPhoneNumber;
}
  export class InputPrivacyKeyAddedByPhone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3508640733;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyAddedByPhone";
  static fromReader(reader: Reader): InputPrivacyKeyAddedByPhone;
}
  export class InputPrivacyKeyVoiceMessages extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2934349160;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyVoiceMessages";
  static fromReader(reader: Reader): InputPrivacyKeyVoiceMessages;
}
  export class InputPrivacyKeyAbout extends VirtualClass<void> {
  CONSTRUCTOR_ID: 941870144;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyAbout";
  static fromReader(reader: Reader): InputPrivacyKeyAbout;
}
  export class InputPrivacyKeyBirthday extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3596227020;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyBirthday";
  static fromReader(reader: Reader): InputPrivacyKeyBirthday;
}
  export class InputPrivacyKeyStarGiftsAutoSave extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3782419265;
  SUBCLASS_OF_ID: 87435256;
  classType: "constructor";
  className: "InputPrivacyKeyStarGiftsAutoSave";
  static fromReader(reader: Reader): InputPrivacyKeyStarGiftsAutoSave;
}
  export class PrivacyKeyStatusTimestamp extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3157175088;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyStatusTimestamp";
  static fromReader(reader: Reader): PrivacyKeyStatusTimestamp;
}
  export class PrivacyKeyChatInvite extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1343122938;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyChatInvite";
  static fromReader(reader: Reader): PrivacyKeyChatInvite;
}
  export class PrivacyKeyPhoneCall extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1030105979;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyPhoneCall";
  static fromReader(reader: Reader): PrivacyKeyPhoneCall;
}
  export class PrivacyKeyPhoneP2P extends VirtualClass<void> {
  CONSTRUCTOR_ID: 961092808;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyPhoneP2P";
  static fromReader(reader: Reader): PrivacyKeyPhoneP2P;
}
  export class PrivacyKeyForwards extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1777096355;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyForwards";
  static fromReader(reader: Reader): PrivacyKeyForwards;
}
  export class PrivacyKeyProfilePhoto extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2517966829;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyProfilePhoto";
  static fromReader(reader: Reader): PrivacyKeyProfilePhoto;
}
  export class PrivacyKeyPhoneNumber extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3516589165;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyPhoneNumber";
  static fromReader(reader: Reader): PrivacyKeyPhoneNumber;
}
  export class PrivacyKeyAddedByPhone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1124062251;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyAddedByPhone";
  static fromReader(reader: Reader): PrivacyKeyAddedByPhone;
}
  export class PrivacyKeyVoiceMessages extends VirtualClass<void> {
  CONSTRUCTOR_ID: 110621716;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyVoiceMessages";
  static fromReader(reader: Reader): PrivacyKeyVoiceMessages;
}
  export class PrivacyKeyAbout extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2760292193;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyAbout";
  static fromReader(reader: Reader): PrivacyKeyAbout;
}
  export class PrivacyKeyBirthday extends VirtualClass<void> {
  CONSTRUCTOR_ID: 536913176;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyBirthday";
  static fromReader(reader: Reader): PrivacyKeyBirthday;
}
  export class PrivacyKeyStarGiftsAutoSave extends VirtualClass<void> {
  CONSTRUCTOR_ID: 749010424;
  SUBCLASS_OF_ID: 2185646531;
  classType: "constructor";
  className: "PrivacyKeyStarGiftsAutoSave";
  static fromReader(reader: Reader): PrivacyKeyStarGiftsAutoSave;
}
  export class InputPrivacyValueAllowContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 218751099;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowContacts";
  static fromReader(reader: Reader): InputPrivacyValueAllowContacts;
}
  export class InputPrivacyValueAllowAll extends VirtualClass<void> {
  CONSTRUCTOR_ID: 407582158;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowAll";
  static fromReader(reader: Reader): InputPrivacyValueAllowAll;
}
  export class InputPrivacyValueAllowUsers extends VirtualClass<{
    users: Api.TypeInputUser[];
  }> {
  CONSTRUCTOR_ID: 320652927;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowUsers";
  static fromReader(reader: Reader): InputPrivacyValueAllowUsers;
    users: Api.TypeInputUser[];
  }
  export class InputPrivacyValueDisallowContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 195371015;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueDisallowContacts";
  static fromReader(reader: Reader): InputPrivacyValueDisallowContacts;
}
  export class InputPrivacyValueDisallowAll extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3597362889;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueDisallowAll";
  static fromReader(reader: Reader): InputPrivacyValueDisallowAll;
}
  export class InputPrivacyValueDisallowUsers extends VirtualClass<{
    users: Api.TypeInputUser[];
  }> {
  CONSTRUCTOR_ID: 2417034343;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueDisallowUsers";
  static fromReader(reader: Reader): InputPrivacyValueDisallowUsers;
    users: Api.TypeInputUser[];
  }
  export class InputPrivacyValueAllowChatParticipants extends VirtualClass<{
    chats: long[];
  }> {
  CONSTRUCTOR_ID: 2215004623;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowChatParticipants";
  static fromReader(reader: Reader): InputPrivacyValueAllowChatParticipants;
    chats: long[];
  }
  export class InputPrivacyValueDisallowChatParticipants extends VirtualClass<{
    chats: long[];
  }> {
  CONSTRUCTOR_ID: 3914272646;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueDisallowChatParticipants";
  static fromReader(reader: Reader): InputPrivacyValueDisallowChatParticipants;
    chats: long[];
  }
  export class InputPrivacyValueAllowCloseFriends extends VirtualClass<void> {
  CONSTRUCTOR_ID: 793067081;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowCloseFriends";
  static fromReader(reader: Reader): InputPrivacyValueAllowCloseFriends;
}
  export class InputPrivacyValueAllowPremium extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2009975281;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowPremium";
  static fromReader(reader: Reader): InputPrivacyValueAllowPremium;
}
  export class InputPrivacyValueAllowBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1515179237;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueAllowBots";
  static fromReader(reader: Reader): InputPrivacyValueAllowBots;
}
  export class InputPrivacyValueDisallowBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3303373077;
  SUBCLASS_OF_ID: 1513843490;
  classType: "constructor";
  className: "InputPrivacyValueDisallowBots";
  static fromReader(reader: Reader): InputPrivacyValueDisallowBots;
}
  export class PrivacyValueAllowContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4294843308;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowContacts";
  static fromReader(reader: Reader): PrivacyValueAllowContacts;
}
  export class PrivacyValueAllowAll extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1698855810;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowAll";
  static fromReader(reader: Reader): PrivacyValueAllowAll;
}
  export class PrivacyValueAllowUsers extends VirtualClass<{
    users: long[];
  }> {
  CONSTRUCTOR_ID: 3096469426;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowUsers";
  static fromReader(reader: Reader): PrivacyValueAllowUsers;
    users: long[];
  }
  export class PrivacyValueDisallowContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4169726490;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueDisallowContacts";
  static fromReader(reader: Reader): PrivacyValueDisallowContacts;
}
  export class PrivacyValueDisallowAll extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2339628899;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueDisallowAll";
  static fromReader(reader: Reader): PrivacyValueDisallowAll;
}
  export class PrivacyValueDisallowUsers extends VirtualClass<{
    users: long[];
  }> {
  CONSTRUCTOR_ID: 3831632193;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueDisallowUsers";
  static fromReader(reader: Reader): PrivacyValueDisallowUsers;
    users: long[];
  }
  export class PrivacyValueAllowChatParticipants extends VirtualClass<{
    chats: long[];
  }> {
  CONSTRUCTOR_ID: 1796427406;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowChatParticipants";
  static fromReader(reader: Reader): PrivacyValueAllowChatParticipants;
    chats: long[];
  }
  export class PrivacyValueDisallowChatParticipants extends VirtualClass<{
    chats: long[];
  }> {
  CONSTRUCTOR_ID: 1103656293;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueDisallowChatParticipants";
  static fromReader(reader: Reader): PrivacyValueDisallowChatParticipants;
    chats: long[];
  }
  export class PrivacyValueAllowCloseFriends extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4159232155;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowCloseFriends";
  static fromReader(reader: Reader): PrivacyValueAllowCloseFriends;
}
  export class PrivacyValueAllowPremium extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3974725963;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowPremium";
  static fromReader(reader: Reader): PrivacyValueAllowPremium;
}
  export class PrivacyValueAllowBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 558242653;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueAllowBots";
  static fromReader(reader: Reader): PrivacyValueAllowBots;
}
  export class PrivacyValueDisallowBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4138072111;
  SUBCLASS_OF_ID: 3954700912;
  classType: "constructor";
  className: "PrivacyValueDisallowBots";
  static fromReader(reader: Reader): PrivacyValueDisallowBots;
}
  export class AccountDaysTTL extends VirtualClass<{
    days: int;
  }> {
  CONSTRUCTOR_ID: 3100684255;
  SUBCLASS_OF_ID: 3131284872;
  classType: "constructor";
  className: "AccountDaysTTL";
  static fromReader(reader: Reader): AccountDaysTTL;
    days: int;
  }
  export class DocumentAttributeImageSize extends VirtualClass<{
    w: int;
    h: int;
  }> {
  CONSTRUCTOR_ID: 1815593308;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeImageSize";
  static fromReader(reader: Reader): DocumentAttributeImageSize;
    w: int;
    h: int;
  }
  export class DocumentAttributeAnimated extends VirtualClass<void> {
  CONSTRUCTOR_ID: 297109817;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeAnimated";
  static fromReader(reader: Reader): DocumentAttributeAnimated;
}
  export class DocumentAttributeSticker extends VirtualClass<{
    // flags: null;
    mask?: boolean;
    alt: string;
    stickerset: Api.TypeInputStickerSet;
    maskCoords?: Api.TypeMaskCoords;
  }> {
  CONSTRUCTOR_ID: 1662637586;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeSticker";
  static fromReader(reader: Reader): DocumentAttributeSticker;
    // flags: null;
    mask?: boolean;
    alt: string;
    stickerset: Api.TypeInputStickerSet;
    maskCoords?: Api.TypeMaskCoords;
  }
  export class DocumentAttributeVideo extends VirtualClass<{
    // flags: null;
    roundMessage?: boolean;
    supportsStreaming?: boolean;
    nosound?: boolean;
    duration: double;
    w: int;
    h: int;
    preloadPrefixSize?: int;
    videoStartTs?: double;
    videoCodec?: string;
  }> {
  CONSTRUCTOR_ID: 1137015880;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeVideo";
  static fromReader(reader: Reader): DocumentAttributeVideo;
    // flags: null;
    roundMessage?: boolean;
    supportsStreaming?: boolean;
    nosound?: boolean;
    duration: double;
    w: int;
    h: int;
    preloadPrefixSize?: int;
    videoStartTs?: double;
    videoCodec?: string;
  }
  export class DocumentAttributeAudio extends VirtualClass<{
    // flags: null;
    voice?: boolean;
    duration: int;
    title?: string;
    performer?: string;
    waveform?: bytes;
  }> {
  CONSTRUCTOR_ID: 2555574726;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeAudio";
  static fromReader(reader: Reader): DocumentAttributeAudio;
    // flags: null;
    voice?: boolean;
    duration: int;
    title?: string;
    performer?: string;
    waveform?: bytes;
  }
  export class DocumentAttributeFilename extends VirtualClass<{
    fileName: string;
  }> {
  CONSTRUCTOR_ID: 358154344;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeFilename";
  static fromReader(reader: Reader): DocumentAttributeFilename;
    fileName: string;
  }
  export class DocumentAttributeHasStickers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2550256375;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeHasStickers";
  static fromReader(reader: Reader): DocumentAttributeHasStickers;
}
  export class DocumentAttributeCustomEmoji extends VirtualClass<{
    // flags: null;
    free?: boolean;
    textColor?: boolean;
    alt: string;
    stickerset: Api.TypeInputStickerSet;
  }> {
  CONSTRUCTOR_ID: 4245985433;
  SUBCLASS_OF_ID: 4146719643;
  classType: "constructor";
  className: "DocumentAttributeCustomEmoji";
  static fromReader(reader: Reader): DocumentAttributeCustomEmoji;
    // flags: null;
    free?: boolean;
    textColor?: boolean;
    alt: string;
    stickerset: Api.TypeInputStickerSet;
  }
  export class StickerPack extends VirtualClass<{
    emoticon: string;
    documents: long[];
  }> {
  CONSTRUCTOR_ID: 313694676;
  SUBCLASS_OF_ID: 2683282644;
  classType: "constructor";
  className: "StickerPack";
  static fromReader(reader: Reader): StickerPack;
    emoticon: string;
    documents: long[];
  }
  export class WebPageEmpty extends VirtualClass<{
    // flags: null;
    id: long;
    url?: string;
  }> {
  CONSTRUCTOR_ID: 555358088;
  SUBCLASS_OF_ID: 1437168769;
  classType: "constructor";
  className: "WebPageEmpty";
  static fromReader(reader: Reader): WebPageEmpty;
    // flags: null;
    id: long;
    url?: string;
  }
  export class WebPagePending extends VirtualClass<{
    // flags: null;
    id: long;
    url?: string;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2966502983;
  SUBCLASS_OF_ID: 1437168769;
  classType: "constructor";
  className: "WebPagePending";
  static fromReader(reader: Reader): WebPagePending;
    // flags: null;
    id: long;
    url?: string;
    date: int;
  }
  export class WebPage extends VirtualClass<{
    // flags: null;
    hasLargeMedia?: boolean;
    id: long;
    url: string;
    displayUrl: string;
    hash: int;
    type?: string;
    siteName?: string;
    title?: string;
    description?: string;
    photo?: Api.TypePhoto;
    embedUrl?: string;
    embedType?: string;
    embedWidth?: int;
    embedHeight?: int;
    duration?: int;
    author?: string;
    document?: Api.TypeDocument;
    cachedPage?: Api.TypePage;
    attributes?: Api.TypeWebPageAttribute[];
  }> {
  CONSTRUCTOR_ID: 3902555570;
  SUBCLASS_OF_ID: 1437168769;
  classType: "constructor";
  className: "WebPage";
  static fromReader(reader: Reader): WebPage;
    // flags: null;
    hasLargeMedia?: boolean;
    id: long;
    url: string;
    displayUrl: string;
    hash: int;
    type?: string;
    siteName?: string;
    title?: string;
    description?: string;
    photo?: Api.TypePhoto;
    embedUrl?: string;
    embedType?: string;
    embedWidth?: int;
    embedHeight?: int;
    duration?: int;
    author?: string;
    document?: Api.TypeDocument;
    cachedPage?: Api.TypePage;
    attributes?: Api.TypeWebPageAttribute[];
  }
  export class WebPageNotModified extends VirtualClass<{
    // flags: null;
    cachedPageViews?: int;
  }> {
  CONSTRUCTOR_ID: 1930545681;
  SUBCLASS_OF_ID: 1437168769;
  classType: "constructor";
  className: "WebPageNotModified";
  static fromReader(reader: Reader): WebPageNotModified;
    // flags: null;
    cachedPageViews?: int;
  }
  export class Authorization extends VirtualClass<{
    // flags: null;
    current?: boolean;
    officialApp?: boolean;
    passwordPending?: boolean;
    encryptedRequestsDisabled?: boolean;
    callRequestsDisabled?: boolean;
    unconfirmed?: boolean;
    hash: long;
    deviceModel: string;
    platform: string;
    systemVersion: string;
    apiId: int;
    appName: string;
    appVersion: string;
    dateCreated: int;
    dateActive: int;
    ip: string;
    country: string;
    region: string;
  }> {
  CONSTRUCTOR_ID: 2902578717;
  SUBCLASS_OF_ID: 3373514778;
  classType: "constructor";
  className: "Authorization";
  static fromReader(reader: Reader): Authorization;
    // flags: null;
    current?: boolean;
    officialApp?: boolean;
    passwordPending?: boolean;
    encryptedRequestsDisabled?: boolean;
    callRequestsDisabled?: boolean;
    unconfirmed?: boolean;
    hash: long;
    deviceModel: string;
    platform: string;
    systemVersion: string;
    apiId: int;
    appName: string;
    appVersion: string;
    dateCreated: int;
    dateActive: int;
    ip: string;
    country: string;
    region: string;
  }
  export class ReceivedNotifyMessage extends VirtualClass<{
    id: int;
    flags: int;
  }> {
  CONSTRUCTOR_ID: 2743383929;
  SUBCLASS_OF_ID: 2841786398;
  classType: "constructor";
  className: "ReceivedNotifyMessage";
  static fromReader(reader: Reader): ReceivedNotifyMessage;
    id: int;
    flags: int;
  }
  export class ChatInviteExported extends VirtualClass<{
    // flags: null;
    revoked?: boolean;
    permanent?: boolean;
    requestNeeded?: boolean;
    link: string;
    adminId: long;
    date: int;
    startDate?: int;
    expireDate?: int;
    usageLimit?: int;
    usage?: int;
    requested?: int;
    subscriptionExpired?: int;
    title?: string;
    subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
  }> {
  CONSTRUCTOR_ID: 2720841110;
  SUBCLASS_OF_ID: 3027536472;
  classType: "constructor";
  className: "ChatInviteExported";
  static fromReader(reader: Reader): ChatInviteExported;
    // flags: null;
    revoked?: boolean;
    permanent?: boolean;
    requestNeeded?: boolean;
    link: string;
    adminId: long;
    date: int;
    startDate?: int;
    expireDate?: int;
    usageLimit?: int;
    usage?: int;
    requested?: int;
    subscriptionExpired?: int;
    title?: string;
    subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
  }
  export class ChatInvitePublicJoinRequests extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3977280183;
  SUBCLASS_OF_ID: 3027536472;
  classType: "constructor";
  className: "ChatInvitePublicJoinRequests";
  static fromReader(reader: Reader): ChatInvitePublicJoinRequests;
}
  export class ChatInviteAlready extends VirtualClass<{
    chat: Api.TypeChat;
  }> {
  CONSTRUCTOR_ID: 1516793212;
  SUBCLASS_OF_ID: 72750902;
  classType: "constructor";
  className: "ChatInviteAlready";
  static fromReader(reader: Reader): ChatInviteAlready;
    chat: Api.TypeChat;
  }
  export class ChatInvite extends VirtualClass<{
    // flags: null;
    channel?: boolean;
    broadcast?: boolean;
    public?: boolean;
    megagroup?: boolean;
    requestNeeded?: boolean;
    verified?: boolean;
    scam?: boolean;
    fake?: boolean;
    canRefulfillSubscription?: boolean;
    title: string;
    about?: string;
    photo: Api.TypePhoto;
    participantsCount: int;
    participants?: Api.TypeUser[];
    color: int;
    subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
    subscriptionFormId?: long;
    botVerification?: Api.TypeBotVerification;
  }> {
  CONSTRUCTOR_ID: 1553807106;
  SUBCLASS_OF_ID: 72750902;
  classType: "constructor";
  className: "ChatInvite";
  static fromReader(reader: Reader): ChatInvite;
    // flags: null;
    channel?: boolean;
    broadcast?: boolean;
    public?: boolean;
    megagroup?: boolean;
    requestNeeded?: boolean;
    verified?: boolean;
    scam?: boolean;
    fake?: boolean;
    canRefulfillSubscription?: boolean;
    title: string;
    about?: string;
    photo: Api.TypePhoto;
    participantsCount: int;
    participants?: Api.TypeUser[];
    color: int;
    subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
    subscriptionFormId?: long;
    botVerification?: Api.TypeBotVerification;
  }
  export class ChatInvitePeek extends VirtualClass<{
    chat: Api.TypeChat;
    expires: int;
  }> {
  CONSTRUCTOR_ID: 1634294960;
  SUBCLASS_OF_ID: 72750902;
  classType: "constructor";
  className: "ChatInvitePeek";
  static fromReader(reader: Reader): ChatInvitePeek;
    chat: Api.TypeChat;
    expires: int;
  }
  export class InputStickerSetEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4290128789;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetEmpty";
  static fromReader(reader: Reader): InputStickerSetEmpty;
}
  export class InputStickerSetID extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 2649203305;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetID";
  static fromReader(reader: Reader): InputStickerSetID;
    id: long;
    accessHash: long;
  }
  export class InputStickerSetShortName extends VirtualClass<{
    shortName: string;
  }> {
  CONSTRUCTOR_ID: 2250033312;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetShortName";
  static fromReader(reader: Reader): InputStickerSetShortName;
    shortName: string;
  }
  export class InputStickerSetAnimatedEmoji extends VirtualClass<void> {
  CONSTRUCTOR_ID: 42402760;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetAnimatedEmoji";
  static fromReader(reader: Reader): InputStickerSetAnimatedEmoji;
}
  export class InputStickerSetDice extends VirtualClass<{
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 3867103758;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetDice";
  static fromReader(reader: Reader): InputStickerSetDice;
    emoticon: string;
  }
  export class InputStickerSetAnimatedEmojiAnimations extends VirtualClass<void> {
  CONSTRUCTOR_ID: 215889721;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetAnimatedEmojiAnimations";
  static fromReader(reader: Reader): InputStickerSetAnimatedEmojiAnimations;
}
  export class InputStickerSetPremiumGifts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3364567810;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetPremiumGifts";
  static fromReader(reader: Reader): InputStickerSetPremiumGifts;
}
  export class InputStickerSetEmojiGenericAnimations extends VirtualClass<void> {
  CONSTRUCTOR_ID: 80008398;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetEmojiGenericAnimations";
  static fromReader(reader: Reader): InputStickerSetEmojiGenericAnimations;
}
  export class InputStickerSetEmojiDefaultStatuses extends VirtualClass<void> {
  CONSTRUCTOR_ID: 701560302;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetEmojiDefaultStatuses";
  static fromReader(reader: Reader): InputStickerSetEmojiDefaultStatuses;
}
  export class InputStickerSetEmojiDefaultTopicIcons extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1153562857;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetEmojiDefaultTopicIcons";
  static fromReader(reader: Reader): InputStickerSetEmojiDefaultTopicIcons;
}
  export class InputStickerSetEmojiChannelDefaultStatuses extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1232373075;
  SUBCLASS_OF_ID: 1034127786;
  classType: "constructor";
  className: "InputStickerSetEmojiChannelDefaultStatuses";
  static fromReader(reader: Reader): InputStickerSetEmojiChannelDefaultStatuses;
}
  export class StickerSet extends VirtualClass<{
    // flags: null;
    archived?: boolean;
    official?: boolean;
    masks?: boolean;
    emojis?: boolean;
    textColor?: boolean;
    channelEmojiStatus?: boolean;
    creator?: boolean;
    installedDate?: int;
    id: long;
    accessHash: long;
    title: string;
    shortName: string;
    thumbs?: Api.TypePhotoSize[];
    thumbDcId?: int;
    thumbVersion?: int;
    thumbDocumentId?: long;
    count: int;
    hash: int;
  }> {
  CONSTRUCTOR_ID: 768691932;
  SUBCLASS_OF_ID: 3134455697;
  classType: "constructor";
  className: "StickerSet";
  static fromReader(reader: Reader): StickerSet;
    // flags: null;
    archived?: boolean;
    official?: boolean;
    masks?: boolean;
    emojis?: boolean;
    textColor?: boolean;
    channelEmojiStatus?: boolean;
    creator?: boolean;
    installedDate?: int;
    id: long;
    accessHash: long;
    title: string;
    shortName: string;
    thumbs?: Api.TypePhotoSize[];
    thumbDcId?: int;
    thumbVersion?: int;
    thumbDocumentId?: long;
    count: int;
    hash: int;
  }
  export class BotCommand extends VirtualClass<{
    command: string;
    description: string;
  }> {
  CONSTRUCTOR_ID: 3262826695;
  SUBCLASS_OF_ID: 236872386;
  classType: "constructor";
  className: "BotCommand";
  static fromReader(reader: Reader): BotCommand;
    command: string;
    description: string;
  }
  export class BotInfo extends VirtualClass<{
    // flags: null;
    hasPreviewMedias?: boolean;
    userId?: long;
    description?: string;
    descriptionPhoto?: Api.TypePhoto;
    descriptionDocument?: Api.TypeDocument;
    commands?: Api.TypeBotCommand[];
    menuButton?: Api.TypeBotMenuButton;
    privacyPolicyUrl?: string;
    appSettings?: Api.TypeBotAppSettings;
    verifierSettings?: Api.TypeBotVerifierSettings;
  }> {
  CONSTRUCTOR_ID: 1300890265;
  SUBCLASS_OF_ID: 4059496923;
  classType: "constructor";
  className: "BotInfo";
  static fromReader(reader: Reader): BotInfo;
    // flags: null;
    hasPreviewMedias?: boolean;
    userId?: long;
    description?: string;
    descriptionPhoto?: Api.TypePhoto;
    descriptionDocument?: Api.TypeDocument;
    commands?: Api.TypeBotCommand[];
    menuButton?: Api.TypeBotMenuButton;
    privacyPolicyUrl?: string;
    appSettings?: Api.TypeBotAppSettings;
    verifierSettings?: Api.TypeBotVerifierSettings;
  }
  export class KeyboardButton extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 2734311552;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButton";
  static fromReader(reader: Reader): KeyboardButton;
    text: string;
  }
  export class KeyboardButtonUrl extends VirtualClass<{
    text: string;
    url: string;
  }> {
  CONSTRUCTOR_ID: 629866245;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonUrl";
  static fromReader(reader: Reader): KeyboardButtonUrl;
    text: string;
    url: string;
  }
  export class KeyboardButtonCallback extends VirtualClass<{
    // flags: null;
    requiresPassword?: boolean;
    text: string;
    data: bytes;
  }> {
  CONSTRUCTOR_ID: 901503851;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonCallback";
  static fromReader(reader: Reader): KeyboardButtonCallback;
    // flags: null;
    requiresPassword?: boolean;
    text: string;
    data: bytes;
  }
  export class KeyboardButtonRequestPhone extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 2976541737;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonRequestPhone";
  static fromReader(reader: Reader): KeyboardButtonRequestPhone;
    text: string;
  }
  export class KeyboardButtonRequestGeoLocation extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 4235815743;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonRequestGeoLocation";
  static fromReader(reader: Reader): KeyboardButtonRequestGeoLocation;
    text: string;
  }
  export class KeyboardButtonSwitchInline extends VirtualClass<{
    // flags: null;
    samePeer?: boolean;
    text: string;
    query: string;
    peerTypes?: Api.TypeInlineQueryPeerType[];
  }> {
  CONSTRUCTOR_ID: 2478439349;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonSwitchInline";
  static fromReader(reader: Reader): KeyboardButtonSwitchInline;
    // flags: null;
    samePeer?: boolean;
    text: string;
    query: string;
    peerTypes?: Api.TypeInlineQueryPeerType[];
  }
  export class KeyboardButtonGame extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 1358175439;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonGame";
  static fromReader(reader: Reader): KeyboardButtonGame;
    text: string;
  }
  export class KeyboardButtonBuy extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 2950250427;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonBuy";
  static fromReader(reader: Reader): KeyboardButtonBuy;
    text: string;
  }
  export class KeyboardButtonUrlAuth extends VirtualClass<{
    // flags: null;
    text: string;
    fwdText?: string;
    url: string;
    buttonId: int;
  }> {
  CONSTRUCTOR_ID: 280464681;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonUrlAuth";
  static fromReader(reader: Reader): KeyboardButtonUrlAuth;
    // flags: null;
    text: string;
    fwdText?: string;
    url: string;
    buttonId: int;
  }
  export class InputKeyboardButtonUrlAuth extends VirtualClass<{
    // flags: null;
    requestWriteAccess?: boolean;
    text: string;
    fwdText?: string;
    url: string;
    bot: Api.TypeInputUser;
  }> {
  CONSTRUCTOR_ID: 3492708308;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "InputKeyboardButtonUrlAuth";
  static fromReader(reader: Reader): InputKeyboardButtonUrlAuth;
    // flags: null;
    requestWriteAccess?: boolean;
    text: string;
    fwdText?: string;
    url: string;
    bot: Api.TypeInputUser;
  }
  export class KeyboardButtonRequestPoll extends VirtualClass<{
    // flags: null;
    quiz?: Bool;
    text: string;
  }> {
  CONSTRUCTOR_ID: 3150401885;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonRequestPoll";
  static fromReader(reader: Reader): KeyboardButtonRequestPoll;
    // flags: null;
    quiz?: Bool;
    text: string;
  }
  export class InputKeyboardButtonUserProfile extends VirtualClass<{
    text: string;
    userId: Api.TypeInputUser;
  }> {
  CONSTRUCTOR_ID: 3918005115;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "InputKeyboardButtonUserProfile";
  static fromReader(reader: Reader): InputKeyboardButtonUserProfile;
    text: string;
    userId: Api.TypeInputUser;
  }
  export class KeyboardButtonUserProfile extends VirtualClass<{
    text: string;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 814112961;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonUserProfile";
  static fromReader(reader: Reader): KeyboardButtonUserProfile;
    text: string;
    userId: long;
  }
  export class KeyboardButtonWebView extends VirtualClass<{
    text: string;
    url: string;
  }> {
  CONSTRUCTOR_ID: 326529584;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonWebView";
  static fromReader(reader: Reader): KeyboardButtonWebView;
    text: string;
    url: string;
  }
  export class KeyboardButtonSimpleWebView extends VirtualClass<{
    text: string;
    url: string;
  }> {
  CONSTRUCTOR_ID: 2696958044;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonSimpleWebView";
  static fromReader(reader: Reader): KeyboardButtonSimpleWebView;
    text: string;
    url: string;
  }
  export class KeyboardButtonRequestPeer extends VirtualClass<{
    text: string;
    buttonId: int;
    peerType: Api.TypeRequestPeerType;
    maxQuantity: int;
  }> {
  CONSTRUCTOR_ID: 1406648280;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonRequestPeer";
  static fromReader(reader: Reader): KeyboardButtonRequestPeer;
    text: string;
    buttonId: int;
    peerType: Api.TypeRequestPeerType;
    maxQuantity: int;
  }
  export class InputKeyboardButtonRequestPeer extends VirtualClass<{
    // flags: null;
    nameRequested?: boolean;
    usernameRequested?: boolean;
    photoRequested?: boolean;
    text: string;
    buttonId: int;
    peerType: Api.TypeRequestPeerType;
    maxQuantity: int;
  }> {
  CONSTRUCTOR_ID: 3378916613;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "InputKeyboardButtonRequestPeer";
  static fromReader(reader: Reader): InputKeyboardButtonRequestPeer;
    // flags: null;
    nameRequested?: boolean;
    usernameRequested?: boolean;
    photoRequested?: boolean;
    text: string;
    buttonId: int;
    peerType: Api.TypeRequestPeerType;
    maxQuantity: int;
  }
  export class KeyboardButtonCopy extends VirtualClass<{
    text: string;
    copyText: string;
  }> {
  CONSTRUCTOR_ID: 1976723854;
  SUBCLASS_OF_ID: 195916963;
  classType: "constructor";
  className: "KeyboardButtonCopy";
  static fromReader(reader: Reader): KeyboardButtonCopy;
    text: string;
    copyText: string;
  }
  export class KeyboardButtonRow extends VirtualClass<{
    buttons: Api.TypeKeyboardButton[];
  }> {
  CONSTRUCTOR_ID: 2002815875;
  SUBCLASS_OF_ID: 2222403758;
  classType: "constructor";
  className: "KeyboardButtonRow";
  static fromReader(reader: Reader): KeyboardButtonRow;
    buttons: Api.TypeKeyboardButton[];
  }
  export class ReplyKeyboardHide extends VirtualClass<{
    // flags: null;
    selective?: boolean;
  }> {
  CONSTRUCTOR_ID: 2688441221;
  SUBCLASS_OF_ID: 3806400242;
  classType: "constructor";
  className: "ReplyKeyboardHide";
  static fromReader(reader: Reader): ReplyKeyboardHide;
    // flags: null;
    selective?: boolean;
  }
  export class ReplyKeyboardForceReply extends VirtualClass<{
    // flags: null;
    singleUse?: boolean;
    selective?: boolean;
    placeholder?: string;
  }> {
  CONSTRUCTOR_ID: 2259946248;
  SUBCLASS_OF_ID: 3806400242;
  classType: "constructor";
  className: "ReplyKeyboardForceReply";
  static fromReader(reader: Reader): ReplyKeyboardForceReply;
    // flags: null;
    singleUse?: boolean;
    selective?: boolean;
    placeholder?: string;
  }
  export class ReplyKeyboardMarkup extends VirtualClass<{
    // flags: null;
    resize?: boolean;
    singleUse?: boolean;
    selective?: boolean;
    persistent?: boolean;
    rows: Api.TypeKeyboardButtonRow[];
    placeholder?: string;
  }> {
  CONSTRUCTOR_ID: 2245892561;
  SUBCLASS_OF_ID: 3806400242;
  classType: "constructor";
  className: "ReplyKeyboardMarkup";
  static fromReader(reader: Reader): ReplyKeyboardMarkup;
    // flags: null;
    resize?: boolean;
    singleUse?: boolean;
    selective?: boolean;
    persistent?: boolean;
    rows: Api.TypeKeyboardButtonRow[];
    placeholder?: string;
  }
  export class ReplyInlineMarkup extends VirtualClass<{
    rows: Api.TypeKeyboardButtonRow[];
  }> {
  CONSTRUCTOR_ID: 1218642516;
  SUBCLASS_OF_ID: 3806400242;
  classType: "constructor";
  className: "ReplyInlineMarkup";
  static fromReader(reader: Reader): ReplyInlineMarkup;
    rows: Api.TypeKeyboardButtonRow[];
  }
  export class MessageEntityUnknown extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 3146955413;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityUnknown";
  static fromReader(reader: Reader): MessageEntityUnknown;
    offset: int;
    length: int;
  }
  export class MessageEntityMention extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 4194588573;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityMention";
  static fromReader(reader: Reader): MessageEntityMention;
    offset: int;
    length: int;
  }
  export class MessageEntityHashtag extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1868782349;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityHashtag";
  static fromReader(reader: Reader): MessageEntityHashtag;
    offset: int;
    length: int;
  }
  export class MessageEntityBotCommand extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1827637959;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityBotCommand";
  static fromReader(reader: Reader): MessageEntityBotCommand;
    offset: int;
    length: int;
  }
  export class MessageEntityUrl extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1859134776;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityUrl";
  static fromReader(reader: Reader): MessageEntityUrl;
    offset: int;
    length: int;
  }
  export class MessageEntityEmail extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1692693954;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityEmail";
  static fromReader(reader: Reader): MessageEntityEmail;
    offset: int;
    length: int;
  }
  export class MessageEntityBold extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 3177253833;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityBold";
  static fromReader(reader: Reader): MessageEntityBold;
    offset: int;
    length: int;
  }
  export class MessageEntityItalic extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 2188348256;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityItalic";
  static fromReader(reader: Reader): MessageEntityItalic;
    offset: int;
    length: int;
  }
  export class MessageEntityCode extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 681706865;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityCode";
  static fromReader(reader: Reader): MessageEntityCode;
    offset: int;
    length: int;
  }
  export class MessageEntityPre extends VirtualClass<{
    offset: int;
    length: int;
    language: string;
  }> {
  CONSTRUCTOR_ID: 1938967520;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityPre";
  static fromReader(reader: Reader): MessageEntityPre;
    offset: int;
    length: int;
    language: string;
  }
  export class MessageEntityTextUrl extends VirtualClass<{
    offset: int;
    length: int;
    url: string;
  }> {
  CONSTRUCTOR_ID: 1990644519;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityTextUrl";
  static fromReader(reader: Reader): MessageEntityTextUrl;
    offset: int;
    length: int;
    url: string;
  }
  export class MessageEntityMentionName extends VirtualClass<{
    offset: int;
    length: int;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 3699052864;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityMentionName";
  static fromReader(reader: Reader): MessageEntityMentionName;
    offset: int;
    length: int;
    userId: long;
  }
  export class InputMessageEntityMentionName extends VirtualClass<{
    offset: int;
    length: int;
    userId: Api.TypeInputUser;
  }> {
  CONSTRUCTOR_ID: 546203849;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "InputMessageEntityMentionName";
  static fromReader(reader: Reader): InputMessageEntityMentionName;
    offset: int;
    length: int;
    userId: Api.TypeInputUser;
  }
  export class MessageEntityPhone extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 2607407947;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityPhone";
  static fromReader(reader: Reader): MessageEntityPhone;
    offset: int;
    length: int;
  }
  export class MessageEntityCashtag extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1280209983;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityCashtag";
  static fromReader(reader: Reader): MessageEntityCashtag;
    offset: int;
    length: int;
  }
  export class MessageEntityUnderline extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 2622389899;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityUnderline";
  static fromReader(reader: Reader): MessageEntityUnderline;
    offset: int;
    length: int;
  }
  export class MessageEntityStrike extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 3204879316;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityStrike";
  static fromReader(reader: Reader): MessageEntityStrike;
    offset: int;
    length: int;
  }
  export class MessageEntityBankCard extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 1981704948;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityBankCard";
  static fromReader(reader: Reader): MessageEntityBankCard;
    offset: int;
    length: int;
  }
  export class MessageEntitySpoiler extends VirtualClass<{
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 852137487;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntitySpoiler";
  static fromReader(reader: Reader): MessageEntitySpoiler;
    offset: int;
    length: int;
  }
  export class MessageEntityCustomEmoji extends VirtualClass<{
    offset: int;
    length: int;
    documentId: long;
  }> {
  CONSTRUCTOR_ID: 3369010680;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityCustomEmoji";
  static fromReader(reader: Reader): MessageEntityCustomEmoji;
    offset: int;
    length: int;
    documentId: long;
  }
  export class MessageEntityBlockquote extends VirtualClass<{
    // flags: null;
    collapsed?: boolean;
    offset: int;
    length: int;
  }> {
  CONSTRUCTOR_ID: 4056722092;
  SUBCLASS_OF_ID: 3479443932;
  classType: "constructor";
  className: "MessageEntityBlockquote";
  static fromReader(reader: Reader): MessageEntityBlockquote;
    // flags: null;
    collapsed?: boolean;
    offset: int;
    length: int;
  }
  export class InputChannelEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4002160262;
  SUBCLASS_OF_ID: 1089602301;
  classType: "constructor";
  className: "InputChannelEmpty";
  static fromReader(reader: Reader): InputChannelEmpty;
}
  export class InputChannel extends VirtualClass<{
    channelId: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 4082822184;
  SUBCLASS_OF_ID: 1089602301;
  classType: "constructor";
  className: "InputChannel";
  static fromReader(reader: Reader): InputChannel;
    channelId: long;
    accessHash: long;
  }
  export class InputChannelFromMessage extends VirtualClass<{
    peer: Api.TypeInputPeer;
    msgId: int;
    channelId: long;
  }> {
  CONSTRUCTOR_ID: 1536380829;
  SUBCLASS_OF_ID: 1089602301;
  classType: "constructor";
  className: "InputChannelFromMessage";
  static fromReader(reader: Reader): InputChannelFromMessage;
    peer: Api.TypeInputPeer;
    msgId: int;
    channelId: long;
  }
  export class MessageRange extends VirtualClass<{
    minId: int;
    maxId: int;
  }> {
  CONSTRUCTOR_ID: 182649427;
  SUBCLASS_OF_ID: 3200730487;
  classType: "constructor";
  className: "MessageRange";
  static fromReader(reader: Reader): MessageRange;
    minId: int;
    maxId: int;
  }
  export class ChannelMessagesFilterEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2496933607;
  SUBCLASS_OF_ID: 322136662;
  classType: "constructor";
  className: "ChannelMessagesFilterEmpty";
  static fromReader(reader: Reader): ChannelMessagesFilterEmpty;
}
  export class ChannelMessagesFilter extends VirtualClass<{
    // flags: null;
    excludeNewMessages?: boolean;
    ranges: Api.TypeMessageRange[];
  }> {
  CONSTRUCTOR_ID: 3447183703;
  SUBCLASS_OF_ID: 322136662;
  classType: "constructor";
  className: "ChannelMessagesFilter";
  static fromReader(reader: Reader): ChannelMessagesFilter;
    // flags: null;
    excludeNewMessages?: boolean;
    ranges: Api.TypeMessageRange[];
  }
  export class ChannelParticipant extends VirtualClass<{
    // flags: null;
    userId: long;
    date: int;
    subscriptionUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 3409540633;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipant";
  static fromReader(reader: Reader): ChannelParticipant;
    // flags: null;
    userId: long;
    date: int;
    subscriptionUntilDate?: int;
  }
  export class ChannelParticipantSelf extends VirtualClass<{
    // flags: null;
    viaRequest?: boolean;
    userId: long;
    inviterId: long;
    date: int;
    subscriptionUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 1331723247;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipantSelf";
  static fromReader(reader: Reader): ChannelParticipantSelf;
    // flags: null;
    viaRequest?: boolean;
    userId: long;
    inviterId: long;
    date: int;
    subscriptionUntilDate?: int;
  }
  export class ChannelParticipantCreator extends VirtualClass<{
    // flags: null;
    userId: long;
    adminRights: Api.TypeChatAdminRights;
    rank?: string;
  }> {
  CONSTRUCTOR_ID: 803602899;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipantCreator";
  static fromReader(reader: Reader): ChannelParticipantCreator;
    // flags: null;
    userId: long;
    adminRights: Api.TypeChatAdminRights;
    rank?: string;
  }
  export class ChannelParticipantAdmin extends VirtualClass<{
    // flags: null;
    canEdit?: boolean;
    self?: boolean;
    userId: long;
    inviterId?: long;
    promotedBy: long;
    date: int;
    adminRights: Api.TypeChatAdminRights;
    rank?: string;
  }> {
  CONSTRUCTOR_ID: 885242707;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipantAdmin";
  static fromReader(reader: Reader): ChannelParticipantAdmin;
    // flags: null;
    canEdit?: boolean;
    self?: boolean;
    userId: long;
    inviterId?: long;
    promotedBy: long;
    date: int;
    adminRights: Api.TypeChatAdminRights;
    rank?: string;
  }
  export class ChannelParticipantBanned extends VirtualClass<{
    // flags: null;
    left?: boolean;
    peer: Api.TypePeer;
    kickedBy: long;
    date: int;
    bannedRights: Api.TypeChatBannedRights;
  }> {
  CONSTRUCTOR_ID: 1844969806;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipantBanned";
  static fromReader(reader: Reader): ChannelParticipantBanned;
    // flags: null;
    left?: boolean;
    peer: Api.TypePeer;
    kickedBy: long;
    date: int;
    bannedRights: Api.TypeChatBannedRights;
  }
  export class ChannelParticipantLeft extends VirtualClass<{
    peer: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 453242886;
  SUBCLASS_OF_ID: 3653762072;
  classType: "constructor";
  className: "ChannelParticipantLeft";
  static fromReader(reader: Reader): ChannelParticipantLeft;
    peer: Api.TypePeer;
  }
  export class ChannelParticipantsRecent extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3728686201;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsRecent";
  static fromReader(reader: Reader): ChannelParticipantsRecent;
}
  export class ChannelParticipantsAdmins extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3026225513;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsAdmins";
  static fromReader(reader: Reader): ChannelParticipantsAdmins;
}
  export class ChannelParticipantsKicked extends VirtualClass<{
    q: string;
  }> {
  CONSTRUCTOR_ID: 2746567045;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsKicked";
  static fromReader(reader: Reader): ChannelParticipantsKicked;
    q: string;
  }
  export class ChannelParticipantsBots extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2966521435;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsBots";
  static fromReader(reader: Reader): ChannelParticipantsBots;
}
  export class ChannelParticipantsBanned extends VirtualClass<{
    q: string;
  }> {
  CONSTRUCTOR_ID: 338142689;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsBanned";
  static fromReader(reader: Reader): ChannelParticipantsBanned;
    q: string;
  }
  export class ChannelParticipantsSearch extends VirtualClass<{
    q: string;
  }> {
  CONSTRUCTOR_ID: 106343499;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsSearch";
  static fromReader(reader: Reader): ChannelParticipantsSearch;
    q: string;
  }
  export class ChannelParticipantsContacts extends VirtualClass<{
    q: string;
  }> {
  CONSTRUCTOR_ID: 3144345741;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsContacts";
  static fromReader(reader: Reader): ChannelParticipantsContacts;
    q: string;
  }
  export class ChannelParticipantsMentions extends VirtualClass<{
    // flags: null;
    q?: string;
    topMsgId?: int;
  }> {
  CONSTRUCTOR_ID: 3763035371;
  SUBCLASS_OF_ID: 3209570131;
  classType: "constructor";
  className: "ChannelParticipantsMentions";
  static fromReader(reader: Reader): ChannelParticipantsMentions;
    // flags: null;
    q?: string;
    topMsgId?: int;
  }
  export class InputBotInlineMessageMediaAuto extends VirtualClass<{
    // flags: null;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 864077702;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaAuto";
  static fromReader(reader: Reader): InputBotInlineMessageMediaAuto;
    // flags: null;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageText extends VirtualClass<{
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 1036876423;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageText";
  static fromReader(reader: Reader): InputBotInlineMessageText;
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageMediaGeo extends VirtualClass<{
    // flags: null;
    geoPoint: Api.TypeInputGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 2526190213;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaGeo";
  static fromReader(reader: Reader): InputBotInlineMessageMediaGeo;
    // flags: null;
    geoPoint: Api.TypeInputGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageMediaVenue extends VirtualClass<{
    // flags: null;
    geoPoint: Api.TypeInputGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 1098628881;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaVenue";
  static fromReader(reader: Reader): InputBotInlineMessageMediaVenue;
    // flags: null;
    geoPoint: Api.TypeInputGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageMediaContact extends VirtualClass<{
    // flags: null;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 2800599037;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaContact";
  static fromReader(reader: Reader): InputBotInlineMessageMediaContact;
    // flags: null;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageGame extends VirtualClass<{
    // flags: null;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 1262639204;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageGame";
  static fromReader(reader: Reader): InputBotInlineMessageGame;
    // flags: null;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageMediaInvoice extends VirtualClass<{
    // flags: null;
    title: string;
    description: string;
    photo?: Api.TypeInputWebDocument;
    invoice: Api.TypeInvoice;
    payload: bytes;
    provider: string;
    providerData: Api.TypeDataJSON;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 3622273573;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaInvoice";
  static fromReader(reader: Reader): InputBotInlineMessageMediaInvoice;
    // flags: null;
    title: string;
    description: string;
    photo?: Api.TypeInputWebDocument;
    invoice: Api.TypeInvoice;
    payload: bytes;
    provider: string;
    providerData: Api.TypeDataJSON;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineMessageMediaWebPage extends VirtualClass<{
    // flags: null;
    invertMedia?: boolean;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    optional?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    url: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 3185362192;
  SUBCLASS_OF_ID: 1408974864;
  classType: "constructor";
  className: "InputBotInlineMessageMediaWebPage";
  static fromReader(reader: Reader): InputBotInlineMessageMediaWebPage;
    // flags: null;
    invertMedia?: boolean;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    optional?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    url: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class InputBotInlineResult extends VirtualClass<{
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    url?: string;
    thumb?: Api.TypeInputWebDocument;
    content?: Api.TypeInputWebDocument;
    sendMessage: Api.TypeInputBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 2294256409;
  SUBCLASS_OF_ID: 2158273502;
  classType: "constructor";
  className: "InputBotInlineResult";
  static fromReader(reader: Reader): InputBotInlineResult;
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    url?: string;
    thumb?: Api.TypeInputWebDocument;
    content?: Api.TypeInputWebDocument;
    sendMessage: Api.TypeInputBotInlineMessage;
  }
  export class InputBotInlineResultPhoto extends VirtualClass<{
    id: string;
    type: string;
    photo: Api.TypeInputPhoto;
    sendMessage: Api.TypeInputBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 2832753831;
  SUBCLASS_OF_ID: 2158273502;
  classType: "constructor";
  className: "InputBotInlineResultPhoto";
  static fromReader(reader: Reader): InputBotInlineResultPhoto;
    id: string;
    type: string;
    photo: Api.TypeInputPhoto;
    sendMessage: Api.TypeInputBotInlineMessage;
  }
  export class InputBotInlineResultDocument extends VirtualClass<{
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    document: Api.TypeInputDocument;
    sendMessage: Api.TypeInputBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 4294507972;
  SUBCLASS_OF_ID: 2158273502;
  classType: "constructor";
  className: "InputBotInlineResultDocument";
  static fromReader(reader: Reader): InputBotInlineResultDocument;
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    document: Api.TypeInputDocument;
    sendMessage: Api.TypeInputBotInlineMessage;
  }
  export class InputBotInlineResultGame extends VirtualClass<{
    id: string;
    shortName: string;
    sendMessage: Api.TypeInputBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 1336154098;
  SUBCLASS_OF_ID: 2158273502;
  classType: "constructor";
  className: "InputBotInlineResultGame";
  static fromReader(reader: Reader): InputBotInlineResultGame;
    id: string;
    shortName: string;
    sendMessage: Api.TypeInputBotInlineMessage;
  }
  export class BotInlineMessageMediaAuto extends VirtualClass<{
    // flags: null;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 1984755728;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaAuto";
  static fromReader(reader: Reader): BotInlineMessageMediaAuto;
    // flags: null;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageText extends VirtualClass<{
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 2357159394;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageText";
  static fromReader(reader: Reader): BotInlineMessageText;
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageMediaGeo extends VirtualClass<{
    // flags: null;
    geo: Api.TypeGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 85477117;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaGeo";
  static fromReader(reader: Reader): BotInlineMessageMediaGeo;
    // flags: null;
    geo: Api.TypeGeoPoint;
    heading?: int;
    period?: int;
    proximityNotificationRadius?: int;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageMediaVenue extends VirtualClass<{
    // flags: null;
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 2324063644;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaVenue";
  static fromReader(reader: Reader): BotInlineMessageMediaVenue;
    // flags: null;
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageMediaContact extends VirtualClass<{
    // flags: null;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 416402882;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaContact";
  static fromReader(reader: Reader): BotInlineMessageMediaContact;
    // flags: null;
    phoneNumber: string;
    firstName: string;
    lastName: string;
    vcard: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageMediaInvoice extends VirtualClass<{
    // flags: null;
    shippingAddressRequested?: boolean;
    test?: boolean;
    title: string;
    description: string;
    photo?: Api.TypeWebDocument;
    currency: string;
    totalAmount: long;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 894081801;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaInvoice";
  static fromReader(reader: Reader): BotInlineMessageMediaInvoice;
    // flags: null;
    shippingAddressRequested?: boolean;
    test?: boolean;
    title: string;
    description: string;
    photo?: Api.TypeWebDocument;
    currency: string;
    totalAmount: long;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineMessageMediaWebPage extends VirtualClass<{
    // flags: null;
    invertMedia?: boolean;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    manual?: boolean;
    safe?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    url: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }> {
  CONSTRUCTOR_ID: 2157631910;
  SUBCLASS_OF_ID: 3297841032;
  classType: "constructor";
  className: "BotInlineMessageMediaWebPage";
  static fromReader(reader: Reader): BotInlineMessageMediaWebPage;
    // flags: null;
    invertMedia?: boolean;
    forceLargeMedia?: boolean;
    forceSmallMedia?: boolean;
    manual?: boolean;
    safe?: boolean;
    message: string;
    entities?: Api.TypeMessageEntity[];
    url: string;
    replyMarkup?: Api.TypeReplyMarkup;
  }
  export class BotInlineResult extends VirtualClass<{
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    url?: string;
    thumb?: Api.TypeWebDocument;
    content?: Api.TypeWebDocument;
    sendMessage: Api.TypeBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 295067450;
  SUBCLASS_OF_ID: 942846933;
  classType: "constructor";
  className: "BotInlineResult";
  static fromReader(reader: Reader): BotInlineResult;
    // flags: null;
    id: string;
    type: string;
    title?: string;
    description?: string;
    url?: string;
    thumb?: Api.TypeWebDocument;
    content?: Api.TypeWebDocument;
    sendMessage: Api.TypeBotInlineMessage;
  }
  export class BotInlineMediaResult extends VirtualClass<{
    // flags: null;
    id: string;
    type: string;
    photo?: Api.TypePhoto;
    document?: Api.TypeDocument;
    title?: string;
    description?: string;
    sendMessage: Api.TypeBotInlineMessage;
  }> {
  CONSTRUCTOR_ID: 400266251;
  SUBCLASS_OF_ID: 942846933;
  classType: "constructor";
  className: "BotInlineMediaResult";
  static fromReader(reader: Reader): BotInlineMediaResult;
    // flags: null;
    id: string;
    type: string;
    photo?: Api.TypePhoto;
    document?: Api.TypeDocument;
    title?: string;
    description?: string;
    sendMessage: Api.TypeBotInlineMessage;
  }
  export class ExportedMessageLink extends VirtualClass<{
    link: string;
    html: string;
  }> {
  CONSTRUCTOR_ID: 1571494644;
  SUBCLASS_OF_ID: 3739632844;
  classType: "constructor";
  className: "ExportedMessageLink";
  static fromReader(reader: Reader): ExportedMessageLink;
    link: string;
    html: string;
  }
  export class MessageFwdHeader extends VirtualClass<{
    // flags: null;
    imported?: boolean;
    savedOut?: boolean;
    fromId?: Api.TypePeer;
    fromName?: string;
    date: int;
    channelPost?: int;
    postAuthor?: string;
    savedFromPeer?: Api.TypePeer;
    savedFromMsgId?: int;
    savedFromId?: Api.TypePeer;
    savedFromName?: string;
    savedDate?: int;
    psaType?: string;
  }> {
  CONSTRUCTOR_ID: 1313731771;
  SUBCLASS_OF_ID: 2049468420;
  classType: "constructor";
  className: "MessageFwdHeader";
  static fromReader(reader: Reader): MessageFwdHeader;
    // flags: null;
    imported?: boolean;
    savedOut?: boolean;
    fromId?: Api.TypePeer;
    fromName?: string;
    date: int;
    channelPost?: int;
    postAuthor?: string;
    savedFromPeer?: Api.TypePeer;
    savedFromMsgId?: int;
    savedFromId?: Api.TypePeer;
    savedFromName?: string;
    savedDate?: int;
    psaType?: string;
  }
  export class InputBotInlineMessageID extends VirtualClass<{
    dcId: int;
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 2299280777;
  SUBCLASS_OF_ID: 768434944;
  classType: "constructor";
  className: "InputBotInlineMessageID";
  static fromReader(reader: Reader): InputBotInlineMessageID;
    dcId: int;
    id: long;
    accessHash: long;
  }
  export class InputBotInlineMessageID64 extends VirtualClass<{
    dcId: int;
    ownerId: long;
    id: int;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3067680215;
  SUBCLASS_OF_ID: 768434944;
  classType: "constructor";
  className: "InputBotInlineMessageID64";
  static fromReader(reader: Reader): InputBotInlineMessageID64;
    dcId: int;
    ownerId: long;
    id: int;
    accessHash: long;
  }
  export class InlineBotSwitchPM extends VirtualClass<{
    text: string;
    startParam: string;
  }> {
  CONSTRUCTOR_ID: 1008755359;
  SUBCLASS_OF_ID: 2192701243;
  classType: "constructor";
  className: "InlineBotSwitchPM";
  static fromReader(reader: Reader): InlineBotSwitchPM;
    text: string;
    startParam: string;
  }
  export class TopPeer extends VirtualClass<{
    peer: Api.TypePeer;
    rating: double;
  }> {
  CONSTRUCTOR_ID: 3989684315;
  SUBCLASS_OF_ID: 1763100161;
  classType: "constructor";
  className: "TopPeer";
  static fromReader(reader: Reader): TopPeer;
    peer: Api.TypePeer;
    rating: double;
  }
  export class TopPeerCategoryBotsPM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2875595611;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryBotsPM";
  static fromReader(reader: Reader): TopPeerCategoryBotsPM;
}
  export class TopPeerCategoryBotsInline extends VirtualClass<void> {
  CONSTRUCTOR_ID: 344356834;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryBotsInline";
  static fromReader(reader: Reader): TopPeerCategoryBotsInline;
}
  export class TopPeerCategoryCorrespondents extends VirtualClass<void> {
  CONSTRUCTOR_ID: 104314861;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryCorrespondents";
  static fromReader(reader: Reader): TopPeerCategoryCorrespondents;
}
  export class TopPeerCategoryGroups extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3172442442;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryGroups";
  static fromReader(reader: Reader): TopPeerCategoryGroups;
}
  export class TopPeerCategoryChannels extends VirtualClass<void> {
  CONSTRUCTOR_ID: 371037736;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryChannels";
  static fromReader(reader: Reader): TopPeerCategoryChannels;
}
  export class TopPeerCategoryPhoneCalls extends VirtualClass<void> {
  CONSTRUCTOR_ID: 511092620;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryPhoneCalls";
  static fromReader(reader: Reader): TopPeerCategoryPhoneCalls;
}
  export class TopPeerCategoryForwardUsers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2822794409;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryForwardUsers";
  static fromReader(reader: Reader): TopPeerCategoryForwardUsers;
}
  export class TopPeerCategoryForwardChats extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4226728176;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryForwardChats";
  static fromReader(reader: Reader): TopPeerCategoryForwardChats;
}
  export class TopPeerCategoryBotsApp extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4255022060;
  SUBCLASS_OF_ID: 3723502850;
  classType: "constructor";
  className: "TopPeerCategoryBotsApp";
  static fromReader(reader: Reader): TopPeerCategoryBotsApp;
}
  export class TopPeerCategoryPeers extends VirtualClass<{
    category: Api.TypeTopPeerCategory;
    count: int;
    peers: Api.TypeTopPeer[];
  }> {
  CONSTRUCTOR_ID: 4219683473;
  SUBCLASS_OF_ID: 78563632;
  classType: "constructor";
  className: "TopPeerCategoryPeers";
  static fromReader(reader: Reader): TopPeerCategoryPeers;
    category: Api.TypeTopPeerCategory;
    count: int;
    peers: Api.TypeTopPeer[];
  }
  export class DraftMessageEmpty extends VirtualClass<{
    // flags: null;
    date?: int;
  }> {
  CONSTRUCTOR_ID: 453805082;
  SUBCLASS_OF_ID: 869564229;
  classType: "constructor";
  className: "DraftMessageEmpty";
  static fromReader(reader: Reader): DraftMessageEmpty;
    // flags: null;
    date?: int;
  }
  export class DraftMessage extends VirtualClass<{
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    replyTo?: Api.TypeInputReplyTo;
    message: string;
    entities?: Api.TypeMessageEntity[];
    media?: Api.TypeInputMedia;
    date: int;
    effect?: long;
  }> {
  CONSTRUCTOR_ID: 761606687;
  SUBCLASS_OF_ID: 869564229;
  classType: "constructor";
  className: "DraftMessage";
  static fromReader(reader: Reader): DraftMessage;
    // flags: null;
    noWebpage?: boolean;
    invertMedia?: boolean;
    replyTo?: Api.TypeInputReplyTo;
    message: string;
    entities?: Api.TypeMessageEntity[];
    media?: Api.TypeInputMedia;
    date: int;
    effect?: long;
  }
  export class StickerSetCovered extends VirtualClass<{
    set: Api.TypeStickerSet;
    cover: Api.TypeDocument;
  }> {
  CONSTRUCTOR_ID: 1678812626;
  SUBCLASS_OF_ID: 2139546853;
  classType: "constructor";
  className: "StickerSetCovered";
  static fromReader(reader: Reader): StickerSetCovered;
    set: Api.TypeStickerSet;
    cover: Api.TypeDocument;
  }
  export class StickerSetMultiCovered extends VirtualClass<{
    set: Api.TypeStickerSet;
    covers: Api.TypeDocument[];
  }> {
  CONSTRUCTOR_ID: 872932635;
  SUBCLASS_OF_ID: 2139546853;
  classType: "constructor";
  className: "StickerSetMultiCovered";
  static fromReader(reader: Reader): StickerSetMultiCovered;
    set: Api.TypeStickerSet;
    covers: Api.TypeDocument[];
  }
  export class StickerSetFullCovered extends VirtualClass<{
    set: Api.TypeStickerSet;
    packs: Api.TypeStickerPack[];
    keywords: Api.TypeStickerKeyword[];
    documents: Api.TypeDocument[];
  }> {
  CONSTRUCTOR_ID: 1087454222;
  SUBCLASS_OF_ID: 2139546853;
  classType: "constructor";
  className: "StickerSetFullCovered";
  static fromReader(reader: Reader): StickerSetFullCovered;
    set: Api.TypeStickerSet;
    packs: Api.TypeStickerPack[];
    keywords: Api.TypeStickerKeyword[];
    documents: Api.TypeDocument[];
  }
  export class StickerSetNoCovered extends VirtualClass<{
    set: Api.TypeStickerSet;
  }> {
  CONSTRUCTOR_ID: 2008112412;
  SUBCLASS_OF_ID: 2139546853;
  classType: "constructor";
  className: "StickerSetNoCovered";
  static fromReader(reader: Reader): StickerSetNoCovered;
    set: Api.TypeStickerSet;
  }
  export class MaskCoords extends VirtualClass<{
    n: int;
    x: double;
    y: double;
    zoom: double;
  }> {
  CONSTRUCTOR_ID: 2933316530;
  SUBCLASS_OF_ID: 112964349;
  classType: "constructor";
  className: "MaskCoords";
  static fromReader(reader: Reader): MaskCoords;
    n: int;
    x: double;
    y: double;
    zoom: double;
  }
  export class InputStickeredMediaPhoto extends VirtualClass<{
    id: Api.TypeInputPhoto;
  }> {
  CONSTRUCTOR_ID: 1251549527;
  SUBCLASS_OF_ID: 1363597726;
  classType: "constructor";
  className: "InputStickeredMediaPhoto";
  static fromReader(reader: Reader): InputStickeredMediaPhoto;
    id: Api.TypeInputPhoto;
  }
  export class InputStickeredMediaDocument extends VirtualClass<{
    id: Api.TypeInputDocument;
  }> {
  CONSTRUCTOR_ID: 70813275;
  SUBCLASS_OF_ID: 1363597726;
  classType: "constructor";
  className: "InputStickeredMediaDocument";
  static fromReader(reader: Reader): InputStickeredMediaDocument;
    id: Api.TypeInputDocument;
  }
  export class Game extends VirtualClass<{
    // flags: null;
    id: long;
    accessHash: long;
    shortName: string;
    title: string;
    description: string;
    photo: Api.TypePhoto;
    document?: Api.TypeDocument;
  }> {
  CONSTRUCTOR_ID: 3187238203;
  SUBCLASS_OF_ID: 2199494322;
  classType: "constructor";
  className: "Game";
  static fromReader(reader: Reader): Game;
    // flags: null;
    id: long;
    accessHash: long;
    shortName: string;
    title: string;
    description: string;
    photo: Api.TypePhoto;
    document?: Api.TypeDocument;
  }
  export class InputGameID extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 53231223;
  SUBCLASS_OF_ID: 1221679235;
  classType: "constructor";
  className: "InputGameID";
  static fromReader(reader: Reader): InputGameID;
    id: long;
    accessHash: long;
  }
  export class InputGameShortName extends VirtualClass<{
    botId: Api.TypeInputUser;
    shortName: string;
  }> {
  CONSTRUCTOR_ID: 3274827786;
  SUBCLASS_OF_ID: 1221679235;
  classType: "constructor";
  className: "InputGameShortName";
  static fromReader(reader: Reader): InputGameShortName;
    botId: Api.TypeInputUser;
    shortName: string;
  }
  export class HighScore extends VirtualClass<{
    pos: int;
    userId: long;
    score: int;
  }> {
  CONSTRUCTOR_ID: 1940093419;
  SUBCLASS_OF_ID: 3542818357;
  classType: "constructor";
  className: "HighScore";
  static fromReader(reader: Reader): HighScore;
    pos: int;
    userId: long;
    score: int;
  }
  export class TextEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3695018575;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextEmpty";
  static fromReader(reader: Reader): TextEmpty;
}
  export class TextPlain extends VirtualClass<{
    text: string;
  }> {
  CONSTRUCTOR_ID: 1950782688;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextPlain";
  static fromReader(reader: Reader): TextPlain;
    text: string;
  }
  export class TextBold extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1730456516;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextBold";
  static fromReader(reader: Reader): TextBold;
    text: Api.TypeRichText;
  }
  export class TextItalic extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3641877916;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextItalic";
  static fromReader(reader: Reader): TextItalic;
    text: Api.TypeRichText;
  }
  export class TextUnderline extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3240501956;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextUnderline";
  static fromReader(reader: Reader): TextUnderline;
    text: Api.TypeRichText;
  }
  export class TextStrike extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 2616769429;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextStrike";
  static fromReader(reader: Reader): TextStrike;
    text: Api.TypeRichText;
  }
  export class TextFixed extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1816074681;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextFixed";
  static fromReader(reader: Reader): TextFixed;
    text: Api.TypeRichText;
  }
  export class TextUrl extends VirtualClass<{
    text: Api.TypeRichText;
    url: string;
    webpageId: long;
  }> {
  CONSTRUCTOR_ID: 1009288385;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextUrl";
  static fromReader(reader: Reader): TextUrl;
    text: Api.TypeRichText;
    url: string;
    webpageId: long;
  }
  export class TextEmail extends VirtualClass<{
    text: Api.TypeRichText;
    email: string;
  }> {
  CONSTRUCTOR_ID: 3730443734;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextEmail";
  static fromReader(reader: Reader): TextEmail;
    text: Api.TypeRichText;
    email: string;
  }
  export class TextConcat extends VirtualClass<{
    texts: Api.TypeRichText[];
  }> {
  CONSTRUCTOR_ID: 2120376535;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextConcat";
  static fromReader(reader: Reader): TextConcat;
    texts: Api.TypeRichText[];
  }
  export class TextSubscript extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3983181060;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextSubscript";
  static fromReader(reader: Reader): TextSubscript;
    text: Api.TypeRichText;
  }
  export class TextSuperscript extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3355139585;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextSuperscript";
  static fromReader(reader: Reader): TextSuperscript;
    text: Api.TypeRichText;
  }
  export class TextMarked extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 55281185;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextMarked";
  static fromReader(reader: Reader): TextMarked;
    text: Api.TypeRichText;
  }
  export class TextPhone extends VirtualClass<{
    text: Api.TypeRichText;
    phone: string;
  }> {
  CONSTRUCTOR_ID: 483104362;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextPhone";
  static fromReader(reader: Reader): TextPhone;
    text: Api.TypeRichText;
    phone: string;
  }
  export class TextImage extends VirtualClass<{
    documentId: long;
    w: int;
    h: int;
  }> {
  CONSTRUCTOR_ID: 136105807;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextImage";
  static fromReader(reader: Reader): TextImage;
    documentId: long;
    w: int;
    h: int;
  }
  export class TextAnchor extends VirtualClass<{
    text: Api.TypeRichText;
    name: string;
  }> {
  CONSTRUCTOR_ID: 894777186;
  SUBCLASS_OF_ID: 4056986745;
  classType: "constructor";
  className: "TextAnchor";
  static fromReader(reader: Reader): TextAnchor;
    text: Api.TypeRichText;
    name: string;
  }
  export class PageBlockUnsupported extends VirtualClass<void> {
  CONSTRUCTOR_ID: 324435594;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockUnsupported";
  static fromReader(reader: Reader): PageBlockUnsupported;
}
  export class PageBlockTitle extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1890305021;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockTitle";
  static fromReader(reader: Reader): PageBlockTitle;
    text: Api.TypeRichText;
  }
  export class PageBlockSubtitle extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 2415565343;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockSubtitle";
  static fromReader(reader: Reader): PageBlockSubtitle;
    text: Api.TypeRichText;
  }
  export class PageBlockAuthorDate extends VirtualClass<{
    author: Api.TypeRichText;
    publishedDate: int;
  }> {
  CONSTRUCTOR_ID: 3132089824;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockAuthorDate";
  static fromReader(reader: Reader): PageBlockAuthorDate;
    author: Api.TypeRichText;
    publishedDate: int;
  }
  export class PageBlockHeader extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3218105580;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockHeader";
  static fromReader(reader: Reader): PageBlockHeader;
    text: Api.TypeRichText;
  }
  export class PageBlockSubheader extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 4046173921;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockSubheader";
  static fromReader(reader: Reader): PageBlockSubheader;
    text: Api.TypeRichText;
  }
  export class PageBlockParagraph extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1182402406;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockParagraph";
  static fromReader(reader: Reader): PageBlockParagraph;
    text: Api.TypeRichText;
  }
  export class PageBlockPreformatted extends VirtualClass<{
    text: Api.TypeRichText;
    language: string;
  }> {
  CONSTRUCTOR_ID: 3228621118;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockPreformatted";
  static fromReader(reader: Reader): PageBlockPreformatted;
    text: Api.TypeRichText;
    language: string;
  }
  export class PageBlockFooter extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1216809369;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockFooter";
  static fromReader(reader: Reader): PageBlockFooter;
    text: Api.TypeRichText;
  }
  export class PageBlockDivider extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3676352904;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockDivider";
  static fromReader(reader: Reader): PageBlockDivider;
}
  export class PageBlockAnchor extends VirtualClass<{
    name: string;
  }> {
  CONSTRUCTOR_ID: 3456972720;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockAnchor";
  static fromReader(reader: Reader): PageBlockAnchor;
    name: string;
  }
  export class PageBlockList extends VirtualClass<{
    items: Api.TypePageListItem[];
  }> {
  CONSTRUCTOR_ID: 3840442385;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockList";
  static fromReader(reader: Reader): PageBlockList;
    items: Api.TypePageListItem[];
  }
  export class PageBlockBlockquote extends VirtualClass<{
    text: Api.TypeRichText;
    caption: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 641563686;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockBlockquote";
  static fromReader(reader: Reader): PageBlockBlockquote;
    text: Api.TypeRichText;
    caption: Api.TypeRichText;
  }
  export class PageBlockPullquote extends VirtualClass<{
    text: Api.TypeRichText;
    caption: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1329878739;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockPullquote";
  static fromReader(reader: Reader): PageBlockPullquote;
    text: Api.TypeRichText;
    caption: Api.TypeRichText;
  }
  export class PageBlockPhoto extends VirtualClass<{
    // flags: null;
    photoId: long;
    caption: Api.TypePageCaption;
    url?: string;
    webpageId?: long;
  }> {
  CONSTRUCTOR_ID: 391759200;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockPhoto";
  static fromReader(reader: Reader): PageBlockPhoto;
    // flags: null;
    photoId: long;
    caption: Api.TypePageCaption;
    url?: string;
    webpageId?: long;
  }
  export class PageBlockVideo extends VirtualClass<{
    // flags: null;
    autoplay?: boolean;
    loop?: boolean;
    videoId: long;
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 2089805750;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockVideo";
  static fromReader(reader: Reader): PageBlockVideo;
    // flags: null;
    autoplay?: boolean;
    loop?: boolean;
    videoId: long;
    caption: Api.TypePageCaption;
  }
  export class PageBlockCover extends VirtualClass<{
    cover: Api.TypePageBlock;
  }> {
  CONSTRUCTOR_ID: 972174080;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockCover";
  static fromReader(reader: Reader): PageBlockCover;
    cover: Api.TypePageBlock;
  }
  export class PageBlockEmbed extends VirtualClass<{
    // flags: null;
    fullWidth?: boolean;
    allowScrolling?: boolean;
    url?: string;
    html?: string;
    posterPhotoId?: long;
    w?: int;
    h?: int;
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 2826014149;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockEmbed";
  static fromReader(reader: Reader): PageBlockEmbed;
    // flags: null;
    fullWidth?: boolean;
    allowScrolling?: boolean;
    url?: string;
    html?: string;
    posterPhotoId?: long;
    w?: int;
    h?: int;
    caption: Api.TypePageCaption;
  }
  export class PageBlockEmbedPost extends VirtualClass<{
    url: string;
    webpageId: long;
    authorPhotoId: long;
    author: string;
    date: int;
    blocks: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 4065961995;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockEmbedPost";
  static fromReader(reader: Reader): PageBlockEmbedPost;
    url: string;
    webpageId: long;
    authorPhotoId: long;
    author: string;
    date: int;
    blocks: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }
  export class PageBlockCollage extends VirtualClass<{
    items: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 1705048653;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockCollage";
  static fromReader(reader: Reader): PageBlockCollage;
    items: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }
  export class PageBlockSlideshow extends VirtualClass<{
    items: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 52401552;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockSlideshow";
  static fromReader(reader: Reader): PageBlockSlideshow;
    items: Api.TypePageBlock[];
    caption: Api.TypePageCaption;
  }
  export class PageBlockChannel extends VirtualClass<{
    channel: Api.TypeChat;
  }> {
  CONSTRUCTOR_ID: 4011282869;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockChannel";
  static fromReader(reader: Reader): PageBlockChannel;
    channel: Api.TypeChat;
  }
  export class PageBlockAudio extends VirtualClass<{
    audioId: long;
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 2151899626;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockAudio";
  static fromReader(reader: Reader): PageBlockAudio;
    audioId: long;
    caption: Api.TypePageCaption;
  }
  export class PageBlockKicker extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 504660880;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockKicker";
  static fromReader(reader: Reader): PageBlockKicker;
    text: Api.TypeRichText;
  }
  export class PageBlockTable extends VirtualClass<{
    // flags: null;
    bordered?: boolean;
    striped?: boolean;
    title: Api.TypeRichText;
    rows: Api.TypePageTableRow[];
  }> {
  CONSTRUCTOR_ID: 3209554562;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockTable";
  static fromReader(reader: Reader): PageBlockTable;
    // flags: null;
    bordered?: boolean;
    striped?: boolean;
    title: Api.TypeRichText;
    rows: Api.TypePageTableRow[];
  }
  export class PageBlockOrderedList extends VirtualClass<{
    items: Api.TypePageListOrderedItem[];
  }> {
  CONSTRUCTOR_ID: 2592793057;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockOrderedList";
  static fromReader(reader: Reader): PageBlockOrderedList;
    items: Api.TypePageListOrderedItem[];
  }
  export class PageBlockDetails extends VirtualClass<{
    // flags: null;
    open?: boolean;
    blocks: Api.TypePageBlock[];
    title: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1987480557;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockDetails";
  static fromReader(reader: Reader): PageBlockDetails;
    // flags: null;
    open?: boolean;
    blocks: Api.TypePageBlock[];
    title: Api.TypeRichText;
  }
  export class PageBlockRelatedArticles extends VirtualClass<{
    title: Api.TypeRichText;
    articles: Api.TypePageRelatedArticle[];
  }> {
  CONSTRUCTOR_ID: 370236054;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockRelatedArticles";
  static fromReader(reader: Reader): PageBlockRelatedArticles;
    title: Api.TypeRichText;
    articles: Api.TypePageRelatedArticle[];
  }
  export class PageBlockMap extends VirtualClass<{
    geo: Api.TypeGeoPoint;
    zoom: int;
    w: int;
    h: int;
    caption: Api.TypePageCaption;
  }> {
  CONSTRUCTOR_ID: 2756656886;
  SUBCLASS_OF_ID: 449467972;
  classType: "constructor";
  className: "PageBlockMap";
  static fromReader(reader: Reader): PageBlockMap;
    geo: Api.TypeGeoPoint;
    zoom: int;
    w: int;
    h: int;
    caption: Api.TypePageCaption;
  }
  export class PhoneCallDiscardReasonMissed extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2246320897;
  SUBCLASS_OF_ID: 3634081085;
  classType: "constructor";
  className: "PhoneCallDiscardReasonMissed";
  static fromReader(reader: Reader): PhoneCallDiscardReasonMissed;
}
  export class PhoneCallDiscardReasonDisconnect extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3767910816;
  SUBCLASS_OF_ID: 3634081085;
  classType: "constructor";
  className: "PhoneCallDiscardReasonDisconnect";
  static fromReader(reader: Reader): PhoneCallDiscardReasonDisconnect;
}
  export class PhoneCallDiscardReasonHangup extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1471006352;
  SUBCLASS_OF_ID: 3634081085;
  classType: "constructor";
  className: "PhoneCallDiscardReasonHangup";
  static fromReader(reader: Reader): PhoneCallDiscardReasonHangup;
}
  export class PhoneCallDiscardReasonBusy extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4210550985;
  SUBCLASS_OF_ID: 3634081085;
  classType: "constructor";
  className: "PhoneCallDiscardReasonBusy";
  static fromReader(reader: Reader): PhoneCallDiscardReasonBusy;
}
  export class PhoneCallDiscardReasonAllowGroupCall extends VirtualClass<{
    encryptedKey: bytes;
  }> {
  CONSTRUCTOR_ID: 2950871097;
  SUBCLASS_OF_ID: 3634081085;
  classType: "constructor";
  className: "PhoneCallDiscardReasonAllowGroupCall";
  static fromReader(reader: Reader): PhoneCallDiscardReasonAllowGroupCall;
    encryptedKey: bytes;
  }
  export class DataJSON extends VirtualClass<{
    data: string;
  }> {
  CONSTRUCTOR_ID: 2104790276;
  SUBCLASS_OF_ID: 2902676200;
  classType: "constructor";
  className: "DataJSON";
  static fromReader(reader: Reader): DataJSON;
    data: string;
  }
  export class LabeledPrice extends VirtualClass<{
    label: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 3408489464;
  SUBCLASS_OF_ID: 478413946;
  classType: "constructor";
  className: "LabeledPrice";
  static fromReader(reader: Reader): LabeledPrice;
    label: string;
    amount: long;
  }
  export class Invoice extends VirtualClass<{
    // flags: null;
    test?: boolean;
    nameRequested?: boolean;
    phoneRequested?: boolean;
    emailRequested?: boolean;
    shippingAddressRequested?: boolean;
    flexible?: boolean;
    phoneToProvider?: boolean;
    emailToProvider?: boolean;
    recurring?: boolean;
    currency: string;
    prices: Api.TypeLabeledPrice[];
    maxTipAmount?: long;
    suggestedTipAmounts?: long[];
    termsUrl?: string;
    subscriptionPeriod?: int;
  }> {
  CONSTRUCTOR_ID: 77522308;
  SUBCLASS_OF_ID: 1608003288;
  classType: "constructor";
  className: "Invoice";
  static fromReader(reader: Reader): Invoice;
    // flags: null;
    test?: boolean;
    nameRequested?: boolean;
    phoneRequested?: boolean;
    emailRequested?: boolean;
    shippingAddressRequested?: boolean;
    flexible?: boolean;
    phoneToProvider?: boolean;
    emailToProvider?: boolean;
    recurring?: boolean;
    currency: string;
    prices: Api.TypeLabeledPrice[];
    maxTipAmount?: long;
    suggestedTipAmounts?: long[];
    termsUrl?: string;
    subscriptionPeriod?: int;
  }
  export class PaymentCharge extends VirtualClass<{
    id: string;
    providerChargeId: string;
  }> {
  CONSTRUCTOR_ID: 3926049406;
  SUBCLASS_OF_ID: 1019752665;
  classType: "constructor";
  className: "PaymentCharge";
  static fromReader(reader: Reader): PaymentCharge;
    id: string;
    providerChargeId: string;
  }
  export class PostAddress extends VirtualClass<{
    streetLine1: string;
    streetLine2: string;
    city: string;
    state: string;
    countryIso2: string;
    postCode: string;
  }> {
  CONSTRUCTOR_ID: 512535275;
  SUBCLASS_OF_ID: 2373900844;
  classType: "constructor";
  className: "PostAddress";
  static fromReader(reader: Reader): PostAddress;
    streetLine1: string;
    streetLine2: string;
    city: string;
    state: string;
    countryIso2: string;
    postCode: string;
  }
  export class PaymentRequestedInfo extends VirtualClass<{
    // flags: null;
    name?: string;
    phone?: string;
    email?: string;
    shippingAddress?: Api.TypePostAddress;
  }> {
  CONSTRUCTOR_ID: 2426158996;
  SUBCLASS_OF_ID: 2377134406;
  classType: "constructor";
  className: "PaymentRequestedInfo";
  static fromReader(reader: Reader): PaymentRequestedInfo;
    // flags: null;
    name?: string;
    phone?: string;
    email?: string;
    shippingAddress?: Api.TypePostAddress;
  }
  export class PaymentSavedCredentialsCard extends VirtualClass<{
    id: string;
    title: string;
  }> {
  CONSTRUCTOR_ID: 3452074527;
  SUBCLASS_OF_ID: 3009576675;
  classType: "constructor";
  className: "PaymentSavedCredentialsCard";
  static fromReader(reader: Reader): PaymentSavedCredentialsCard;
    id: string;
    title: string;
  }
  export class WebDocument extends VirtualClass<{
    url: string;
    accessHash: long;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }> {
  CONSTRUCTOR_ID: 475467473;
  SUBCLASS_OF_ID: 996419604;
  classType: "constructor";
  className: "WebDocument";
  static fromReader(reader: Reader): WebDocument;
    url: string;
    accessHash: long;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }
  export class WebDocumentNoProxy extends VirtualClass<{
    url: string;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }> {
  CONSTRUCTOR_ID: 4190682310;
  SUBCLASS_OF_ID: 996419604;
  classType: "constructor";
  className: "WebDocumentNoProxy";
  static fromReader(reader: Reader): WebDocumentNoProxy;
    url: string;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }
  export class InputWebDocument extends VirtualClass<{
    url: string;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }> {
  CONSTRUCTOR_ID: 2616017741;
  SUBCLASS_OF_ID: 2330505542;
  classType: "constructor";
  className: "InputWebDocument";
  static fromReader(reader: Reader): InputWebDocument;
    url: string;
    size: int;
    mimeType: string;
    attributes: Api.TypeDocumentAttribute[];
  }
  export class InputWebFileLocation extends VirtualClass<{
    url: string;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3258570374;
  SUBCLASS_OF_ID: 4147042521;
  classType: "constructor";
  className: "InputWebFileLocation";
  static fromReader(reader: Reader): InputWebFileLocation;
    url: string;
    accessHash: long;
  }
  export class InputWebFileGeoPointLocation extends VirtualClass<{
    geoPoint: Api.TypeInputGeoPoint;
    accessHash: long;
    w: int;
    h: int;
    zoom: int;
    scale: int;
  }> {
  CONSTRUCTOR_ID: 2669814217;
  SUBCLASS_OF_ID: 4147042521;
  classType: "constructor";
  className: "InputWebFileGeoPointLocation";
  static fromReader(reader: Reader): InputWebFileGeoPointLocation;
    geoPoint: Api.TypeInputGeoPoint;
    accessHash: long;
    w: int;
    h: int;
    zoom: int;
    scale: int;
  }
  export class InputWebFileAudioAlbumThumbLocation extends VirtualClass<{
    // flags: null;
    small?: boolean;
    document?: Api.TypeInputDocument;
    title?: string;
    performer?: string;
  }> {
  CONSTRUCTOR_ID: 4100974884;
  SUBCLASS_OF_ID: 4147042521;
  classType: "constructor";
  className: "InputWebFileAudioAlbumThumbLocation";
  static fromReader(reader: Reader): InputWebFileAudioAlbumThumbLocation;
    // flags: null;
    small?: boolean;
    document?: Api.TypeInputDocument;
    title?: string;
    performer?: string;
  }
  export class InputPaymentCredentialsSaved extends VirtualClass<{
    id: string;
    tmpPassword: bytes;
  }> {
  CONSTRUCTOR_ID: 3238965967;
  SUBCLASS_OF_ID: 681157949;
  classType: "constructor";
  className: "InputPaymentCredentialsSaved";
  static fromReader(reader: Reader): InputPaymentCredentialsSaved;
    id: string;
    tmpPassword: bytes;
  }
  export class InputPaymentCredentials extends VirtualClass<{
    // flags: null;
    save?: boolean;
    data: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 873977640;
  SUBCLASS_OF_ID: 681157949;
  classType: "constructor";
  className: "InputPaymentCredentials";
  static fromReader(reader: Reader): InputPaymentCredentials;
    // flags: null;
    save?: boolean;
    data: Api.TypeDataJSON;
  }
  export class InputPaymentCredentialsApplePay extends VirtualClass<{
    paymentData: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 178373535;
  SUBCLASS_OF_ID: 681157949;
  classType: "constructor";
  className: "InputPaymentCredentialsApplePay";
  static fromReader(reader: Reader): InputPaymentCredentialsApplePay;
    paymentData: Api.TypeDataJSON;
  }
  export class InputPaymentCredentialsGooglePay extends VirtualClass<{
    paymentToken: Api.TypeDataJSON;
  }> {
  CONSTRUCTOR_ID: 2328045569;
  SUBCLASS_OF_ID: 681157949;
  classType: "constructor";
  className: "InputPaymentCredentialsGooglePay";
  static fromReader(reader: Reader): InputPaymentCredentialsGooglePay;
    paymentToken: Api.TypeDataJSON;
  }
  export class ShippingOption extends VirtualClass<{
    id: string;
    title: string;
    prices: Api.TypeLabeledPrice[];
  }> {
  CONSTRUCTOR_ID: 3055631583;
  SUBCLASS_OF_ID: 4108930168;
  classType: "constructor";
  className: "ShippingOption";
  static fromReader(reader: Reader): ShippingOption;
    id: string;
    title: string;
    prices: Api.TypeLabeledPrice[];
  }
  export class InputStickerSetItem extends VirtualClass<{
    // flags: null;
    document: Api.TypeInputDocument;
    emoji: string;
    maskCoords?: Api.TypeMaskCoords;
    keywords?: string;
  }> {
  CONSTRUCTOR_ID: 853188252;
  SUBCLASS_OF_ID: 2925129845;
  classType: "constructor";
  className: "InputStickerSetItem";
  static fromReader(reader: Reader): InputStickerSetItem;
    // flags: null;
    document: Api.TypeInputDocument;
    emoji: string;
    maskCoords?: Api.TypeMaskCoords;
    keywords?: string;
  }
  export class InputPhoneCall extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 506920429;
  SUBCLASS_OF_ID: 3165319744;
  classType: "constructor";
  className: "InputPhoneCall";
  static fromReader(reader: Reader): InputPhoneCall;
    id: long;
    accessHash: long;
  }
  export class PhoneCallEmpty extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 1399245077;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCallEmpty";
  static fromReader(reader: Reader): PhoneCallEmpty;
    id: long;
  }
  export class PhoneCallWaiting extends VirtualClass<{
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    protocol: Api.TypePhoneCallProtocol;
    receiveDate?: int;
    conferenceCall?: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 4006881368;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCallWaiting";
  static fromReader(reader: Reader): PhoneCallWaiting;
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    protocol: Api.TypePhoneCallProtocol;
    receiveDate?: int;
    conferenceCall?: Api.TypeInputGroupCall;
  }
  export class PhoneCallRequested extends VirtualClass<{
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAHash: bytes;
    protocol: Api.TypePhoneCallProtocol;
    conferenceCall?: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 1161174115;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCallRequested";
  static fromReader(reader: Reader): PhoneCallRequested;
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAHash: bytes;
    protocol: Api.TypePhoneCallProtocol;
    conferenceCall?: Api.TypeInputGroupCall;
  }
  export class PhoneCallAccepted extends VirtualClass<{
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gB: bytes;
    protocol: Api.TypePhoneCallProtocol;
    conferenceCall?: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 587035009;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCallAccepted";
  static fromReader(reader: Reader): PhoneCallAccepted;
    // flags: null;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gB: bytes;
    protocol: Api.TypePhoneCallProtocol;
    conferenceCall?: Api.TypeInputGroupCall;
  }
  export class PhoneCall extends VirtualClass<{
    // flags: null;
    p2pAllowed?: boolean;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAOrB: bytes;
    keyFingerprint: long;
    protocol: Api.TypePhoneCallProtocol;
    connections: Api.TypePhoneConnection[];
    startDate: int;
    customParameters?: Api.TypeDataJSON;
    conferenceCall?: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 1000707084;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCall";
  static fromReader(reader: Reader): PhoneCall;
    // flags: null;
    p2pAllowed?: boolean;
    video?: boolean;
    id: long;
    accessHash: long;
    date: int;
    adminId: long;
    participantId: long;
    gAOrB: bytes;
    keyFingerprint: long;
    protocol: Api.TypePhoneCallProtocol;
    connections: Api.TypePhoneConnection[];
    startDate: int;
    customParameters?: Api.TypeDataJSON;
    conferenceCall?: Api.TypeInputGroupCall;
  }
  export class PhoneCallDiscarded extends VirtualClass<{
    // flags: null;
    needRating?: boolean;
    needDebug?: boolean;
    video?: boolean;
    id: long;
    reason?: Api.TypePhoneCallDiscardReason;
    duration?: int;
    conferenceCall?: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 4191311107;
  SUBCLASS_OF_ID: 3296664529;
  classType: "constructor";
  className: "PhoneCallDiscarded";
  static fromReader(reader: Reader): PhoneCallDiscarded;
    // flags: null;
    needRating?: boolean;
    needDebug?: boolean;
    video?: boolean;
    id: long;
    reason?: Api.TypePhoneCallDiscardReason;
    duration?: int;
    conferenceCall?: Api.TypeInputGroupCall;
  }
  export class PhoneConnection extends VirtualClass<{
    // flags: null;
    tcp?: boolean;
    id: long;
    ip: string;
    ipv6: string;
    port: int;
    peerTag: bytes;
  }> {
  CONSTRUCTOR_ID: 2629903303;
  SUBCLASS_OF_ID: 2861425677;
  classType: "constructor";
  className: "PhoneConnection";
  static fromReader(reader: Reader): PhoneConnection;
    // flags: null;
    tcp?: boolean;
    id: long;
    ip: string;
    ipv6: string;
    port: int;
    peerTag: bytes;
  }
  export class PhoneConnectionWebrtc extends VirtualClass<{
    // flags: null;
    turn?: boolean;
    stun?: boolean;
    id: long;
    ip: string;
    ipv6: string;
    port: int;
    username: string;
    password: string;
  }> {
  CONSTRUCTOR_ID: 1667228533;
  SUBCLASS_OF_ID: 2861425677;
  classType: "constructor";
  className: "PhoneConnectionWebrtc";
  static fromReader(reader: Reader): PhoneConnectionWebrtc;
    // flags: null;
    turn?: boolean;
    stun?: boolean;
    id: long;
    ip: string;
    ipv6: string;
    port: int;
    username: string;
    password: string;
  }
  export class PhoneCallProtocol extends VirtualClass<{
    // flags: null;
    udpP2p?: boolean;
    udpReflector?: boolean;
    minLayer: int;
    maxLayer: int;
    libraryVersions: string[];
  }> {
  CONSTRUCTOR_ID: 4236742600;
  SUBCLASS_OF_ID: 2017038755;
  classType: "constructor";
  className: "PhoneCallProtocol";
  static fromReader(reader: Reader): PhoneCallProtocol;
    // flags: null;
    udpP2p?: boolean;
    udpReflector?: boolean;
    minLayer: int;
    maxLayer: int;
    libraryVersions: string[];
  }
  export class CdnPublicKey extends VirtualClass<{
    dcId: int;
    publicKey: string;
  }> {
  CONSTRUCTOR_ID: 3380800186;
  SUBCLASS_OF_ID: 383469555;
  classType: "constructor";
  className: "CdnPublicKey";
  static fromReader(reader: Reader): CdnPublicKey;
    dcId: int;
    publicKey: string;
  }
  export class CdnConfig extends VirtualClass<{
    publicKeys: Api.TypeCdnPublicKey[];
  }> {
  CONSTRUCTOR_ID: 1462101002;
  SUBCLASS_OF_ID: 3973724540;
  classType: "constructor";
  className: "CdnConfig";
  static fromReader(reader: Reader): CdnConfig;
    publicKeys: Api.TypeCdnPublicKey[];
  }
  export class LangPackString extends VirtualClass<{
    key: string;
    value: string;
  }> {
  CONSTRUCTOR_ID: 3402727926;
  SUBCLASS_OF_ID: 3692534457;
  classType: "constructor";
  className: "LangPackString";
  static fromReader(reader: Reader): LangPackString;
    key: string;
    value: string;
  }
  export class LangPackStringPluralized extends VirtualClass<{
    // flags: null;
    key: string;
    zeroValue?: string;
    oneValue?: string;
    twoValue?: string;
    fewValue?: string;
    manyValue?: string;
    otherValue: string;
  }> {
  CONSTRUCTOR_ID: 1816636575;
  SUBCLASS_OF_ID: 3692534457;
  classType: "constructor";
  className: "LangPackStringPluralized";
  static fromReader(reader: Reader): LangPackStringPluralized;
    // flags: null;
    key: string;
    zeroValue?: string;
    oneValue?: string;
    twoValue?: string;
    fewValue?: string;
    manyValue?: string;
    otherValue: string;
  }
  export class LangPackStringDeleted extends VirtualClass<{
    key: string;
  }> {
  CONSTRUCTOR_ID: 695856818;
  SUBCLASS_OF_ID: 3692534457;
  classType: "constructor";
  className: "LangPackStringDeleted";
  static fromReader(reader: Reader): LangPackStringDeleted;
    key: string;
  }
  export class LangPackDifference extends VirtualClass<{
    langCode: string;
    fromVersion: int;
    version: int;
    strings: Api.TypeLangPackString[];
  }> {
  CONSTRUCTOR_ID: 4085629430;
  SUBCLASS_OF_ID: 1382427989;
  classType: "constructor";
  className: "LangPackDifference";
  static fromReader(reader: Reader): LangPackDifference;
    langCode: string;
    fromVersion: int;
    version: int;
    strings: Api.TypeLangPackString[];
  }
  export class LangPackLanguage extends VirtualClass<{
    // flags: null;
    official?: boolean;
    rtl?: boolean;
    beta?: boolean;
    name: string;
    nativeName: string;
    langCode: string;
    baseLangCode?: string;
    pluralCode: string;
    stringsCount: int;
    translatedCount: int;
    translationsUrl: string;
  }> {
  CONSTRUCTOR_ID: 4006239459;
  SUBCLASS_OF_ID: 2880211383;
  classType: "constructor";
  className: "LangPackLanguage";
  static fromReader(reader: Reader): LangPackLanguage;
    // flags: null;
    official?: boolean;
    rtl?: boolean;
    beta?: boolean;
    name: string;
    nativeName: string;
    langCode: string;
    baseLangCode?: string;
    pluralCode: string;
    stringsCount: int;
    translatedCount: int;
    translationsUrl: string;
  }
  export class ChannelAdminLogEventActionChangeTitle extends VirtualClass<{
    prevValue: string;
    newValue: string;
  }> {
  CONSTRUCTOR_ID: 3873421349;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeTitle";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeTitle;
    prevValue: string;
    newValue: string;
  }
  export class ChannelAdminLogEventActionChangeAbout extends VirtualClass<{
    prevValue: string;
    newValue: string;
  }> {
  CONSTRUCTOR_ID: 1427671598;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeAbout";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeAbout;
    prevValue: string;
    newValue: string;
  }
  export class ChannelAdminLogEventActionChangeUsername extends VirtualClass<{
    prevValue: string;
    newValue: string;
  }> {
  CONSTRUCTOR_ID: 1783299128;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeUsername";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeUsername;
    prevValue: string;
    newValue: string;
  }
  export class ChannelAdminLogEventActionChangePhoto extends VirtualClass<{
    prevPhoto: Api.TypePhoto;
    newPhoto: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 1129042607;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangePhoto";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangePhoto;
    prevPhoto: Api.TypePhoto;
    newPhoto: Api.TypePhoto;
  }
  export class ChannelAdminLogEventActionToggleInvites extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 460916654;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleInvites";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleInvites;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionToggleSignatures extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 648939889;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleSignatures";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleSignatures;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionUpdatePinned extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 3924306968;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionUpdatePinned";
  static fromReader(reader: Reader): ChannelAdminLogEventActionUpdatePinned;
    message: Api.TypeMessage;
  }
  export class ChannelAdminLogEventActionEditMessage extends VirtualClass<{
    prevMessage: Api.TypeMessage;
    newMessage: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 1889215493;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionEditMessage";
  static fromReader(reader: Reader): ChannelAdminLogEventActionEditMessage;
    prevMessage: Api.TypeMessage;
    newMessage: Api.TypeMessage;
  }
  export class ChannelAdminLogEventActionDeleteMessage extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 1121994683;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionDeleteMessage";
  static fromReader(reader: Reader): ChannelAdminLogEventActionDeleteMessage;
    message: Api.TypeMessage;
  }
  export class ChannelAdminLogEventActionParticipantJoin extends VirtualClass<void> {
  CONSTRUCTOR_ID: 405815507;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantJoin";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantJoin;
}
  export class ChannelAdminLogEventActionParticipantLeave extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4170676210;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantLeave";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantLeave;
}
  export class ChannelAdminLogEventActionParticipantInvite extends VirtualClass<{
    participant: Api.TypeChannelParticipant;
  }> {
  CONSTRUCTOR_ID: 3810276568;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantInvite";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantInvite;
    participant: Api.TypeChannelParticipant;
  }
  export class ChannelAdminLogEventActionParticipantToggleBan extends VirtualClass<{
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }> {
  CONSTRUCTOR_ID: 3872931198;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantToggleBan";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantToggleBan;
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }
  export class ChannelAdminLogEventActionParticipantToggleAdmin extends VirtualClass<{
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }> {
  CONSTRUCTOR_ID: 3580323600;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantToggleAdmin";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantToggleAdmin;
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }
  export class ChannelAdminLogEventActionChangeStickerSet extends VirtualClass<{
    prevStickerset: Api.TypeInputStickerSet;
    newStickerset: Api.TypeInputStickerSet;
  }> {
  CONSTRUCTOR_ID: 2982398631;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeStickerSet";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeStickerSet;
    prevStickerset: Api.TypeInputStickerSet;
    newStickerset: Api.TypeInputStickerSet;
  }
  export class ChannelAdminLogEventActionTogglePreHistoryHidden extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 1599903217;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionTogglePreHistoryHidden";
  static fromReader(reader: Reader): ChannelAdminLogEventActionTogglePreHistoryHidden;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionDefaultBannedRights extends VirtualClass<{
    prevBannedRights: Api.TypeChatBannedRights;
    newBannedRights: Api.TypeChatBannedRights;
  }> {
  CONSTRUCTOR_ID: 771095562;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionDefaultBannedRights";
  static fromReader(reader: Reader): ChannelAdminLogEventActionDefaultBannedRights;
    prevBannedRights: Api.TypeChatBannedRights;
    newBannedRights: Api.TypeChatBannedRights;
  }
  export class ChannelAdminLogEventActionStopPoll extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 2399639107;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionStopPoll";
  static fromReader(reader: Reader): ChannelAdminLogEventActionStopPoll;
    message: Api.TypeMessage;
  }
  export class ChannelAdminLogEventActionChangeLinkedChat extends VirtualClass<{
    prevValue: long;
    newValue: long;
  }> {
  CONSTRUCTOR_ID: 84703944;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeLinkedChat";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeLinkedChat;
    prevValue: long;
    newValue: long;
  }
  export class ChannelAdminLogEventActionChangeLocation extends VirtualClass<{
    prevValue: Api.TypeChannelLocation;
    newValue: Api.TypeChannelLocation;
  }> {
  CONSTRUCTOR_ID: 241923758;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeLocation";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeLocation;
    prevValue: Api.TypeChannelLocation;
    newValue: Api.TypeChannelLocation;
  }
  export class ChannelAdminLogEventActionToggleSlowMode extends VirtualClass<{
    prevValue: int;
    newValue: int;
  }> {
  CONSTRUCTOR_ID: 1401984889;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleSlowMode";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleSlowMode;
    prevValue: int;
    newValue: int;
  }
  export class ChannelAdminLogEventActionStartGroupCall extends VirtualClass<{
    call: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 589338437;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionStartGroupCall";
  static fromReader(reader: Reader): ChannelAdminLogEventActionStartGroupCall;
    call: Api.TypeInputGroupCall;
  }
  export class ChannelAdminLogEventActionDiscardGroupCall extends VirtualClass<{
    call: Api.TypeInputGroupCall;
  }> {
  CONSTRUCTOR_ID: 3684667712;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionDiscardGroupCall";
  static fromReader(reader: Reader): ChannelAdminLogEventActionDiscardGroupCall;
    call: Api.TypeInputGroupCall;
  }
  export class ChannelAdminLogEventActionParticipantMute extends VirtualClass<{
    participant: Api.TypeGroupCallParticipant;
  }> {
  CONSTRUCTOR_ID: 4179895506;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantMute";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantMute;
    participant: Api.TypeGroupCallParticipant;
  }
  export class ChannelAdminLogEventActionParticipantUnmute extends VirtualClass<{
    participant: Api.TypeGroupCallParticipant;
  }> {
  CONSTRUCTOR_ID: 3863226816;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantUnmute";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantUnmute;
    participant: Api.TypeGroupCallParticipant;
  }
  export class ChannelAdminLogEventActionToggleGroupCallSetting extends VirtualClass<{
    joinMuted: Bool;
  }> {
  CONSTRUCTOR_ID: 1456906823;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleGroupCallSetting";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleGroupCallSetting;
    joinMuted: Bool;
  }
  export class ChannelAdminLogEventActionParticipantJoinByInvite extends VirtualClass<{
    // flags: null;
    viaChatlist?: boolean;
    invite: Api.TypeExportedChatInvite;
  }> {
  CONSTRUCTOR_ID: 4271882584;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantJoinByInvite";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantJoinByInvite;
    // flags: null;
    viaChatlist?: boolean;
    invite: Api.TypeExportedChatInvite;
  }
  export class ChannelAdminLogEventActionExportedInviteDelete extends VirtualClass<{
    invite: Api.TypeExportedChatInvite;
  }> {
  CONSTRUCTOR_ID: 1515256996;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionExportedInviteDelete";
  static fromReader(reader: Reader): ChannelAdminLogEventActionExportedInviteDelete;
    invite: Api.TypeExportedChatInvite;
  }
  export class ChannelAdminLogEventActionExportedInviteRevoke extends VirtualClass<{
    invite: Api.TypeExportedChatInvite;
  }> {
  CONSTRUCTOR_ID: 1091179342;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionExportedInviteRevoke";
  static fromReader(reader: Reader): ChannelAdminLogEventActionExportedInviteRevoke;
    invite: Api.TypeExportedChatInvite;
  }
  export class ChannelAdminLogEventActionExportedInviteEdit extends VirtualClass<{
    prevInvite: Api.TypeExportedChatInvite;
    newInvite: Api.TypeExportedChatInvite;
  }> {
  CONSTRUCTOR_ID: 3910056793;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionExportedInviteEdit";
  static fromReader(reader: Reader): ChannelAdminLogEventActionExportedInviteEdit;
    prevInvite: Api.TypeExportedChatInvite;
    newInvite: Api.TypeExportedChatInvite;
  }
  export class ChannelAdminLogEventActionParticipantVolume extends VirtualClass<{
    participant: Api.TypeGroupCallParticipant;
  }> {
  CONSTRUCTOR_ID: 1048537159;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantVolume";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantVolume;
    participant: Api.TypeGroupCallParticipant;
  }
  export class ChannelAdminLogEventActionChangeHistoryTTL extends VirtualClass<{
    prevValue: int;
    newValue: int;
  }> {
  CONSTRUCTOR_ID: 1855199800;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeHistoryTTL";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeHistoryTTL;
    prevValue: int;
    newValue: int;
  }
  export class ChannelAdminLogEventActionParticipantJoinByRequest extends VirtualClass<{
    invite: Api.TypeExportedChatInvite;
    approvedBy: long;
  }> {
  CONSTRUCTOR_ID: 2947945546;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantJoinByRequest";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantJoinByRequest;
    invite: Api.TypeExportedChatInvite;
    approvedBy: long;
  }
  export class ChannelAdminLogEventActionToggleNoForwards extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 3408578406;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleNoForwards";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleNoForwards;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionSendMessage extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 663693416;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionSendMessage";
  static fromReader(reader: Reader): ChannelAdminLogEventActionSendMessage;
    message: Api.TypeMessage;
  }
  export class ChannelAdminLogEventActionChangeAvailableReactions extends VirtualClass<{
    prevValue: Api.TypeChatReactions;
    newValue: Api.TypeChatReactions;
  }> {
  CONSTRUCTOR_ID: 3192786680;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeAvailableReactions";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeAvailableReactions;
    prevValue: Api.TypeChatReactions;
    newValue: Api.TypeChatReactions;
  }
  export class ChannelAdminLogEventActionChangeUsernames extends VirtualClass<{
    prevValue: string[];
    newValue: string[];
  }> {
  CONSTRUCTOR_ID: 4031755177;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeUsernames";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeUsernames;
    prevValue: string[];
    newValue: string[];
  }
  export class ChannelAdminLogEventActionToggleForum extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 46949251;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleForum";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleForum;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionCreateTopic extends VirtualClass<{
    topic: Api.TypeForumTopic;
  }> {
  CONSTRUCTOR_ID: 1483767080;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionCreateTopic";
  static fromReader(reader: Reader): ChannelAdminLogEventActionCreateTopic;
    topic: Api.TypeForumTopic;
  }
  export class ChannelAdminLogEventActionEditTopic extends VirtualClass<{
    prevTopic: Api.TypeForumTopic;
    newTopic: Api.TypeForumTopic;
  }> {
  CONSTRUCTOR_ID: 4033864200;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionEditTopic";
  static fromReader(reader: Reader): ChannelAdminLogEventActionEditTopic;
    prevTopic: Api.TypeForumTopic;
    newTopic: Api.TypeForumTopic;
  }
  export class ChannelAdminLogEventActionDeleteTopic extends VirtualClass<{
    topic: Api.TypeForumTopic;
  }> {
  CONSTRUCTOR_ID: 2920712457;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionDeleteTopic";
  static fromReader(reader: Reader): ChannelAdminLogEventActionDeleteTopic;
    topic: Api.TypeForumTopic;
  }
  export class ChannelAdminLogEventActionPinTopic extends VirtualClass<{
    // flags: null;
    prevTopic?: Api.TypeForumTopic;
    newTopic?: Api.TypeForumTopic;
  }> {
  CONSTRUCTOR_ID: 1569535291;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionPinTopic";
  static fromReader(reader: Reader): ChannelAdminLogEventActionPinTopic;
    // flags: null;
    prevTopic?: Api.TypeForumTopic;
    newTopic?: Api.TypeForumTopic;
  }
  export class ChannelAdminLogEventActionToggleAntiSpam extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 1693675004;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleAntiSpam";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleAntiSpam;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionChangePeerColor extends VirtualClass<{
    prevValue: Api.TypePeerColor;
    newValue: Api.TypePeerColor;
  }> {
  CONSTRUCTOR_ID: 1469507456;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangePeerColor";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangePeerColor;
    prevValue: Api.TypePeerColor;
    newValue: Api.TypePeerColor;
  }
  export class ChannelAdminLogEventActionChangeProfilePeerColor extends VirtualClass<{
    prevValue: Api.TypePeerColor;
    newValue: Api.TypePeerColor;
  }> {
  CONSTRUCTOR_ID: 1581742885;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeProfilePeerColor";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeProfilePeerColor;
    prevValue: Api.TypePeerColor;
    newValue: Api.TypePeerColor;
  }
  export class ChannelAdminLogEventActionChangeWallpaper extends VirtualClass<{
    prevValue: Api.TypeWallPaper;
    newValue: Api.TypeWallPaper;
  }> {
  CONSTRUCTOR_ID: 834362706;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeWallpaper";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeWallpaper;
    prevValue: Api.TypeWallPaper;
    newValue: Api.TypeWallPaper;
  }
  export class ChannelAdminLogEventActionChangeEmojiStatus extends VirtualClass<{
    prevValue: Api.TypeEmojiStatus;
    newValue: Api.TypeEmojiStatus;
  }> {
  CONSTRUCTOR_ID: 1051328177;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeEmojiStatus";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeEmojiStatus;
    prevValue: Api.TypeEmojiStatus;
    newValue: Api.TypeEmojiStatus;
  }
  export class ChannelAdminLogEventActionChangeEmojiStickerSet extends VirtualClass<{
    prevStickerset: Api.TypeInputStickerSet;
    newStickerset: Api.TypeInputStickerSet;
  }> {
  CONSTRUCTOR_ID: 1188577451;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionChangeEmojiStickerSet";
  static fromReader(reader: Reader): ChannelAdminLogEventActionChangeEmojiStickerSet;
    prevStickerset: Api.TypeInputStickerSet;
    newStickerset: Api.TypeInputStickerSet;
  }
  export class ChannelAdminLogEventActionToggleSignatureProfiles extends VirtualClass<{
    newValue: Bool;
  }> {
  CONSTRUCTOR_ID: 1621597305;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionToggleSignatureProfiles";
  static fromReader(reader: Reader): ChannelAdminLogEventActionToggleSignatureProfiles;
    newValue: Bool;
  }
  export class ChannelAdminLogEventActionParticipantSubExtend extends VirtualClass<{
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }> {
  CONSTRUCTOR_ID: 1684286899;
  SUBCLASS_OF_ID: 2998503411;
  classType: "constructor";
  className: "ChannelAdminLogEventActionParticipantSubExtend";
  static fromReader(reader: Reader): ChannelAdminLogEventActionParticipantSubExtend;
    prevParticipant: Api.TypeChannelParticipant;
    newParticipant: Api.TypeChannelParticipant;
  }
  export class ChannelAdminLogEvent extends VirtualClass<{
    id: long;
    date: int;
    userId: long;
    action: Api.TypeChannelAdminLogEventAction;
  }> {
  CONSTRUCTOR_ID: 531458253;
  SUBCLASS_OF_ID: 1083115929;
  classType: "constructor";
  className: "ChannelAdminLogEvent";
  static fromReader(reader: Reader): ChannelAdminLogEvent;
    id: long;
    date: int;
    userId: long;
    action: Api.TypeChannelAdminLogEventAction;
  }
  export class ChannelAdminLogEventsFilter extends VirtualClass<{
    // flags: null;
    join?: boolean;
    leave?: boolean;
    invite?: boolean;
    ban?: boolean;
    unban?: boolean;
    kick?: boolean;
    unkick?: boolean;
    promote?: boolean;
    demote?: boolean;
    info?: boolean;
    settings?: boolean;
    pinned?: boolean;
    edit?: boolean;
    delete?: boolean;
    groupCall?: boolean;
    invites?: boolean;
    send?: boolean;
    forums?: boolean;
    subExtend?: boolean;
  }> {
  CONSTRUCTOR_ID: 3926948580;
  SUBCLASS_OF_ID: 2092692249;
  classType: "constructor";
  className: "ChannelAdminLogEventsFilter";
  static fromReader(reader: Reader): ChannelAdminLogEventsFilter;
    // flags: null;
    join?: boolean;
    leave?: boolean;
    invite?: boolean;
    ban?: boolean;
    unban?: boolean;
    kick?: boolean;
    unkick?: boolean;
    promote?: boolean;
    demote?: boolean;
    info?: boolean;
    settings?: boolean;
    pinned?: boolean;
    edit?: boolean;
    delete?: boolean;
    groupCall?: boolean;
    invites?: boolean;
    send?: boolean;
    forums?: boolean;
    subExtend?: boolean;
  }
  export class PopularContact extends VirtualClass<{
    clientId: long;
    importers: int;
  }> {
  CONSTRUCTOR_ID: 1558266229;
  SUBCLASS_OF_ID: 67708250;
  classType: "constructor";
  className: "PopularContact";
  static fromReader(reader: Reader): PopularContact;
    clientId: long;
    importers: int;
  }
  export class RecentMeUrlUnknown extends VirtualClass<{
    url: string;
  }> {
  CONSTRUCTOR_ID: 1189204285;
  SUBCLASS_OF_ID: 1436889209;
  classType: "constructor";
  className: "RecentMeUrlUnknown";
  static fromReader(reader: Reader): RecentMeUrlUnknown;
    url: string;
  }
  export class RecentMeUrlUser extends VirtualClass<{
    url: string;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 3106671074;
  SUBCLASS_OF_ID: 1436889209;
  classType: "constructor";
  className: "RecentMeUrlUser";
  static fromReader(reader: Reader): RecentMeUrlUser;
    url: string;
    userId: long;
  }
  export class RecentMeUrlChat extends VirtualClass<{
    url: string;
    chatId: long;
  }> {
  CONSTRUCTOR_ID: 3000660434;
  SUBCLASS_OF_ID: 1436889209;
  classType: "constructor";
  className: "RecentMeUrlChat";
  static fromReader(reader: Reader): RecentMeUrlChat;
    url: string;
    chatId: long;
  }
  export class RecentMeUrlChatInvite extends VirtualClass<{
    url: string;
    chatInvite: Api.TypeChatInvite;
  }> {
  CONSTRUCTOR_ID: 3947431965;
  SUBCLASS_OF_ID: 1436889209;
  classType: "constructor";
  className: "RecentMeUrlChatInvite";
  static fromReader(reader: Reader): RecentMeUrlChatInvite;
    url: string;
    chatInvite: Api.TypeChatInvite;
  }
  export class RecentMeUrlStickerSet extends VirtualClass<{
    url: string;
    set: Api.TypeStickerSetCovered;
  }> {
  CONSTRUCTOR_ID: 3154794460;
  SUBCLASS_OF_ID: 1436889209;
  classType: "constructor";
  className: "RecentMeUrlStickerSet";
  static fromReader(reader: Reader): RecentMeUrlStickerSet;
    url: string;
    set: Api.TypeStickerSetCovered;
  }
  export class InputSingleMedia extends VirtualClass<{
    // flags: null;
    media: Api.TypeInputMedia;
    randomId?: long;
    message: string;
    entities?: Api.TypeMessageEntity[];
  }> {
  CONSTRUCTOR_ID: 482797855;
  SUBCLASS_OF_ID: 566922968;
  classType: "constructor";
  className: "InputSingleMedia";
  static fromReader(reader: Reader): InputSingleMedia;
    // flags: null;
    media: Api.TypeInputMedia;
    randomId?: long;
    message: string;
    entities?: Api.TypeMessageEntity[];
  }
  export class WebAuthorization extends VirtualClass<{
    hash: long;
    botId: long;
    domain: string;
    browser: string;
    platform: string;
    dateCreated: int;
    dateActive: int;
    ip: string;
    region: string;
  }> {
  CONSTRUCTOR_ID: 2801333330;
  SUBCLASS_OF_ID: 58084656;
  classType: "constructor";
  className: "WebAuthorization";
  static fromReader(reader: Reader): WebAuthorization;
    hash: long;
    botId: long;
    domain: string;
    browser: string;
    platform: string;
    dateCreated: int;
    dateActive: int;
    ip: string;
    region: string;
  }
  export class InputMessageID extends VirtualClass<{
    id: int;
  }> {
  CONSTRUCTOR_ID: 2792792866;
  SUBCLASS_OF_ID: 1421262021;
  classType: "constructor";
  className: "InputMessageID";
  static fromReader(reader: Reader): InputMessageID;
    id: int;
  }
  export class InputMessageReplyTo extends VirtualClass<{
    id: int;
  }> {
  CONSTRUCTOR_ID: 3134751637;
  SUBCLASS_OF_ID: 1421262021;
  classType: "constructor";
  className: "InputMessageReplyTo";
  static fromReader(reader: Reader): InputMessageReplyTo;
    id: int;
  }
  export class InputMessagePinned extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2257003832;
  SUBCLASS_OF_ID: 1421262021;
  classType: "constructor";
  className: "InputMessagePinned";
  static fromReader(reader: Reader): InputMessagePinned;
}
  export class InputMessageCallbackQuery extends VirtualClass<{
    id: int;
    queryId: long;
  }> {
  CONSTRUCTOR_ID: 2902071934;
  SUBCLASS_OF_ID: 1421262021;
  classType: "constructor";
  className: "InputMessageCallbackQuery";
  static fromReader(reader: Reader): InputMessageCallbackQuery;
    id: int;
    queryId: long;
  }
  export class InputDialogPeer extends VirtualClass<{
    peer: Api.TypeInputPeer;
  }> {
  CONSTRUCTOR_ID: 4239064759;
  SUBCLASS_OF_ID: 2719782805;
  classType: "constructor";
  className: "InputDialogPeer";
  static fromReader(reader: Reader): InputDialogPeer;
    peer: Api.TypeInputPeer;
  }
  export class InputDialogPeerFolder extends VirtualClass<{
    folderId: int;
  }> {
  CONSTRUCTOR_ID: 1684014375;
  SUBCLASS_OF_ID: 2719782805;
  classType: "constructor";
  className: "InputDialogPeerFolder";
  static fromReader(reader: Reader): InputDialogPeerFolder;
    folderId: int;
  }
  export class DialogPeer extends VirtualClass<{
    peer: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 3849174789;
  SUBCLASS_OF_ID: 627892654;
  classType: "constructor";
  className: "DialogPeer";
  static fromReader(reader: Reader): DialogPeer;
    peer: Api.TypePeer;
  }
  export class DialogPeerFolder extends VirtualClass<{
    folderId: int;
  }> {
  CONSTRUCTOR_ID: 1363483106;
  SUBCLASS_OF_ID: 627892654;
  classType: "constructor";
  className: "DialogPeerFolder";
  static fromReader(reader: Reader): DialogPeerFolder;
    folderId: int;
  }
  export class FileHash extends VirtualClass<{
    offset: long;
    limit: int;
    hash: bytes;
  }> {
  CONSTRUCTOR_ID: 4087022428;
  SUBCLASS_OF_ID: 3939776691;
  classType: "constructor";
  className: "FileHash";
  static fromReader(reader: Reader): FileHash;
    offset: long;
    limit: int;
    hash: bytes;
  }
  export class InputClientProxy extends VirtualClass<{
    address: string;
    port: int;
  }> {
  CONSTRUCTOR_ID: 1968737087;
  SUBCLASS_OF_ID: 152716102;
  classType: "constructor";
  className: "InputClientProxy";
  static fromReader(reader: Reader): InputClientProxy;
    address: string;
    port: int;
  }
  export class InputSecureFileUploaded extends VirtualClass<{
    id: long;
    parts: int;
    md5Checksum: string;
    fileHash: bytes;
    secret: bytes;
  }> {
  CONSTRUCTOR_ID: 859091184;
  SUBCLASS_OF_ID: 3670584828;
  classType: "constructor";
  className: "InputSecureFileUploaded";
  static fromReader(reader: Reader): InputSecureFileUploaded;
    id: long;
    parts: int;
    md5Checksum: string;
    fileHash: bytes;
    secret: bytes;
  }
  export class InputSecureFile extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 1399317950;
  SUBCLASS_OF_ID: 3670584828;
  classType: "constructor";
  className: "InputSecureFile";
  static fromReader(reader: Reader): InputSecureFile;
    id: long;
    accessHash: long;
  }
  export class SecureFileEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1679398724;
  SUBCLASS_OF_ID: 1572395975;
  classType: "constructor";
  className: "SecureFileEmpty";
  static fromReader(reader: Reader): SecureFileEmpty;
}
  export class SecureFile extends VirtualClass<{
    id: long;
    accessHash: long;
    size: long;
    dcId: int;
    date: int;
    fileHash: bytes;
    secret: bytes;
  }> {
  CONSTRUCTOR_ID: 2097791614;
  SUBCLASS_OF_ID: 1572395975;
  classType: "constructor";
  className: "SecureFile";
  static fromReader(reader: Reader): SecureFile;
    id: long;
    accessHash: long;
    size: long;
    dcId: int;
    date: int;
    fileHash: bytes;
    secret: bytes;
  }
  export class SecureData extends VirtualClass<{
    data: bytes;
    dataHash: bytes;
    secret: bytes;
  }> {
  CONSTRUCTOR_ID: 2330640067;
  SUBCLASS_OF_ID: 2094276276;
  classType: "constructor";
  className: "SecureData";
  static fromReader(reader: Reader): SecureData;
    data: bytes;
    dataHash: bytes;
    secret: bytes;
  }
  export class SecurePlainPhone extends VirtualClass<{
    phone: string;
  }> {
  CONSTRUCTOR_ID: 2103482845;
  SUBCLASS_OF_ID: 598912950;
  classType: "constructor";
  className: "SecurePlainPhone";
  static fromReader(reader: Reader): SecurePlainPhone;
    phone: string;
  }
  export class SecurePlainEmail extends VirtualClass<{
    email: string;
  }> {
  CONSTRUCTOR_ID: 569137759;
  SUBCLASS_OF_ID: 598912950;
  classType: "constructor";
  className: "SecurePlainEmail";
  static fromReader(reader: Reader): SecurePlainEmail;
    email: string;
  }
  export class SecureValueTypePersonalDetails extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2636808675;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypePersonalDetails";
  static fromReader(reader: Reader): SecureValueTypePersonalDetails;
}
  export class SecureValueTypePassport extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1034709504;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypePassport";
  static fromReader(reader: Reader): SecureValueTypePassport;
}
  export class SecureValueTypeDriverLicense extends VirtualClass<void> {
  CONSTRUCTOR_ID: 115615172;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeDriverLicense";
  static fromReader(reader: Reader): SecureValueTypeDriverLicense;
}
  export class SecureValueTypeIdentityCard extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2698015819;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeIdentityCard";
  static fromReader(reader: Reader): SecureValueTypeIdentityCard;
}
  export class SecureValueTypeInternalPassport extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2577698595;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeInternalPassport";
  static fromReader(reader: Reader): SecureValueTypeInternalPassport;
}
  export class SecureValueTypeAddress extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3420659238;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeAddress";
  static fromReader(reader: Reader): SecureValueTypeAddress;
}
  export class SecureValueTypeUtilityBill extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4231435598;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeUtilityBill";
  static fromReader(reader: Reader): SecureValueTypeUtilityBill;
}
  export class SecureValueTypeBankStatement extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2299755533;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeBankStatement";
  static fromReader(reader: Reader): SecureValueTypeBankStatement;
}
  export class SecureValueTypeRentalAgreement extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2340959368;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeRentalAgreement";
  static fromReader(reader: Reader): SecureValueTypeRentalAgreement;
}
  export class SecureValueTypePassportRegistration extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2581823594;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypePassportRegistration";
  static fromReader(reader: Reader): SecureValueTypePassportRegistration;
}
  export class SecureValueTypeTemporaryRegistration extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3926060083;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeTemporaryRegistration";
  static fromReader(reader: Reader): SecureValueTypeTemporaryRegistration;
}
  export class SecureValueTypePhone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3005262555;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypePhone";
  static fromReader(reader: Reader): SecureValueTypePhone;
}
  export class SecureValueTypeEmail extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2386339822;
  SUBCLASS_OF_ID: 2291398038;
  classType: "constructor";
  className: "SecureValueTypeEmail";
  static fromReader(reader: Reader): SecureValueTypeEmail;
}
  export class SecureValue extends VirtualClass<{
    // flags: null;
    type: Api.TypeSecureValueType;
    data?: Api.TypeSecureData;
    frontSide?: Api.TypeSecureFile;
    reverseSide?: Api.TypeSecureFile;
    selfie?: Api.TypeSecureFile;
    translation?: Api.TypeSecureFile[];
    files?: Api.TypeSecureFile[];
    plainData?: Api.TypeSecurePlainData;
    hash: bytes;
  }> {
  CONSTRUCTOR_ID: 411017418;
  SUBCLASS_OF_ID: 85014702;
  classType: "constructor";
  className: "SecureValue";
  static fromReader(reader: Reader): SecureValue;
    // flags: null;
    type: Api.TypeSecureValueType;
    data?: Api.TypeSecureData;
    frontSide?: Api.TypeSecureFile;
    reverseSide?: Api.TypeSecureFile;
    selfie?: Api.TypeSecureFile;
    translation?: Api.TypeSecureFile[];
    files?: Api.TypeSecureFile[];
    plainData?: Api.TypeSecurePlainData;
    hash: bytes;
  }
  export class InputSecureValue extends VirtualClass<{
    // flags: null;
    type: Api.TypeSecureValueType;
    data?: Api.TypeSecureData;
    frontSide?: Api.TypeInputSecureFile;
    reverseSide?: Api.TypeInputSecureFile;
    selfie?: Api.TypeInputSecureFile;
    translation?: Api.TypeInputSecureFile[];
    files?: Api.TypeInputSecureFile[];
    plainData?: Api.TypeSecurePlainData;
  }> {
  CONSTRUCTOR_ID: 3676426407;
  SUBCLASS_OF_ID: 3030229500;
  classType: "constructor";
  className: "InputSecureValue";
  static fromReader(reader: Reader): InputSecureValue;
    // flags: null;
    type: Api.TypeSecureValueType;
    data?: Api.TypeSecureData;
    frontSide?: Api.TypeInputSecureFile;
    reverseSide?: Api.TypeInputSecureFile;
    selfie?: Api.TypeInputSecureFile;
    translation?: Api.TypeInputSecureFile[];
    files?: Api.TypeInputSecureFile[];
    plainData?: Api.TypeSecurePlainData;
  }
  export class SecureValueHash extends VirtualClass<{
    type: Api.TypeSecureValueType;
    hash: bytes;
  }> {
  CONSTRUCTOR_ID: 3978218928;
  SUBCLASS_OF_ID: 3589652487;
  classType: "constructor";
  className: "SecureValueHash";
  static fromReader(reader: Reader): SecureValueHash;
    type: Api.TypeSecureValueType;
    hash: bytes;
  }
  export class SecureValueErrorData extends VirtualClass<{
    type: Api.TypeSecureValueType;
    dataHash: bytes;
    field: string;
    text: string;
  }> {
  CONSTRUCTOR_ID: 3903065049;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorData";
  static fromReader(reader: Reader): SecureValueErrorData;
    type: Api.TypeSecureValueType;
    dataHash: bytes;
    field: string;
    text: string;
  }
  export class SecureValueErrorFrontSide extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 12467706;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorFrontSide";
  static fromReader(reader: Reader): SecureValueErrorFrontSide;
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }
  export class SecureValueErrorReverseSide extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 2257201829;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorReverseSide";
  static fromReader(reader: Reader): SecureValueErrorReverseSide;
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }
  export class SecureValueErrorSelfie extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 3845639894;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorSelfie";
  static fromReader(reader: Reader): SecureValueErrorSelfie;
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }
  export class SecureValueErrorFile extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 2054162547;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorFile";
  static fromReader(reader: Reader): SecureValueErrorFile;
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }
  export class SecureValueErrorFiles extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes[];
    text: string;
  }> {
  CONSTRUCTOR_ID: 1717706985;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorFiles";
  static fromReader(reader: Reader): SecureValueErrorFiles;
    type: Api.TypeSecureValueType;
    fileHash: bytes[];
    text: string;
  }
  export class SecureValueError extends VirtualClass<{
    type: Api.TypeSecureValueType;
    hash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 2258466191;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueError";
  static fromReader(reader: Reader): SecureValueError;
    type: Api.TypeSecureValueType;
    hash: bytes;
    text: string;
  }
  export class SecureValueErrorTranslationFile extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }> {
  CONSTRUCTOR_ID: 2702460784;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorTranslationFile";
  static fromReader(reader: Reader): SecureValueErrorTranslationFile;
    type: Api.TypeSecureValueType;
    fileHash: bytes;
    text: string;
  }
  export class SecureValueErrorTranslationFiles extends VirtualClass<{
    type: Api.TypeSecureValueType;
    fileHash: bytes[];
    text: string;
  }> {
  CONSTRUCTOR_ID: 878931416;
  SUBCLASS_OF_ID: 101146574;
  classType: "constructor";
  className: "SecureValueErrorTranslationFiles";
  static fromReader(reader: Reader): SecureValueErrorTranslationFiles;
    type: Api.TypeSecureValueType;
    fileHash: bytes[];
    text: string;
  }
  export class SecureCredentialsEncrypted extends VirtualClass<{
    data: bytes;
    hash: bytes;
    secret: bytes;
  }> {
  CONSTRUCTOR_ID: 871426631;
  SUBCLASS_OF_ID: 2497476147;
  classType: "constructor";
  className: "SecureCredentialsEncrypted";
  static fromReader(reader: Reader): SecureCredentialsEncrypted;
    data: bytes;
    hash: bytes;
    secret: bytes;
  }
  export class SavedPhoneContact extends VirtualClass<{
    phone: string;
    firstName: string;
    lastName: string;
    date: int;
  }> {
  CONSTRUCTOR_ID: 289586518;
  SUBCLASS_OF_ID: 115054788;
  classType: "constructor";
  className: "SavedPhoneContact";
  static fromReader(reader: Reader): SavedPhoneContact;
    phone: string;
    firstName: string;
    lastName: string;
    date: int;
  }
  export class PasswordKdfAlgoUnknown extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3562713238;
  SUBCLASS_OF_ID: 935130572;
  classType: "constructor";
  className: "PasswordKdfAlgoUnknown";
  static fromReader(reader: Reader): PasswordKdfAlgoUnknown;
}
  export class PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow extends VirtualClass<{
    salt1: bytes;
    salt2: bytes;
    g: int;
    p: bytes;
  }> {
  CONSTRUCTOR_ID: 982592842;
  SUBCLASS_OF_ID: 935130572;
  classType: "constructor";
  className: "PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow";
  static fromReader(reader: Reader): PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow;
    salt1: bytes;
    salt2: bytes;
    g: int;
    p: bytes;
  }
  export class SecurePasswordKdfAlgoUnknown extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4883767;
  SUBCLASS_OF_ID: 1998989635;
  classType: "constructor";
  className: "SecurePasswordKdfAlgoUnknown";
  static fromReader(reader: Reader): SecurePasswordKdfAlgoUnknown;
}
  export class SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000 extends VirtualClass<{
    salt: bytes;
  }> {
  CONSTRUCTOR_ID: 3153255840;
  SUBCLASS_OF_ID: 1998989635;
  classType: "constructor";
  className: "SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000";
  static fromReader(reader: Reader): SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000;
    salt: bytes;
  }
  export class SecurePasswordKdfAlgoSHA512 extends VirtualClass<{
    salt: bytes;
  }> {
  CONSTRUCTOR_ID: 2252807570;
  SUBCLASS_OF_ID: 1998989635;
  classType: "constructor";
  className: "SecurePasswordKdfAlgoSHA512";
  static fromReader(reader: Reader): SecurePasswordKdfAlgoSHA512;
    salt: bytes;
  }
  export class SecureSecretSettings extends VirtualClass<{
    secureAlgo: Api.TypeSecurePasswordKdfAlgo;
    secureSecret: bytes;
    secureSecretId: long;
  }> {
  CONSTRUCTOR_ID: 354925740;
  SUBCLASS_OF_ID: 3334996731;
  classType: "constructor";
  className: "SecureSecretSettings";
  static fromReader(reader: Reader): SecureSecretSettings;
    secureAlgo: Api.TypeSecurePasswordKdfAlgo;
    secureSecret: bytes;
    secureSecretId: long;
  }
  export class InputCheckPasswordEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2558588504;
  SUBCLASS_OF_ID: 3558536544;
  classType: "constructor";
  className: "InputCheckPasswordEmpty";
  static fromReader(reader: Reader): InputCheckPasswordEmpty;
}
  export class InputCheckPasswordSRP extends VirtualClass<{
    srpId: long;
    A: bytes;
    M1: bytes;
  }> {
  CONSTRUCTOR_ID: 3531600002;
  SUBCLASS_OF_ID: 3558536544;
  classType: "constructor";
  className: "InputCheckPasswordSRP";
  static fromReader(reader: Reader): InputCheckPasswordSRP;
    srpId: long;
    A: bytes;
    M1: bytes;
  }
  export class SecureRequiredType extends VirtualClass<{
    // flags: null;
    nativeNames?: boolean;
    selfieRequired?: boolean;
    translationRequired?: boolean;
    type: Api.TypeSecureValueType;
  }> {
  CONSTRUCTOR_ID: 2191366618;
  SUBCLASS_OF_ID: 2088452618;
  classType: "constructor";
  className: "SecureRequiredType";
  static fromReader(reader: Reader): SecureRequiredType;
    // flags: null;
    nativeNames?: boolean;
    selfieRequired?: boolean;
    translationRequired?: boolean;
    type: Api.TypeSecureValueType;
  }
  export class SecureRequiredTypeOneOf extends VirtualClass<{
    types: Api.TypeSecureRequiredType[];
  }> {
  CONSTRUCTOR_ID: 41187252;
  SUBCLASS_OF_ID: 2088452618;
  classType: "constructor";
  className: "SecureRequiredTypeOneOf";
  static fromReader(reader: Reader): SecureRequiredTypeOneOf;
    types: Api.TypeSecureRequiredType[];
  }
  export class InputAppEvent extends VirtualClass<{
    time: double;
    type: string;
    peer: long;
    data: Api.TypeJSONValue;
  }> {
  CONSTRUCTOR_ID: 488313413;
  SUBCLASS_OF_ID: 2301763846;
  classType: "constructor";
  className: "InputAppEvent";
  static fromReader(reader: Reader): InputAppEvent;
    time: double;
    type: string;
    peer: long;
    data: Api.TypeJSONValue;
  }
  export class JsonObjectValue extends VirtualClass<{
    key: string;
    value: Api.TypeJSONValue;
  }> {
  CONSTRUCTOR_ID: 3235781593;
  SUBCLASS_OF_ID: 2474626745;
  classType: "constructor";
  className: "JsonObjectValue";
  static fromReader(reader: Reader): JsonObjectValue;
    key: string;
    value: Api.TypeJSONValue;
  }
  export class JsonNull extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1064139624;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonNull";
  static fromReader(reader: Reader): JsonNull;
}
  export class JsonBool extends VirtualClass<{
    value: Bool;
  }> {
  CONSTRUCTOR_ID: 3342098026;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonBool";
  static fromReader(reader: Reader): JsonBool;
    value: Bool;
  }
  export class JsonNumber extends VirtualClass<{
    value: double;
  }> {
  CONSTRUCTOR_ID: 736157604;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonNumber";
  static fromReader(reader: Reader): JsonNumber;
    value: double;
  }
  export class JsonString extends VirtualClass<{
    value: string;
  }> {
  CONSTRUCTOR_ID: 3072226938;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonString";
  static fromReader(reader: Reader): JsonString;
    value: string;
  }
  export class JsonArray extends VirtualClass<{
    value: Api.TypeJSONValue[];
  }> {
  CONSTRUCTOR_ID: 4148447075;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonArray";
  static fromReader(reader: Reader): JsonArray;
    value: Api.TypeJSONValue[];
  }
  export class JsonObject extends VirtualClass<{
    value: Api.TypeJSONObjectValue[];
  }> {
  CONSTRUCTOR_ID: 2579616925;
  SUBCLASS_OF_ID: 3952707507;
  classType: "constructor";
  className: "JsonObject";
  static fromReader(reader: Reader): JsonObject;
    value: Api.TypeJSONObjectValue[];
  }
  export class PageTableCell extends VirtualClass<{
    // flags: null;
    header?: boolean;
    alignCenter?: boolean;
    alignRight?: boolean;
    valignMiddle?: boolean;
    valignBottom?: boolean;
    text?: Api.TypeRichText;
    colspan?: int;
    rowspan?: int;
  }> {
  CONSTRUCTOR_ID: 878078826;
  SUBCLASS_OF_ID: 2968203348;
  classType: "constructor";
  className: "PageTableCell";
  static fromReader(reader: Reader): PageTableCell;
    // flags: null;
    header?: boolean;
    alignCenter?: boolean;
    alignRight?: boolean;
    valignMiddle?: boolean;
    valignBottom?: boolean;
    text?: Api.TypeRichText;
    colspan?: int;
    rowspan?: int;
  }
  export class PageTableRow extends VirtualClass<{
    cells: Api.TypePageTableCell[];
  }> {
  CONSTRUCTOR_ID: 3770729957;
  SUBCLASS_OF_ID: 1504505361;
  classType: "constructor";
  className: "PageTableRow";
  static fromReader(reader: Reader): PageTableRow;
    cells: Api.TypePageTableCell[];
  }
  export class PageCaption extends VirtualClass<{
    text: Api.TypeRichText;
    credit: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1869903447;
  SUBCLASS_OF_ID: 699985587;
  classType: "constructor";
  className: "PageCaption";
  static fromReader(reader: Reader): PageCaption;
    text: Api.TypeRichText;
    credit: Api.TypeRichText;
  }
  export class PageListItemText extends VirtualClass<{
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 3106911949;
  SUBCLASS_OF_ID: 2360261809;
  classType: "constructor";
  className: "PageListItemText";
  static fromReader(reader: Reader): PageListItemText;
    text: Api.TypeRichText;
  }
  export class PageListItemBlocks extends VirtualClass<{
    blocks: Api.TypePageBlock[];
  }> {
  CONSTRUCTOR_ID: 635466748;
  SUBCLASS_OF_ID: 2360261809;
  classType: "constructor";
  className: "PageListItemBlocks";
  static fromReader(reader: Reader): PageListItemBlocks;
    blocks: Api.TypePageBlock[];
  }
  export class PageListOrderedItemText extends VirtualClass<{
    num: string;
    text: Api.TypeRichText;
  }> {
  CONSTRUCTOR_ID: 1577484359;
  SUBCLASS_OF_ID: 4007268024;
  classType: "constructor";
  className: "PageListOrderedItemText";
  static fromReader(reader: Reader): PageListOrderedItemText;
    num: string;
    text: Api.TypeRichText;
  }
  export class PageListOrderedItemBlocks extends VirtualClass<{
    num: string;
    blocks: Api.TypePageBlock[];
  }> {
  CONSTRUCTOR_ID: 2564655414;
  SUBCLASS_OF_ID: 4007268024;
  classType: "constructor";
  className: "PageListOrderedItemBlocks";
  static fromReader(reader: Reader): PageListOrderedItemBlocks;
    num: string;
    blocks: Api.TypePageBlock[];
  }
  export class PageRelatedArticle extends VirtualClass<{
    // flags: null;
    url: string;
    webpageId: long;
    title?: string;
    description?: string;
    photoId?: long;
    author?: string;
    publishedDate?: int;
  }> {
  CONSTRUCTOR_ID: 3012615176;
  SUBCLASS_OF_ID: 919623714;
  classType: "constructor";
  className: "PageRelatedArticle";
  static fromReader(reader: Reader): PageRelatedArticle;
    // flags: null;
    url: string;
    webpageId: long;
    title?: string;
    description?: string;
    photoId?: long;
    author?: string;
    publishedDate?: int;
  }
  export class Page extends VirtualClass<{
    // flags: null;
    part?: boolean;
    rtl?: boolean;
    v2?: boolean;
    url: string;
    blocks: Api.TypePageBlock[];
    photos: Api.TypePhoto[];
    documents: Api.TypeDocument[];
    views?: int;
  }> {
  CONSTRUCTOR_ID: 2556788493;
  SUBCLASS_OF_ID: 3023575326;
  classType: "constructor";
  className: "Page";
  static fromReader(reader: Reader): Page;
    // flags: null;
    part?: boolean;
    rtl?: boolean;
    v2?: boolean;
    url: string;
    blocks: Api.TypePageBlock[];
    photos: Api.TypePhoto[];
    documents: Api.TypeDocument[];
    views?: int;
  }
  export class PollAnswer extends VirtualClass<{
    text: Api.TypeTextWithEntities;
    option: bytes;
  }> {
  CONSTRUCTOR_ID: 4279689930;
  SUBCLASS_OF_ID: 2124799390;
  classType: "constructor";
  className: "PollAnswer";
  static fromReader(reader: Reader): PollAnswer;
    text: Api.TypeTextWithEntities;
    option: bytes;
  }
  export class Poll extends VirtualClass<{
    id: long;
    // flags: null;
    closed?: boolean;
    publicVoters?: boolean;
    multipleChoice?: boolean;
    quiz?: boolean;
    question: Api.TypeTextWithEntities;
    answers: Api.TypePollAnswer[];
    closePeriod?: int;
    closeDate?: int;
  }> {
  CONSTRUCTOR_ID: 1484026161;
  SUBCLASS_OF_ID: 613307771;
  classType: "constructor";
  className: "Poll";
  static fromReader(reader: Reader): Poll;
    id: long;
    // flags: null;
    closed?: boolean;
    publicVoters?: boolean;
    multipleChoice?: boolean;
    quiz?: boolean;
    question: Api.TypeTextWithEntities;
    answers: Api.TypePollAnswer[];
    closePeriod?: int;
    closeDate?: int;
  }
  export class PollAnswerVoters extends VirtualClass<{
    // flags: null;
    chosen?: boolean;
    correct?: boolean;
    option: bytes;
    voters: int;
  }> {
  CONSTRUCTOR_ID: 997055186;
  SUBCLASS_OF_ID: 2095107985;
  classType: "constructor";
  className: "PollAnswerVoters";
  static fromReader(reader: Reader): PollAnswerVoters;
    // flags: null;
    chosen?: boolean;
    correct?: boolean;
    option: bytes;
    voters: int;
  }
  export class PollResults extends VirtualClass<{
    // flags: null;
    min?: boolean;
    results?: Api.TypePollAnswerVoters[];
    totalVoters?: int;
    recentVoters?: Api.TypePeer[];
    solution?: string;
    solutionEntities?: Api.TypeMessageEntity[];
  }> {
  CONSTRUCTOR_ID: 2061444128;
  SUBCLASS_OF_ID: 3283416711;
  classType: "constructor";
  className: "PollResults";
  static fromReader(reader: Reader): PollResults;
    // flags: null;
    min?: boolean;
    results?: Api.TypePollAnswerVoters[];
    totalVoters?: int;
    recentVoters?: Api.TypePeer[];
    solution?: string;
    solutionEntities?: Api.TypeMessageEntity[];
  }
  export class ChatOnlines extends VirtualClass<{
    onlines: int;
  }> {
  CONSTRUCTOR_ID: 4030849616;
  SUBCLASS_OF_ID: 2357301306;
  classType: "constructor";
  className: "ChatOnlines";
  static fromReader(reader: Reader): ChatOnlines;
    onlines: int;
  }
  export class StatsURL extends VirtualClass<{
    url: string;
  }> {
  CONSTRUCTOR_ID: 1202287072;
  SUBCLASS_OF_ID: 2370606272;
  classType: "constructor";
  className: "StatsURL";
  static fromReader(reader: Reader): StatsURL;
    url: string;
  }
  export class ChatAdminRights extends VirtualClass<{
    // flags: null;
    changeInfo?: boolean;
    postMessages?: boolean;
    editMessages?: boolean;
    deleteMessages?: boolean;
    banUsers?: boolean;
    inviteUsers?: boolean;
    pinMessages?: boolean;
    addAdmins?: boolean;
    anonymous?: boolean;
    manageCall?: boolean;
    other?: boolean;
    manageTopics?: boolean;
    postStories?: boolean;
    editStories?: boolean;
    deleteStories?: boolean;
  }> {
  CONSTRUCTOR_ID: 1605510357;
  SUBCLASS_OF_ID: 2252195780;
  classType: "constructor";
  className: "ChatAdminRights";
  static fromReader(reader: Reader): ChatAdminRights;
    // flags: null;
    changeInfo?: boolean;
    postMessages?: boolean;
    editMessages?: boolean;
    deleteMessages?: boolean;
    banUsers?: boolean;
    inviteUsers?: boolean;
    pinMessages?: boolean;
    addAdmins?: boolean;
    anonymous?: boolean;
    manageCall?: boolean;
    other?: boolean;
    manageTopics?: boolean;
    postStories?: boolean;
    editStories?: boolean;
    deleteStories?: boolean;
  }
  export class ChatBannedRights extends VirtualClass<{
    // flags: null;
    viewMessages?: boolean;
    sendMessages?: boolean;
    sendMedia?: boolean;
    sendStickers?: boolean;
    sendGifs?: boolean;
    sendGames?: boolean;
    sendInline?: boolean;
    embedLinks?: boolean;
    sendPolls?: boolean;
    changeInfo?: boolean;
    inviteUsers?: boolean;
    pinMessages?: boolean;
    manageTopics?: boolean;
    sendPhotos?: boolean;
    sendVideos?: boolean;
    sendRoundvideos?: boolean;
    sendAudios?: boolean;
    sendVoices?: boolean;
    sendDocs?: boolean;
    sendPlain?: boolean;
    untilDate: int;
  }> {
  CONSTRUCTOR_ID: 2668758040;
  SUBCLASS_OF_ID: 1263814057;
  classType: "constructor";
  className: "ChatBannedRights";
  static fromReader(reader: Reader): ChatBannedRights;
    // flags: null;
    viewMessages?: boolean;
    sendMessages?: boolean;
    sendMedia?: boolean;
    sendStickers?: boolean;
    sendGifs?: boolean;
    sendGames?: boolean;
    sendInline?: boolean;
    embedLinks?: boolean;
    sendPolls?: boolean;
    changeInfo?: boolean;
    inviteUsers?: boolean;
    pinMessages?: boolean;
    manageTopics?: boolean;
    sendPhotos?: boolean;
    sendVideos?: boolean;
    sendRoundvideos?: boolean;
    sendAudios?: boolean;
    sendVoices?: boolean;
    sendDocs?: boolean;
    sendPlain?: boolean;
    untilDate: int;
  }
  export class InputWallPaper extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3861952889;
  SUBCLASS_OF_ID: 4000784410;
  classType: "constructor";
  className: "InputWallPaper";
  static fromReader(reader: Reader): InputWallPaper;
    id: long;
    accessHash: long;
  }
  export class InputWallPaperSlug extends VirtualClass<{
    slug: string;
  }> {
  CONSTRUCTOR_ID: 1913199744;
  SUBCLASS_OF_ID: 4000784410;
  classType: "constructor";
  className: "InputWallPaperSlug";
  static fromReader(reader: Reader): InputWallPaperSlug;
    slug: string;
  }
  export class InputWallPaperNoFile extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 2524595758;
  SUBCLASS_OF_ID: 4000784410;
  classType: "constructor";
  className: "InputWallPaperNoFile";
  static fromReader(reader: Reader): InputWallPaperNoFile;
    id: long;
  }
  export class CodeSettings extends VirtualClass<{
    // flags: null;
    allowFlashcall?: boolean;
    currentNumber?: boolean;
    allowAppHash?: boolean;
    allowMissedCall?: boolean;
    allowFirebase?: boolean;
    unknownNumber?: boolean;
    logoutTokens?: bytes[];
    token?: string;
    appSandbox?: Bool;
  }> {
  CONSTRUCTOR_ID: 2904898936;
  SUBCLASS_OF_ID: 1223539850;
  classType: "constructor";
  className: "CodeSettings";
  static fromReader(reader: Reader): CodeSettings;
    // flags: null;
    allowFlashcall?: boolean;
    currentNumber?: boolean;
    allowAppHash?: boolean;
    allowMissedCall?: boolean;
    allowFirebase?: boolean;
    unknownNumber?: boolean;
    logoutTokens?: bytes[];
    token?: string;
    appSandbox?: Bool;
  }
  export class WallPaperSettings extends VirtualClass<{
    // flags: null;
    blur?: boolean;
    motion?: boolean;
    backgroundColor?: int;
    secondBackgroundColor?: int;
    thirdBackgroundColor?: int;
    fourthBackgroundColor?: int;
    intensity?: int;
    rotation?: int;
    emoticon?: string;
  }> {
  CONSTRUCTOR_ID: 925826256;
  SUBCLASS_OF_ID: 1098244882;
  classType: "constructor";
  className: "WallPaperSettings";
  static fromReader(reader: Reader): WallPaperSettings;
    // flags: null;
    blur?: boolean;
    motion?: boolean;
    backgroundColor?: int;
    secondBackgroundColor?: int;
    thirdBackgroundColor?: int;
    fourthBackgroundColor?: int;
    intensity?: int;
    rotation?: int;
    emoticon?: string;
  }
  export class AutoDownloadSettings extends VirtualClass<{
    // flags: null;
    disabled?: boolean;
    videoPreloadLarge?: boolean;
    audioPreloadNext?: boolean;
    phonecallsLessData?: boolean;
    storiesPreload?: boolean;
    photoSizeMax: int;
    videoSizeMax: long;
    fileSizeMax: long;
    videoUploadMaxbitrate: int;
    smallQueueActiveOperationsMax: int;
    largeQueueActiveOperationsMax: int;
  }> {
  CONSTRUCTOR_ID: 3131405864;
  SUBCLASS_OF_ID: 1361582535;
  classType: "constructor";
  className: "AutoDownloadSettings";
  static fromReader(reader: Reader): AutoDownloadSettings;
    // flags: null;
    disabled?: boolean;
    videoPreloadLarge?: boolean;
    audioPreloadNext?: boolean;
    phonecallsLessData?: boolean;
    storiesPreload?: boolean;
    photoSizeMax: int;
    videoSizeMax: long;
    fileSizeMax: long;
    videoUploadMaxbitrate: int;
    smallQueueActiveOperationsMax: int;
    largeQueueActiveOperationsMax: int;
  }
  export class EmojiKeyword extends VirtualClass<{
    keyword: string;
    emoticons: string[];
  }> {
  CONSTRUCTOR_ID: 3585325561;
  SUBCLASS_OF_ID: 1712497982;
  classType: "constructor";
  className: "EmojiKeyword";
  static fromReader(reader: Reader): EmojiKeyword;
    keyword: string;
    emoticons: string[];
  }
  export class EmojiKeywordDeleted extends VirtualClass<{
    keyword: string;
    emoticons: string[];
  }> {
  CONSTRUCTOR_ID: 594408994;
  SUBCLASS_OF_ID: 1712497982;
  classType: "constructor";
  className: "EmojiKeywordDeleted";
  static fromReader(reader: Reader): EmojiKeywordDeleted;
    keyword: string;
    emoticons: string[];
  }
  export class EmojiKeywordsDifference extends VirtualClass<{
    langCode: string;
    fromVersion: int;
    version: int;
    keywords: Api.TypeEmojiKeyword[];
  }> {
  CONSTRUCTOR_ID: 1556570557;
  SUBCLASS_OF_ID: 3531196018;
  classType: "constructor";
  className: "EmojiKeywordsDifference";
  static fromReader(reader: Reader): EmojiKeywordsDifference;
    langCode: string;
    fromVersion: int;
    version: int;
    keywords: Api.TypeEmojiKeyword[];
  }
  export class EmojiURL extends VirtualClass<{
    url: string;
  }> {
  CONSTRUCTOR_ID: 2775937949;
  SUBCLASS_OF_ID: 530614809;
  classType: "constructor";
  className: "EmojiURL";
  static fromReader(reader: Reader): EmojiURL;
    url: string;
  }
  export class EmojiLanguage extends VirtualClass<{
    langCode: string;
  }> {
  CONSTRUCTOR_ID: 3019592545;
  SUBCLASS_OF_ID: 2760705262;
  classType: "constructor";
  className: "EmojiLanguage";
  static fromReader(reader: Reader): EmojiLanguage;
    langCode: string;
  }
  export class Folder extends VirtualClass<{
    // flags: null;
    autofillNewBroadcasts?: boolean;
    autofillPublicGroups?: boolean;
    autofillNewCorrespondents?: boolean;
    id: int;
    title: string;
    photo?: Api.TypeChatPhoto;
  }> {
  CONSTRUCTOR_ID: 4283715173;
  SUBCLASS_OF_ID: 3943566587;
  classType: "constructor";
  className: "Folder";
  static fromReader(reader: Reader): Folder;
    // flags: null;
    autofillNewBroadcasts?: boolean;
    autofillPublicGroups?: boolean;
    autofillNewCorrespondents?: boolean;
    id: int;
    title: string;
    photo?: Api.TypeChatPhoto;
  }
  export class InputFolderPeer extends VirtualClass<{
    peer: Api.TypeInputPeer;
    folderId: int;
  }> {
  CONSTRUCTOR_ID: 4224893590;
  SUBCLASS_OF_ID: 1954700800;
  classType: "constructor";
  className: "InputFolderPeer";
  static fromReader(reader: Reader): InputFolderPeer;
    peer: Api.TypeInputPeer;
    folderId: int;
  }
  export class FolderPeer extends VirtualClass<{
    peer: Api.TypePeer;
    folderId: int;
  }> {
  CONSTRUCTOR_ID: 3921323624;
  SUBCLASS_OF_ID: 4092733499;
  classType: "constructor";
  className: "FolderPeer";
  static fromReader(reader: Reader): FolderPeer;
    peer: Api.TypePeer;
    folderId: int;
  }
  export class UrlAuthResultRequest extends VirtualClass<{
    // flags: null;
    requestWriteAccess?: boolean;
    bot: Api.TypeUser;
    domain: string;
  }> {
  CONSTRUCTOR_ID: 2463316494;
  SUBCLASS_OF_ID: 2003159838;
  classType: "constructor";
  className: "UrlAuthResultRequest";
  static fromReader(reader: Reader): UrlAuthResultRequest;
    // flags: null;
    requestWriteAccess?: boolean;
    bot: Api.TypeUser;
    domain: string;
  }
  export class UrlAuthResultAccepted extends VirtualClass<{
    url: string;
  }> {
  CONSTRUCTOR_ID: 2408320590;
  SUBCLASS_OF_ID: 2003159838;
  classType: "constructor";
  className: "UrlAuthResultAccepted";
  static fromReader(reader: Reader): UrlAuthResultAccepted;
    url: string;
  }
  export class UrlAuthResultDefault extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2849430303;
  SUBCLASS_OF_ID: 2003159838;
  classType: "constructor";
  className: "UrlAuthResultDefault";
  static fromReader(reader: Reader): UrlAuthResultDefault;
}
  export class ChannelLocationEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3216354699;
  SUBCLASS_OF_ID: 3961916287;
  classType: "constructor";
  className: "ChannelLocationEmpty";
  static fromReader(reader: Reader): ChannelLocationEmpty;
}
  export class ChannelLocation extends VirtualClass<{
    geoPoint: Api.TypeGeoPoint;
    address: string;
  }> {
  CONSTRUCTOR_ID: 547062491;
  SUBCLASS_OF_ID: 3961916287;
  classType: "constructor";
  className: "ChannelLocation";
  static fromReader(reader: Reader): ChannelLocation;
    geoPoint: Api.TypeGeoPoint;
    address: string;
  }
  export class PeerLocated extends VirtualClass<{
    peer: Api.TypePeer;
    expires: int;
    distance: int;
  }> {
  CONSTRUCTOR_ID: 3393592157;
  SUBCLASS_OF_ID: 4208604332;
  classType: "constructor";
  className: "PeerLocated";
  static fromReader(reader: Reader): PeerLocated;
    peer: Api.TypePeer;
    expires: int;
    distance: int;
  }
  export class PeerSelfLocated extends VirtualClass<{
    expires: int;
  }> {
  CONSTRUCTOR_ID: 4176226379;
  SUBCLASS_OF_ID: 4208604332;
  classType: "constructor";
  className: "PeerSelfLocated";
  static fromReader(reader: Reader): PeerSelfLocated;
    expires: int;
  }
  export class RestrictionReason extends VirtualClass<{
    platform: string;
    reason: string;
    text: string;
  }> {
  CONSTRUCTOR_ID: 3497176244;
  SUBCLASS_OF_ID: 112039341;
  classType: "constructor";
  className: "RestrictionReason";
  static fromReader(reader: Reader): RestrictionReason;
    platform: string;
    reason: string;
    text: string;
  }
  export class InputTheme extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 1012306921;
  SUBCLASS_OF_ID: 127992048;
  classType: "constructor";
  className: "InputTheme";
  static fromReader(reader: Reader): InputTheme;
    id: long;
    accessHash: long;
  }
  export class InputThemeSlug extends VirtualClass<{
    slug: string;
  }> {
  CONSTRUCTOR_ID: 4119399921;
  SUBCLASS_OF_ID: 127992048;
  classType: "constructor";
  className: "InputThemeSlug";
  static fromReader(reader: Reader): InputThemeSlug;
    slug: string;
  }
  export class Theme extends VirtualClass<{
    // flags: null;
    creator?: boolean;
    default?: boolean;
    forChat?: boolean;
    id: long;
    accessHash: long;
    slug: string;
    title: string;
    document?: Api.TypeDocument;
    settings?: Api.TypeThemeSettings[];
    emoticon?: string;
    installsCount?: int;
  }> {
  CONSTRUCTOR_ID: 2685298646;
  SUBCLASS_OF_ID: 1454688268;
  classType: "constructor";
  className: "Theme";
  static fromReader(reader: Reader): Theme;
    // flags: null;
    creator?: boolean;
    default?: boolean;
    forChat?: boolean;
    id: long;
    accessHash: long;
    slug: string;
    title: string;
    document?: Api.TypeDocument;
    settings?: Api.TypeThemeSettings[];
    emoticon?: string;
    installsCount?: int;
  }
  export class BaseThemeClassic extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3282117730;
  SUBCLASS_OF_ID: 520352836;
  classType: "constructor";
  className: "BaseThemeClassic";
  static fromReader(reader: Reader): BaseThemeClassic;
}
  export class BaseThemeDay extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4225242760;
  SUBCLASS_OF_ID: 520352836;
  classType: "constructor";
  className: "BaseThemeDay";
  static fromReader(reader: Reader): BaseThemeDay;
}
  export class BaseThemeNight extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3081969320;
  SUBCLASS_OF_ID: 520352836;
  classType: "constructor";
  className: "BaseThemeNight";
  static fromReader(reader: Reader): BaseThemeNight;
}
  export class BaseThemeTinted extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1834973166;
  SUBCLASS_OF_ID: 520352836;
  classType: "constructor";
  className: "BaseThemeTinted";
  static fromReader(reader: Reader): BaseThemeTinted;
}
  export class BaseThemeArctic extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1527845466;
  SUBCLASS_OF_ID: 520352836;
  classType: "constructor";
  className: "BaseThemeArctic";
  static fromReader(reader: Reader): BaseThemeArctic;
}
  export class InputThemeSettings extends VirtualClass<{
    // flags: null;
    messageColorsAnimated?: boolean;
    baseTheme: Api.TypeBaseTheme;
    accentColor: int;
    outboxAccentColor?: int;
    messageColors?: int[];
    wallpaper?: Api.TypeInputWallPaper;
    wallpaperSettings?: Api.TypeWallPaperSettings;
  }> {
  CONSTRUCTOR_ID: 2413711439;
  SUBCLASS_OF_ID: 2201536642;
  classType: "constructor";
  className: "InputThemeSettings";
  static fromReader(reader: Reader): InputThemeSettings;
    // flags: null;
    messageColorsAnimated?: boolean;
    baseTheme: Api.TypeBaseTheme;
    accentColor: int;
    outboxAccentColor?: int;
    messageColors?: int[];
    wallpaper?: Api.TypeInputWallPaper;
    wallpaperSettings?: Api.TypeWallPaperSettings;
  }
  export class ThemeSettings extends VirtualClass<{
    // flags: null;
    messageColorsAnimated?: boolean;
    baseTheme: Api.TypeBaseTheme;
    accentColor: int;
    outboxAccentColor?: int;
    messageColors?: int[];
    wallpaper?: Api.TypeWallPaper;
  }> {
  CONSTRUCTOR_ID: 4200117972;
  SUBCLASS_OF_ID: 2187750712;
  classType: "constructor";
  className: "ThemeSettings";
  static fromReader(reader: Reader): ThemeSettings;
    // flags: null;
    messageColorsAnimated?: boolean;
    baseTheme: Api.TypeBaseTheme;
    accentColor: int;
    outboxAccentColor?: int;
    messageColors?: int[];
    wallpaper?: Api.TypeWallPaper;
  }
  export class WebPageAttributeTheme extends VirtualClass<{
    // flags: null;
    documents?: Api.TypeDocument[];
    settings?: Api.TypeThemeSettings;
  }> {
  CONSTRUCTOR_ID: 1421174295;
  SUBCLASS_OF_ID: 2949638599;
  classType: "constructor";
  className: "WebPageAttributeTheme";
  static fromReader(reader: Reader): WebPageAttributeTheme;
    // flags: null;
    documents?: Api.TypeDocument[];
    settings?: Api.TypeThemeSettings;
  }
  export class WebPageAttributeStory extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    id: int;
    story?: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 781501415;
  SUBCLASS_OF_ID: 2949638599;
  classType: "constructor";
  className: "WebPageAttributeStory";
  static fromReader(reader: Reader): WebPageAttributeStory;
    // flags: null;
    peer: Api.TypePeer;
    id: int;
    story?: Api.TypeStoryItem;
  }
  export class WebPageAttributeStickerSet extends VirtualClass<{
    // flags: null;
    emojis?: boolean;
    textColor?: boolean;
    stickers: Api.TypeDocument[];
  }> {
  CONSTRUCTOR_ID: 1355547603;
  SUBCLASS_OF_ID: 2949638599;
  classType: "constructor";
  className: "WebPageAttributeStickerSet";
  static fromReader(reader: Reader): WebPageAttributeStickerSet;
    // flags: null;
    emojis?: boolean;
    textColor?: boolean;
    stickers: Api.TypeDocument[];
  }
  export class WebPageAttributeUniqueStarGift extends VirtualClass<{
    gift: Api.TypeStarGift;
  }> {
  CONSTRUCTOR_ID: 3480186296;
  SUBCLASS_OF_ID: 2949638599;
  classType: "constructor";
  className: "WebPageAttributeUniqueStarGift";
  static fromReader(reader: Reader): WebPageAttributeUniqueStarGift;
    gift: Api.TypeStarGift;
  }
  export class BankCardOpenUrl extends VirtualClass<{
    url: string;
    name: string;
  }> {
  CONSTRUCTOR_ID: 4117234314;
  SUBCLASS_OF_ID: 4074915342;
  classType: "constructor";
  className: "BankCardOpenUrl";
  static fromReader(reader: Reader): BankCardOpenUrl;
    url: string;
    name: string;
  }
  export class DialogFilter extends VirtualClass<{
    // flags: null;
    contacts?: boolean;
    nonContacts?: boolean;
    groups?: boolean;
    broadcasts?: boolean;
    bots?: boolean;
    excludeMuted?: boolean;
    excludeRead?: boolean;
    excludeArchived?: boolean;
    titleNoanimate?: boolean;
    id: int;
    title: Api.TypeTextWithEntities;
    emoticon?: string;
    color?: int;
    pinnedPeers: Api.TypeInputPeer[];
    includePeers: Api.TypeInputPeer[];
    excludePeers: Api.TypeInputPeer[];
  }> {
  CONSTRUCTOR_ID: 2856789585;
  SUBCLASS_OF_ID: 1764475991;
  classType: "constructor";
  className: "DialogFilter";
  static fromReader(reader: Reader): DialogFilter;
    // flags: null;
    contacts?: boolean;
    nonContacts?: boolean;
    groups?: boolean;
    broadcasts?: boolean;
    bots?: boolean;
    excludeMuted?: boolean;
    excludeRead?: boolean;
    excludeArchived?: boolean;
    titleNoanimate?: boolean;
    id: int;
    title: Api.TypeTextWithEntities;
    emoticon?: string;
    color?: int;
    pinnedPeers: Api.TypeInputPeer[];
    includePeers: Api.TypeInputPeer[];
    excludePeers: Api.TypeInputPeer[];
  }
  export class DialogFilterDefault extends VirtualClass<void> {
  CONSTRUCTOR_ID: 909284270;
  SUBCLASS_OF_ID: 1764475991;
  classType: "constructor";
  className: "DialogFilterDefault";
  static fromReader(reader: Reader): DialogFilterDefault;
}
  export class DialogFilterChatlist extends VirtualClass<{
    // flags: null;
    hasMyInvites?: boolean;
    titleNoanimate?: boolean;
    id: int;
    title: Api.TypeTextWithEntities;
    emoticon?: string;
    color?: int;
    pinnedPeers: Api.TypeInputPeer[];
    includePeers: Api.TypeInputPeer[];
  }> {
  CONSTRUCTOR_ID: 2522053591;
  SUBCLASS_OF_ID: 1764475991;
  classType: "constructor";
  className: "DialogFilterChatlist";
  static fromReader(reader: Reader): DialogFilterChatlist;
    // flags: null;
    hasMyInvites?: boolean;
    titleNoanimate?: boolean;
    id: int;
    title: Api.TypeTextWithEntities;
    emoticon?: string;
    color?: int;
    pinnedPeers: Api.TypeInputPeer[];
    includePeers: Api.TypeInputPeer[];
  }
  export class DialogFilterSuggested extends VirtualClass<{
    filter: Api.TypeDialogFilter;
    description: string;
  }> {
  CONSTRUCTOR_ID: 2004110666;
  SUBCLASS_OF_ID: 837673094;
  classType: "constructor";
  className: "DialogFilterSuggested";
  static fromReader(reader: Reader): DialogFilterSuggested;
    filter: Api.TypeDialogFilter;
    description: string;
  }
  export class StatsDateRangeDays extends VirtualClass<{
    minDate: int;
    maxDate: int;
  }> {
  CONSTRUCTOR_ID: 3057118639;
  SUBCLASS_OF_ID: 2166579781;
  classType: "constructor";
  className: "StatsDateRangeDays";
  static fromReader(reader: Reader): StatsDateRangeDays;
    minDate: int;
    maxDate: int;
  }
  export class StatsAbsValueAndPrev extends VirtualClass<{
    current: double;
    previous: double;
  }> {
  CONSTRUCTOR_ID: 3410210014;
  SUBCLASS_OF_ID: 1052662191;
  classType: "constructor";
  className: "StatsAbsValueAndPrev";
  static fromReader(reader: Reader): StatsAbsValueAndPrev;
    current: double;
    previous: double;
  }
  export class StatsPercentValue extends VirtualClass<{
    part: double;
    total: double;
  }> {
  CONSTRUCTOR_ID: 3419287520;
  SUBCLASS_OF_ID: 2533541150;
  classType: "constructor";
  className: "StatsPercentValue";
  static fromReader(reader: Reader): StatsPercentValue;
    part: double;
    total: double;
  }
  export class StatsGraphAsync extends VirtualClass<{
    token: string;
  }> {
  CONSTRUCTOR_ID: 1244130093;
  SUBCLASS_OF_ID: 2609918291;
  classType: "constructor";
  className: "StatsGraphAsync";
  static fromReader(reader: Reader): StatsGraphAsync;
    token: string;
  }
  export class StatsGraphError extends VirtualClass<{
    error: string;
  }> {
  CONSTRUCTOR_ID: 3202127906;
  SUBCLASS_OF_ID: 2609918291;
  classType: "constructor";
  className: "StatsGraphError";
  static fromReader(reader: Reader): StatsGraphError;
    error: string;
  }
  export class StatsGraph extends VirtualClass<{
    // flags: null;
    json: Api.TypeDataJSON;
    zoomToken?: string;
  }> {
  CONSTRUCTOR_ID: 2393138358;
  SUBCLASS_OF_ID: 2609918291;
  classType: "constructor";
  className: "StatsGraph";
  static fromReader(reader: Reader): StatsGraph;
    // flags: null;
    json: Api.TypeDataJSON;
    zoomToken?: string;
  }
  export class VideoSize extends VirtualClass<{
    // flags: null;
    type: string;
    w: int;
    h: int;
    size: int;
    videoStartTs?: double;
  }> {
  CONSTRUCTOR_ID: 3727929492;
  SUBCLASS_OF_ID: 1660015881;
  classType: "constructor";
  className: "VideoSize";
  static fromReader(reader: Reader): VideoSize;
    // flags: null;
    type: string;
    w: int;
    h: int;
    size: int;
    videoStartTs?: double;
  }
  export class VideoSizeEmojiMarkup extends VirtualClass<{
    emojiId: long;
    backgroundColors: int[];
  }> {
  CONSTRUCTOR_ID: 4166795580;
  SUBCLASS_OF_ID: 1660015881;
  classType: "constructor";
  className: "VideoSizeEmojiMarkup";
  static fromReader(reader: Reader): VideoSizeEmojiMarkup;
    emojiId: long;
    backgroundColors: int[];
  }
  export class VideoSizeStickerMarkup extends VirtualClass<{
    stickerset: Api.TypeInputStickerSet;
    stickerId: long;
    backgroundColors: int[];
  }> {
  CONSTRUCTOR_ID: 228623102;
  SUBCLASS_OF_ID: 1660015881;
  classType: "constructor";
  className: "VideoSizeStickerMarkup";
  static fromReader(reader: Reader): VideoSizeStickerMarkup;
    stickerset: Api.TypeInputStickerSet;
    stickerId: long;
    backgroundColors: int[];
  }
  export class StatsGroupTopPoster extends VirtualClass<{
    userId: long;
    messages: int;
    avgChars: int;
  }> {
  CONSTRUCTOR_ID: 2634330011;
  SUBCLASS_OF_ID: 2177224227;
  classType: "constructor";
  className: "StatsGroupTopPoster";
  static fromReader(reader: Reader): StatsGroupTopPoster;
    userId: long;
    messages: int;
    avgChars: int;
  }
  export class StatsGroupTopAdmin extends VirtualClass<{
    userId: long;
    deleted: int;
    kicked: int;
    banned: int;
  }> {
  CONSTRUCTOR_ID: 3612888199;
  SUBCLASS_OF_ID: 2150997085;
  classType: "constructor";
  className: "StatsGroupTopAdmin";
  static fromReader(reader: Reader): StatsGroupTopAdmin;
    userId: long;
    deleted: int;
    kicked: int;
    banned: int;
  }
  export class StatsGroupTopInviter extends VirtualClass<{
    userId: long;
    invitations: int;
  }> {
  CONSTRUCTOR_ID: 1398765469;
  SUBCLASS_OF_ID: 2231438458;
  classType: "constructor";
  className: "StatsGroupTopInviter";
  static fromReader(reader: Reader): StatsGroupTopInviter;
    userId: long;
    invitations: int;
  }
  export class GlobalPrivacySettings extends VirtualClass<{
    // flags: null;
    archiveAndMuteNewNoncontactPeers?: boolean;
    keepArchivedUnmuted?: boolean;
    keepArchivedFolders?: boolean;
    hideReadMarks?: boolean;
    newNoncontactPeersRequirePremium?: boolean;
  }> {
  CONSTRUCTOR_ID: 1934380235;
  SUBCLASS_OF_ID: 3373160304;
  classType: "constructor";
  className: "GlobalPrivacySettings";
  static fromReader(reader: Reader): GlobalPrivacySettings;
    // flags: null;
    archiveAndMuteNewNoncontactPeers?: boolean;
    keepArchivedUnmuted?: boolean;
    keepArchivedFolders?: boolean;
    hideReadMarks?: boolean;
    newNoncontactPeersRequirePremium?: boolean;
  }
  export class MessageViews extends VirtualClass<{
    // flags: null;
    views?: int;
    forwards?: int;
    replies?: Api.TypeMessageReplies;
  }> {
  CONSTRUCTOR_ID: 1163625789;
  SUBCLASS_OF_ID: 1018201017;
  classType: "constructor";
  className: "MessageViews";
  static fromReader(reader: Reader): MessageViews;
    // flags: null;
    views?: int;
    forwards?: int;
    replies?: Api.TypeMessageReplies;
  }
  export class MessageReplyHeader extends VirtualClass<{
    // flags: null;
    replyToScheduled?: boolean;
    forumTopic?: boolean;
    quote?: boolean;
    replyToMsgId?: int;
    replyToPeerId?: Api.TypePeer;
    replyFrom?: Api.TypeMessageFwdHeader;
    replyMedia?: Api.TypeMessageMedia;
    replyToTopId?: int;
    quoteText?: string;
    quoteEntities?: Api.TypeMessageEntity[];
    quoteOffset?: int;
  }> {
  CONSTRUCTOR_ID: 2948336091;
  SUBCLASS_OF_ID: 1531810151;
  classType: "constructor";
  className: "MessageReplyHeader";
  static fromReader(reader: Reader): MessageReplyHeader;
    // flags: null;
    replyToScheduled?: boolean;
    forumTopic?: boolean;
    quote?: boolean;
    replyToMsgId?: int;
    replyToPeerId?: Api.TypePeer;
    replyFrom?: Api.TypeMessageFwdHeader;
    replyMedia?: Api.TypeMessageMedia;
    replyToTopId?: int;
    quoteText?: string;
    quoteEntities?: Api.TypeMessageEntity[];
    quoteOffset?: int;
  }
  export class MessageReplyStoryHeader extends VirtualClass<{
    peer: Api.TypePeer;
    storyId: int;
  }> {
  CONSTRUCTOR_ID: 240843065;
  SUBCLASS_OF_ID: 1531810151;
  classType: "constructor";
  className: "MessageReplyStoryHeader";
  static fromReader(reader: Reader): MessageReplyStoryHeader;
    peer: Api.TypePeer;
    storyId: int;
  }
  export class MessageReplies extends VirtualClass<{
    // flags: null;
    comments?: boolean;
    replies: int;
    repliesPts: int;
    recentRepliers?: Api.TypePeer[];
    channelId?: long;
    maxId?: int;
    readMaxId?: int;
  }> {
  CONSTRUCTOR_ID: 2211844034;
  SUBCLASS_OF_ID: 1825397986;
  classType: "constructor";
  className: "MessageReplies";
  static fromReader(reader: Reader): MessageReplies;
    // flags: null;
    comments?: boolean;
    replies: int;
    repliesPts: int;
    recentRepliers?: Api.TypePeer[];
    channelId?: long;
    maxId?: int;
    readMaxId?: int;
  }
  export class PeerBlocked extends VirtualClass<{
    peerId: Api.TypePeer;
    date: int;
  }> {
  CONSTRUCTOR_ID: 3908927508;
  SUBCLASS_OF_ID: 1425210520;
  classType: "constructor";
  className: "PeerBlocked";
  static fromReader(reader: Reader): PeerBlocked;
    peerId: Api.TypePeer;
    date: int;
  }
  export class GroupCallDiscarded extends VirtualClass<{
    id: long;
    accessHash: long;
    duration: int;
  }> {
  CONSTRUCTOR_ID: 2004925620;
  SUBCLASS_OF_ID: 548729632;
  classType: "constructor";
  className: "GroupCallDiscarded";
  static fromReader(reader: Reader): GroupCallDiscarded;
    id: long;
    accessHash: long;
    duration: int;
  }
  export class GroupCall extends VirtualClass<{
    // flags: null;
    joinMuted?: boolean;
    canChangeJoinMuted?: boolean;
    joinDateAsc?: boolean;
    scheduleStartSubscribed?: boolean;
    canStartVideo?: boolean;
    recordVideoActive?: boolean;
    rtmpStream?: boolean;
    listenersHidden?: boolean;
    id: long;
    accessHash: long;
    participantsCount: int;
    title?: string;
    streamDcId?: int;
    recordStartDate?: int;
    scheduleDate?: int;
    unmutedVideoCount?: int;
    unmutedVideoLimit: int;
    version: int;
    conferenceFromCall?: long;
  }> {
  CONSTRUCTOR_ID: 3455636451;
  SUBCLASS_OF_ID: 548729632;
  classType: "constructor";
  className: "GroupCall";
  static fromReader(reader: Reader): GroupCall;
    // flags: null;
    joinMuted?: boolean;
    canChangeJoinMuted?: boolean;
    joinDateAsc?: boolean;
    scheduleStartSubscribed?: boolean;
    canStartVideo?: boolean;
    recordVideoActive?: boolean;
    rtmpStream?: boolean;
    listenersHidden?: boolean;
    id: long;
    accessHash: long;
    participantsCount: int;
    title?: string;
    streamDcId?: int;
    recordStartDate?: int;
    scheduleDate?: int;
    unmutedVideoCount?: int;
    unmutedVideoLimit: int;
    version: int;
    conferenceFromCall?: long;
  }
  export class InputGroupCall extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 3635053583;
  SUBCLASS_OF_ID: 1482758833;
  classType: "constructor";
  className: "InputGroupCall";
  static fromReader(reader: Reader): InputGroupCall;
    id: long;
    accessHash: long;
  }
  export class GroupCallParticipant extends VirtualClass<{
    // flags: null;
    muted?: boolean;
    left?: boolean;
    canSelfUnmute?: boolean;
    justJoined?: boolean;
    versioned?: boolean;
    min?: boolean;
    mutedByYou?: boolean;
    volumeByAdmin?: boolean;
    self?: boolean;
    videoJoined?: boolean;
    peer: Api.TypePeer;
    date: int;
    activeDate?: int;
    source: int;
    volume?: int;
    about?: string;
    raiseHandRating?: long;
    video?: Api.TypeGroupCallParticipantVideo;
    presentation?: Api.TypeGroupCallParticipantVideo;
  }> {
  CONSTRUCTOR_ID: 3953538814;
  SUBCLASS_OF_ID: 3222974284;
  classType: "constructor";
  className: "GroupCallParticipant";
  static fromReader(reader: Reader): GroupCallParticipant;
    // flags: null;
    muted?: boolean;
    left?: boolean;
    canSelfUnmute?: boolean;
    justJoined?: boolean;
    versioned?: boolean;
    min?: boolean;
    mutedByYou?: boolean;
    volumeByAdmin?: boolean;
    self?: boolean;
    videoJoined?: boolean;
    peer: Api.TypePeer;
    date: int;
    activeDate?: int;
    source: int;
    volume?: int;
    about?: string;
    raiseHandRating?: long;
    video?: Api.TypeGroupCallParticipantVideo;
    presentation?: Api.TypeGroupCallParticipantVideo;
  }
  export class InlineQueryPeerTypeSameBotPM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 813821341;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypeSameBotPM";
  static fromReader(reader: Reader): InlineQueryPeerTypeSameBotPM;
}
  export class InlineQueryPeerTypePM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2201751468;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypePM";
  static fromReader(reader: Reader): InlineQueryPeerTypePM;
}
  export class InlineQueryPeerTypeChat extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3613836554;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypeChat";
  static fromReader(reader: Reader): InlineQueryPeerTypeChat;
}
  export class InlineQueryPeerTypeMegagroup extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1589952067;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypeMegagroup";
  static fromReader(reader: Reader): InlineQueryPeerTypeMegagroup;
}
  export class InlineQueryPeerTypeBroadcast extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1664413338;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypeBroadcast";
  static fromReader(reader: Reader): InlineQueryPeerTypeBroadcast;
}
  export class InlineQueryPeerTypeBotPM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 238759180;
  SUBCLASS_OF_ID: 2947611167;
  classType: "constructor";
  className: "InlineQueryPeerTypeBotPM";
  static fromReader(reader: Reader): InlineQueryPeerTypeBotPM;
}
  export class ChatInviteImporter extends VirtualClass<{
    // flags: null;
    requested?: boolean;
    viaChatlist?: boolean;
    userId: long;
    date: int;
    about?: string;
    approvedBy?: long;
  }> {
  CONSTRUCTOR_ID: 2354765785;
  SUBCLASS_OF_ID: 1393710126;
  classType: "constructor";
  className: "ChatInviteImporter";
  static fromReader(reader: Reader): ChatInviteImporter;
    // flags: null;
    requested?: boolean;
    viaChatlist?: boolean;
    userId: long;
    date: int;
    about?: string;
    approvedBy?: long;
  }
  export class ChatAdminWithInvites extends VirtualClass<{
    adminId: long;
    invitesCount: int;
    revokedInvitesCount: int;
  }> {
  CONSTRUCTOR_ID: 4075613987;
  SUBCLASS_OF_ID: 1348727704;
  classType: "constructor";
  className: "ChatAdminWithInvites";
  static fromReader(reader: Reader): ChatAdminWithInvites;
    adminId: long;
    invitesCount: int;
    revokedInvitesCount: int;
  }
  export class GroupCallParticipantVideoSourceGroup extends VirtualClass<{
    semantics: string;
    sources: int[];
  }> {
  CONSTRUCTOR_ID: 3702593719;
  SUBCLASS_OF_ID: 806746236;
  classType: "constructor";
  className: "GroupCallParticipantVideoSourceGroup";
  static fromReader(reader: Reader): GroupCallParticipantVideoSourceGroup;
    semantics: string;
    sources: int[];
  }
  export class GroupCallParticipantVideo extends VirtualClass<{
    // flags: null;
    paused?: boolean;
    endpoint: string;
    sourceGroups: Api.TypeGroupCallParticipantVideoSourceGroup[];
    audioSource?: int;
  }> {
  CONSTRUCTOR_ID: 1735736008;
  SUBCLASS_OF_ID: 4014389467;
  classType: "constructor";
  className: "GroupCallParticipantVideo";
  static fromReader(reader: Reader): GroupCallParticipantVideo;
    // flags: null;
    paused?: boolean;
    endpoint: string;
    sourceGroups: Api.TypeGroupCallParticipantVideoSourceGroup[];
    audioSource?: int;
  }
  export class BotCommandScopeDefault extends VirtualClass<void> {
  CONSTRUCTOR_ID: 795652779;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopeDefault";
  static fromReader(reader: Reader): BotCommandScopeDefault;
}
  export class BotCommandScopeUsers extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1011811544;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopeUsers";
  static fromReader(reader: Reader): BotCommandScopeUsers;
}
  export class BotCommandScopeChats extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1877059713;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopeChats";
  static fromReader(reader: Reader): BotCommandScopeChats;
}
  export class BotCommandScopeChatAdmins extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3114950762;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopeChatAdmins";
  static fromReader(reader: Reader): BotCommandScopeChatAdmins;
}
  export class BotCommandScopePeer extends VirtualClass<{
    peer: Api.TypeInputPeer;
  }> {
  CONSTRUCTOR_ID: 3684534653;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopePeer";
  static fromReader(reader: Reader): BotCommandScopePeer;
    peer: Api.TypeInputPeer;
  }
  export class BotCommandScopePeerAdmins extends VirtualClass<{
    peer: Api.TypeInputPeer;
  }> {
  CONSTRUCTOR_ID: 1071145937;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopePeerAdmins";
  static fromReader(reader: Reader): BotCommandScopePeerAdmins;
    peer: Api.TypeInputPeer;
  }
  export class BotCommandScopePeerUser extends VirtualClass<{
    peer: Api.TypeInputPeer;
    userId: Api.TypeInputUser;
  }> {
  CONSTRUCTOR_ID: 169026035;
  SUBCLASS_OF_ID: 1269783824;
  classType: "constructor";
  className: "BotCommandScopePeerUser";
  static fromReader(reader: Reader): BotCommandScopePeerUser;
    peer: Api.TypeInputPeer;
    userId: Api.TypeInputUser;
  }
  export class SponsoredMessage extends VirtualClass<{
    // flags: null;
    recommended?: boolean;
    canReport?: boolean;
    randomId: bytes;
    url: string;
    title: string;
    message: string;
    entities?: Api.TypeMessageEntity[];
    photo?: Api.TypePhoto;
    media?: Api.TypeMessageMedia;
    color?: Api.TypePeerColor;
    buttonText: string;
    sponsorInfo?: string;
    additionalInfo?: string;
  }> {
  CONSTRUCTOR_ID: 1301522832;
  SUBCLASS_OF_ID: 3780630582;
  classType: "constructor";
  className: "SponsoredMessage";
  static fromReader(reader: Reader): SponsoredMessage;
    // flags: null;
    recommended?: boolean;
    canReport?: boolean;
    randomId: bytes;
    url: string;
    title: string;
    message: string;
    entities?: Api.TypeMessageEntity[];
    photo?: Api.TypePhoto;
    media?: Api.TypeMessageMedia;
    color?: Api.TypePeerColor;
    buttonText: string;
    sponsorInfo?: string;
    additionalInfo?: string;
  }
  export class SearchResultsCalendarPeriod extends VirtualClass<{
    date: int;
    minMsgId: int;
    maxMsgId: int;
    count: int;
  }> {
  CONSTRUCTOR_ID: 3383776159;
  SUBCLASS_OF_ID: 3797743871;
  classType: "constructor";
  className: "SearchResultsCalendarPeriod";
  static fromReader(reader: Reader): SearchResultsCalendarPeriod;
    date: int;
    minMsgId: int;
    maxMsgId: int;
    count: int;
  }
  export class SearchResultPosition extends VirtualClass<{
    msgId: int;
    date: int;
    offset: int;
  }> {
  CONSTRUCTOR_ID: 2137295719;
  SUBCLASS_OF_ID: 3101824532;
  classType: "constructor";
  className: "SearchResultPosition";
  static fromReader(reader: Reader): SearchResultPosition;
    msgId: int;
    date: int;
    offset: int;
  }
  export class ReactionCount extends VirtualClass<{
    // flags: null;
    chosenOrder?: int;
    reaction: Api.TypeReaction;
    count: int;
  }> {
  CONSTRUCTOR_ID: 2748435328;
  SUBCLASS_OF_ID: 3523792447;
  classType: "constructor";
  className: "ReactionCount";
  static fromReader(reader: Reader): ReactionCount;
    // flags: null;
    chosenOrder?: int;
    reaction: Api.TypeReaction;
    count: int;
  }
  export class MessageReactions extends VirtualClass<{
    // flags: null;
    min?: boolean;
    canSeeList?: boolean;
    reactionsAsTags?: boolean;
    results: Api.TypeReactionCount[];
    recentReactions?: Api.TypeMessagePeerReaction[];
    topReactors?: Api.TypeMessageReactor[];
  }> {
  CONSTRUCTOR_ID: 171155211;
  SUBCLASS_OF_ID: 2321221404;
  classType: "constructor";
  className: "MessageReactions";
  static fromReader(reader: Reader): MessageReactions;
    // flags: null;
    min?: boolean;
    canSeeList?: boolean;
    reactionsAsTags?: boolean;
    results: Api.TypeReactionCount[];
    recentReactions?: Api.TypeMessagePeerReaction[];
    topReactors?: Api.TypeMessageReactor[];
  }
  export class AvailableReaction extends VirtualClass<{
    // flags: null;
    inactive?: boolean;
    premium?: boolean;
    reaction: string;
    title: string;
    staticIcon: Api.TypeDocument;
    appearAnimation: Api.TypeDocument;
    selectAnimation: Api.TypeDocument;
    activateAnimation: Api.TypeDocument;
    effectAnimation: Api.TypeDocument;
    aroundAnimation?: Api.TypeDocument;
    centerIcon?: Api.TypeDocument;
  }> {
  CONSTRUCTOR_ID: 3229084673;
  SUBCLASS_OF_ID: 2350685555;
  classType: "constructor";
  className: "AvailableReaction";
  static fromReader(reader: Reader): AvailableReaction;
    // flags: null;
    inactive?: boolean;
    premium?: boolean;
    reaction: string;
    title: string;
    staticIcon: Api.TypeDocument;
    appearAnimation: Api.TypeDocument;
    selectAnimation: Api.TypeDocument;
    activateAnimation: Api.TypeDocument;
    effectAnimation: Api.TypeDocument;
    aroundAnimation?: Api.TypeDocument;
    centerIcon?: Api.TypeDocument;
  }
  export class MessagePeerReaction extends VirtualClass<{
    // flags: null;
    big?: boolean;
    unread?: boolean;
    my?: boolean;
    peerId: Api.TypePeer;
    date: int;
    reaction: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 2356786748;
  SUBCLASS_OF_ID: 2943591077;
  classType: "constructor";
  className: "MessagePeerReaction";
  static fromReader(reader: Reader): MessagePeerReaction;
    // flags: null;
    big?: boolean;
    unread?: boolean;
    my?: boolean;
    peerId: Api.TypePeer;
    date: int;
    reaction: Api.TypeReaction;
  }
  export class GroupCallStreamChannel extends VirtualClass<{
    channel: int;
    scale: int;
    lastTimestampMs: long;
  }> {
  CONSTRUCTOR_ID: 2162903215;
  SUBCLASS_OF_ID: 3712266840;
  classType: "constructor";
  className: "GroupCallStreamChannel";
  static fromReader(reader: Reader): GroupCallStreamChannel;
    channel: int;
    scale: int;
    lastTimestampMs: long;
  }
  export class AttachMenuBotIconColor extends VirtualClass<{
    name: string;
    color: int;
  }> {
  CONSTRUCTOR_ID: 1165423600;
  SUBCLASS_OF_ID: 3198471018;
  classType: "constructor";
  className: "AttachMenuBotIconColor";
  static fromReader(reader: Reader): AttachMenuBotIconColor;
    name: string;
    color: int;
  }
  export class AttachMenuBotIcon extends VirtualClass<{
    // flags: null;
    name: string;
    icon: Api.TypeDocument;
    colors?: Api.TypeAttachMenuBotIconColor[];
  }> {
  CONSTRUCTOR_ID: 2997303403;
  SUBCLASS_OF_ID: 2152219989;
  classType: "constructor";
  className: "AttachMenuBotIcon";
  static fromReader(reader: Reader): AttachMenuBotIcon;
    // flags: null;
    name: string;
    icon: Api.TypeDocument;
    colors?: Api.TypeAttachMenuBotIconColor[];
  }
  export class AttachMenuBot extends VirtualClass<{
    // flags: null;
    inactive?: boolean;
    hasSettings?: boolean;
    requestWriteAccess?: boolean;
    showInAttachMenu?: boolean;
    showInSideMenu?: boolean;
    sideMenuDisclaimerNeeded?: boolean;
    botId: long;
    shortName: string;
    peerTypes?: Api.TypeAttachMenuPeerType[];
    icons: Api.TypeAttachMenuBotIcon[];
  }> {
  CONSTRUCTOR_ID: 3641544190;
  SUBCLASS_OF_ID: 2668131398;
  classType: "constructor";
  className: "AttachMenuBot";
  static fromReader(reader: Reader): AttachMenuBot;
    // flags: null;
    inactive?: boolean;
    hasSettings?: boolean;
    requestWriteAccess?: boolean;
    showInAttachMenu?: boolean;
    showInSideMenu?: boolean;
    sideMenuDisclaimerNeeded?: boolean;
    botId: long;
    shortName: string;
    peerTypes?: Api.TypeAttachMenuPeerType[];
    icons: Api.TypeAttachMenuBotIcon[];
  }
  export class AttachMenuBotsNotModified extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4057500252;
  SUBCLASS_OF_ID: 2217616346;
  classType: "constructor";
  className: "AttachMenuBotsNotModified";
  static fromReader(reader: Reader): AttachMenuBotsNotModified;
}
  export class AttachMenuBots extends VirtualClass<{
    hash: long;
    bots: Api.TypeAttachMenuBot[];
    users: Api.TypeUser[];
  }> {
  CONSTRUCTOR_ID: 1011024320;
  SUBCLASS_OF_ID: 2217616346;
  classType: "constructor";
  className: "AttachMenuBots";
  static fromReader(reader: Reader): AttachMenuBots;
    hash: long;
    bots: Api.TypeAttachMenuBot[];
    users: Api.TypeUser[];
  }
  export class AttachMenuBotsBot extends VirtualClass<{
    bot: Api.TypeAttachMenuBot;
    users: Api.TypeUser[];
  }> {
  CONSTRUCTOR_ID: 2478794367;
  SUBCLASS_OF_ID: 3677587517;
  classType: "constructor";
  className: "AttachMenuBotsBot";
  static fromReader(reader: Reader): AttachMenuBotsBot;
    bot: Api.TypeAttachMenuBot;
    users: Api.TypeUser[];
  }
  export class WebViewResultUrl extends VirtualClass<{
    // flags: null;
    fullsize?: boolean;
    fullscreen?: boolean;
    queryId?: long;
    url: string;
  }> {
  CONSTRUCTOR_ID: 1294139288;
  SUBCLASS_OF_ID: 2479793990;
  classType: "constructor";
  className: "WebViewResultUrl";
  static fromReader(reader: Reader): WebViewResultUrl;
    // flags: null;
    fullsize?: boolean;
    fullscreen?: boolean;
    queryId?: long;
    url: string;
  }
  export class WebViewMessageSent extends VirtualClass<{
    // flags: null;
    msgId?: Api.TypeInputBotInlineMessageID;
  }> {
  CONSTRUCTOR_ID: 211046684;
  SUBCLASS_OF_ID: 1977914130;
  classType: "constructor";
  className: "WebViewMessageSent";
  static fromReader(reader: Reader): WebViewMessageSent;
    // flags: null;
    msgId?: Api.TypeInputBotInlineMessageID;
  }
  export class BotMenuButtonDefault extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1966318984;
  SUBCLASS_OF_ID: 1282522428;
  classType: "constructor";
  className: "BotMenuButtonDefault";
  static fromReader(reader: Reader): BotMenuButtonDefault;
}
  export class BotMenuButtonCommands extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1113113093;
  SUBCLASS_OF_ID: 1282522428;
  classType: "constructor";
  className: "BotMenuButtonCommands";
  static fromReader(reader: Reader): BotMenuButtonCommands;
}
  export class BotMenuButton extends VirtualClass<{
    text: string;
    url: string;
  }> {
  CONSTRUCTOR_ID: 3350559974;
  SUBCLASS_OF_ID: 1282522428;
  classType: "constructor";
  className: "BotMenuButton";
  static fromReader(reader: Reader): BotMenuButton;
    text: string;
    url: string;
  }
  export class NotificationSoundDefault extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2548612798;
  SUBCLASS_OF_ID: 4076201307;
  classType: "constructor";
  className: "NotificationSoundDefault";
  static fromReader(reader: Reader): NotificationSoundDefault;
}
  export class NotificationSoundNone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1863070943;
  SUBCLASS_OF_ID: 4076201307;
  classType: "constructor";
  className: "NotificationSoundNone";
  static fromReader(reader: Reader): NotificationSoundNone;
}
  export class NotificationSoundLocal extends VirtualClass<{
    title: string;
    data: string;
  }> {
  CONSTRUCTOR_ID: 2198575844;
  SUBCLASS_OF_ID: 4076201307;
  classType: "constructor";
  className: "NotificationSoundLocal";
  static fromReader(reader: Reader): NotificationSoundLocal;
    title: string;
    data: string;
  }
  export class NotificationSoundRingtone extends VirtualClass<{
    id: long;
  }> {
  CONSTRUCTOR_ID: 4285300809;
  SUBCLASS_OF_ID: 4076201307;
  classType: "constructor";
  className: "NotificationSoundRingtone";
  static fromReader(reader: Reader): NotificationSoundRingtone;
    id: long;
  }
  export class AttachMenuPeerTypeSameBotPM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2104224014;
  SUBCLASS_OF_ID: 3520628432;
  classType: "constructor";
  className: "AttachMenuPeerTypeSameBotPM";
  static fromReader(reader: Reader): AttachMenuPeerTypeSameBotPM;
}
  export class AttachMenuPeerTypeBotPM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3274439194;
  SUBCLASS_OF_ID: 3520628432;
  classType: "constructor";
  className: "AttachMenuPeerTypeBotPM";
  static fromReader(reader: Reader): AttachMenuPeerTypeBotPM;
}
  export class AttachMenuPeerTypePM extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4047950623;
  SUBCLASS_OF_ID: 3520628432;
  classType: "constructor";
  className: "AttachMenuPeerTypePM";
  static fromReader(reader: Reader): AttachMenuPeerTypePM;
}
  export class AttachMenuPeerTypeChat extends VirtualClass<void> {
  CONSTRUCTOR_ID: 84480319;
  SUBCLASS_OF_ID: 3520628432;
  classType: "constructor";
  className: "AttachMenuPeerTypeChat";
  static fromReader(reader: Reader): AttachMenuPeerTypeChat;
}
  export class AttachMenuPeerTypeBroadcast extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2080104188;
  SUBCLASS_OF_ID: 3520628432;
  classType: "constructor";
  className: "AttachMenuPeerTypeBroadcast";
  static fromReader(reader: Reader): AttachMenuPeerTypeBroadcast;
}
  export class InputInvoiceMessage extends VirtualClass<{
    peer: Api.TypeInputPeer;
    msgId: int;
  }> {
  CONSTRUCTOR_ID: 3317000281;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceMessage";
  static fromReader(reader: Reader): InputInvoiceMessage;
    peer: Api.TypeInputPeer;
    msgId: int;
  }
  export class InputInvoiceSlug extends VirtualClass<{
    slug: string;
  }> {
  CONSTRUCTOR_ID: 3274099439;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceSlug";
  static fromReader(reader: Reader): InputInvoiceSlug;
    slug: string;
  }
  export class InputInvoicePremiumGiftCode extends VirtualClass<{
    purpose: Api.TypeInputStorePaymentPurpose;
    option: Api.TypePremiumGiftCodeOption;
  }> {
  CONSTRUCTOR_ID: 2560125965;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoicePremiumGiftCode";
  static fromReader(reader: Reader): InputInvoicePremiumGiftCode;
    purpose: Api.TypeInputStorePaymentPurpose;
    option: Api.TypePremiumGiftCodeOption;
  }
  export class InputInvoiceStars extends VirtualClass<{
    purpose: Api.TypeInputStorePaymentPurpose;
  }> {
  CONSTRUCTOR_ID: 1710230755;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceStars";
  static fromReader(reader: Reader): InputInvoiceStars;
    purpose: Api.TypeInputStorePaymentPurpose;
  }
  export class InputInvoiceChatInviteSubscription extends VirtualClass<{
    hash: string;
  }> {
  CONSTRUCTOR_ID: 887591921;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceChatInviteSubscription";
  static fromReader(reader: Reader): InputInvoiceChatInviteSubscription;
    hash: string;
  }
  export class InputInvoiceStarGift extends VirtualClass<{
    // flags: null;
    hideName?: boolean;
    includeUpgrade?: boolean;
    peer: Api.TypeInputPeer;
    giftId: long;
    message?: Api.TypeTextWithEntities;
  }> {
  CONSTRUCTOR_ID: 3898760850;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceStarGift";
  static fromReader(reader: Reader): InputInvoiceStarGift;
    // flags: null;
    hideName?: boolean;
    includeUpgrade?: boolean;
    peer: Api.TypeInputPeer;
    giftId: long;
    message?: Api.TypeTextWithEntities;
  }
  export class InputInvoiceStarGiftUpgrade extends VirtualClass<{
    // flags: null;
    keepOriginalDetails?: boolean;
    stargift: Api.TypeInputSavedStarGift;
  }> {
  CONSTRUCTOR_ID: 1300335965;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceStarGiftUpgrade";
  static fromReader(reader: Reader): InputInvoiceStarGiftUpgrade;
    // flags: null;
    keepOriginalDetails?: boolean;
    stargift: Api.TypeInputSavedStarGift;
  }
  export class InputInvoiceStarGiftTransfer extends VirtualClass<{
    stargift: Api.TypeInputSavedStarGift;
    toId: Api.TypeInputPeer;
  }> {
  CONSTRUCTOR_ID: 1247763417;
  SUBCLASS_OF_ID: 1919851518;
  classType: "constructor";
  className: "InputInvoiceStarGiftTransfer";
  static fromReader(reader: Reader): InputInvoiceStarGiftTransfer;
    stargift: Api.TypeInputSavedStarGift;
    toId: Api.TypeInputPeer;
  }
  export class InputStorePaymentPremiumSubscription extends VirtualClass<{
    // flags: null;
    restore?: boolean;
    upgrade?: boolean;
  }> {
  CONSTRUCTOR_ID: 2792693350;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentPremiumSubscription";
  static fromReader(reader: Reader): InputStorePaymentPremiumSubscription;
    // flags: null;
    restore?: boolean;
    upgrade?: boolean;
  }
  export class InputStorePaymentGiftPremium extends VirtualClass<{
    userId: Api.TypeInputUser;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 1634697192;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentGiftPremium";
  static fromReader(reader: Reader): InputStorePaymentGiftPremium;
    userId: Api.TypeInputUser;
    currency: string;
    amount: long;
  }
  export class InputStorePaymentPremiumGiftCode extends VirtualClass<{
    // flags: null;
    users: Api.TypeInputUser[];
    boostPeer?: Api.TypeInputPeer;
    currency: string;
    amount: long;
    message?: Api.TypeTextWithEntities;
  }> {
  CONSTRUCTOR_ID: 4219011987;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentPremiumGiftCode";
  static fromReader(reader: Reader): InputStorePaymentPremiumGiftCode;
    // flags: null;
    users: Api.TypeInputUser[];
    boostPeer?: Api.TypeInputPeer;
    currency: string;
    amount: long;
    message?: Api.TypeTextWithEntities;
  }
  export class InputStorePaymentPremiumGiveaway extends VirtualClass<{
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    boostPeer: Api.TypeInputPeer;
    additionalPeers?: Api.TypeInputPeer[];
    countriesIso2?: string[];
    prizeDescription?: string;
    randomId?: long;
    untilDate: int;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 369444042;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentPremiumGiveaway";
  static fromReader(reader: Reader): InputStorePaymentPremiumGiveaway;
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    boostPeer: Api.TypeInputPeer;
    additionalPeers?: Api.TypeInputPeer[];
    countriesIso2?: string[];
    prizeDescription?: string;
    randomId?: long;
    untilDate: int;
    currency: string;
    amount: long;
  }
  export class InputStorePaymentStarsTopup extends VirtualClass<{
    stars: long;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 3722252118;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentStarsTopup";
  static fromReader(reader: Reader): InputStorePaymentStarsTopup;
    stars: long;
    currency: string;
    amount: long;
  }
  export class InputStorePaymentStarsGift extends VirtualClass<{
    userId: Api.TypeInputUser;
    stars: long;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 494149367;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentStarsGift";
  static fromReader(reader: Reader): InputStorePaymentStarsGift;
    userId: Api.TypeInputUser;
    stars: long;
    currency: string;
    amount: long;
  }
  export class InputStorePaymentStarsGiveaway extends VirtualClass<{
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    stars: long;
    boostPeer: Api.TypeInputPeer;
    additionalPeers?: Api.TypeInputPeer[];
    countriesIso2?: string[];
    prizeDescription?: string;
    randomId?: long;
    untilDate: int;
    currency: string;
    amount: long;
    users: int;
  }> {
  CONSTRUCTOR_ID: 1964968186;
  SUBCLASS_OF_ID: 3886290765;
  classType: "constructor";
  className: "InputStorePaymentStarsGiveaway";
  static fromReader(reader: Reader): InputStorePaymentStarsGiveaway;
    // flags: null;
    onlyNewSubscribers?: boolean;
    winnersAreVisible?: boolean;
    stars: long;
    boostPeer: Api.TypeInputPeer;
    additionalPeers?: Api.TypeInputPeer[];
    countriesIso2?: string[];
    prizeDescription?: string;
    randomId?: long;
    untilDate: int;
    currency: string;
    amount: long;
    users: int;
  }
  export class PremiumGiftOption extends VirtualClass<{
    // flags: null;
    months: int;
    currency: string;
    amount: long;
    botUrl: string;
    storeProduct?: string;
  }> {
  CONSTRUCTOR_ID: 1958953753;
  SUBCLASS_OF_ID: 1367519294;
  classType: "constructor";
  className: "PremiumGiftOption";
  static fromReader(reader: Reader): PremiumGiftOption;
    // flags: null;
    months: int;
    currency: string;
    amount: long;
    botUrl: string;
    storeProduct?: string;
  }
  export class PaymentFormMethod extends VirtualClass<{
    url: string;
    title: string;
  }> {
  CONSTRUCTOR_ID: 2298016283;
  SUBCLASS_OF_ID: 1069664278;
  classType: "constructor";
  className: "PaymentFormMethod";
  static fromReader(reader: Reader): PaymentFormMethod;
    url: string;
    title: string;
  }
  export class EmojiStatusEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 769727150;
  SUBCLASS_OF_ID: 4180717880;
  classType: "constructor";
  className: "EmojiStatusEmpty";
  static fromReader(reader: Reader): EmojiStatusEmpty;
}
  export class EmojiStatus extends VirtualClass<{
    // flags: null;
    documentId: long;
    until?: int;
  }> {
  CONSTRUCTOR_ID: 3892250250;
  SUBCLASS_OF_ID: 4180717880;
  classType: "constructor";
  className: "EmojiStatus";
  static fromReader(reader: Reader): EmojiStatus;
    // flags: null;
    documentId: long;
    until?: int;
  }
  export class EmojiStatusCollectible extends VirtualClass<{
    // flags: null;
    collectibleId: long;
    documentId: long;
    title: string;
    slug: string;
    patternDocumentId: long;
    centerColor: int;
    edgeColor: int;
    patternColor: int;
    textColor: int;
    until?: int;
  }> {
  CONSTRUCTOR_ID: 1904500795;
  SUBCLASS_OF_ID: 4180717880;
  classType: "constructor";
  className: "EmojiStatusCollectible";
  static fromReader(reader: Reader): EmojiStatusCollectible;
    // flags: null;
    collectibleId: long;
    documentId: long;
    title: string;
    slug: string;
    patternDocumentId: long;
    centerColor: int;
    edgeColor: int;
    patternColor: int;
    textColor: int;
    until?: int;
  }
  export class InputEmojiStatusCollectible extends VirtualClass<{
    // flags: null;
    collectibleId: long;
    until?: int;
  }> {
  CONSTRUCTOR_ID: 118758847;
  SUBCLASS_OF_ID: 4180717880;
  classType: "constructor";
  className: "InputEmojiStatusCollectible";
  static fromReader(reader: Reader): InputEmojiStatusCollectible;
    // flags: null;
    collectibleId: long;
    until?: int;
  }
  export class ReactionEmpty extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2046153753;
  SUBCLASS_OF_ID: 1570858401;
  classType: "constructor";
  className: "ReactionEmpty";
  static fromReader(reader: Reader): ReactionEmpty;
}
  export class ReactionEmoji extends VirtualClass<{
    emoticon: string;
  }> {
  CONSTRUCTOR_ID: 455247544;
  SUBCLASS_OF_ID: 1570858401;
  classType: "constructor";
  className: "ReactionEmoji";
  static fromReader(reader: Reader): ReactionEmoji;
    emoticon: string;
  }
  export class ReactionCustomEmoji extends VirtualClass<{
    documentId: long;
  }> {
  CONSTRUCTOR_ID: 2302016627;
  SUBCLASS_OF_ID: 1570858401;
  classType: "constructor";
  className: "ReactionCustomEmoji";
  static fromReader(reader: Reader): ReactionCustomEmoji;
    documentId: long;
  }
  export class ReactionPaid extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1379771627;
  SUBCLASS_OF_ID: 1570858401;
  classType: "constructor";
  className: "ReactionPaid";
  static fromReader(reader: Reader): ReactionPaid;
}
  export class ChatReactionsNone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3942396604;
  SUBCLASS_OF_ID: 320742581;
  classType: "constructor";
  className: "ChatReactionsNone";
  static fromReader(reader: Reader): ChatReactionsNone;
}
  export class ChatReactionsAll extends VirtualClass<{
    // flags: null;
    allowCustom?: boolean;
  }> {
  CONSTRUCTOR_ID: 1385335754;
  SUBCLASS_OF_ID: 320742581;
  classType: "constructor";
  className: "ChatReactionsAll";
  static fromReader(reader: Reader): ChatReactionsAll;
    // flags: null;
    allowCustom?: boolean;
  }
  export class ChatReactionsSome extends VirtualClass<{
    reactions: Api.TypeReaction[];
  }> {
  CONSTRUCTOR_ID: 1713193015;
  SUBCLASS_OF_ID: 320742581;
  classType: "constructor";
  className: "ChatReactionsSome";
  static fromReader(reader: Reader): ChatReactionsSome;
    reactions: Api.TypeReaction[];
  }
  export class EmailVerifyPurposeLoginSetup extends VirtualClass<{
    phoneNumber: string;
    phoneCodeHash: string;
  }> {
  CONSTRUCTOR_ID: 1128644211;
  SUBCLASS_OF_ID: 3110628072;
  classType: "constructor";
  className: "EmailVerifyPurposeLoginSetup";
  static fromReader(reader: Reader): EmailVerifyPurposeLoginSetup;
    phoneNumber: string;
    phoneCodeHash: string;
  }
  export class EmailVerifyPurposeLoginChange extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1383932651;
  SUBCLASS_OF_ID: 3110628072;
  classType: "constructor";
  className: "EmailVerifyPurposeLoginChange";
  static fromReader(reader: Reader): EmailVerifyPurposeLoginChange;
}
  export class EmailVerifyPurposePassport extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3153401477;
  SUBCLASS_OF_ID: 3110628072;
  classType: "constructor";
  className: "EmailVerifyPurposePassport";
  static fromReader(reader: Reader): EmailVerifyPurposePassport;
}
  export class EmailVerificationCode extends VirtualClass<{
    code: string;
  }> {
  CONSTRUCTOR_ID: 2452510121;
  SUBCLASS_OF_ID: 606003776;
  classType: "constructor";
  className: "EmailVerificationCode";
  static fromReader(reader: Reader): EmailVerificationCode;
    code: string;
  }
  export class EmailVerificationGoogle extends VirtualClass<{
    token: string;
  }> {
  CONSTRUCTOR_ID: 3683688130;
  SUBCLASS_OF_ID: 606003776;
  classType: "constructor";
  className: "EmailVerificationGoogle";
  static fromReader(reader: Reader): EmailVerificationGoogle;
    token: string;
  }
  export class EmailVerificationApple extends VirtualClass<{
    token: string;
  }> {
  CONSTRUCTOR_ID: 2530243837;
  SUBCLASS_OF_ID: 606003776;
  classType: "constructor";
  className: "EmailVerificationApple";
  static fromReader(reader: Reader): EmailVerificationApple;
    token: string;
  }
  export class PremiumSubscriptionOption extends VirtualClass<{
    // flags: null;
    current?: boolean;
    canPurchaseUpgrade?: boolean;
    transaction?: string;
    months: int;
    currency: string;
    amount: long;
    botUrl: string;
    storeProduct?: string;
  }> {
  CONSTRUCTOR_ID: 1596792306;
  SUBCLASS_OF_ID: 774752063;
  classType: "constructor";
  className: "PremiumSubscriptionOption";
  static fromReader(reader: Reader): PremiumSubscriptionOption;
    // flags: null;
    current?: boolean;
    canPurchaseUpgrade?: boolean;
    transaction?: string;
    months: int;
    currency: string;
    amount: long;
    botUrl: string;
    storeProduct?: string;
  }
  export class SendAsPeer extends VirtualClass<{
    // flags: null;
    premiumRequired?: boolean;
    peer: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 3088871476;
  SUBCLASS_OF_ID: 1143177700;
  classType: "constructor";
  className: "SendAsPeer";
  static fromReader(reader: Reader): SendAsPeer;
    // flags: null;
    premiumRequired?: boolean;
    peer: Api.TypePeer;
  }
  export class MessageExtendedMediaPreview extends VirtualClass<{
    // flags: null;
    w?: int;
    h?: int;
    thumb?: Api.TypePhotoSize;
    videoDuration?: int;
  }> {
  CONSTRUCTOR_ID: 2908916936;
  SUBCLASS_OF_ID: 2535971165;
  classType: "constructor";
  className: "MessageExtendedMediaPreview";
  static fromReader(reader: Reader): MessageExtendedMediaPreview;
    // flags: null;
    w?: int;
    h?: int;
    thumb?: Api.TypePhotoSize;
    videoDuration?: int;
  }
  export class MessageExtendedMedia extends VirtualClass<{
    media: Api.TypeMessageMedia;
  }> {
  CONSTRUCTOR_ID: 3997670500;
  SUBCLASS_OF_ID: 2535971165;
  classType: "constructor";
  className: "MessageExtendedMedia";
  static fromReader(reader: Reader): MessageExtendedMedia;
    media: Api.TypeMessageMedia;
  }
  export class StickerKeyword extends VirtualClass<{
    documentId: long;
    keyword: string[];
  }> {
  CONSTRUCTOR_ID: 4244550300;
  SUBCLASS_OF_ID: 1435835755;
  classType: "constructor";
  className: "StickerKeyword";
  static fromReader(reader: Reader): StickerKeyword;
    documentId: long;
    keyword: string[];
  }
  export class Username extends VirtualClass<{
    // flags: null;
    editable?: boolean;
    active?: boolean;
    username: string;
  }> {
  CONSTRUCTOR_ID: 3020371527;
  SUBCLASS_OF_ID: 19424289;
  classType: "constructor";
  className: "Username";
  static fromReader(reader: Reader): Username;
    // flags: null;
    editable?: boolean;
    active?: boolean;
    username: string;
  }
  export class ForumTopicDeleted extends VirtualClass<{
    id: int;
  }> {
  CONSTRUCTOR_ID: 37687451;
  SUBCLASS_OF_ID: 2367169027;
  classType: "constructor";
  className: "ForumTopicDeleted";
  static fromReader(reader: Reader): ForumTopicDeleted;
    id: int;
  }
  export class ForumTopic extends VirtualClass<{
    // flags: null;
    my?: boolean;
    closed?: boolean;
    pinned?: boolean;
    short?: boolean;
    hidden?: boolean;
    id: int;
    date: int;
    title: string;
    iconColor: int;
    iconEmojiId?: long;
    topMessage: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    unreadMentionsCount: int;
    unreadReactionsCount: int;
    fromId: Api.TypePeer;
    notifySettings: Api.TypePeerNotifySettings;
    draft?: Api.TypeDraftMessage;
  }> {
  CONSTRUCTOR_ID: 1903173033;
  SUBCLASS_OF_ID: 2367169027;
  classType: "constructor";
  className: "ForumTopic";
  static fromReader(reader: Reader): ForumTopic;
    // flags: null;
    my?: boolean;
    closed?: boolean;
    pinned?: boolean;
    short?: boolean;
    hidden?: boolean;
    id: int;
    date: int;
    title: string;
    iconColor: int;
    iconEmojiId?: long;
    topMessage: int;
    readInboxMaxId: int;
    readOutboxMaxId: int;
    unreadCount: int;
    unreadMentionsCount: int;
    unreadReactionsCount: int;
    fromId: Api.TypePeer;
    notifySettings: Api.TypePeerNotifySettings;
    draft?: Api.TypeDraftMessage;
  }
  export class DefaultHistoryTTL extends VirtualClass<{
    period: int;
  }> {
  CONSTRUCTOR_ID: 1135897376;
  SUBCLASS_OF_ID: 4027396967;
  classType: "constructor";
  className: "DefaultHistoryTTL";
  static fromReader(reader: Reader): DefaultHistoryTTL;
    period: int;
  }
  export class ExportedContactToken extends VirtualClass<{
    url: string;
    expires: int;
  }> {
  CONSTRUCTOR_ID: 1103040667;
  SUBCLASS_OF_ID: 2262679249;
  classType: "constructor";
  className: "ExportedContactToken";
  static fromReader(reader: Reader): ExportedContactToken;
    url: string;
    expires: int;
  }
  export class RequestPeerTypeUser extends VirtualClass<{
    // flags: null;
    bot?: Bool;
    premium?: Bool;
  }> {
  CONSTRUCTOR_ID: 1597737472;
  SUBCLASS_OF_ID: 3919636500;
  classType: "constructor";
  className: "RequestPeerTypeUser";
  static fromReader(reader: Reader): RequestPeerTypeUser;
    // flags: null;
    bot?: Bool;
    premium?: Bool;
  }
  export class RequestPeerTypeChat extends VirtualClass<{
    // flags: null;
    creator?: boolean;
    botParticipant?: boolean;
    hasUsername?: Bool;
    forum?: Bool;
    userAdminRights?: Api.TypeChatAdminRights;
    botAdminRights?: Api.TypeChatAdminRights;
  }> {
  CONSTRUCTOR_ID: 3387977243;
  SUBCLASS_OF_ID: 3919636500;
  classType: "constructor";
  className: "RequestPeerTypeChat";
  static fromReader(reader: Reader): RequestPeerTypeChat;
    // flags: null;
    creator?: boolean;
    botParticipant?: boolean;
    hasUsername?: Bool;
    forum?: Bool;
    userAdminRights?: Api.TypeChatAdminRights;
    botAdminRights?: Api.TypeChatAdminRights;
  }
  export class RequestPeerTypeBroadcast extends VirtualClass<{
    // flags: null;
    creator?: boolean;
    hasUsername?: Bool;
    userAdminRights?: Api.TypeChatAdminRights;
    botAdminRights?: Api.TypeChatAdminRights;
  }> {
  CONSTRUCTOR_ID: 865857388;
  SUBCLASS_OF_ID: 3919636500;
  classType: "constructor";
  className: "RequestPeerTypeBroadcast";
  static fromReader(reader: Reader): RequestPeerTypeBroadcast;
    // flags: null;
    creator?: boolean;
    hasUsername?: Bool;
    userAdminRights?: Api.TypeChatAdminRights;
    botAdminRights?: Api.TypeChatAdminRights;
  }
  export class EmojiListNotModified extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1209970170;
  SUBCLASS_OF_ID: 3169807034;
  classType: "constructor";
  className: "EmojiListNotModified";
  static fromReader(reader: Reader): EmojiListNotModified;
}
  export class EmojiList extends VirtualClass<{
    hash: long;
    documentId: long[];
  }> {
  CONSTRUCTOR_ID: 2048790993;
  SUBCLASS_OF_ID: 3169807034;
  classType: "constructor";
  className: "EmojiList";
  static fromReader(reader: Reader): EmojiList;
    hash: long;
    documentId: long[];
  }
  export class EmojiGroup extends VirtualClass<{
    title: string;
    iconEmojiId: long;
    emoticons: string[];
  }> {
  CONSTRUCTOR_ID: 2056961449;
  SUBCLASS_OF_ID: 1440784787;
  classType: "constructor";
  className: "EmojiGroup";
  static fromReader(reader: Reader): EmojiGroup;
    title: string;
    iconEmojiId: long;
    emoticons: string[];
  }
  export class EmojiGroupGreeting extends VirtualClass<{
    title: string;
    iconEmojiId: long;
    emoticons: string[];
  }> {
  CONSTRUCTOR_ID: 2161274055;
  SUBCLASS_OF_ID: 1440784787;
  classType: "constructor";
  className: "EmojiGroupGreeting";
  static fromReader(reader: Reader): EmojiGroupGreeting;
    title: string;
    iconEmojiId: long;
    emoticons: string[];
  }
  export class EmojiGroupPremium extends VirtualClass<{
    title: string;
    iconEmojiId: long;
  }> {
  CONSTRUCTOR_ID: 154914612;
  SUBCLASS_OF_ID: 1440784787;
  classType: "constructor";
  className: "EmojiGroupPremium";
  static fromReader(reader: Reader): EmojiGroupPremium;
    title: string;
    iconEmojiId: long;
  }
  export class TextWithEntities extends VirtualClass<{
    text: string;
    entities: Api.TypeMessageEntity[];
  }> {
  CONSTRUCTOR_ID: 1964978502;
  SUBCLASS_OF_ID: 2513062661;
  classType: "constructor";
  className: "TextWithEntities";
  static fromReader(reader: Reader): TextWithEntities;
    text: string;
    entities: Api.TypeMessageEntity[];
  }
  export class AutoSaveSettings extends VirtualClass<{
    // flags: null;
    photos?: boolean;
    videos?: boolean;
    videoMaxSize?: long;
  }> {
  CONSTRUCTOR_ID: 3360175310;
  SUBCLASS_OF_ID: 3443234534;
  classType: "constructor";
  className: "AutoSaveSettings";
  static fromReader(reader: Reader): AutoSaveSettings;
    // flags: null;
    photos?: boolean;
    videos?: boolean;
    videoMaxSize?: long;
  }
  export class AutoSaveException extends VirtualClass<{
    peer: Api.TypePeer;
    settings: Api.TypeAutoSaveSettings;
  }> {
  CONSTRUCTOR_ID: 2170563911;
  SUBCLASS_OF_ID: 3716579625;
  classType: "constructor";
  className: "AutoSaveException";
  static fromReader(reader: Reader): AutoSaveException;
    peer: Api.TypePeer;
    settings: Api.TypeAutoSaveSettings;
  }
  export class InputBotAppID extends VirtualClass<{
    id: long;
    accessHash: long;
  }> {
  CONSTRUCTOR_ID: 2837495162;
  SUBCLASS_OF_ID: 3059063121;
  classType: "constructor";
  className: "InputBotAppID";
  static fromReader(reader: Reader): InputBotAppID;
    id: long;
    accessHash: long;
  }
  export class InputBotAppShortName extends VirtualClass<{
    botId: Api.TypeInputUser;
    shortName: string;
  }> {
  CONSTRUCTOR_ID: 2425095175;
  SUBCLASS_OF_ID: 3059063121;
  classType: "constructor";
  className: "InputBotAppShortName";
  static fromReader(reader: Reader): InputBotAppShortName;
    botId: Api.TypeInputUser;
    shortName: string;
  }
  export class BotAppNotModified extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1571189943;
  SUBCLASS_OF_ID: 34550446;
  classType: "constructor";
  className: "BotAppNotModified";
  static fromReader(reader: Reader): BotAppNotModified;
}
  export class BotApp extends VirtualClass<{
    // flags: null;
    id: long;
    accessHash: long;
    shortName: string;
    title: string;
    description: string;
    photo: Api.TypePhoto;
    document?: Api.TypeDocument;
    hash: long;
  }> {
  CONSTRUCTOR_ID: 2516373974;
  SUBCLASS_OF_ID: 34550446;
  classType: "constructor";
  className: "BotApp";
  static fromReader(reader: Reader): BotApp;
    // flags: null;
    id: long;
    accessHash: long;
    shortName: string;
    title: string;
    description: string;
    photo: Api.TypePhoto;
    document?: Api.TypeDocument;
    hash: long;
  }
  export class InlineBotWebView extends VirtualClass<{
    text: string;
    url: string;
  }> {
  CONSTRUCTOR_ID: 3044185557;
  SUBCLASS_OF_ID: 1826625002;
  classType: "constructor";
  className: "InlineBotWebView";
  static fromReader(reader: Reader): InlineBotWebView;
    text: string;
    url: string;
  }
  export class ReadParticipantDate extends VirtualClass<{
    userId: long;
    date: int;
  }> {
  CONSTRUCTOR_ID: 1246753138;
  SUBCLASS_OF_ID: 4245130466;
  classType: "constructor";
  className: "ReadParticipantDate";
  static fromReader(reader: Reader): ReadParticipantDate;
    userId: long;
    date: int;
  }
  export class InputChatlistDialogFilter extends VirtualClass<{
    filterId: int;
  }> {
  CONSTRUCTOR_ID: 4091599411;
  SUBCLASS_OF_ID: 37721689;
  classType: "constructor";
  className: "InputChatlistDialogFilter";
  static fromReader(reader: Reader): InputChatlistDialogFilter;
    filterId: int;
  }
  export class ExportedChatlistInvite extends VirtualClass<{
    // flags: null;
    title: string;
    url: string;
    peers: Api.TypePeer[];
  }> {
  CONSTRUCTOR_ID: 206668204;
  SUBCLASS_OF_ID: 1997666559;
  classType: "constructor";
  className: "ExportedChatlistInvite";
  static fromReader(reader: Reader): ExportedChatlistInvite;
    // flags: null;
    title: string;
    url: string;
    peers: Api.TypePeer[];
  }
  export class MessagePeerVote extends VirtualClass<{
    peer: Api.TypePeer;
    option: bytes;
    date: int;
  }> {
  CONSTRUCTOR_ID: 3066834268;
  SUBCLASS_OF_ID: 2244112898;
  classType: "constructor";
  className: "MessagePeerVote";
  static fromReader(reader: Reader): MessagePeerVote;
    peer: Api.TypePeer;
    option: bytes;
    date: int;
  }
  export class MessagePeerVoteInputOption extends VirtualClass<{
    peer: Api.TypePeer;
    date: int;
  }> {
  CONSTRUCTOR_ID: 1959634180;
  SUBCLASS_OF_ID: 2244112898;
  classType: "constructor";
  className: "MessagePeerVoteInputOption";
  static fromReader(reader: Reader): MessagePeerVoteInputOption;
    peer: Api.TypePeer;
    date: int;
  }
  export class MessagePeerVoteMultiple extends VirtualClass<{
    peer: Api.TypePeer;
    options: bytes[];
    date: int;
  }> {
  CONSTRUCTOR_ID: 1177089766;
  SUBCLASS_OF_ID: 2244112898;
  classType: "constructor";
  className: "MessagePeerVoteMultiple";
  static fromReader(reader: Reader): MessagePeerVoteMultiple;
    peer: Api.TypePeer;
    options: bytes[];
    date: int;
  }
  export class StoryViews extends VirtualClass<{
    // flags: null;
    hasViewers?: boolean;
    viewsCount: int;
    forwardsCount?: int;
    reactions?: Api.TypeReactionCount[];
    reactionsCount?: int;
    recentViewers?: long[];
  }> {
  CONSTRUCTOR_ID: 2371443926;
  SUBCLASS_OF_ID: 1424272486;
  classType: "constructor";
  className: "StoryViews";
  static fromReader(reader: Reader): StoryViews;
    // flags: null;
    hasViewers?: boolean;
    viewsCount: int;
    forwardsCount?: int;
    reactions?: Api.TypeReactionCount[];
    reactionsCount?: int;
    recentViewers?: long[];
  }
  export class StoryItemDeleted extends VirtualClass<{
    id: int;
  }> {
  CONSTRUCTOR_ID: 1374088783;
  SUBCLASS_OF_ID: 3564613939;
  classType: "constructor";
  className: "StoryItemDeleted";
  static fromReader(reader: Reader): StoryItemDeleted;
    id: int;
  }
  export class StoryItemSkipped extends VirtualClass<{
    // flags: null;
    closeFriends?: boolean;
    id: int;
    date: int;
    expireDate: int;
  }> {
  CONSTRUCTOR_ID: 4289579283;
  SUBCLASS_OF_ID: 3564613939;
  classType: "constructor";
  className: "StoryItemSkipped";
  static fromReader(reader: Reader): StoryItemSkipped;
    // flags: null;
    closeFriends?: boolean;
    id: int;
    date: int;
    expireDate: int;
  }
  export class StoryItem extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    public?: boolean;
    closeFriends?: boolean;
    min?: boolean;
    noforwards?: boolean;
    edited?: boolean;
    contacts?: boolean;
    selectedContacts?: boolean;
    out?: boolean;
    id: int;
    date: int;
    fromId?: Api.TypePeer;
    fwdFrom?: Api.TypeStoryFwdHeader;
    expireDate: int;
    caption?: string;
    entities?: Api.TypeMessageEntity[];
    media: Api.TypeMessageMedia;
    mediaAreas?: Api.TypeMediaArea[];
    privacy?: Api.TypePrivacyRule[];
    views?: Api.TypeStoryViews;
    sentReaction?: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 2041735716;
  SUBCLASS_OF_ID: 3564613939;
  classType: "constructor";
  className: "StoryItem";
  static fromReader(reader: Reader): StoryItem;
    // flags: null;
    pinned?: boolean;
    public?: boolean;
    closeFriends?: boolean;
    min?: boolean;
    noforwards?: boolean;
    edited?: boolean;
    contacts?: boolean;
    selectedContacts?: boolean;
    out?: boolean;
    id: int;
    date: int;
    fromId?: Api.TypePeer;
    fwdFrom?: Api.TypeStoryFwdHeader;
    expireDate: int;
    caption?: string;
    entities?: Api.TypeMessageEntity[];
    media: Api.TypeMessageMedia;
    mediaAreas?: Api.TypeMediaArea[];
    privacy?: Api.TypePrivacyRule[];
    views?: Api.TypeStoryViews;
    sentReaction?: Api.TypeReaction;
  }
  export class StoryView extends VirtualClass<{
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    userId: long;
    date: int;
    reaction?: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 2965236421;
  SUBCLASS_OF_ID: 898711459;
  classType: "constructor";
  className: "StoryView";
  static fromReader(reader: Reader): StoryView;
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    userId: long;
    date: int;
    reaction?: Api.TypeReaction;
  }
  export class StoryViewPublicForward extends VirtualClass<{
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 2424530699;
  SUBCLASS_OF_ID: 898711459;
  classType: "constructor";
  className: "StoryViewPublicForward";
  static fromReader(reader: Reader): StoryViewPublicForward;
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    message: Api.TypeMessage;
  }
  export class StoryViewPublicRepost extends VirtualClass<{
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    peerId: Api.TypePeer;
    story: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 3178549065;
  SUBCLASS_OF_ID: 898711459;
  classType: "constructor";
  className: "StoryViewPublicRepost";
  static fromReader(reader: Reader): StoryViewPublicRepost;
    // flags: null;
    blocked?: boolean;
    blockedMyStoriesFrom?: boolean;
    peerId: Api.TypePeer;
    story: Api.TypeStoryItem;
  }
  export class InputReplyToMessage extends VirtualClass<{
    // flags: null;
    replyToMsgId: int;
    topMsgId?: int;
    replyToPeerId?: Api.TypeInputPeer;
    quoteText?: string;
    quoteEntities?: Api.TypeMessageEntity[];
    quoteOffset?: int;
  }> {
  CONSTRUCTOR_ID: 583071445;
  SUBCLASS_OF_ID: 2356220701;
  classType: "constructor";
  className: "InputReplyToMessage";
  static fromReader(reader: Reader): InputReplyToMessage;
    // flags: null;
    replyToMsgId: int;
    topMsgId?: int;
    replyToPeerId?: Api.TypeInputPeer;
    quoteText?: string;
    quoteEntities?: Api.TypeMessageEntity[];
    quoteOffset?: int;
  }
  export class InputReplyToStory extends VirtualClass<{
    peer: Api.TypeInputPeer;
    storyId: int;
  }> {
  CONSTRUCTOR_ID: 1484862010;
  SUBCLASS_OF_ID: 2356220701;
  classType: "constructor";
  className: "InputReplyToStory";
  static fromReader(reader: Reader): InputReplyToStory;
    peer: Api.TypeInputPeer;
    storyId: int;
  }
  export class ExportedStoryLink extends VirtualClass<{
    link: string;
  }> {
  CONSTRUCTOR_ID: 1070138683;
  SUBCLASS_OF_ID: 264585638;
  classType: "constructor";
  className: "ExportedStoryLink";
  static fromReader(reader: Reader): ExportedStoryLink;
    link: string;
  }
  export class StoriesStealthMode extends VirtualClass<{
    // flags: null;
    activeUntilDate?: int;
    cooldownUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 1898850301;
  SUBCLASS_OF_ID: 49120257;
  classType: "constructor";
  className: "StoriesStealthMode";
  static fromReader(reader: Reader): StoriesStealthMode;
    // flags: null;
    activeUntilDate?: int;
    cooldownUntilDate?: int;
  }
  export class MediaAreaCoordinates extends VirtualClass<{
    // flags: null;
    x: double;
    y: double;
    w: double;
    h: double;
    rotation: double;
    radius?: double;
  }> {
  CONSTRUCTOR_ID: 3486113794;
  SUBCLASS_OF_ID: 491031609;
  classType: "constructor";
  className: "MediaAreaCoordinates";
  static fromReader(reader: Reader): MediaAreaCoordinates;
    // flags: null;
    x: double;
    y: double;
    w: double;
    h: double;
    rotation: double;
    radius?: double;
  }
  export class MediaAreaVenue extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }> {
  CONSTRUCTOR_ID: 3196246940;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaVenue";
  static fromReader(reader: Reader): MediaAreaVenue;
    coordinates: Api.TypeMediaAreaCoordinates;
    geo: Api.TypeGeoPoint;
    title: string;
    address: string;
    provider: string;
    venueId: string;
    venueType: string;
  }
  export class InputMediaAreaVenue extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    queryId: long;
    resultId: string;
  }> {
  CONSTRUCTOR_ID: 2994872703;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "InputMediaAreaVenue";
  static fromReader(reader: Reader): InputMediaAreaVenue;
    coordinates: Api.TypeMediaAreaCoordinates;
    queryId: long;
    resultId: string;
  }
  export class MediaAreaGeoPoint extends VirtualClass<{
    // flags: null;
    coordinates: Api.TypeMediaAreaCoordinates;
    geo: Api.TypeGeoPoint;
    address?: Api.TypeGeoPointAddress;
  }> {
  CONSTRUCTOR_ID: 3402974509;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaGeoPoint";
  static fromReader(reader: Reader): MediaAreaGeoPoint;
    // flags: null;
    coordinates: Api.TypeMediaAreaCoordinates;
    geo: Api.TypeGeoPoint;
    address?: Api.TypeGeoPointAddress;
  }
  export class MediaAreaSuggestedReaction extends VirtualClass<{
    // flags: null;
    dark?: boolean;
    flipped?: boolean;
    coordinates: Api.TypeMediaAreaCoordinates;
    reaction: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 340088945;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaSuggestedReaction";
  static fromReader(reader: Reader): MediaAreaSuggestedReaction;
    // flags: null;
    dark?: boolean;
    flipped?: boolean;
    coordinates: Api.TypeMediaAreaCoordinates;
    reaction: Api.TypeReaction;
  }
  export class MediaAreaChannelPost extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    channelId: long;
    msgId: int;
  }> {
  CONSTRUCTOR_ID: 1996756655;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaChannelPost";
  static fromReader(reader: Reader): MediaAreaChannelPost;
    coordinates: Api.TypeMediaAreaCoordinates;
    channelId: long;
    msgId: int;
  }
  export class InputMediaAreaChannelPost extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    channel: Api.TypeInputChannel;
    msgId: int;
  }> {
  CONSTRUCTOR_ID: 577893055;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "InputMediaAreaChannelPost";
  static fromReader(reader: Reader): InputMediaAreaChannelPost;
    coordinates: Api.TypeMediaAreaCoordinates;
    channel: Api.TypeInputChannel;
    msgId: int;
  }
  export class MediaAreaUrl extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    url: string;
  }> {
  CONSTRUCTOR_ID: 926421125;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaUrl";
  static fromReader(reader: Reader): MediaAreaUrl;
    coordinates: Api.TypeMediaAreaCoordinates;
    url: string;
  }
  export class MediaAreaWeather extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    emoji: string;
    temperatureC: double;
    color: int;
  }> {
  CONSTRUCTOR_ID: 1235637404;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaWeather";
  static fromReader(reader: Reader): MediaAreaWeather;
    coordinates: Api.TypeMediaAreaCoordinates;
    emoji: string;
    temperatureC: double;
    color: int;
  }
  export class MediaAreaStarGift extends VirtualClass<{
    coordinates: Api.TypeMediaAreaCoordinates;
    slug: string;
  }> {
  CONSTRUCTOR_ID: 1468491885;
  SUBCLASS_OF_ID: 4084038642;
  classType: "constructor";
  className: "MediaAreaStarGift";
  static fromReader(reader: Reader): MediaAreaStarGift;
    coordinates: Api.TypeMediaAreaCoordinates;
    slug: string;
  }
  export class PeerStories extends VirtualClass<{
    // flags: null;
    peer: Api.TypePeer;
    maxReadId?: int;
    stories: Api.TypeStoryItem[];
  }> {
  CONSTRUCTOR_ID: 2587224473;
  SUBCLASS_OF_ID: 304908871;
  classType: "constructor";
  className: "PeerStories";
  static fromReader(reader: Reader): PeerStories;
    // flags: null;
    peer: Api.TypePeer;
    maxReadId?: int;
    stories: Api.TypeStoryItem[];
  }
  export class PremiumGiftCodeOption extends VirtualClass<{
    // flags: null;
    users: int;
    months: int;
    storeProduct?: string;
    storeQuantity?: int;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 629052971;
  SUBCLASS_OF_ID: 2216898;
  classType: "constructor";
  className: "PremiumGiftCodeOption";
  static fromReader(reader: Reader): PremiumGiftCodeOption;
    // flags: null;
    users: int;
    months: int;
    storeProduct?: string;
    storeQuantity?: int;
    currency: string;
    amount: long;
  }
  export class PrepaidGiveaway extends VirtualClass<{
    id: long;
    months: int;
    quantity: int;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2991824212;
  SUBCLASS_OF_ID: 3997067136;
  classType: "constructor";
  className: "PrepaidGiveaway";
  static fromReader(reader: Reader): PrepaidGiveaway;
    id: long;
    months: int;
    quantity: int;
    date: int;
  }
  export class PrepaidStarsGiveaway extends VirtualClass<{
    id: long;
    stars: long;
    quantity: int;
    boosts: int;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2594011104;
  SUBCLASS_OF_ID: 3997067136;
  classType: "constructor";
  className: "PrepaidStarsGiveaway";
  static fromReader(reader: Reader): PrepaidStarsGiveaway;
    id: long;
    stars: long;
    quantity: int;
    boosts: int;
    date: int;
  }
  export class Boost extends VirtualClass<{
    // flags: null;
    gift?: boolean;
    giveaway?: boolean;
    unclaimed?: boolean;
    id: string;
    userId?: long;
    giveawayMsgId?: int;
    date: int;
    expires: int;
    usedGiftSlug?: string;
    multiplier?: int;
    stars?: long;
  }> {
  CONSTRUCTOR_ID: 1262359766;
  SUBCLASS_OF_ID: 2544175212;
  classType: "constructor";
  className: "Boost";
  static fromReader(reader: Reader): Boost;
    // flags: null;
    gift?: boolean;
    giveaway?: boolean;
    unclaimed?: boolean;
    id: string;
    userId?: long;
    giveawayMsgId?: int;
    date: int;
    expires: int;
    usedGiftSlug?: string;
    multiplier?: int;
    stars?: long;
  }
  export class MyBoost extends VirtualClass<{
    // flags: null;
    slot: int;
    peer?: Api.TypePeer;
    date: int;
    expires: int;
    cooldownUntilDate?: int;
  }> {
  CONSTRUCTOR_ID: 3293069660;
  SUBCLASS_OF_ID: 3306842303;
  classType: "constructor";
  className: "MyBoost";
  static fromReader(reader: Reader): MyBoost;
    // flags: null;
    slot: int;
    peer?: Api.TypePeer;
    date: int;
    expires: int;
    cooldownUntilDate?: int;
  }
  export class StoryFwdHeader extends VirtualClass<{
    // flags: null;
    modified?: boolean;
    from?: Api.TypePeer;
    fromName?: string;
    storyId?: int;
  }> {
  CONSTRUCTOR_ID: 3089555792;
  SUBCLASS_OF_ID: 2863706412;
  classType: "constructor";
  className: "StoryFwdHeader";
  static fromReader(reader: Reader): StoryFwdHeader;
    // flags: null;
    modified?: boolean;
    from?: Api.TypePeer;
    fromName?: string;
    storyId?: int;
  }
  export class PostInteractionCountersMessage extends VirtualClass<{
    msgId: int;
    views: int;
    forwards: int;
    reactions: int;
  }> {
  CONSTRUCTOR_ID: 3875901055;
  SUBCLASS_OF_ID: 1850361243;
  classType: "constructor";
  className: "PostInteractionCountersMessage";
  static fromReader(reader: Reader): PostInteractionCountersMessage;
    msgId: int;
    views: int;
    forwards: int;
    reactions: int;
  }
  export class PostInteractionCountersStory extends VirtualClass<{
    storyId: int;
    views: int;
    forwards: int;
    reactions: int;
  }> {
  CONSTRUCTOR_ID: 2319978023;
  SUBCLASS_OF_ID: 1850361243;
  classType: "constructor";
  className: "PostInteractionCountersStory";
  static fromReader(reader: Reader): PostInteractionCountersStory;
    storyId: int;
    views: int;
    forwards: int;
    reactions: int;
  }
  export class PublicForwardMessage extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 32685898;
  SUBCLASS_OF_ID: 1653609939;
  classType: "constructor";
  className: "PublicForwardMessage";
  static fromReader(reader: Reader): PublicForwardMessage;
    message: Api.TypeMessage;
  }
  export class PublicForwardStory extends VirtualClass<{
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 3992169936;
  SUBCLASS_OF_ID: 1653609939;
  classType: "constructor";
  className: "PublicForwardStory";
  static fromReader(reader: Reader): PublicForwardStory;
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }
  export class PeerColor extends VirtualClass<{
    // flags: null;
    color?: int;
    backgroundEmojiId?: long;
  }> {
  CONSTRUCTOR_ID: 3041614543;
  SUBCLASS_OF_ID: 4068582527;
  classType: "constructor";
  className: "PeerColor";
  static fromReader(reader: Reader): PeerColor;
    // flags: null;
    color?: int;
    backgroundEmojiId?: long;
  }
  export class StoryReaction extends VirtualClass<{
    peerId: Api.TypePeer;
    date: int;
    reaction: Api.TypeReaction;
  }> {
  CONSTRUCTOR_ID: 1620104917;
  SUBCLASS_OF_ID: 3379257259;
  classType: "constructor";
  className: "StoryReaction";
  static fromReader(reader: Reader): StoryReaction;
    peerId: Api.TypePeer;
    date: int;
    reaction: Api.TypeReaction;
  }
  export class StoryReactionPublicForward extends VirtualClass<{
    message: Api.TypeMessage;
  }> {
  CONSTRUCTOR_ID: 3148555843;
  SUBCLASS_OF_ID: 3379257259;
  classType: "constructor";
  className: "StoryReactionPublicForward";
  static fromReader(reader: Reader): StoryReactionPublicForward;
    message: Api.TypeMessage;
  }
  export class StoryReactionPublicRepost extends VirtualClass<{
    peerId: Api.TypePeer;
    story: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 3486322451;
  SUBCLASS_OF_ID: 3379257259;
  classType: "constructor";
  className: "StoryReactionPublicRepost";
  static fromReader(reader: Reader): StoryReactionPublicRepost;
    peerId: Api.TypePeer;
    story: Api.TypeStoryItem;
  }
  export class SavedDialog extends VirtualClass<{
    // flags: null;
    pinned?: boolean;
    peer: Api.TypePeer;
    topMessage: int;
  }> {
  CONSTRUCTOR_ID: 3179793260;
  SUBCLASS_OF_ID: 599418118;
  classType: "constructor";
  className: "SavedDialog";
  static fromReader(reader: Reader): SavedDialog;
    // flags: null;
    pinned?: boolean;
    peer: Api.TypePeer;
    topMessage: int;
  }
  export class SavedReactionTag extends VirtualClass<{
    // flags: null;
    reaction: Api.TypeReaction;
    title?: string;
    count: int;
  }> {
  CONSTRUCTOR_ID: 3413112872;
  SUBCLASS_OF_ID: 3983021080;
  classType: "constructor";
  className: "SavedReactionTag";
  static fromReader(reader: Reader): SavedReactionTag;
    // flags: null;
    reaction: Api.TypeReaction;
    title?: string;
    count: int;
  }
  export class OutboxReadDate extends VirtualClass<{
    date: int;
  }> {
  CONSTRUCTOR_ID: 1001931436;
  SUBCLASS_OF_ID: 1867613126;
  classType: "constructor";
  className: "OutboxReadDate";
  static fromReader(reader: Reader): OutboxReadDate;
    date: int;
  }
  export class SmsJob extends VirtualClass<{
    jobId: string;
    phoneNumber: string;
    text: string;
  }> {
  CONSTRUCTOR_ID: 3869372088;
  SUBCLASS_OF_ID: 522459262;
  classType: "constructor";
  className: "SmsJob";
  static fromReader(reader: Reader): SmsJob;
    jobId: string;
    phoneNumber: string;
    text: string;
  }
  export class BusinessWeeklyOpen extends VirtualClass<{
    startMinute: int;
    endMinute: int;
  }> {
  CONSTRUCTOR_ID: 302717625;
  SUBCLASS_OF_ID: 406857255;
  classType: "constructor";
  className: "BusinessWeeklyOpen";
  static fromReader(reader: Reader): BusinessWeeklyOpen;
    startMinute: int;
    endMinute: int;
  }
  export class BusinessWorkHours extends VirtualClass<{
    // flags: null;
    openNow?: boolean;
    timezoneId: string;
    weeklyOpen: Api.TypeBusinessWeeklyOpen[];
  }> {
  CONSTRUCTOR_ID: 2358423704;
  SUBCLASS_OF_ID: 1704962053;
  classType: "constructor";
  className: "BusinessWorkHours";
  static fromReader(reader: Reader): BusinessWorkHours;
    // flags: null;
    openNow?: boolean;
    timezoneId: string;
    weeklyOpen: Api.TypeBusinessWeeklyOpen[];
  }
  export class BusinessLocation extends VirtualClass<{
    // flags: null;
    geoPoint?: Api.TypeGeoPoint;
    address: string;
  }> {
  CONSTRUCTOR_ID: 2891717367;
  SUBCLASS_OF_ID: 2578238160;
  classType: "constructor";
  className: "BusinessLocation";
  static fromReader(reader: Reader): BusinessLocation;
    // flags: null;
    geoPoint?: Api.TypeGeoPoint;
    address: string;
  }
  export class InputBusinessRecipients extends VirtualClass<{
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: Api.TypeInputUser[];
  }> {
  CONSTRUCTOR_ID: 1871393450;
  SUBCLASS_OF_ID: 226420031;
  classType: "constructor";
  className: "InputBusinessRecipients";
  static fromReader(reader: Reader): InputBusinessRecipients;
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: Api.TypeInputUser[];
  }
  export class BusinessRecipients extends VirtualClass<{
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: long[];
  }> {
  CONSTRUCTOR_ID: 554733559;
  SUBCLASS_OF_ID: 1384459846;
  classType: "constructor";
  className: "BusinessRecipients";
  static fromReader(reader: Reader): BusinessRecipients;
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: long[];
  }
  export class BusinessAwayMessageScheduleAlways extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3384402617;
  SUBCLASS_OF_ID: 672702558;
  classType: "constructor";
  className: "BusinessAwayMessageScheduleAlways";
  static fromReader(reader: Reader): BusinessAwayMessageScheduleAlways;
}
  export class BusinessAwayMessageScheduleOutsideWorkHours extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3287479553;
  SUBCLASS_OF_ID: 672702558;
  classType: "constructor";
  className: "BusinessAwayMessageScheduleOutsideWorkHours";
  static fromReader(reader: Reader): BusinessAwayMessageScheduleOutsideWorkHours;
}
  export class BusinessAwayMessageScheduleCustom extends VirtualClass<{
    startDate: int;
    endDate: int;
  }> {
  CONSTRUCTOR_ID: 3427638988;
  SUBCLASS_OF_ID: 672702558;
  classType: "constructor";
  className: "BusinessAwayMessageScheduleCustom";
  static fromReader(reader: Reader): BusinessAwayMessageScheduleCustom;
    startDate: int;
    endDate: int;
  }
  export class InputBusinessGreetingMessage extends VirtualClass<{
    shortcutId: int;
    recipients: Api.TypeInputBusinessRecipients;
    noActivityDays: int;
  }> {
  CONSTRUCTOR_ID: 26528571;
  SUBCLASS_OF_ID: 1652088029;
  classType: "constructor";
  className: "InputBusinessGreetingMessage";
  static fromReader(reader: Reader): InputBusinessGreetingMessage;
    shortcutId: int;
    recipients: Api.TypeInputBusinessRecipients;
    noActivityDays: int;
  }
  export class BusinessGreetingMessage extends VirtualClass<{
    shortcutId: int;
    recipients: Api.TypeBusinessRecipients;
    noActivityDays: int;
  }> {
  CONSTRUCTOR_ID: 3843664811;
  SUBCLASS_OF_ID: 3007638222;
  classType: "constructor";
  className: "BusinessGreetingMessage";
  static fromReader(reader: Reader): BusinessGreetingMessage;
    shortcutId: int;
    recipients: Api.TypeBusinessRecipients;
    noActivityDays: int;
  }
  export class InputBusinessAwayMessage extends VirtualClass<{
    // flags: null;
    offlineOnly?: boolean;
    shortcutId: int;
    schedule: Api.TypeBusinessAwayMessageSchedule;
    recipients: Api.TypeInputBusinessRecipients;
  }> {
  CONSTRUCTOR_ID: 2200008160;
  SUBCLASS_OF_ID: 3629489271;
  classType: "constructor";
  className: "InputBusinessAwayMessage";
  static fromReader(reader: Reader): InputBusinessAwayMessage;
    // flags: null;
    offlineOnly?: boolean;
    shortcutId: int;
    schedule: Api.TypeBusinessAwayMessageSchedule;
    recipients: Api.TypeInputBusinessRecipients;
  }
  export class BusinessAwayMessage extends VirtualClass<{
    // flags: null;
    offlineOnly?: boolean;
    shortcutId: int;
    schedule: Api.TypeBusinessAwayMessageSchedule;
    recipients: Api.TypeBusinessRecipients;
  }> {
  CONSTRUCTOR_ID: 4011158108;
  SUBCLASS_OF_ID: 4057181732;
  classType: "constructor";
  className: "BusinessAwayMessage";
  static fromReader(reader: Reader): BusinessAwayMessage;
    // flags: null;
    offlineOnly?: boolean;
    shortcutId: int;
    schedule: Api.TypeBusinessAwayMessageSchedule;
    recipients: Api.TypeBusinessRecipients;
  }
  export class Timezone extends VirtualClass<{
    id: string;
    name: string;
    utcOffset: int;
  }> {
  CONSTRUCTOR_ID: 4287793653;
  SUBCLASS_OF_ID: 3463958721;
  classType: "constructor";
  className: "Timezone";
  static fromReader(reader: Reader): Timezone;
    id: string;
    name: string;
    utcOffset: int;
  }
  export class QuickReply extends VirtualClass<{
    shortcutId: int;
    shortcut: string;
    topMessage: int;
    count: int;
  }> {
  CONSTRUCTOR_ID: 110563371;
  SUBCLASS_OF_ID: 3806990098;
  classType: "constructor";
  className: "QuickReply";
  static fromReader(reader: Reader): QuickReply;
    shortcutId: int;
    shortcut: string;
    topMessage: int;
    count: int;
  }
  export class InputQuickReplyShortcut extends VirtualClass<{
    shortcut: string;
  }> {
  CONSTRUCTOR_ID: 609840449;
  SUBCLASS_OF_ID: 2775088215;
  classType: "constructor";
  className: "InputQuickReplyShortcut";
  static fromReader(reader: Reader): InputQuickReplyShortcut;
    shortcut: string;
  }
  export class InputQuickReplyShortcutId extends VirtualClass<{
    shortcutId: int;
  }> {
  CONSTRUCTOR_ID: 18418929;
  SUBCLASS_OF_ID: 2775088215;
  classType: "constructor";
  className: "InputQuickReplyShortcutId";
  static fromReader(reader: Reader): InputQuickReplyShortcutId;
    shortcutId: int;
  }
  export class ConnectedBot extends VirtualClass<{
    // flags: null;
    canReply?: boolean;
    botId: long;
    recipients: Api.TypeBusinessBotRecipients;
  }> {
  CONSTRUCTOR_ID: 3171321345;
  SUBCLASS_OF_ID: 904403870;
  classType: "constructor";
  className: "ConnectedBot";
  static fromReader(reader: Reader): ConnectedBot;
    // flags: null;
    canReply?: boolean;
    botId: long;
    recipients: Api.TypeBusinessBotRecipients;
  }
  export class Birthday extends VirtualClass<{
    // flags: null;
    day: int;
    month: int;
    year?: int;
  }> {
  CONSTRUCTOR_ID: 1821253126;
  SUBCLASS_OF_ID: 3196048996;
  classType: "constructor";
  className: "Birthday";
  static fromReader(reader: Reader): Birthday;
    // flags: null;
    day: int;
    month: int;
    year?: int;
  }
  export class BotBusinessConnection extends VirtualClass<{
    // flags: null;
    canReply?: boolean;
    disabled?: boolean;
    connectionId: string;
    userId: long;
    dcId: int;
    date: int;
  }> {
  CONSTRUCTOR_ID: 2305045428;
  SUBCLASS_OF_ID: 2601715014;
  classType: "constructor";
  className: "BotBusinessConnection";
  static fromReader(reader: Reader): BotBusinessConnection;
    // flags: null;
    canReply?: boolean;
    disabled?: boolean;
    connectionId: string;
    userId: long;
    dcId: int;
    date: int;
  }
  export class InputBusinessIntro extends VirtualClass<{
    // flags: null;
    title: string;
    description: string;
    sticker?: Api.TypeInputDocument;
  }> {
  CONSTRUCTOR_ID: 163867085;
  SUBCLASS_OF_ID: 1683650173;
  classType: "constructor";
  className: "InputBusinessIntro";
  static fromReader(reader: Reader): InputBusinessIntro;
    // flags: null;
    title: string;
    description: string;
    sticker?: Api.TypeInputDocument;
  }
  export class BusinessIntro extends VirtualClass<{
    // flags: null;
    title: string;
    description: string;
    sticker?: Api.TypeDocument;
  }> {
  CONSTRUCTOR_ID: 1510606445;
  SUBCLASS_OF_ID: 1694815175;
  classType: "constructor";
  className: "BusinessIntro";
  static fromReader(reader: Reader): BusinessIntro;
    // flags: null;
    title: string;
    description: string;
    sticker?: Api.TypeDocument;
  }
  export class InputCollectibleUsername extends VirtualClass<{
    username: string;
  }> {
  CONSTRUCTOR_ID: 3818152105;
  SUBCLASS_OF_ID: 705659371;
  classType: "constructor";
  className: "InputCollectibleUsername";
  static fromReader(reader: Reader): InputCollectibleUsername;
    username: string;
  }
  export class InputCollectiblePhone extends VirtualClass<{
    phone: string;
  }> {
  CONSTRUCTOR_ID: 2732725412;
  SUBCLASS_OF_ID: 705659371;
  classType: "constructor";
  className: "InputCollectiblePhone";
  static fromReader(reader: Reader): InputCollectiblePhone;
    phone: string;
  }
  export class InputBusinessBotRecipients extends VirtualClass<{
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: Api.TypeInputUser[];
    excludeUsers?: Api.TypeInputUser[];
  }> {
  CONSTRUCTOR_ID: 3303379486;
  SUBCLASS_OF_ID: 2849240411;
  classType: "constructor";
  className: "InputBusinessBotRecipients";
  static fromReader(reader: Reader): InputBusinessBotRecipients;
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: Api.TypeInputUser[];
    excludeUsers?: Api.TypeInputUser[];
  }
  export class BusinessBotRecipients extends VirtualClass<{
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: long[];
    excludeUsers?: long[];
  }> {
  CONSTRUCTOR_ID: 3096245107;
  SUBCLASS_OF_ID: 4036133834;
  classType: "constructor";
  className: "BusinessBotRecipients";
  static fromReader(reader: Reader): BusinessBotRecipients;
    // flags: null;
    existingChats?: boolean;
    newChats?: boolean;
    contacts?: boolean;
    nonContacts?: boolean;
    excludeSelected?: boolean;
    users?: long[];
    excludeUsers?: long[];
  }
  export class ContactBirthday extends VirtualClass<{
    contactId: long;
    birthday: Api.TypeBirthday;
  }> {
  CONSTRUCTOR_ID: 496600883;
  SUBCLASS_OF_ID: 3638372358;
  classType: "constructor";
  className: "ContactBirthday";
  static fromReader(reader: Reader): ContactBirthday;
    contactId: long;
    birthday: Api.TypeBirthday;
  }
  export class MissingInvitee extends VirtualClass<{
    // flags: null;
    premiumWouldAllowInvite?: boolean;
    premiumRequiredForPm?: boolean;
    userId: long;
  }> {
  CONSTRUCTOR_ID: 1653379620;
  SUBCLASS_OF_ID: 1552723164;
  classType: "constructor";
  className: "MissingInvitee";
  static fromReader(reader: Reader): MissingInvitee;
    // flags: null;
    premiumWouldAllowInvite?: boolean;
    premiumRequiredForPm?: boolean;
    userId: long;
  }
  export class InputBusinessChatLink extends VirtualClass<{
    // flags: null;
    message: string;
    entities?: Api.TypeMessageEntity[];
    title?: string;
  }> {
  CONSTRUCTOR_ID: 292003751;
  SUBCLASS_OF_ID: 2875655443;
  classType: "constructor";
  className: "InputBusinessChatLink";
  static fromReader(reader: Reader): InputBusinessChatLink;
    // flags: null;
    message: string;
    entities?: Api.TypeMessageEntity[];
    title?: string;
  }
  export class BusinessChatLink extends VirtualClass<{
    // flags: null;
    link: string;
    message: string;
    entities?: Api.TypeMessageEntity[];
    title?: string;
    views: int;
  }> {
  CONSTRUCTOR_ID: 3031328367;
  SUBCLASS_OF_ID: 1007504011;
  classType: "constructor";
  className: "BusinessChatLink";
  static fromReader(reader: Reader): BusinessChatLink;
    // flags: null;
    link: string;
    message: string;
    entities?: Api.TypeMessageEntity[];
    title?: string;
    views: int;
  }
  export class RequestedPeerUser extends VirtualClass<{
    // flags: null;
    userId: long;
    firstName?: string;
    lastName?: string;
    username?: string;
    photo?: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 3593466986;
  SUBCLASS_OF_ID: 3263724560;
  classType: "constructor";
  className: "RequestedPeerUser";
  static fromReader(reader: Reader): RequestedPeerUser;
    // flags: null;
    userId: long;
    firstName?: string;
    lastName?: string;
    username?: string;
    photo?: Api.TypePhoto;
  }
  export class RequestedPeerChat extends VirtualClass<{
    // flags: null;
    chatId: long;
    title?: string;
    photo?: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 1929860175;
  SUBCLASS_OF_ID: 3263724560;
  classType: "constructor";
  className: "RequestedPeerChat";
  static fromReader(reader: Reader): RequestedPeerChat;
    // flags: null;
    chatId: long;
    title?: string;
    photo?: Api.TypePhoto;
  }
  export class RequestedPeerChannel extends VirtualClass<{
    // flags: null;
    channelId: long;
    title?: string;
    username?: string;
    photo?: Api.TypePhoto;
  }> {
  CONSTRUCTOR_ID: 2342781924;
  SUBCLASS_OF_ID: 3263724560;
  classType: "constructor";
  className: "RequestedPeerChannel";
  static fromReader(reader: Reader): RequestedPeerChannel;
    // flags: null;
    channelId: long;
    title?: string;
    username?: string;
    photo?: Api.TypePhoto;
  }
  export class SponsoredMessageReportOption extends VirtualClass<{
    text: string;
    option: bytes;
  }> {
  CONSTRUCTOR_ID: 1124938064;
  SUBCLASS_OF_ID: 3711084312;
  classType: "constructor";
  className: "SponsoredMessageReportOption";
  static fromReader(reader: Reader): SponsoredMessageReportOption;
    text: string;
    option: bytes;
  }
  export class BroadcastRevenueTransactionProceeds extends VirtualClass<{
    amount: long;
    fromDate: int;
    toDate: int;
  }> {
  CONSTRUCTOR_ID: 1434332356;
  SUBCLASS_OF_ID: 1962590909;
  classType: "constructor";
  className: "BroadcastRevenueTransactionProceeds";
  static fromReader(reader: Reader): BroadcastRevenueTransactionProceeds;
    amount: long;
    fromDate: int;
    toDate: int;
  }
  export class BroadcastRevenueTransactionWithdrawal extends VirtualClass<{
    // flags: null;
    pending?: boolean;
    failed?: boolean;
    amount: long;
    date: int;
    provider: string;
    transactionDate?: int;
    transactionUrl?: string;
  }> {
  CONSTRUCTOR_ID: 1515784568;
  SUBCLASS_OF_ID: 1962590909;
  classType: "constructor";
  className: "BroadcastRevenueTransactionWithdrawal";
  static fromReader(reader: Reader): BroadcastRevenueTransactionWithdrawal;
    // flags: null;
    pending?: boolean;
    failed?: boolean;
    amount: long;
    date: int;
    provider: string;
    transactionDate?: int;
    transactionUrl?: string;
  }
  export class BroadcastRevenueTransactionRefund extends VirtualClass<{
    amount: long;
    date: int;
    provider: string;
  }> {
  CONSTRUCTOR_ID: 1121127726;
  SUBCLASS_OF_ID: 1962590909;
  classType: "constructor";
  className: "BroadcastRevenueTransactionRefund";
  static fromReader(reader: Reader): BroadcastRevenueTransactionRefund;
    amount: long;
    date: int;
    provider: string;
  }
  export class ReactionNotificationsFromContacts extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3133384218;
  SUBCLASS_OF_ID: 878672192;
  classType: "constructor";
  className: "ReactionNotificationsFromContacts";
  static fromReader(reader: Reader): ReactionNotificationsFromContacts;
}
  export class ReactionNotificationsFromAll extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1268654752;
  SUBCLASS_OF_ID: 878672192;
  classType: "constructor";
  className: "ReactionNotificationsFromAll";
  static fromReader(reader: Reader): ReactionNotificationsFromAll;
}
  export class ReactionsNotifySettings extends VirtualClass<{
    // flags: null;
    messagesNotifyFrom?: Api.TypeReactionNotificationsFrom;
    storiesNotifyFrom?: Api.TypeReactionNotificationsFrom;
    sound: Api.TypeNotificationSound;
    showPreviews: Bool;
  }> {
  CONSTRUCTOR_ID: 1457736048;
  SUBCLASS_OF_ID: 2382301265;
  classType: "constructor";
  className: "ReactionsNotifySettings";
  static fromReader(reader: Reader): ReactionsNotifySettings;
    // flags: null;
    messagesNotifyFrom?: Api.TypeReactionNotificationsFrom;
    storiesNotifyFrom?: Api.TypeReactionNotificationsFrom;
    sound: Api.TypeNotificationSound;
    showPreviews: Bool;
  }
  export class BroadcastRevenueBalances extends VirtualClass<{
    // flags: null;
    withdrawalEnabled?: boolean;
    currentBalance: long;
    availableBalance: long;
    overallRevenue: long;
  }> {
  CONSTRUCTOR_ID: 3288297959;
  SUBCLASS_OF_ID: 365072370;
  classType: "constructor";
  className: "BroadcastRevenueBalances";
  static fromReader(reader: Reader): BroadcastRevenueBalances;
    // flags: null;
    withdrawalEnabled?: boolean;
    currentBalance: long;
    availableBalance: long;
    overallRevenue: long;
  }
  export class AvailableEffect extends VirtualClass<{
    // flags: null;
    premiumRequired?: boolean;
    id: long;
    emoticon: string;
    staticIconId?: long;
    effectStickerId: long;
    effectAnimationId?: long;
  }> {
  CONSTRUCTOR_ID: 2479088254;
  SUBCLASS_OF_ID: 2556047233;
  classType: "constructor";
  className: "AvailableEffect";
  static fromReader(reader: Reader): AvailableEffect;
    // flags: null;
    premiumRequired?: boolean;
    id: long;
    emoticon: string;
    staticIconId?: long;
    effectStickerId: long;
    effectAnimationId?: long;
  }
  export class FactCheck extends VirtualClass<{
    // flags: null;
    needCheck?: boolean;
    country?: string;
    text?: Api.TypeTextWithEntities;
    hash: long;
  }> {
  CONSTRUCTOR_ID: 3097230543;
  SUBCLASS_OF_ID: 1178641315;
  classType: "constructor";
  className: "FactCheck";
  static fromReader(reader: Reader): FactCheck;
    // flags: null;
    needCheck?: boolean;
    country?: string;
    text?: Api.TypeTextWithEntities;
    hash: long;
  }
  export class StarsTransactionPeerUnsupported extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2515714020;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerUnsupported";
  static fromReader(reader: Reader): StarsTransactionPeerUnsupported;
}
  export class StarsTransactionPeerAppStore extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3025646453;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerAppStore";
  static fromReader(reader: Reader): StarsTransactionPeerAppStore;
}
  export class StarsTransactionPeerPlayMarket extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2069236235;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerPlayMarket";
  static fromReader(reader: Reader): StarsTransactionPeerPlayMarket;
}
  export class StarsTransactionPeerPremiumBot extends VirtualClass<void> {
  CONSTRUCTOR_ID: 621656824;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerPremiumBot";
  static fromReader(reader: Reader): StarsTransactionPeerPremiumBot;
}
  export class StarsTransactionPeerFragment extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3912227074;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerFragment";
  static fromReader(reader: Reader): StarsTransactionPeerFragment;
}
  export class StarsTransactionPeer extends VirtualClass<{
    peer: Api.TypePeer;
  }> {
  CONSTRUCTOR_ID: 3624771933;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeer";
  static fromReader(reader: Reader): StarsTransactionPeer;
    peer: Api.TypePeer;
  }
  export class StarsTransactionPeerAds extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1617438738;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerAds";
  static fromReader(reader: Reader): StarsTransactionPeerAds;
}
  export class StarsTransactionPeerAPI extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4184308397;
  SUBCLASS_OF_ID: 1102483843;
  classType: "constructor";
  className: "StarsTransactionPeerAPI";
  static fromReader(reader: Reader): StarsTransactionPeerAPI;
}
  export class StarsTopupOption extends VirtualClass<{
    // flags: null;
    extended?: boolean;
    stars: long;
    storeProduct?: string;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 198776256;
  SUBCLASS_OF_ID: 3854345708;
  classType: "constructor";
  className: "StarsTopupOption";
  static fromReader(reader: Reader): StarsTopupOption;
    // flags: null;
    extended?: boolean;
    stars: long;
    storeProduct?: string;
    currency: string;
    amount: long;
  }
  export class StarsTransaction extends VirtualClass<{
    // flags: null;
    refund?: boolean;
    pending?: boolean;
    failed?: boolean;
    gift?: boolean;
    reaction?: boolean;
    stargiftUpgrade?: boolean;
    id: string;
    stars: Api.TypeStarsAmount;
    date: int;
    peer: Api.TypeStarsTransactionPeer;
    title?: string;
    description?: string;
    photo?: Api.TypeWebDocument;
    transactionDate?: int;
    transactionUrl?: string;
    botPayload?: bytes;
    msgId?: int;
    extendedMedia?: Api.TypeMessageMedia[];
    subscriptionPeriod?: int;
    giveawayPostId?: int;
    stargift?: Api.TypeStarGift;
    floodskipNumber?: int;
    starrefCommissionPermille?: int;
    starrefPeer?: Api.TypePeer;
    starrefAmount?: Api.TypeStarsAmount;
  }> {
  CONSTRUCTOR_ID: 1692387622;
  SUBCLASS_OF_ID: 2257078130;
  classType: "constructor";
  className: "StarsTransaction";
  static fromReader(reader: Reader): StarsTransaction;
    // flags: null;
    refund?: boolean;
    pending?: boolean;
    failed?: boolean;
    gift?: boolean;
    reaction?: boolean;
    stargiftUpgrade?: boolean;
    id: string;
    stars: Api.TypeStarsAmount;
    date: int;
    peer: Api.TypeStarsTransactionPeer;
    title?: string;
    description?: string;
    photo?: Api.TypeWebDocument;
    transactionDate?: int;
    transactionUrl?: string;
    botPayload?: bytes;
    msgId?: int;
    extendedMedia?: Api.TypeMessageMedia[];
    subscriptionPeriod?: int;
    giveawayPostId?: int;
    stargift?: Api.TypeStarGift;
    floodskipNumber?: int;
    starrefCommissionPermille?: int;
    starrefPeer?: Api.TypePeer;
    starrefAmount?: Api.TypeStarsAmount;
  }
  export class FoundStory extends VirtualClass<{
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }> {
  CONSTRUCTOR_ID: 3900361664;
  SUBCLASS_OF_ID: 3005049029;
  classType: "constructor";
  className: "FoundStory";
  static fromReader(reader: Reader): FoundStory;
    peer: Api.TypePeer;
    story: Api.TypeStoryItem;
  }
  export class GeoPointAddress extends VirtualClass<{
    // flags: null;
    countryIso2: string;
    state?: string;
    city?: string;
    street?: string;
  }> {
  CONSTRUCTOR_ID: 3729546643;
  SUBCLASS_OF_ID: 2522202840;
  classType: "constructor";
  className: "GeoPointAddress";
  static fromReader(reader: Reader): GeoPointAddress;
    // flags: null;
    countryIso2: string;
    state?: string;
    city?: string;
    street?: string;
  }
  export class StarsRevenueStatus extends VirtualClass<{
    // flags: null;
    withdrawalEnabled?: boolean;
    currentBalance: Api.TypeStarsAmount;
    availableBalance: Api.TypeStarsAmount;
    overallRevenue: Api.TypeStarsAmount;
    nextWithdrawalAt?: int;
  }> {
  CONSTRUCTOR_ID: 4273886353;
  SUBCLASS_OF_ID: 1031643121;
  classType: "constructor";
  className: "StarsRevenueStatus";
  static fromReader(reader: Reader): StarsRevenueStatus;
    // flags: null;
    withdrawalEnabled?: boolean;
    currentBalance: Api.TypeStarsAmount;
    availableBalance: Api.TypeStarsAmount;
    overallRevenue: Api.TypeStarsAmount;
    nextWithdrawalAt?: int;
  }
  export class InputStarsTransaction extends VirtualClass<{
    // flags: null;
    refund?: boolean;
    id: string;
  }> {
  CONSTRUCTOR_ID: 543876817;
  SUBCLASS_OF_ID: 300026090;
  classType: "constructor";
  className: "InputStarsTransaction";
  static fromReader(reader: Reader): InputStarsTransaction;
    // flags: null;
    refund?: boolean;
    id: string;
  }
  export class StarsGiftOption extends VirtualClass<{
    // flags: null;
    extended?: boolean;
    stars: long;
    storeProduct?: string;
    currency: string;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 1577421297;
  SUBCLASS_OF_ID: 2848803767;
  classType: "constructor";
  className: "StarsGiftOption";
  static fromReader(reader: Reader): StarsGiftOption;
    // flags: null;
    extended?: boolean;
    stars: long;
    storeProduct?: string;
    currency: string;
    amount: long;
  }
  export class BotPreviewMedia extends VirtualClass<{
    date: int;
    media: Api.TypeMessageMedia;
  }> {
  CONSTRUCTOR_ID: 602479523;
  SUBCLASS_OF_ID: 1445641261;
  classType: "constructor";
  className: "BotPreviewMedia";
  static fromReader(reader: Reader): BotPreviewMedia;
    date: int;
    media: Api.TypeMessageMedia;
  }
  export class StarsSubscriptionPricing extends VirtualClass<{
    period: int;
    amount: long;
  }> {
  CONSTRUCTOR_ID: 88173912;
  SUBCLASS_OF_ID: 3153574313;
  classType: "constructor";
  className: "StarsSubscriptionPricing";
  static fromReader(reader: Reader): StarsSubscriptionPricing;
    period: int;
    amount: long;
  }
  export class StarsSubscription extends VirtualClass<{
    // flags: null;
    canceled?: boolean;
    canRefulfill?: boolean;
    missingBalance?: boolean;
    botCanceled?: boolean;
    id: string;
    peer: Api.TypePeer;
    untilDate: int;
    pricing: Api.TypeStarsSubscriptionPricing;
    chatInviteHash?: string;
    title?: string;
    photo?: Api.TypeWebDocument;
    invoiceSlug?: string;
  }> {
  CONSTRUCTOR_ID: 779004698;
  SUBCLASS_OF_ID: 3974965699;
  classType: "constructor";
  className: "StarsSubscription";
  static fromReader(reader: Reader): StarsSubscription;
    // flags: null;
    canceled?: boolean;
    canRefulfill?: boolean;
    missingBalance?: boolean;
    botCanceled?: boolean;
    id: string;
    peer: Api.TypePeer;
    untilDate: int;
    pricing: Api.TypeStarsSubscriptionPricing;
    chatInviteHash?: string;
    title?: string;
    photo?: Api.TypeWebDocument;
    invoiceSlug?: string;
  }
  export class MessageReactor extends VirtualClass<{
    // flags: null;
    top?: boolean;
    my?: boolean;
    anonymous?: boolean;
    peerId?: Api.TypePeer;
    count: int;
  }> {
  CONSTRUCTOR_ID: 1269016922;
  SUBCLASS_OF_ID: 4030208697;
  classType: "constructor";
  className: "MessageReactor";
  static fromReader(reader: Reader): MessageReactor;
    // flags: null;
    top?: boolean;
    my?: boolean;
    anonymous?: boolean;
    peerId?: Api.TypePeer;
    count: int;
  }
  export class StarsGiveawayOption extends VirtualClass<{
    // flags: null;
    extended?: boolean;
    default?: boolean;
    stars: long;
    yearlyBoosts: int;
    storeProduct?: string;
    currency: string;
    amount: long;
    winners: Api.TypeStarsGiveawayWinnersOption[];
  }> {
  CONSTRUCTOR_ID: 2496562474;
  SUBCLASS_OF_ID: 975741451;
  classType: "constructor";
  className: "StarsGiveawayOption";
  static fromReader(reader: Reader): StarsGiveawayOption;
    // flags: null;
    extended?: boolean;
    default?: boolean;
    stars: long;
    yearlyBoosts: int;
    storeProduct?: string;
    currency: string;
    amount: long;
    winners: Api.TypeStarsGiveawayWinnersOption[];
  }
  export class StarsGiveawayWinnersOption extends VirtualClass<{
    // flags: null;
    default?: boolean;
    users: int;
    perUserStars: long;
  }> {
  CONSTRUCTOR_ID: 1411605001;
  SUBCLASS_OF_ID: 4227506916;
  classType: "constructor";
  className: "StarsGiveawayWinnersOption";
  static fromReader(reader: Reader): StarsGiveawayWinnersOption;
    // flags: null;
    default?: boolean;
    users: int;
    perUserStars: long;
  }
  export class StarGift extends VirtualClass<{
    // flags: null;
    limited?: boolean;
    soldOut?: boolean;
    birthday?: boolean;
    id: long;
    sticker: Api.TypeDocument;
    stars: long;
    availabilityRemains?: int;
    availabilityTotal?: int;
    convertStars: long;
    firstSaleDate?: int;
    lastSaleDate?: int;
    upgradeStars?: long;
  }> {
  CONSTRUCTOR_ID: 46953416;
  SUBCLASS_OF_ID: 3273414923;
  classType: "constructor";
  className: "StarGift";
  static fromReader(reader: Reader): StarGift;
    // flags: null;
    limited?: boolean;
    soldOut?: boolean;
    birthday?: boolean;
    id: long;
    sticker: Api.TypeDocument;
    stars: long;
    availabilityRemains?: int;
    availabilityTotal?: int;
    convertStars: long;
    firstSaleDate?: int;
    lastSaleDate?: int;
    upgradeStars?: long;
  }
  export class StarGiftUnique extends VirtualClass<{
    // flags: null;
    id: long;
    title: string;
    slug: string;
    num: int;
    ownerId?: Api.TypePeer;
    ownerName?: string;
    ownerAddress?: string;
    attributes: Api.TypeStarGiftAttribute[];
    availabilityIssued: int;
    availabilityTotal: int;
  }> {
  CONSTRUCTOR_ID: 4076764746;
  SUBCLASS_OF_ID: 3273414923;
  classType: "constructor";
  className: "StarGiftUnique";
  static fromReader(reader: Reader): StarGiftUnique;
    // flags: null;
    id: long;
    title: string;
    slug: string;
    num: int;
    ownerId?: Api.TypePeer;
    ownerName?: string;
    ownerAddress?: string;
    attributes: Api.TypeStarGiftAttribute[];
    availabilityIssued: int;
    availabilityTotal: int;
  }
  export class MessageReportOption extends VirtualClass<{
    text: string;
    option: bytes;
  }> {
  CONSTRUCTOR_ID: 2030298073;
  SUBCLASS_OF_ID: 4252610440;
  classType: "constructor";
  className: "MessageReportOption";
  static fromReader(reader: Reader): MessageReportOption;
    text: string;
    option: bytes;
  }
  export class ReportResultChooseOption extends VirtualClass<{
    title: string;
    options: Api.TypeMessageReportOption[];
  }> {
  CONSTRUCTOR_ID: 4041531574;
  SUBCLASS_OF_ID: 2899571768;
  classType: "constructor";
  className: "ReportResultChooseOption";
  static fromReader(reader: Reader): ReportResultChooseOption;
    title: string;
    options: Api.TypeMessageReportOption[];
  }
  export class ReportResultAddComment extends VirtualClass<{
    // flags: null;
    optional?: boolean;
    option: bytes;
  }> {
  CONSTRUCTOR_ID: 1862904881;
  SUBCLASS_OF_ID: 2899571768;
  classType: "constructor";
  className: "ReportResultAddComment";
  static fromReader(reader: Reader): ReportResultAddComment;
    // flags: null;
    optional?: boolean;
    option: bytes;
  }
  export class ReportResultReported extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2377333835;
  SUBCLASS_OF_ID: 2899571768;
  classType: "constructor";
  className: "ReportResultReported";
  static fromReader(reader: Reader): ReportResultReported;
}
  export class BotAppSettings extends VirtualClass<{
    // flags: null;
    placeholderPath?: bytes;
    backgroundColor?: int;
    backgroundDarkColor?: int;
    headerColor?: int;
    headerDarkColor?: int;
  }> {
  CONSTRUCTOR_ID: 3382384976;
  SUBCLASS_OF_ID: 396255971;
  classType: "constructor";
  className: "BotAppSettings";
  static fromReader(reader: Reader): BotAppSettings;
    // flags: null;
    placeholderPath?: bytes;
    backgroundColor?: int;
    backgroundDarkColor?: int;
    headerColor?: int;
    headerDarkColor?: int;
  }
  export class StarRefProgram extends VirtualClass<{
    // flags: null;
    botId: long;
    commissionPermille: int;
    durationMonths?: int;
    endDate?: int;
    dailyRevenuePerUser?: Api.TypeStarsAmount;
  }> {
  CONSTRUCTOR_ID: 3708577522;
  SUBCLASS_OF_ID: 2559107074;
  classType: "constructor";
  className: "StarRefProgram";
  static fromReader(reader: Reader): StarRefProgram;
    // flags: null;
    botId: long;
    commissionPermille: int;
    durationMonths?: int;
    endDate?: int;
    dailyRevenuePerUser?: Api.TypeStarsAmount;
  }
  export class ConnectedBotStarRef extends VirtualClass<{
    // flags: null;
    revoked?: boolean;
    url: string;
    date: int;
    botId: long;
    commissionPermille: int;
    durationMonths?: int;
    participants: long;
    revenue: long;
  }> {
  CONSTRUCTOR_ID: 429997937;
  SUBCLASS_OF_ID: 2689765260;
  classType: "constructor";
  className: "ConnectedBotStarRef";
  static fromReader(reader: Reader): ConnectedBotStarRef;
    // flags: null;
    revoked?: boolean;
    url: string;
    date: int;
    botId: long;
    commissionPermille: int;
    durationMonths?: int;
    participants: long;
    revenue: long;
  }
  export class StarsAmount extends VirtualClass<{
    amount: long;
    nanos: int;
  }> {
  CONSTRUCTOR_ID: 3149313187;
  SUBCLASS_OF_ID: 895169088;
  classType: "constructor";
  className: "StarsAmount";
  static fromReader(reader: Reader): StarsAmount;
    amount: long;
    nanos: int;
  }
  export class BotVerifierSettings extends VirtualClass<{
    // flags: null;
    canModifyCustomDescription?: boolean;
    icon: long;
    company: string;
    customDescription?: string;
  }> {
  CONSTRUCTOR_ID: 2966251031;
  SUBCLASS_OF_ID: 4057334604;
  classType: "constructor";
  className: "BotVerifierSettings";
  static fromReader(reader: Reader): BotVerifierSettings;
    // flags: null;
    canModifyCustomDescription?: boolean;
    icon: long;
    company: string;
    customDescription?: string;
  }
  export class BotVerification extends VirtualClass<{
    botId: long;
    icon: long;
    description: string;
  }> {
  CONSTRUCTOR_ID: 4181513308;
  SUBCLASS_OF_ID: 750730330;
  classType: "constructor";
  className: "BotVerification";
  static fromReader(reader: Reader): BotVerification;
    botId: long;
    icon: long;
    description: string;
  }
  export class StarGiftAttributeModel extends VirtualClass<{
    name: string;
    document: Api.TypeDocument;
    rarityPermille: int;
  }> {
  CONSTRUCTOR_ID: 970559507;
  SUBCLASS_OF_ID: 2276819400;
  classType: "constructor";
  className: "StarGiftAttributeModel";
  static fromReader(reader: Reader): StarGiftAttributeModel;
    name: string;
    document: Api.TypeDocument;
    rarityPermille: int;
  }
  export class StarGiftAttributePattern extends VirtualClass<{
    name: string;
    document: Api.TypeDocument;
    rarityPermille: int;
  }> {
  CONSTRUCTOR_ID: 330104601;
  SUBCLASS_OF_ID: 2276819400;
  classType: "constructor";
  className: "StarGiftAttributePattern";
  static fromReader(reader: Reader): StarGiftAttributePattern;
    name: string;
    document: Api.TypeDocument;
    rarityPermille: int;
  }
  export class StarGiftAttributeBackdrop extends VirtualClass<{
    name: string;
    centerColor: int;
    edgeColor: int;
    patternColor: int;
    textColor: int;
    rarityPermille: int;
  }> {
  CONSTRUCTOR_ID: 2485589858;
  SUBCLASS_OF_ID: 2276819400;
  classType: "constructor";
  className: "StarGiftAttributeBackdrop";
  static fromReader(reader: Reader): StarGiftAttributeBackdrop;
    name: string;
    centerColor: int;
    edgeColor: int;
    patternColor: int;
    textColor: int;
    rarityPermille: int;
  }
  export class StarGiftAttributeOriginalDetails extends VirtualClass<{
    // flags: null;
    senderId?: Api.TypePeer;
    recipientId: Api.TypePeer;
    date: int;
    message?: Api.TypeTextWithEntities;
  }> {
  CONSTRUCTOR_ID: 3770675820;
  SUBCLASS_OF_ID: 2276819400;
  classType: "constructor";
  className: "StarGiftAttributeOriginalDetails";
  static fromReader(reader: Reader): StarGiftAttributeOriginalDetails;
    // flags: null;
    senderId?: Api.TypePeer;
    recipientId: Api.TypePeer;
    date: int;
    message?: Api.TypeTextWithEntities;
  }
  export class SavedStarGift extends VirtualClass<{
    // flags: null;
    nameHidden?: boolean;
    unsaved?: boolean;
    refunded?: boolean;
    canUpgrade?: boolean;
    fromId?: Api.TypePeer;
    date: int;
    gift: Api.TypeStarGift;
    message?: Api.TypeTextWithEntities;
    msgId?: int;
    savedId?: long;
    convertStars?: long;
    upgradeStars?: long;
    canExportAt?: int;
    transferStars?: long;
  }> {
  CONSTRUCTOR_ID: 1616305061;
  SUBCLASS_OF_ID: 2385198100;
  classType: "constructor";
  className: "SavedStarGift";
  static fromReader(reader: Reader): SavedStarGift;
    // flags: null;
    nameHidden?: boolean;
    unsaved?: boolean;
    refunded?: boolean;
    canUpgrade?: boolean;
    fromId?: Api.TypePeer;
    date: int;
    gift: Api.TypeStarGift;
    message?: Api.TypeTextWithEntities;
    msgId?: int;
    savedId?: long;
    convertStars?: long;
    upgradeStars?: long;
    canExportAt?: int;
    transferStars?: long;
  }
  export class InputSavedStarGiftUser extends VirtualClass<{
    msgId: int;
  }> {
  CONSTRUCTOR_ID: 1764202389;
  SUBCLASS_OF_ID: 2406848942;
  classType: "constructor";
  className: "InputSavedStarGiftUser";
  static fromReader(reader: Reader): InputSavedStarGiftUser;
    msgId: int;
  }
  export class InputSavedStarGiftChat extends VirtualClass<{
    peer: Api.TypeInputPeer;
    savedId: long;
  }> {
  CONSTRUCTOR_ID: 4043418239;
  SUBCLASS_OF_ID: 2406848942;
  classType: "constructor";
  className: "InputSavedStarGiftChat";
  static fromReader(reader: Reader): InputSavedStarGiftChat;
    peer: Api.TypeInputPeer;
    savedId: long;
  }
  export class ResPQ extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    pq: bytes;
    serverPublicKeyFingerprints: long[];
  }> {
  CONSTRUCTOR_ID: 85337187;
  SUBCLASS_OF_ID: 2020181688;
  classType: "constructor";
  className: "ResPQ";
  static fromReader(reader: Reader): ResPQ;
    nonce: int128;
    serverNonce: int128;
    pq: bytes;
    serverPublicKeyFingerprints: long[];
  }
  export class PQInnerData extends VirtualClass<{
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
  }> {
  CONSTRUCTOR_ID: 2211011308;
  SUBCLASS_OF_ID: 1097864055;
  classType: "constructor";
  className: "PQInnerData";
  static fromReader(reader: Reader): PQInnerData;
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
  }
  export class PQInnerDataDc extends VirtualClass<{
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    dc: int;
  }> {
  CONSTRUCTOR_ID: 2851430293;
  SUBCLASS_OF_ID: 1097864055;
  classType: "constructor";
  className: "PQInnerDataDc";
  static fromReader(reader: Reader): PQInnerDataDc;
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    dc: int;
  }
  export class PQInnerDataTemp extends VirtualClass<{
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    expiresIn: int;
  }> {
  CONSTRUCTOR_ID: 1013613780;
  SUBCLASS_OF_ID: 1097864055;
  classType: "constructor";
  className: "PQInnerDataTemp";
  static fromReader(reader: Reader): PQInnerDataTemp;
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    expiresIn: int;
  }
  export class PQInnerDataTempDc extends VirtualClass<{
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    dc: int;
    expiresIn: int;
  }> {
  CONSTRUCTOR_ID: 1459478408;
  SUBCLASS_OF_ID: 1097864055;
  classType: "constructor";
  className: "PQInnerDataTempDc";
  static fromReader(reader: Reader): PQInnerDataTempDc;
    pq: bytes;
    p: bytes;
    q: bytes;
    nonce: int128;
    serverNonce: int128;
    newNonce: int256;
    dc: int;
    expiresIn: int;
  }
  export class BindAuthKeyInner extends VirtualClass<{
    nonce: long;
    tempAuthKeyId: long;
    permAuthKeyId: long;
    tempSessionId: long;
    expiresAt: int;
  }> {
  CONSTRUCTOR_ID: 1973679973;
  SUBCLASS_OF_ID: 789156209;
  classType: "constructor";
  className: "BindAuthKeyInner";
  static fromReader(reader: Reader): BindAuthKeyInner;
    nonce: long;
    tempAuthKeyId: long;
    permAuthKeyId: long;
    tempSessionId: long;
    expiresAt: int;
  }
  export class ServerDHParamsFail extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    newNonceHash: int128;
  }> {
  CONSTRUCTOR_ID: 2043348061;
  SUBCLASS_OF_ID: 2786626974;
  classType: "constructor";
  className: "ServerDHParamsFail";
  static fromReader(reader: Reader): ServerDHParamsFail;
    nonce: int128;
    serverNonce: int128;
    newNonceHash: int128;
  }
  export class ServerDHParamsOk extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    encryptedAnswer: bytes;
  }> {
  CONSTRUCTOR_ID: 3504867164;
  SUBCLASS_OF_ID: 2786626974;
  classType: "constructor";
  className: "ServerDHParamsOk";
  static fromReader(reader: Reader): ServerDHParamsOk;
    nonce: int128;
    serverNonce: int128;
    encryptedAnswer: bytes;
  }
  export class ServerDHInnerData extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    g: int;
    dhPrime: bytes;
    gA: bytes;
    serverTime: int;
  }> {
  CONSTRUCTOR_ID: 3045658042;
  SUBCLASS_OF_ID: 3332007868;
  classType: "constructor";
  className: "ServerDHInnerData";
  static fromReader(reader: Reader): ServerDHInnerData;
    nonce: int128;
    serverNonce: int128;
    g: int;
    dhPrime: bytes;
    gA: bytes;
    serverTime: int;
  }
  export class ClientDHInnerData extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    retryId: long;
    gB: bytes;
  }> {
  CONSTRUCTOR_ID: 1715713620;
  SUBCLASS_OF_ID: 4176408426;
  classType: "constructor";
  className: "ClientDHInnerData";
  static fromReader(reader: Reader): ClientDHInnerData;
    nonce: int128;
    serverNonce: int128;
    retryId: long;
    gB: bytes;
  }
  export class DhGenOk extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    newNonceHash1: int128;
  }> {
  CONSTRUCTOR_ID: 1003222836;
  SUBCLASS_OF_ID: 1440574683;
  classType: "constructor";
  className: "DhGenOk";
  static fromReader(reader: Reader): DhGenOk;
    nonce: int128;
    serverNonce: int128;
    newNonceHash1: int128;
  }
  export class DhGenRetry extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    newNonceHash2: int128;
  }> {
  CONSTRUCTOR_ID: 1188831161;
  SUBCLASS_OF_ID: 1440574683;
  classType: "constructor";
  className: "DhGenRetry";
  static fromReader(reader: Reader): DhGenRetry;
    nonce: int128;
    serverNonce: int128;
    newNonceHash2: int128;
  }
  export class DhGenFail extends VirtualClass<{
    nonce: int128;
    serverNonce: int128;
    newNonceHash3: int128;
  }> {
  CONSTRUCTOR_ID: 2795351554;
  SUBCLASS_OF_ID: 1440574683;
  classType: "constructor";
  className: "DhGenFail";
  static fromReader(reader: Reader): DhGenFail;
    nonce: int128;
    serverNonce: int128;
    newNonceHash3: int128;
  }
  export class DestroyAuthKeyOk extends VirtualClass<void> {
  CONSTRUCTOR_ID: 4133544404;
  SUBCLASS_OF_ID: 2190599822;
  classType: "constructor";
  className: "DestroyAuthKeyOk";
  static fromReader(reader: Reader): DestroyAuthKeyOk;
}
  export class DestroyAuthKeyNone extends VirtualClass<void> {
  CONSTRUCTOR_ID: 178201177;
  SUBCLASS_OF_ID: 2190599822;
  classType: "constructor";
  className: "DestroyAuthKeyNone";
  static fromReader(reader: Reader): DestroyAuthKeyNone;
}
  export class DestroyAuthKeyFail extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3926956819;
  SUBCLASS_OF_ID: 2190599822;
  classType: "constructor";
  className: "DestroyAuthKeyFail";
  static fromReader(reader: Reader): DestroyAuthKeyFail;
}
  export class MsgsAck extends VirtualClass<{
    msgIds: long[];
  }> {
  CONSTRUCTOR_ID: 1658238041;
  SUBCLASS_OF_ID: 2188801988;
  classType: "constructor";
  className: "MsgsAck";
  static fromReader(reader: Reader): MsgsAck;
    msgIds: long[];
  }
  export class BadMsgNotification extends VirtualClass<{
    badMsgId: long;
    badMsgSeqno: int;
    errorCode: int;
  }> {
  CONSTRUCTOR_ID: 2817521681;
  SUBCLASS_OF_ID: 3468337495;
  classType: "constructor";
  className: "BadMsgNotification";
  static fromReader(reader: Reader): BadMsgNotification;
    badMsgId: long;
    badMsgSeqno: int;
    errorCode: int;
  }
  export class BadServerSalt extends VirtualClass<{
    badMsgId: long;
    badMsgSeqno: int;
    errorCode: int;
    newServerSalt: long;
  }> {
  CONSTRUCTOR_ID: 3987424379;
  SUBCLASS_OF_ID: 3468337495;
  classType: "constructor";
  className: "BadServerSalt";
  static fromReader(reader: Reader): BadServerSalt;
    badMsgId: long;
    badMsgSeqno: int;
    errorCode: int;
    newServerSalt: long;
  }
  export class MsgsStateReq extends VirtualClass<{
    msgIds: long[];
  }> {
  CONSTRUCTOR_ID: 3664378706;
  SUBCLASS_OF_ID: 418389456;
  classType: "constructor";
  className: "MsgsStateReq";
  static fromReader(reader: Reader): MsgsStateReq;
    msgIds: long[];
  }
  export class MsgsStateInfo extends VirtualClass<{
    reqMsgId: long;
    info: string;
  }> {
  CONSTRUCTOR_ID: 81704317;
  SUBCLASS_OF_ID: 118098532;
  classType: "constructor";
  className: "MsgsStateInfo";
  static fromReader(reader: Reader): MsgsStateInfo;
    reqMsgId: long;
    info: string;
  }
  export class MsgsAllInfo extends VirtualClass<{
    msgIds: long[];
    info: string;
  }> {
  CONSTRUCTOR_ID: 2361446705;
  SUBCLASS_OF_ID: 4203727700;
  classType: "constructor";
  className: "MsgsAllInfo";
  static fromReader(reader: Reader): MsgsAllInfo;
    msgIds: long[];
    info: string;
  }
  export class MsgDetailedInfo extends VirtualClass<{
    msgId: long;
    answerMsgId: long;
    bytes: int;
    status: int;
  }> {
  CONSTRUCTOR_ID: 661470918;
  SUBCLASS_OF_ID: 1597167086;
  classType: "constructor";
  className: "MsgDetailedInfo";
  static fromReader(reader: Reader): MsgDetailedInfo;
    msgId: long;
    answerMsgId: long;
    bytes: int;
    status: int;
  }
  export class MsgNewDetailedInfo extends VirtualClass<{
    answerMsgId: long;
    bytes: int;
    status: int;
  }> {
  CONSTRUCTOR_ID: 2157819615;
  SUBCLASS_OF_ID: 1597167086;
  classType: "constructor";
  className: "MsgNewDetailedInfo";
  static fromReader(reader: Reader): MsgNewDetailedInfo;
    answerMsgId: long;
    bytes: int;
    status: int;
  }
  export class MsgResendReq extends VirtualClass<{
    msgIds: long[];
  }> {
  CONSTRUCTOR_ID: 2105940488;
  SUBCLASS_OF_ID: 33703188;
  classType: "constructor";
  className: "MsgResendReq";
  static fromReader(reader: Reader): MsgResendReq;
    msgIds: long[];
  }
  export class RpcError extends VirtualClass<{
    errorCode: int;
    errorMessage: string;
  }> {
  CONSTRUCTOR_ID: 558156313;
  SUBCLASS_OF_ID: 1243079269;
  classType: "constructor";
  className: "RpcError";
  static fromReader(reader: Reader): RpcError;
    errorCode: int;
    errorMessage: string;
  }
  export class RpcAnswerUnknown extends VirtualClass<void> {
  CONSTRUCTOR_ID: 1579864942;
  SUBCLASS_OF_ID: 1271559536;
  classType: "constructor";
  className: "RpcAnswerUnknown";
  static fromReader(reader: Reader): RpcAnswerUnknown;
}
  export class RpcAnswerDroppedRunning extends VirtualClass<void> {
  CONSTRUCTOR_ID: 3447252358;
  SUBCLASS_OF_ID: 1271559536;
  classType: "constructor";
  className: "RpcAnswerDroppedRunning";
  static fromReader(reader: Reader): RpcAnswerDroppedRunning;
}
  export class RpcAnswerDropped extends VirtualClass<{
    msgId: long;
    seqNo: int;
    bytes: int;
  }> {
  CONSTRUCTOR_ID: 2755319991;
  SUBCLASS_OF_ID: 1271559536;
  classType: "constructor";
  className: "RpcAnswerDropped";
  static fromReader(reader: Reader): RpcAnswerDropped;
    msgId: long;
    seqNo: int;
    bytes: int;
  }
  export class FutureSalt extends VirtualClass<{
    validSince: int;
    validUntil: int;
    salt: long;
  }> {
  CONSTRUCTOR_ID: 155834844;
  SUBCLASS_OF_ID: 1172651471;
  classType: "constructor";
  className: "FutureSalt";
  static fromReader(reader: Reader): FutureSalt;
    validSince: int;
    validUntil: int;
    salt: long;
  }
  export class FutureSalts extends VirtualClass<{
    reqMsgId: long;
    now: int;
    salts: FutureSalt[];
  }> {
  CONSTRUCTOR_ID: 2924480661;
  SUBCLASS_OF_ID: 277935383;
  classType: "constructor";
  className: "FutureSalts";
  static fromReader(reader: Reader): FutureSalts;
    reqMsgId: long;
    now: int;
    salts: FutureSalt[];
  }
  export class Pong extends VirtualClass<{
    msgId: long;
    pingId: long;
  }> {
  CONSTRUCTOR_ID: 880243653;
  SUBCLASS_OF_ID: 2171268721;
  classType: "constructor";
  className: "Pong";
  static fromReader(reader: Reader): Pong;
    msgId: long;
    pingId: long;
  }
  export class DestroySessionOk extends VirtualClass<{
    sessionId: long;
  }> {
  CONSTRUCTOR_ID: 3793765884;
  SUBCLASS_OF_ID: 2936858557;
  classType: "constructor";
  className: "DestroySessionOk";
  static fromReader(reader: Reader): DestroySessionOk;
    sessionId: long;
  }
  export class DestroySessionNone extends VirtualClass<{
    sessionId: long;
  }> {
  CONSTRUCTOR_ID: 1658015945;
  SUBCLASS_OF_ID: 2936858557;
  classType: "constructor";
  className: "DestroySessionNone";
  static fromReader(reader: Reader): DestroySessionNone;
    sessionId: long;
  }
  export class NewSessionCreated extends VirtualClass<{
    firstMsgId: long;
    uniqueId: long;
    serverSalt: long;
  }> {
  CONSTRUCTOR_ID: 2663516424;
  SUBCLASS_OF_ID: 1359818801;
  classType: "constructor";
  className: "NewSessionCreated";
  static fromReader(reader: Reader): NewSessionCreated;
    firstMsgId: long;
    uniqueId: long;
    serverSalt: long;
  }
  export class HttpWait extends VirtualClass<{
    maxDelay: int;
    waitAfter: int;
    maxWait: int;
  }> {
  CONSTRUCTOR_ID: 2459514271;
  SUBCLASS_OF_ID: 310685398;
  classType: "constructor";
  className: "HttpWait";
  static fromReader(reader: Reader): HttpWait;
    maxDelay: int;
    waitAfter: int;
    maxWait: int;
  }
  export class IpPort extends VirtualClass<{
    ipv4: int;
    port: int;
  }> {
  CONSTRUCTOR_ID: 3560156531;
  SUBCLASS_OF_ID: 2728408870;
  classType: "constructor";
  className: "IpPort";
  static fromReader(reader: Reader): IpPort;
    ipv4: int;
    port: int;
  }
  export class IpPortSecret extends VirtualClass<{
    ipv4: int;
    port: int;
    secret: bytes;
  }> {
  CONSTRUCTOR_ID: 932718150;
  SUBCLASS_OF_ID: 2728408870;
  classType: "constructor";
  className: "IpPortSecret";
  static fromReader(reader: Reader): IpPortSecret;
    ipv4: int;
    port: int;
    secret: bytes;
  }
  export class AccessPointRule extends VirtualClass<{
    phonePrefixRules: string;
    dcId: int;
    ips: Api.TypeIpPort[];
  }> {
  CONSTRUCTOR_ID: 1182381663;
  SUBCLASS_OF_ID: 2980880637;
  classType: "constructor";
  className: "AccessPointRule";
  static fromReader(reader: Reader): AccessPointRule;
    phonePrefixRules: string;
    dcId: int;
    ips: Api.TypeIpPort[];
  }
  export class TlsClientHello extends VirtualClass<{
    blocks: Api.TypeTlsBlock[];
  }> {
  CONSTRUCTOR_ID: 262524817;
  SUBCLASS_OF_ID: 3203533088;
  classType: "constructor";
  className: "TlsClientHello";
  static fromReader(reader: Reader): TlsClientHello;
    blocks: Api.TypeTlsBlock[];
  }
  export class TlsBlockString extends VirtualClass<{
    data: string;
  }> {
  CONSTRUCTOR_ID: 1488907607;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockString";
  static fromReader(reader: Reader): TlsBlockString;
    data: string;
  }
  export class TlsBlockRandom extends VirtualClass<{
    length: int;
  }> {
  CONSTRUCTOR_ID: 3265966728;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockRandom";
  static fromReader(reader: Reader): TlsBlockRandom;
    length: int;
  }
  export class TlsBlockZero extends VirtualClass<{
    length: int;
  }> {
  CONSTRUCTOR_ID: 3400654219;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockZero";
  static fromReader(reader: Reader): TlsBlockZero;
    length: int;
  }
  export class TlsBlockDomain extends VirtualClass<void> {
  CONSTRUCTOR_ID: 283665263;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockDomain";
  static fromReader(reader: Reader): TlsBlockDomain;
}
  export class TlsBlockGrease extends VirtualClass<{
    seed: int;
  }> {
  CONSTRUCTOR_ID: 2623335513;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockGrease";
  static fromReader(reader: Reader): TlsBlockGrease;
    seed: int;
  }
  export class TlsBlockPublicKey extends VirtualClass<void> {
  CONSTRUCTOR_ID: 2662947676;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockPublicKey";
  static fromReader(reader: Reader): TlsBlockPublicKey;
}
  export class TlsBlockScope extends VirtualClass<{
    entries: Api.TypeTlsBlock[];
  }> {
  CONSTRUCTOR_ID: 3638474097;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockScope";
  static fromReader(reader: Reader): TlsBlockScope;
    entries: Api.TypeTlsBlock[];
  }
  export class TlsBlockPermutation extends VirtualClass<{
    entries: Api.TypeTlsBlock[];
  }> {
  CONSTRUCTOR_ID: 48631757;
  SUBCLASS_OF_ID: 4044764304;
  classType: "constructor";
  className: "TlsBlockPermutation";
  static fromReader(reader: Reader): TlsBlockPermutation;
    entries: Api.TypeTlsBlock[];
  }
  export class InvokeAfterMsg extends Request<Partial<{
    msgId: long;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 3416209197;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeAfterMsg";
  static fromReader(reader: Reader): InvokeAfterMsg;
    msgId: long;
    query: X;
  }
  export class InvokeAfterMsgs extends Request<Partial<{
    msgIds: long[];
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 1036301552;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeAfterMsgs";
  static fromReader(reader: Reader): InvokeAfterMsgs;
    msgIds: long[];
    query: X;
  }
  export class InitConnection extends Request<Partial<{
    // flags: null;
    apiId: int;
    deviceModel: string;
    systemVersion: string;
    appVersion: string;
    systemLangCode: string;
    langPack: string;
    langCode: string;
    proxy?: Api.TypeInputClientProxy;
    params?: Api.TypeJSONValue;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 3251461801;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InitConnection";
  static fromReader(reader: Reader): InitConnection;
    // flags: null;
    apiId: int;
    deviceModel: string;
    systemVersion: string;
    appVersion: string;
    systemLangCode: string;
    langPack: string;
    langCode: string;
    proxy?: Api.TypeInputClientProxy;
    params?: Api.TypeJSONValue;
    query: X;
  }
  export class InvokeWithLayer extends Request<Partial<{
    layer: int;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 3667594509;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithLayer";
  static fromReader(reader: Reader): InvokeWithLayer;
    layer: int;
    query: X;
  }
  export class InvokeWithoutUpdates extends Request<Partial<{
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 3214170551;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithoutUpdates";
  static fromReader(reader: Reader): InvokeWithoutUpdates;
    query: X;
  }
  export class InvokeWithMessagesRange extends Request<Partial<{
    range: Api.TypeMessageRange;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 911373810;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithMessagesRange";
  static fromReader(reader: Reader): InvokeWithMessagesRange;
    range: Api.TypeMessageRange;
    query: X;
  }
  export class InvokeWithTakeout extends Request<Partial<{
    takeoutId: long;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 2896821550;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithTakeout";
  static fromReader(reader: Reader): InvokeWithTakeout;
    takeoutId: long;
    query: X;
  }
  export class InvokeWithBusinessConnection extends Request<Partial<{
    connectionId: string;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 3710427022;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithBusinessConnection";
  static fromReader(reader: Reader): InvokeWithBusinessConnection;
    connectionId: string;
    query: X;
  }
  export class InvokeWithGooglePlayIntegrity extends Request<Partial<{
    nonce: string;
    token: string;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 502868356;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithGooglePlayIntegrity";
  static fromReader(reader: Reader): InvokeWithGooglePlayIntegrity;
    nonce: string;
    token: string;
    query: X;
  }
  export class InvokeWithApnsSecret extends Request<Partial<{
    nonce: string;
    secret: string;
    query: X;
  }>, X> {
  CONSTRUCTOR_ID: 229528824;
  SUBCLASS_OF_ID: 3081909835;
  classType: "request";
  className: "InvokeWithApnsSecret";
  static fromReader(reader: Reader): InvokeWithApnsSecret;
    nonce: string;
    secret: string;
    query: X;
  }
  export class ReqPq extends Request<Partial<{
    nonce: int128;
  }>, Api.TypeResPQ> {
  CONSTRUCTOR_ID: 1615239032;
  SUBCLASS_OF_ID: 2020181688;
  classType: "request";
  className: "ReqPq";
  static fromReader(reader: Reader): ReqPq;
    nonce: int128;
  }
  export class ReqPqMulti extends Request<Partial<{
    nonce: int128;
  }>, Api.TypeResPQ> {
  CONSTRUCTOR_ID: 3195965169;
  SUBCLASS_OF_ID: 2020181688;
  classType: "request";
  className: "ReqPqMulti";
  static fromReader(reader: Reader): ReqPqMulti;
    nonce: int128;
  }
  export class ReqDHParams extends Request<Partial<{
    nonce: int128;
    serverNonce: int128;
    p: bytes;
    q: bytes;
    publicKeyFingerprint: long;
    encryptedData: bytes;
  }>, Api.TypeServer_DH_Params> {
  CONSTRUCTOR_ID: 3608339646;
  SUBCLASS_OF_ID: 2786626974;
  classType: "request";
  className: "ReqDHParams";
  static fromReader(reader: Reader): ReqDHParams;
    nonce: int128;
    serverNonce: int128;
    p: bytes;
    q: bytes;
    publicKeyFingerprint: long;
    encryptedData: bytes;
  }
  export class SetClientDHParams extends Request<Partial<{
    nonce: int128;
    serverNonce: int128;
    encryptedData: bytes;
  }>, Api.TypeSet_client_DH_params_answer> {
  CONSTRUCTOR_ID: 4110704415;
  SUBCLASS_OF_ID: 1440574683;
  classType: "request";
  className: "SetClientDHParams";
  static fromReader(reader: Reader): SetClientDHParams;
    nonce: int128;
    serverNonce: int128;
    encryptedData: bytes;
  }
  export class DestroyAuthKey extends Request<void, Api.TypeDestroyAuthKeyRes> {
  CONSTRUCTOR_ID: 3510849888;
  SUBCLASS_OF_ID: 2190599822;
  classType: "request";
  className: "DestroyAuthKey";
  static fromReader(reader: Reader): DestroyAuthKey;
}
  export class RpcDropAnswer extends Request<Partial<{
    reqMsgId: long;
  }>, Api.TypeRpcDropAnswer> {
  CONSTRUCTOR_ID: 1491380032;
  SUBCLASS_OF_ID: 1271559536;
  classType: "request";
  className: "RpcDropAnswer";
  static fromReader(reader: Reader): RpcDropAnswer;
    reqMsgId: long;
  }
  export class GetFutureSalts extends Request<Partial<{
    num: int;
  }>, Api.TypeFutureSalts> {
  CONSTRUCTOR_ID: 3105996036;
  SUBCLASS_OF_ID: 277935383;
  classType: "request";
  className: "GetFutureSalts";
  static fromReader(reader: Reader): GetFutureSalts;
    num: int;
  }
  export class Ping extends Request<Partial<{
    pingId: long;
  }>, Api.TypePong> {
  CONSTRUCTOR_ID: 2059302892;
  SUBCLASS_OF_ID: 2171268721;
  classType: "request";
  className: "Ping";
  static fromReader(reader: Reader): Ping;
    pingId: long;
  }
  export class PingDelayDisconnect extends Request<Partial<{
    pingId: long;
    disconnectDelay: int;
  }>, Api.TypePong> {
  CONSTRUCTOR_ID: 4081220492;
  SUBCLASS_OF_ID: 2171268721;
  classType: "request";
  className: "PingDelayDisconnect";
  static fromReader(reader: Reader): PingDelayDisconnect;
    pingId: long;
    disconnectDelay: int;
  }
  export class DestroySession extends Request<Partial<{
    sessionId: long;
  }>, Api.TypeDestroySessionRes> {
  CONSTRUCTOR_ID: 3880853798;
  SUBCLASS_OF_ID: 2936858557;
  classType: "request";
  className: "DestroySession";
  static fromReader(reader: Reader): DestroySession;
    sessionId: long;
  }
// namespaces
  

  export namespace storage {
    export class FileUnknown extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2861972229;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileUnknown";
    static fromReader(reader: Reader): FileUnknown;
}
    export class FilePartial extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1086091090;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FilePartial";
    static fromReader(reader: Reader): FilePartial;
}
    export class FileJpeg extends VirtualClass<void> {
    CONSTRUCTOR_ID: 8322574;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileJpeg";
    static fromReader(reader: Reader): FileJpeg;
}
    export class FileGif extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3403786975;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileGif";
    static fromReader(reader: Reader): FileGif;
}
    export class FilePng extends VirtualClass<void> {
    CONSTRUCTOR_ID: 172975040;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FilePng";
    static fromReader(reader: Reader): FilePng;
}
    export class FilePdf extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2921222285;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FilePdf";
    static fromReader(reader: Reader): FilePdf;
}
    export class FileMp3 extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1384777335;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileMp3";
    static fromReader(reader: Reader): FileMp3;
}
    export class FileMov extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1258941372;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileMov";
    static fromReader(reader: Reader): FileMov;
}
    export class FileMp4 extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3016663268;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileMp4";
    static fromReader(reader: Reader): FileMp4;
}
    export class FileWebp extends VirtualClass<void> {
    CONSTRUCTOR_ID: 276907596;
    SUBCLASS_OF_ID: 4087473907;
    classType: "constructor";
    className: "storage.FileWebp";
    static fromReader(reader: Reader): FileWebp;
}
  }

  export namespace auth {
    export class SentCode extends VirtualClass<{
      // flags: null;
      type: auth.TypeSentCodeType;
      phoneCodeHash: string;
      nextType?: auth.TypeCodeType;
      timeout?: int;
    }> {
    CONSTRUCTOR_ID: 1577067778;
    SUBCLASS_OF_ID: 1827172481;
    classType: "constructor";
    className: "auth.SentCode";
    static fromReader(reader: Reader): SentCode;
      // flags: null;
      type: auth.TypeSentCodeType;
      phoneCodeHash: string;
      nextType?: auth.TypeCodeType;
      timeout?: int;
    }
    export class SentCodeSuccess extends VirtualClass<{
      authorization: auth.TypeAuthorization;
    }> {
    CONSTRUCTOR_ID: 596704836;
    SUBCLASS_OF_ID: 1827172481;
    classType: "constructor";
    className: "auth.SentCodeSuccess";
    static fromReader(reader: Reader): SentCodeSuccess;
      authorization: auth.TypeAuthorization;
    }
    export class Authorization extends VirtualClass<{
      // flags: null;
      setupPasswordRequired?: boolean;
      otherwiseReloginDays?: int;
      tmpSessions?: int;
      futureAuthToken?: bytes;
      user: Api.TypeUser;
    }> {
    CONSTRUCTOR_ID: 782418132;
    SUBCLASS_OF_ID: 3118485049;
    classType: "constructor";
    className: "auth.Authorization";
    static fromReader(reader: Reader): Authorization;
      // flags: null;
      setupPasswordRequired?: boolean;
      otherwiseReloginDays?: int;
      tmpSessions?: int;
      futureAuthToken?: bytes;
      user: Api.TypeUser;
    }
    export class AuthorizationSignUpRequired extends VirtualClass<{
      // flags: null;
      termsOfService?: help.TypeTermsOfService;
    }> {
    CONSTRUCTOR_ID: 1148485274;
    SUBCLASS_OF_ID: 3118485049;
    classType: "constructor";
    className: "auth.AuthorizationSignUpRequired";
    static fromReader(reader: Reader): AuthorizationSignUpRequired;
      // flags: null;
      termsOfService?: help.TypeTermsOfService;
    }
    export class ExportedAuthorization extends VirtualClass<{
      id: long;
      bytes: bytes;
    }> {
    CONSTRUCTOR_ID: 3023364792;
    SUBCLASS_OF_ID: 1607593041;
    classType: "constructor";
    className: "auth.ExportedAuthorization";
    static fromReader(reader: Reader): ExportedAuthorization;
      id: long;
      bytes: bytes;
    }
    export class PasswordRecovery extends VirtualClass<{
      emailPattern: string;
    }> {
    CONSTRUCTOR_ID: 326715557;
    SUBCLASS_OF_ID: 4201829434;
    classType: "constructor";
    className: "auth.PasswordRecovery";
    static fromReader(reader: Reader): PasswordRecovery;
      emailPattern: string;
    }
    export class CodeTypeSms extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1923290508;
    SUBCLASS_OF_ID: 3019105281;
    classType: "constructor";
    className: "auth.CodeTypeSms";
    static fromReader(reader: Reader): CodeTypeSms;
}
    export class CodeTypeCall extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1948046307;
    SUBCLASS_OF_ID: 3019105281;
    classType: "constructor";
    className: "auth.CodeTypeCall";
    static fromReader(reader: Reader): CodeTypeCall;
}
    export class CodeTypeFlashCall extends VirtualClass<void> {
    CONSTRUCTOR_ID: 577556219;
    SUBCLASS_OF_ID: 3019105281;
    classType: "constructor";
    className: "auth.CodeTypeFlashCall";
    static fromReader(reader: Reader): CodeTypeFlashCall;
}
    export class CodeTypeMissedCall extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3592083182;
    SUBCLASS_OF_ID: 3019105281;
    classType: "constructor";
    className: "auth.CodeTypeMissedCall";
    static fromReader(reader: Reader): CodeTypeMissedCall;
}
    export class CodeTypeFragmentSms extends VirtualClass<void> {
    CONSTRUCTOR_ID: 116234636;
    SUBCLASS_OF_ID: 3019105281;
    classType: "constructor";
    className: "auth.CodeTypeFragmentSms";
    static fromReader(reader: Reader): CodeTypeFragmentSms;
}
    export class SentCodeTypeApp extends VirtualClass<{
      length: int;
    }> {
    CONSTRUCTOR_ID: 1035688326;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeApp";
    static fromReader(reader: Reader): SentCodeTypeApp;
      length: int;
    }
    export class SentCodeTypeSms extends VirtualClass<{
      length: int;
    }> {
    CONSTRUCTOR_ID: 3221273506;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeSms";
    static fromReader(reader: Reader): SentCodeTypeSms;
      length: int;
    }
    export class SentCodeTypeCall extends VirtualClass<{
      length: int;
    }> {
    CONSTRUCTOR_ID: 1398007207;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeCall";
    static fromReader(reader: Reader): SentCodeTypeCall;
      length: int;
    }
    export class SentCodeTypeFlashCall extends VirtualClass<{
      pattern: string;
    }> {
    CONSTRUCTOR_ID: 2869151449;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeFlashCall";
    static fromReader(reader: Reader): SentCodeTypeFlashCall;
      pattern: string;
    }
    export class SentCodeTypeMissedCall extends VirtualClass<{
      prefix: string;
      length: int;
    }> {
    CONSTRUCTOR_ID: 2181063812;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeMissedCall";
    static fromReader(reader: Reader): SentCodeTypeMissedCall;
      prefix: string;
      length: int;
    }
    export class SentCodeTypeEmailCode extends VirtualClass<{
      // flags: null;
      appleSigninAllowed?: boolean;
      googleSigninAllowed?: boolean;
      emailPattern: string;
      length: int;
      resetAvailablePeriod?: int;
      resetPendingDate?: int;
    }> {
    CONSTRUCTOR_ID: 4098946459;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeEmailCode";
    static fromReader(reader: Reader): SentCodeTypeEmailCode;
      // flags: null;
      appleSigninAllowed?: boolean;
      googleSigninAllowed?: boolean;
      emailPattern: string;
      length: int;
      resetAvailablePeriod?: int;
      resetPendingDate?: int;
    }
    export class SentCodeTypeSetUpEmailRequired extends VirtualClass<{
      // flags: null;
      appleSigninAllowed?: boolean;
      googleSigninAllowed?: boolean;
    }> {
    CONSTRUCTOR_ID: 2773032426;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeSetUpEmailRequired";
    static fromReader(reader: Reader): SentCodeTypeSetUpEmailRequired;
      // flags: null;
      appleSigninAllowed?: boolean;
      googleSigninAllowed?: boolean;
    }
    export class SentCodeTypeFragmentSms extends VirtualClass<{
      url: string;
      length: int;
    }> {
    CONSTRUCTOR_ID: 3646315577;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeFragmentSms";
    static fromReader(reader: Reader): SentCodeTypeFragmentSms;
      url: string;
      length: int;
    }
    export class SentCodeTypeFirebaseSms extends VirtualClass<{
      // flags: null;
      nonce?: bytes;
      playIntegrityProjectId?: long;
      playIntegrityNonce?: bytes;
      receipt?: string;
      pushTimeout?: int;
      length: int;
    }> {
    CONSTRUCTOR_ID: 10475318;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeFirebaseSms";
    static fromReader(reader: Reader): SentCodeTypeFirebaseSms;
      // flags: null;
      nonce?: bytes;
      playIntegrityProjectId?: long;
      playIntegrityNonce?: bytes;
      receipt?: string;
      pushTimeout?: int;
      length: int;
    }
    export class SentCodeTypeSmsWord extends VirtualClass<{
      // flags: null;
      beginning?: string;
    }> {
    CONSTRUCTOR_ID: 2752949377;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeSmsWord";
    static fromReader(reader: Reader): SentCodeTypeSmsWord;
      // flags: null;
      beginning?: string;
    }
    export class SentCodeTypeSmsPhrase extends VirtualClass<{
      // flags: null;
      beginning?: string;
    }> {
    CONSTRUCTOR_ID: 3010958511;
    SUBCLASS_OF_ID: 4284159374;
    classType: "constructor";
    className: "auth.SentCodeTypeSmsPhrase";
    static fromReader(reader: Reader): SentCodeTypeSmsPhrase;
      // flags: null;
      beginning?: string;
    }
    export class LoginToken extends VirtualClass<{
      expires: int;
      token: bytes;
    }> {
    CONSTRUCTOR_ID: 1654593920;
    SUBCLASS_OF_ID: 1800795702;
    classType: "constructor";
    className: "auth.LoginToken";
    static fromReader(reader: Reader): LoginToken;
      expires: int;
      token: bytes;
    }
    export class LoginTokenMigrateTo extends VirtualClass<{
      dcId: int;
      token: bytes;
    }> {
    CONSTRUCTOR_ID: 110008598;
    SUBCLASS_OF_ID: 1800795702;
    classType: "constructor";
    className: "auth.LoginTokenMigrateTo";
    static fromReader(reader: Reader): LoginTokenMigrateTo;
      dcId: int;
      token: bytes;
    }
    export class LoginTokenSuccess extends VirtualClass<{
      authorization: auth.TypeAuthorization;
    }> {
    CONSTRUCTOR_ID: 957176926;
    SUBCLASS_OF_ID: 1800795702;
    classType: "constructor";
    className: "auth.LoginTokenSuccess";
    static fromReader(reader: Reader): LoginTokenSuccess;
      authorization: auth.TypeAuthorization;
    }
    export class LoggedOut extends VirtualClass<{
      // flags: null;
      futureAuthToken?: bytes;
    }> {
    CONSTRUCTOR_ID: 3282207583;
    SUBCLASS_OF_ID: 176177941;
    classType: "constructor";
    className: "auth.LoggedOut";
    static fromReader(reader: Reader): LoggedOut;
      // flags: null;
      futureAuthToken?: bytes;
    }
  }

  export namespace contacts {
    export class ContactsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3075189202;
    SUBCLASS_OF_ID: 951985654;
    classType: "constructor";
    className: "contacts.ContactsNotModified";
    static fromReader(reader: Reader): ContactsNotModified;
}
    export class Contacts extends VirtualClass<{
      contacts: Api.TypeContact[];
      savedCount: int;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3941105218;
    SUBCLASS_OF_ID: 951985654;
    classType: "constructor";
    className: "contacts.Contacts";
    static fromReader(reader: Reader): Contacts;
      contacts: Api.TypeContact[];
      savedCount: int;
      users: Api.TypeUser[];
    }
    export class ImportedContacts extends VirtualClass<{
      imported: Api.TypeImportedContact[];
      popularInvites: Api.TypePopularContact[];
      retryContacts: long[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2010127419;
    SUBCLASS_OF_ID: 2171776403;
    classType: "constructor";
    className: "contacts.ImportedContacts";
    static fromReader(reader: Reader): ImportedContacts;
      imported: Api.TypeImportedContact[];
      popularInvites: Api.TypePopularContact[];
      retryContacts: long[];
      users: Api.TypeUser[];
    }
    export class Blocked extends VirtualClass<{
      blocked: Api.TypePeerBlocked[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 182326673;
    SUBCLASS_OF_ID: 4290400079;
    classType: "constructor";
    className: "contacts.Blocked";
    static fromReader(reader: Reader): Blocked;
      blocked: Api.TypePeerBlocked[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class BlockedSlice extends VirtualClass<{
      count: int;
      blocked: Api.TypePeerBlocked[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3781575060;
    SUBCLASS_OF_ID: 4290400079;
    classType: "constructor";
    className: "contacts.BlockedSlice";
    static fromReader(reader: Reader): BlockedSlice;
      count: int;
      blocked: Api.TypePeerBlocked[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class Found extends VirtualClass<{
      myResults: Api.TypePeer[];
      results: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3004386717;
    SUBCLASS_OF_ID: 1132896995;
    classType: "constructor";
    className: "contacts.Found";
    static fromReader(reader: Reader): Found;
      myResults: Api.TypePeer[];
      results: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ResolvedPeer extends VirtualClass<{
      peer: Api.TypePeer;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2131196633;
    SUBCLASS_OF_ID: 4033196968;
    classType: "constructor";
    className: "contacts.ResolvedPeer";
    static fromReader(reader: Reader): ResolvedPeer;
      peer: Api.TypePeer;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class TopPeersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3727060725;
    SUBCLASS_OF_ID: 2666052488;
    classType: "constructor";
    className: "contacts.TopPeersNotModified";
    static fromReader(reader: Reader): TopPeersNotModified;
}
    export class TopPeers extends VirtualClass<{
      categories: Api.TypeTopPeerCategoryPeers[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1891070632;
    SUBCLASS_OF_ID: 2666052488;
    classType: "constructor";
    className: "contacts.TopPeers";
    static fromReader(reader: Reader): TopPeers;
      categories: Api.TypeTopPeerCategoryPeers[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class TopPeersDisabled extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3039597469;
    SUBCLASS_OF_ID: 2666052488;
    classType: "constructor";
    className: "contacts.TopPeersDisabled";
    static fromReader(reader: Reader): TopPeersDisabled;
}
    export class ContactBirthdays extends VirtualClass<{
      contacts: Api.TypeContactBirthday[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 290452237;
    SUBCLASS_OF_ID: 242920447;
    classType: "constructor";
    className: "contacts.ContactBirthdays";
    static fromReader(reader: Reader): ContactBirthdays;
      contacts: Api.TypeContactBirthday[];
      users: Api.TypeUser[];
    }
  }

  export namespace messages {
    export class Dialogs extends VirtualClass<{
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 364538944;
    SUBCLASS_OF_ID: 236671726;
    classType: "constructor";
    className: "messages.Dialogs";
    static fromReader(reader: Reader): Dialogs;
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class DialogsSlice extends VirtualClass<{
      count: int;
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1910543603;
    SUBCLASS_OF_ID: 236671726;
    classType: "constructor";
    className: "messages.DialogsSlice";
    static fromReader(reader: Reader): DialogsSlice;
      count: int;
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class DialogsNotModified extends VirtualClass<{
      count: int;
    }> {
    CONSTRUCTOR_ID: 4041467286;
    SUBCLASS_OF_ID: 236671726;
    classType: "constructor";
    className: "messages.DialogsNotModified";
    static fromReader(reader: Reader): DialogsNotModified;
      count: int;
    }
    export class Messages extends VirtualClass<{
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2356252295;
    SUBCLASS_OF_ID: 3568569182;
    classType: "constructor";
    className: "messages.Messages";
    static fromReader(reader: Reader): Messages;
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class MessagesSlice extends VirtualClass<{
      // flags: null;
      inexact?: boolean;
      count: int;
      nextRate?: int;
      offsetIdOffset?: int;
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 978610270;
    SUBCLASS_OF_ID: 3568569182;
    classType: "constructor";
    className: "messages.MessagesSlice";
    static fromReader(reader: Reader): MessagesSlice;
      // flags: null;
      inexact?: boolean;
      count: int;
      nextRate?: int;
      offsetIdOffset?: int;
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChannelMessages extends VirtualClass<{
      // flags: null;
      inexact?: boolean;
      pts: int;
      count: int;
      offsetIdOffset?: int;
      messages: Api.TypeMessage[];
      topics: Api.TypeForumTopic[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3346446926;
    SUBCLASS_OF_ID: 3568569182;
    classType: "constructor";
    className: "messages.ChannelMessages";
    static fromReader(reader: Reader): ChannelMessages;
      // flags: null;
      inexact?: boolean;
      pts: int;
      count: int;
      offsetIdOffset?: int;
      messages: Api.TypeMessage[];
      topics: Api.TypeForumTopic[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class MessagesNotModified extends VirtualClass<{
      count: int;
    }> {
    CONSTRUCTOR_ID: 1951620897;
    SUBCLASS_OF_ID: 3568569182;
    classType: "constructor";
    className: "messages.MessagesNotModified";
    static fromReader(reader: Reader): MessagesNotModified;
      count: int;
    }
    export class Chats extends VirtualClass<{
      chats: Api.TypeChat[];
    }> {
    CONSTRUCTOR_ID: 1694474197;
    SUBCLASS_OF_ID: 2580925204;
    classType: "constructor";
    className: "messages.Chats";
    static fromReader(reader: Reader): Chats;
      chats: Api.TypeChat[];
    }
    export class ChatsSlice extends VirtualClass<{
      count: int;
      chats: Api.TypeChat[];
    }> {
    CONSTRUCTOR_ID: 2631405892;
    SUBCLASS_OF_ID: 2580925204;
    classType: "constructor";
    className: "messages.ChatsSlice";
    static fromReader(reader: Reader): ChatsSlice;
      count: int;
      chats: Api.TypeChat[];
    }
    export class ChatFull extends VirtualClass<{
      fullChat: Api.TypeChatFull;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3856126364;
    SUBCLASS_OF_ID: 576344329;
    classType: "constructor";
    className: "messages.ChatFull";
    static fromReader(reader: Reader): ChatFull;
      fullChat: Api.TypeChatFull;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class AffectedHistory extends VirtualClass<{
      pts: int;
      ptsCount: int;
      offset: int;
    }> {
    CONSTRUCTOR_ID: 3025955281;
    SUBCLASS_OF_ID: 743031062;
    classType: "constructor";
    className: "messages.AffectedHistory";
    static fromReader(reader: Reader): AffectedHistory;
      pts: int;
      ptsCount: int;
      offset: int;
    }
    export class DhConfigNotModified extends VirtualClass<{
      random: bytes;
    }> {
    CONSTRUCTOR_ID: 3236054581;
    SUBCLASS_OF_ID: 3834178955;
    classType: "constructor";
    className: "messages.DhConfigNotModified";
    static fromReader(reader: Reader): DhConfigNotModified;
      random: bytes;
    }
    export class DhConfig extends VirtualClass<{
      g: int;
      p: bytes;
      version: int;
      random: bytes;
    }> {
    CONSTRUCTOR_ID: 740433629;
    SUBCLASS_OF_ID: 3834178955;
    classType: "constructor";
    className: "messages.DhConfig";
    static fromReader(reader: Reader): DhConfig;
      g: int;
      p: bytes;
      version: int;
      random: bytes;
    }
    export class SentEncryptedMessage extends VirtualClass<{
      date: int;
    }> {
    CONSTRUCTOR_ID: 1443858741;
    SUBCLASS_OF_ID: 3382591056;
    classType: "constructor";
    className: "messages.SentEncryptedMessage";
    static fromReader(reader: Reader): SentEncryptedMessage;
      date: int;
    }
    export class SentEncryptedFile extends VirtualClass<{
      date: int;
      file: Api.TypeEncryptedFile;
    }> {
    CONSTRUCTOR_ID: 2492727090;
    SUBCLASS_OF_ID: 3382591056;
    classType: "constructor";
    className: "messages.SentEncryptedFile";
    static fromReader(reader: Reader): SentEncryptedFile;
      date: int;
      file: Api.TypeEncryptedFile;
    }
    export class StickersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 4050950690;
    SUBCLASS_OF_ID: 3611015646;
    classType: "constructor";
    className: "messages.StickersNotModified";
    static fromReader(reader: Reader): StickersNotModified;
}
    export class Stickers extends VirtualClass<{
      hash: long;
      stickers: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 816245886;
    SUBCLASS_OF_ID: 3611015646;
    classType: "constructor";
    className: "messages.Stickers";
    static fromReader(reader: Reader): Stickers;
      hash: long;
      stickers: Api.TypeDocument[];
    }
    export class AllStickersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3898999491;
    SUBCLASS_OF_ID: 1166231593;
    classType: "constructor";
    className: "messages.AllStickersNotModified";
    static fromReader(reader: Reader): AllStickersNotModified;
}
    export class AllStickers extends VirtualClass<{
      hash: long;
      sets: Api.TypeStickerSet[];
    }> {
    CONSTRUCTOR_ID: 3451637435;
    SUBCLASS_OF_ID: 1166231593;
    classType: "constructor";
    className: "messages.AllStickers";
    static fromReader(reader: Reader): AllStickers;
      hash: long;
      sets: Api.TypeStickerSet[];
    }
    export class AffectedMessages extends VirtualClass<{
      pts: int;
      ptsCount: int;
    }> {
    CONSTRUCTOR_ID: 2228326789;
    SUBCLASS_OF_ID: 3469983854;
    classType: "constructor";
    className: "messages.AffectedMessages";
    static fromReader(reader: Reader): AffectedMessages;
      pts: int;
      ptsCount: int;
    }
    export class StickerSet extends VirtualClass<{
      set: Api.TypeStickerSet;
      packs: Api.TypeStickerPack[];
      keywords: Api.TypeStickerKeyword[];
      documents: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 1846886166;
    SUBCLASS_OF_ID: 2607827546;
    classType: "constructor";
    className: "messages.StickerSet";
    static fromReader(reader: Reader): StickerSet;
      set: Api.TypeStickerSet;
      packs: Api.TypeStickerPack[];
      keywords: Api.TypeStickerKeyword[];
      documents: Api.TypeDocument[];
    }
    export class StickerSetNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3556320491;
    SUBCLASS_OF_ID: 2607827546;
    classType: "constructor";
    className: "messages.StickerSetNotModified";
    static fromReader(reader: Reader): StickerSetNotModified;
}
    export class SavedGifsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3892468898;
    SUBCLASS_OF_ID: 2794152437;
    classType: "constructor";
    className: "messages.SavedGifsNotModified";
    static fromReader(reader: Reader): SavedGifsNotModified;
}
    export class SavedGifs extends VirtualClass<{
      hash: long;
      gifs: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 2225089037;
    SUBCLASS_OF_ID: 2794152437;
    classType: "constructor";
    className: "messages.SavedGifs";
    static fromReader(reader: Reader): SavedGifs;
      hash: long;
      gifs: Api.TypeDocument[];
    }
    export class BotResults extends VirtualClass<{
      // flags: null;
      gallery?: boolean;
      queryId: long;
      nextOffset?: string;
      switchPm?: Api.TypeInlineBotSwitchPM;
      switchWebview?: Api.TypeInlineBotWebView;
      results: Api.TypeBotInlineResult[];
      cacheTime: int;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3760321270;
    SUBCLASS_OF_ID: 1054136777;
    classType: "constructor";
    className: "messages.BotResults";
    static fromReader(reader: Reader): BotResults;
      // flags: null;
      gallery?: boolean;
      queryId: long;
      nextOffset?: string;
      switchPm?: Api.TypeInlineBotSwitchPM;
      switchWebview?: Api.TypeInlineBotWebView;
      results: Api.TypeBotInlineResult[];
      cacheTime: int;
      users: Api.TypeUser[];
    }
    export class BotCallbackAnswer extends VirtualClass<{
      // flags: null;
      alert?: boolean;
      hasUrl?: boolean;
      nativeUi?: boolean;
      message?: string;
      url?: string;
      cacheTime: int;
    }> {
    CONSTRUCTOR_ID: 911761060;
    SUBCLASS_OF_ID: 1817039244;
    classType: "constructor";
    className: "messages.BotCallbackAnswer";
    static fromReader(reader: Reader): BotCallbackAnswer;
      // flags: null;
      alert?: boolean;
      hasUrl?: boolean;
      nativeUi?: boolean;
      message?: string;
      url?: string;
      cacheTime: int;
    }
    export class MessageEditData extends VirtualClass<{
      // flags: null;
      caption?: boolean;
    }> {
    CONSTRUCTOR_ID: 649453030;
    SUBCLASS_OF_ID: 4215772317;
    classType: "constructor";
    className: "messages.MessageEditData";
    static fromReader(reader: Reader): MessageEditData;
      // flags: null;
      caption?: boolean;
    }
    export class PeerDialogs extends VirtualClass<{
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      state: updates.TypeState;
    }> {
    CONSTRUCTOR_ID: 863093588;
    SUBCLASS_OF_ID: 986120498;
    classType: "constructor";
    className: "messages.PeerDialogs";
    static fromReader(reader: Reader): PeerDialogs;
      dialogs: Api.TypeDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      state: updates.TypeState;
    }
    export class FeaturedStickersNotModified extends VirtualClass<{
      count: int;
    }> {
    CONSTRUCTOR_ID: 3336309862;
    SUBCLASS_OF_ID: 638891810;
    classType: "constructor";
    className: "messages.FeaturedStickersNotModified";
    static fromReader(reader: Reader): FeaturedStickersNotModified;
      count: int;
    }
    export class FeaturedStickers extends VirtualClass<{
      // flags: null;
      premium?: boolean;
      hash: long;
      count: int;
      sets: Api.TypeStickerSetCovered[];
      unread: long[];
    }> {
    CONSTRUCTOR_ID: 3191351558;
    SUBCLASS_OF_ID: 638891810;
    classType: "constructor";
    className: "messages.FeaturedStickers";
    static fromReader(reader: Reader): FeaturedStickers;
      // flags: null;
      premium?: boolean;
      hash: long;
      count: int;
      sets: Api.TypeStickerSetCovered[];
      unread: long[];
    }
    export class RecentStickersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 186120336;
    SUBCLASS_OF_ID: 4151281283;
    classType: "constructor";
    className: "messages.RecentStickersNotModified";
    static fromReader(reader: Reader): RecentStickersNotModified;
}
    export class RecentStickers extends VirtualClass<{
      hash: long;
      packs: Api.TypeStickerPack[];
      stickers: Api.TypeDocument[];
      dates: int[];
    }> {
    CONSTRUCTOR_ID: 2295561302;
    SUBCLASS_OF_ID: 4151281283;
    classType: "constructor";
    className: "messages.RecentStickers";
    static fromReader(reader: Reader): RecentStickers;
      hash: long;
      packs: Api.TypeStickerPack[];
      stickers: Api.TypeDocument[];
      dates: int[];
    }
    export class ArchivedStickers extends VirtualClass<{
      count: int;
      sets: Api.TypeStickerSetCovered[];
    }> {
    CONSTRUCTOR_ID: 1338747336;
    SUBCLASS_OF_ID: 1922488177;
    classType: "constructor";
    className: "messages.ArchivedStickers";
    static fromReader(reader: Reader): ArchivedStickers;
      count: int;
      sets: Api.TypeStickerSetCovered[];
    }
    export class StickerSetInstallResultSuccess extends VirtualClass<void> {
    CONSTRUCTOR_ID: 946083368;
    SUBCLASS_OF_ID: 1741373416;
    classType: "constructor";
    className: "messages.StickerSetInstallResultSuccess";
    static fromReader(reader: Reader): StickerSetInstallResultSuccess;
}
    export class StickerSetInstallResultArchive extends VirtualClass<{
      sets: Api.TypeStickerSetCovered[];
    }> {
    CONSTRUCTOR_ID: 904138920;
    SUBCLASS_OF_ID: 1741373416;
    classType: "constructor";
    className: "messages.StickerSetInstallResultArchive";
    static fromReader(reader: Reader): StickerSetInstallResultArchive;
      sets: Api.TypeStickerSetCovered[];
    }
    export class HighScores extends VirtualClass<{
      scores: Api.TypeHighScore[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2587622809;
    SUBCLASS_OF_ID: 1825412605;
    classType: "constructor";
    className: "messages.HighScores";
    static fromReader(reader: Reader): HighScores;
      scores: Api.TypeHighScore[];
      users: Api.TypeUser[];
    }
    export class FavedStickersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2660214483;
    SUBCLASS_OF_ID: 2389929913;
    classType: "constructor";
    className: "messages.FavedStickersNotModified";
    static fromReader(reader: Reader): FavedStickersNotModified;
}
    export class FavedStickers extends VirtualClass<{
      hash: long;
      packs: Api.TypeStickerPack[];
      stickers: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 750063767;
    SUBCLASS_OF_ID: 2389929913;
    classType: "constructor";
    className: "messages.FavedStickers";
    static fromReader(reader: Reader): FavedStickers;
      hash: long;
      packs: Api.TypeStickerPack[];
      stickers: Api.TypeDocument[];
    }
    export class FoundStickerSetsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 223655517;
    SUBCLASS_OF_ID: 68023137;
    classType: "constructor";
    className: "messages.FoundStickerSetsNotModified";
    static fromReader(reader: Reader): FoundStickerSetsNotModified;
}
    export class FoundStickerSets extends VirtualClass<{
      hash: long;
      sets: Api.TypeStickerSetCovered[];
    }> {
    CONSTRUCTOR_ID: 2331024850;
    SUBCLASS_OF_ID: 68023137;
    classType: "constructor";
    className: "messages.FoundStickerSets";
    static fromReader(reader: Reader): FoundStickerSets;
      hash: long;
      sets: Api.TypeStickerSetCovered[];
    }
    export class SearchCounter extends VirtualClass<{
      // flags: null;
      inexact?: boolean;
      filter: Api.TypeMessagesFilter;
      count: int;
    }> {
    CONSTRUCTOR_ID: 3896830975;
    SUBCLASS_OF_ID: 3601317794;
    classType: "constructor";
    className: "messages.SearchCounter";
    static fromReader(reader: Reader): SearchCounter;
      // flags: null;
      inexact?: boolean;
      filter: Api.TypeMessagesFilter;
      count: int;
    }
    export class InactiveChats extends VirtualClass<{
      dates: int[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2837970629;
    SUBCLASS_OF_ID: 2348013524;
    classType: "constructor";
    className: "messages.InactiveChats";
    static fromReader(reader: Reader): InactiveChats;
      dates: int[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class VotesList extends VirtualClass<{
      // flags: null;
      count: int;
      votes: Api.TypeMessagePeerVote[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }> {
    CONSTRUCTOR_ID: 1218005070;
    SUBCLASS_OF_ID: 3256457349;
    classType: "constructor";
    className: "messages.VotesList";
    static fromReader(reader: Reader): VotesList;
      // flags: null;
      count: int;
      votes: Api.TypeMessagePeerVote[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }
    export class MessageViews extends VirtualClass<{
      views: Api.TypeMessageViews[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3066361155;
    SUBCLASS_OF_ID: 2947935132;
    classType: "constructor";
    className: "messages.MessageViews";
    static fromReader(reader: Reader): MessageViews;
      views: Api.TypeMessageViews[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class DiscussionMessage extends VirtualClass<{
      // flags: null;
      messages: Api.TypeMessage[];
      maxId?: int;
      readInboxMaxId?: int;
      readOutboxMaxId?: int;
      unreadCount: int;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2788431746;
    SUBCLASS_OF_ID: 1408820200;
    classType: "constructor";
    className: "messages.DiscussionMessage";
    static fromReader(reader: Reader): DiscussionMessage;
      // flags: null;
      messages: Api.TypeMessage[];
      maxId?: int;
      readInboxMaxId?: int;
      readOutboxMaxId?: int;
      unreadCount: int;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class HistoryImport extends VirtualClass<{
      id: long;
    }> {
    CONSTRUCTOR_ID: 375566091;
    SUBCLASS_OF_ID: 2978723082;
    classType: "constructor";
    className: "messages.HistoryImport";
    static fromReader(reader: Reader): HistoryImport;
      id: long;
    }
    export class HistoryImportParsed extends VirtualClass<{
      // flags: null;
      pm?: boolean;
      group?: boolean;
      title?: string;
    }> {
    CONSTRUCTOR_ID: 1578088377;
    SUBCLASS_OF_ID: 1538421259;
    classType: "constructor";
    className: "messages.HistoryImportParsed";
    static fromReader(reader: Reader): HistoryImportParsed;
      // flags: null;
      pm?: boolean;
      group?: boolean;
      title?: string;
    }
    export class AffectedFoundMessages extends VirtualClass<{
      pts: int;
      ptsCount: int;
      offset: int;
      messages: int[];
    }> {
    CONSTRUCTOR_ID: 4019011180;
    SUBCLASS_OF_ID: 4162282798;
    classType: "constructor";
    className: "messages.AffectedFoundMessages";
    static fromReader(reader: Reader): AffectedFoundMessages;
      pts: int;
      ptsCount: int;
      offset: int;
      messages: int[];
    }
    export class ExportedChatInvites extends VirtualClass<{
      count: int;
      invites: Api.TypeExportedChatInvite[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3183881676;
    SUBCLASS_OF_ID: 1614624881;
    classType: "constructor";
    className: "messages.ExportedChatInvites";
    static fromReader(reader: Reader): ExportedChatInvites;
      count: int;
      invites: Api.TypeExportedChatInvite[];
      users: Api.TypeUser[];
    }
    export class ExportedChatInvite extends VirtualClass<{
      invite: Api.TypeExportedChatInvite;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 410107472;
    SUBCLASS_OF_ID: 2195510474;
    classType: "constructor";
    className: "messages.ExportedChatInvite";
    static fromReader(reader: Reader): ExportedChatInvite;
      invite: Api.TypeExportedChatInvite;
      users: Api.TypeUser[];
    }
    export class ExportedChatInviteReplaced extends VirtualClass<{
      invite: Api.TypeExportedChatInvite;
      newInvite: Api.TypeExportedChatInvite;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 572915951;
    SUBCLASS_OF_ID: 2195510474;
    classType: "constructor";
    className: "messages.ExportedChatInviteReplaced";
    static fromReader(reader: Reader): ExportedChatInviteReplaced;
      invite: Api.TypeExportedChatInvite;
      newInvite: Api.TypeExportedChatInvite;
      users: Api.TypeUser[];
    }
    export class ChatInviteImporters extends VirtualClass<{
      count: int;
      importers: Api.TypeChatInviteImporter[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2176233482;
    SUBCLASS_OF_ID: 3653012134;
    classType: "constructor";
    className: "messages.ChatInviteImporters";
    static fromReader(reader: Reader): ChatInviteImporters;
      count: int;
      importers: Api.TypeChatInviteImporter[];
      users: Api.TypeUser[];
    }
    export class ChatAdminsWithInvites extends VirtualClass<{
      admins: Api.TypeChatAdminWithInvites[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3063640791;
    SUBCLASS_OF_ID: 2405149995;
    classType: "constructor";
    className: "messages.ChatAdminsWithInvites";
    static fromReader(reader: Reader): ChatAdminsWithInvites;
      admins: Api.TypeChatAdminWithInvites[];
      users: Api.TypeUser[];
    }
    export class CheckedHistoryImportPeer extends VirtualClass<{
      confirmText: string;
    }> {
    CONSTRUCTOR_ID: 2723014423;
    SUBCLASS_OF_ID: 3091968823;
    classType: "constructor";
    className: "messages.CheckedHistoryImportPeer";
    static fromReader(reader: Reader): CheckedHistoryImportPeer;
      confirmText: string;
    }
    export class SponsoredMessages extends VirtualClass<{
      // flags: null;
      postsBetween?: int;
      messages: Api.TypeSponsoredMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3387825543;
    SUBCLASS_OF_ID: 2134993376;
    classType: "constructor";
    className: "messages.SponsoredMessages";
    static fromReader(reader: Reader): SponsoredMessages;
      // flags: null;
      postsBetween?: int;
      messages: Api.TypeSponsoredMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SponsoredMessagesEmpty extends VirtualClass<void> {
    CONSTRUCTOR_ID: 406407439;
    SUBCLASS_OF_ID: 2134993376;
    classType: "constructor";
    className: "messages.SponsoredMessagesEmpty";
    static fromReader(reader: Reader): SponsoredMessagesEmpty;
}
    export class SearchResultsCalendar extends VirtualClass<{
      // flags: null;
      inexact?: boolean;
      count: int;
      minDate: int;
      minMsgId: int;
      offsetIdOffset?: int;
      periods: Api.TypeSearchResultsCalendarPeriod[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 343859772;
    SUBCLASS_OF_ID: 2462409743;
    classType: "constructor";
    className: "messages.SearchResultsCalendar";
    static fromReader(reader: Reader): SearchResultsCalendar;
      // flags: null;
      inexact?: boolean;
      count: int;
      minDate: int;
      minMsgId: int;
      offsetIdOffset?: int;
      periods: Api.TypeSearchResultsCalendarPeriod[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SearchResultsPositions extends VirtualClass<{
      count: int;
      positions: Api.TypeSearchResultsPosition[];
    }> {
    CONSTRUCTOR_ID: 1404185519;
    SUBCLASS_OF_ID: 3647172749;
    classType: "constructor";
    className: "messages.SearchResultsPositions";
    static fromReader(reader: Reader): SearchResultsPositions;
      count: int;
      positions: Api.TypeSearchResultsPosition[];
    }
    export class PeerSettings extends VirtualClass<{
      settings: Api.TypePeerSettings;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1753266509;
    SUBCLASS_OF_ID: 1705179041;
    classType: "constructor";
    className: "messages.PeerSettings";
    static fromReader(reader: Reader): PeerSettings;
      settings: Api.TypePeerSettings;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class MessageReactionsList extends VirtualClass<{
      // flags: null;
      count: int;
      reactions: Api.TypeMessagePeerReaction[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }> {
    CONSTRUCTOR_ID: 834488621;
    SUBCLASS_OF_ID: 1627186662;
    classType: "constructor";
    className: "messages.MessageReactionsList";
    static fromReader(reader: Reader): MessageReactionsList;
      // flags: null;
      count: int;
      reactions: Api.TypeMessagePeerReaction[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }
    export class AvailableReactionsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2668042583;
    SUBCLASS_OF_ID: 3827740034;
    classType: "constructor";
    className: "messages.AvailableReactionsNotModified";
    static fromReader(reader: Reader): AvailableReactionsNotModified;
}
    export class AvailableReactions extends VirtualClass<{
      hash: int;
      reactions: Api.TypeAvailableReaction[];
    }> {
    CONSTRUCTOR_ID: 1989032621;
    SUBCLASS_OF_ID: 3827740034;
    classType: "constructor";
    className: "messages.AvailableReactions";
    static fromReader(reader: Reader): AvailableReactions;
      hash: int;
      reactions: Api.TypeAvailableReaction[];
    }
    export class TranscribedAudio extends VirtualClass<{
      // flags: null;
      pending?: boolean;
      transcriptionId: long;
      text: string;
      trialRemainsNum?: int;
      trialRemainsUntilDate?: int;
    }> {
    CONSTRUCTOR_ID: 3485063511;
    SUBCLASS_OF_ID: 565332278;
    classType: "constructor";
    className: "messages.TranscribedAudio";
    static fromReader(reader: Reader): TranscribedAudio;
      // flags: null;
      pending?: boolean;
      transcriptionId: long;
      text: string;
      trialRemainsNum?: int;
      trialRemainsUntilDate?: int;
    }
    export class ReactionsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2960120799;
    SUBCLASS_OF_ID: 2915271460;
    classType: "constructor";
    className: "messages.ReactionsNotModified";
    static fromReader(reader: Reader): ReactionsNotModified;
}
    export class Reactions extends VirtualClass<{
      hash: long;
      reactions: Api.TypeReaction[];
    }> {
    CONSTRUCTOR_ID: 3942512406;
    SUBCLASS_OF_ID: 2915271460;
    classType: "constructor";
    className: "messages.Reactions";
    static fromReader(reader: Reader): Reactions;
      hash: long;
      reactions: Api.TypeReaction[];
    }
    export class ForumTopics extends VirtualClass<{
      // flags: null;
      orderByCreateDate?: boolean;
      count: int;
      topics: Api.TypeForumTopic[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      pts: int;
    }> {
    CONSTRUCTOR_ID: 913709011;
    SUBCLASS_OF_ID: 2384281118;
    classType: "constructor";
    className: "messages.ForumTopics";
    static fromReader(reader: Reader): ForumTopics;
      // flags: null;
      orderByCreateDate?: boolean;
      count: int;
      topics: Api.TypeForumTopic[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      pts: int;
    }
    export class EmojiGroupsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1874111879;
    SUBCLASS_OF_ID: 2127189465;
    classType: "constructor";
    className: "messages.EmojiGroupsNotModified";
    static fromReader(reader: Reader): EmojiGroupsNotModified;
}
    export class EmojiGroups extends VirtualClass<{
      hash: int;
      groups: Api.TypeEmojiGroup[];
    }> {
    CONSTRUCTOR_ID: 2283780427;
    SUBCLASS_OF_ID: 2127189465;
    classType: "constructor";
    className: "messages.EmojiGroups";
    static fromReader(reader: Reader): EmojiGroups;
      hash: int;
      groups: Api.TypeEmojiGroup[];
    }
    export class TranslateResult extends VirtualClass<{
      result: Api.TypeTextWithEntities[];
    }> {
    CONSTRUCTOR_ID: 870003448;
    SUBCLASS_OF_ID: 37897192;
    classType: "constructor";
    className: "messages.TranslateResult";
    static fromReader(reader: Reader): TranslateResult;
      result: Api.TypeTextWithEntities[];
    }
    export class BotApp extends VirtualClass<{
      // flags: null;
      inactive?: boolean;
      requestWriteAccess?: boolean;
      hasSettings?: boolean;
      app: Api.TypeBotApp;
    }> {
    CONSTRUCTOR_ID: 3947933173;
    SUBCLASS_OF_ID: 2406630311;
    classType: "constructor";
    className: "messages.BotApp";
    static fromReader(reader: Reader): BotApp;
      // flags: null;
      inactive?: boolean;
      requestWriteAccess?: boolean;
      hasSettings?: boolean;
      app: Api.TypeBotApp;
    }
    export class WebPage extends VirtualClass<{
      webpage: Api.TypeWebPage;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4250800829;
    SUBCLASS_OF_ID: 754495828;
    classType: "constructor";
    className: "messages.WebPage";
    static fromReader(reader: Reader): WebPage;
      webpage: Api.TypeWebPage;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SavedDialogs extends VirtualClass<{
      dialogs: Api.TypeSavedDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4164608545;
    SUBCLASS_OF_ID: 1632352382;
    classType: "constructor";
    className: "messages.SavedDialogs";
    static fromReader(reader: Reader): SavedDialogs;
      dialogs: Api.TypeSavedDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SavedDialogsSlice extends VirtualClass<{
      count: int;
      dialogs: Api.TypeSavedDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1153080793;
    SUBCLASS_OF_ID: 1632352382;
    classType: "constructor";
    className: "messages.SavedDialogsSlice";
    static fromReader(reader: Reader): SavedDialogsSlice;
      count: int;
      dialogs: Api.TypeSavedDialog[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SavedDialogsNotModified extends VirtualClass<{
      count: int;
    }> {
    CONSTRUCTOR_ID: 3223285736;
    SUBCLASS_OF_ID: 1632352382;
    classType: "constructor";
    className: "messages.SavedDialogsNotModified";
    static fromReader(reader: Reader): SavedDialogsNotModified;
      count: int;
    }
    export class SavedReactionTagsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2291882479;
    SUBCLASS_OF_ID: 2744867811;
    classType: "constructor";
    className: "messages.SavedReactionTagsNotModified";
    static fromReader(reader: Reader): SavedReactionTagsNotModified;
}
    export class SavedReactionTags extends VirtualClass<{
      tags: Api.TypeSavedReactionTag[];
      hash: long;
    }> {
    CONSTRUCTOR_ID: 844731658;
    SUBCLASS_OF_ID: 2744867811;
    classType: "constructor";
    className: "messages.SavedReactionTags";
    static fromReader(reader: Reader): SavedReactionTags;
      tags: Api.TypeSavedReactionTag[];
      hash: long;
    }
    export class QuickReplies extends VirtualClass<{
      quickReplies: Api.TypeQuickReply[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3331155605;
    SUBCLASS_OF_ID: 4147636582;
    classType: "constructor";
    className: "messages.QuickReplies";
    static fromReader(reader: Reader): QuickReplies;
      quickReplies: Api.TypeQuickReply[];
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class QuickRepliesNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1603398491;
    SUBCLASS_OF_ID: 4147636582;
    classType: "constructor";
    className: "messages.QuickRepliesNotModified";
    static fromReader(reader: Reader): QuickRepliesNotModified;
}
    export class DialogFilters extends VirtualClass<{
      // flags: null;
      tagsEnabled?: boolean;
      filters: Api.TypeDialogFilter[];
    }> {
    CONSTRUCTOR_ID: 718878489;
    SUBCLASS_OF_ID: 2785014199;
    classType: "constructor";
    className: "messages.DialogFilters";
    static fromReader(reader: Reader): DialogFilters;
      // flags: null;
      tagsEnabled?: boolean;
      filters: Api.TypeDialogFilter[];
    }
    export class MyStickers extends VirtualClass<{
      count: int;
      sets: Api.TypeStickerSetCovered[];
    }> {
    CONSTRUCTOR_ID: 4211040925;
    SUBCLASS_OF_ID: 2981377290;
    classType: "constructor";
    className: "messages.MyStickers";
    static fromReader(reader: Reader): MyStickers;
      count: int;
      sets: Api.TypeStickerSetCovered[];
    }
    export class InvitedUsers extends VirtualClass<{
      updates: Api.TypeUpdates;
      missingInvitees: Api.TypeMissingInvitee[];
    }> {
    CONSTRUCTOR_ID: 2136862630;
    SUBCLASS_OF_ID: 1035899041;
    classType: "constructor";
    className: "messages.InvitedUsers";
    static fromReader(reader: Reader): InvitedUsers;
      updates: Api.TypeUpdates;
      missingInvitees: Api.TypeMissingInvitee[];
    }
    export class AvailableEffectsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3522009691;
    SUBCLASS_OF_ID: 1148245437;
    classType: "constructor";
    className: "messages.AvailableEffectsNotModified";
    static fromReader(reader: Reader): AvailableEffectsNotModified;
}
    export class AvailableEffects extends VirtualClass<{
      hash: int;
      effects: Api.TypeAvailableEffect[];
      documents: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 3185271150;
    SUBCLASS_OF_ID: 1148245437;
    classType: "constructor";
    className: "messages.AvailableEffects";
    static fromReader(reader: Reader): AvailableEffects;
      hash: int;
      effects: Api.TypeAvailableEffect[];
      documents: Api.TypeDocument[];
    }
    export class BotPreparedInlineMessage extends VirtualClass<{
      id: string;
      expireDate: int;
    }> {
    CONSTRUCTOR_ID: 2395931921;
    SUBCLASS_OF_ID: 4019263931;
    classType: "constructor";
    className: "messages.BotPreparedInlineMessage";
    static fromReader(reader: Reader): BotPreparedInlineMessage;
      id: string;
      expireDate: int;
    }
    export class PreparedInlineMessage extends VirtualClass<{
      queryId: long;
      result: Api.TypeBotInlineResult;
      peerTypes: Api.TypeInlineQueryPeerType[];
      cacheTime: int;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4283920525;
    SUBCLASS_OF_ID: 1225645901;
    classType: "constructor";
    className: "messages.PreparedInlineMessage";
    static fromReader(reader: Reader): PreparedInlineMessage;
      queryId: long;
      result: Api.TypeBotInlineResult;
      peerTypes: Api.TypeInlineQueryPeerType[];
      cacheTime: int;
      users: Api.TypeUser[];
    }
    export class FoundStickersNotModified extends VirtualClass<{
      // flags: null;
      nextOffset?: int;
    }> {
    CONSTRUCTOR_ID: 1611711796;
    SUBCLASS_OF_ID: 104866129;
    classType: "constructor";
    className: "messages.FoundStickersNotModified";
    static fromReader(reader: Reader): FoundStickersNotModified;
      // flags: null;
      nextOffset?: int;
    }
    export class FoundStickers extends VirtualClass<{
      // flags: null;
      nextOffset?: int;
      hash: long;
      stickers: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 2194268816;
    SUBCLASS_OF_ID: 104866129;
    classType: "constructor";
    className: "messages.FoundStickers";
    static fromReader(reader: Reader): FoundStickers;
      // flags: null;
      nextOffset?: int;
      hash: long;
      stickers: Api.TypeDocument[];
    }
    export class WebPagePreview extends VirtualClass<{
      media: Api.TypeMessageMedia;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3040774945;
    SUBCLASS_OF_ID: 3801354434;
    classType: "constructor";
    className: "messages.WebPagePreview";
    static fromReader(reader: Reader): WebPagePreview;
      media: Api.TypeMessageMedia;
      users: Api.TypeUser[];
    }
  }

  export namespace updates {
    export class State extends VirtualClass<{
      pts: int;
      qts: int;
      date: int;
      seq: int;
      unreadCount: int;
    }> {
    CONSTRUCTOR_ID: 2775329342;
    SUBCLASS_OF_ID: 601823745;
    classType: "constructor";
    className: "updates.State";
    static fromReader(reader: Reader): State;
      pts: int;
      qts: int;
      date: int;
      seq: int;
      unreadCount: int;
    }
    export class DifferenceEmpty extends VirtualClass<{
      date: int;
      seq: int;
    }> {
    CONSTRUCTOR_ID: 1567990072;
    SUBCLASS_OF_ID: 541599860;
    classType: "constructor";
    className: "updates.DifferenceEmpty";
    static fromReader(reader: Reader): DifferenceEmpty;
      date: int;
      seq: int;
    }
    export class Difference extends VirtualClass<{
      newMessages: Api.TypeMessage[];
      newEncryptedMessages: Api.TypeEncryptedMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      state: updates.TypeState;
    }> {
    CONSTRUCTOR_ID: 16030880;
    SUBCLASS_OF_ID: 541599860;
    classType: "constructor";
    className: "updates.Difference";
    static fromReader(reader: Reader): Difference;
      newMessages: Api.TypeMessage[];
      newEncryptedMessages: Api.TypeEncryptedMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      state: updates.TypeState;
    }
    export class DifferenceSlice extends VirtualClass<{
      newMessages: Api.TypeMessage[];
      newEncryptedMessages: Api.TypeEncryptedMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      intermediateState: updates.TypeState;
    }> {
    CONSTRUCTOR_ID: 2835028353;
    SUBCLASS_OF_ID: 541599860;
    classType: "constructor";
    className: "updates.DifferenceSlice";
    static fromReader(reader: Reader): DifferenceSlice;
      newMessages: Api.TypeMessage[];
      newEncryptedMessages: Api.TypeEncryptedMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      intermediateState: updates.TypeState;
    }
    export class DifferenceTooLong extends VirtualClass<{
      pts: int;
    }> {
    CONSTRUCTOR_ID: 1258196845;
    SUBCLASS_OF_ID: 541599860;
    classType: "constructor";
    className: "updates.DifferenceTooLong";
    static fromReader(reader: Reader): DifferenceTooLong;
      pts: int;
    }
    export class ChannelDifferenceEmpty extends VirtualClass<{
      // flags: null;
      final?: boolean;
      pts: int;
      timeout?: int;
    }> {
    CONSTRUCTOR_ID: 1041346555;
    SUBCLASS_OF_ID: 696872797;
    classType: "constructor";
    className: "updates.ChannelDifferenceEmpty";
    static fromReader(reader: Reader): ChannelDifferenceEmpty;
      // flags: null;
      final?: boolean;
      pts: int;
      timeout?: int;
    }
    export class ChannelDifferenceTooLong extends VirtualClass<{
      // flags: null;
      final?: boolean;
      timeout?: int;
      dialog: Api.TypeDialog;
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2763835134;
    SUBCLASS_OF_ID: 696872797;
    classType: "constructor";
    className: "updates.ChannelDifferenceTooLong";
    static fromReader(reader: Reader): ChannelDifferenceTooLong;
      // flags: null;
      final?: boolean;
      timeout?: int;
      dialog: Api.TypeDialog;
      messages: Api.TypeMessage[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChannelDifference extends VirtualClass<{
      // flags: null;
      final?: boolean;
      pts: int;
      timeout?: int;
      newMessages: Api.TypeMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 543450958;
    SUBCLASS_OF_ID: 696872797;
    classType: "constructor";
    className: "updates.ChannelDifference";
    static fromReader(reader: Reader): ChannelDifference;
      // flags: null;
      final?: boolean;
      pts: int;
      timeout?: int;
      newMessages: Api.TypeMessage[];
      otherUpdates: Api.TypeUpdate[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
  }

  export namespace photos {
    export class Photos extends VirtualClass<{
      photos: Api.TypePhoto[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2378853029;
    SUBCLASS_OF_ID: 667924839;
    classType: "constructor";
    className: "photos.Photos";
    static fromReader(reader: Reader): Photos;
      photos: Api.TypePhoto[];
      users: Api.TypeUser[];
    }
    export class PhotosSlice extends VirtualClass<{
      count: int;
      photos: Api.TypePhoto[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 352657236;
    SUBCLASS_OF_ID: 667924839;
    classType: "constructor";
    className: "photos.PhotosSlice";
    static fromReader(reader: Reader): PhotosSlice;
      count: int;
      photos: Api.TypePhoto[];
      users: Api.TypeUser[];
    }
    export class Photo extends VirtualClass<{
      photo: Api.TypePhoto;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 539045032;
    SUBCLASS_OF_ID: 3264396580;
    classType: "constructor";
    className: "photos.Photo";
    static fromReader(reader: Reader): Photo;
      photo: Api.TypePhoto;
      users: Api.TypeUser[];
    }
  }

  export namespace upload {
    export class File extends VirtualClass<{
      type: storage.TypeFileType;
      mtime: int;
      bytes: bytes;
    }> {
    CONSTRUCTOR_ID: 157948117;
    SUBCLASS_OF_ID: 1822152488;
    classType: "constructor";
    className: "upload.File";
    static fromReader(reader: Reader): File;
      type: storage.TypeFileType;
      mtime: int;
      bytes: bytes;
    }
    export class FileCdnRedirect extends VirtualClass<{
      dcId: int;
      fileToken: bytes;
      encryptionKey: bytes;
      encryptionIv: bytes;
      fileHashes: Api.TypeFileHash[];
    }> {
    CONSTRUCTOR_ID: 4052539972;
    SUBCLASS_OF_ID: 1822152488;
    classType: "constructor";
    className: "upload.FileCdnRedirect";
    static fromReader(reader: Reader): FileCdnRedirect;
      dcId: int;
      fileToken: bytes;
      encryptionKey: bytes;
      encryptionIv: bytes;
      fileHashes: Api.TypeFileHash[];
    }
    export class WebFile extends VirtualClass<{
      size: int;
      mimeType: string;
      fileType: storage.TypeFileType;
      mtime: int;
      bytes: bytes;
    }> {
    CONSTRUCTOR_ID: 568808380;
    SUBCLASS_OF_ID: 1760657233;
    classType: "constructor";
    className: "upload.WebFile";
    static fromReader(reader: Reader): WebFile;
      size: int;
      mimeType: string;
      fileType: storage.TypeFileType;
      mtime: int;
      bytes: bytes;
    }
    export class CdnFileReuploadNeeded extends VirtualClass<{
      requestToken: bytes;
    }> {
    CONSTRUCTOR_ID: 4004045934;
    SUBCLASS_OF_ID: 4123851048;
    classType: "constructor";
    className: "upload.CdnFileReuploadNeeded";
    static fromReader(reader: Reader): CdnFileReuploadNeeded;
      requestToken: bytes;
    }
    export class CdnFile extends VirtualClass<{
      bytes: bytes;
    }> {
    CONSTRUCTOR_ID: 2845821519;
    SUBCLASS_OF_ID: 4123851048;
    classType: "constructor";
    className: "upload.CdnFile";
    static fromReader(reader: Reader): CdnFile;
      bytes: bytes;
    }
  }

  export namespace help {
    export class AppUpdate extends VirtualClass<{
      // flags: null;
      canNotSkip?: boolean;
      id: int;
      version: string;
      text: string;
      entities: Api.TypeMessageEntity[];
      document?: Api.TypeDocument;
      url?: string;
      sticker?: Api.TypeDocument;
    }> {
    CONSTRUCTOR_ID: 3434860080;
    SUBCLASS_OF_ID: 1486292638;
    classType: "constructor";
    className: "help.AppUpdate";
    static fromReader(reader: Reader): AppUpdate;
      // flags: null;
      canNotSkip?: boolean;
      id: int;
      version: string;
      text: string;
      entities: Api.TypeMessageEntity[];
      document?: Api.TypeDocument;
      url?: string;
      sticker?: Api.TypeDocument;
    }
    export class NoAppUpdate extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3294258486;
    SUBCLASS_OF_ID: 1486292638;
    classType: "constructor";
    className: "help.NoAppUpdate";
    static fromReader(reader: Reader): NoAppUpdate;
}
    export class InviteText extends VirtualClass<{
      message: string;
    }> {
    CONSTRUCTOR_ID: 415997816;
    SUBCLASS_OF_ID: 3480267317;
    classType: "constructor";
    className: "help.InviteText";
    static fromReader(reader: Reader): InviteText;
      message: string;
    }
    export class Support extends VirtualClass<{
      phoneNumber: string;
      user: Api.TypeUser;
    }> {
    CONSTRUCTOR_ID: 398898678;
    SUBCLASS_OF_ID: 1901706475;
    classType: "constructor";
    className: "help.Support";
    static fromReader(reader: Reader): Support;
      phoneNumber: string;
      user: Api.TypeUser;
    }
    export class TermsOfService extends VirtualClass<{
      // flags: null;
      popup?: boolean;
      id: Api.TypeDataJSON;
      text: string;
      entities: Api.TypeMessageEntity[];
      minAgeConfirm?: int;
    }> {
    CONSTRUCTOR_ID: 2013922064;
    SUBCLASS_OF_ID: 552502034;
    classType: "constructor";
    className: "help.TermsOfService";
    static fromReader(reader: Reader): TermsOfService;
      // flags: null;
      popup?: boolean;
      id: Api.TypeDataJSON;
      text: string;
      entities: Api.TypeMessageEntity[];
      minAgeConfirm?: int;
    }
    export class RecentMeUrls extends VirtualClass<{
      urls: Api.TypeRecentMeUrl[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 235081943;
    SUBCLASS_OF_ID: 4067017847;
    classType: "constructor";
    className: "help.RecentMeUrls";
    static fromReader(reader: Reader): RecentMeUrls;
      urls: Api.TypeRecentMeUrl[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class TermsOfServiceUpdateEmpty extends VirtualClass<{
      expires: int;
    }> {
    CONSTRUCTOR_ID: 3811614591;
    SUBCLASS_OF_ID: 691808631;
    classType: "constructor";
    className: "help.TermsOfServiceUpdateEmpty";
    static fromReader(reader: Reader): TermsOfServiceUpdateEmpty;
      expires: int;
    }
    export class TermsOfServiceUpdate extends VirtualClass<{
      expires: int;
      termsOfService: help.TypeTermsOfService;
    }> {
    CONSTRUCTOR_ID: 686618977;
    SUBCLASS_OF_ID: 691808631;
    classType: "constructor";
    className: "help.TermsOfServiceUpdate";
    static fromReader(reader: Reader): TermsOfServiceUpdate;
      expires: int;
      termsOfService: help.TypeTermsOfService;
    }
    export class DeepLinkInfoEmpty extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1722786150;
    SUBCLASS_OF_ID: 2555030584;
    classType: "constructor";
    className: "help.DeepLinkInfoEmpty";
    static fromReader(reader: Reader): DeepLinkInfoEmpty;
}
    export class DeepLinkInfo extends VirtualClass<{
      // flags: null;
      updateApp?: boolean;
      message: string;
      entities?: Api.TypeMessageEntity[];
    }> {
    CONSTRUCTOR_ID: 1783556146;
    SUBCLASS_OF_ID: 2555030584;
    classType: "constructor";
    className: "help.DeepLinkInfo";
    static fromReader(reader: Reader): DeepLinkInfo;
      // flags: null;
      updateApp?: boolean;
      message: string;
      entities?: Api.TypeMessageEntity[];
    }
    export class PassportConfigNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3216634967;
    SUBCLASS_OF_ID: 3328622765;
    classType: "constructor";
    className: "help.PassportConfigNotModified";
    static fromReader(reader: Reader): PassportConfigNotModified;
}
    export class PassportConfig extends VirtualClass<{
      hash: int;
      countriesLangs: Api.TypeDataJSON;
    }> {
    CONSTRUCTOR_ID: 2694370991;
    SUBCLASS_OF_ID: 3328622765;
    classType: "constructor";
    className: "help.PassportConfig";
    static fromReader(reader: Reader): PassportConfig;
      hash: int;
      countriesLangs: Api.TypeDataJSON;
    }
    export class SupportName extends VirtualClass<{
      name: string;
    }> {
    CONSTRUCTOR_ID: 2349199817;
    SUBCLASS_OF_ID: 2135996354;
    classType: "constructor";
    className: "help.SupportName";
    static fromReader(reader: Reader): SupportName;
      name: string;
    }
    export class UserInfoEmpty extends VirtualClass<void> {
    CONSTRUCTOR_ID: 4088278765;
    SUBCLASS_OF_ID: 1548998616;
    classType: "constructor";
    className: "help.UserInfoEmpty";
    static fromReader(reader: Reader): UserInfoEmpty;
}
    export class UserInfo extends VirtualClass<{
      message: string;
      entities: Api.TypeMessageEntity[];
      author: string;
      date: int;
    }> {
    CONSTRUCTOR_ID: 32192344;
    SUBCLASS_OF_ID: 1548998616;
    classType: "constructor";
    className: "help.UserInfo";
    static fromReader(reader: Reader): UserInfo;
      message: string;
      entities: Api.TypeMessageEntity[];
      author: string;
      date: int;
    }
    export class PromoDataEmpty extends VirtualClass<{
      expires: int;
    }> {
    CONSTRUCTOR_ID: 2566302837;
    SUBCLASS_OF_ID: 2639877442;
    classType: "constructor";
    className: "help.PromoDataEmpty";
    static fromReader(reader: Reader): PromoDataEmpty;
      expires: int;
    }
    export class PromoData extends VirtualClass<{
      // flags: null;
      proxy?: boolean;
      expires: int;
      peer: Api.TypePeer;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      psaType?: string;
      psaMessage?: string;
    }> {
    CONSTRUCTOR_ID: 2352576831;
    SUBCLASS_OF_ID: 2639877442;
    classType: "constructor";
    className: "help.PromoData";
    static fromReader(reader: Reader): PromoData;
      // flags: null;
      proxy?: boolean;
      expires: int;
      peer: Api.TypePeer;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      psaType?: string;
      psaMessage?: string;
    }
    export class CountryCode extends VirtualClass<{
      // flags: null;
      countryCode: string;
      prefixes?: string[];
      patterns?: string[];
    }> {
    CONSTRUCTOR_ID: 1107543535;
    SUBCLASS_OF_ID: 1995654757;
    classType: "constructor";
    className: "help.CountryCode";
    static fromReader(reader: Reader): CountryCode;
      // flags: null;
      countryCode: string;
      prefixes?: string[];
      patterns?: string[];
    }
    export class Country extends VirtualClass<{
      // flags: null;
      hidden?: boolean;
      iso2: string;
      defaultName: string;
      name?: string;
      countryCodes: help.TypeCountryCode[];
    }> {
    CONSTRUCTOR_ID: 3280440867;
    SUBCLASS_OF_ID: 2720964136;
    classType: "constructor";
    className: "help.Country";
    static fromReader(reader: Reader): Country;
      // flags: null;
      hidden?: boolean;
      iso2: string;
      defaultName: string;
      name?: string;
      countryCodes: help.TypeCountryCode[];
    }
    export class CountriesListNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2479628082;
    SUBCLASS_OF_ID: 3929144968;
    classType: "constructor";
    className: "help.CountriesListNotModified";
    static fromReader(reader: Reader): CountriesListNotModified;
}
    export class CountriesList extends VirtualClass<{
      countries: help.TypeCountry[];
      hash: int;
    }> {
    CONSTRUCTOR_ID: 2278585758;
    SUBCLASS_OF_ID: 3929144968;
    classType: "constructor";
    className: "help.CountriesList";
    static fromReader(reader: Reader): CountriesList;
      countries: help.TypeCountry[];
      hash: int;
    }
    export class PremiumPromo extends VirtualClass<{
      statusText: string;
      statusEntities: Api.TypeMessageEntity[];
      videoSections: string[];
      videos: Api.TypeDocument[];
      periodOptions: Api.TypePremiumSubscriptionOption[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1395946908;
    SUBCLASS_OF_ID: 3381109560;
    classType: "constructor";
    className: "help.PremiumPromo";
    static fromReader(reader: Reader): PremiumPromo;
      statusText: string;
      statusEntities: Api.TypeMessageEntity[];
      videoSections: string[];
      videos: Api.TypeDocument[];
      periodOptions: Api.TypePremiumSubscriptionOption[];
      users: Api.TypeUser[];
    }
    export class AppConfigNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2094949405;
    SUBCLASS_OF_ID: 339221658;
    classType: "constructor";
    className: "help.AppConfigNotModified";
    static fromReader(reader: Reader): AppConfigNotModified;
}
    export class AppConfig extends VirtualClass<{
      hash: int;
      config: Api.TypeJSONValue;
    }> {
    CONSTRUCTOR_ID: 3709368366;
    SUBCLASS_OF_ID: 339221658;
    classType: "constructor";
    className: "help.AppConfig";
    static fromReader(reader: Reader): AppConfig;
      hash: int;
      config: Api.TypeJSONValue;
    }
    export class PeerColorSet extends VirtualClass<{
      colors: int[];
    }> {
    CONSTRUCTOR_ID: 639736408;
    SUBCLASS_OF_ID: 298574124;
    classType: "constructor";
    className: "help.PeerColorSet";
    static fromReader(reader: Reader): PeerColorSet;
      colors: int[];
    }
    export class PeerColorProfileSet extends VirtualClass<{
      paletteColors: int[];
      bgColors: int[];
      storyColors: int[];
    }> {
    CONSTRUCTOR_ID: 1987928555;
    SUBCLASS_OF_ID: 298574124;
    classType: "constructor";
    className: "help.PeerColorProfileSet";
    static fromReader(reader: Reader): PeerColorProfileSet;
      paletteColors: int[];
      bgColors: int[];
      storyColors: int[];
    }
    export class PeerColorOption extends VirtualClass<{
      // flags: null;
      hidden?: boolean;
      colorId: int;
      colors?: help.TypePeerColorSet;
      darkColors?: help.TypePeerColorSet;
      channelMinLevel?: int;
      groupMinLevel?: int;
    }> {
    CONSTRUCTOR_ID: 2917953214;
    SUBCLASS_OF_ID: 1454943896;
    classType: "constructor";
    className: "help.PeerColorOption";
    static fromReader(reader: Reader): PeerColorOption;
      // flags: null;
      hidden?: boolean;
      colorId: int;
      colors?: help.TypePeerColorSet;
      darkColors?: help.TypePeerColorSet;
      channelMinLevel?: int;
      groupMinLevel?: int;
    }
    export class PeerColorsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 732034510;
    SUBCLASS_OF_ID: 239036211;
    classType: "constructor";
    className: "help.PeerColorsNotModified";
    static fromReader(reader: Reader): PeerColorsNotModified;
}
    export class PeerColors extends VirtualClass<{
      hash: int;
      colors: help.TypePeerColorOption[];
    }> {
    CONSTRUCTOR_ID: 16313608;
    SUBCLASS_OF_ID: 239036211;
    classType: "constructor";
    className: "help.PeerColors";
    static fromReader(reader: Reader): PeerColors;
      hash: int;
      colors: help.TypePeerColorOption[];
    }
    export class TimezonesListNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2533820620;
    SUBCLASS_OF_ID: 3396789365;
    classType: "constructor";
    className: "help.TimezonesListNotModified";
    static fromReader(reader: Reader): TimezonesListNotModified;
}
    export class TimezonesList extends VirtualClass<{
      timezones: Api.TypeTimezone[];
      hash: int;
    }> {
    CONSTRUCTOR_ID: 2071260529;
    SUBCLASS_OF_ID: 3396789365;
    classType: "constructor";
    className: "help.TimezonesList";
    static fromReader(reader: Reader): TimezonesList;
      timezones: Api.TypeTimezone[];
      hash: int;
    }
    export class ConfigSimple extends VirtualClass<{
      date: int;
      expires: int;
      rules: Api.TypeAccessPointRule[];
    }> {
    CONSTRUCTOR_ID: 1515793004;
    SUBCLASS_OF_ID: 689453764;
    classType: "constructor";
    className: "help.ConfigSimple";
    static fromReader(reader: Reader): ConfigSimple;
      date: int;
      expires: int;
      rules: Api.TypeAccessPointRule[];
    }
  }

  export namespace account {
    export class PrivacyRules extends VirtualClass<{
      rules: Api.TypePrivacyRule[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1352683077;
    SUBCLASS_OF_ID: 3042622082;
    classType: "constructor";
    className: "account.PrivacyRules";
    static fromReader(reader: Reader): PrivacyRules;
      rules: Api.TypePrivacyRule[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class Authorizations extends VirtualClass<{
      authorizationTtlDays: int;
      authorizations: Api.TypeAuthorization[];
    }> {
    CONSTRUCTOR_ID: 1275039392;
    SUBCLASS_OF_ID: 200663295;
    classType: "constructor";
    className: "account.Authorizations";
    static fromReader(reader: Reader): Authorizations;
      authorizationTtlDays: int;
      authorizations: Api.TypeAuthorization[];
    }
    export class Password extends VirtualClass<{
      // flags: null;
      hasRecovery?: boolean;
      hasSecureValues?: boolean;
      hasPassword?: boolean;
      currentAlgo?: Api.TypePasswordKdfAlgo;
      srp_B?: bytes;
      srpId?: long;
      hint?: string;
      emailUnconfirmedPattern?: string;
      newAlgo: Api.TypePasswordKdfAlgo;
      newSecureAlgo: Api.TypeSecurePasswordKdfAlgo;
      secureRandom: bytes;
      pendingResetDate?: int;
      loginEmailPattern?: string;
    }> {
    CONSTRUCTOR_ID: 2507886843;
    SUBCLASS_OF_ID: 1403130275;
    classType: "constructor";
    className: "account.Password";
    static fromReader(reader: Reader): Password;
      // flags: null;
      hasRecovery?: boolean;
      hasSecureValues?: boolean;
      hasPassword?: boolean;
      currentAlgo?: Api.TypePasswordKdfAlgo;
      srp_B?: bytes;
      srpId?: long;
      hint?: string;
      emailUnconfirmedPattern?: string;
      newAlgo: Api.TypePasswordKdfAlgo;
      newSecureAlgo: Api.TypeSecurePasswordKdfAlgo;
      secureRandom: bytes;
      pendingResetDate?: int;
      loginEmailPattern?: string;
    }
    export class PasswordSettings extends VirtualClass<{
      // flags: null;
      email?: string;
      secureSettings?: Api.TypeSecureSecretSettings;
    }> {
    CONSTRUCTOR_ID: 2589733861;
    SUBCLASS_OF_ID: 3527389304;
    classType: "constructor";
    className: "account.PasswordSettings";
    static fromReader(reader: Reader): PasswordSettings;
      // flags: null;
      email?: string;
      secureSettings?: Api.TypeSecureSecretSettings;
    }
    export class PasswordInputSettings extends VirtualClass<{
      // flags: null;
      newAlgo?: Api.TypePasswordKdfAlgo;
      newPasswordHash?: bytes;
      hint?: string;
      email?: string;
      newSecureSettings?: Api.TypeSecureSecretSettings;
    }> {
    CONSTRUCTOR_ID: 3258394569;
    SUBCLASS_OF_ID: 205679782;
    classType: "constructor";
    className: "account.PasswordInputSettings";
    static fromReader(reader: Reader): PasswordInputSettings;
      // flags: null;
      newAlgo?: Api.TypePasswordKdfAlgo;
      newPasswordHash?: bytes;
      hint?: string;
      email?: string;
      newSecureSettings?: Api.TypeSecureSecretSettings;
    }
    export class TmpPassword extends VirtualClass<{
      tmpPassword: bytes;
      validUntil: int;
    }> {
    CONSTRUCTOR_ID: 3680828724;
    SUBCLASS_OF_ID: 2959382829;
    classType: "constructor";
    className: "account.TmpPassword";
    static fromReader(reader: Reader): TmpPassword;
      tmpPassword: bytes;
      validUntil: int;
    }
    export class WebAuthorizations extends VirtualClass<{
      authorizations: Api.TypeWebAuthorization[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3981887996;
    SUBCLASS_OF_ID: 2587253554;
    classType: "constructor";
    className: "account.WebAuthorizations";
    static fromReader(reader: Reader): WebAuthorizations;
      authorizations: Api.TypeWebAuthorization[];
      users: Api.TypeUser[];
    }
    export class AuthorizationForm extends VirtualClass<{
      // flags: null;
      requiredTypes: Api.TypeSecureRequiredType[];
      values: Api.TypeSecureValue[];
      errors: Api.TypeSecureValueError[];
      users: Api.TypeUser[];
      privacyPolicyUrl?: string;
    }> {
    CONSTRUCTOR_ID: 2905480408;
    SUBCLASS_OF_ID: 2013567636;
    classType: "constructor";
    className: "account.AuthorizationForm";
    static fromReader(reader: Reader): AuthorizationForm;
      // flags: null;
      requiredTypes: Api.TypeSecureRequiredType[];
      values: Api.TypeSecureValue[];
      errors: Api.TypeSecureValueError[];
      users: Api.TypeUser[];
      privacyPolicyUrl?: string;
    }
    export class SentEmailCode extends VirtualClass<{
      emailPattern: string;
      length: int;
    }> {
    CONSTRUCTOR_ID: 2166326607;
    SUBCLASS_OF_ID: 1777582190;
    classType: "constructor";
    className: "account.SentEmailCode";
    static fromReader(reader: Reader): SentEmailCode;
      emailPattern: string;
      length: int;
    }
    export class Takeout extends VirtualClass<{
      id: long;
    }> {
    CONSTRUCTOR_ID: 1304052993;
    SUBCLASS_OF_ID: 2218704517;
    classType: "constructor";
    className: "account.Takeout";
    static fromReader(reader: Reader): Takeout;
      id: long;
    }
    export class WallPapersNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 471437699;
    SUBCLASS_OF_ID: 2730838269;
    classType: "constructor";
    className: "account.WallPapersNotModified";
    static fromReader(reader: Reader): WallPapersNotModified;
}
    export class WallPapers extends VirtualClass<{
      hash: long;
      wallpapers: Api.TypeWallPaper[];
    }> {
    CONSTRUCTOR_ID: 3452142988;
    SUBCLASS_OF_ID: 2730838269;
    classType: "constructor";
    className: "account.WallPapers";
    static fromReader(reader: Reader): WallPapers;
      hash: long;
      wallpapers: Api.TypeWallPaper[];
    }
    export class AutoDownloadSettings extends VirtualClass<{
      low: Api.TypeAutoDownloadSettings;
      medium: Api.TypeAutoDownloadSettings;
      high: Api.TypeAutoDownloadSettings;
    }> {
    CONSTRUCTOR_ID: 1674235686;
    SUBCLASS_OF_ID: 800610593;
    classType: "constructor";
    className: "account.AutoDownloadSettings";
    static fromReader(reader: Reader): AutoDownloadSettings;
      low: Api.TypeAutoDownloadSettings;
      medium: Api.TypeAutoDownloadSettings;
      high: Api.TypeAutoDownloadSettings;
    }
    export class ThemesNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 4095653410;
    SUBCLASS_OF_ID: 2143625732;
    classType: "constructor";
    className: "account.ThemesNotModified";
    static fromReader(reader: Reader): ThemesNotModified;
}
    export class Themes extends VirtualClass<{
      hash: long;
      themes: Api.TypeTheme[];
    }> {
    CONSTRUCTOR_ID: 2587724909;
    SUBCLASS_OF_ID: 2143625732;
    classType: "constructor";
    className: "account.Themes";
    static fromReader(reader: Reader): Themes;
      hash: long;
      themes: Api.TypeTheme[];
    }
    export class ContentSettings extends VirtualClass<{
      // flags: null;
      sensitiveEnabled?: boolean;
      sensitiveCanChange?: boolean;
    }> {
    CONSTRUCTOR_ID: 1474462241;
    SUBCLASS_OF_ID: 2923427985;
    classType: "constructor";
    className: "account.ContentSettings";
    static fromReader(reader: Reader): ContentSettings;
      // flags: null;
      sensitiveEnabled?: boolean;
      sensitiveCanChange?: boolean;
    }
    export class ResetPasswordFailedWait extends VirtualClass<{
      retryDate: int;
    }> {
    CONSTRUCTOR_ID: 3816265825;
    SUBCLASS_OF_ID: 1230009366;
    classType: "constructor";
    className: "account.ResetPasswordFailedWait";
    static fromReader(reader: Reader): ResetPasswordFailedWait;
      retryDate: int;
    }
    export class ResetPasswordRequestedWait extends VirtualClass<{
      untilDate: int;
    }> {
    CONSTRUCTOR_ID: 3924819069;
    SUBCLASS_OF_ID: 1230009366;
    classType: "constructor";
    className: "account.ResetPasswordRequestedWait";
    static fromReader(reader: Reader): ResetPasswordRequestedWait;
      untilDate: int;
    }
    export class ResetPasswordOk extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3911636542;
    SUBCLASS_OF_ID: 1230009366;
    classType: "constructor";
    className: "account.ResetPasswordOk";
    static fromReader(reader: Reader): ResetPasswordOk;
}
    export class SavedRingtonesNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 4227262641;
    SUBCLASS_OF_ID: 666683742;
    classType: "constructor";
    className: "account.SavedRingtonesNotModified";
    static fromReader(reader: Reader): SavedRingtonesNotModified;
}
    export class SavedRingtones extends VirtualClass<{
      hash: long;
      ringtones: Api.TypeDocument[];
    }> {
    CONSTRUCTOR_ID: 3253284037;
    SUBCLASS_OF_ID: 666683742;
    classType: "constructor";
    className: "account.SavedRingtones";
    static fromReader(reader: Reader): SavedRingtones;
      hash: long;
      ringtones: Api.TypeDocument[];
    }
    export class SavedRingtone extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3072737133;
    SUBCLASS_OF_ID: 2984412196;
    classType: "constructor";
    className: "account.SavedRingtone";
    static fromReader(reader: Reader): SavedRingtone;
}
    export class SavedRingtoneConverted extends VirtualClass<{
      document: Api.TypeDocument;
    }> {
    CONSTRUCTOR_ID: 523271863;
    SUBCLASS_OF_ID: 2984412196;
    classType: "constructor";
    className: "account.SavedRingtoneConverted";
    static fromReader(reader: Reader): SavedRingtoneConverted;
      document: Api.TypeDocument;
    }
    export class EmojiStatusesNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 3498894917;
    SUBCLASS_OF_ID: 3554674122;
    classType: "constructor";
    className: "account.EmojiStatusesNotModified";
    static fromReader(reader: Reader): EmojiStatusesNotModified;
}
    export class EmojiStatuses extends VirtualClass<{
      hash: long;
      statuses: Api.TypeEmojiStatus[];
    }> {
    CONSTRUCTOR_ID: 2428790737;
    SUBCLASS_OF_ID: 3554674122;
    classType: "constructor";
    className: "account.EmojiStatuses";
    static fromReader(reader: Reader): EmojiStatuses;
      hash: long;
      statuses: Api.TypeEmojiStatus[];
    }
    export class EmailVerified extends VirtualClass<{
      email: string;
    }> {
    CONSTRUCTOR_ID: 731303195;
    SUBCLASS_OF_ID: 1686319496;
    classType: "constructor";
    className: "account.EmailVerified";
    static fromReader(reader: Reader): EmailVerified;
      email: string;
    }
    export class EmailVerifiedLogin extends VirtualClass<{
      email: string;
      sentCode: auth.TypeSentCode;
    }> {
    CONSTRUCTOR_ID: 3787132257;
    SUBCLASS_OF_ID: 1686319496;
    classType: "constructor";
    className: "account.EmailVerifiedLogin";
    static fromReader(reader: Reader): EmailVerifiedLogin;
      email: string;
      sentCode: auth.TypeSentCode;
    }
    export class AutoSaveSettings extends VirtualClass<{
      usersSettings: Api.TypeAutoSaveSettings;
      chatsSettings: Api.TypeAutoSaveSettings;
      broadcastsSettings: Api.TypeAutoSaveSettings;
      exceptions: Api.TypeAutoSaveException[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1279133341;
    SUBCLASS_OF_ID: 1221537538;
    classType: "constructor";
    className: "account.AutoSaveSettings";
    static fromReader(reader: Reader): AutoSaveSettings;
      usersSettings: Api.TypeAutoSaveSettings;
      chatsSettings: Api.TypeAutoSaveSettings;
      broadcastsSettings: Api.TypeAutoSaveSettings;
      exceptions: Api.TypeAutoSaveException[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ConnectedBots extends VirtualClass<{
      connectedBots: Api.TypeConnectedBot[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 400029819;
    SUBCLASS_OF_ID: 3838506963;
    classType: "constructor";
    className: "account.ConnectedBots";
    static fromReader(reader: Reader): ConnectedBots;
      connectedBots: Api.TypeConnectedBot[];
      users: Api.TypeUser[];
    }
    export class BusinessChatLinks extends VirtualClass<{
      links: Api.TypeBusinessChatLink[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3963855569;
    SUBCLASS_OF_ID: 3334097457;
    classType: "constructor";
    className: "account.BusinessChatLinks";
    static fromReader(reader: Reader): BusinessChatLinks;
      links: Api.TypeBusinessChatLink[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ResolvedBusinessChatLinks extends VirtualClass<{
      // flags: null;
      peer: Api.TypePeer;
      message: string;
      entities?: Api.TypeMessageEntity[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2586029857;
    SUBCLASS_OF_ID: 980888616;
    classType: "constructor";
    className: "account.ResolvedBusinessChatLinks";
    static fromReader(reader: Reader): ResolvedBusinessChatLinks;
      // flags: null;
      peer: Api.TypePeer;
      message: string;
      entities?: Api.TypeMessageEntity[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
  }

  export namespace channels {
    export class ChannelParticipants extends VirtualClass<{
      count: int;
      participants: Api.TypeChannelParticipant[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2595290799;
    SUBCLASS_OF_ID: 3859443300;
    classType: "constructor";
    className: "channels.ChannelParticipants";
    static fromReader(reader: Reader): ChannelParticipants;
      count: int;
      participants: Api.TypeChannelParticipant[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChannelParticipantsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 4028055529;
    SUBCLASS_OF_ID: 3859443300;
    classType: "constructor";
    className: "channels.ChannelParticipantsNotModified";
    static fromReader(reader: Reader): ChannelParticipantsNotModified;
}
    export class ChannelParticipant extends VirtualClass<{
      participant: Api.TypeChannelParticipant;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3753378583;
    SUBCLASS_OF_ID: 1717048602;
    classType: "constructor";
    className: "channels.ChannelParticipant";
    static fromReader(reader: Reader): ChannelParticipant;
      participant: Api.TypeChannelParticipant;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class AdminLogResults extends VirtualClass<{
      events: Api.TypeChannelAdminLogEvent[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3985307469;
    SUBCLASS_OF_ID: 1374713532;
    classType: "constructor";
    className: "channels.AdminLogResults";
    static fromReader(reader: Reader): AdminLogResults;
      events: Api.TypeChannelAdminLogEvent[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SendAsPeers extends VirtualClass<{
      peers: Api.TypeSendAsPeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4103516358;
    SUBCLASS_OF_ID: 952864033;
    classType: "constructor";
    className: "channels.SendAsPeers";
    static fromReader(reader: Reader): SendAsPeers;
      peers: Api.TypeSendAsPeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class SponsoredMessageReportResultChooseOption extends VirtualClass<{
      title: string;
      options: Api.TypeSponsoredMessageReportOption[];
    }> {
    CONSTRUCTOR_ID: 2221907522;
    SUBCLASS_OF_ID: 639834146;
    classType: "constructor";
    className: "channels.SponsoredMessageReportResultChooseOption";
    static fromReader(reader: Reader): SponsoredMessageReportResultChooseOption;
      title: string;
      options: Api.TypeSponsoredMessageReportOption[];
    }
    export class SponsoredMessageReportResultAdsHidden extends VirtualClass<void> {
    CONSTRUCTOR_ID: 1044107055;
    SUBCLASS_OF_ID: 639834146;
    classType: "constructor";
    className: "channels.SponsoredMessageReportResultAdsHidden";
    static fromReader(reader: Reader): SponsoredMessageReportResultAdsHidden;
}
    export class SponsoredMessageReportResultReported extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2910423113;
    SUBCLASS_OF_ID: 639834146;
    classType: "constructor";
    className: "channels.SponsoredMessageReportResultReported";
    static fromReader(reader: Reader): SponsoredMessageReportResultReported;
}
  }

  export namespace payments {
    export class PaymentForm extends VirtualClass<{
      // flags: null;
      canSaveCredentials?: boolean;
      passwordMissing?: boolean;
      formId: long;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      providerId: long;
      url: string;
      nativeProvider?: string;
      nativeParams?: Api.TypeDataJSON;
      additionalMethods?: Api.TypePaymentFormMethod[];
      savedInfo?: Api.TypePaymentRequestedInfo;
      savedCredentials?: Api.TypePaymentSavedCredentials[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2684716881;
    SUBCLASS_OF_ID: 2689089305;
    classType: "constructor";
    className: "payments.PaymentForm";
    static fromReader(reader: Reader): PaymentForm;
      // flags: null;
      canSaveCredentials?: boolean;
      passwordMissing?: boolean;
      formId: long;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      providerId: long;
      url: string;
      nativeProvider?: string;
      nativeParams?: Api.TypeDataJSON;
      additionalMethods?: Api.TypePaymentFormMethod[];
      savedInfo?: Api.TypePaymentRequestedInfo;
      savedCredentials?: Api.TypePaymentSavedCredentials[];
      users: Api.TypeUser[];
    }
    export class PaymentFormStars extends VirtualClass<{
      // flags: null;
      formId: long;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2079764828;
    SUBCLASS_OF_ID: 2689089305;
    classType: "constructor";
    className: "payments.PaymentFormStars";
    static fromReader(reader: Reader): PaymentFormStars;
      // flags: null;
      formId: long;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      users: Api.TypeUser[];
    }
    export class PaymentFormStarGift extends VirtualClass<{
      formId: long;
      invoice: Api.TypeInvoice;
    }> {
    CONSTRUCTOR_ID: 3022376929;
    SUBCLASS_OF_ID: 2689089305;
    classType: "constructor";
    className: "payments.PaymentFormStarGift";
    static fromReader(reader: Reader): PaymentFormStarGift;
      formId: long;
      invoice: Api.TypeInvoice;
    }
    export class ValidatedRequestedInfo extends VirtualClass<{
      // flags: null;
      id?: string;
      shippingOptions?: Api.TypeShippingOption[];
    }> {
    CONSTRUCTOR_ID: 3510966403;
    SUBCLASS_OF_ID: 2407548087;
    classType: "constructor";
    className: "payments.ValidatedRequestedInfo";
    static fromReader(reader: Reader): ValidatedRequestedInfo;
      // flags: null;
      id?: string;
      shippingOptions?: Api.TypeShippingOption[];
    }
    export class PaymentResult extends VirtualClass<{
      updates: Api.TypeUpdates;
    }> {
    CONSTRUCTOR_ID: 1314881805;
    SUBCLASS_OF_ID: 2330028701;
    classType: "constructor";
    className: "payments.PaymentResult";
    static fromReader(reader: Reader): PaymentResult;
      updates: Api.TypeUpdates;
    }
    export class PaymentVerificationNeeded extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 3628142905;
    SUBCLASS_OF_ID: 2330028701;
    classType: "constructor";
    className: "payments.PaymentVerificationNeeded";
    static fromReader(reader: Reader): PaymentVerificationNeeded;
      url: string;
    }
    export class PaymentReceipt extends VirtualClass<{
      // flags: null;
      date: int;
      botId: long;
      providerId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      info?: Api.TypePaymentRequestedInfo;
      shipping?: Api.TypeShippingOption;
      tipAmount?: long;
      currency: string;
      totalAmount: long;
      credentialsTitle: string;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1891958275;
    SUBCLASS_OF_ID: 1493210057;
    classType: "constructor";
    className: "payments.PaymentReceipt";
    static fromReader(reader: Reader): PaymentReceipt;
      // flags: null;
      date: int;
      botId: long;
      providerId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      info?: Api.TypePaymentRequestedInfo;
      shipping?: Api.TypeShippingOption;
      tipAmount?: long;
      currency: string;
      totalAmount: long;
      credentialsTitle: string;
      users: Api.TypeUser[];
    }
    export class PaymentReceiptStars extends VirtualClass<{
      // flags: null;
      date: int;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      currency: string;
      totalAmount: long;
      transactionId: string;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3669751866;
    SUBCLASS_OF_ID: 1493210057;
    classType: "constructor";
    className: "payments.PaymentReceiptStars";
    static fromReader(reader: Reader): PaymentReceiptStars;
      // flags: null;
      date: int;
      botId: long;
      title: string;
      description: string;
      photo?: Api.TypeWebDocument;
      invoice: Api.TypeInvoice;
      currency: string;
      totalAmount: long;
      transactionId: string;
      users: Api.TypeUser[];
    }
    export class SavedInfo extends VirtualClass<{
      // flags: null;
      hasSavedCredentials?: boolean;
      savedInfo?: Api.TypePaymentRequestedInfo;
    }> {
    CONSTRUCTOR_ID: 4220511292;
    SUBCLASS_OF_ID: 2906452294;
    classType: "constructor";
    className: "payments.SavedInfo";
    static fromReader(reader: Reader): SavedInfo;
      // flags: null;
      hasSavedCredentials?: boolean;
      savedInfo?: Api.TypePaymentRequestedInfo;
    }
    export class BankCardData extends VirtualClass<{
      title: string;
      openUrls: Api.TypeBankCardOpenUrl[];
    }> {
    CONSTRUCTOR_ID: 1042605427;
    SUBCLASS_OF_ID: 2356008587;
    classType: "constructor";
    className: "payments.BankCardData";
    static fromReader(reader: Reader): BankCardData;
      title: string;
      openUrls: Api.TypeBankCardOpenUrl[];
    }
    export class ExportedInvoice extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 2932919257;
    SUBCLASS_OF_ID: 907039794;
    classType: "constructor";
    className: "payments.ExportedInvoice";
    static fromReader(reader: Reader): ExportedInvoice;
      url: string;
    }
    export class CheckedGiftCode extends VirtualClass<{
      // flags: null;
      viaGiveaway?: boolean;
      fromId?: Api.TypePeer;
      giveawayMsgId?: int;
      toId?: long;
      date: int;
      months: int;
      usedDate?: int;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 675942550;
    SUBCLASS_OF_ID: 1529452520;
    classType: "constructor";
    className: "payments.CheckedGiftCode";
    static fromReader(reader: Reader): CheckedGiftCode;
      // flags: null;
      viaGiveaway?: boolean;
      fromId?: Api.TypePeer;
      giveawayMsgId?: int;
      toId?: long;
      date: int;
      months: int;
      usedDate?: int;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class GiveawayInfo extends VirtualClass<{
      // flags: null;
      participating?: boolean;
      preparingResults?: boolean;
      startDate: int;
      joinedTooEarlyDate?: int;
      adminDisallowedChatId?: long;
      disallowedCountry?: string;
    }> {
    CONSTRUCTOR_ID: 1130879648;
    SUBCLASS_OF_ID: 2527295421;
    classType: "constructor";
    className: "payments.GiveawayInfo";
    static fromReader(reader: Reader): GiveawayInfo;
      // flags: null;
      participating?: boolean;
      preparingResults?: boolean;
      startDate: int;
      joinedTooEarlyDate?: int;
      adminDisallowedChatId?: long;
      disallowedCountry?: string;
    }
    export class GiveawayInfoResults extends VirtualClass<{
      // flags: null;
      winner?: boolean;
      refunded?: boolean;
      startDate: int;
      giftCodeSlug?: string;
      starsPrize?: long;
      finishDate: int;
      winnersCount: int;
      activatedCount?: int;
    }> {
    CONSTRUCTOR_ID: 3782600303;
    SUBCLASS_OF_ID: 2527295421;
    classType: "constructor";
    className: "payments.GiveawayInfoResults";
    static fromReader(reader: Reader): GiveawayInfoResults;
      // flags: null;
      winner?: boolean;
      refunded?: boolean;
      startDate: int;
      giftCodeSlug?: string;
      starsPrize?: long;
      finishDate: int;
      winnersCount: int;
      activatedCount?: int;
    }
    export class StarsStatus extends VirtualClass<{
      // flags: null;
      balance: Api.TypeStarsAmount;
      subscriptions?: Api.TypeStarsSubscription[];
      subscriptionsNextOffset?: string;
      subscriptionsMissingBalance?: long;
      history?: Api.TypeStarsTransaction[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1822222573;
    SUBCLASS_OF_ID: 1855724911;
    classType: "constructor";
    className: "payments.StarsStatus";
    static fromReader(reader: Reader): StarsStatus;
      // flags: null;
      balance: Api.TypeStarsAmount;
      subscriptions?: Api.TypeStarsSubscription[];
      subscriptionsNextOffset?: string;
      subscriptionsMissingBalance?: long;
      history?: Api.TypeStarsTransaction[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class StarsRevenueStats extends VirtualClass<{
      revenueGraph: Api.TypeStatsGraph;
      status: Api.TypeStarsRevenueStatus;
      usdRate: double;
    }> {
    CONSTRUCTOR_ID: 3375085371;
    SUBCLASS_OF_ID: 2772915699;
    classType: "constructor";
    className: "payments.StarsRevenueStats";
    static fromReader(reader: Reader): StarsRevenueStats;
      revenueGraph: Api.TypeStatsGraph;
      status: Api.TypeStarsRevenueStatus;
      usdRate: double;
    }
    export class StarsRevenueWithdrawalUrl extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 497778871;
    SUBCLASS_OF_ID: 2221318382;
    classType: "constructor";
    className: "payments.StarsRevenueWithdrawalUrl";
    static fromReader(reader: Reader): StarsRevenueWithdrawalUrl;
      url: string;
    }
    export class StarsRevenueAdsAccountUrl extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 961445665;
    SUBCLASS_OF_ID: 1243777813;
    classType: "constructor";
    className: "payments.StarsRevenueAdsAccountUrl";
    static fromReader(reader: Reader): StarsRevenueAdsAccountUrl;
      url: string;
    }
    export class StarGiftsNotModified extends VirtualClass<void> {
    CONSTRUCTOR_ID: 2743640936;
    SUBCLASS_OF_ID: 1635309988;
    classType: "constructor";
    className: "payments.StarGiftsNotModified";
    static fromReader(reader: Reader): StarGiftsNotModified;
}
    export class StarGifts extends VirtualClass<{
      hash: int;
      gifts: Api.TypeStarGift[];
    }> {
    CONSTRUCTOR_ID: 2417396202;
    SUBCLASS_OF_ID: 1635309988;
    classType: "constructor";
    className: "payments.StarGifts";
    static fromReader(reader: Reader): StarGifts;
      hash: int;
      gifts: Api.TypeStarGift[];
    }
    export class ConnectedStarRefBots extends VirtualClass<{
      count: int;
      connectedBots: Api.TypeConnectedBotStarRef[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2564155933;
    SUBCLASS_OF_ID: 593369703;
    classType: "constructor";
    className: "payments.ConnectedStarRefBots";
    static fromReader(reader: Reader): ConnectedStarRefBots;
      count: int;
      connectedBots: Api.TypeConnectedBotStarRef[];
      users: Api.TypeUser[];
    }
    export class SuggestedStarRefBots extends VirtualClass<{
      // flags: null;
      count: int;
      suggestedBots: Api.TypeStarRefProgram[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }> {
    CONSTRUCTOR_ID: 3033913433;
    SUBCLASS_OF_ID: 1880658499;
    classType: "constructor";
    className: "payments.SuggestedStarRefBots";
    static fromReader(reader: Reader): SuggestedStarRefBots;
      // flags: null;
      count: int;
      suggestedBots: Api.TypeStarRefProgram[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }
    export class StarGiftUpgradePreview extends VirtualClass<{
      sampleAttributes: Api.TypeStarGiftAttribute[];
    }> {
    CONSTRUCTOR_ID: 377215243;
    SUBCLASS_OF_ID: 1579903175;
    classType: "constructor";
    className: "payments.StarGiftUpgradePreview";
    static fromReader(reader: Reader): StarGiftUpgradePreview;
      sampleAttributes: Api.TypeStarGiftAttribute[];
    }
    export class UniqueStarGift extends VirtualClass<{
      gift: Api.TypeStarGift;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3399677451;
    SUBCLASS_OF_ID: 2024850939;
    classType: "constructor";
    className: "payments.UniqueStarGift";
    static fromReader(reader: Reader): UniqueStarGift;
      gift: Api.TypeStarGift;
      users: Api.TypeUser[];
    }
    export class SavedStarGifts extends VirtualClass<{
      // flags: null;
      count: int;
      chatNotificationsEnabled?: Bool;
      gifts: Api.TypeSavedStarGift[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2515765681;
    SUBCLASS_OF_ID: 3574671511;
    classType: "constructor";
    className: "payments.SavedStarGifts";
    static fromReader(reader: Reader): SavedStarGifts;
      // flags: null;
      count: int;
      chatNotificationsEnabled?: Bool;
      gifts: Api.TypeSavedStarGift[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class StarGiftWithdrawalUrl extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 2225748636;
    SUBCLASS_OF_ID: 2726440389;
    classType: "constructor";
    className: "payments.StarGiftWithdrawalUrl";
    static fromReader(reader: Reader): StarGiftWithdrawalUrl;
      url: string;
    }
  }

  export namespace phone {
    export class PhoneCall extends VirtualClass<{
      phoneCall: Api.TypePhoneCall;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3968000320;
    SUBCLASS_OF_ID: 3565878863;
    classType: "constructor";
    className: "phone.PhoneCall";
    static fromReader(reader: Reader): PhoneCall;
      phoneCall: Api.TypePhoneCall;
      users: Api.TypeUser[];
    }
    export class GroupCall extends VirtualClass<{
      call: Api.TypeGroupCall;
      participants: Api.TypeGroupCallParticipant[];
      participantsNextOffset: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2658302637;
    SUBCLASS_OF_ID: 809572030;
    classType: "constructor";
    className: "phone.GroupCall";
    static fromReader(reader: Reader): GroupCall;
      call: Api.TypeGroupCall;
      participants: Api.TypeGroupCallParticipant[];
      participantsNextOffset: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class GroupParticipants extends VirtualClass<{
      count: int;
      participants: Api.TypeGroupCallParticipant[];
      nextOffset: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      version: int;
    }> {
    CONSTRUCTOR_ID: 4101460406;
    SUBCLASS_OF_ID: 1926431988;
    classType: "constructor";
    className: "phone.GroupParticipants";
    static fromReader(reader: Reader): GroupParticipants;
      count: int;
      participants: Api.TypeGroupCallParticipant[];
      nextOffset: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      version: int;
    }
    export class JoinAsPeers extends VirtualClass<{
      peers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2951045695;
    SUBCLASS_OF_ID: 3031920891;
    classType: "constructor";
    className: "phone.JoinAsPeers";
    static fromReader(reader: Reader): JoinAsPeers;
      peers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ExportedGroupCallInvite extends VirtualClass<{
      link: string;
    }> {
    CONSTRUCTOR_ID: 541839704;
    SUBCLASS_OF_ID: 993787535;
    classType: "constructor";
    className: "phone.ExportedGroupCallInvite";
    static fromReader(reader: Reader): ExportedGroupCallInvite;
      link: string;
    }
    export class GroupCallStreamChannels extends VirtualClass<{
      channels: Api.TypeGroupCallStreamChannel[];
    }> {
    CONSTRUCTOR_ID: 3504636594;
    SUBCLASS_OF_ID: 2438448612;
    classType: "constructor";
    className: "phone.GroupCallStreamChannels";
    static fromReader(reader: Reader): GroupCallStreamChannels;
      channels: Api.TypeGroupCallStreamChannel[];
    }
    export class GroupCallStreamRtmpUrl extends VirtualClass<{
      url: string;
      key: string;
    }> {
    CONSTRUCTOR_ID: 767505458;
    SUBCLASS_OF_ID: 3522500043;
    classType: "constructor";
    className: "phone.GroupCallStreamRtmpUrl";
    static fromReader(reader: Reader): GroupCallStreamRtmpUrl;
      url: string;
      key: string;
    }
  }

  export namespace stats {
    export class BroadcastStats extends VirtualClass<{
      period: Api.TypeStatsDateRangeDays;
      followers: Api.TypeStatsAbsValueAndPrev;
      viewsPerPost: Api.TypeStatsAbsValueAndPrev;
      sharesPerPost: Api.TypeStatsAbsValueAndPrev;
      reactionsPerPost: Api.TypeStatsAbsValueAndPrev;
      viewsPerStory: Api.TypeStatsAbsValueAndPrev;
      sharesPerStory: Api.TypeStatsAbsValueAndPrev;
      reactionsPerStory: Api.TypeStatsAbsValueAndPrev;
      enabledNotifications: Api.TypeStatsPercentValue;
      growthGraph: Api.TypeStatsGraph;
      followersGraph: Api.TypeStatsGraph;
      muteGraph: Api.TypeStatsGraph;
      topHoursGraph: Api.TypeStatsGraph;
      interactionsGraph: Api.TypeStatsGraph;
      ivInteractionsGraph: Api.TypeStatsGraph;
      viewsBySourceGraph: Api.TypeStatsGraph;
      newFollowersBySourceGraph: Api.TypeStatsGraph;
      languagesGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
      storyInteractionsGraph: Api.TypeStatsGraph;
      storyReactionsByEmotionGraph: Api.TypeStatsGraph;
      recentPostsInteractions: Api.TypePostInteractionCounters[];
    }> {
    CONSTRUCTOR_ID: 963421692;
    SUBCLASS_OF_ID: 2146587688;
    classType: "constructor";
    className: "stats.BroadcastStats";
    static fromReader(reader: Reader): BroadcastStats;
      period: Api.TypeStatsDateRangeDays;
      followers: Api.TypeStatsAbsValueAndPrev;
      viewsPerPost: Api.TypeStatsAbsValueAndPrev;
      sharesPerPost: Api.TypeStatsAbsValueAndPrev;
      reactionsPerPost: Api.TypeStatsAbsValueAndPrev;
      viewsPerStory: Api.TypeStatsAbsValueAndPrev;
      sharesPerStory: Api.TypeStatsAbsValueAndPrev;
      reactionsPerStory: Api.TypeStatsAbsValueAndPrev;
      enabledNotifications: Api.TypeStatsPercentValue;
      growthGraph: Api.TypeStatsGraph;
      followersGraph: Api.TypeStatsGraph;
      muteGraph: Api.TypeStatsGraph;
      topHoursGraph: Api.TypeStatsGraph;
      interactionsGraph: Api.TypeStatsGraph;
      ivInteractionsGraph: Api.TypeStatsGraph;
      viewsBySourceGraph: Api.TypeStatsGraph;
      newFollowersBySourceGraph: Api.TypeStatsGraph;
      languagesGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
      storyInteractionsGraph: Api.TypeStatsGraph;
      storyReactionsByEmotionGraph: Api.TypeStatsGraph;
      recentPostsInteractions: Api.TypePostInteractionCounters[];
    }
    export class MegagroupStats extends VirtualClass<{
      period: Api.TypeStatsDateRangeDays;
      members: Api.TypeStatsAbsValueAndPrev;
      messages: Api.TypeStatsAbsValueAndPrev;
      viewers: Api.TypeStatsAbsValueAndPrev;
      posters: Api.TypeStatsAbsValueAndPrev;
      growthGraph: Api.TypeStatsGraph;
      membersGraph: Api.TypeStatsGraph;
      newMembersBySourceGraph: Api.TypeStatsGraph;
      languagesGraph: Api.TypeStatsGraph;
      messagesGraph: Api.TypeStatsGraph;
      actionsGraph: Api.TypeStatsGraph;
      topHoursGraph: Api.TypeStatsGraph;
      weekdaysGraph: Api.TypeStatsGraph;
      topPosters: Api.TypeStatsGroupTopPoster[];
      topAdmins: Api.TypeStatsGroupTopAdmin[];
      topInviters: Api.TypeStatsGroupTopInviter[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4018141462;
    SUBCLASS_OF_ID: 1532608141;
    classType: "constructor";
    className: "stats.MegagroupStats";
    static fromReader(reader: Reader): MegagroupStats;
      period: Api.TypeStatsDateRangeDays;
      members: Api.TypeStatsAbsValueAndPrev;
      messages: Api.TypeStatsAbsValueAndPrev;
      viewers: Api.TypeStatsAbsValueAndPrev;
      posters: Api.TypeStatsAbsValueAndPrev;
      growthGraph: Api.TypeStatsGraph;
      membersGraph: Api.TypeStatsGraph;
      newMembersBySourceGraph: Api.TypeStatsGraph;
      languagesGraph: Api.TypeStatsGraph;
      messagesGraph: Api.TypeStatsGraph;
      actionsGraph: Api.TypeStatsGraph;
      topHoursGraph: Api.TypeStatsGraph;
      weekdaysGraph: Api.TypeStatsGraph;
      topPosters: Api.TypeStatsGroupTopPoster[];
      topAdmins: Api.TypeStatsGroupTopAdmin[];
      topInviters: Api.TypeStatsGroupTopInviter[];
      users: Api.TypeUser[];
    }
    export class MessageStats extends VirtualClass<{
      viewsGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
    }> {
    CONSTRUCTOR_ID: 2145983508;
    SUBCLASS_OF_ID: 2516886306;
    classType: "constructor";
    className: "stats.MessageStats";
    static fromReader(reader: Reader): MessageStats;
      viewsGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
    }
    export class StoryStats extends VirtualClass<{
      viewsGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
    }> {
    CONSTRUCTOR_ID: 1355613820;
    SUBCLASS_OF_ID: 2337096660;
    classType: "constructor";
    className: "stats.StoryStats";
    static fromReader(reader: Reader): StoryStats;
      viewsGraph: Api.TypeStatsGraph;
      reactionsByEmotionGraph: Api.TypeStatsGraph;
    }
    export class PublicForwards extends VirtualClass<{
      // flags: null;
      count: int;
      forwards: Api.TypePublicForward[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2466479648;
    SUBCLASS_OF_ID: 2804429329;
    classType: "constructor";
    className: "stats.PublicForwards";
    static fromReader(reader: Reader): PublicForwards;
      // flags: null;
      count: int;
      forwards: Api.TypePublicForward[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class BroadcastRevenueStats extends VirtualClass<{
      topHoursGraph: Api.TypeStatsGraph;
      revenueGraph: Api.TypeStatsGraph;
      balances: Api.TypeBroadcastRevenueBalances;
      usdRate: double;
    }> {
    CONSTRUCTOR_ID: 1409802903;
    SUBCLASS_OF_ID: 753807480;
    classType: "constructor";
    className: "stats.BroadcastRevenueStats";
    static fromReader(reader: Reader): BroadcastRevenueStats;
      topHoursGraph: Api.TypeStatsGraph;
      revenueGraph: Api.TypeStatsGraph;
      balances: Api.TypeBroadcastRevenueBalances;
      usdRate: double;
    }
    export class BroadcastRevenueWithdrawalUrl extends VirtualClass<{
      url: string;
    }> {
    CONSTRUCTOR_ID: 3966080823;
    SUBCLASS_OF_ID: 3512518885;
    classType: "constructor";
    className: "stats.BroadcastRevenueWithdrawalUrl";
    static fromReader(reader: Reader): BroadcastRevenueWithdrawalUrl;
      url: string;
    }
    export class BroadcastRevenueTransactions extends VirtualClass<{
      count: int;
      transactions: Api.TypeBroadcastRevenueTransaction[];
    }> {
    CONSTRUCTOR_ID: 2266334310;
    SUBCLASS_OF_ID: 108456469;
    classType: "constructor";
    className: "stats.BroadcastRevenueTransactions";
    static fromReader(reader: Reader): BroadcastRevenueTransactions;
      count: int;
      transactions: Api.TypeBroadcastRevenueTransaction[];
    }
  }

  export namespace stickers {
    export class SuggestedShortName extends VirtualClass<{
      shortName: string;
    }> {
    CONSTRUCTOR_ID: 2248056895;
    SUBCLASS_OF_ID: 3293203233;
    classType: "constructor";
    className: "stickers.SuggestedShortName";
    static fromReader(reader: Reader): SuggestedShortName;
      shortName: string;
    }
  }

  export namespace users {
    export class UserFull extends VirtualClass<{
      fullUser: Api.TypeUserFull;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 997004590;
    SUBCLASS_OF_ID: 2212470261;
    classType: "constructor";
    className: "users.UserFull";
    static fromReader(reader: Reader): UserFull;
      fullUser: Api.TypeUserFull;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class Users extends VirtualClass<{
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1658259128;
    SUBCLASS_OF_ID: 4065063104;
    classType: "constructor";
    className: "users.Users";
    static fromReader(reader: Reader): Users;
      users: Api.TypeUser[];
    }
    export class UsersSlice extends VirtualClass<{
      count: int;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 828000628;
    SUBCLASS_OF_ID: 4065063104;
    classType: "constructor";
    className: "users.UsersSlice";
    static fromReader(reader: Reader): UsersSlice;
      count: int;
      users: Api.TypeUser[];
    }
  }

  export namespace chatlists {
    export class ExportedChatlistInvite extends VirtualClass<{
      filter: Api.TypeDialogFilter;
      invite: Api.TypeExportedChatlistInvite;
    }> {
    CONSTRUCTOR_ID: 283567014;
    SUBCLASS_OF_ID: 3261681385;
    classType: "constructor";
    className: "chatlists.ExportedChatlistInvite";
    static fromReader(reader: Reader): ExportedChatlistInvite;
      filter: Api.TypeDialogFilter;
      invite: Api.TypeExportedChatlistInvite;
    }
    export class ExportedInvites extends VirtualClass<{
      invites: Api.TypeExportedChatlistInvite[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 279670215;
    SUBCLASS_OF_ID: 3871476160;
    classType: "constructor";
    className: "chatlists.ExportedInvites";
    static fromReader(reader: Reader): ExportedInvites;
      invites: Api.TypeExportedChatlistInvite[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChatlistInviteAlready extends VirtualClass<{
      filterId: int;
      missingPeers: Api.TypePeer[];
      alreadyPeers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4203214425;
    SUBCLASS_OF_ID: 1097993845;
    classType: "constructor";
    className: "chatlists.ChatlistInviteAlready";
    static fromReader(reader: Reader): ChatlistInviteAlready;
      filterId: int;
      missingPeers: Api.TypePeer[];
      alreadyPeers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChatlistInvite extends VirtualClass<{
      // flags: null;
      titleNoanimate?: boolean;
      title: Api.TypeTextWithEntities;
      emoticon?: string;
      peers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 4044279343;
    SUBCLASS_OF_ID: 1097993845;
    classType: "constructor";
    className: "chatlists.ChatlistInvite";
    static fromReader(reader: Reader): ChatlistInvite;
      // flags: null;
      titleNoanimate?: boolean;
      title: Api.TypeTextWithEntities;
      emoticon?: string;
      peers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class ChatlistUpdates extends VirtualClass<{
      missingPeers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2478671757;
    SUBCLASS_OF_ID: 2098610666;
    classType: "constructor";
    className: "chatlists.ChatlistUpdates";
    static fromReader(reader: Reader): ChatlistUpdates;
      missingPeers: Api.TypePeer[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
  }

  export namespace bots {
    export class BotInfo extends VirtualClass<{
      name: string;
      about: string;
      description: string;
    }> {
    CONSTRUCTOR_ID: 3903288752;
    SUBCLASS_OF_ID: 3397067317;
    classType: "constructor";
    className: "bots.BotInfo";
    static fromReader(reader: Reader): BotInfo;
      name: string;
      about: string;
      description: string;
    }
    export class PopularAppBots extends VirtualClass<{
      // flags: null;
      nextOffset?: string;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 428978491;
    SUBCLASS_OF_ID: 2070199933;
    classType: "constructor";
    className: "bots.PopularAppBots";
    static fromReader(reader: Reader): PopularAppBots;
      // flags: null;
      nextOffset?: string;
      users: Api.TypeUser[];
    }
    export class PreviewInfo extends VirtualClass<{
      media: Api.TypeBotPreviewMedia[];
      langCodes: string[];
    }> {
    CONSTRUCTOR_ID: 212278628;
    SUBCLASS_OF_ID: 4039278389;
    classType: "constructor";
    className: "bots.PreviewInfo";
    static fromReader(reader: Reader): PreviewInfo;
      media: Api.TypeBotPreviewMedia[];
      langCodes: string[];
    }
  }

  export namespace stories {
    export class AllStoriesNotModified extends VirtualClass<{
      // flags: null;
      state: string;
      stealthMode: Api.TypeStoriesStealthMode;
    }> {
    CONSTRUCTOR_ID: 291044926;
    SUBCLASS_OF_ID: 2120274125;
    classType: "constructor";
    className: "stories.AllStoriesNotModified";
    static fromReader(reader: Reader): AllStoriesNotModified;
      // flags: null;
      state: string;
      stealthMode: Api.TypeStoriesStealthMode;
    }
    export class AllStories extends VirtualClass<{
      // flags: null;
      hasMore?: boolean;
      count: int;
      state: string;
      peerStories: Api.TypePeerStories[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      stealthMode: Api.TypeStoriesStealthMode;
    }> {
    CONSTRUCTOR_ID: 1862033025;
    SUBCLASS_OF_ID: 2120274125;
    classType: "constructor";
    className: "stories.AllStories";
    static fromReader(reader: Reader): AllStories;
      // flags: null;
      hasMore?: boolean;
      count: int;
      state: string;
      peerStories: Api.TypePeerStories[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      stealthMode: Api.TypeStoriesStealthMode;
    }
    export class Stories extends VirtualClass<{
      // flags: null;
      count: int;
      stories: Api.TypeStoryItem[];
      pinnedToTop?: int[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 1673780490;
    SUBCLASS_OF_ID: 622595116;
    classType: "constructor";
    className: "stories.Stories";
    static fromReader(reader: Reader): Stories;
      // flags: null;
      count: int;
      stories: Api.TypeStoryItem[];
      pinnedToTop?: int[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class StoryViewsList extends VirtualClass<{
      // flags: null;
      count: int;
      viewsCount: int;
      forwardsCount: int;
      reactionsCount: int;
      views: Api.TypeStoryView[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }> {
    CONSTRUCTOR_ID: 1507299269;
    SUBCLASS_OF_ID: 3108205920;
    classType: "constructor";
    className: "stories.StoryViewsList";
    static fromReader(reader: Reader): StoryViewsList;
      // flags: null;
      count: int;
      viewsCount: int;
      forwardsCount: int;
      reactionsCount: int;
      views: Api.TypeStoryView[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }
    export class StoryViews extends VirtualClass<{
      views: Api.TypeStoryViews[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3734957341;
    SUBCLASS_OF_ID: 1262470330;
    classType: "constructor";
    className: "stories.StoryViews";
    static fromReader(reader: Reader): StoryViews;
      views: Api.TypeStoryViews[];
      users: Api.TypeUser[];
    }
    export class PeerStories extends VirtualClass<{
      stories: Api.TypePeerStories;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3404105576;
    SUBCLASS_OF_ID: 2639712208;
    classType: "constructor";
    className: "stories.PeerStories";
    static fromReader(reader: Reader): PeerStories;
      stories: Api.TypePeerStories;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class StoryReactionsList extends VirtualClass<{
      // flags: null;
      count: int;
      reactions: Api.TypeStoryReaction[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }> {
    CONSTRUCTOR_ID: 2858383516;
    SUBCLASS_OF_ID: 74420707;
    classType: "constructor";
    className: "stories.StoryReactionsList";
    static fromReader(reader: Reader): StoryReactionsList;
      // flags: null;
      count: int;
      reactions: Api.TypeStoryReaction[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
      nextOffset?: string;
    }
    export class FoundStories extends VirtualClass<{
      // flags: null;
      count: int;
      stories: Api.TypeFoundStory[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 3806230327;
    SUBCLASS_OF_ID: 393808693;
    classType: "constructor";
    className: "stories.FoundStories";
    static fromReader(reader: Reader): FoundStories;
      // flags: null;
      count: int;
      stories: Api.TypeFoundStory[];
      nextOffset?: string;
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
  }

  export namespace premium {
    export class BoostsList extends VirtualClass<{
      // flags: null;
      count: int;
      boosts: Api.TypeBoost[];
      nextOffset?: string;
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2264424764;
    SUBCLASS_OF_ID: 573941949;
    classType: "constructor";
    className: "premium.BoostsList";
    static fromReader(reader: Reader): BoostsList;
      // flags: null;
      count: int;
      boosts: Api.TypeBoost[];
      nextOffset?: string;
      users: Api.TypeUser[];
    }
    export class MyBoosts extends VirtualClass<{
      myBoosts: Api.TypeMyBoost[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }> {
    CONSTRUCTOR_ID: 2598512866;
    SUBCLASS_OF_ID: 2905936603;
    classType: "constructor";
    className: "premium.MyBoosts";
    static fromReader(reader: Reader): MyBoosts;
      myBoosts: Api.TypeMyBoost[];
      chats: Api.TypeChat[];
      users: Api.TypeUser[];
    }
    export class BoostsStatus extends VirtualClass<{
      // flags: null;
      myBoost?: boolean;
      level: int;
      currentLevelBoosts: int;
      boosts: int;
      giftBoosts?: int;
      nextLevelBoosts?: int;
      premiumAudience?: Api.TypeStatsPercentValue;
      boostUrl: string;
      prepaidGiveaways?: Api.TypePrepaidGiveaway[];
      myBoostSlots?: int[];
    }> {
    CONSTRUCTOR_ID: 1230586490;
    SUBCLASS_OF_ID: 3273333433;
    classType: "constructor";
    className: "premium.BoostsStatus";
    static fromReader(reader: Reader): BoostsStatus;
      // flags: null;
      myBoost?: boolean;
      level: int;
      currentLevelBoosts: int;
      boosts: int;
      giftBoosts?: int;
      nextLevelBoosts?: int;
      premiumAudience?: Api.TypeStatsPercentValue;
      boostUrl: string;
      prepaidGiveaways?: Api.TypePrepaidGiveaway[];
      myBoostSlots?: int[];
    }
  }

  export namespace smsjobs {
    export class EligibleToJoin extends VirtualClass<{
      termsUrl: string;
      monthlySentSms: int;
    }> {
    CONSTRUCTOR_ID: 3700114639;
    SUBCLASS_OF_ID: 1589076134;
    classType: "constructor";
    className: "smsjobs.EligibleToJoin";
    static fromReader(reader: Reader): EligibleToJoin;
      termsUrl: string;
      monthlySentSms: int;
    }
    export class Status extends VirtualClass<{
      // flags: null;
      allowInternational?: boolean;
      recentSent: int;
      recentSince: int;
      recentRemains: int;
      totalSent: int;
      totalSince: int;
      lastGiftSlug?: string;
      termsUrl: string;
    }> {
    CONSTRUCTOR_ID: 720277905;
    SUBCLASS_OF_ID: 3448711973;
    classType: "constructor";
    className: "smsjobs.Status";
    static fromReader(reader: Reader): Status;
      // flags: null;
      allowInternational?: boolean;
      recentSent: int;
      recentSince: int;
      recentRemains: int;
      totalSent: int;
      totalSince: int;
      lastGiftSlug?: string;
      termsUrl: string;
    }
  }

  export namespace fragment {
    export class CollectibleInfo extends VirtualClass<{
      purchaseDate: int;
      currency: string;
      amount: long;
      cryptoCurrency: string;
      cryptoAmount: long;
      url: string;
    }> {
    CONSTRUCTOR_ID: 1857945489;
    SUBCLASS_OF_ID: 3572127632;
    classType: "constructor";
    className: "fragment.CollectibleInfo";
    static fromReader(reader: Reader): CollectibleInfo;
      purchaseDate: int;
      currency: string;
      amount: long;
      cryptoCurrency: string;
      cryptoAmount: long;
      url: string;
    }
  }
  

  export namespace storage {
    export type TypeFileType = storage.FileUnknown | storage.FilePartial | storage.FileJpeg | storage.FileGif | storage.FilePng | storage.FilePdf | storage.FileMp3 | storage.FileMov | storage.FileMp4 | storage.FileWebp;
  }

  export namespace auth {
    export type TypeSentCode = auth.SentCode | auth.SentCodeSuccess;
    export type TypeAuthorization = auth.Authorization | auth.AuthorizationSignUpRequired;
    export type TypeExportedAuthorization = auth.ExportedAuthorization;
    export type TypePasswordRecovery = auth.PasswordRecovery;
    export type TypeCodeType = auth.CodeTypeSms | auth.CodeTypeCall | auth.CodeTypeFlashCall | auth.CodeTypeMissedCall | auth.CodeTypeFragmentSms;
    export type TypeSentCodeType = auth.SentCodeTypeApp | auth.SentCodeTypeSms | auth.SentCodeTypeCall | auth.SentCodeTypeFlashCall | auth.SentCodeTypeMissedCall | auth.SentCodeTypeEmailCode | auth.SentCodeTypeSetUpEmailRequired | auth.SentCodeTypeFragmentSms | auth.SentCodeTypeFirebaseSms | auth.SentCodeTypeSmsWord | auth.SentCodeTypeSmsPhrase;
    export type TypeLoginToken = auth.LoginToken | auth.LoginTokenMigrateTo | auth.LoginTokenSuccess;
    export type TypeLoggedOut = auth.LoggedOut;
  }

  export namespace contacts {
    export type TypeContacts = contacts.ContactsNotModified | contacts.Contacts;
    export type TypeImportedContacts = contacts.ImportedContacts;
    export type TypeBlocked = contacts.Blocked | contacts.BlockedSlice;
    export type TypeFound = contacts.Found;
    export type TypeResolvedPeer = contacts.ResolvedPeer;
    export type TypeTopPeers = contacts.TopPeersNotModified | contacts.TopPeers | contacts.TopPeersDisabled;
    export type TypeContactBirthdays = contacts.ContactBirthdays;
  }

  export namespace messages {
    export type TypeDialogs = messages.Dialogs | messages.DialogsSlice | messages.DialogsNotModified;
    export type TypeMessages = messages.Messages | messages.MessagesSlice | messages.ChannelMessages | messages.MessagesNotModified;
    export type TypeChats = messages.Chats | messages.ChatsSlice;
    export type TypeChatFull = messages.ChatFull;
    export type TypeAffectedHistory = messages.AffectedHistory;
    export type TypeDhConfig = messages.DhConfigNotModified | messages.DhConfig;
    export type TypeSentEncryptedMessage = messages.SentEncryptedMessage | messages.SentEncryptedFile;
    export type TypeStickers = messages.StickersNotModified | messages.Stickers;
    export type TypeAllStickers = messages.AllStickersNotModified | messages.AllStickers;
    export type TypeAffectedMessages = messages.AffectedMessages;
    export type TypeStickerSet = messages.StickerSet | messages.StickerSetNotModified;
    export type TypeSavedGifs = messages.SavedGifsNotModified | messages.SavedGifs;
    export type TypeBotResults = messages.BotResults;
    export type TypeBotCallbackAnswer = messages.BotCallbackAnswer;
    export type TypeMessageEditData = messages.MessageEditData;
    export type TypePeerDialogs = messages.PeerDialogs;
    export type TypeFeaturedStickers = messages.FeaturedStickersNotModified | messages.FeaturedStickers;
    export type TypeRecentStickers = messages.RecentStickersNotModified | messages.RecentStickers;
    export type TypeArchivedStickers = messages.ArchivedStickers;
    export type TypeStickerSetInstallResult = messages.StickerSetInstallResultSuccess | messages.StickerSetInstallResultArchive;
    export type TypeHighScores = messages.HighScores;
    export type TypeFavedStickers = messages.FavedStickersNotModified | messages.FavedStickers;
    export type TypeFoundStickerSets = messages.FoundStickerSetsNotModified | messages.FoundStickerSets;
    export type TypeSearchCounter = messages.SearchCounter;
    export type TypeInactiveChats = messages.InactiveChats;
    export type TypeVotesList = messages.VotesList;
    export type TypeMessageViews = messages.MessageViews;
    export type TypeDiscussionMessage = messages.DiscussionMessage;
    export type TypeHistoryImport = messages.HistoryImport;
    export type TypeHistoryImportParsed = messages.HistoryImportParsed;
    export type TypeAffectedFoundMessages = messages.AffectedFoundMessages;
    export type TypeExportedChatInvites = messages.ExportedChatInvites;
    export type TypeExportedChatInvite = messages.ExportedChatInvite | messages.ExportedChatInviteReplaced;
    export type TypeChatInviteImporters = messages.ChatInviteImporters;
    export type TypeChatAdminsWithInvites = messages.ChatAdminsWithInvites;
    export type TypeCheckedHistoryImportPeer = messages.CheckedHistoryImportPeer;
    export type TypeSponsoredMessages = messages.SponsoredMessages | messages.SponsoredMessagesEmpty;
    export type TypeSearchResultsCalendar = messages.SearchResultsCalendar;
    export type TypeSearchResultsPositions = messages.SearchResultsPositions;
    export type TypePeerSettings = messages.PeerSettings;
    export type TypeMessageReactionsList = messages.MessageReactionsList;
    export type TypeAvailableReactions = messages.AvailableReactionsNotModified | messages.AvailableReactions;
    export type TypeTranscribedAudio = messages.TranscribedAudio;
    export type TypeReactions = messages.ReactionsNotModified | messages.Reactions;
    export type TypeForumTopics = messages.ForumTopics;
    export type TypeEmojiGroups = messages.EmojiGroupsNotModified | messages.EmojiGroups;
    export type TypeTranslatedText = messages.TranslateResult;
    export type TypeBotApp = messages.BotApp;
    export type TypeWebPage = messages.WebPage;
    export type TypeSavedDialogs = messages.SavedDialogs | messages.SavedDialogsSlice | messages.SavedDialogsNotModified;
    export type TypeSavedReactionTags = messages.SavedReactionTagsNotModified | messages.SavedReactionTags;
    export type TypeQuickReplies = messages.QuickReplies | messages.QuickRepliesNotModified;
    export type TypeDialogFilters = messages.DialogFilters;
    export type TypeMyStickers = messages.MyStickers;
    export type TypeInvitedUsers = messages.InvitedUsers;
    export type TypeAvailableEffects = messages.AvailableEffectsNotModified | messages.AvailableEffects;
    export type TypeBotPreparedInlineMessage = messages.BotPreparedInlineMessage;
    export type TypePreparedInlineMessage = messages.PreparedInlineMessage;
    export type TypeFoundStickers = messages.FoundStickersNotModified | messages.FoundStickers;
    export type TypeWebPagePreview = messages.WebPagePreview;
  }

  export namespace updates {
    export type TypeState = updates.State;
    export type TypeDifference = updates.DifferenceEmpty | updates.Difference | updates.DifferenceSlice | updates.DifferenceTooLong;
    export type TypeChannelDifference = updates.ChannelDifferenceEmpty | updates.ChannelDifferenceTooLong | updates.ChannelDifference;
  }

  export namespace photos {
    export type TypePhotos = photos.Photos | photos.PhotosSlice;
    export type TypePhoto = photos.Photo;
  }

  export namespace upload {
    export type TypeFile = upload.File | upload.FileCdnRedirect;
    export type TypeWebFile = upload.WebFile;
    export type TypeCdnFile = upload.CdnFileReuploadNeeded | upload.CdnFile;
  }

  export namespace help {
    export type TypeAppUpdate = help.AppUpdate | help.NoAppUpdate;
    export type TypeInviteText = help.InviteText;
    export type TypeSupport = help.Support;
    export type TypeTermsOfService = help.TermsOfService;
    export type TypeRecentMeUrls = help.RecentMeUrls;
    export type TypeTermsOfServiceUpdate = help.TermsOfServiceUpdateEmpty | help.TermsOfServiceUpdate;
    export type TypeDeepLinkInfo = help.DeepLinkInfoEmpty | help.DeepLinkInfo;
    export type TypePassportConfig = help.PassportConfigNotModified | help.PassportConfig;
    export type TypeSupportName = help.SupportName;
    export type TypeUserInfo = help.UserInfoEmpty | help.UserInfo;
    export type TypePromoData = help.PromoDataEmpty | help.PromoData;
    export type TypeCountryCode = help.CountryCode;
    export type TypeCountry = help.Country;
    export type TypeCountriesList = help.CountriesListNotModified | help.CountriesList;
    export type TypePremiumPromo = help.PremiumPromo;
    export type TypeAppConfig = help.AppConfigNotModified | help.AppConfig;
    export type TypePeerColorSet = help.PeerColorSet | help.PeerColorProfileSet;
    export type TypePeerColorOption = help.PeerColorOption;
    export type TypePeerColors = help.PeerColorsNotModified | help.PeerColors;
    export type TypeTimezonesList = help.TimezonesListNotModified | help.TimezonesList;
    export type TypeConfigSimple = help.ConfigSimple;
  }

  export namespace account {
    export type TypePrivacyRules = account.PrivacyRules;
    export type TypeAuthorizations = account.Authorizations;
    export type TypePassword = account.Password;
    export type TypePasswordSettings = account.PasswordSettings;
    export type TypePasswordInputSettings = account.PasswordInputSettings;
    export type TypeTmpPassword = account.TmpPassword;
    export type TypeWebAuthorizations = account.WebAuthorizations;
    export type TypeAuthorizationForm = account.AuthorizationForm;
    export type TypeSentEmailCode = account.SentEmailCode;
    export type TypeTakeout = account.Takeout;
    export type TypeWallPapers = account.WallPapersNotModified | account.WallPapers;
    export type TypeAutoDownloadSettings = account.AutoDownloadSettings;
    export type TypeThemes = account.ThemesNotModified | account.Themes;
    export type TypeContentSettings = account.ContentSettings;
    export type TypeResetPasswordResult = account.ResetPasswordFailedWait | account.ResetPasswordRequestedWait | account.ResetPasswordOk;
    export type TypeSavedRingtones = account.SavedRingtonesNotModified | account.SavedRingtones;
    export type TypeSavedRingtone = account.SavedRingtone | account.SavedRingtoneConverted;
    export type TypeEmojiStatuses = account.EmojiStatusesNotModified | account.EmojiStatuses;
    export type TypeEmailVerified = account.EmailVerified | account.EmailVerifiedLogin;
    export type TypeAutoSaveSettings = account.AutoSaveSettings;
    export type TypeConnectedBots = account.ConnectedBots;
    export type TypeBusinessChatLinks = account.BusinessChatLinks;
    export type TypeResolvedBusinessChatLinks = account.ResolvedBusinessChatLinks;
  }

  export namespace channels {
    export type TypeChannelParticipants = channels.ChannelParticipants | channels.ChannelParticipantsNotModified;
    export type TypeChannelParticipant = channels.ChannelParticipant;
    export type TypeAdminLogResults = channels.AdminLogResults;
    export type TypeSendAsPeers = channels.SendAsPeers;
    export type TypeSponsoredMessageReportResult = channels.SponsoredMessageReportResultChooseOption | channels.SponsoredMessageReportResultAdsHidden | channels.SponsoredMessageReportResultReported;
  }

  export namespace payments {
    export type TypePaymentForm = payments.PaymentForm | payments.PaymentFormStars | payments.PaymentFormStarGift;
    export type TypeValidatedRequestedInfo = payments.ValidatedRequestedInfo;
    export type TypePaymentResult = payments.PaymentResult | payments.PaymentVerificationNeeded;
    export type TypePaymentReceipt = payments.PaymentReceipt | payments.PaymentReceiptStars;
    export type TypeSavedInfo = payments.SavedInfo;
    export type TypeBankCardData = payments.BankCardData;
    export type TypeExportedInvoice = payments.ExportedInvoice;
    export type TypeCheckedGiftCode = payments.CheckedGiftCode;
    export type TypeGiveawayInfo = payments.GiveawayInfo | payments.GiveawayInfoResults;
    export type TypeStarsStatus = payments.StarsStatus;
    export type TypeStarsRevenueStats = payments.StarsRevenueStats;
    export type TypeStarsRevenueWithdrawalUrl = payments.StarsRevenueWithdrawalUrl;
    export type TypeStarsRevenueAdsAccountUrl = payments.StarsRevenueAdsAccountUrl;
    export type TypeStarGifts = payments.StarGiftsNotModified | payments.StarGifts;
    export type TypeConnectedStarRefBots = payments.ConnectedStarRefBots;
    export type TypeSuggestedStarRefBots = payments.SuggestedStarRefBots;
    export type TypeStarGiftUpgradePreview = payments.StarGiftUpgradePreview;
    export type TypeUniqueStarGift = payments.UniqueStarGift;
    export type TypeSavedStarGifts = payments.SavedStarGifts;
    export type TypeStarGiftWithdrawalUrl = payments.StarGiftWithdrawalUrl;
  }

  export namespace phone {
    export type TypePhoneCall = phone.PhoneCall;
    export type TypeGroupCall = phone.GroupCall;
    export type TypeGroupParticipants = phone.GroupParticipants;
    export type TypeJoinAsPeers = phone.JoinAsPeers;
    export type TypeExportedGroupCallInvite = phone.ExportedGroupCallInvite;
    export type TypeGroupCallStreamChannels = phone.GroupCallStreamChannels;
    export type TypeGroupCallStreamRtmpUrl = phone.GroupCallStreamRtmpUrl;
  }

  export namespace stats {
    export type TypeBroadcastStats = stats.BroadcastStats;
    export type TypeMegagroupStats = stats.MegagroupStats;
    export type TypeMessageStats = stats.MessageStats;
    export type TypeStoryStats = stats.StoryStats;
    export type TypePublicForwards = stats.PublicForwards;
    export type TypeBroadcastRevenueStats = stats.BroadcastRevenueStats;
    export type TypeBroadcastRevenueWithdrawalUrl = stats.BroadcastRevenueWithdrawalUrl;
    export type TypeBroadcastRevenueTransactions = stats.BroadcastRevenueTransactions;
  }

  export namespace stickers {
    export type TypeSuggestedShortName = stickers.SuggestedShortName;
  }

  export namespace users {
    export type TypeUserFull = users.UserFull;
    export type TypeUsers = users.Users | users.UsersSlice;
  }

  export namespace chatlists {
    export type TypeExportedChatlistInvite = chatlists.ExportedChatlistInvite;
    export type TypeExportedInvites = chatlists.ExportedInvites;
    export type TypeChatlistInvite = chatlists.ChatlistInviteAlready | chatlists.ChatlistInvite;
    export type TypeChatlistUpdates = chatlists.ChatlistUpdates;
  }

  export namespace bots {
    export type TypeBotInfo = bots.BotInfo;
    export type TypePopularAppBots = bots.PopularAppBots;
    export type TypePreviewInfo = bots.PreviewInfo;
  }

  export namespace stories {
    export type TypeAllStories = stories.AllStoriesNotModified | stories.AllStories;
    export type TypeStories = stories.Stories;
    export type TypeStoryViewsList = stories.StoryViewsList;
    export type TypeStoryViews = stories.StoryViews;
    export type TypePeerStories = stories.PeerStories;
    export type TypeStoryReactionsList = stories.StoryReactionsList;
    export type TypeFoundStories = stories.FoundStories;
  }

  export namespace premium {
    export type TypeBoostsList = premium.BoostsList;
    export type TypeMyBoosts = premium.MyBoosts;
    export type TypeBoostsStatus = premium.BoostsStatus;
  }

  export namespace smsjobs {
    export type TypeEligibilityToJoin = smsjobs.EligibleToJoin;
    export type TypeStatus = smsjobs.Status;
  }

  export namespace fragment {
    export type TypeCollectibleInfo = fragment.CollectibleInfo;
  }
  

  export namespace auth {
    export class SendCode extends Request<Partial<{
      phoneNumber: string;
      apiId: int;
      apiHash: string;
      settings: Api.TypeCodeSettings;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 2792825935;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "auth.SendCode";
    static fromReader(reader: Reader): SendCode;
      phoneNumber: string;
      apiId: int;
      apiHash: string;
      settings: Api.TypeCodeSettings;
    }
    export class SignUp extends Request<Partial<{
      // flags: null;
      noJoinedNotifications?: boolean;
      phoneNumber: string;
      phoneCodeHash: string;
      firstName: string;
      lastName: string;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 2865215255;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.SignUp";
    static fromReader(reader: Reader): SignUp;
      // flags: null;
      noJoinedNotifications?: boolean;
      phoneNumber: string;
      phoneCodeHash: string;
      firstName: string;
      lastName: string;
    }
    export class SignIn extends Request<Partial<{
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode?: string;
      emailVerification?: Api.TypeEmailVerification;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 2371004753;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.SignIn";
    static fromReader(reader: Reader): SignIn;
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode?: string;
      emailVerification?: Api.TypeEmailVerification;
    }
    export class LogOut extends Request<void, auth.TypeLoggedOut> {
    CONSTRUCTOR_ID: 1047706137;
    SUBCLASS_OF_ID: 176177941;
    classType: "request";
    className: "auth.LogOut";
    static fromReader(reader: Reader): LogOut;
}
    export class ResetAuthorizations extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2678787354;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.ResetAuthorizations";
    static fromReader(reader: Reader): ResetAuthorizations;
}
    export class ExportAuthorization extends Request<Partial<{
      dcId: int;
    }>, auth.TypeExportedAuthorization> {
    CONSTRUCTOR_ID: 3854565325;
    SUBCLASS_OF_ID: 1607593041;
    classType: "request";
    className: "auth.ExportAuthorization";
    static fromReader(reader: Reader): ExportAuthorization;
      dcId: int;
    }
    export class ImportAuthorization extends Request<Partial<{
      id: long;
      bytes: bytes;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 2776268205;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.ImportAuthorization";
    static fromReader(reader: Reader): ImportAuthorization;
      id: long;
      bytes: bytes;
    }
    export class BindTempAuthKey extends Request<Partial<{
      permAuthKeyId: long;
      nonce: long;
      expiresAt: int;
      encryptedMessage: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 3453233669;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.BindTempAuthKey";
    static fromReader(reader: Reader): BindTempAuthKey;
      permAuthKeyId: long;
      nonce: long;
      expiresAt: int;
      encryptedMessage: bytes;
    }
    export class ImportBotAuthorization extends Request<Partial<{
      flags: int;
      apiId: int;
      apiHash: string;
      botAuthToken: string;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 1738800940;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.ImportBotAuthorization";
    static fromReader(reader: Reader): ImportBotAuthorization;
      flags: int;
      apiId: int;
      apiHash: string;
      botAuthToken: string;
    }
    export class CheckPassword extends Request<Partial<{
      password: Api.TypeInputCheckPasswordSRP;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 3515567382;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.CheckPassword";
    static fromReader(reader: Reader): CheckPassword;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class RequestPasswordRecovery extends Request<void, auth.TypePasswordRecovery> {
    CONSTRUCTOR_ID: 3633822822;
    SUBCLASS_OF_ID: 4201829434;
    classType: "request";
    className: "auth.RequestPasswordRecovery";
    static fromReader(reader: Reader): RequestPasswordRecovery;
}
    export class RecoverPassword extends Request<Partial<{
      // flags: null;
      code: string;
      newSettings?: account.TypePasswordInputSettings;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 923364464;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.RecoverPassword";
    static fromReader(reader: Reader): RecoverPassword;
      // flags: null;
      code: string;
      newSettings?: account.TypePasswordInputSettings;
    }
    export class ResendCode extends Request<Partial<{
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      reason?: string;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 3403969827;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "auth.ResendCode";
    static fromReader(reader: Reader): ResendCode;
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      reason?: string;
    }
    export class CancelCode extends Request<Partial<{
      phoneNumber: string;
      phoneCodeHash: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 520357240;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.CancelCode";
    static fromReader(reader: Reader): CancelCode;
      phoneNumber: string;
      phoneCodeHash: string;
    }
    export class DropTempAuthKeys extends Request<Partial<{
      exceptAuthKeys: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2387124616;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.DropTempAuthKeys";
    static fromReader(reader: Reader): DropTempAuthKeys;
      exceptAuthKeys: long[];
    }
    export class ExportLoginToken extends Request<Partial<{
      apiId: int;
      apiHash: string;
      exceptIds: long[];
    }>, auth.TypeLoginToken> {
    CONSTRUCTOR_ID: 3084944894;
    SUBCLASS_OF_ID: 1800795702;
    classType: "request";
    className: "auth.ExportLoginToken";
    static fromReader(reader: Reader): ExportLoginToken;
      apiId: int;
      apiHash: string;
      exceptIds: long[];
    }
    export class ImportLoginToken extends Request<Partial<{
      token: bytes;
    }>, auth.TypeLoginToken> {
    CONSTRUCTOR_ID: 2511101156;
    SUBCLASS_OF_ID: 1800795702;
    classType: "request";
    className: "auth.ImportLoginToken";
    static fromReader(reader: Reader): ImportLoginToken;
      token: bytes;
    }
    export class AcceptLoginToken extends Request<Partial<{
      token: bytes;
    }>, Api.TypeAuthorization> {
    CONSTRUCTOR_ID: 3902057805;
    SUBCLASS_OF_ID: 3373514778;
    classType: "request";
    className: "auth.AcceptLoginToken";
    static fromReader(reader: Reader): AcceptLoginToken;
      token: bytes;
    }
    export class CheckRecoveryPassword extends Request<Partial<{
      code: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 221691769;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.CheckRecoveryPassword";
    static fromReader(reader: Reader): CheckRecoveryPassword;
      code: string;
    }
    export class ImportWebTokenAuthorization extends Request<Partial<{
      apiId: int;
      apiHash: string;
      webAuthToken: string;
    }>, auth.TypeAuthorization> {
    CONSTRUCTOR_ID: 767062953;
    SUBCLASS_OF_ID: 3118485049;
    classType: "request";
    className: "auth.ImportWebTokenAuthorization";
    static fromReader(reader: Reader): ImportWebTokenAuthorization;
      apiId: int;
      apiHash: string;
      webAuthToken: string;
    }
    export class RequestFirebaseSms extends Request<Partial<{
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      safetyNetToken?: string;
      playIntegrityToken?: string;
      iosPushSecret?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 2386109982;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.RequestFirebaseSms";
    static fromReader(reader: Reader): RequestFirebaseSms;
      // flags: null;
      phoneNumber: string;
      phoneCodeHash: string;
      safetyNetToken?: string;
      playIntegrityToken?: string;
      iosPushSecret?: string;
    }
    export class ResetLoginEmail extends Request<Partial<{
      phoneNumber: string;
      phoneCodeHash: string;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 2123760019;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "auth.ResetLoginEmail";
    static fromReader(reader: Reader): ResetLoginEmail;
      phoneNumber: string;
      phoneCodeHash: string;
    }
    export class ReportMissingCode extends Request<Partial<{
      phoneNumber: string;
      phoneCodeHash: string;
      mnc: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3416125430;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "auth.ReportMissingCode";
    static fromReader(reader: Reader): ReportMissingCode;
      phoneNumber: string;
      phoneCodeHash: string;
      mnc: string;
    }
  }

  export namespace account {
    export class RegisterDevice extends Request<Partial<{
      // flags: null;
      noMuted?: boolean;
      tokenType: int;
      token: string;
      appSandbox: Bool;
      secret: bytes;
      otherUids: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3968205178;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.RegisterDevice";
    static fromReader(reader: Reader): RegisterDevice;
      // flags: null;
      noMuted?: boolean;
      tokenType: int;
      token: string;
      appSandbox: Bool;
      secret: bytes;
      otherUids: long[];
    }
    export class UnregisterDevice extends Request<Partial<{
      tokenType: int;
      token: string;
      otherUids: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 1779249670;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UnregisterDevice";
    static fromReader(reader: Reader): UnregisterDevice;
      tokenType: int;
      token: string;
      otherUids: long[];
    }
    export class UpdateNotifySettings extends Request<Partial<{
      peer: Api.TypeInputNotifyPeer;
      settings: Api.TypeInputPeerNotifySettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 2227067795;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateNotifySettings";
    static fromReader(reader: Reader): UpdateNotifySettings;
      peer: Api.TypeInputNotifyPeer;
      settings: Api.TypeInputPeerNotifySettings;
    }
    export class GetNotifySettings extends Request<Partial<{
      peer: Api.TypeInputNotifyPeer;
    }>, Api.TypePeerNotifySettings> {
    CONSTRUCTOR_ID: 313765169;
    SUBCLASS_OF_ID: 3475030132;
    classType: "request";
    className: "account.GetNotifySettings";
    static fromReader(reader: Reader): GetNotifySettings;
      peer: Api.TypeInputNotifyPeer;
    }
    export class ResetNotifySettings extends Request<void, Bool> {
    CONSTRUCTOR_ID: 3682473799;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResetNotifySettings";
    static fromReader(reader: Reader): ResetNotifySettings;
}
    export class UpdateProfile extends Request<Partial<{
      // flags: null;
      firstName?: string;
      lastName?: string;
      about?: string;
    }>, Api.TypeUser> {
    CONSTRUCTOR_ID: 2018596725;
    SUBCLASS_OF_ID: 765557111;
    classType: "request";
    className: "account.UpdateProfile";
    static fromReader(reader: Reader): UpdateProfile;
      // flags: null;
      firstName?: string;
      lastName?: string;
      about?: string;
    }
    export class UpdateStatus extends Request<Partial<{
      offline: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1713919532;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateStatus";
    static fromReader(reader: Reader): UpdateStatus;
      offline: Bool;
    }
    export class GetWallPapers extends Request<Partial<{
      hash: long;
    }>, account.TypeWallPapers> {
    CONSTRUCTOR_ID: 127302966;
    SUBCLASS_OF_ID: 2730838269;
    classType: "request";
    className: "account.GetWallPapers";
    static fromReader(reader: Reader): GetWallPapers;
      hash: long;
    }
    export class ReportPeer extends Request<Partial<{
      peer: Api.TypeEntityLike;
      reason: Api.TypeReportReason;
      message: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3317316998;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ReportPeer";
    static fromReader(reader: Reader): ReportPeer;
      peer: Api.TypeEntityLike;
      reason: Api.TypeReportReason;
      message: string;
    }
    export class CheckUsername extends Request<Partial<{
      username: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 655677548;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.CheckUsername";
    static fromReader(reader: Reader): CheckUsername;
      username: string;
    }
    export class UpdateUsername extends Request<Partial<{
      username: string;
    }>, Api.TypeUser> {
    CONSTRUCTOR_ID: 1040964988;
    SUBCLASS_OF_ID: 765557111;
    classType: "request";
    className: "account.UpdateUsername";
    static fromReader(reader: Reader): UpdateUsername;
      username: string;
    }
    export class GetPrivacy extends Request<Partial<{
      key: Api.TypeInputPrivacyKey;
    }>, account.TypePrivacyRules> {
    CONSTRUCTOR_ID: 3671837008;
    SUBCLASS_OF_ID: 3042622082;
    classType: "request";
    className: "account.GetPrivacy";
    static fromReader(reader: Reader): GetPrivacy;
      key: Api.TypeInputPrivacyKey;
    }
    export class SetPrivacy extends Request<Partial<{
      key: Api.TypeInputPrivacyKey;
      rules: Api.TypeInputPrivacyRule[];
    }>, account.TypePrivacyRules> {
    CONSTRUCTOR_ID: 3388480744;
    SUBCLASS_OF_ID: 3042622082;
    classType: "request";
    className: "account.SetPrivacy";
    static fromReader(reader: Reader): SetPrivacy;
      key: Api.TypeInputPrivacyKey;
      rules: Api.TypeInputPrivacyRule[];
    }
    export class DeleteAccount extends Request<Partial<{
      // flags: null;
      reason: string;
      password?: Api.TypeInputCheckPasswordSRP;
    }>, Bool> {
    CONSTRUCTOR_ID: 2730545012;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DeleteAccount";
    static fromReader(reader: Reader): DeleteAccount;
      // flags: null;
      reason: string;
      password?: Api.TypeInputCheckPasswordSRP;
    }
    export class GetAccountTTL extends Request<void, Api.TypeAccountDaysTTL> {
    CONSTRUCTOR_ID: 150761757;
    SUBCLASS_OF_ID: 3131284872;
    classType: "request";
    className: "account.GetAccountTTL";
    static fromReader(reader: Reader): GetAccountTTL;
}
    export class SetAccountTTL extends Request<Partial<{
      ttl: Api.TypeAccountDaysTTL;
    }>, Bool> {
    CONSTRUCTOR_ID: 608323678;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SetAccountTTL";
    static fromReader(reader: Reader): SetAccountTTL;
      ttl: Api.TypeAccountDaysTTL;
    }
    export class SendChangePhoneCode extends Request<Partial<{
      phoneNumber: string;
      settings: Api.TypeCodeSettings;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 2186758885;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "account.SendChangePhoneCode";
    static fromReader(reader: Reader): SendChangePhoneCode;
      phoneNumber: string;
      settings: Api.TypeCodeSettings;
    }
    export class ChangePhone extends Request<Partial<{
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode: string;
    }>, Api.TypeUser> {
    CONSTRUCTOR_ID: 1891839707;
    SUBCLASS_OF_ID: 765557111;
    classType: "request";
    className: "account.ChangePhone";
    static fromReader(reader: Reader): ChangePhone;
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode: string;
    }
    export class UpdateDeviceLocked extends Request<Partial<{
      period: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 954152242;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateDeviceLocked";
    static fromReader(reader: Reader): UpdateDeviceLocked;
      period: int;
    }
    export class GetAuthorizations extends Request<void, account.TypeAuthorizations> {
    CONSTRUCTOR_ID: 3810574680;
    SUBCLASS_OF_ID: 200663295;
    classType: "request";
    className: "account.GetAuthorizations";
    static fromReader(reader: Reader): GetAuthorizations;
}
    export class ResetAuthorization extends Request<Partial<{
      hash: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 3749180348;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResetAuthorization";
    static fromReader(reader: Reader): ResetAuthorization;
      hash: long;
    }
    export class GetPassword extends Request<void, account.TypePassword> {
    CONSTRUCTOR_ID: 1418342645;
    SUBCLASS_OF_ID: 1403130275;
    classType: "request";
    className: "account.GetPassword";
    static fromReader(reader: Reader): GetPassword;
}
    export class GetPasswordSettings extends Request<Partial<{
      password: Api.TypeInputCheckPasswordSRP;
    }>, account.TypePasswordSettings> {
    CONSTRUCTOR_ID: 2631199481;
    SUBCLASS_OF_ID: 3527389304;
    classType: "request";
    className: "account.GetPasswordSettings";
    static fromReader(reader: Reader): GetPasswordSettings;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class UpdatePasswordSettings extends Request<Partial<{
      password: Api.TypeInputCheckPasswordSRP;
      newSettings: account.TypePasswordInputSettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 2778402863;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdatePasswordSettings";
    static fromReader(reader: Reader): UpdatePasswordSettings;
      password: Api.TypeInputCheckPasswordSRP;
      newSettings: account.TypePasswordInputSettings;
    }
    export class SendConfirmPhoneCode extends Request<Partial<{
      hash: string;
      settings: Api.TypeCodeSettings;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 457157256;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "account.SendConfirmPhoneCode";
    static fromReader(reader: Reader): SendConfirmPhoneCode;
      hash: string;
      settings: Api.TypeCodeSettings;
    }
    export class ConfirmPhone extends Request<Partial<{
      phoneCodeHash: string;
      phoneCode: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1596029123;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ConfirmPhone";
    static fromReader(reader: Reader): ConfirmPhone;
      phoneCodeHash: string;
      phoneCode: string;
    }
    export class GetTmpPassword extends Request<Partial<{
      password: Api.TypeInputCheckPasswordSRP;
      period: int;
    }>, account.TypeTmpPassword> {
    CONSTRUCTOR_ID: 1151208273;
    SUBCLASS_OF_ID: 2959382829;
    classType: "request";
    className: "account.GetTmpPassword";
    static fromReader(reader: Reader): GetTmpPassword;
      password: Api.TypeInputCheckPasswordSRP;
      period: int;
    }
    export class GetWebAuthorizations extends Request<void, account.TypeWebAuthorizations> {
    CONSTRUCTOR_ID: 405695855;
    SUBCLASS_OF_ID: 2587253554;
    classType: "request";
    className: "account.GetWebAuthorizations";
    static fromReader(reader: Reader): GetWebAuthorizations;
}
    export class ResetWebAuthorization extends Request<Partial<{
      hash: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 755087855;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResetWebAuthorization";
    static fromReader(reader: Reader): ResetWebAuthorization;
      hash: long;
    }
    export class ResetWebAuthorizations extends Request<void, Bool> {
    CONSTRUCTOR_ID: 1747789204;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResetWebAuthorizations";
    static fromReader(reader: Reader): ResetWebAuthorizations;
}
    export class GetAllSecureValues extends Request<void, Api.TypeSecureValue[]> {
    CONSTRUCTOR_ID: 2995305597;
    SUBCLASS_OF_ID: 3895345441;
    classType: "request";
    className: "account.GetAllSecureValues";
    static fromReader(reader: Reader): GetAllSecureValues;
}
    export class GetSecureValue extends Request<Partial<{
      types: Api.TypeSecureValueType[];
    }>, Api.TypeSecureValue[]> {
    CONSTRUCTOR_ID: 1936088002;
    SUBCLASS_OF_ID: 3895345441;
    classType: "request";
    className: "account.GetSecureValue";
    static fromReader(reader: Reader): GetSecureValue;
      types: Api.TypeSecureValueType[];
    }
    export class SaveSecureValue extends Request<Partial<{
      value: Api.TypeInputSecureValue;
      secureSecretId: long;
    }>, Api.TypeSecureValue> {
    CONSTRUCTOR_ID: 2308956957;
    SUBCLASS_OF_ID: 85014702;
    classType: "request";
    className: "account.SaveSecureValue";
    static fromReader(reader: Reader): SaveSecureValue;
      value: Api.TypeInputSecureValue;
      secureSecretId: long;
    }
    export class DeleteSecureValue extends Request<Partial<{
      types: Api.TypeSecureValueType[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3095444555;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DeleteSecureValue";
    static fromReader(reader: Reader): DeleteSecureValue;
      types: Api.TypeSecureValueType[];
    }
    export class GetAuthorizationForm extends Request<Partial<{
      botId: long;
      scope: string;
      publicKey: string;
    }>, account.TypeAuthorizationForm> {
    CONSTRUCTOR_ID: 2838059386;
    SUBCLASS_OF_ID: 2013567636;
    classType: "request";
    className: "account.GetAuthorizationForm";
    static fromReader(reader: Reader): GetAuthorizationForm;
      botId: long;
      scope: string;
      publicKey: string;
    }
    export class AcceptAuthorization extends Request<Partial<{
      botId: long;
      scope: string;
      publicKey: string;
      valueHashes: Api.TypeSecureValueHash[];
      credentials: Api.TypeSecureCredentialsEncrypted;
    }>, Bool> {
    CONSTRUCTOR_ID: 4092415091;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.AcceptAuthorization";
    static fromReader(reader: Reader): AcceptAuthorization;
      botId: long;
      scope: string;
      publicKey: string;
      valueHashes: Api.TypeSecureValueHash[];
      credentials: Api.TypeSecureCredentialsEncrypted;
    }
    export class SendVerifyPhoneCode extends Request<Partial<{
      phoneNumber: string;
      settings: Api.TypeCodeSettings;
    }>, auth.TypeSentCode> {
    CONSTRUCTOR_ID: 2778945273;
    SUBCLASS_OF_ID: 1827172481;
    classType: "request";
    className: "account.SendVerifyPhoneCode";
    static fromReader(reader: Reader): SendVerifyPhoneCode;
      phoneNumber: string;
      settings: Api.TypeCodeSettings;
    }
    export class VerifyPhone extends Request<Partial<{
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1305716726;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.VerifyPhone";
    static fromReader(reader: Reader): VerifyPhone;
      phoneNumber: string;
      phoneCodeHash: string;
      phoneCode: string;
    }
    export class SendVerifyEmailCode extends Request<Partial<{
      purpose: Api.TypeEmailVerifyPurpose;
      email: string;
    }>, account.TypeSentEmailCode> {
    CONSTRUCTOR_ID: 2564831163;
    SUBCLASS_OF_ID: 1777582190;
    classType: "request";
    className: "account.SendVerifyEmailCode";
    static fromReader(reader: Reader): SendVerifyEmailCode;
      purpose: Api.TypeEmailVerifyPurpose;
      email: string;
    }
    export class VerifyEmail extends Request<Partial<{
      purpose: Api.TypeEmailVerifyPurpose;
      verification: Api.TypeEmailVerification;
    }>, account.TypeEmailVerified> {
    CONSTRUCTOR_ID: 53322959;
    SUBCLASS_OF_ID: 1686319496;
    classType: "request";
    className: "account.VerifyEmail";
    static fromReader(reader: Reader): VerifyEmail;
      purpose: Api.TypeEmailVerifyPurpose;
      verification: Api.TypeEmailVerification;
    }
    export class InitTakeoutSession extends Request<Partial<{
      // flags: null;
      contacts?: boolean;
      messageUsers?: boolean;
      messageChats?: boolean;
      messageMegagroups?: boolean;
      messageChannels?: boolean;
      files?: boolean;
      fileMaxSize?: long;
    }>, account.TypeTakeout> {
    CONSTRUCTOR_ID: 2398350000;
    SUBCLASS_OF_ID: 2218704517;
    classType: "request";
    className: "account.InitTakeoutSession";
    static fromReader(reader: Reader): InitTakeoutSession;
      // flags: null;
      contacts?: boolean;
      messageUsers?: boolean;
      messageChats?: boolean;
      messageMegagroups?: boolean;
      messageChannels?: boolean;
      files?: boolean;
      fileMaxSize?: long;
    }
    export class FinishTakeoutSession extends Request<Partial<{
      // flags: null;
      success?: boolean;
    }>, Bool> {
    CONSTRUCTOR_ID: 489050862;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.FinishTakeoutSession";
    static fromReader(reader: Reader): FinishTakeoutSession;
      // flags: null;
      success?: boolean;
    }
    export class ConfirmPasswordEmail extends Request<Partial<{
      code: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 2413762848;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ConfirmPasswordEmail";
    static fromReader(reader: Reader): ConfirmPasswordEmail;
      code: string;
    }
    export class ResendPasswordEmail extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2055154197;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResendPasswordEmail";
    static fromReader(reader: Reader): ResendPasswordEmail;
}
    export class CancelPasswordEmail extends Request<void, Bool> {
    CONSTRUCTOR_ID: 3251361206;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.CancelPasswordEmail";
    static fromReader(reader: Reader): CancelPasswordEmail;
}
    export class GetContactSignUpNotification extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2668087080;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.GetContactSignUpNotification";
    static fromReader(reader: Reader): GetContactSignUpNotification;
}
    export class SetContactSignUpNotification extends Request<Partial<{
      silent: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 3488890721;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SetContactSignUpNotification";
    static fromReader(reader: Reader): SetContactSignUpNotification;
      silent: Bool;
    }
    export class GetNotifyExceptions extends Request<Partial<{
      // flags: null;
      compareSound?: boolean;
      compareStories?: boolean;
      peer?: Api.TypeInputNotifyPeer;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1398240377;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "account.GetNotifyExceptions";
    static fromReader(reader: Reader): GetNotifyExceptions;
      // flags: null;
      compareSound?: boolean;
      compareStories?: boolean;
      peer?: Api.TypeInputNotifyPeer;
    }
    export class GetWallPaper extends Request<Partial<{
      wallpaper: Api.TypeInputWallPaper;
    }>, Api.TypeWallPaper> {
    CONSTRUCTOR_ID: 4237155306;
    SUBCLASS_OF_ID: 2527250827;
    classType: "request";
    className: "account.GetWallPaper";
    static fromReader(reader: Reader): GetWallPaper;
      wallpaper: Api.TypeInputWallPaper;
    }
    export class UploadWallPaper extends Request<Partial<{
      // flags: null;
      forChat?: boolean;
      file: Api.TypeInputFile;
      mimeType: string;
      settings: Api.TypeWallPaperSettings;
    }>, Api.TypeWallPaper> {
    CONSTRUCTOR_ID: 3818557187;
    SUBCLASS_OF_ID: 2527250827;
    classType: "request";
    className: "account.UploadWallPaper";
    static fromReader(reader: Reader): UploadWallPaper;
      // flags: null;
      forChat?: boolean;
      file: Api.TypeInputFile;
      mimeType: string;
      settings: Api.TypeWallPaperSettings;
    }
    export class SaveWallPaper extends Request<Partial<{
      wallpaper: Api.TypeInputWallPaper;
      unsave: Bool;
      settings: Api.TypeWallPaperSettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 1817860919;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SaveWallPaper";
    static fromReader(reader: Reader): SaveWallPaper;
      wallpaper: Api.TypeInputWallPaper;
      unsave: Bool;
      settings: Api.TypeWallPaperSettings;
    }
    export class InstallWallPaper extends Request<Partial<{
      wallpaper: Api.TypeInputWallPaper;
      settings: Api.TypeWallPaperSettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 4276967273;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.InstallWallPaper";
    static fromReader(reader: Reader): InstallWallPaper;
      wallpaper: Api.TypeInputWallPaper;
      settings: Api.TypeWallPaperSettings;
    }
    export class ResetWallPapers extends Request<void, Bool> {
    CONSTRUCTOR_ID: 3141244932;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ResetWallPapers";
    static fromReader(reader: Reader): ResetWallPapers;
}
    export class GetAutoDownloadSettings extends Request<void, account.TypeAutoDownloadSettings> {
    CONSTRUCTOR_ID: 1457130303;
    SUBCLASS_OF_ID: 800610593;
    classType: "request";
    className: "account.GetAutoDownloadSettings";
    static fromReader(reader: Reader): GetAutoDownloadSettings;
}
    export class SaveAutoDownloadSettings extends Request<Partial<{
      // flags: null;
      low?: boolean;
      high?: boolean;
      settings: Api.TypeAutoDownloadSettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 1995661875;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SaveAutoDownloadSettings";
    static fromReader(reader: Reader): SaveAutoDownloadSettings;
      // flags: null;
      low?: boolean;
      high?: boolean;
      settings: Api.TypeAutoDownloadSettings;
    }
    export class UploadTheme extends Request<Partial<{
      // flags: null;
      file: Api.TypeInputFile;
      thumb?: Api.TypeInputFile;
      fileName: string;
      mimeType: string;
    }>, Api.TypeDocument> {
    CONSTRUCTOR_ID: 473805619;
    SUBCLASS_OF_ID: 555739168;
    classType: "request";
    className: "account.UploadTheme";
    static fromReader(reader: Reader): UploadTheme;
      // flags: null;
      file: Api.TypeInputFile;
      thumb?: Api.TypeInputFile;
      fileName: string;
      mimeType: string;
    }
    export class CreateTheme extends Request<Partial<{
      // flags: null;
      slug: string;
      title: string;
      document?: Api.TypeInputDocument;
      settings?: Api.TypeInputThemeSettings[];
    }>, Api.TypeTheme> {
    CONSTRUCTOR_ID: 1697530880;
    SUBCLASS_OF_ID: 1454688268;
    classType: "request";
    className: "account.CreateTheme";
    static fromReader(reader: Reader): CreateTheme;
      // flags: null;
      slug: string;
      title: string;
      document?: Api.TypeInputDocument;
      settings?: Api.TypeInputThemeSettings[];
    }
    export class UpdateTheme extends Request<Partial<{
      // flags: null;
      format: string;
      theme: Api.TypeInputTheme;
      slug?: string;
      title?: string;
      document?: Api.TypeInputDocument;
      settings?: Api.TypeInputThemeSettings[];
    }>, Api.TypeTheme> {
    CONSTRUCTOR_ID: 737414348;
    SUBCLASS_OF_ID: 1454688268;
    classType: "request";
    className: "account.UpdateTheme";
    static fromReader(reader: Reader): UpdateTheme;
      // flags: null;
      format: string;
      theme: Api.TypeInputTheme;
      slug?: string;
      title?: string;
      document?: Api.TypeInputDocument;
      settings?: Api.TypeInputThemeSettings[];
    }
    export class SaveTheme extends Request<Partial<{
      theme: Api.TypeInputTheme;
      unsave: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 4065792108;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SaveTheme";
    static fromReader(reader: Reader): SaveTheme;
      theme: Api.TypeInputTheme;
      unsave: Bool;
    }
    export class InstallTheme extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      theme?: Api.TypeInputTheme;
      format?: string;
      baseTheme?: Api.TypeBaseTheme;
    }>, Bool> {
    CONSTRUCTOR_ID: 3341269819;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.InstallTheme";
    static fromReader(reader: Reader): InstallTheme;
      // flags: null;
      dark?: boolean;
      theme?: Api.TypeInputTheme;
      format?: string;
      baseTheme?: Api.TypeBaseTheme;
    }
    export class GetTheme extends Request<Partial<{
      format: string;
      theme: Api.TypeInputTheme;
    }>, Api.TypeTheme> {
    CONSTRUCTOR_ID: 978872812;
    SUBCLASS_OF_ID: 1454688268;
    classType: "request";
    className: "account.GetTheme";
    static fromReader(reader: Reader): GetTheme;
      format: string;
      theme: Api.TypeInputTheme;
    }
    export class GetThemes extends Request<Partial<{
      format: string;
      hash: long;
    }>, account.TypeThemes> {
    CONSTRUCTOR_ID: 1913054296;
    SUBCLASS_OF_ID: 2143625732;
    classType: "request";
    className: "account.GetThemes";
    static fromReader(reader: Reader): GetThemes;
      format: string;
      hash: long;
    }
    export class SetContentSettings extends Request<Partial<{
      // flags: null;
      sensitiveEnabled?: boolean;
    }>, Bool> {
    CONSTRUCTOR_ID: 3044323691;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SetContentSettings";
    static fromReader(reader: Reader): SetContentSettings;
      // flags: null;
      sensitiveEnabled?: boolean;
    }
    export class GetContentSettings extends Request<void, account.TypeContentSettings> {
    CONSTRUCTOR_ID: 2342210990;
    SUBCLASS_OF_ID: 2923427985;
    classType: "request";
    className: "account.GetContentSettings";
    static fromReader(reader: Reader): GetContentSettings;
}
    export class GetMultiWallPapers extends Request<Partial<{
      wallpapers: Api.TypeInputWallPaper[];
    }>, Api.TypeWallPaper[]> {
    CONSTRUCTOR_ID: 1705865692;
    SUBCLASS_OF_ID: 2395165315;
    classType: "request";
    className: "account.GetMultiWallPapers";
    static fromReader(reader: Reader): GetMultiWallPapers;
      wallpapers: Api.TypeInputWallPaper[];
    }
    export class GetGlobalPrivacySettings extends Request<void, Api.TypeGlobalPrivacySettings> {
    CONSTRUCTOR_ID: 3945483510;
    SUBCLASS_OF_ID: 3373160304;
    classType: "request";
    className: "account.GetGlobalPrivacySettings";
    static fromReader(reader: Reader): GetGlobalPrivacySettings;
}
    export class SetGlobalPrivacySettings extends Request<Partial<{
      settings: Api.TypeGlobalPrivacySettings;
    }>, Api.TypeGlobalPrivacySettings> {
    CONSTRUCTOR_ID: 517647042;
    SUBCLASS_OF_ID: 3373160304;
    classType: "request";
    className: "account.SetGlobalPrivacySettings";
    static fromReader(reader: Reader): SetGlobalPrivacySettings;
      settings: Api.TypeGlobalPrivacySettings;
    }
    export class ReportProfilePhoto extends Request<Partial<{
      peer: Api.TypeEntityLike;
      photoId: Api.TypeInputPhoto;
      reason: Api.TypeReportReason;
      message: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 4203529973;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ReportProfilePhoto";
    static fromReader(reader: Reader): ReportProfilePhoto;
      peer: Api.TypeEntityLike;
      photoId: Api.TypeInputPhoto;
      reason: Api.TypeReportReason;
      message: string;
    }
    export class ResetPassword extends Request<void, account.TypeResetPasswordResult> {
    CONSTRUCTOR_ID: 2466827803;
    SUBCLASS_OF_ID: 1230009366;
    classType: "request";
    className: "account.ResetPassword";
    static fromReader(reader: Reader): ResetPassword;
}
    export class DeclinePasswordReset extends Request<void, Bool> {
    CONSTRUCTOR_ID: 1284770294;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DeclinePasswordReset";
    static fromReader(reader: Reader): DeclinePasswordReset;
}
    export class GetChatThemes extends Request<Partial<{
      hash: long;
    }>, account.TypeThemes> {
    CONSTRUCTOR_ID: 3594051209;
    SUBCLASS_OF_ID: 2143625732;
    classType: "request";
    className: "account.GetChatThemes";
    static fromReader(reader: Reader): GetChatThemes;
      hash: long;
    }
    export class SetAuthorizationTTL extends Request<Partial<{
      authorizationTtlDays: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 3213466272;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SetAuthorizationTTL";
    static fromReader(reader: Reader): SetAuthorizationTTL;
      authorizationTtlDays: int;
    }
    export class ChangeAuthorizationSettings extends Request<Partial<{
      // flags: null;
      confirmed?: boolean;
      hash: long;
      encryptedRequestsDisabled?: Bool;
      callRequestsDisabled?: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1089766498;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ChangeAuthorizationSettings";
    static fromReader(reader: Reader): ChangeAuthorizationSettings;
      // flags: null;
      confirmed?: boolean;
      hash: long;
      encryptedRequestsDisabled?: Bool;
      callRequestsDisabled?: Bool;
    }
    export class GetSavedRingtones extends Request<Partial<{
      hash: long;
    }>, account.TypeSavedRingtones> {
    CONSTRUCTOR_ID: 3784319624;
    SUBCLASS_OF_ID: 666683742;
    classType: "request";
    className: "account.GetSavedRingtones";
    static fromReader(reader: Reader): GetSavedRingtones;
      hash: long;
    }
    export class SaveRingtone extends Request<Partial<{
      id: Api.TypeInputDocument;
      unsave: Bool;
    }>, account.TypeSavedRingtone> {
    CONSTRUCTOR_ID: 1038768899;
    SUBCLASS_OF_ID: 2984412196;
    classType: "request";
    className: "account.SaveRingtone";
    static fromReader(reader: Reader): SaveRingtone;
      id: Api.TypeInputDocument;
      unsave: Bool;
    }
    export class UploadRingtone extends Request<Partial<{
      file: Api.TypeInputFile;
      fileName: string;
      mimeType: string;
    }>, Api.TypeDocument> {
    CONSTRUCTOR_ID: 2199552930;
    SUBCLASS_OF_ID: 555739168;
    classType: "request";
    className: "account.UploadRingtone";
    static fromReader(reader: Reader): UploadRingtone;
      file: Api.TypeInputFile;
      fileName: string;
      mimeType: string;
    }
    export class UpdateEmojiStatus extends Request<Partial<{
      emojiStatus: Api.TypeEmojiStatus;
    }>, Bool> {
    CONSTRUCTOR_ID: 4224966251;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateEmojiStatus";
    static fromReader(reader: Reader): UpdateEmojiStatus;
      emojiStatus: Api.TypeEmojiStatus;
    }
    export class GetDefaultEmojiStatuses extends Request<Partial<{
      hash: long;
    }>, account.TypeEmojiStatuses> {
    CONSTRUCTOR_ID: 3598005126;
    SUBCLASS_OF_ID: 3554674122;
    classType: "request";
    className: "account.GetDefaultEmojiStatuses";
    static fromReader(reader: Reader): GetDefaultEmojiStatuses;
      hash: long;
    }
    export class GetRecentEmojiStatuses extends Request<Partial<{
      hash: long;
    }>, account.TypeEmojiStatuses> {
    CONSTRUCTOR_ID: 257392901;
    SUBCLASS_OF_ID: 3554674122;
    classType: "request";
    className: "account.GetRecentEmojiStatuses";
    static fromReader(reader: Reader): GetRecentEmojiStatuses;
      hash: long;
    }
    export class ClearRecentEmojiStatuses extends Request<void, Bool> {
    CONSTRUCTOR_ID: 404757166;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ClearRecentEmojiStatuses";
    static fromReader(reader: Reader): ClearRecentEmojiStatuses;
}
    export class ReorderUsernames extends Request<Partial<{
      order: string[];
    }>, Bool> {
    CONSTRUCTOR_ID: 4015001259;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ReorderUsernames";
    static fromReader(reader: Reader): ReorderUsernames;
      order: string[];
    }
    export class ToggleUsername extends Request<Partial<{
      username: string;
      active: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1490465654;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ToggleUsername";
    static fromReader(reader: Reader): ToggleUsername;
      username: string;
      active: Bool;
    }
    export class GetDefaultProfilePhotoEmojis extends Request<Partial<{
      hash: long;
    }>, Api.TypeEmojiList> {
    CONSTRUCTOR_ID: 3799319336;
    SUBCLASS_OF_ID: 3169807034;
    classType: "request";
    className: "account.GetDefaultProfilePhotoEmojis";
    static fromReader(reader: Reader): GetDefaultProfilePhotoEmojis;
      hash: long;
    }
    export class GetDefaultGroupPhotoEmojis extends Request<Partial<{
      hash: long;
    }>, Api.TypeEmojiList> {
    CONSTRUCTOR_ID: 2438488238;
    SUBCLASS_OF_ID: 3169807034;
    classType: "request";
    className: "account.GetDefaultGroupPhotoEmojis";
    static fromReader(reader: Reader): GetDefaultGroupPhotoEmojis;
      hash: long;
    }
    export class GetAutoSaveSettings extends Request<void, account.TypeAutoSaveSettings> {
    CONSTRUCTOR_ID: 2915810522;
    SUBCLASS_OF_ID: 1221537538;
    classType: "request";
    className: "account.GetAutoSaveSettings";
    static fromReader(reader: Reader): GetAutoSaveSettings;
}
    export class SaveAutoSaveSettings extends Request<Partial<{
      // flags: null;
      users?: boolean;
      chats?: boolean;
      broadcasts?: boolean;
      peer?: Api.TypeEntityLike;
      settings: Api.TypeAutoSaveSettings;
    }>, Bool> {
    CONSTRUCTOR_ID: 3600515937;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.SaveAutoSaveSettings";
    static fromReader(reader: Reader): SaveAutoSaveSettings;
      // flags: null;
      users?: boolean;
      chats?: boolean;
      broadcasts?: boolean;
      peer?: Api.TypeEntityLike;
      settings: Api.TypeAutoSaveSettings;
    }
    export class DeleteAutoSaveExceptions extends Request<void, Bool> {
    CONSTRUCTOR_ID: 1404829728;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DeleteAutoSaveExceptions";
    static fromReader(reader: Reader): DeleteAutoSaveExceptions;
}
    export class InvalidateSignInCodes extends Request<Partial<{
      codes: string[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3398101178;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.InvalidateSignInCodes";
    static fromReader(reader: Reader): InvalidateSignInCodes;
      codes: string[];
    }
    export class UpdateColor extends Request<Partial<{
      // flags: null;
      forProfile?: boolean;
      color?: int;
      backgroundEmojiId?: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 2096079197;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateColor";
    static fromReader(reader: Reader): UpdateColor;
      // flags: null;
      forProfile?: boolean;
      color?: int;
      backgroundEmojiId?: long;
    }
    export class GetDefaultBackgroundEmojis extends Request<Partial<{
      hash: long;
    }>, Api.TypeEmojiList> {
    CONSTRUCTOR_ID: 2785720782;
    SUBCLASS_OF_ID: 3169807034;
    classType: "request";
    className: "account.GetDefaultBackgroundEmojis";
    static fromReader(reader: Reader): GetDefaultBackgroundEmojis;
      hash: long;
    }
    export class GetChannelDefaultEmojiStatuses extends Request<Partial<{
      hash: long;
    }>, account.TypeEmojiStatuses> {
    CONSTRUCTOR_ID: 1999087573;
    SUBCLASS_OF_ID: 3554674122;
    classType: "request";
    className: "account.GetChannelDefaultEmojiStatuses";
    static fromReader(reader: Reader): GetChannelDefaultEmojiStatuses;
      hash: long;
    }
    export class GetChannelRestrictedStatusEmojis extends Request<Partial<{
      hash: long;
    }>, Api.TypeEmojiList> {
    CONSTRUCTOR_ID: 900325589;
    SUBCLASS_OF_ID: 3169807034;
    classType: "request";
    className: "account.GetChannelRestrictedStatusEmojis";
    static fromReader(reader: Reader): GetChannelRestrictedStatusEmojis;
      hash: long;
    }
    export class UpdateBusinessWorkHours extends Request<Partial<{
      // flags: null;
      businessWorkHours?: Api.TypeBusinessWorkHours;
    }>, Bool> {
    CONSTRUCTOR_ID: 1258348646;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBusinessWorkHours";
    static fromReader(reader: Reader): UpdateBusinessWorkHours;
      // flags: null;
      businessWorkHours?: Api.TypeBusinessWorkHours;
    }
    export class UpdateBusinessLocation extends Request<Partial<{
      // flags: null;
      geoPoint?: Api.TypeInputGeoPoint;
      address?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 2657817370;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBusinessLocation";
    static fromReader(reader: Reader): UpdateBusinessLocation;
      // flags: null;
      geoPoint?: Api.TypeInputGeoPoint;
      address?: string;
    }
    export class UpdateBusinessGreetingMessage extends Request<Partial<{
      // flags: null;
      message?: Api.TypeInputBusinessGreetingMessage;
    }>, Bool> {
    CONSTRUCTOR_ID: 1724755908;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBusinessGreetingMessage";
    static fromReader(reader: Reader): UpdateBusinessGreetingMessage;
      // flags: null;
      message?: Api.TypeInputBusinessGreetingMessage;
    }
    export class UpdateBusinessAwayMessage extends Request<Partial<{
      // flags: null;
      message?: Api.TypeInputBusinessAwayMessage;
    }>, Bool> {
    CONSTRUCTOR_ID: 2724888485;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBusinessAwayMessage";
    static fromReader(reader: Reader): UpdateBusinessAwayMessage;
      // flags: null;
      message?: Api.TypeInputBusinessAwayMessage;
    }
    export class UpdateConnectedBot extends Request<Partial<{
      // flags: null;
      canReply?: boolean;
      deleted?: boolean;
      bot: Api.TypeEntityLike;
      recipients: Api.TypeInputBusinessBotRecipients;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1138250269;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "account.UpdateConnectedBot";
    static fromReader(reader: Reader): UpdateConnectedBot;
      // flags: null;
      canReply?: boolean;
      deleted?: boolean;
      bot: Api.TypeEntityLike;
      recipients: Api.TypeInputBusinessBotRecipients;
    }
    export class GetConnectedBots extends Request<void, account.TypeConnectedBots> {
    CONSTRUCTOR_ID: 1319421967;
    SUBCLASS_OF_ID: 3838506963;
    classType: "request";
    className: "account.GetConnectedBots";
    static fromReader(reader: Reader): GetConnectedBots;
}
    export class GetBotBusinessConnection extends Request<Partial<{
      connectionId: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1990746736;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "account.GetBotBusinessConnection";
    static fromReader(reader: Reader): GetBotBusinessConnection;
      connectionId: string;
    }
    export class UpdateBusinessIntro extends Request<Partial<{
      // flags: null;
      intro?: Api.TypeInputBusinessIntro;
    }>, Bool> {
    CONSTRUCTOR_ID: 2786381876;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBusinessIntro";
    static fromReader(reader: Reader): UpdateBusinessIntro;
      // flags: null;
      intro?: Api.TypeInputBusinessIntro;
    }
    export class ToggleConnectedBotPaused extends Request<Partial<{
      peer: Api.TypeEntityLike;
      paused: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1684934807;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ToggleConnectedBotPaused";
    static fromReader(reader: Reader): ToggleConnectedBotPaused;
      peer: Api.TypeEntityLike;
      paused: Bool;
    }
    export class DisablePeerConnectedBot extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1581481689;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DisablePeerConnectedBot";
    static fromReader(reader: Reader): DisablePeerConnectedBot;
      peer: Api.TypeEntityLike;
    }
    export class UpdateBirthday extends Request<Partial<{
      // flags: null;
      birthday?: Api.TypeBirthday;
    }>, Bool> {
    CONSTRUCTOR_ID: 3429764113;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdateBirthday";
    static fromReader(reader: Reader): UpdateBirthday;
      // flags: null;
      birthday?: Api.TypeBirthday;
    }
    export class CreateBusinessChatLink extends Request<Partial<{
      link: Api.TypeInputBusinessChatLink;
    }>, Api.TypeBusinessChatLink> {
    CONSTRUCTOR_ID: 2287068814;
    SUBCLASS_OF_ID: 1007504011;
    classType: "request";
    className: "account.CreateBusinessChatLink";
    static fromReader(reader: Reader): CreateBusinessChatLink;
      link: Api.TypeInputBusinessChatLink;
    }
    export class EditBusinessChatLink extends Request<Partial<{
      slug: string;
      link: Api.TypeInputBusinessChatLink;
    }>, Api.TypeBusinessChatLink> {
    CONSTRUCTOR_ID: 2352222383;
    SUBCLASS_OF_ID: 1007504011;
    classType: "request";
    className: "account.EditBusinessChatLink";
    static fromReader(reader: Reader): EditBusinessChatLink;
      slug: string;
      link: Api.TypeInputBusinessChatLink;
    }
    export class DeleteBusinessChatLink extends Request<Partial<{
      slug: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1611085428;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.DeleteBusinessChatLink";
    static fromReader(reader: Reader): DeleteBusinessChatLink;
      slug: string;
    }
    export class GetBusinessChatLinks extends Request<void, account.TypeBusinessChatLinks> {
    CONSTRUCTOR_ID: 1869667809;
    SUBCLASS_OF_ID: 3334097457;
    classType: "request";
    className: "account.GetBusinessChatLinks";
    static fromReader(reader: Reader): GetBusinessChatLinks;
}
    export class ResolveBusinessChatLink extends Request<Partial<{
      slug: string;
    }>, account.TypeResolvedBusinessChatLinks> {
    CONSTRUCTOR_ID: 1418913262;
    SUBCLASS_OF_ID: 980888616;
    classType: "request";
    className: "account.ResolveBusinessChatLink";
    static fromReader(reader: Reader): ResolveBusinessChatLink;
      slug: string;
    }
    export class UpdatePersonalChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3645048288;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.UpdatePersonalChannel";
    static fromReader(reader: Reader): UpdatePersonalChannel;
      channel: Api.TypeEntityLike;
    }
    export class ToggleSponsoredMessages extends Request<Partial<{
      enabled: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 3118048141;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "account.ToggleSponsoredMessages";
    static fromReader(reader: Reader): ToggleSponsoredMessages;
      enabled: Bool;
    }
    export class GetReactionsNotifySettings extends Request<void, Api.TypeReactionsNotifySettings> {
    CONSTRUCTOR_ID: 115172684;
    SUBCLASS_OF_ID: 2382301265;
    classType: "request";
    className: "account.GetReactionsNotifySettings";
    static fromReader(reader: Reader): GetReactionsNotifySettings;
}
    export class SetReactionsNotifySettings extends Request<Partial<{
      settings: Api.TypeReactionsNotifySettings;
    }>, Api.TypeReactionsNotifySettings> {
    CONSTRUCTOR_ID: 829220168;
    SUBCLASS_OF_ID: 2382301265;
    classType: "request";
    className: "account.SetReactionsNotifySettings";
    static fromReader(reader: Reader): SetReactionsNotifySettings;
      settings: Api.TypeReactionsNotifySettings;
    }
    export class GetCollectibleEmojiStatuses extends Request<Partial<{
      hash: long;
    }>, account.TypeEmojiStatuses> {
    CONSTRUCTOR_ID: 779830595;
    SUBCLASS_OF_ID: 3554674122;
    classType: "request";
    className: "account.GetCollectibleEmojiStatuses";
    static fromReader(reader: Reader): GetCollectibleEmojiStatuses;
      hash: long;
    }
  }

  export namespace users {
    export class GetUsers extends Request<Partial<{
      id: Api.TypeEntityLike[];
    }>, Api.TypeUser[]> {
    CONSTRUCTOR_ID: 227648840;
    SUBCLASS_OF_ID: 67557965;
    classType: "request";
    className: "users.GetUsers";
    static fromReader(reader: Reader): GetUsers;
      id: Api.TypeEntityLike[];
    }
    export class GetFullUser extends Request<Partial<{
      id: Api.TypeEntityLike;
    }>, users.TypeUserFull> {
    CONSTRUCTOR_ID: 3054459160;
    SUBCLASS_OF_ID: 2212470261;
    classType: "request";
    className: "users.GetFullUser";
    static fromReader(reader: Reader): GetFullUser;
      id: Api.TypeEntityLike;
    }
    export class SetSecureValueErrors extends Request<Partial<{
      id: Api.TypeEntityLike;
      errors: Api.TypeSecureValueError[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2429064373;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "users.SetSecureValueErrors";
    static fromReader(reader: Reader): SetSecureValueErrors;
      id: Api.TypeEntityLike;
      errors: Api.TypeSecureValueError[];
    }
    export class GetIsPremiumRequiredToContact extends Request<Partial<{
      id: Api.TypeEntityLike[];
    }>, Bool[]> {
    CONSTRUCTOR_ID: 2787289616;
    SUBCLASS_OF_ID: 366986225;
    classType: "request";
    className: "users.GetIsPremiumRequiredToContact";
    static fromReader(reader: Reader): GetIsPremiumRequiredToContact;
      id: Api.TypeEntityLike[];
    }
  }

  export namespace contacts {
    export class GetContactIDs extends Request<Partial<{
      hash: long;
    }>, int[]> {
    CONSTRUCTOR_ID: 2061264541;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "contacts.GetContactIDs";
    static fromReader(reader: Reader): GetContactIDs;
      hash: long;
    }
    export class GetStatuses extends Request<void, Api.TypeContactStatus[]> {
    CONSTRUCTOR_ID: 3299038190;
    SUBCLASS_OF_ID: 3749797008;
    classType: "request";
    className: "contacts.GetStatuses";
    static fromReader(reader: Reader): GetStatuses;
}
    export class GetContacts extends Request<Partial<{
      hash: long;
    }>, contacts.TypeContacts> {
    CONSTRUCTOR_ID: 1574346258;
    SUBCLASS_OF_ID: 951985654;
    classType: "request";
    className: "contacts.GetContacts";
    static fromReader(reader: Reader): GetContacts;
      hash: long;
    }
    export class ImportContacts extends Request<Partial<{
      contacts: Api.TypeInputContact[];
    }>, contacts.TypeImportedContacts> {
    CONSTRUCTOR_ID: 746589157;
    SUBCLASS_OF_ID: 2171776403;
    classType: "request";
    className: "contacts.ImportContacts";
    static fromReader(reader: Reader): ImportContacts;
      contacts: Api.TypeInputContact[];
    }
    export class DeleteContacts extends Request<Partial<{
      id: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 157945344;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "contacts.DeleteContacts";
    static fromReader(reader: Reader): DeleteContacts;
      id: Api.TypeEntityLike[];
    }
    export class DeleteByPhones extends Request<Partial<{
      phones: string[];
    }>, Bool> {
    CONSTRUCTOR_ID: 269745566;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.DeleteByPhones";
    static fromReader(reader: Reader): DeleteByPhones;
      phones: string[];
    }
    export class Block extends Request<Partial<{
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 774801204;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.Block";
    static fromReader(reader: Reader): Block;
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike;
    }
    export class Unblock extends Request<Partial<{
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3041973032;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.Unblock";
    static fromReader(reader: Reader): Unblock;
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike;
    }
    export class GetBlocked extends Request<Partial<{
      // flags: null;
      myStoriesFrom?: boolean;
      offset: int;
      limit: int;
    }>, contacts.TypeBlocked> {
    CONSTRUCTOR_ID: 2592509824;
    SUBCLASS_OF_ID: 4290400079;
    classType: "request";
    className: "contacts.GetBlocked";
    static fromReader(reader: Reader): GetBlocked;
      // flags: null;
      myStoriesFrom?: boolean;
      offset: int;
      limit: int;
    }
    export class Search extends Request<Partial<{
      q: string;
      limit: int;
    }>, contacts.TypeFound> {
    CONSTRUCTOR_ID: 301470424;
    SUBCLASS_OF_ID: 1132896995;
    classType: "request";
    className: "contacts.Search";
    static fromReader(reader: Reader): Search;
      q: string;
      limit: int;
    }
    export class ResolveUsername extends Request<Partial<{
      // flags: null;
      username: string;
      referer?: string;
    }>, contacts.TypeResolvedPeer> {
    CONSTRUCTOR_ID: 1918565308;
    SUBCLASS_OF_ID: 4033196968;
    classType: "request";
    className: "contacts.ResolveUsername";
    static fromReader(reader: Reader): ResolveUsername;
      // flags: null;
      username: string;
      referer?: string;
    }
    export class GetTopPeers extends Request<Partial<{
      // flags: null;
      correspondents?: boolean;
      botsPm?: boolean;
      botsInline?: boolean;
      phoneCalls?: boolean;
      forwardUsers?: boolean;
      forwardChats?: boolean;
      groups?: boolean;
      channels?: boolean;
      botsApp?: boolean;
      offset: int;
      limit: int;
      hash: long;
    }>, contacts.TypeTopPeers> {
    CONSTRUCTOR_ID: 2536798390;
    SUBCLASS_OF_ID: 2666052488;
    classType: "request";
    className: "contacts.GetTopPeers";
    static fromReader(reader: Reader): GetTopPeers;
      // flags: null;
      correspondents?: boolean;
      botsPm?: boolean;
      botsInline?: boolean;
      phoneCalls?: boolean;
      forwardUsers?: boolean;
      forwardChats?: boolean;
      groups?: boolean;
      channels?: boolean;
      botsApp?: boolean;
      offset: int;
      limit: int;
      hash: long;
    }
    export class ResetTopPeerRating extends Request<Partial<{
      category: Api.TypeTopPeerCategory;
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 451113900;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.ResetTopPeerRating";
    static fromReader(reader: Reader): ResetTopPeerRating;
      category: Api.TypeTopPeerCategory;
      peer: Api.TypeEntityLike;
    }
    export class ResetSaved extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2274703345;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.ResetSaved";
    static fromReader(reader: Reader): ResetSaved;
}
    export class GetSaved extends Request<void, Api.TypeSavedContact[]> {
    CONSTRUCTOR_ID: 2196890527;
    SUBCLASS_OF_ID: 158718959;
    classType: "request";
    className: "contacts.GetSaved";
    static fromReader(reader: Reader): GetSaved;
}
    export class ToggleTopPeers extends Request<Partial<{
      enabled: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2232729050;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.ToggleTopPeers";
    static fromReader(reader: Reader): ToggleTopPeers;
      enabled: Bool;
    }
    export class AddContact extends Request<Partial<{
      // flags: null;
      addPhonePrivacyException?: boolean;
      id: Api.TypeEntityLike;
      firstName: string;
      lastName: string;
      phone: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3908330448;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "contacts.AddContact";
    static fromReader(reader: Reader): AddContact;
      // flags: null;
      addPhonePrivacyException?: boolean;
      id: Api.TypeEntityLike;
      firstName: string;
      lastName: string;
      phone: string;
    }
    export class AcceptContact extends Request<Partial<{
      id: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4164002319;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "contacts.AcceptContact";
    static fromReader(reader: Reader): AcceptContact;
      id: Api.TypeEntityLike;
    }
    export class GetLocated extends Request<Partial<{
      // flags: null;
      background?: boolean;
      geoPoint: Api.TypeInputGeoPoint;
      selfExpires?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3544759364;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "contacts.GetLocated";
    static fromReader(reader: Reader): GetLocated;
      // flags: null;
      background?: boolean;
      geoPoint: Api.TypeInputGeoPoint;
      selfExpires?: int;
    }
    export class BlockFromReplies extends Request<Partial<{
      // flags: null;
      deleteMessage?: boolean;
      deleteHistory?: boolean;
      reportSpam?: boolean;
      msgId: MessageIDLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 698914348;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "contacts.BlockFromReplies";
    static fromReader(reader: Reader): BlockFromReplies;
      // flags: null;
      deleteMessage?: boolean;
      deleteHistory?: boolean;
      reportSpam?: boolean;
      msgId: MessageIDLike;
    }
    export class ResolvePhone extends Request<Partial<{
      phone: string;
    }>, contacts.TypeResolvedPeer> {
    CONSTRUCTOR_ID: 2331591492;
    SUBCLASS_OF_ID: 4033196968;
    classType: "request";
    className: "contacts.ResolvePhone";
    static fromReader(reader: Reader): ResolvePhone;
      phone: string;
    }
    export class ExportContactToken extends Request<void, Api.TypeExportedContactToken> {
    CONSTRUCTOR_ID: 4167385127;
    SUBCLASS_OF_ID: 2262679249;
    classType: "request";
    className: "contacts.ExportContactToken";
    static fromReader(reader: Reader): ExportContactToken;
}
    export class ImportContactToken extends Request<Partial<{
      token: string;
    }>, Api.TypeUser> {
    CONSTRUCTOR_ID: 318789512;
    SUBCLASS_OF_ID: 765557111;
    classType: "request";
    className: "contacts.ImportContactToken";
    static fromReader(reader: Reader): ImportContactToken;
      token: string;
    }
    export class EditCloseFriends extends Request<Partial<{
      id: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3127313904;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.EditCloseFriends";
    static fromReader(reader: Reader): EditCloseFriends;
      id: long[];
    }
    export class SetBlocked extends Request<Partial<{
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike[];
      limit: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 2496027766;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "contacts.SetBlocked";
    static fromReader(reader: Reader): SetBlocked;
      // flags: null;
      myStoriesFrom?: boolean;
      id: Api.TypeEntityLike[];
      limit: int;
    }
    export class GetBirthdays extends Request<void, contacts.TypeContactBirthdays> {
    CONSTRUCTOR_ID: 3673008228;
    SUBCLASS_OF_ID: 242920447;
    classType: "request";
    className: "contacts.GetBirthdays";
    static fromReader(reader: Reader): GetBirthdays;
}
  }

  export namespace messages {
    export class GetMessages extends Request<Partial<{
      id: Api.TypeInputMessage[];
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 1673946374;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetMessages";
    static fromReader(reader: Reader): GetMessages;
      id: Api.TypeInputMessage[];
    }
    export class GetDialogs extends Request<Partial<{
      // flags: null;
      excludePinned?: boolean;
      folderId?: int;
      offsetDate: int;
      offsetId: int;
      offsetPeer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }>, messages.TypeDialogs> {
    CONSTRUCTOR_ID: 2700397391;
    SUBCLASS_OF_ID: 236671726;
    classType: "request";
    className: "messages.GetDialogs";
    static fromReader(reader: Reader): GetDialogs;
      // flags: null;
      excludePinned?: boolean;
      folderId?: int;
      offsetDate: int;
      offsetId: int;
      offsetPeer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }
    export class GetHistory extends Request<Partial<{
      peer: Api.TypeEntityLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 1143203525;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetHistory";
    static fromReader(reader: Reader): GetHistory;
      peer: Api.TypeEntityLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }
    export class Search extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      q: string;
      fromId?: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      savedReaction?: Api.TypeReaction[];
      topMsgId?: MessageIDLike;
      filter: Api.TypeMessagesFilter;
      minDate: int;
      maxDate: int;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 703497338;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.Search";
    static fromReader(reader: Reader): Search;
      // flags: null;
      peer: Api.TypeEntityLike;
      q: string;
      fromId?: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      savedReaction?: Api.TypeReaction[];
      topMsgId?: MessageIDLike;
      filter: Api.TypeMessagesFilter;
      minDate: int;
      maxDate: int;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }
    export class ReadHistory extends Request<Partial<{
      peer: Api.TypeEntityLike;
      maxId: int;
    }>, messages.TypeAffectedMessages> {
    CONSTRUCTOR_ID: 238054714;
    SUBCLASS_OF_ID: 3469983854;
    classType: "request";
    className: "messages.ReadHistory";
    static fromReader(reader: Reader): ReadHistory;
      peer: Api.TypeEntityLike;
      maxId: int;
    }
    export class DeleteHistory extends Request<Partial<{
      // flags: null;
      justClear?: boolean;
      revoke?: boolean;
      peer: Api.TypeEntityLike;
      maxId: int;
      minDate?: int;
      maxDate?: int;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 2962199082;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "messages.DeleteHistory";
    static fromReader(reader: Reader): DeleteHistory;
      // flags: null;
      justClear?: boolean;
      revoke?: boolean;
      peer: Api.TypeEntityLike;
      maxId: int;
      minDate?: int;
      maxDate?: int;
    }
    export class DeleteMessages extends Request<Partial<{
      // flags: null;
      revoke?: boolean;
      id: int[];
    }>, messages.TypeAffectedMessages> {
    CONSTRUCTOR_ID: 3851326930;
    SUBCLASS_OF_ID: 3469983854;
    classType: "request";
    className: "messages.DeleteMessages";
    static fromReader(reader: Reader): DeleteMessages;
      // flags: null;
      revoke?: boolean;
      id: int[];
    }
    export class ReceivedMessages extends Request<Partial<{
      maxId: int;
    }>, Api.TypeReceivedNotifyMessage[]> {
    CONSTRUCTOR_ID: 94983360;
    SUBCLASS_OF_ID: 2238052503;
    classType: "request";
    className: "messages.ReceivedMessages";
    static fromReader(reader: Reader): ReceivedMessages;
      maxId: int;
    }
    export class SetTyping extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      action: Api.TypeSendMessageAction;
    }>, Bool> {
    CONSTRUCTOR_ID: 1486110434;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetTyping";
    static fromReader(reader: Reader): SetTyping;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      action: Api.TypeSendMessageAction;
    }
    export class SendMessage extends Request<Partial<{
      // flags: null;
      noWebpage?: boolean;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      message: string;
      randomId?: long;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2554304325;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendMessage";
    static fromReader(reader: Reader): SendMessage;
      // flags: null;
      noWebpage?: boolean;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      message: string;
      randomId?: long;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }
    export class SendMedia extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      media: Api.TypeInputMedia;
      message: string;
      randomId?: long;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2018673486;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendMedia";
    static fromReader(reader: Reader): SendMedia;
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      media: Api.TypeInputMedia;
      message: string;
      randomId?: long;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }
    export class ForwardMessages extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      background?: boolean;
      withMyScore?: boolean;
      dropAuthor?: boolean;
      dropMediaCaptions?: boolean;
      noforwards?: boolean;
      allowPaidFloodskip?: boolean;
      fromPeer: Api.TypeEntityLike;
      id: int[];
      randomId: long[];
      toPeer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      videoTimestamp?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1836374536;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.ForwardMessages";
    static fromReader(reader: Reader): ForwardMessages;
      // flags: null;
      silent?: boolean;
      background?: boolean;
      withMyScore?: boolean;
      dropAuthor?: boolean;
      dropMediaCaptions?: boolean;
      noforwards?: boolean;
      allowPaidFloodskip?: boolean;
      fromPeer: Api.TypeEntityLike;
      id: int[];
      randomId: long[];
      toPeer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      videoTimestamp?: int;
    }
    export class ReportSpam extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3474297563;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReportSpam";
    static fromReader(reader: Reader): ReportSpam;
      peer: Api.TypeEntityLike;
    }
    export class GetPeerSettings extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, messages.TypePeerSettings> {
    CONSTRUCTOR_ID: 4024018594;
    SUBCLASS_OF_ID: 1705179041;
    classType: "request";
    className: "messages.GetPeerSettings";
    static fromReader(reader: Reader): GetPeerSettings;
      peer: Api.TypeEntityLike;
    }
    export class Report extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
      option: bytes;
      message: string;
    }>, Api.TypeReportResult> {
    CONSTRUCTOR_ID: 4235767707;
    SUBCLASS_OF_ID: 2899571768;
    classType: "request";
    className: "messages.Report";
    static fromReader(reader: Reader): Report;
      peer: Api.TypeEntityLike;
      id: int[];
      option: bytes;
      message: string;
    }
    export class GetChats extends Request<Partial<{
      id: long[];
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 1240027791;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "messages.GetChats";
    static fromReader(reader: Reader): GetChats;
      id: long[];
    }
    export class GetFullChat extends Request<Partial<{
      chatId: long;
    }>, messages.TypeChatFull> {
    CONSTRUCTOR_ID: 2930772788;
    SUBCLASS_OF_ID: 576344329;
    classType: "request";
    className: "messages.GetFullChat";
    static fromReader(reader: Reader): GetFullChat;
      chatId: long;
    }
    export class EditChatTitle extends Request<Partial<{
      chatId: long;
      title: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1937260541;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.EditChatTitle";
    static fromReader(reader: Reader): EditChatTitle;
      chatId: long;
      title: string;
    }
    export class EditChatPhoto extends Request<Partial<{
      chatId: long;
      photo: Api.TypeInputChatPhoto;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 903730804;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.EditChatPhoto";
    static fromReader(reader: Reader): EditChatPhoto;
      chatId: long;
      photo: Api.TypeInputChatPhoto;
    }
    export class AddChatUser extends Request<Partial<{
      chatId: long;
      userId: Api.TypeEntityLike;
      fwdLimit: int;
    }>, messages.TypeInvitedUsers> {
    CONSTRUCTOR_ID: 3418804487;
    SUBCLASS_OF_ID: 1035899041;
    classType: "request";
    className: "messages.AddChatUser";
    static fromReader(reader: Reader): AddChatUser;
      chatId: long;
      userId: Api.TypeEntityLike;
      fwdLimit: int;
    }
    export class DeleteChatUser extends Request<Partial<{
      // flags: null;
      revokeHistory?: boolean;
      chatId: long;
      userId: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2719505579;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.DeleteChatUser";
    static fromReader(reader: Reader): DeleteChatUser;
      // flags: null;
      revokeHistory?: boolean;
      chatId: long;
      userId: Api.TypeEntityLike;
    }
    export class CreateChat extends Request<Partial<{
      // flags: null;
      users: Api.TypeEntityLike[];
      title: string;
      ttlPeriod?: int;
    }>, messages.TypeInvitedUsers> {
    CONSTRUCTOR_ID: 2463030740;
    SUBCLASS_OF_ID: 1035899041;
    classType: "request";
    className: "messages.CreateChat";
    static fromReader(reader: Reader): CreateChat;
      // flags: null;
      users: Api.TypeEntityLike[];
      title: string;
      ttlPeriod?: int;
    }
    export class GetDhConfig extends Request<Partial<{
      version: int;
      randomLength: int;
    }>, messages.TypeDhConfig> {
    CONSTRUCTOR_ID: 651135312;
    SUBCLASS_OF_ID: 3834178955;
    classType: "request";
    className: "messages.GetDhConfig";
    static fromReader(reader: Reader): GetDhConfig;
      version: int;
      randomLength: int;
    }
    export class RequestEncryption extends Request<Partial<{
      userId: Api.TypeEntityLike;
      randomId: int;
      gA: bytes;
    }>, Api.TypeEncryptedChat> {
    CONSTRUCTOR_ID: 4132286275;
    SUBCLASS_OF_ID: 1831379834;
    classType: "request";
    className: "messages.RequestEncryption";
    static fromReader(reader: Reader): RequestEncryption;
      userId: Api.TypeEntityLike;
      randomId: int;
      gA: bytes;
    }
    export class AcceptEncryption extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
      gB: bytes;
      keyFingerprint: long;
    }>, Api.TypeEncryptedChat> {
    CONSTRUCTOR_ID: 1035731989;
    SUBCLASS_OF_ID: 1831379834;
    classType: "request";
    className: "messages.AcceptEncryption";
    static fromReader(reader: Reader): AcceptEncryption;
      peer: Api.TypeInputEncryptedChat;
      gB: bytes;
      keyFingerprint: long;
    }
    export class DiscardEncryption extends Request<Partial<{
      // flags: null;
      deleteHistory?: boolean;
      chatId: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 4086541984;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.DiscardEncryption";
    static fromReader(reader: Reader): DiscardEncryption;
      // flags: null;
      deleteHistory?: boolean;
      chatId: int;
    }
    export class SetEncryptedTyping extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
      typing: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2031374829;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetEncryptedTyping";
    static fromReader(reader: Reader): SetEncryptedTyping;
      peer: Api.TypeInputEncryptedChat;
      typing: Bool;
    }
    export class ReadEncryptedHistory extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
      maxDate: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 2135648522;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReadEncryptedHistory";
    static fromReader(reader: Reader): ReadEncryptedHistory;
      peer: Api.TypeInputEncryptedChat;
      maxDate: int;
    }
    export class SendEncrypted extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
    }>, messages.TypeSentEncryptedMessage> {
    CONSTRUCTOR_ID: 1157265941;
    SUBCLASS_OF_ID: 3382591056;
    classType: "request";
    className: "messages.SendEncrypted";
    static fromReader(reader: Reader): SendEncrypted;
      // flags: null;
      silent?: boolean;
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
    }
    export class SendEncryptedFile extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
      file: Api.TypeInputEncryptedFile;
    }>, messages.TypeSentEncryptedMessage> {
    CONSTRUCTOR_ID: 1431914525;
    SUBCLASS_OF_ID: 3382591056;
    classType: "request";
    className: "messages.SendEncryptedFile";
    static fromReader(reader: Reader): SendEncryptedFile;
      // flags: null;
      silent?: boolean;
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
      file: Api.TypeInputEncryptedFile;
    }
    export class SendEncryptedService extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
    }>, messages.TypeSentEncryptedMessage> {
    CONSTRUCTOR_ID: 852769188;
    SUBCLASS_OF_ID: 3382591056;
    classType: "request";
    className: "messages.SendEncryptedService";
    static fromReader(reader: Reader): SendEncryptedService;
      peer: Api.TypeInputEncryptedChat;
      randomId?: long;
      data: bytes;
    }
    export class ReceivedQueue extends Request<Partial<{
      maxQts: int;
    }>, long[]> {
    CONSTRUCTOR_ID: 1436924774;
    SUBCLASS_OF_ID: 2300109160;
    classType: "request";
    className: "messages.ReceivedQueue";
    static fromReader(reader: Reader): ReceivedQueue;
      maxQts: int;
    }
    export class ReportEncryptedSpam extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
    }>, Bool> {
    CONSTRUCTOR_ID: 1259113487;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReportEncryptedSpam";
    static fromReader(reader: Reader): ReportEncryptedSpam;
      peer: Api.TypeInputEncryptedChat;
    }
    export class ReadMessageContents extends Request<Partial<{
      id: int[];
    }>, messages.TypeAffectedMessages> {
    CONSTRUCTOR_ID: 916930423;
    SUBCLASS_OF_ID: 3469983854;
    classType: "request";
    className: "messages.ReadMessageContents";
    static fromReader(reader: Reader): ReadMessageContents;
      id: int[];
    }
    export class GetStickers extends Request<Partial<{
      emoticon: string;
      hash: long;
    }>, messages.TypeStickers> {
    CONSTRUCTOR_ID: 3584414625;
    SUBCLASS_OF_ID: 3611015646;
    classType: "request";
    className: "messages.GetStickers";
    static fromReader(reader: Reader): GetStickers;
      emoticon: string;
      hash: long;
    }
    export class GetAllStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeAllStickers> {
    CONSTRUCTOR_ID: 3097534888;
    SUBCLASS_OF_ID: 1166231593;
    classType: "request";
    className: "messages.GetAllStickers";
    static fromReader(reader: Reader): GetAllStickers;
      hash: long;
    }
    export class GetWebPagePreview extends Request<Partial<{
      // flags: null;
      message: string;
      entities?: Api.TypeMessageEntity[];
    }>, messages.TypeWebPagePreview> {
    CONSTRUCTOR_ID: 1460498287;
    SUBCLASS_OF_ID: 3801354434;
    classType: "request";
    className: "messages.GetWebPagePreview";
    static fromReader(reader: Reader): GetWebPagePreview;
      // flags: null;
      message: string;
      entities?: Api.TypeMessageEntity[];
    }
    export class ExportChatInvite extends Request<Partial<{
      // flags: null;
      legacyRevokePermanent?: boolean;
      requestNeeded?: boolean;
      peer: Api.TypeEntityLike;
      expireDate?: int;
      usageLimit?: int;
      title?: string;
      subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
    }>, Api.TypeExportedChatInvite> {
    CONSTRUCTOR_ID: 2757090960;
    SUBCLASS_OF_ID: 3027536472;
    classType: "request";
    className: "messages.ExportChatInvite";
    static fromReader(reader: Reader): ExportChatInvite;
      // flags: null;
      legacyRevokePermanent?: boolean;
      requestNeeded?: boolean;
      peer: Api.TypeEntityLike;
      expireDate?: int;
      usageLimit?: int;
      title?: string;
      subscriptionPricing?: Api.TypeStarsSubscriptionPricing;
    }
    export class CheckChatInvite extends Request<Partial<{
      hash: string;
    }>, Api.TypeChatInvite> {
    CONSTRUCTOR_ID: 1051570619;
    SUBCLASS_OF_ID: 72750902;
    classType: "request";
    className: "messages.CheckChatInvite";
    static fromReader(reader: Reader): CheckChatInvite;
      hash: string;
    }
    export class ImportChatInvite extends Request<Partial<{
      hash: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1817183516;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.ImportChatInvite";
    static fromReader(reader: Reader): ImportChatInvite;
      hash: string;
    }
    export class GetStickerSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
      hash: int;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 3365989492;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "messages.GetStickerSet";
    static fromReader(reader: Reader): GetStickerSet;
      stickerset: Api.TypeInputStickerSet;
      hash: int;
    }
    export class InstallStickerSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
      archived: Bool;
    }>, messages.TypeStickerSetInstallResult> {
    CONSTRUCTOR_ID: 3348096096;
    SUBCLASS_OF_ID: 1741373416;
    classType: "request";
    className: "messages.InstallStickerSet";
    static fromReader(reader: Reader): InstallStickerSet;
      stickerset: Api.TypeInputStickerSet;
      archived: Bool;
    }
    export class UninstallStickerSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
    }>, Bool> {
    CONSTRUCTOR_ID: 4184757726;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.UninstallStickerSet";
    static fromReader(reader: Reader): UninstallStickerSet;
      stickerset: Api.TypeInputStickerSet;
    }
    export class StartBot extends Request<Partial<{
      bot: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      randomId?: long;
      startParam: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3873403768;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.StartBot";
    static fromReader(reader: Reader): StartBot;
      bot: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      randomId?: long;
      startParam: string;
    }
    export class GetMessagesViews extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
      increment: Bool;
    }>, messages.TypeMessageViews> {
    CONSTRUCTOR_ID: 1468322785;
    SUBCLASS_OF_ID: 2947935132;
    classType: "request";
    className: "messages.GetMessagesViews";
    static fromReader(reader: Reader): GetMessagesViews;
      peer: Api.TypeEntityLike;
      id: int[];
      increment: Bool;
    }
    export class EditChatAdmin extends Request<Partial<{
      chatId: long;
      userId: Api.TypeEntityLike;
      isAdmin: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2824589762;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.EditChatAdmin";
    static fromReader(reader: Reader): EditChatAdmin;
      chatId: long;
      userId: Api.TypeEntityLike;
      isAdmin: Bool;
    }
    export class MigrateChat extends Request<Partial<{
      chatId: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2726777625;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.MigrateChat";
    static fromReader(reader: Reader): MigrateChat;
      chatId: long;
    }
    export class SearchGlobal extends Request<Partial<{
      // flags: null;
      broadcastsOnly?: boolean;
      groupsOnly?: boolean;
      usersOnly?: boolean;
      folderId?: int;
      q: string;
      filter: Api.TypeMessagesFilter;
      minDate: int;
      maxDate: int;
      offsetRate: int;
      offsetPeer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 1271290010;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.SearchGlobal";
    static fromReader(reader: Reader): SearchGlobal;
      // flags: null;
      broadcastsOnly?: boolean;
      groupsOnly?: boolean;
      usersOnly?: boolean;
      folderId?: int;
      q: string;
      filter: Api.TypeMessagesFilter;
      minDate: int;
      maxDate: int;
      offsetRate: int;
      offsetPeer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }
    export class ReorderStickerSets extends Request<Partial<{
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      order: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2016638777;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReorderStickerSets";
    static fromReader(reader: Reader): ReorderStickerSets;
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      order: long[];
    }
    export class GetDocumentByHash extends Request<Partial<{
      sha256: bytes;
      size: long;
      mimeType: string;
    }>, Api.TypeDocument> {
    CONSTRUCTOR_ID: 2985428511;
    SUBCLASS_OF_ID: 555739168;
    classType: "request";
    className: "messages.GetDocumentByHash";
    static fromReader(reader: Reader): GetDocumentByHash;
      sha256: bytes;
      size: long;
      mimeType: string;
    }
    export class GetSavedGifs extends Request<Partial<{
      hash: long;
    }>, messages.TypeSavedGifs> {
    CONSTRUCTOR_ID: 1559270965;
    SUBCLASS_OF_ID: 2794152437;
    classType: "request";
    className: "messages.GetSavedGifs";
    static fromReader(reader: Reader): GetSavedGifs;
      hash: long;
    }
    export class SaveGif extends Request<Partial<{
      id: Api.TypeInputDocument;
      unsave: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 846868683;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SaveGif";
    static fromReader(reader: Reader): SaveGif;
      id: Api.TypeInputDocument;
      unsave: Bool;
    }
    export class GetInlineBotResults extends Request<Partial<{
      // flags: null;
      bot: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      geoPoint?: Api.TypeInputGeoPoint;
      query: string;
      offset: string;
    }>, messages.TypeBotResults> {
    CONSTRUCTOR_ID: 1364105629;
    SUBCLASS_OF_ID: 1054136777;
    classType: "request";
    className: "messages.GetInlineBotResults";
    static fromReader(reader: Reader): GetInlineBotResults;
      // flags: null;
      bot: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      geoPoint?: Api.TypeInputGeoPoint;
      query: string;
      offset: string;
    }
    export class SetInlineBotResults extends Request<Partial<{
      // flags: null;
      gallery?: boolean;
      private?: boolean;
      queryId: long;
      results: Api.TypeInputBotInlineResult[];
      cacheTime: int;
      nextOffset?: string;
      switchPm?: Api.TypeInlineBotSwitchPM;
      switchWebview?: Api.TypeInlineBotWebView;
    }>, Bool> {
    CONSTRUCTOR_ID: 3138561049;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetInlineBotResults";
    static fromReader(reader: Reader): SetInlineBotResults;
      // flags: null;
      gallery?: boolean;
      private?: boolean;
      queryId: long;
      results: Api.TypeInputBotInlineResult[];
      cacheTime: int;
      nextOffset?: string;
      switchPm?: Api.TypeInlineBotSwitchPM;
      switchWebview?: Api.TypeInlineBotWebView;
    }
    export class SendInlineBotResult extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      hideVia?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      randomId?: long;
      queryId: long;
      id: string;
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1052698730;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendInlineBotResult";
    static fromReader(reader: Reader): SendInlineBotResult;
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      hideVia?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      randomId?: long;
      queryId: long;
      id: string;
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
    }
    export class GetMessageEditData extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int;
    }>, messages.TypeMessageEditData> {
    CONSTRUCTOR_ID: 4255550774;
    SUBCLASS_OF_ID: 4215772317;
    classType: "request";
    className: "messages.GetMessageEditData";
    static fromReader(reader: Reader): GetMessageEditData;
      peer: Api.TypeEntityLike;
      id: int;
    }
    export class EditMessage extends Request<Partial<{
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      message?: string;
      media?: Api.TypeInputMedia;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      quickReplyShortcutId?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3755032581;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.EditMessage";
    static fromReader(reader: Reader): EditMessage;
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      message?: string;
      media?: Api.TypeInputMedia;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
      scheduleDate?: int;
      quickReplyShortcutId?: int;
    }
    export class EditInlineBotMessage extends Request<Partial<{
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      id: Api.TypeInputBotInlineMessageID;
      message?: string;
      media?: Api.TypeInputMedia;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2203418042;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.EditInlineBotMessage";
    static fromReader(reader: Reader): EditInlineBotMessage;
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      id: Api.TypeInputBotInlineMessageID;
      message?: string;
      media?: Api.TypeInputMedia;
      replyMarkup?: Api.TypeReplyMarkup;
      entities?: Api.TypeMessageEntity[];
    }
    export class GetBotCallbackAnswer extends Request<Partial<{
      // flags: null;
      game?: boolean;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      data?: bytes;
      password?: Api.TypeInputCheckPasswordSRP;
    }>, messages.TypeBotCallbackAnswer> {
    CONSTRUCTOR_ID: 2470627847;
    SUBCLASS_OF_ID: 1817039244;
    classType: "request";
    className: "messages.GetBotCallbackAnswer";
    static fromReader(reader: Reader): GetBotCallbackAnswer;
      // flags: null;
      game?: boolean;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      data?: bytes;
      password?: Api.TypeInputCheckPasswordSRP;
    }
    export class SetBotCallbackAnswer extends Request<Partial<{
      // flags: null;
      alert?: boolean;
      queryId: long;
      message?: string;
      url?: string;
      cacheTime: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 3582923530;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetBotCallbackAnswer";
    static fromReader(reader: Reader): SetBotCallbackAnswer;
      // flags: null;
      alert?: boolean;
      queryId: long;
      message?: string;
      url?: string;
      cacheTime: int;
    }
    export class GetPeerDialogs extends Request<Partial<{
      peers: Api.TypeInputDialogPeer[];
    }>, messages.TypePeerDialogs> {
    CONSTRUCTOR_ID: 3832593661;
    SUBCLASS_OF_ID: 986120498;
    classType: "request";
    className: "messages.GetPeerDialogs";
    static fromReader(reader: Reader): GetPeerDialogs;
      peers: Api.TypeInputDialogPeer[];
    }
    export class SaveDraft extends Request<Partial<{
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      replyTo?: Api.TypeInputReplyTo;
      peer: Api.TypeEntityLike;
      message: string;
      entities?: Api.TypeMessageEntity[];
      media?: Api.TypeInputMedia;
      effect?: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 3547514318;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SaveDraft";
    static fromReader(reader: Reader): SaveDraft;
      // flags: null;
      noWebpage?: boolean;
      invertMedia?: boolean;
      replyTo?: Api.TypeInputReplyTo;
      peer: Api.TypeEntityLike;
      message: string;
      entities?: Api.TypeMessageEntity[];
      media?: Api.TypeInputMedia;
      effect?: long;
    }
    export class GetAllDrafts extends Request<void, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1782549861;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.GetAllDrafts";
    static fromReader(reader: Reader): GetAllDrafts;
}
    export class GetFeaturedStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeFeaturedStickers> {
    CONSTRUCTOR_ID: 1685588756;
    SUBCLASS_OF_ID: 638891810;
    classType: "request";
    className: "messages.GetFeaturedStickers";
    static fromReader(reader: Reader): GetFeaturedStickers;
      hash: long;
    }
    export class ReadFeaturedStickers extends Request<Partial<{
      id: long[];
    }>, Bool> {
    CONSTRUCTOR_ID: 1527873830;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReadFeaturedStickers";
    static fromReader(reader: Reader): ReadFeaturedStickers;
      id: long[];
    }
    export class GetRecentStickers extends Request<Partial<{
      // flags: null;
      attached?: boolean;
      hash: long;
    }>, messages.TypeRecentStickers> {
    CONSTRUCTOR_ID: 2645114939;
    SUBCLASS_OF_ID: 4151281283;
    classType: "request";
    className: "messages.GetRecentStickers";
    static fromReader(reader: Reader): GetRecentStickers;
      // flags: null;
      attached?: boolean;
      hash: long;
    }
    export class SaveRecentSticker extends Request<Partial<{
      // flags: null;
      attached?: boolean;
      id: Api.TypeInputDocument;
      unsave: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 958863608;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SaveRecentSticker";
    static fromReader(reader: Reader): SaveRecentSticker;
      // flags: null;
      attached?: boolean;
      id: Api.TypeInputDocument;
      unsave: Bool;
    }
    export class ClearRecentStickers extends Request<Partial<{
      // flags: null;
      attached?: boolean;
    }>, Bool> {
    CONSTRUCTOR_ID: 2308530221;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ClearRecentStickers";
    static fromReader(reader: Reader): ClearRecentStickers;
      // flags: null;
      attached?: boolean;
    }
    export class GetArchivedStickers extends Request<Partial<{
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      offsetId: long;
      limit: int;
    }>, messages.TypeArchivedStickers> {
    CONSTRUCTOR_ID: 1475442322;
    SUBCLASS_OF_ID: 1922488177;
    classType: "request";
    className: "messages.GetArchivedStickers";
    static fromReader(reader: Reader): GetArchivedStickers;
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      offsetId: long;
      limit: int;
    }
    export class GetMaskStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeAllStickers> {
    CONSTRUCTOR_ID: 1678738104;
    SUBCLASS_OF_ID: 1166231593;
    classType: "request";
    className: "messages.GetMaskStickers";
    static fromReader(reader: Reader): GetMaskStickers;
      hash: long;
    }
    export class GetAttachedStickers extends Request<Partial<{
      media: Api.TypeInputStickeredMedia;
    }>, Api.TypeStickerSetCovered[]> {
    CONSTRUCTOR_ID: 3428542412;
    SUBCLASS_OF_ID: 3423756139;
    classType: "request";
    className: "messages.GetAttachedStickers";
    static fromReader(reader: Reader): GetAttachedStickers;
      media: Api.TypeInputStickeredMedia;
    }
    export class SetGameScore extends Request<Partial<{
      // flags: null;
      editMessage?: boolean;
      force?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      userId: Api.TypeEntityLike;
      score: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2398678208;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SetGameScore";
    static fromReader(reader: Reader): SetGameScore;
      // flags: null;
      editMessage?: boolean;
      force?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      userId: Api.TypeEntityLike;
      score: int;
    }
    export class SetInlineGameScore extends Request<Partial<{
      // flags: null;
      editMessage?: boolean;
      force?: boolean;
      id: Api.TypeInputBotInlineMessageID;
      userId: Api.TypeEntityLike;
      score: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 363700068;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetInlineGameScore";
    static fromReader(reader: Reader): SetInlineGameScore;
      // flags: null;
      editMessage?: boolean;
      force?: boolean;
      id: Api.TypeInputBotInlineMessageID;
      userId: Api.TypeEntityLike;
      score: int;
    }
    export class GetGameHighScores extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int;
      userId: Api.TypeEntityLike;
    }>, messages.TypeHighScores> {
    CONSTRUCTOR_ID: 3894568093;
    SUBCLASS_OF_ID: 1825412605;
    classType: "request";
    className: "messages.GetGameHighScores";
    static fromReader(reader: Reader): GetGameHighScores;
      peer: Api.TypeEntityLike;
      id: int;
      userId: Api.TypeEntityLike;
    }
    export class GetInlineGameHighScores extends Request<Partial<{
      id: Api.TypeInputBotInlineMessageID;
      userId: Api.TypeEntityLike;
    }>, messages.TypeHighScores> {
    CONSTRUCTOR_ID: 258170395;
    SUBCLASS_OF_ID: 1825412605;
    classType: "request";
    className: "messages.GetInlineGameHighScores";
    static fromReader(reader: Reader): GetInlineGameHighScores;
      id: Api.TypeInputBotInlineMessageID;
      userId: Api.TypeEntityLike;
    }
    export class GetCommonChats extends Request<Partial<{
      userId: Api.TypeEntityLike;
      maxId: long;
      limit: int;
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 3826032900;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "messages.GetCommonChats";
    static fromReader(reader: Reader): GetCommonChats;
      userId: Api.TypeEntityLike;
      maxId: long;
      limit: int;
    }
    export class GetWebPage extends Request<Partial<{
      url: string;
      hash: int;
    }>, messages.TypeWebPage> {
    CONSTRUCTOR_ID: 2375455395;
    SUBCLASS_OF_ID: 754495828;
    classType: "request";
    className: "messages.GetWebPage";
    static fromReader(reader: Reader): GetWebPage;
      url: string;
      hash: int;
    }
    export class ToggleDialogPin extends Request<Partial<{
      // flags: null;
      pinned?: boolean;
      peer: Api.TypeInputDialogPeer;
    }>, Bool> {
    CONSTRUCTOR_ID: 2805064279;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ToggleDialogPin";
    static fromReader(reader: Reader): ToggleDialogPin;
      // flags: null;
      pinned?: boolean;
      peer: Api.TypeInputDialogPeer;
    }
    export class ReorderPinnedDialogs extends Request<Partial<{
      // flags: null;
      force?: boolean;
      folderId: int;
      order: Api.TypeInputDialogPeer[];
    }>, Bool> {
    CONSTRUCTOR_ID: 991616823;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReorderPinnedDialogs";
    static fromReader(reader: Reader): ReorderPinnedDialogs;
      // flags: null;
      force?: boolean;
      folderId: int;
      order: Api.TypeInputDialogPeer[];
    }
    export class GetPinnedDialogs extends Request<Partial<{
      folderId: int;
    }>, messages.TypePeerDialogs> {
    CONSTRUCTOR_ID: 3602468338;
    SUBCLASS_OF_ID: 986120498;
    classType: "request";
    className: "messages.GetPinnedDialogs";
    static fromReader(reader: Reader): GetPinnedDialogs;
      folderId: int;
    }
    export class SetBotShippingResults extends Request<Partial<{
      // flags: null;
      queryId: long;
      error?: string;
      shippingOptions?: Api.TypeShippingOption[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3858133754;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetBotShippingResults";
    static fromReader(reader: Reader): SetBotShippingResults;
      // flags: null;
      queryId: long;
      error?: string;
      shippingOptions?: Api.TypeShippingOption[];
    }
    export class SetBotPrecheckoutResults extends Request<Partial<{
      // flags: null;
      success?: boolean;
      queryId: long;
      error?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 163765653;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetBotPrecheckoutResults";
    static fromReader(reader: Reader): SetBotPrecheckoutResults;
      // flags: null;
      success?: boolean;
      queryId: long;
      error?: string;
    }
    export class UploadMedia extends Request<Partial<{
      // flags: null;
      businessConnectionId?: string;
      peer: Api.TypeEntityLike;
      media: Api.TypeInputMedia;
    }>, Api.TypeMessageMedia> {
    CONSTRUCTOR_ID: 345405816;
    SUBCLASS_OF_ID: 1198308914;
    classType: "request";
    className: "messages.UploadMedia";
    static fromReader(reader: Reader): UploadMedia;
      // flags: null;
      businessConnectionId?: string;
      peer: Api.TypeEntityLike;
      media: Api.TypeInputMedia;
    }
    export class SendScreenshotNotification extends Request<Partial<{
      peer: Api.TypeEntityLike;
      replyTo: Api.TypeInputReplyTo;
      randomId?: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2705348631;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendScreenshotNotification";
    static fromReader(reader: Reader): SendScreenshotNotification;
      peer: Api.TypeEntityLike;
      replyTo: Api.TypeInputReplyTo;
      randomId?: long;
    }
    export class GetFavedStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeFavedStickers> {
    CONSTRUCTOR_ID: 82946729;
    SUBCLASS_OF_ID: 2389929913;
    classType: "request";
    className: "messages.GetFavedStickers";
    static fromReader(reader: Reader): GetFavedStickers;
      hash: long;
    }
    export class FaveSticker extends Request<Partial<{
      id: Api.TypeInputDocument;
      unfave: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 3120547163;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.FaveSticker";
    static fromReader(reader: Reader): FaveSticker;
      id: Api.TypeInputDocument;
      unfave: Bool;
    }
    export class GetUnreadMentions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 4043827088;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetUnreadMentions";
    static fromReader(reader: Reader): GetUnreadMentions;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
    }
    export class ReadMentions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 921026381;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "messages.ReadMentions";
    static fromReader(reader: Reader): ReadMentions;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }
    export class GetRecentLocations extends Request<Partial<{
      peer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 1881817312;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetRecentLocations";
    static fromReader(reader: Reader): GetRecentLocations;
      peer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }
    export class SendMultiMedia extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      multiMedia: Api.TypeInputSingleMedia[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 934757205;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendMultiMedia";
    static fromReader(reader: Reader): SendMultiMedia;
      // flags: null;
      silent?: boolean;
      background?: boolean;
      clearDraft?: boolean;
      noforwards?: boolean;
      updateStickersetsOrder?: boolean;
      invertMedia?: boolean;
      allowPaidFloodskip?: boolean;
      peer: Api.TypeEntityLike;
      replyTo?: Api.TypeInputReplyTo;
      multiMedia: Api.TypeInputSingleMedia[];
      scheduleDate?: int;
      sendAs?: Api.TypeEntityLike;
      quickReplyShortcut?: Api.TypeInputQuickReplyShortcut;
      effect?: long;
    }
    export class UploadEncryptedFile extends Request<Partial<{
      peer: Api.TypeInputEncryptedChat;
      file: Api.TypeInputEncryptedFile;
    }>, Api.TypeEncryptedFile> {
    CONSTRUCTOR_ID: 1347929239;
    SUBCLASS_OF_ID: 2217371584;
    classType: "request";
    className: "messages.UploadEncryptedFile";
    static fromReader(reader: Reader): UploadEncryptedFile;
      peer: Api.TypeInputEncryptedChat;
      file: Api.TypeInputEncryptedFile;
    }
    export class SearchStickerSets extends Request<Partial<{
      // flags: null;
      excludeFeatured?: boolean;
      q: string;
      hash: long;
    }>, messages.TypeFoundStickerSets> {
    CONSTRUCTOR_ID: 896555914;
    SUBCLASS_OF_ID: 68023137;
    classType: "request";
    className: "messages.SearchStickerSets";
    static fromReader(reader: Reader): SearchStickerSets;
      // flags: null;
      excludeFeatured?: boolean;
      q: string;
      hash: long;
    }
    export class GetSplitRanges extends Request<void, Api.TypeMessageRange[]> {
    CONSTRUCTOR_ID: 486505992;
    SUBCLASS_OF_ID: 1537549572;
    classType: "request";
    className: "messages.GetSplitRanges";
    static fromReader(reader: Reader): GetSplitRanges;
}
    export class MarkDialogUnread extends Request<Partial<{
      // flags: null;
      unread?: boolean;
      peer: Api.TypeInputDialogPeer;
    }>, Bool> {
    CONSTRUCTOR_ID: 3263617423;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.MarkDialogUnread";
    static fromReader(reader: Reader): MarkDialogUnread;
      // flags: null;
      unread?: boolean;
      peer: Api.TypeInputDialogPeer;
    }
    export class GetDialogUnreadMarks extends Request<void, Api.TypeDialogPeer[]> {
    CONSTRUCTOR_ID: 585256482;
    SUBCLASS_OF_ID: 3200666329;
    classType: "request";
    className: "messages.GetDialogUnreadMarks";
    static fromReader(reader: Reader): GetDialogUnreadMarks;
}
    export class ClearAllDrafts extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2119757468;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ClearAllDrafts";
    static fromReader(reader: Reader): ClearAllDrafts;
}
    export class UpdatePinnedMessage extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      unpin?: boolean;
      pmOneside?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3534419948;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.UpdatePinnedMessage";
    static fromReader(reader: Reader): UpdatePinnedMessage;
      // flags: null;
      silent?: boolean;
      unpin?: boolean;
      pmOneside?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
    }
    export class SendVote extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      options: bytes[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 283795844;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendVote";
    static fromReader(reader: Reader): SendVote;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      options: bytes[];
    }
    export class GetPollResults extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1941660731;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.GetPollResults";
    static fromReader(reader: Reader): GetPollResults;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class GetOnlines extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Api.TypeChatOnlines> {
    CONSTRUCTOR_ID: 1848369232;
    SUBCLASS_OF_ID: 2357301306;
    classType: "request";
    className: "messages.GetOnlines";
    static fromReader(reader: Reader): GetOnlines;
      peer: Api.TypeEntityLike;
    }
    export class EditChatAbout extends Request<Partial<{
      peer: Api.TypeEntityLike;
      about: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3740665751;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.EditChatAbout";
    static fromReader(reader: Reader): EditChatAbout;
      peer: Api.TypeEntityLike;
      about: string;
    }
    export class EditChatDefaultBannedRights extends Request<Partial<{
      peer: Api.TypeEntityLike;
      bannedRights: Api.TypeChatBannedRights;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2777049921;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.EditChatDefaultBannedRights";
    static fromReader(reader: Reader): EditChatDefaultBannedRights;
      peer: Api.TypeEntityLike;
      bannedRights: Api.TypeChatBannedRights;
    }
    export class GetEmojiKeywords extends Request<Partial<{
      langCode: string;
    }>, Api.TypeEmojiKeywordsDifference> {
    CONSTRUCTOR_ID: 899735650;
    SUBCLASS_OF_ID: 3531196018;
    classType: "request";
    className: "messages.GetEmojiKeywords";
    static fromReader(reader: Reader): GetEmojiKeywords;
      langCode: string;
    }
    export class GetEmojiKeywordsDifference extends Request<Partial<{
      langCode: string;
      fromVersion: int;
    }>, Api.TypeEmojiKeywordsDifference> {
    CONSTRUCTOR_ID: 352892591;
    SUBCLASS_OF_ID: 3531196018;
    classType: "request";
    className: "messages.GetEmojiKeywordsDifference";
    static fromReader(reader: Reader): GetEmojiKeywordsDifference;
      langCode: string;
      fromVersion: int;
    }
    export class GetEmojiKeywordsLanguages extends Request<Partial<{
      langCodes: string[];
    }>, Api.TypeEmojiLanguage[]> {
    CONSTRUCTOR_ID: 1318675378;
    SUBCLASS_OF_ID: 3885355911;
    classType: "request";
    className: "messages.GetEmojiKeywordsLanguages";
    static fromReader(reader: Reader): GetEmojiKeywordsLanguages;
      langCodes: string[];
    }
    export class GetEmojiURL extends Request<Partial<{
      langCode: string;
    }>, Api.TypeEmojiURL> {
    CONSTRUCTOR_ID: 3585149990;
    SUBCLASS_OF_ID: 530614809;
    classType: "request";
    className: "messages.GetEmojiURL";
    static fromReader(reader: Reader): GetEmojiURL;
      langCode: string;
    }
    export class GetSearchCounters extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      filters: Api.TypeMessagesFilter[];
    }>, messages.TypeSearchCounter[]> {
    CONSTRUCTOR_ID: 465367808;
    SUBCLASS_OF_ID: 1809726574;
    classType: "request";
    className: "messages.GetSearchCounters";
    static fromReader(reader: Reader): GetSearchCounters;
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      filters: Api.TypeMessagesFilter[];
    }
    export class RequestUrlAuth extends Request<Partial<{
      // flags: null;
      peer?: Api.TypeEntityLike;
      msgId?: MessageIDLike;
      buttonId?: int;
      url?: string;
    }>, Api.TypeUrlAuthResult> {
    CONSTRUCTOR_ID: 428848198;
    SUBCLASS_OF_ID: 2003159838;
    classType: "request";
    className: "messages.RequestUrlAuth";
    static fromReader(reader: Reader): RequestUrlAuth;
      // flags: null;
      peer?: Api.TypeEntityLike;
      msgId?: MessageIDLike;
      buttonId?: int;
      url?: string;
    }
    export class AcceptUrlAuth extends Request<Partial<{
      // flags: null;
      writeAllowed?: boolean;
      peer?: Api.TypeEntityLike;
      msgId?: MessageIDLike;
      buttonId?: int;
      url?: string;
    }>, Api.TypeUrlAuthResult> {
    CONSTRUCTOR_ID: 2972479781;
    SUBCLASS_OF_ID: 2003159838;
    classType: "request";
    className: "messages.AcceptUrlAuth";
    static fromReader(reader: Reader): AcceptUrlAuth;
      // flags: null;
      writeAllowed?: boolean;
      peer?: Api.TypeEntityLike;
      msgId?: MessageIDLike;
      buttonId?: int;
      url?: string;
    }
    export class HidePeerSettingsBar extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1336717624;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.HidePeerSettingsBar";
    static fromReader(reader: Reader): HidePeerSettingsBar;
      peer: Api.TypeEntityLike;
    }
    export class GetScheduledHistory extends Request<Partial<{
      peer: Api.TypeEntityLike;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 4111889931;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetScheduledHistory";
    static fromReader(reader: Reader): GetScheduledHistory;
      peer: Api.TypeEntityLike;
      hash: long;
    }
    export class GetScheduledMessages extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 3183150180;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetScheduledMessages";
    static fromReader(reader: Reader): GetScheduledMessages;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class SendScheduledMessages extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3174597898;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendScheduledMessages";
    static fromReader(reader: Reader): SendScheduledMessages;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class DeleteScheduledMessages extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1504586518;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.DeleteScheduledMessages";
    static fromReader(reader: Reader): DeleteScheduledMessages;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class GetPollVotes extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      option?: bytes;
      offset?: string;
      limit: int;
    }>, messages.TypeVotesList> {
    CONSTRUCTOR_ID: 3094231054;
    SUBCLASS_OF_ID: 3256457349;
    classType: "request";
    className: "messages.GetPollVotes";
    static fromReader(reader: Reader): GetPollVotes;
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      option?: bytes;
      offset?: string;
      limit: int;
    }
    export class ToggleStickerSets extends Request<Partial<{
      // flags: null;
      uninstall?: boolean;
      archive?: boolean;
      unarchive?: boolean;
      stickersets: Api.TypeInputStickerSet[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3037016042;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ToggleStickerSets";
    static fromReader(reader: Reader): ToggleStickerSets;
      // flags: null;
      uninstall?: boolean;
      archive?: boolean;
      unarchive?: boolean;
      stickersets: Api.TypeInputStickerSet[];
    }
    export class GetDialogFilters extends Request<void, messages.TypeDialogFilters> {
    CONSTRUCTOR_ID: 4023684233;
    SUBCLASS_OF_ID: 2785014199;
    classType: "request";
    className: "messages.GetDialogFilters";
    static fromReader(reader: Reader): GetDialogFilters;
}
    export class GetSuggestedDialogFilters extends Request<void, Api.TypeDialogFilterSuggested[]> {
    CONSTRUCTOR_ID: 2728186924;
    SUBCLASS_OF_ID: 2066312249;
    classType: "request";
    className: "messages.GetSuggestedDialogFilters";
    static fromReader(reader: Reader): GetSuggestedDialogFilters;
}
    export class UpdateDialogFilter extends Request<Partial<{
      // flags: null;
      id: int;
      filter?: Api.TypeDialogFilter;
    }>, Bool> {
    CONSTRUCTOR_ID: 450142282;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.UpdateDialogFilter";
    static fromReader(reader: Reader): UpdateDialogFilter;
      // flags: null;
      id: int;
      filter?: Api.TypeDialogFilter;
    }
    export class UpdateDialogFiltersOrder extends Request<Partial<{
      order: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3311649252;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.UpdateDialogFiltersOrder";
    static fromReader(reader: Reader): UpdateDialogFiltersOrder;
      order: int[];
    }
    export class GetOldFeaturedStickers extends Request<Partial<{
      offset: int;
      limit: int;
      hash: long;
    }>, messages.TypeFeaturedStickers> {
    CONSTRUCTOR_ID: 2127598753;
    SUBCLASS_OF_ID: 638891810;
    classType: "request";
    className: "messages.GetOldFeaturedStickers";
    static fromReader(reader: Reader): GetOldFeaturedStickers;
      offset: int;
      limit: int;
      hash: long;
    }
    export class GetReplies extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 584962828;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetReplies";
    static fromReader(reader: Reader): GetReplies;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }
    export class GetDiscussionMessage extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, messages.TypeDiscussionMessage> {
    CONSTRUCTOR_ID: 1147761405;
    SUBCLASS_OF_ID: 1408820200;
    classType: "request";
    className: "messages.GetDiscussionMessage";
    static fromReader(reader: Reader): GetDiscussionMessage;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class ReadDiscussion extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      readMaxId: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 4147227124;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReadDiscussion";
    static fromReader(reader: Reader): ReadDiscussion;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      readMaxId: int;
    }
    export class UnpinAllMessages extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 3995253160;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "messages.UnpinAllMessages";
    static fromReader(reader: Reader): UnpinAllMessages;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }
    export class DeleteChat extends Request<Partial<{
      chatId: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 1540419152;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.DeleteChat";
    static fromReader(reader: Reader): DeleteChat;
      chatId: long;
    }
    export class DeletePhoneCallHistory extends Request<Partial<{
      // flags: null;
      revoke?: boolean;
    }>, messages.TypeAffectedFoundMessages> {
    CONSTRUCTOR_ID: 4190888969;
    SUBCLASS_OF_ID: 4162282798;
    classType: "request";
    className: "messages.DeletePhoneCallHistory";
    static fromReader(reader: Reader): DeletePhoneCallHistory;
      // flags: null;
      revoke?: boolean;
    }
    export class CheckHistoryImport extends Request<Partial<{
      importHead: string;
    }>, messages.TypeHistoryImportParsed> {
    CONSTRUCTOR_ID: 1140726259;
    SUBCLASS_OF_ID: 1538421259;
    classType: "request";
    className: "messages.CheckHistoryImport";
    static fromReader(reader: Reader): CheckHistoryImport;
      importHead: string;
    }
    export class InitHistoryImport extends Request<Partial<{
      peer: Api.TypeEntityLike;
      file: Api.TypeInputFile;
      mediaCount: int;
    }>, messages.TypeHistoryImport> {
    CONSTRUCTOR_ID: 873008187;
    SUBCLASS_OF_ID: 2978723082;
    classType: "request";
    className: "messages.InitHistoryImport";
    static fromReader(reader: Reader): InitHistoryImport;
      peer: Api.TypeEntityLike;
      file: Api.TypeInputFile;
      mediaCount: int;
    }
    export class UploadImportedMedia extends Request<Partial<{
      peer: Api.TypeEntityLike;
      importId: long;
      fileName: string;
      media: Api.TypeInputMedia;
    }>, Api.TypeMessageMedia> {
    CONSTRUCTOR_ID: 713433234;
    SUBCLASS_OF_ID: 1198308914;
    classType: "request";
    className: "messages.UploadImportedMedia";
    static fromReader(reader: Reader): UploadImportedMedia;
      peer: Api.TypeEntityLike;
      importId: long;
      fileName: string;
      media: Api.TypeInputMedia;
    }
    export class StartHistoryImport extends Request<Partial<{
      peer: Api.TypeEntityLike;
      importId: long;
    }>, Bool> {
    CONSTRUCTOR_ID: 3023958852;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.StartHistoryImport";
    static fromReader(reader: Reader): StartHistoryImport;
      peer: Api.TypeEntityLike;
      importId: long;
    }
    export class GetExportedChatInvites extends Request<Partial<{
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      adminId: Api.TypeEntityLike;
      offsetDate?: int;
      offsetLink?: string;
      limit: int;
    }>, messages.TypeExportedChatInvites> {
    CONSTRUCTOR_ID: 2729812982;
    SUBCLASS_OF_ID: 1614624881;
    classType: "request";
    className: "messages.GetExportedChatInvites";
    static fromReader(reader: Reader): GetExportedChatInvites;
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      adminId: Api.TypeEntityLike;
      offsetDate?: int;
      offsetLink?: string;
      limit: int;
    }
    export class GetExportedChatInvite extends Request<Partial<{
      peer: Api.TypeEntityLike;
      link: string;
    }>, messages.TypeExportedChatInvite> {
    CONSTRUCTOR_ID: 1937010524;
    SUBCLASS_OF_ID: 2195510474;
    classType: "request";
    className: "messages.GetExportedChatInvite";
    static fromReader(reader: Reader): GetExportedChatInvite;
      peer: Api.TypeEntityLike;
      link: string;
    }
    export class EditExportedChatInvite extends Request<Partial<{
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      link: string;
      expireDate?: int;
      usageLimit?: int;
      requestNeeded?: Bool;
      title?: string;
    }>, messages.TypeExportedChatInvite> {
    CONSTRUCTOR_ID: 3184144245;
    SUBCLASS_OF_ID: 2195510474;
    classType: "request";
    className: "messages.EditExportedChatInvite";
    static fromReader(reader: Reader): EditExportedChatInvite;
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      link: string;
      expireDate?: int;
      usageLimit?: int;
      requestNeeded?: Bool;
      title?: string;
    }
    export class DeleteRevokedExportedChatInvites extends Request<Partial<{
      peer: Api.TypeEntityLike;
      adminId: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1452833749;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.DeleteRevokedExportedChatInvites";
    static fromReader(reader: Reader): DeleteRevokedExportedChatInvites;
      peer: Api.TypeEntityLike;
      adminId: Api.TypeEntityLike;
    }
    export class DeleteExportedChatInvite extends Request<Partial<{
      peer: Api.TypeEntityLike;
      link: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3563365419;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.DeleteExportedChatInvite";
    static fromReader(reader: Reader): DeleteExportedChatInvite;
      peer: Api.TypeEntityLike;
      link: string;
    }
    export class GetAdminsWithInvites extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, messages.TypeChatAdminsWithInvites> {
    CONSTRUCTOR_ID: 958457583;
    SUBCLASS_OF_ID: 2405149995;
    classType: "request";
    className: "messages.GetAdminsWithInvites";
    static fromReader(reader: Reader): GetAdminsWithInvites;
      peer: Api.TypeEntityLike;
    }
    export class GetChatInviteImporters extends Request<Partial<{
      // flags: null;
      requested?: boolean;
      subscriptionExpired?: boolean;
      peer: Api.TypeEntityLike;
      link?: string;
      q?: string;
      offsetDate: int;
      offsetUser: Api.TypeEntityLike;
      limit: int;
    }>, messages.TypeChatInviteImporters> {
    CONSTRUCTOR_ID: 3741637966;
    SUBCLASS_OF_ID: 3653012134;
    classType: "request";
    className: "messages.GetChatInviteImporters";
    static fromReader(reader: Reader): GetChatInviteImporters;
      // flags: null;
      requested?: boolean;
      subscriptionExpired?: boolean;
      peer: Api.TypeEntityLike;
      link?: string;
      q?: string;
      offsetDate: int;
      offsetUser: Api.TypeEntityLike;
      limit: int;
    }
    export class SetHistoryTTL extends Request<Partial<{
      peer: Api.TypeEntityLike;
      period: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3087949796;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SetHistoryTTL";
    static fromReader(reader: Reader): SetHistoryTTL;
      peer: Api.TypeEntityLike;
      period: int;
    }
    export class CheckHistoryImportPeer extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, messages.TypeCheckedHistoryImportPeer> {
    CONSTRUCTOR_ID: 1573261059;
    SUBCLASS_OF_ID: 3091968823;
    classType: "request";
    className: "messages.CheckHistoryImportPeer";
    static fromReader(reader: Reader): CheckHistoryImportPeer;
      peer: Api.TypeEntityLike;
    }
    export class SetChatTheme extends Request<Partial<{
      peer: Api.TypeEntityLike;
      emoticon: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3862683967;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SetChatTheme";
    static fromReader(reader: Reader): SetChatTheme;
      peer: Api.TypeEntityLike;
      emoticon: string;
    }
    export class GetMessageReadParticipants extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, Api.TypeReadParticipantDate[]> {
    CONSTRUCTOR_ID: 834782287;
    SUBCLASS_OF_ID: 566904155;
    classType: "request";
    className: "messages.GetMessageReadParticipants";
    static fromReader(reader: Reader): GetMessageReadParticipants;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class GetSearchResultsCalendar extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      filter: Api.TypeMessagesFilter;
      offsetId: int;
      offsetDate: int;
    }>, messages.TypeSearchResultsCalendar> {
    CONSTRUCTOR_ID: 1789130429;
    SUBCLASS_OF_ID: 2462409743;
    classType: "request";
    className: "messages.GetSearchResultsCalendar";
    static fromReader(reader: Reader): GetSearchResultsCalendar;
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      filter: Api.TypeMessagesFilter;
      offsetId: int;
      offsetDate: int;
    }
    export class GetSearchResultsPositions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      filter: Api.TypeMessagesFilter;
      offsetId: int;
      limit: int;
    }>, messages.TypeSearchResultsPositions> {
    CONSTRUCTOR_ID: 2625580816;
    SUBCLASS_OF_ID: 3647172749;
    classType: "request";
    className: "messages.GetSearchResultsPositions";
    static fromReader(reader: Reader): GetSearchResultsPositions;
      // flags: null;
      peer: Api.TypeEntityLike;
      savedPeerId?: Api.TypeEntityLike;
      filter: Api.TypeMessagesFilter;
      offsetId: int;
      limit: int;
    }
    export class HideChatJoinRequest extends Request<Partial<{
      // flags: null;
      approved?: boolean;
      peer: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2145904661;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.HideChatJoinRequest";
    static fromReader(reader: Reader): HideChatJoinRequest;
      // flags: null;
      approved?: boolean;
      peer: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
    }
    export class HideAllChatJoinRequests extends Request<Partial<{
      // flags: null;
      approved?: boolean;
      peer: Api.TypeEntityLike;
      link?: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3766875370;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.HideAllChatJoinRequests";
    static fromReader(reader: Reader): HideAllChatJoinRequests;
      // flags: null;
      approved?: boolean;
      peer: Api.TypeEntityLike;
      link?: string;
    }
    export class ToggleNoForwards extends Request<Partial<{
      peer: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2971578274;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.ToggleNoForwards";
    static fromReader(reader: Reader): ToggleNoForwards;
      peer: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class SaveDefaultSendAs extends Request<Partial<{
      peer: Api.TypeEntityLike;
      sendAs: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3439189910;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SaveDefaultSendAs";
    static fromReader(reader: Reader): SaveDefaultSendAs;
      peer: Api.TypeEntityLike;
      sendAs: Api.TypeEntityLike;
    }
    export class SendReaction extends Request<Partial<{
      // flags: null;
      big?: boolean;
      addToRecent?: boolean;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      reaction?: Api.TypeReaction[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3540875476;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendReaction";
    static fromReader(reader: Reader): SendReaction;
      // flags: null;
      big?: boolean;
      addToRecent?: boolean;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      reaction?: Api.TypeReaction[];
    }
    export class GetMessagesReactions extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2344259814;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.GetMessagesReactions";
    static fromReader(reader: Reader): GetMessagesReactions;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class GetMessageReactionsList extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      reaction?: Api.TypeReaction;
      offset?: string;
      limit: int;
    }>, messages.TypeMessageReactionsList> {
    CONSTRUCTOR_ID: 1176190792;
    SUBCLASS_OF_ID: 1627186662;
    classType: "request";
    className: "messages.GetMessageReactionsList";
    static fromReader(reader: Reader): GetMessageReactionsList;
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      reaction?: Api.TypeReaction;
      offset?: string;
      limit: int;
    }
    export class SetChatAvailableReactions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      availableReactions: Api.TypeChatReactions;
      reactionsLimit?: int;
      paidEnabled?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2253071745;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SetChatAvailableReactions";
    static fromReader(reader: Reader): SetChatAvailableReactions;
      // flags: null;
      peer: Api.TypeEntityLike;
      availableReactions: Api.TypeChatReactions;
      reactionsLimit?: int;
      paidEnabled?: Bool;
    }
    export class GetAvailableReactions extends Request<Partial<{
      hash: int;
    }>, messages.TypeAvailableReactions> {
    CONSTRUCTOR_ID: 417243308;
    SUBCLASS_OF_ID: 3827740034;
    classType: "request";
    className: "messages.GetAvailableReactions";
    static fromReader(reader: Reader): GetAvailableReactions;
      hash: int;
    }
    export class SetDefaultReaction extends Request<Partial<{
      reaction: Api.TypeReaction;
    }>, Bool> {
    CONSTRUCTOR_ID: 1330094102;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetDefaultReaction";
    static fromReader(reader: Reader): SetDefaultReaction;
      reaction: Api.TypeReaction;
    }
    export class TranslateText extends Request<Partial<{
      // flags: null;
      peer?: Api.TypeEntityLike;
      id?: int[];
      text?: Api.TypeTextWithEntities[];
      toLang: string;
    }>, messages.TypeTranslatedText> {
    CONSTRUCTOR_ID: 1662529584;
    SUBCLASS_OF_ID: 37897192;
    classType: "request";
    className: "messages.TranslateText";
    static fromReader(reader: Reader): TranslateText;
      // flags: null;
      peer?: Api.TypeEntityLike;
      id?: int[];
      text?: Api.TypeTextWithEntities[];
      toLang: string;
    }
    export class GetUnreadReactions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 841173339;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetUnreadReactions";
    static fromReader(reader: Reader): GetUnreadReactions;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
      offsetId: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
    }
    export class ReadReactions extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 1420459918;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "messages.ReadReactions";
    static fromReader(reader: Reader): ReadReactions;
      // flags: null;
      peer: Api.TypeEntityLike;
      topMsgId?: MessageIDLike;
    }
    export class SearchSentMedia extends Request<Partial<{
      q: string;
      filter: Api.TypeMessagesFilter;
      limit: int;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 276705696;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.SearchSentMedia";
    static fromReader(reader: Reader): SearchSentMedia;
      q: string;
      filter: Api.TypeMessagesFilter;
      limit: int;
    }
    export class GetAttachMenuBots extends Request<Partial<{
      hash: long;
    }>, Api.TypeAttachMenuBots> {
    CONSTRUCTOR_ID: 385663691;
    SUBCLASS_OF_ID: 2217616346;
    classType: "request";
    className: "messages.GetAttachMenuBots";
    static fromReader(reader: Reader): GetAttachMenuBots;
      hash: long;
    }
    export class GetAttachMenuBot extends Request<Partial<{
      bot: Api.TypeEntityLike;
    }>, Api.TypeAttachMenuBotsBot> {
    CONSTRUCTOR_ID: 1998676370;
    SUBCLASS_OF_ID: 3677587517;
    classType: "request";
    className: "messages.GetAttachMenuBot";
    static fromReader(reader: Reader): GetAttachMenuBot;
      bot: Api.TypeEntityLike;
    }
    export class ToggleBotInAttachMenu extends Request<Partial<{
      // flags: null;
      writeAllowed?: boolean;
      bot: Api.TypeEntityLike;
      enabled: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1777704297;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ToggleBotInAttachMenu";
    static fromReader(reader: Reader): ToggleBotInAttachMenu;
      // flags: null;
      writeAllowed?: boolean;
      bot: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class RequestWebView extends Request<Partial<{
      // flags: null;
      fromBotMenu?: boolean;
      silent?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      url?: string;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
      replyTo?: Api.TypeInputReplyTo;
      sendAs?: Api.TypeEntityLike;
    }>, Api.TypeWebViewResult> {
    CONSTRUCTOR_ID: 647873217;
    SUBCLASS_OF_ID: 2479793990;
    classType: "request";
    className: "messages.RequestWebView";
    static fromReader(reader: Reader): RequestWebView;
      // flags: null;
      fromBotMenu?: boolean;
      silent?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      url?: string;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
      replyTo?: Api.TypeInputReplyTo;
      sendAs?: Api.TypeEntityLike;
    }
    export class ProlongWebView extends Request<Partial<{
      // flags: null;
      silent?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      queryId: long;
      replyTo?: Api.TypeInputReplyTo;
      sendAs?: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 2966952579;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ProlongWebView";
    static fromReader(reader: Reader): ProlongWebView;
      // flags: null;
      silent?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      queryId: long;
      replyTo?: Api.TypeInputReplyTo;
      sendAs?: Api.TypeEntityLike;
    }
    export class RequestSimpleWebView extends Request<Partial<{
      // flags: null;
      fromSwitchWebview?: boolean;
      fromSideMenu?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      bot: Api.TypeEntityLike;
      url?: string;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }>, Api.TypeWebViewResult> {
    CONSTRUCTOR_ID: 1094336115;
    SUBCLASS_OF_ID: 2479793990;
    classType: "request";
    className: "messages.RequestSimpleWebView";
    static fromReader(reader: Reader): RequestSimpleWebView;
      // flags: null;
      fromSwitchWebview?: boolean;
      fromSideMenu?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      bot: Api.TypeEntityLike;
      url?: string;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }
    export class SendWebViewResultMessage extends Request<Partial<{
      botQueryId: string;
      result: Api.TypeInputBotInlineResult;
    }>, Api.TypeWebViewMessageSent> {
    CONSTRUCTOR_ID: 172168437;
    SUBCLASS_OF_ID: 1977914130;
    classType: "request";
    className: "messages.SendWebViewResultMessage";
    static fromReader(reader: Reader): SendWebViewResultMessage;
      botQueryId: string;
      result: Api.TypeInputBotInlineResult;
    }
    export class SendWebViewData extends Request<Partial<{
      bot: Api.TypeEntityLike;
      randomId?: long;
      buttonText: string;
      data: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3691135688;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendWebViewData";
    static fromReader(reader: Reader): SendWebViewData;
      bot: Api.TypeEntityLike;
      randomId?: long;
      buttonText: string;
      data: string;
    }
    export class TranscribeAudio extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, messages.TypeTranscribedAudio> {
    CONSTRUCTOR_ID: 647928393;
    SUBCLASS_OF_ID: 565332278;
    classType: "request";
    className: "messages.TranscribeAudio";
    static fromReader(reader: Reader): TranscribeAudio;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class RateTranscribedAudio extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      transcriptionId: long;
      good: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2132608815;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.RateTranscribedAudio";
    static fromReader(reader: Reader): RateTranscribedAudio;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      transcriptionId: long;
      good: Bool;
    }
    export class GetCustomEmojiDocuments extends Request<Partial<{
      documentId: long[];
    }>, Api.TypeDocument[]> {
    CONSTRUCTOR_ID: 3651866452;
    SUBCLASS_OF_ID: 3428388360;
    classType: "request";
    className: "messages.GetCustomEmojiDocuments";
    static fromReader(reader: Reader): GetCustomEmojiDocuments;
      documentId: long[];
    }
    export class GetEmojiStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeAllStickers> {
    CONSTRUCTOR_ID: 4227637647;
    SUBCLASS_OF_ID: 1166231593;
    classType: "request";
    className: "messages.GetEmojiStickers";
    static fromReader(reader: Reader): GetEmojiStickers;
      hash: long;
    }
    export class GetFeaturedEmojiStickers extends Request<Partial<{
      hash: long;
    }>, messages.TypeFeaturedStickers> {
    CONSTRUCTOR_ID: 248473398;
    SUBCLASS_OF_ID: 638891810;
    classType: "request";
    className: "messages.GetFeaturedEmojiStickers";
    static fromReader(reader: Reader): GetFeaturedEmojiStickers;
      hash: long;
    }
    export class ReportReaction extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int;
      reactionPeer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1063567478;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReportReaction";
    static fromReader(reader: Reader): ReportReaction;
      peer: Api.TypeEntityLike;
      id: int;
      reactionPeer: Api.TypeEntityLike;
    }
    export class GetTopReactions extends Request<Partial<{
      limit: int;
      hash: long;
    }>, messages.TypeReactions> {
    CONSTRUCTOR_ID: 3145803194;
    SUBCLASS_OF_ID: 2915271460;
    classType: "request";
    className: "messages.GetTopReactions";
    static fromReader(reader: Reader): GetTopReactions;
      limit: int;
      hash: long;
    }
    export class GetRecentReactions extends Request<Partial<{
      limit: int;
      hash: long;
    }>, messages.TypeReactions> {
    CONSTRUCTOR_ID: 960896434;
    SUBCLASS_OF_ID: 2915271460;
    classType: "request";
    className: "messages.GetRecentReactions";
    static fromReader(reader: Reader): GetRecentReactions;
      limit: int;
      hash: long;
    }
    export class ClearRecentReactions extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2650730420;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ClearRecentReactions";
    static fromReader(reader: Reader): ClearRecentReactions;
}
    export class GetExtendedMedia extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2230847508;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.GetExtendedMedia";
    static fromReader(reader: Reader): GetExtendedMedia;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class SetDefaultHistoryTTL extends Request<Partial<{
      period: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 2662667333;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.SetDefaultHistoryTTL";
    static fromReader(reader: Reader): SetDefaultHistoryTTL;
      period: int;
    }
    export class GetDefaultHistoryTTL extends Request<void, Api.TypeDefaultHistoryTTL> {
    CONSTRUCTOR_ID: 1703637384;
    SUBCLASS_OF_ID: 4027396967;
    classType: "request";
    className: "messages.GetDefaultHistoryTTL";
    static fromReader(reader: Reader): GetDefaultHistoryTTL;
}
    export class SendBotRequestedPeer extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      buttonId: int;
      requestedPeers: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2444415072;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendBotRequestedPeer";
    static fromReader(reader: Reader): SendBotRequestedPeer;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      buttonId: int;
      requestedPeers: Api.TypeEntityLike[];
    }
    export class GetEmojiGroups extends Request<Partial<{
      hash: int;
    }>, messages.TypeEmojiGroups> {
    CONSTRUCTOR_ID: 1955122779;
    SUBCLASS_OF_ID: 2127189465;
    classType: "request";
    className: "messages.GetEmojiGroups";
    static fromReader(reader: Reader): GetEmojiGroups;
      hash: int;
    }
    export class GetEmojiStatusGroups extends Request<Partial<{
      hash: int;
    }>, messages.TypeEmojiGroups> {
    CONSTRUCTOR_ID: 785209037;
    SUBCLASS_OF_ID: 2127189465;
    classType: "request";
    className: "messages.GetEmojiStatusGroups";
    static fromReader(reader: Reader): GetEmojiStatusGroups;
      hash: int;
    }
    export class GetEmojiProfilePhotoGroups extends Request<Partial<{
      hash: int;
    }>, messages.TypeEmojiGroups> {
    CONSTRUCTOR_ID: 564480243;
    SUBCLASS_OF_ID: 2127189465;
    classType: "request";
    className: "messages.GetEmojiProfilePhotoGroups";
    static fromReader(reader: Reader): GetEmojiProfilePhotoGroups;
      hash: int;
    }
    export class SearchCustomEmoji extends Request<Partial<{
      emoticon: string;
      hash: long;
    }>, Api.TypeEmojiList> {
    CONSTRUCTOR_ID: 739360983;
    SUBCLASS_OF_ID: 3169807034;
    classType: "request";
    className: "messages.SearchCustomEmoji";
    static fromReader(reader: Reader): SearchCustomEmoji;
      emoticon: string;
      hash: long;
    }
    export class TogglePeerTranslations extends Request<Partial<{
      // flags: null;
      disabled?: boolean;
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3833378169;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.TogglePeerTranslations";
    static fromReader(reader: Reader): TogglePeerTranslations;
      // flags: null;
      disabled?: boolean;
      peer: Api.TypeEntityLike;
    }
    export class GetBotApp extends Request<Partial<{
      app: Api.TypeInputBotApp;
      hash: long;
    }>, messages.TypeBotApp> {
    CONSTRUCTOR_ID: 889046467;
    SUBCLASS_OF_ID: 2406630311;
    classType: "request";
    className: "messages.GetBotApp";
    static fromReader(reader: Reader): GetBotApp;
      app: Api.TypeInputBotApp;
      hash: long;
    }
    export class RequestAppWebView extends Request<Partial<{
      // flags: null;
      writeAllowed?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      app: Api.TypeInputBotApp;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }>, Api.TypeWebViewResult> {
    CONSTRUCTOR_ID: 1398901710;
    SUBCLASS_OF_ID: 2479793990;
    classType: "request";
    className: "messages.RequestAppWebView";
    static fromReader(reader: Reader): RequestAppWebView;
      // flags: null;
      writeAllowed?: boolean;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      app: Api.TypeInputBotApp;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }
    export class SetChatWallPaper extends Request<Partial<{
      // flags: null;
      forBoth?: boolean;
      revert?: boolean;
      peer: Api.TypeEntityLike;
      wallpaper?: Api.TypeInputWallPaper;
      settings?: Api.TypeWallPaperSettings;
      id?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2415577825;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SetChatWallPaper";
    static fromReader(reader: Reader): SetChatWallPaper;
      // flags: null;
      forBoth?: boolean;
      revert?: boolean;
      peer: Api.TypeEntityLike;
      wallpaper?: Api.TypeInputWallPaper;
      settings?: Api.TypeWallPaperSettings;
      id?: int;
    }
    export class SearchEmojiStickerSets extends Request<Partial<{
      // flags: null;
      excludeFeatured?: boolean;
      q: string;
      hash: long;
    }>, messages.TypeFoundStickerSets> {
    CONSTRUCTOR_ID: 2461288780;
    SUBCLASS_OF_ID: 68023137;
    classType: "request";
    className: "messages.SearchEmojiStickerSets";
    static fromReader(reader: Reader): SearchEmojiStickerSets;
      // flags: null;
      excludeFeatured?: boolean;
      q: string;
      hash: long;
    }
    export class GetSavedDialogs extends Request<Partial<{
      // flags: null;
      excludePinned?: boolean;
      offsetDate: int;
      offsetId: int;
      offsetPeer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }>, messages.TypeSavedDialogs> {
    CONSTRUCTOR_ID: 1401016858;
    SUBCLASS_OF_ID: 1632352382;
    classType: "request";
    className: "messages.GetSavedDialogs";
    static fromReader(reader: Reader): GetSavedDialogs;
      // flags: null;
      excludePinned?: boolean;
      offsetDate: int;
      offsetId: int;
      offsetPeer: Api.TypeEntityLike;
      limit: int;
      hash: long;
    }
    export class GetSavedHistory extends Request<Partial<{
      peer: Api.TypeEntityLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 1033519437;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetSavedHistory";
    static fromReader(reader: Reader): GetSavedHistory;
      peer: Api.TypeEntityLike;
      offsetId: int;
      offsetDate: int;
      addOffset: int;
      limit: int;
      maxId: int;
      minId: int;
      hash: long;
    }
    export class DeleteSavedHistory extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      maxId: int;
      minDate?: int;
      maxDate?: int;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 1855459371;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "messages.DeleteSavedHistory";
    static fromReader(reader: Reader): DeleteSavedHistory;
      // flags: null;
      peer: Api.TypeEntityLike;
      maxId: int;
      minDate?: int;
      maxDate?: int;
    }
    export class GetPinnedSavedDialogs extends Request<void, messages.TypeSavedDialogs> {
    CONSTRUCTOR_ID: 3594360032;
    SUBCLASS_OF_ID: 1632352382;
    classType: "request";
    className: "messages.GetPinnedSavedDialogs";
    static fromReader(reader: Reader): GetPinnedSavedDialogs;
}
    export class ToggleSavedDialogPin extends Request<Partial<{
      // flags: null;
      pinned?: boolean;
      peer: Api.TypeInputDialogPeer;
    }>, Bool> {
    CONSTRUCTOR_ID: 2894183390;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ToggleSavedDialogPin";
    static fromReader(reader: Reader): ToggleSavedDialogPin;
      // flags: null;
      pinned?: boolean;
      peer: Api.TypeInputDialogPeer;
    }
    export class ReorderPinnedSavedDialogs extends Request<Partial<{
      // flags: null;
      force?: boolean;
      order: Api.TypeInputDialogPeer[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2339464583;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReorderPinnedSavedDialogs";
    static fromReader(reader: Reader): ReorderPinnedSavedDialogs;
      // flags: null;
      force?: boolean;
      order: Api.TypeInputDialogPeer[];
    }
    export class GetSavedReactionTags extends Request<Partial<{
      // flags: null;
      peer?: Api.TypeEntityLike;
      hash: long;
    }>, messages.TypeSavedReactionTags> {
    CONSTRUCTOR_ID: 909631579;
    SUBCLASS_OF_ID: 2744867811;
    classType: "request";
    className: "messages.GetSavedReactionTags";
    static fromReader(reader: Reader): GetSavedReactionTags;
      // flags: null;
      peer?: Api.TypeEntityLike;
      hash: long;
    }
    export class UpdateSavedReactionTag extends Request<Partial<{
      // flags: null;
      reaction: Api.TypeReaction;
      title?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1613331948;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.UpdateSavedReactionTag";
    static fromReader(reader: Reader): UpdateSavedReactionTag;
      // flags: null;
      reaction: Api.TypeReaction;
      title?: string;
    }
    export class GetDefaultTagReactions extends Request<Partial<{
      hash: long;
    }>, messages.TypeReactions> {
    CONSTRUCTOR_ID: 3187225640;
    SUBCLASS_OF_ID: 2915271460;
    classType: "request";
    className: "messages.GetDefaultTagReactions";
    static fromReader(reader: Reader): GetDefaultTagReactions;
      hash: long;
    }
    export class GetOutboxReadDate extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, Api.TypeOutboxReadDate> {
    CONSTRUCTOR_ID: 2353790557;
    SUBCLASS_OF_ID: 1867613126;
    classType: "request";
    className: "messages.GetOutboxReadDate";
    static fromReader(reader: Reader): GetOutboxReadDate;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class GetQuickReplies extends Request<Partial<{
      hash: long;
    }>, messages.TypeQuickReplies> {
    CONSTRUCTOR_ID: 3565417128;
    SUBCLASS_OF_ID: 4147636582;
    classType: "request";
    className: "messages.GetQuickReplies";
    static fromReader(reader: Reader): GetQuickReplies;
      hash: long;
    }
    export class ReorderQuickReplies extends Request<Partial<{
      order: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 1613961479;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReorderQuickReplies";
    static fromReader(reader: Reader): ReorderQuickReplies;
      order: int[];
    }
    export class CheckQuickReplyShortcut extends Request<Partial<{
      shortcut: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 4057005011;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.CheckQuickReplyShortcut";
    static fromReader(reader: Reader): CheckQuickReplyShortcut;
      shortcut: string;
    }
    export class EditQuickReplyShortcut extends Request<Partial<{
      shortcutId: int;
      shortcut: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1543519471;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.EditQuickReplyShortcut";
    static fromReader(reader: Reader): EditQuickReplyShortcut;
      shortcutId: int;
      shortcut: string;
    }
    export class DeleteQuickReplyShortcut extends Request<Partial<{
      shortcutId: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 1019234112;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.DeleteQuickReplyShortcut";
    static fromReader(reader: Reader): DeleteQuickReplyShortcut;
      shortcutId: int;
    }
    export class GetQuickReplyMessages extends Request<Partial<{
      // flags: null;
      shortcutId: int;
      id?: int[];
      hash: long;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 2493814211;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "messages.GetQuickReplyMessages";
    static fromReader(reader: Reader): GetQuickReplyMessages;
      // flags: null;
      shortcutId: int;
      id?: int[];
      hash: long;
    }
    export class SendQuickReplyMessages extends Request<Partial<{
      peer: Api.TypeEntityLike;
      shortcutId: int;
      id: int[];
      randomId: long[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1819610593;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendQuickReplyMessages";
    static fromReader(reader: Reader): SendQuickReplyMessages;
      peer: Api.TypeEntityLike;
      shortcutId: int;
      id: int[];
      randomId: long[];
    }
    export class DeleteQuickReplyMessages extends Request<Partial<{
      shortcutId: int;
      id: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3775260944;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.DeleteQuickReplyMessages";
    static fromReader(reader: Reader): DeleteQuickReplyMessages;
      shortcutId: int;
      id: int[];
    }
    export class ToggleDialogFilterTags extends Request<Partial<{
      enabled: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 4247640649;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ToggleDialogFilterTags";
    static fromReader(reader: Reader): ToggleDialogFilterTags;
      enabled: Bool;
    }
    export class GetMyStickers extends Request<Partial<{
      offsetId: long;
      limit: int;
    }>, messages.TypeMyStickers> {
    CONSTRUCTOR_ID: 3501580796;
    SUBCLASS_OF_ID: 2981377290;
    classType: "request";
    className: "messages.GetMyStickers";
    static fromReader(reader: Reader): GetMyStickers;
      offsetId: long;
      limit: int;
    }
    export class GetEmojiStickerGroups extends Request<Partial<{
      hash: int;
    }>, messages.TypeEmojiGroups> {
    CONSTRUCTOR_ID: 500711669;
    SUBCLASS_OF_ID: 2127189465;
    classType: "request";
    className: "messages.GetEmojiStickerGroups";
    static fromReader(reader: Reader): GetEmojiStickerGroups;
      hash: int;
    }
    export class GetAvailableEffects extends Request<Partial<{
      hash: int;
    }>, messages.TypeAvailableEffects> {
    CONSTRUCTOR_ID: 3735161401;
    SUBCLASS_OF_ID: 1148245437;
    classType: "request";
    className: "messages.GetAvailableEffects";
    static fromReader(reader: Reader): GetAvailableEffects;
      hash: int;
    }
    export class EditFactCheck extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      text: Api.TypeTextWithEntities;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 92925557;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.EditFactCheck";
    static fromReader(reader: Reader): EditFactCheck;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      text: Api.TypeTextWithEntities;
    }
    export class DeleteFactCheck extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3520762892;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.DeleteFactCheck";
    static fromReader(reader: Reader): DeleteFactCheck;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class GetFactCheck extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike[];
    }>, Api.TypeFactCheck[]> {
    CONSTRUCTOR_ID: 3117270510;
    SUBCLASS_OF_ID: 3148224531;
    classType: "request";
    className: "messages.GetFactCheck";
    static fromReader(reader: Reader): GetFactCheck;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike[];
    }
    export class RequestMainWebView extends Request<Partial<{
      // flags: null;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }>, Api.TypeWebViewResult> {
    CONSTRUCTOR_ID: 3386908283;
    SUBCLASS_OF_ID: 2479793990;
    classType: "request";
    className: "messages.RequestMainWebView";
    static fromReader(reader: Reader): RequestMainWebView;
      // flags: null;
      compact?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
      startParam?: string;
      themeParams?: Api.TypeDataJSON;
      platform: string;
    }
    export class SendPaidReaction extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      count: int;
      randomId?: long;
      private?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2648090235;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.SendPaidReaction";
    static fromReader(reader: Reader): SendPaidReaction;
      // flags: null;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      count: int;
      randomId?: long;
      private?: Bool;
    }
    export class TogglePaidReactionPrivacy extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      private: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2224739223;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.TogglePaidReactionPrivacy";
    static fromReader(reader: Reader): TogglePaidReactionPrivacy;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
      private: Bool;
    }
    export class GetPaidReactionPrivacy extends Request<void, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1193563562;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "messages.GetPaidReactionPrivacy";
    static fromReader(reader: Reader): GetPaidReactionPrivacy;
}
    export class ViewSponsoredMessage extends Request<Partial<{
      peer: Api.TypeEntityLike;
      randomId: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 1731909873;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ViewSponsoredMessage";
    static fromReader(reader: Reader): ViewSponsoredMessage;
      peer: Api.TypeEntityLike;
      randomId: bytes;
    }
    export class ClickSponsoredMessage extends Request<Partial<{
      // flags: null;
      media?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      randomId: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 252261477;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ClickSponsoredMessage";
    static fromReader(reader: Reader): ClickSponsoredMessage;
      // flags: null;
      media?: boolean;
      fullscreen?: boolean;
      peer: Api.TypeEntityLike;
      randomId: bytes;
    }
    export class ReportSponsoredMessage extends Request<Partial<{
      peer: Api.TypeEntityLike;
      randomId: bytes;
      option: bytes;
    }>, channels.TypeSponsoredMessageReportResult> {
    CONSTRUCTOR_ID: 452189112;
    SUBCLASS_OF_ID: 639834146;
    classType: "request";
    className: "messages.ReportSponsoredMessage";
    static fromReader(reader: Reader): ReportSponsoredMessage;
      peer: Api.TypeEntityLike;
      randomId: bytes;
      option: bytes;
    }
    export class GetSponsoredMessages extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, messages.TypeSponsoredMessages> {
    CONSTRUCTOR_ID: 2614293561;
    SUBCLASS_OF_ID: 2134993376;
    classType: "request";
    className: "messages.GetSponsoredMessages";
    static fromReader(reader: Reader): GetSponsoredMessages;
      peer: Api.TypeEntityLike;
    }
    export class SavePreparedInlineMessage extends Request<Partial<{
      // flags: null;
      result: Api.TypeInputBotInlineResult;
      userId: Api.TypeEntityLike;
      peerTypes?: Api.TypeInlineQueryPeerType[];
    }>, messages.TypeBotPreparedInlineMessage> {
    CONSTRUCTOR_ID: 4062150447;
    SUBCLASS_OF_ID: 4019263931;
    classType: "request";
    className: "messages.SavePreparedInlineMessage";
    static fromReader(reader: Reader): SavePreparedInlineMessage;
      // flags: null;
      result: Api.TypeInputBotInlineResult;
      userId: Api.TypeEntityLike;
      peerTypes?: Api.TypeInlineQueryPeerType[];
    }
    export class GetPreparedInlineMessage extends Request<Partial<{
      bot: Api.TypeEntityLike;
      id: string;
    }>, messages.TypePreparedInlineMessage> {
    CONSTRUCTOR_ID: 2239675832;
    SUBCLASS_OF_ID: 1225645901;
    classType: "request";
    className: "messages.GetPreparedInlineMessage";
    static fromReader(reader: Reader): GetPreparedInlineMessage;
      bot: Api.TypeEntityLike;
      id: string;
    }
    export class SearchStickers extends Request<Partial<{
      // flags: null;
      emojis?: boolean;
      q: string;
      emoticon: string;
      langCode: string[];
      offset: int;
      limit: int;
      hash: long;
    }>, messages.TypeFoundStickers> {
    CONSTRUCTOR_ID: 699516522;
    SUBCLASS_OF_ID: 104866129;
    classType: "request";
    className: "messages.SearchStickers";
    static fromReader(reader: Reader): SearchStickers;
      // flags: null;
      emojis?: boolean;
      q: string;
      emoticon: string;
      langCode: string[];
      offset: int;
      limit: int;
      hash: long;
    }
    export class ReportMessagesDelivery extends Request<Partial<{
      // flags: null;
      push?: boolean;
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 1517122453;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "messages.ReportMessagesDelivery";
    static fromReader(reader: Reader): ReportMessagesDelivery;
      // flags: null;
      push?: boolean;
      peer: Api.TypeEntityLike;
      id: int[];
    }
  }

  export namespace updates {
    export class GetState extends Request<void, updates.TypeState> {
    CONSTRUCTOR_ID: 3990128682;
    SUBCLASS_OF_ID: 601823745;
    classType: "request";
    className: "updates.GetState";
    static fromReader(reader: Reader): GetState;
}
    export class GetDifference extends Request<Partial<{
      // flags: null;
      pts: int;
      ptsLimit?: int;
      ptsTotalLimit?: int;
      date: int;
      qts: int;
      qtsLimit?: int;
    }>, updates.TypeDifference> {
    CONSTRUCTOR_ID: 432207715;
    SUBCLASS_OF_ID: 541599860;
    classType: "request";
    className: "updates.GetDifference";
    static fromReader(reader: Reader): GetDifference;
      // flags: null;
      pts: int;
      ptsLimit?: int;
      ptsTotalLimit?: int;
      date: int;
      qts: int;
      qtsLimit?: int;
    }
    export class GetChannelDifference extends Request<Partial<{
      // flags: null;
      force?: boolean;
      channel: Api.TypeEntityLike;
      filter: Api.TypeChannelMessagesFilter;
      pts: int;
      limit: int;
    }>, updates.TypeChannelDifference> {
    CONSTRUCTOR_ID: 51854712;
    SUBCLASS_OF_ID: 696872797;
    classType: "request";
    className: "updates.GetChannelDifference";
    static fromReader(reader: Reader): GetChannelDifference;
      // flags: null;
      force?: boolean;
      channel: Api.TypeEntityLike;
      filter: Api.TypeChannelMessagesFilter;
      pts: int;
      limit: int;
    }
  }

  export namespace photos {
    export class UpdateProfilePhoto extends Request<Partial<{
      // flags: null;
      fallback?: boolean;
      bot?: Api.TypeEntityLike;
      id: Api.TypeInputPhoto;
    }>, photos.TypePhoto> {
    CONSTRUCTOR_ID: 166207545;
    SUBCLASS_OF_ID: 3264396580;
    classType: "request";
    className: "photos.UpdateProfilePhoto";
    static fromReader(reader: Reader): UpdateProfilePhoto;
      // flags: null;
      fallback?: boolean;
      bot?: Api.TypeEntityLike;
      id: Api.TypeInputPhoto;
    }
    export class UploadProfilePhoto extends Request<Partial<{
      // flags: null;
      fallback?: boolean;
      bot?: Api.TypeEntityLike;
      file?: Api.TypeInputFile;
      video?: Api.TypeInputFile;
      videoStartTs?: double;
      videoEmojiMarkup?: Api.TypeVideoSize;
    }>, photos.TypePhoto> {
    CONSTRUCTOR_ID: 59286453;
    SUBCLASS_OF_ID: 3264396580;
    classType: "request";
    className: "photos.UploadProfilePhoto";
    static fromReader(reader: Reader): UploadProfilePhoto;
      // flags: null;
      fallback?: boolean;
      bot?: Api.TypeEntityLike;
      file?: Api.TypeInputFile;
      video?: Api.TypeInputFile;
      videoStartTs?: double;
      videoEmojiMarkup?: Api.TypeVideoSize;
    }
    export class DeletePhotos extends Request<Partial<{
      id: Api.TypeInputPhoto[];
    }>, long[]> {
    CONSTRUCTOR_ID: 2278522671;
    SUBCLASS_OF_ID: 2300109160;
    classType: "request";
    className: "photos.DeletePhotos";
    static fromReader(reader: Reader): DeletePhotos;
      id: Api.TypeInputPhoto[];
    }
    export class GetUserPhotos extends Request<Partial<{
      userId: Api.TypeEntityLike;
      offset: int;
      maxId: long;
      limit: int;
    }>, photos.TypePhotos> {
    CONSTRUCTOR_ID: 2446144168;
    SUBCLASS_OF_ID: 667924839;
    classType: "request";
    className: "photos.GetUserPhotos";
    static fromReader(reader: Reader): GetUserPhotos;
      userId: Api.TypeEntityLike;
      offset: int;
      maxId: long;
      limit: int;
    }
    export class UploadContactProfilePhoto extends Request<Partial<{
      // flags: null;
      suggest?: boolean;
      save?: boolean;
      userId: Api.TypeEntityLike;
      file?: Api.TypeInputFile;
      video?: Api.TypeInputFile;
      videoStartTs?: double;
      videoEmojiMarkup?: Api.TypeVideoSize;
    }>, photos.TypePhoto> {
    CONSTRUCTOR_ID: 3779873393;
    SUBCLASS_OF_ID: 3264396580;
    classType: "request";
    className: "photos.UploadContactProfilePhoto";
    static fromReader(reader: Reader): UploadContactProfilePhoto;
      // flags: null;
      suggest?: boolean;
      save?: boolean;
      userId: Api.TypeEntityLike;
      file?: Api.TypeInputFile;
      video?: Api.TypeInputFile;
      videoStartTs?: double;
      videoEmojiMarkup?: Api.TypeVideoSize;
    }
  }

  export namespace upload {
    export class SaveFilePart extends Request<Partial<{
      fileId: long;
      filePart: int;
      bytes: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 3003426337;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "upload.SaveFilePart";
    static fromReader(reader: Reader): SaveFilePart;
      fileId: long;
      filePart: int;
      bytes: bytes;
    }
    export class GetFile extends Request<Partial<{
      // flags: null;
      precise?: boolean;
      cdnSupported?: boolean;
      location: Api.TypeInputFileLocation;
      offset: long;
      limit: int;
    }>, upload.TypeFile> {
    CONSTRUCTOR_ID: 3193124286;
    SUBCLASS_OF_ID: 1822152488;
    classType: "request";
    className: "upload.GetFile";
    static fromReader(reader: Reader): GetFile;
      // flags: null;
      precise?: boolean;
      cdnSupported?: boolean;
      location: Api.TypeInputFileLocation;
      offset: long;
      limit: int;
    }
    export class SaveBigFilePart extends Request<Partial<{
      fileId: long;
      filePart: int;
      fileTotalParts: int;
      bytes: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 3732629309;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "upload.SaveBigFilePart";
    static fromReader(reader: Reader): SaveBigFilePart;
      fileId: long;
      filePart: int;
      fileTotalParts: int;
      bytes: bytes;
    }
    export class GetWebFile extends Request<Partial<{
      location: Api.TypeInputWebFileLocation;
      offset: int;
      limit: int;
    }>, upload.TypeWebFile> {
    CONSTRUCTOR_ID: 619086221;
    SUBCLASS_OF_ID: 1760657233;
    classType: "request";
    className: "upload.GetWebFile";
    static fromReader(reader: Reader): GetWebFile;
      location: Api.TypeInputWebFileLocation;
      offset: int;
      limit: int;
    }
    export class GetCdnFile extends Request<Partial<{
      fileToken: bytes;
      offset: long;
      limit: int;
    }>, upload.TypeCdnFile> {
    CONSTRUCTOR_ID: 962554330;
    SUBCLASS_OF_ID: 4123851048;
    classType: "request";
    className: "upload.GetCdnFile";
    static fromReader(reader: Reader): GetCdnFile;
      fileToken: bytes;
      offset: long;
      limit: int;
    }
    export class ReuploadCdnFile extends Request<Partial<{
      fileToken: bytes;
      requestToken: bytes;
    }>, Api.TypeFileHash[]> {
    CONSTRUCTOR_ID: 2603046056;
    SUBCLASS_OF_ID: 2777941798;
    classType: "request";
    className: "upload.ReuploadCdnFile";
    static fromReader(reader: Reader): ReuploadCdnFile;
      fileToken: bytes;
      requestToken: bytes;
    }
    export class GetCdnFileHashes extends Request<Partial<{
      fileToken: bytes;
      offset: long;
    }>, Api.TypeFileHash[]> {
    CONSTRUCTOR_ID: 2447130417;
    SUBCLASS_OF_ID: 2777941798;
    classType: "request";
    className: "upload.GetCdnFileHashes";
    static fromReader(reader: Reader): GetCdnFileHashes;
      fileToken: bytes;
      offset: long;
    }
    export class GetFileHashes extends Request<Partial<{
      location: Api.TypeInputFileLocation;
      offset: long;
    }>, Api.TypeFileHash[]> {
    CONSTRUCTOR_ID: 2438371370;
    SUBCLASS_OF_ID: 2777941798;
    classType: "request";
    className: "upload.GetFileHashes";
    static fromReader(reader: Reader): GetFileHashes;
      location: Api.TypeInputFileLocation;
      offset: long;
    }
  }

  export namespace help {
    export class GetConfig extends Request<void, Api.TypeConfig> {
    CONSTRUCTOR_ID: 3304659051;
    SUBCLASS_OF_ID: 3542493770;
    classType: "request";
    className: "help.GetConfig";
    static fromReader(reader: Reader): GetConfig;
}
    export class GetNearestDc extends Request<void, Api.TypeNearestDc> {
    CONSTRUCTOR_ID: 531836966;
    SUBCLASS_OF_ID: 947323999;
    classType: "request";
    className: "help.GetNearestDc";
    static fromReader(reader: Reader): GetNearestDc;
}
    export class GetAppUpdate extends Request<Partial<{
      source: string;
    }>, help.TypeAppUpdate> {
    CONSTRUCTOR_ID: 1378703997;
    SUBCLASS_OF_ID: 1486292638;
    classType: "request";
    className: "help.GetAppUpdate";
    static fromReader(reader: Reader): GetAppUpdate;
      source: string;
    }
    export class GetInviteText extends Request<void, help.TypeInviteText> {
    CONSTRUCTOR_ID: 1295590211;
    SUBCLASS_OF_ID: 3480267317;
    classType: "request";
    className: "help.GetInviteText";
    static fromReader(reader: Reader): GetInviteText;
}
    export class GetSupport extends Request<void, help.TypeSupport> {
    CONSTRUCTOR_ID: 2631862477;
    SUBCLASS_OF_ID: 1901706475;
    classType: "request";
    className: "help.GetSupport";
    static fromReader(reader: Reader): GetSupport;
}
    export class SetBotUpdatesStatus extends Request<Partial<{
      pendingUpdatesCount: int;
      message: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3961704397;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "help.SetBotUpdatesStatus";
    static fromReader(reader: Reader): SetBotUpdatesStatus;
      pendingUpdatesCount: int;
      message: string;
    }
    export class GetCdnConfig extends Request<void, Api.TypeCdnConfig> {
    CONSTRUCTOR_ID: 1375900482;
    SUBCLASS_OF_ID: 3973724540;
    classType: "request";
    className: "help.GetCdnConfig";
    static fromReader(reader: Reader): GetCdnConfig;
}
    export class GetRecentMeUrls extends Request<Partial<{
      referer: string;
    }>, help.TypeRecentMeUrls> {
    CONSTRUCTOR_ID: 1036054804;
    SUBCLASS_OF_ID: 4067017847;
    classType: "request";
    className: "help.GetRecentMeUrls";
    static fromReader(reader: Reader): GetRecentMeUrls;
      referer: string;
    }
    export class GetTermsOfServiceUpdate extends Request<void, help.TypeTermsOfServiceUpdate> {
    CONSTRUCTOR_ID: 749019089;
    SUBCLASS_OF_ID: 691808631;
    classType: "request";
    className: "help.GetTermsOfServiceUpdate";
    static fromReader(reader: Reader): GetTermsOfServiceUpdate;
}
    export class AcceptTermsOfService extends Request<Partial<{
      id: Api.TypeDataJSON;
    }>, Bool> {
    CONSTRUCTOR_ID: 4000511898;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "help.AcceptTermsOfService";
    static fromReader(reader: Reader): AcceptTermsOfService;
      id: Api.TypeDataJSON;
    }
    export class GetDeepLinkInfo extends Request<Partial<{
      path: string;
    }>, help.TypeDeepLinkInfo> {
    CONSTRUCTOR_ID: 1072547679;
    SUBCLASS_OF_ID: 2555030584;
    classType: "request";
    className: "help.GetDeepLinkInfo";
    static fromReader(reader: Reader): GetDeepLinkInfo;
      path: string;
    }
    export class GetAppConfig extends Request<Partial<{
      hash: int;
    }>, help.TypeAppConfig> {
    CONSTRUCTOR_ID: 1642330196;
    SUBCLASS_OF_ID: 339221658;
    classType: "request";
    className: "help.GetAppConfig";
    static fromReader(reader: Reader): GetAppConfig;
      hash: int;
    }
    export class SaveAppLog extends Request<Partial<{
      events: Api.TypeInputAppEvent[];
    }>, Bool> {
    CONSTRUCTOR_ID: 1862465352;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "help.SaveAppLog";
    static fromReader(reader: Reader): SaveAppLog;
      events: Api.TypeInputAppEvent[];
    }
    export class GetPassportConfig extends Request<Partial<{
      hash: int;
    }>, help.TypePassportConfig> {
    CONSTRUCTOR_ID: 3328290056;
    SUBCLASS_OF_ID: 3328622765;
    classType: "request";
    className: "help.GetPassportConfig";
    static fromReader(reader: Reader): GetPassportConfig;
      hash: int;
    }
    export class GetSupportName extends Request<void, help.TypeSupportName> {
    CONSTRUCTOR_ID: 3546343212;
    SUBCLASS_OF_ID: 2135996354;
    classType: "request";
    className: "help.GetSupportName";
    static fromReader(reader: Reader): GetSupportName;
}
    export class GetUserInfo extends Request<Partial<{
      userId: Api.TypeEntityLike;
    }>, help.TypeUserInfo> {
    CONSTRUCTOR_ID: 59377875;
    SUBCLASS_OF_ID: 1548998616;
    classType: "request";
    className: "help.GetUserInfo";
    static fromReader(reader: Reader): GetUserInfo;
      userId: Api.TypeEntityLike;
    }
    export class EditUserInfo extends Request<Partial<{
      userId: Api.TypeEntityLike;
      message: string;
      entities: Api.TypeMessageEntity[];
    }>, help.TypeUserInfo> {
    CONSTRUCTOR_ID: 1723407216;
    SUBCLASS_OF_ID: 1548998616;
    classType: "request";
    className: "help.EditUserInfo";
    static fromReader(reader: Reader): EditUserInfo;
      userId: Api.TypeEntityLike;
      message: string;
      entities: Api.TypeMessageEntity[];
    }
    export class GetPromoData extends Request<void, help.TypePromoData> {
    CONSTRUCTOR_ID: 3231151137;
    SUBCLASS_OF_ID: 2639877442;
    classType: "request";
    className: "help.GetPromoData";
    static fromReader(reader: Reader): GetPromoData;
}
    export class HidePromoData extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 505748629;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "help.HidePromoData";
    static fromReader(reader: Reader): HidePromoData;
      peer: Api.TypeEntityLike;
    }
    export class DismissSuggestion extends Request<Partial<{
      peer: Api.TypeEntityLike;
      suggestion: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 4111317665;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "help.DismissSuggestion";
    static fromReader(reader: Reader): DismissSuggestion;
      peer: Api.TypeEntityLike;
      suggestion: string;
    }
    export class GetCountriesList extends Request<Partial<{
      langCode: string;
      hash: int;
    }>, help.TypeCountriesList> {
    CONSTRUCTOR_ID: 1935116200;
    SUBCLASS_OF_ID: 3929144968;
    classType: "request";
    className: "help.GetCountriesList";
    static fromReader(reader: Reader): GetCountriesList;
      langCode: string;
      hash: int;
    }
    export class GetPremiumPromo extends Request<void, help.TypePremiumPromo> {
    CONSTRUCTOR_ID: 3088815060;
    SUBCLASS_OF_ID: 3381109560;
    classType: "request";
    className: "help.GetPremiumPromo";
    static fromReader(reader: Reader): GetPremiumPromo;
}
    export class GetPeerColors extends Request<Partial<{
      hash: int;
    }>, help.TypePeerColors> {
    CONSTRUCTOR_ID: 3665884207;
    SUBCLASS_OF_ID: 239036211;
    classType: "request";
    className: "help.GetPeerColors";
    static fromReader(reader: Reader): GetPeerColors;
      hash: int;
    }
    export class GetPeerProfileColors extends Request<Partial<{
      hash: int;
    }>, help.TypePeerColors> {
    CONSTRUCTOR_ID: 2882513405;
    SUBCLASS_OF_ID: 239036211;
    classType: "request";
    className: "help.GetPeerProfileColors";
    static fromReader(reader: Reader): GetPeerProfileColors;
      hash: int;
    }
    export class GetTimezonesList extends Request<Partial<{
      hash: int;
    }>, help.TypeTimezonesList> {
    CONSTRUCTOR_ID: 1236468288;
    SUBCLASS_OF_ID: 3396789365;
    classType: "request";
    className: "help.GetTimezonesList";
    static fromReader(reader: Reader): GetTimezonesList;
      hash: int;
    }
  }

  export namespace channels {
    export class ReadHistory extends Request<Partial<{
      channel: Api.TypeEntityLike;
      maxId: int;
    }>, Bool> {
    CONSTRUCTOR_ID: 3423619383;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ReadHistory";
    static fromReader(reader: Reader): ReadHistory;
      channel: Api.TypeEntityLike;
      maxId: int;
    }
    export class DeleteMessages extends Request<Partial<{
      channel: Api.TypeEntityLike;
      id: int[];
    }>, messages.TypeAffectedMessages> {
    CONSTRUCTOR_ID: 2227305806;
    SUBCLASS_OF_ID: 3469983854;
    classType: "request";
    className: "channels.DeleteMessages";
    static fromReader(reader: Reader): DeleteMessages;
      channel: Api.TypeEntityLike;
      id: int[];
    }
    export class ReportSpam extends Request<Partial<{
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
      id: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 4098523925;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ReportSpam";
    static fromReader(reader: Reader): ReportSpam;
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
      id: int[];
    }
    export class GetMessages extends Request<Partial<{
      channel: Api.TypeEntityLike;
      id: Api.TypeInputMessage[];
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 2911672867;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "channels.GetMessages";
    static fromReader(reader: Reader): GetMessages;
      channel: Api.TypeEntityLike;
      id: Api.TypeInputMessage[];
    }
    export class GetParticipants extends Request<Partial<{
      channel: Api.TypeEntityLike;
      filter: Api.TypeChannelParticipantsFilter;
      offset: int;
      limit: int;
      hash: long;
    }>, channels.TypeChannelParticipants> {
    CONSTRUCTOR_ID: 2010044880;
    SUBCLASS_OF_ID: 3859443300;
    classType: "request";
    className: "channels.GetParticipants";
    static fromReader(reader: Reader): GetParticipants;
      channel: Api.TypeEntityLike;
      filter: Api.TypeChannelParticipantsFilter;
      offset: int;
      limit: int;
      hash: long;
    }
    export class GetParticipant extends Request<Partial<{
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
    }>, channels.TypeChannelParticipant> {
    CONSTRUCTOR_ID: 2695589062;
    SUBCLASS_OF_ID: 1717048602;
    classType: "request";
    className: "channels.GetParticipant";
    static fromReader(reader: Reader): GetParticipant;
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
    }
    export class GetChannels extends Request<Partial<{
      id: Api.TypeEntityLike[];
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 176122811;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "channels.GetChannels";
    static fromReader(reader: Reader): GetChannels;
      id: Api.TypeEntityLike[];
    }
    export class GetFullChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, messages.TypeChatFull> {
    CONSTRUCTOR_ID: 141781513;
    SUBCLASS_OF_ID: 576344329;
    classType: "request";
    className: "channels.GetFullChannel";
    static fromReader(reader: Reader): GetFullChannel;
      channel: Api.TypeEntityLike;
    }
    export class CreateChannel extends Request<Partial<{
      // flags: null;
      broadcast?: boolean;
      megagroup?: boolean;
      forImport?: boolean;
      forum?: boolean;
      title: string;
      about: string;
      geoPoint?: Api.TypeInputGeoPoint;
      address?: string;
      ttlPeriod?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2432722695;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.CreateChannel";
    static fromReader(reader: Reader): CreateChannel;
      // flags: null;
      broadcast?: boolean;
      megagroup?: boolean;
      forImport?: boolean;
      forum?: boolean;
      title: string;
      about: string;
      geoPoint?: Api.TypeInputGeoPoint;
      address?: string;
      ttlPeriod?: int;
    }
    export class EditAdmin extends Request<Partial<{
      channel: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
      adminRights: Api.TypeChatAdminRights;
      rank: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3543959810;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditAdmin";
    static fromReader(reader: Reader): EditAdmin;
      channel: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
      adminRights: Api.TypeChatAdminRights;
      rank: string;
    }
    export class EditTitle extends Request<Partial<{
      channel: Api.TypeEntityLike;
      title: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1450044624;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditTitle";
    static fromReader(reader: Reader): EditTitle;
      channel: Api.TypeEntityLike;
      title: string;
    }
    export class EditPhoto extends Request<Partial<{
      channel: Api.TypeEntityLike;
      photo: Api.TypeInputChatPhoto;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4046346185;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditPhoto";
    static fromReader(reader: Reader): EditPhoto;
      channel: Api.TypeEntityLike;
      photo: Api.TypeInputChatPhoto;
    }
    export class CheckUsername extends Request<Partial<{
      channel: Api.TypeEntityLike;
      username: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 283557164;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.CheckUsername";
    static fromReader(reader: Reader): CheckUsername;
      channel: Api.TypeEntityLike;
      username: string;
    }
    export class UpdateUsername extends Request<Partial<{
      channel: Api.TypeEntityLike;
      username: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 890549214;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.UpdateUsername";
    static fromReader(reader: Reader): UpdateUsername;
      channel: Api.TypeEntityLike;
      username: string;
    }
    export class JoinChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 615851205;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.JoinChannel";
    static fromReader(reader: Reader): JoinChannel;
      channel: Api.TypeEntityLike;
    }
    export class LeaveChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4164332181;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.LeaveChannel";
    static fromReader(reader: Reader): LeaveChannel;
      channel: Api.TypeEntityLike;
    }
    export class InviteToChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
      users: Api.TypeEntityLike[];
    }>, messages.TypeInvitedUsers> {
    CONSTRUCTOR_ID: 3387112788;
    SUBCLASS_OF_ID: 1035899041;
    classType: "request";
    className: "channels.InviteToChannel";
    static fromReader(reader: Reader): InviteToChannel;
      channel: Api.TypeEntityLike;
      users: Api.TypeEntityLike[];
    }
    export class DeleteChannel extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3222347747;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.DeleteChannel";
    static fromReader(reader: Reader): DeleteChannel;
      channel: Api.TypeEntityLike;
    }
    export class ExportMessageLink extends Request<Partial<{
      // flags: null;
      grouped?: boolean;
      thread?: boolean;
      channel: Api.TypeEntityLike;
      id: int;
    }>, Api.TypeExportedMessageLink> {
    CONSTRUCTOR_ID: 3862932971;
    SUBCLASS_OF_ID: 3739632844;
    classType: "request";
    className: "channels.ExportMessageLink";
    static fromReader(reader: Reader): ExportMessageLink;
      // flags: null;
      grouped?: boolean;
      thread?: boolean;
      channel: Api.TypeEntityLike;
      id: int;
    }
    export class ToggleSignatures extends Request<Partial<{
      // flags: null;
      signaturesEnabled?: boolean;
      profilesEnabled?: boolean;
      channel: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1099781276;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleSignatures";
    static fromReader(reader: Reader): ToggleSignatures;
      // flags: null;
      signaturesEnabled?: boolean;
      profilesEnabled?: boolean;
      channel: Api.TypeEntityLike;
    }
    export class GetAdminedPublicChannels extends Request<Partial<{
      // flags: null;
      byLocation?: boolean;
      checkLimit?: boolean;
      forPersonal?: boolean;
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 4172297903;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "channels.GetAdminedPublicChannels";
    static fromReader(reader: Reader): GetAdminedPublicChannels;
      // flags: null;
      byLocation?: boolean;
      checkLimit?: boolean;
      forPersonal?: boolean;
    }
    export class EditBanned extends Request<Partial<{
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
      bannedRights: Api.TypeChatBannedRights;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2531708289;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditBanned";
    static fromReader(reader: Reader): EditBanned;
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
      bannedRights: Api.TypeChatBannedRights;
    }
    export class GetAdminLog extends Request<Partial<{
      // flags: null;
      channel: Api.TypeEntityLike;
      q: string;
      eventsFilter?: Api.TypeChannelAdminLogEventsFilter;
      admins?: Api.TypeEntityLike[];
      maxId: long;
      minId: long;
      limit: int;
    }>, channels.TypeAdminLogResults> {
    CONSTRUCTOR_ID: 870184064;
    SUBCLASS_OF_ID: 1374713532;
    classType: "request";
    className: "channels.GetAdminLog";
    static fromReader(reader: Reader): GetAdminLog;
      // flags: null;
      channel: Api.TypeEntityLike;
      q: string;
      eventsFilter?: Api.TypeChannelAdminLogEventsFilter;
      admins?: Api.TypeEntityLike[];
      maxId: long;
      minId: long;
      limit: int;
    }
    export class SetStickers extends Request<Partial<{
      channel: Api.TypeEntityLike;
      stickerset: Api.TypeInputStickerSet;
    }>, Bool> {
    CONSTRUCTOR_ID: 3935085817;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.SetStickers";
    static fromReader(reader: Reader): SetStickers;
      channel: Api.TypeEntityLike;
      stickerset: Api.TypeInputStickerSet;
    }
    export class ReadMessageContents extends Request<Partial<{
      channel: Api.TypeEntityLike;
      id: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3937786936;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ReadMessageContents";
    static fromReader(reader: Reader): ReadMessageContents;
      channel: Api.TypeEntityLike;
      id: int[];
    }
    export class DeleteHistory extends Request<Partial<{
      // flags: null;
      forEveryone?: boolean;
      channel: Api.TypeEntityLike;
      maxId: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2611648071;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.DeleteHistory";
    static fromReader(reader: Reader): DeleteHistory;
      // flags: null;
      forEveryone?: boolean;
      channel: Api.TypeEntityLike;
      maxId: int;
    }
    export class TogglePreHistoryHidden extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3938171212;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.TogglePreHistoryHidden";
    static fromReader(reader: Reader): TogglePreHistoryHidden;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class GetLeftChannels extends Request<Partial<{
      offset: int;
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 2202135744;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "channels.GetLeftChannels";
    static fromReader(reader: Reader): GetLeftChannels;
      offset: int;
    }
    export class GetGroupsForDiscussion extends Request<void, messages.TypeChats> {
    CONSTRUCTOR_ID: 4124758904;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "channels.GetGroupsForDiscussion";
    static fromReader(reader: Reader): GetGroupsForDiscussion;
}
    export class SetDiscussionGroup extends Request<Partial<{
      broadcast: Api.TypeEntityLike;
      group: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1079520178;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.SetDiscussionGroup";
    static fromReader(reader: Reader): SetDiscussionGroup;
      broadcast: Api.TypeEntityLike;
      group: Api.TypeEntityLike;
    }
    export class EditCreator extends Request<Partial<{
      channel: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
      password: Api.TypeInputCheckPasswordSRP;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2402864415;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditCreator";
    static fromReader(reader: Reader): EditCreator;
      channel: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class EditLocation extends Request<Partial<{
      channel: Api.TypeEntityLike;
      geoPoint: Api.TypeInputGeoPoint;
      address: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1491484525;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.EditLocation";
    static fromReader(reader: Reader): EditLocation;
      channel: Api.TypeEntityLike;
      geoPoint: Api.TypeInputGeoPoint;
      address: string;
    }
    export class ToggleSlowMode extends Request<Partial<{
      channel: Api.TypeEntityLike;
      seconds: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3990134512;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleSlowMode";
    static fromReader(reader: Reader): ToggleSlowMode;
      channel: Api.TypeEntityLike;
      seconds: int;
    }
    export class GetInactiveChannels extends Request<void, messages.TypeInactiveChats> {
    CONSTRUCTOR_ID: 300429806;
    SUBCLASS_OF_ID: 2348013524;
    classType: "request";
    className: "channels.GetInactiveChannels";
    static fromReader(reader: Reader): GetInactiveChannels;
}
    export class ConvertToGigagroup extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 187239529;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ConvertToGigagroup";
    static fromReader(reader: Reader): ConvertToGigagroup;
      channel: Api.TypeEntityLike;
    }
    export class GetSendAs extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, channels.TypeSendAsPeers> {
    CONSTRUCTOR_ID: 231174382;
    SUBCLASS_OF_ID: 952864033;
    classType: "request";
    className: "channels.GetSendAs";
    static fromReader(reader: Reader): GetSendAs;
      peer: Api.TypeEntityLike;
    }
    export class DeleteParticipantHistory extends Request<Partial<{
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 913655003;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "channels.DeleteParticipantHistory";
    static fromReader(reader: Reader): DeleteParticipantHistory;
      channel: Api.TypeEntityLike;
      participant: Api.TypeEntityLike;
    }
    export class ToggleJoinToSend extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3838547328;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleJoinToSend";
    static fromReader(reader: Reader): ToggleJoinToSend;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class ToggleJoinRequest extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1277789622;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleJoinRequest";
    static fromReader(reader: Reader): ToggleJoinRequest;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class ReorderUsernames extends Request<Partial<{
      channel: Api.TypeEntityLike;
      order: string[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3025988893;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ReorderUsernames";
    static fromReader(reader: Reader): ReorderUsernames;
      channel: Api.TypeEntityLike;
      order: string[];
    }
    export class ToggleUsername extends Request<Partial<{
      channel: Api.TypeEntityLike;
      username: string;
      active: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 1358053637;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ToggleUsername";
    static fromReader(reader: Reader): ToggleUsername;
      channel: Api.TypeEntityLike;
      username: string;
      active: Bool;
    }
    export class DeactivateAllUsernames extends Request<Partial<{
      channel: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 170155475;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.DeactivateAllUsernames";
    static fromReader(reader: Reader): DeactivateAllUsernames;
      channel: Api.TypeEntityLike;
    }
    export class ToggleForum extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2754186025;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleForum";
    static fromReader(reader: Reader): ToggleForum;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class CreateForumTopic extends Request<Partial<{
      // flags: null;
      channel: Api.TypeEntityLike;
      title: string;
      iconColor?: int;
      iconEmojiId?: long;
      randomId?: long;
      sendAs?: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4094427684;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.CreateForumTopic";
    static fromReader(reader: Reader): CreateForumTopic;
      // flags: null;
      channel: Api.TypeEntityLike;
      title: string;
      iconColor?: int;
      iconEmojiId?: long;
      randomId?: long;
      sendAs?: Api.TypeEntityLike;
    }
    export class GetForumTopics extends Request<Partial<{
      // flags: null;
      channel: Api.TypeEntityLike;
      q?: string;
      offsetDate: int;
      offsetId: int;
      offsetTopic: int;
      limit: int;
    }>, messages.TypeForumTopics> {
    CONSTRUCTOR_ID: 233136337;
    SUBCLASS_OF_ID: 2384281118;
    classType: "request";
    className: "channels.GetForumTopics";
    static fromReader(reader: Reader): GetForumTopics;
      // flags: null;
      channel: Api.TypeEntityLike;
      q?: string;
      offsetDate: int;
      offsetId: int;
      offsetTopic: int;
      limit: int;
    }
    export class GetForumTopicsByID extends Request<Partial<{
      channel: Api.TypeEntityLike;
      topics: int[];
    }>, messages.TypeForumTopics> {
    CONSTRUCTOR_ID: 2961383097;
    SUBCLASS_OF_ID: 2384281118;
    classType: "request";
    className: "channels.GetForumTopicsByID";
    static fromReader(reader: Reader): GetForumTopicsByID;
      channel: Api.TypeEntityLike;
      topics: int[];
    }
    export class EditForumTopic extends Request<Partial<{
      // flags: null;
      channel: Api.TypeEntityLike;
      topicId: int;
      title?: string;
      iconEmojiId?: long;
      closed?: Bool;
      hidden?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4108296581;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.EditForumTopic";
    static fromReader(reader: Reader): EditForumTopic;
      // flags: null;
      channel: Api.TypeEntityLike;
      topicId: int;
      title?: string;
      iconEmojiId?: long;
      closed?: Bool;
      hidden?: Bool;
    }
    export class UpdatePinnedForumTopic extends Request<Partial<{
      channel: Api.TypeEntityLike;
      topicId: int;
      pinned: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1814925350;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.UpdatePinnedForumTopic";
    static fromReader(reader: Reader): UpdatePinnedForumTopic;
      channel: Api.TypeEntityLike;
      topicId: int;
      pinned: Bool;
    }
    export class DeleteTopicHistory extends Request<Partial<{
      channel: Api.TypeEntityLike;
      topMsgId: MessageIDLike;
    }>, messages.TypeAffectedHistory> {
    CONSTRUCTOR_ID: 876830509;
    SUBCLASS_OF_ID: 743031062;
    classType: "request";
    className: "channels.DeleteTopicHistory";
    static fromReader(reader: Reader): DeleteTopicHistory;
      channel: Api.TypeEntityLike;
      topMsgId: MessageIDLike;
    }
    export class ReorderPinnedForumTopics extends Request<Partial<{
      // flags: null;
      force?: boolean;
      channel: Api.TypeEntityLike;
      order: int[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 693150095;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ReorderPinnedForumTopics";
    static fromReader(reader: Reader): ReorderPinnedForumTopics;
      // flags: null;
      force?: boolean;
      channel: Api.TypeEntityLike;
      order: int[];
    }
    export class ToggleAntiSpam extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1760814315;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleAntiSpam";
    static fromReader(reader: Reader): ToggleAntiSpam;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class ReportAntiSpamFalsePositive extends Request<Partial<{
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 2823857811;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.ReportAntiSpamFalsePositive";
    static fromReader(reader: Reader): ReportAntiSpamFalsePositive;
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class ToggleParticipantsHidden extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1785624660;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleParticipantsHidden";
    static fromReader(reader: Reader): ToggleParticipantsHidden;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class UpdateColor extends Request<Partial<{
      // flags: null;
      forProfile?: boolean;
      channel: Api.TypeEntityLike;
      color?: int;
      backgroundEmojiId?: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3635033713;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.UpdateColor";
    static fromReader(reader: Reader): UpdateColor;
      // flags: null;
      forProfile?: boolean;
      channel: Api.TypeEntityLike;
      color?: int;
      backgroundEmojiId?: long;
    }
    export class ToggleViewForumAsMessages extends Request<Partial<{
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2537077525;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.ToggleViewForumAsMessages";
    static fromReader(reader: Reader): ToggleViewForumAsMessages;
      channel: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class GetChannelRecommendations extends Request<Partial<{
      // flags: null;
      channel?: Api.TypeEntityLike;
    }>, messages.TypeChats> {
    CONSTRUCTOR_ID: 631707458;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "channels.GetChannelRecommendations";
    static fromReader(reader: Reader): GetChannelRecommendations;
      // flags: null;
      channel?: Api.TypeEntityLike;
    }
    export class UpdateEmojiStatus extends Request<Partial<{
      channel: Api.TypeEntityLike;
      emojiStatus: Api.TypeEmojiStatus;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4040418984;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.UpdateEmojiStatus";
    static fromReader(reader: Reader): UpdateEmojiStatus;
      channel: Api.TypeEntityLike;
      emojiStatus: Api.TypeEmojiStatus;
    }
    export class SetBoostsToUnblockRestrictions extends Request<Partial<{
      channel: Api.TypeEntityLike;
      boosts: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2906234094;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.SetBoostsToUnblockRestrictions";
    static fromReader(reader: Reader): SetBoostsToUnblockRestrictions;
      channel: Api.TypeEntityLike;
      boosts: int;
    }
    export class SetEmojiStickers extends Request<Partial<{
      channel: Api.TypeEntityLike;
      stickerset: Api.TypeInputStickerSet;
    }>, Bool> {
    CONSTRUCTOR_ID: 1020866743;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "channels.SetEmojiStickers";
    static fromReader(reader: Reader): SetEmojiStickers;
      channel: Api.TypeEntityLike;
      stickerset: Api.TypeInputStickerSet;
    }
    export class RestrictSponsoredMessages extends Request<Partial<{
      channel: Api.TypeEntityLike;
      restricted: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2598966553;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "channels.RestrictSponsoredMessages";
    static fromReader(reader: Reader): RestrictSponsoredMessages;
      channel: Api.TypeEntityLike;
      restricted: Bool;
    }
    export class SearchPosts extends Request<Partial<{
      hashtag: string;
      offsetRate: int;
      offsetPeer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }>, messages.TypeMessages> {
    CONSTRUCTOR_ID: 3516897403;
    SUBCLASS_OF_ID: 3568569182;
    classType: "request";
    className: "channels.SearchPosts";
    static fromReader(reader: Reader): SearchPosts;
      hashtag: string;
      offsetRate: int;
      offsetPeer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }
  }

  export namespace bots {
    export class SendCustomRequest extends Request<Partial<{
      customMethod: string;
      params: Api.TypeDataJSON;
    }>, Api.TypeDataJSON> {
    CONSTRUCTOR_ID: 2854709741;
    SUBCLASS_OF_ID: 2902676200;
    classType: "request";
    className: "bots.SendCustomRequest";
    static fromReader(reader: Reader): SendCustomRequest;
      customMethod: string;
      params: Api.TypeDataJSON;
    }
    export class AnswerWebhookJSONQuery extends Request<Partial<{
      queryId: long;
      data: Api.TypeDataJSON;
    }>, Bool> {
    CONSTRUCTOR_ID: 3860938573;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.AnswerWebhookJSONQuery";
    static fromReader(reader: Reader): AnswerWebhookJSONQuery;
      queryId: long;
      data: Api.TypeDataJSON;
    }
    export class SetBotCommands extends Request<Partial<{
      scope: Api.TypeBotCommandScope;
      langCode: string;
      commands: Api.TypeBotCommand[];
    }>, Bool> {
    CONSTRUCTOR_ID: 85399130;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetBotCommands";
    static fromReader(reader: Reader): SetBotCommands;
      scope: Api.TypeBotCommandScope;
      langCode: string;
      commands: Api.TypeBotCommand[];
    }
    export class ResetBotCommands extends Request<Partial<{
      scope: Api.TypeBotCommandScope;
      langCode: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1032708345;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.ResetBotCommands";
    static fromReader(reader: Reader): ResetBotCommands;
      scope: Api.TypeBotCommandScope;
      langCode: string;
    }
    export class GetBotCommands extends Request<Partial<{
      scope: Api.TypeBotCommandScope;
      langCode: string;
    }>, Api.TypeBotCommand[]> {
    CONSTRUCTOR_ID: 3813412310;
    SUBCLASS_OF_ID: 4209579305;
    classType: "request";
    className: "bots.GetBotCommands";
    static fromReader(reader: Reader): GetBotCommands;
      scope: Api.TypeBotCommandScope;
      langCode: string;
    }
    export class SetBotMenuButton extends Request<Partial<{
      userId: Api.TypeEntityLike;
      button: Api.TypeBotMenuButton;
    }>, Bool> {
    CONSTRUCTOR_ID: 1157944655;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetBotMenuButton";
    static fromReader(reader: Reader): SetBotMenuButton;
      userId: Api.TypeEntityLike;
      button: Api.TypeBotMenuButton;
    }
    export class GetBotMenuButton extends Request<Partial<{
      userId: Api.TypeEntityLike;
    }>, Api.TypeBotMenuButton> {
    CONSTRUCTOR_ID: 2623597352;
    SUBCLASS_OF_ID: 1282522428;
    classType: "request";
    className: "bots.GetBotMenuButton";
    static fromReader(reader: Reader): GetBotMenuButton;
      userId: Api.TypeEntityLike;
    }
    export class SetBotBroadcastDefaultAdminRights extends Request<Partial<{
      adminRights: Api.TypeChatAdminRights;
    }>, Bool> {
    CONSTRUCTOR_ID: 2021942497;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetBotBroadcastDefaultAdminRights";
    static fromReader(reader: Reader): SetBotBroadcastDefaultAdminRights;
      adminRights: Api.TypeChatAdminRights;
    }
    export class SetBotGroupDefaultAdminRights extends Request<Partial<{
      adminRights: Api.TypeChatAdminRights;
    }>, Bool> {
    CONSTRUCTOR_ID: 2455685610;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetBotGroupDefaultAdminRights";
    static fromReader(reader: Reader): SetBotGroupDefaultAdminRights;
      adminRights: Api.TypeChatAdminRights;
    }
    export class SetBotInfo extends Request<Partial<{
      // flags: null;
      bot?: Api.TypeEntityLike;
      langCode: string;
      name?: string;
      about?: string;
      description?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 282013987;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetBotInfo";
    static fromReader(reader: Reader): SetBotInfo;
      // flags: null;
      bot?: Api.TypeEntityLike;
      langCode: string;
      name?: string;
      about?: string;
      description?: string;
    }
    export class GetBotInfo extends Request<Partial<{
      // flags: null;
      bot?: Api.TypeEntityLike;
      langCode: string;
    }>, bots.TypeBotInfo> {
    CONSTRUCTOR_ID: 3705214205;
    SUBCLASS_OF_ID: 3397067317;
    classType: "request";
    className: "bots.GetBotInfo";
    static fromReader(reader: Reader): GetBotInfo;
      // flags: null;
      bot?: Api.TypeEntityLike;
      langCode: string;
    }
    export class ReorderUsernames extends Request<Partial<{
      bot: Api.TypeEntityLike;
      order: string[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2533994946;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.ReorderUsernames";
    static fromReader(reader: Reader): ReorderUsernames;
      bot: Api.TypeEntityLike;
      order: string[];
    }
    export class ToggleUsername extends Request<Partial<{
      bot: Api.TypeEntityLike;
      username: string;
      active: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 87861619;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.ToggleUsername";
    static fromReader(reader: Reader): ToggleUsername;
      bot: Api.TypeEntityLike;
      username: string;
      active: Bool;
    }
    export class CanSendMessage extends Request<Partial<{
      bot: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 324662502;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.CanSendMessage";
    static fromReader(reader: Reader): CanSendMessage;
      bot: Api.TypeEntityLike;
    }
    export class AllowSendMessage extends Request<Partial<{
      bot: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4046644207;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "bots.AllowSendMessage";
    static fromReader(reader: Reader): AllowSendMessage;
      bot: Api.TypeEntityLike;
    }
    export class InvokeWebViewCustomMethod extends Request<Partial<{
      bot: Api.TypeEntityLike;
      customMethod: string;
      params: Api.TypeDataJSON;
    }>, Api.TypeDataJSON> {
    CONSTRUCTOR_ID: 142591463;
    SUBCLASS_OF_ID: 2902676200;
    classType: "request";
    className: "bots.InvokeWebViewCustomMethod";
    static fromReader(reader: Reader): InvokeWebViewCustomMethod;
      bot: Api.TypeEntityLike;
      customMethod: string;
      params: Api.TypeDataJSON;
    }
    export class GetPopularAppBots extends Request<Partial<{
      offset: string;
      limit: int;
    }>, bots.TypePopularAppBots> {
    CONSTRUCTOR_ID: 3260088722;
    SUBCLASS_OF_ID: 2070199933;
    classType: "request";
    className: "bots.GetPopularAppBots";
    static fromReader(reader: Reader): GetPopularAppBots;
      offset: string;
      limit: int;
    }
    export class AddPreviewMedia extends Request<Partial<{
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia;
    }>, Api.TypeBotPreviewMedia> {
    CONSTRUCTOR_ID: 397326170;
    SUBCLASS_OF_ID: 1445641261;
    classType: "request";
    className: "bots.AddPreviewMedia";
    static fromReader(reader: Reader): AddPreviewMedia;
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia;
    }
    export class EditPreviewMedia extends Request<Partial<{
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia;
      newMedia: Api.TypeInputMedia;
    }>, Api.TypeBotPreviewMedia> {
    CONSTRUCTOR_ID: 2233819247;
    SUBCLASS_OF_ID: 1445641261;
    classType: "request";
    className: "bots.EditPreviewMedia";
    static fromReader(reader: Reader): EditPreviewMedia;
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia;
      newMedia: Api.TypeInputMedia;
    }
    export class DeletePreviewMedia extends Request<Partial<{
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia[];
    }>, Bool> {
    CONSTRUCTOR_ID: 755054003;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.DeletePreviewMedia";
    static fromReader(reader: Reader): DeletePreviewMedia;
      bot: Api.TypeEntityLike;
      langCode: string;
      media: Api.TypeInputMedia[];
    }
    export class ReorderPreviewMedias extends Request<Partial<{
      bot: Api.TypeEntityLike;
      langCode: string;
      order: Api.TypeInputMedia[];
    }>, Bool> {
    CONSTRUCTOR_ID: 3056071594;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.ReorderPreviewMedias";
    static fromReader(reader: Reader): ReorderPreviewMedias;
      bot: Api.TypeEntityLike;
      langCode: string;
      order: Api.TypeInputMedia[];
    }
    export class GetPreviewInfo extends Request<Partial<{
      bot: Api.TypeEntityLike;
      langCode: string;
    }>, bots.TypePreviewInfo> {
    CONSTRUCTOR_ID: 1111143341;
    SUBCLASS_OF_ID: 4039278389;
    classType: "request";
    className: "bots.GetPreviewInfo";
    static fromReader(reader: Reader): GetPreviewInfo;
      bot: Api.TypeEntityLike;
      langCode: string;
    }
    export class GetPreviewMedias extends Request<Partial<{
      bot: Api.TypeEntityLike;
    }>, Api.TypeBotPreviewMedia[]> {
    CONSTRUCTOR_ID: 2728745293;
    SUBCLASS_OF_ID: 4186319480;
    classType: "request";
    className: "bots.GetPreviewMedias";
    static fromReader(reader: Reader): GetPreviewMedias;
      bot: Api.TypeEntityLike;
    }
    export class UpdateUserEmojiStatus extends Request<Partial<{
      userId: Api.TypeEntityLike;
      emojiStatus: Api.TypeEmojiStatus;
    }>, Bool> {
    CONSTRUCTOR_ID: 3986632901;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.UpdateUserEmojiStatus";
    static fromReader(reader: Reader): UpdateUserEmojiStatus;
      userId: Api.TypeEntityLike;
      emojiStatus: Api.TypeEmojiStatus;
    }
    export class ToggleUserEmojiStatusPermission extends Request<Partial<{
      bot: Api.TypeEntityLike;
      enabled: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 115237778;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.ToggleUserEmojiStatusPermission";
    static fromReader(reader: Reader): ToggleUserEmojiStatusPermission;
      bot: Api.TypeEntityLike;
      enabled: Bool;
    }
    export class CheckDownloadFileParams extends Request<Partial<{
      bot: Api.TypeEntityLike;
      fileName: string;
      url: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1342666121;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.CheckDownloadFileParams";
    static fromReader(reader: Reader): CheckDownloadFileParams;
      bot: Api.TypeEntityLike;
      fileName: string;
      url: string;
    }
    export class GetAdminedBots extends Request<void, Api.TypeUser[]> {
    CONSTRUCTOR_ID: 2960203139;
    SUBCLASS_OF_ID: 67557965;
    classType: "request";
    className: "bots.GetAdminedBots";
    static fromReader(reader: Reader): GetAdminedBots;
}
    export class UpdateStarRefProgram extends Request<Partial<{
      // flags: null;
      bot: Api.TypeEntityLike;
      commissionPermille: int;
      durationMonths?: int;
    }>, Api.TypeStarRefProgram> {
    CONSTRUCTOR_ID: 2005621427;
    SUBCLASS_OF_ID: 2559107074;
    classType: "request";
    className: "bots.UpdateStarRefProgram";
    static fromReader(reader: Reader): UpdateStarRefProgram;
      // flags: null;
      bot: Api.TypeEntityLike;
      commissionPermille: int;
      durationMonths?: int;
    }
    export class SetCustomVerification extends Request<Partial<{
      // flags: null;
      enabled?: boolean;
      bot?: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      customDescription?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 2341068733;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "bots.SetCustomVerification";
    static fromReader(reader: Reader): SetCustomVerification;
      // flags: null;
      enabled?: boolean;
      bot?: Api.TypeEntityLike;
      peer: Api.TypeEntityLike;
      customDescription?: string;
    }
    export class GetBotRecommendations extends Request<Partial<{
      bot: Api.TypeEntityLike;
    }>, users.TypeUsers> {
    CONSTRUCTOR_ID: 2713126933;
    SUBCLASS_OF_ID: 4065063104;
    classType: "request";
    className: "bots.GetBotRecommendations";
    static fromReader(reader: Reader): GetBotRecommendations;
      bot: Api.TypeEntityLike;
    }
  }

  export namespace payments {
    export class GetPaymentForm extends Request<Partial<{
      // flags: null;
      invoice: Api.TypeInputInvoice;
      themeParams?: Api.TypeDataJSON;
    }>, payments.TypePaymentForm> {
    CONSTRUCTOR_ID: 924093883;
    SUBCLASS_OF_ID: 2689089305;
    classType: "request";
    className: "payments.GetPaymentForm";
    static fromReader(reader: Reader): GetPaymentForm;
      // flags: null;
      invoice: Api.TypeInputInvoice;
      themeParams?: Api.TypeDataJSON;
    }
    export class GetPaymentReceipt extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, payments.TypePaymentReceipt> {
    CONSTRUCTOR_ID: 611897804;
    SUBCLASS_OF_ID: 1493210057;
    classType: "request";
    className: "payments.GetPaymentReceipt";
    static fromReader(reader: Reader): GetPaymentReceipt;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class ValidateRequestedInfo extends Request<Partial<{
      // flags: null;
      save?: boolean;
      invoice: Api.TypeInputInvoice;
      info: Api.TypePaymentRequestedInfo;
    }>, payments.TypeValidatedRequestedInfo> {
    CONSTRUCTOR_ID: 3066622251;
    SUBCLASS_OF_ID: 2407548087;
    classType: "request";
    className: "payments.ValidateRequestedInfo";
    static fromReader(reader: Reader): ValidateRequestedInfo;
      // flags: null;
      save?: boolean;
      invoice: Api.TypeInputInvoice;
      info: Api.TypePaymentRequestedInfo;
    }
    export class SendPaymentForm extends Request<Partial<{
      // flags: null;
      formId: long;
      invoice: Api.TypeInputInvoice;
      requestedInfoId?: string;
      shippingOptionId?: string;
      credentials: Api.TypeInputPaymentCredentials;
      tipAmount?: long;
    }>, payments.TypePaymentResult> {
    CONSTRUCTOR_ID: 755192367;
    SUBCLASS_OF_ID: 2330028701;
    classType: "request";
    className: "payments.SendPaymentForm";
    static fromReader(reader: Reader): SendPaymentForm;
      // flags: null;
      formId: long;
      invoice: Api.TypeInputInvoice;
      requestedInfoId?: string;
      shippingOptionId?: string;
      credentials: Api.TypeInputPaymentCredentials;
      tipAmount?: long;
    }
    export class GetSavedInfo extends Request<void, payments.TypeSavedInfo> {
    CONSTRUCTOR_ID: 578650699;
    SUBCLASS_OF_ID: 2906452294;
    classType: "request";
    className: "payments.GetSavedInfo";
    static fromReader(reader: Reader): GetSavedInfo;
}
    export class ClearSavedInfo extends Request<Partial<{
      // flags: null;
      credentials?: boolean;
      info?: boolean;
    }>, Bool> {
    CONSTRUCTOR_ID: 3627905217;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.ClearSavedInfo";
    static fromReader(reader: Reader): ClearSavedInfo;
      // flags: null;
      credentials?: boolean;
      info?: boolean;
    }
    export class GetBankCardData extends Request<Partial<{
      number: string;
    }>, payments.TypeBankCardData> {
    CONSTRUCTOR_ID: 779736953;
    SUBCLASS_OF_ID: 2356008587;
    classType: "request";
    className: "payments.GetBankCardData";
    static fromReader(reader: Reader): GetBankCardData;
      number: string;
    }
    export class ExportInvoice extends Request<Partial<{
      invoiceMedia: Api.TypeInputMedia;
    }>, payments.TypeExportedInvoice> {
    CONSTRUCTOR_ID: 261206117;
    SUBCLASS_OF_ID: 907039794;
    classType: "request";
    className: "payments.ExportInvoice";
    static fromReader(reader: Reader): ExportInvoice;
      invoiceMedia: Api.TypeInputMedia;
    }
    export class AssignAppStoreTransaction extends Request<Partial<{
      receipt: bytes;
      purpose: Api.TypeInputStorePaymentPurpose;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2163045501;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.AssignAppStoreTransaction";
    static fromReader(reader: Reader): AssignAppStoreTransaction;
      receipt: bytes;
      purpose: Api.TypeInputStorePaymentPurpose;
    }
    export class AssignPlayMarketTransaction extends Request<Partial<{
      receipt: Api.TypeDataJSON;
      purpose: Api.TypeInputStorePaymentPurpose;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3757920467;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.AssignPlayMarketTransaction";
    static fromReader(reader: Reader): AssignPlayMarketTransaction;
      receipt: Api.TypeDataJSON;
      purpose: Api.TypeInputStorePaymentPurpose;
    }
    export class CanPurchasePremium extends Request<Partial<{
      purpose: Api.TypeInputStorePaymentPurpose;
    }>, Bool> {
    CONSTRUCTOR_ID: 2680266422;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.CanPurchasePremium";
    static fromReader(reader: Reader): CanPurchasePremium;
      purpose: Api.TypeInputStorePaymentPurpose;
    }
    export class GetPremiumGiftCodeOptions extends Request<Partial<{
      // flags: null;
      boostPeer?: Api.TypeEntityLike;
    }>, Api.TypePremiumGiftCodeOption[]> {
    CONSTRUCTOR_ID: 660060756;
    SUBCLASS_OF_ID: 178857347;
    classType: "request";
    className: "payments.GetPremiumGiftCodeOptions";
    static fromReader(reader: Reader): GetPremiumGiftCodeOptions;
      // flags: null;
      boostPeer?: Api.TypeEntityLike;
    }
    export class CheckGiftCode extends Request<Partial<{
      slug: string;
    }>, payments.TypeCheckedGiftCode> {
    CONSTRUCTOR_ID: 2387719361;
    SUBCLASS_OF_ID: 1529452520;
    classType: "request";
    className: "payments.CheckGiftCode";
    static fromReader(reader: Reader): CheckGiftCode;
      slug: string;
    }
    export class ApplyGiftCode extends Request<Partial<{
      slug: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4142032980;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.ApplyGiftCode";
    static fromReader(reader: Reader): ApplyGiftCode;
      slug: string;
    }
    export class GetGiveawayInfo extends Request<Partial<{
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, payments.TypeGiveawayInfo> {
    CONSTRUCTOR_ID: 4095972389;
    SUBCLASS_OF_ID: 2527295421;
    classType: "request";
    className: "payments.GetGiveawayInfo";
    static fromReader(reader: Reader): GetGiveawayInfo;
      peer: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class LaunchPrepaidGiveaway extends Request<Partial<{
      peer: Api.TypeEntityLike;
      giveawayId: long;
      purpose: Api.TypeInputStorePaymentPurpose;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1609928480;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.LaunchPrepaidGiveaway";
    static fromReader(reader: Reader): LaunchPrepaidGiveaway;
      peer: Api.TypeEntityLike;
      giveawayId: long;
      purpose: Api.TypeInputStorePaymentPurpose;
    }
    export class GetStarsTopupOptions extends Request<void, Api.TypeStarsTopupOption[]> {
    CONSTRUCTOR_ID: 3222194131;
    SUBCLASS_OF_ID: 3573451417;
    classType: "request";
    className: "payments.GetStarsTopupOptions";
    static fromReader(reader: Reader): GetStarsTopupOptions;
}
    export class GetStarsStatus extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, payments.TypeStarsStatus> {
    CONSTRUCTOR_ID: 273665959;
    SUBCLASS_OF_ID: 1855724911;
    classType: "request";
    className: "payments.GetStarsStatus";
    static fromReader(reader: Reader): GetStarsStatus;
      peer: Api.TypeEntityLike;
    }
    export class GetStarsTransactions extends Request<Partial<{
      // flags: null;
      inbound?: boolean;
      outbound?: boolean;
      ascending?: boolean;
      subscriptionId?: string;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }>, payments.TypeStarsStatus> {
    CONSTRUCTOR_ID: 1775912279;
    SUBCLASS_OF_ID: 1855724911;
    classType: "request";
    className: "payments.GetStarsTransactions";
    static fromReader(reader: Reader): GetStarsTransactions;
      // flags: null;
      inbound?: boolean;
      outbound?: boolean;
      ascending?: boolean;
      subscriptionId?: string;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }
    export class SendStarsForm extends Request<Partial<{
      formId: long;
      invoice: Api.TypeInputInvoice;
    }>, payments.TypePaymentResult> {
    CONSTRUCTOR_ID: 2040056084;
    SUBCLASS_OF_ID: 2330028701;
    classType: "request";
    className: "payments.SendStarsForm";
    static fromReader(reader: Reader): SendStarsForm;
      formId: long;
      invoice: Api.TypeInputInvoice;
    }
    export class RefundStarsCharge extends Request<Partial<{
      userId: Api.TypeEntityLike;
      chargeId: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 632196938;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.RefundStarsCharge";
    static fromReader(reader: Reader): RefundStarsCharge;
      userId: Api.TypeEntityLike;
      chargeId: string;
    }
    export class GetStarsRevenueStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
    }>, payments.TypeStarsRevenueStats> {
    CONSTRUCTOR_ID: 3642751702;
    SUBCLASS_OF_ID: 2772915699;
    classType: "request";
    className: "payments.GetStarsRevenueStats";
    static fromReader(reader: Reader): GetStarsRevenueStats;
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
    }
    export class GetStarsRevenueWithdrawalUrl extends Request<Partial<{
      peer: Api.TypeEntityLike;
      stars: long;
      password: Api.TypeInputCheckPasswordSRP;
    }>, payments.TypeStarsRevenueWithdrawalUrl> {
    CONSTRUCTOR_ID: 331081907;
    SUBCLASS_OF_ID: 2221318382;
    classType: "request";
    className: "payments.GetStarsRevenueWithdrawalUrl";
    static fromReader(reader: Reader): GetStarsRevenueWithdrawalUrl;
      peer: Api.TypeEntityLike;
      stars: long;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class GetStarsRevenueAdsAccountUrl extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, payments.TypeStarsRevenueAdsAccountUrl> {
    CONSTRUCTOR_ID: 3520589765;
    SUBCLASS_OF_ID: 1243777813;
    classType: "request";
    className: "payments.GetStarsRevenueAdsAccountUrl";
    static fromReader(reader: Reader): GetStarsRevenueAdsAccountUrl;
      peer: Api.TypeEntityLike;
    }
    export class GetStarsTransactionsByID extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: Api.TypeInputStarsTransaction[];
    }>, payments.TypeStarsStatus> {
    CONSTRUCTOR_ID: 662973742;
    SUBCLASS_OF_ID: 1855724911;
    classType: "request";
    className: "payments.GetStarsTransactionsByID";
    static fromReader(reader: Reader): GetStarsTransactionsByID;
      peer: Api.TypeEntityLike;
      id: Api.TypeInputStarsTransaction[];
    }
    export class GetStarsGiftOptions extends Request<Partial<{
      // flags: null;
      userId?: Api.TypeEntityLike;
    }>, Api.TypeStarsGiftOption[]> {
    CONSTRUCTOR_ID: 3553192904;
    SUBCLASS_OF_ID: 3919820757;
    classType: "request";
    className: "payments.GetStarsGiftOptions";
    static fromReader(reader: Reader): GetStarsGiftOptions;
      // flags: null;
      userId?: Api.TypeEntityLike;
    }
    export class GetStarsSubscriptions extends Request<Partial<{
      // flags: null;
      missingBalance?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
    }>, payments.TypeStarsStatus> {
    CONSTRUCTOR_ID: 52761285;
    SUBCLASS_OF_ID: 1855724911;
    classType: "request";
    className: "payments.GetStarsSubscriptions";
    static fromReader(reader: Reader): GetStarsSubscriptions;
      // flags: null;
      missingBalance?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
    }
    export class ChangeStarsSubscription extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      subscriptionId: string;
      canceled?: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 3346466936;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.ChangeStarsSubscription";
    static fromReader(reader: Reader): ChangeStarsSubscription;
      // flags: null;
      peer: Api.TypeEntityLike;
      subscriptionId: string;
      canceled?: Bool;
    }
    export class FulfillStarsSubscription extends Request<Partial<{
      peer: Api.TypeEntityLike;
      subscriptionId: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 3428576179;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.FulfillStarsSubscription";
    static fromReader(reader: Reader): FulfillStarsSubscription;
      peer: Api.TypeEntityLike;
      subscriptionId: string;
    }
    export class GetStarsGiveawayOptions extends Request<void, Api.TypeStarsGiveawayOption[]> {
    CONSTRUCTOR_ID: 3172924734;
    SUBCLASS_OF_ID: 4175114409;
    classType: "request";
    className: "payments.GetStarsGiveawayOptions";
    static fromReader(reader: Reader): GetStarsGiveawayOptions;
}
    export class GetStarGifts extends Request<Partial<{
      hash: int;
    }>, payments.TypeStarGifts> {
    CONSTRUCTOR_ID: 3293984144;
    SUBCLASS_OF_ID: 1635309988;
    classType: "request";
    className: "payments.GetStarGifts";
    static fromReader(reader: Reader): GetStarGifts;
      hash: int;
    }
    export class SaveStarGift extends Request<Partial<{
      // flags: null;
      unsave?: boolean;
      stargift: Api.TypeInputSavedStarGift;
    }>, Bool> {
    CONSTRUCTOR_ID: 707422588;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.SaveStarGift";
    static fromReader(reader: Reader): SaveStarGift;
      // flags: null;
      unsave?: boolean;
      stargift: Api.TypeInputSavedStarGift;
    }
    export class ConvertStarGift extends Request<Partial<{
      stargift: Api.TypeInputSavedStarGift;
    }>, Bool> {
    CONSTRUCTOR_ID: 1958676331;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.ConvertStarGift";
    static fromReader(reader: Reader): ConvertStarGift;
      stargift: Api.TypeInputSavedStarGift;
    }
    export class BotCancelStarsSubscription extends Request<Partial<{
      // flags: null;
      restore?: boolean;
      userId: Api.TypeEntityLike;
      chargeId: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1845102114;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.BotCancelStarsSubscription";
    static fromReader(reader: Reader): BotCancelStarsSubscription;
      // flags: null;
      restore?: boolean;
      userId: Api.TypeEntityLike;
      chargeId: string;
    }
    export class GetConnectedStarRefBots extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      offsetDate?: int;
      offsetLink?: string;
      limit: int;
    }>, payments.TypeConnectedStarRefBots> {
    CONSTRUCTOR_ID: 1483318611;
    SUBCLASS_OF_ID: 593369703;
    classType: "request";
    className: "payments.GetConnectedStarRefBots";
    static fromReader(reader: Reader): GetConnectedStarRefBots;
      // flags: null;
      peer: Api.TypeEntityLike;
      offsetDate?: int;
      offsetLink?: string;
      limit: int;
    }
    export class GetConnectedStarRefBot extends Request<Partial<{
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
    }>, payments.TypeConnectedStarRefBots> {
    CONSTRUCTOR_ID: 3084490992;
    SUBCLASS_OF_ID: 593369703;
    classType: "request";
    className: "payments.GetConnectedStarRefBot";
    static fromReader(reader: Reader): GetConnectedStarRefBot;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
    }
    export class GetSuggestedStarRefBots extends Request<Partial<{
      // flags: null;
      orderByRevenue?: boolean;
      orderByDate?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }>, payments.TypeSuggestedStarRefBots> {
    CONSTRUCTOR_ID: 225134839;
    SUBCLASS_OF_ID: 1880658499;
    classType: "request";
    className: "payments.GetSuggestedStarRefBots";
    static fromReader(reader: Reader): GetSuggestedStarRefBots;
      // flags: null;
      orderByRevenue?: boolean;
      orderByDate?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }
    export class ConnectStarRefBot extends Request<Partial<{
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
    }>, payments.TypeConnectedStarRefBots> {
    CONSTRUCTOR_ID: 2127901834;
    SUBCLASS_OF_ID: 593369703;
    classType: "request";
    className: "payments.ConnectStarRefBot";
    static fromReader(reader: Reader): ConnectStarRefBot;
      peer: Api.TypeEntityLike;
      bot: Api.TypeEntityLike;
    }
    export class EditConnectedStarRefBot extends Request<Partial<{
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      link: string;
    }>, payments.TypeConnectedStarRefBots> {
    CONSTRUCTOR_ID: 3841762467;
    SUBCLASS_OF_ID: 593369703;
    classType: "request";
    className: "payments.EditConnectedStarRefBot";
    static fromReader(reader: Reader): EditConnectedStarRefBot;
      // flags: null;
      revoked?: boolean;
      peer: Api.TypeEntityLike;
      link: string;
    }
    export class GetStarGiftUpgradePreview extends Request<Partial<{
      giftId: long;
    }>, payments.TypeStarGiftUpgradePreview> {
    CONSTRUCTOR_ID: 2627386545;
    SUBCLASS_OF_ID: 1579903175;
    classType: "request";
    className: "payments.GetStarGiftUpgradePreview";
    static fromReader(reader: Reader): GetStarGiftUpgradePreview;
      giftId: long;
    }
    export class UpgradeStarGift extends Request<Partial<{
      // flags: null;
      keepOriginalDetails?: boolean;
      stargift: Api.TypeInputSavedStarGift;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2933318901;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.UpgradeStarGift";
    static fromReader(reader: Reader): UpgradeStarGift;
      // flags: null;
      keepOriginalDetails?: boolean;
      stargift: Api.TypeInputSavedStarGift;
    }
    export class TransferStarGift extends Request<Partial<{
      stargift: Api.TypeInputSavedStarGift;
      toId: Api.TypeEntityLike;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2132285290;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "payments.TransferStarGift";
    static fromReader(reader: Reader): TransferStarGift;
      stargift: Api.TypeInputSavedStarGift;
      toId: Api.TypeEntityLike;
    }
    export class GetUniqueStarGift extends Request<Partial<{
      slug: string;
    }>, payments.TypeUniqueStarGift> {
    CONSTRUCTOR_ID: 2711047538;
    SUBCLASS_OF_ID: 2024850939;
    classType: "request";
    className: "payments.GetUniqueStarGift";
    static fromReader(reader: Reader): GetUniqueStarGift;
      slug: string;
    }
    export class GetSavedStarGifts extends Request<Partial<{
      // flags: null;
      excludeUnsaved?: boolean;
      excludeSaved?: boolean;
      excludeUnlimited?: boolean;
      excludeLimited?: boolean;
      excludeUnique?: boolean;
      sortByValue?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }>, payments.TypeSavedStarGifts> {
    CONSTRUCTOR_ID: 595791337;
    SUBCLASS_OF_ID: 3574671511;
    classType: "request";
    className: "payments.GetSavedStarGifts";
    static fromReader(reader: Reader): GetSavedStarGifts;
      // flags: null;
      excludeUnsaved?: boolean;
      excludeSaved?: boolean;
      excludeUnlimited?: boolean;
      excludeLimited?: boolean;
      excludeUnique?: boolean;
      sortByValue?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }
    export class GetSavedStarGift extends Request<Partial<{
      stargift: Api.TypeInputSavedStarGift[];
    }>, payments.TypeSavedStarGifts> {
    CONSTRUCTOR_ID: 3025510662;
    SUBCLASS_OF_ID: 3574671511;
    classType: "request";
    className: "payments.GetSavedStarGift";
    static fromReader(reader: Reader): GetSavedStarGift;
      stargift: Api.TypeInputSavedStarGift[];
    }
    export class GetStarGiftWithdrawalUrl extends Request<Partial<{
      stargift: Api.TypeInputSavedStarGift;
      password: Api.TypeInputCheckPasswordSRP;
    }>, payments.TypeStarGiftWithdrawalUrl> {
    CONSTRUCTOR_ID: 3496907688;
    SUBCLASS_OF_ID: 2726440389;
    classType: "request";
    className: "payments.GetStarGiftWithdrawalUrl";
    static fromReader(reader: Reader): GetStarGiftWithdrawalUrl;
      stargift: Api.TypeInputSavedStarGift;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class ToggleChatStarGiftNotifications extends Request<Partial<{
      // flags: null;
      enabled?: boolean;
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1626009505;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "payments.ToggleChatStarGiftNotifications";
    static fromReader(reader: Reader): ToggleChatStarGiftNotifications;
      // flags: null;
      enabled?: boolean;
      peer: Api.TypeEntityLike;
    }
  }

  export namespace stickers {
    export class CreateStickerSet extends Request<Partial<{
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      textColor?: boolean;
      userId: Api.TypeEntityLike;
      title: string;
      shortName: string;
      thumb?: Api.TypeInputDocument;
      stickers: Api.TypeInputStickerSetItem[];
      software?: string;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 2418125671;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.CreateStickerSet";
    static fromReader(reader: Reader): CreateStickerSet;
      // flags: null;
      masks?: boolean;
      emojis?: boolean;
      textColor?: boolean;
      userId: Api.TypeEntityLike;
      title: string;
      shortName: string;
      thumb?: Api.TypeInputDocument;
      stickers: Api.TypeInputStickerSetItem[];
      software?: string;
    }
    export class RemoveStickerFromSet extends Request<Partial<{
      sticker: Api.TypeInputDocument;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 4151709521;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.RemoveStickerFromSet";
    static fromReader(reader: Reader): RemoveStickerFromSet;
      sticker: Api.TypeInputDocument;
    }
    export class ChangeStickerPosition extends Request<Partial<{
      sticker: Api.TypeInputDocument;
      position: int;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 4290172106;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.ChangeStickerPosition";
    static fromReader(reader: Reader): ChangeStickerPosition;
      sticker: Api.TypeInputDocument;
      position: int;
    }
    export class AddStickerToSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
      sticker: Api.TypeInputStickerSetItem;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 2253651646;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.AddStickerToSet";
    static fromReader(reader: Reader): AddStickerToSet;
      stickerset: Api.TypeInputStickerSet;
      sticker: Api.TypeInputStickerSetItem;
    }
    export class SetStickerSetThumb extends Request<Partial<{
      // flags: null;
      stickerset: Api.TypeInputStickerSet;
      thumb?: Api.TypeInputDocument;
      thumbDocumentId?: long;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 2808763282;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.SetStickerSetThumb";
    static fromReader(reader: Reader): SetStickerSetThumb;
      // flags: null;
      stickerset: Api.TypeInputStickerSet;
      thumb?: Api.TypeInputDocument;
      thumbDocumentId?: long;
    }
    export class CheckShortName extends Request<Partial<{
      shortName: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 676017721;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stickers.CheckShortName";
    static fromReader(reader: Reader): CheckShortName;
      shortName: string;
    }
    export class SuggestShortName extends Request<Partial<{
      title: string;
    }>, stickers.TypeSuggestedShortName> {
    CONSTRUCTOR_ID: 1303364867;
    SUBCLASS_OF_ID: 3293203233;
    classType: "request";
    className: "stickers.SuggestShortName";
    static fromReader(reader: Reader): SuggestShortName;
      title: string;
    }
    export class ChangeSticker extends Request<Partial<{
      // flags: null;
      sticker: Api.TypeInputDocument;
      emoji?: string;
      maskCoords?: Api.TypeMaskCoords;
      keywords?: string;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 4115889852;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.ChangeSticker";
    static fromReader(reader: Reader): ChangeSticker;
      // flags: null;
      sticker: Api.TypeInputDocument;
      emoji?: string;
      maskCoords?: Api.TypeMaskCoords;
      keywords?: string;
    }
    export class RenameStickerSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
      title: string;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 306912256;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.RenameStickerSet";
    static fromReader(reader: Reader): RenameStickerSet;
      stickerset: Api.TypeInputStickerSet;
      title: string;
    }
    export class DeleteStickerSet extends Request<Partial<{
      stickerset: Api.TypeInputStickerSet;
    }>, Bool> {
    CONSTRUCTOR_ID: 2272281492;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stickers.DeleteStickerSet";
    static fromReader(reader: Reader): DeleteStickerSet;
      stickerset: Api.TypeInputStickerSet;
    }
    export class ReplaceSticker extends Request<Partial<{
      sticker: Api.TypeInputDocument;
      newSticker: Api.TypeInputStickerSetItem;
    }>, messages.TypeStickerSet> {
    CONSTRUCTOR_ID: 1184253338;
    SUBCLASS_OF_ID: 2607827546;
    classType: "request";
    className: "stickers.ReplaceSticker";
    static fromReader(reader: Reader): ReplaceSticker;
      sticker: Api.TypeInputDocument;
      newSticker: Api.TypeInputStickerSetItem;
    }
  }

  export namespace phone {
    export class GetCallConfig extends Request<void, Api.TypeDataJSON> {
    CONSTRUCTOR_ID: 1430593449;
    SUBCLASS_OF_ID: 2902676200;
    classType: "request";
    className: "phone.GetCallConfig";
    static fromReader(reader: Reader): GetCallConfig;
}
    export class RequestCall extends Request<Partial<{
      // flags: null;
      video?: boolean;
      userId: Api.TypeEntityLike;
      conferenceCall?: Api.TypeInputGroupCall;
      randomId: int;
      gAHash: bytes;
      protocol: Api.TypePhoneCallProtocol;
    }>, phone.TypePhoneCall> {
    CONSTRUCTOR_ID: 2797887500;
    SUBCLASS_OF_ID: 3565878863;
    classType: "request";
    className: "phone.RequestCall";
    static fromReader(reader: Reader): RequestCall;
      // flags: null;
      video?: boolean;
      userId: Api.TypeEntityLike;
      conferenceCall?: Api.TypeInputGroupCall;
      randomId: int;
      gAHash: bytes;
      protocol: Api.TypePhoneCallProtocol;
    }
    export class AcceptCall extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      gB: bytes;
      protocol: Api.TypePhoneCallProtocol;
    }>, phone.TypePhoneCall> {
    CONSTRUCTOR_ID: 1003664544;
    SUBCLASS_OF_ID: 3565878863;
    classType: "request";
    className: "phone.AcceptCall";
    static fromReader(reader: Reader): AcceptCall;
      peer: Api.TypeInputPhoneCall;
      gB: bytes;
      protocol: Api.TypePhoneCallProtocol;
    }
    export class ConfirmCall extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      gA: bytes;
      keyFingerprint: long;
      protocol: Api.TypePhoneCallProtocol;
    }>, phone.TypePhoneCall> {
    CONSTRUCTOR_ID: 788404002;
    SUBCLASS_OF_ID: 3565878863;
    classType: "request";
    className: "phone.ConfirmCall";
    static fromReader(reader: Reader): ConfirmCall;
      peer: Api.TypeInputPhoneCall;
      gA: bytes;
      keyFingerprint: long;
      protocol: Api.TypePhoneCallProtocol;
    }
    export class ReceivedCall extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
    }>, Bool> {
    CONSTRUCTOR_ID: 399855457;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "phone.ReceivedCall";
    static fromReader(reader: Reader): ReceivedCall;
      peer: Api.TypeInputPhoneCall;
    }
    export class DiscardCall extends Request<Partial<{
      // flags: null;
      video?: boolean;
      peer: Api.TypeInputPhoneCall;
      duration: int;
      reason: Api.TypePhoneCallDiscardReason;
      connectionId: long;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2999697856;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.DiscardCall";
    static fromReader(reader: Reader): DiscardCall;
      // flags: null;
      video?: boolean;
      peer: Api.TypeInputPhoneCall;
      duration: int;
      reason: Api.TypePhoneCallDiscardReason;
      connectionId: long;
    }
    export class SetCallRating extends Request<Partial<{
      // flags: null;
      userInitiative?: boolean;
      peer: Api.TypeInputPhoneCall;
      rating: int;
      comment: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1508562471;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.SetCallRating";
    static fromReader(reader: Reader): SetCallRating;
      // flags: null;
      userInitiative?: boolean;
      peer: Api.TypeInputPhoneCall;
      rating: int;
      comment: string;
    }
    export class SaveCallDebug extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      debug: Api.TypeDataJSON;
    }>, Bool> {
    CONSTRUCTOR_ID: 662363518;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "phone.SaveCallDebug";
    static fromReader(reader: Reader): SaveCallDebug;
      peer: Api.TypeInputPhoneCall;
      debug: Api.TypeDataJSON;
    }
    export class SendSignalingData extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      data: bytes;
    }>, Bool> {
    CONSTRUCTOR_ID: 4286223235;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "phone.SendSignalingData";
    static fromReader(reader: Reader): SendSignalingData;
      peer: Api.TypeInputPhoneCall;
      data: bytes;
    }
    export class CreateGroupCall extends Request<Partial<{
      // flags: null;
      rtmpStream?: boolean;
      peer: Api.TypeEntityLike;
      randomId: int;
      title?: string;
      scheduleDate?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1221445336;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.CreateGroupCall";
    static fromReader(reader: Reader): CreateGroupCall;
      // flags: null;
      rtmpStream?: boolean;
      peer: Api.TypeEntityLike;
      randomId: int;
      title?: string;
      scheduleDate?: int;
    }
    export class JoinGroupCall extends Request<Partial<{
      // flags: null;
      muted?: boolean;
      videoStopped?: boolean;
      call: Api.TypeInputGroupCall;
      joinAs: Api.TypeEntityLike;
      inviteHash?: string;
      keyFingerprint?: long;
      params: Api.TypeDataJSON;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3592297971;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.JoinGroupCall";
    static fromReader(reader: Reader): JoinGroupCall;
      // flags: null;
      muted?: boolean;
      videoStopped?: boolean;
      call: Api.TypeInputGroupCall;
      joinAs: Api.TypeEntityLike;
      inviteHash?: string;
      keyFingerprint?: long;
      params: Api.TypeDataJSON;
    }
    export class LeaveGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      source: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1342404601;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.LeaveGroupCall";
    static fromReader(reader: Reader): LeaveGroupCall;
      call: Api.TypeInputGroupCall;
      source: int;
    }
    export class InviteToGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      users: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2067345760;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.InviteToGroupCall";
    static fromReader(reader: Reader): InviteToGroupCall;
      call: Api.TypeInputGroupCall;
      users: Api.TypeEntityLike[];
    }
    export class DiscardGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2054648117;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.DiscardGroupCall";
    static fromReader(reader: Reader): DiscardGroupCall;
      call: Api.TypeInputGroupCall;
    }
    export class ToggleGroupCallSettings extends Request<Partial<{
      // flags: null;
      resetInviteHash?: boolean;
      call: Api.TypeInputGroupCall;
      joinMuted?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1958458429;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.ToggleGroupCallSettings";
    static fromReader(reader: Reader): ToggleGroupCallSettings;
      // flags: null;
      resetInviteHash?: boolean;
      call: Api.TypeInputGroupCall;
      joinMuted?: Bool;
    }
    export class GetGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      limit: int;
    }>, phone.TypeGroupCall> {
    CONSTRUCTOR_ID: 68699611;
    SUBCLASS_OF_ID: 809572030;
    classType: "request";
    className: "phone.GetGroupCall";
    static fromReader(reader: Reader): GetGroupCall;
      call: Api.TypeInputGroupCall;
      limit: int;
    }
    export class GetGroupParticipants extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      ids: Api.TypeEntityLike[];
      sources: int[];
      offset: string;
      limit: int;
    }>, phone.TypeGroupParticipants> {
    CONSTRUCTOR_ID: 3310934187;
    SUBCLASS_OF_ID: 1926431988;
    classType: "request";
    className: "phone.GetGroupParticipants";
    static fromReader(reader: Reader): GetGroupParticipants;
      call: Api.TypeInputGroupCall;
      ids: Api.TypeEntityLike[];
      sources: int[];
      offset: string;
      limit: int;
    }
    export class CheckGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      sources: int[];
    }>, int[]> {
    CONSTRUCTOR_ID: 3046963575;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "phone.CheckGroupCall";
    static fromReader(reader: Reader): CheckGroupCall;
      call: Api.TypeInputGroupCall;
      sources: int[];
    }
    export class ToggleGroupCallRecord extends Request<Partial<{
      // flags: null;
      start?: boolean;
      video?: boolean;
      call: Api.TypeInputGroupCall;
      title?: string;
      videoPortrait?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 4045981448;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.ToggleGroupCallRecord";
    static fromReader(reader: Reader): ToggleGroupCallRecord;
      // flags: null;
      start?: boolean;
      video?: boolean;
      call: Api.TypeInputGroupCall;
      title?: string;
      videoPortrait?: Bool;
    }
    export class EditGroupCallParticipant extends Request<Partial<{
      // flags: null;
      call: Api.TypeInputGroupCall;
      participant: Api.TypeEntityLike;
      muted?: Bool;
      volume?: int;
      raiseHand?: Bool;
      videoStopped?: Bool;
      videoPaused?: Bool;
      presentationPaused?: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2770811583;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.EditGroupCallParticipant";
    static fromReader(reader: Reader): EditGroupCallParticipant;
      // flags: null;
      call: Api.TypeInputGroupCall;
      participant: Api.TypeEntityLike;
      muted?: Bool;
      volume?: int;
      raiseHand?: Bool;
      videoStopped?: Bool;
      videoPaused?: Bool;
      presentationPaused?: Bool;
    }
    export class EditGroupCallTitle extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      title: string;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 480685066;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.EditGroupCallTitle";
    static fromReader(reader: Reader): EditGroupCallTitle;
      call: Api.TypeInputGroupCall;
      title: string;
    }
    export class GetGroupCallJoinAs extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, phone.TypeJoinAsPeers> {
    CONSTRUCTOR_ID: 4017889594;
    SUBCLASS_OF_ID: 3031920891;
    classType: "request";
    className: "phone.GetGroupCallJoinAs";
    static fromReader(reader: Reader): GetGroupCallJoinAs;
      peer: Api.TypeEntityLike;
    }
    export class ExportGroupCallInvite extends Request<Partial<{
      // flags: null;
      canSelfUnmute?: boolean;
      call: Api.TypeInputGroupCall;
    }>, phone.TypeExportedGroupCallInvite> {
    CONSTRUCTOR_ID: 3869926527;
    SUBCLASS_OF_ID: 993787535;
    classType: "request";
    className: "phone.ExportGroupCallInvite";
    static fromReader(reader: Reader): ExportGroupCallInvite;
      // flags: null;
      canSelfUnmute?: boolean;
      call: Api.TypeInputGroupCall;
    }
    export class ToggleGroupCallStartSubscription extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      subscribed: Bool;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 563885286;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.ToggleGroupCallStartSubscription";
    static fromReader(reader: Reader): ToggleGroupCallStartSubscription;
      call: Api.TypeInputGroupCall;
      subscribed: Bool;
    }
    export class StartScheduledGroupCall extends Request<Partial<{
      call: Api.TypeInputGroupCall;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1451287362;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.StartScheduledGroupCall";
    static fromReader(reader: Reader): StartScheduledGroupCall;
      call: Api.TypeInputGroupCall;
    }
    export class SaveDefaultGroupCallJoinAs extends Request<Partial<{
      peer: Api.TypeEntityLike;
      joinAs: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 1465786252;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "phone.SaveDefaultGroupCallJoinAs";
    static fromReader(reader: Reader): SaveDefaultGroupCallJoinAs;
      peer: Api.TypeEntityLike;
      joinAs: Api.TypeEntityLike;
    }
    export class JoinGroupCallPresentation extends Request<Partial<{
      call: Api.TypeInputGroupCall;
      params: Api.TypeDataJSON;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3421137860;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.JoinGroupCallPresentation";
    static fromReader(reader: Reader): JoinGroupCallPresentation;
      call: Api.TypeInputGroupCall;
      params: Api.TypeDataJSON;
    }
    export class LeaveGroupCallPresentation extends Request<Partial<{
      call: Api.TypeInputGroupCall;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 475058500;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "phone.LeaveGroupCallPresentation";
    static fromReader(reader: Reader): LeaveGroupCallPresentation;
      call: Api.TypeInputGroupCall;
    }
    export class GetGroupCallStreamChannels extends Request<Partial<{
      call: Api.TypeInputGroupCall;
    }>, phone.TypeGroupCallStreamChannels> {
    CONSTRUCTOR_ID: 447879488;
    SUBCLASS_OF_ID: 2438448612;
    classType: "request";
    className: "phone.GetGroupCallStreamChannels";
    static fromReader(reader: Reader): GetGroupCallStreamChannels;
      call: Api.TypeInputGroupCall;
    }
    export class GetGroupCallStreamRtmpUrl extends Request<Partial<{
      peer: Api.TypeEntityLike;
      revoke: Bool;
    }>, phone.TypeGroupCallStreamRtmpUrl> {
    CONSTRUCTOR_ID: 3736316863;
    SUBCLASS_OF_ID: 3522500043;
    classType: "request";
    className: "phone.GetGroupCallStreamRtmpUrl";
    static fromReader(reader: Reader): GetGroupCallStreamRtmpUrl;
      peer: Api.TypeEntityLike;
      revoke: Bool;
    }
    export class SaveCallLog extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      file: Api.TypeInputFile;
    }>, Bool> {
    CONSTRUCTOR_ID: 1092913030;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "phone.SaveCallLog";
    static fromReader(reader: Reader): SaveCallLog;
      peer: Api.TypeInputPhoneCall;
      file: Api.TypeInputFile;
    }
    export class CreateConferenceCall extends Request<Partial<{
      peer: Api.TypeInputPhoneCall;
      keyFingerprint: long;
    }>, phone.TypePhoneCall> {
    CONSTRUCTOR_ID: 3754494379;
    SUBCLASS_OF_ID: 3565878863;
    classType: "request";
    className: "phone.CreateConferenceCall";
    static fromReader(reader: Reader): CreateConferenceCall;
      peer: Api.TypeInputPhoneCall;
      keyFingerprint: long;
    }
  }

  export namespace langpack {
    export class GetLangPack extends Request<Partial<{
      langPack: string;
      langCode: string;
    }>, Api.TypeLangPackDifference> {
    CONSTRUCTOR_ID: 4075959050;
    SUBCLASS_OF_ID: 1382427989;
    classType: "request";
    className: "langpack.GetLangPack";
    static fromReader(reader: Reader): GetLangPack;
      langPack: string;
      langCode: string;
    }
    export class GetStrings extends Request<Partial<{
      langPack: string;
      langCode: string;
      keys: string[];
    }>, Api.TypeLangPackString[]> {
    CONSTRUCTOR_ID: 4025104387;
    SUBCLASS_OF_ID: 3350672701;
    classType: "request";
    className: "langpack.GetStrings";
    static fromReader(reader: Reader): GetStrings;
      langPack: string;
      langCode: string;
      keys: string[];
    }
    export class GetDifference extends Request<Partial<{
      langPack: string;
      langCode: string;
      fromVersion: int;
    }>, Api.TypeLangPackDifference> {
    CONSTRUCTOR_ID: 3449309861;
    SUBCLASS_OF_ID: 1382427989;
    classType: "request";
    className: "langpack.GetDifference";
    static fromReader(reader: Reader): GetDifference;
      langPack: string;
      langCode: string;
      fromVersion: int;
    }
    export class GetLanguages extends Request<Partial<{
      langPack: string;
    }>, Api.TypeLangPackLanguage[]> {
    CONSTRUCTOR_ID: 1120311183;
    SUBCLASS_OF_ID: 671683273;
    classType: "request";
    className: "langpack.GetLanguages";
    static fromReader(reader: Reader): GetLanguages;
      langPack: string;
    }
    export class GetLanguage extends Request<Partial<{
      langPack: string;
      langCode: string;
    }>, Api.TypeLangPackLanguage> {
    CONSTRUCTOR_ID: 1784243458;
    SUBCLASS_OF_ID: 2880211383;
    classType: "request";
    className: "langpack.GetLanguage";
    static fromReader(reader: Reader): GetLanguage;
      langPack: string;
      langCode: string;
    }
  }

  export namespace folders {
    export class EditPeerFolders extends Request<Partial<{
      folderPeers: Api.TypeInputFolderPeer[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1749536939;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "folders.EditPeerFolders";
    static fromReader(reader: Reader): EditPeerFolders;
      folderPeers: Api.TypeInputFolderPeer[];
    }
  }

  export namespace stats {
    export class GetBroadcastStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
    }>, stats.TypeBroadcastStats> {
    CONSTRUCTOR_ID: 2873246746;
    SUBCLASS_OF_ID: 2146587688;
    classType: "request";
    className: "stats.GetBroadcastStats";
    static fromReader(reader: Reader): GetBroadcastStats;
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
    }
    export class LoadAsyncGraph extends Request<Partial<{
      // flags: null;
      token: string;
      x?: long;
    }>, Api.TypeStatsGraph> {
    CONSTRUCTOR_ID: 1646092192;
    SUBCLASS_OF_ID: 2609918291;
    classType: "request";
    className: "stats.LoadAsyncGraph";
    static fromReader(reader: Reader): LoadAsyncGraph;
      // flags: null;
      token: string;
      x?: long;
    }
    export class GetMegagroupStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
    }>, stats.TypeMegagroupStats> {
    CONSTRUCTOR_ID: 3705636359;
    SUBCLASS_OF_ID: 1532608141;
    classType: "request";
    className: "stats.GetMegagroupStats";
    static fromReader(reader: Reader): GetMegagroupStats;
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
    }
    export class GetMessagePublicForwards extends Request<Partial<{
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
      offset: string;
      limit: int;
    }>, stats.TypePublicForwards> {
    CONSTRUCTOR_ID: 1595212100;
    SUBCLASS_OF_ID: 2804429329;
    classType: "request";
    className: "stats.GetMessagePublicForwards";
    static fromReader(reader: Reader): GetMessagePublicForwards;
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
      offset: string;
      limit: int;
    }
    export class GetMessageStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }>, stats.TypeMessageStats> {
    CONSTRUCTOR_ID: 3068175349;
    SUBCLASS_OF_ID: 2516886306;
    classType: "request";
    className: "stats.GetMessageStats";
    static fromReader(reader: Reader): GetMessageStats;
      // flags: null;
      dark?: boolean;
      channel: Api.TypeEntityLike;
      msgId: MessageIDLike;
    }
    export class GetStoryStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
    }>, stats.TypeStoryStats> {
    CONSTRUCTOR_ID: 927985472;
    SUBCLASS_OF_ID: 2337096660;
    classType: "request";
    className: "stats.GetStoryStats";
    static fromReader(reader: Reader): GetStoryStats;
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
    }
    export class GetStoryPublicForwards extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int;
      offset: string;
      limit: int;
    }>, stats.TypePublicForwards> {
    CONSTRUCTOR_ID: 2789441270;
    SUBCLASS_OF_ID: 2804429329;
    classType: "request";
    className: "stats.GetStoryPublicForwards";
    static fromReader(reader: Reader): GetStoryPublicForwards;
      peer: Api.TypeEntityLike;
      id: int;
      offset: string;
      limit: int;
    }
    export class GetBroadcastRevenueStats extends Request<Partial<{
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
    }>, stats.TypeBroadcastRevenueStats> {
    CONSTRUCTOR_ID: 4152946201;
    SUBCLASS_OF_ID: 753807480;
    classType: "request";
    className: "stats.GetBroadcastRevenueStats";
    static fromReader(reader: Reader): GetBroadcastRevenueStats;
      // flags: null;
      dark?: boolean;
      peer: Api.TypeEntityLike;
    }
    export class GetBroadcastRevenueWithdrawalUrl extends Request<Partial<{
      peer: Api.TypeEntityLike;
      password: Api.TypeInputCheckPasswordSRP;
    }>, stats.TypeBroadcastRevenueWithdrawalUrl> {
    CONSTRUCTOR_ID: 2650077869;
    SUBCLASS_OF_ID: 3512518885;
    classType: "request";
    className: "stats.GetBroadcastRevenueWithdrawalUrl";
    static fromReader(reader: Reader): GetBroadcastRevenueWithdrawalUrl;
      peer: Api.TypeEntityLike;
      password: Api.TypeInputCheckPasswordSRP;
    }
    export class GetBroadcastRevenueTransactions extends Request<Partial<{
      peer: Api.TypeEntityLike;
      offset: int;
      limit: int;
    }>, stats.TypeBroadcastRevenueTransactions> {
    CONSTRUCTOR_ID: 1889078125;
    SUBCLASS_OF_ID: 108456469;
    classType: "request";
    className: "stats.GetBroadcastRevenueTransactions";
    static fromReader(reader: Reader): GetBroadcastRevenueTransactions;
      peer: Api.TypeEntityLike;
      offset: int;
      limit: int;
    }
  }

  export namespace chatlists {
    export class ExportChatlistInvite extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
      title: string;
      peers: Api.TypeEntityLike[];
    }>, chatlists.TypeExportedChatlistInvite> {
    CONSTRUCTOR_ID: 2222081934;
    SUBCLASS_OF_ID: 3261681385;
    classType: "request";
    className: "chatlists.ExportChatlistInvite";
    static fromReader(reader: Reader): ExportChatlistInvite;
      chatlist: Api.TypeInputChatlist;
      title: string;
      peers: Api.TypeEntityLike[];
    }
    export class DeleteExportedInvite extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
      slug: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1906072670;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "chatlists.DeleteExportedInvite";
    static fromReader(reader: Reader): DeleteExportedInvite;
      chatlist: Api.TypeInputChatlist;
      slug: string;
    }
    export class EditExportedInvite extends Request<Partial<{
      // flags: null;
      chatlist: Api.TypeInputChatlist;
      slug: string;
      title?: string;
      peers?: Api.TypeEntityLike[];
    }>, Api.TypeExportedChatlistInvite> {
    CONSTRUCTOR_ID: 1698543165;
    SUBCLASS_OF_ID: 1997666559;
    classType: "request";
    className: "chatlists.EditExportedInvite";
    static fromReader(reader: Reader): EditExportedInvite;
      // flags: null;
      chatlist: Api.TypeInputChatlist;
      slug: string;
      title?: string;
      peers?: Api.TypeEntityLike[];
    }
    export class GetExportedInvites extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
    }>, chatlists.TypeExportedInvites> {
    CONSTRUCTOR_ID: 3456359043;
    SUBCLASS_OF_ID: 3871476160;
    classType: "request";
    className: "chatlists.GetExportedInvites";
    static fromReader(reader: Reader): GetExportedInvites;
      chatlist: Api.TypeInputChatlist;
    }
    export class CheckChatlistInvite extends Request<Partial<{
      slug: string;
    }>, chatlists.TypeChatlistInvite> {
    CONSTRUCTOR_ID: 1103171583;
    SUBCLASS_OF_ID: 1097993845;
    classType: "request";
    className: "chatlists.CheckChatlistInvite";
    static fromReader(reader: Reader): CheckChatlistInvite;
      slug: string;
    }
    export class JoinChatlistInvite extends Request<Partial<{
      slug: string;
      peers: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2796675994;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "chatlists.JoinChatlistInvite";
    static fromReader(reader: Reader): JoinChatlistInvite;
      slug: string;
      peers: Api.TypeEntityLike[];
    }
    export class GetChatlistUpdates extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
    }>, chatlists.TypeChatlistUpdates> {
    CONSTRUCTOR_ID: 2302776609;
    SUBCLASS_OF_ID: 2098610666;
    classType: "request";
    className: "chatlists.GetChatlistUpdates";
    static fromReader(reader: Reader): GetChatlistUpdates;
      chatlist: Api.TypeInputChatlist;
    }
    export class JoinChatlistUpdates extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
      peers: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3767138549;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "chatlists.JoinChatlistUpdates";
    static fromReader(reader: Reader): JoinChatlistUpdates;
      chatlist: Api.TypeInputChatlist;
      peers: Api.TypeEntityLike[];
    }
    export class HideChatlistUpdates extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
    }>, Bool> {
    CONSTRUCTOR_ID: 1726252795;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "chatlists.HideChatlistUpdates";
    static fromReader(reader: Reader): HideChatlistUpdates;
      chatlist: Api.TypeInputChatlist;
    }
    export class GetLeaveChatlistSuggestions extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
    }>, Api.TypePeer[]> {
    CONSTRUCTOR_ID: 4257011476;
    SUBCLASS_OF_ID: 3113508222;
    classType: "request";
    className: "chatlists.GetLeaveChatlistSuggestions";
    static fromReader(reader: Reader): GetLeaveChatlistSuggestions;
      chatlist: Api.TypeInputChatlist;
    }
    export class LeaveChatlist extends Request<Partial<{
      chatlist: Api.TypeInputChatlist;
      peers: Api.TypeEntityLike[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1962598714;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "chatlists.LeaveChatlist";
    static fromReader(reader: Reader): LeaveChatlist;
      chatlist: Api.TypeInputChatlist;
      peers: Api.TypeEntityLike[];
    }
  }

  export namespace stories {
    export class CanSendStory extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, Bool> {
    CONSTRUCTOR_ID: 3353337821;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stories.CanSendStory";
    static fromReader(reader: Reader): CanSendStory;
      peer: Api.TypeEntityLike;
    }
    export class SendStory extends Request<Partial<{
      // flags: null;
      pinned?: boolean;
      noforwards?: boolean;
      fwdModified?: boolean;
      peer: Api.TypeEntityLike;
      media: Api.TypeInputMedia;
      mediaAreas?: Api.TypeMediaArea[];
      caption?: string;
      entities?: Api.TypeMessageEntity[];
      privacyRules: Api.TypeInputPrivacyRule[];
      randomId?: long;
      period?: int;
      fwdFromId?: Api.TypeEntityLike;
      fwdFromStory?: int;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3840305483;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "stories.SendStory";
    static fromReader(reader: Reader): SendStory;
      // flags: null;
      pinned?: boolean;
      noforwards?: boolean;
      fwdModified?: boolean;
      peer: Api.TypeEntityLike;
      media: Api.TypeInputMedia;
      mediaAreas?: Api.TypeMediaArea[];
      caption?: string;
      entities?: Api.TypeMessageEntity[];
      privacyRules: Api.TypeInputPrivacyRule[];
      randomId?: long;
      period?: int;
      fwdFromId?: Api.TypeEntityLike;
      fwdFromStory?: int;
    }
    export class EditStory extends Request<Partial<{
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      media?: Api.TypeInputMedia;
      mediaAreas?: Api.TypeMediaArea[];
      caption?: string;
      entities?: Api.TypeMessageEntity[];
      privacyRules?: Api.TypeInputPrivacyRule[];
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 3045308998;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "stories.EditStory";
    static fromReader(reader: Reader): EditStory;
      // flags: null;
      peer: Api.TypeEntityLike;
      id: int;
      media?: Api.TypeInputMedia;
      mediaAreas?: Api.TypeMediaArea[];
      caption?: string;
      entities?: Api.TypeMessageEntity[];
      privacyRules?: Api.TypeInputPrivacyRule[];
    }
    export class DeleteStories extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, int[]> {
    CONSTRUCTOR_ID: 2925124447;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "stories.DeleteStories";
    static fromReader(reader: Reader): DeleteStories;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class TogglePinned extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
      pinned: Bool;
    }>, int[]> {
    CONSTRUCTOR_ID: 2591400431;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "stories.TogglePinned";
    static fromReader(reader: Reader): TogglePinned;
      peer: Api.TypeEntityLike;
      id: int[];
      pinned: Bool;
    }
    export class GetAllStories extends Request<Partial<{
      // flags: null;
      next?: boolean;
      hidden?: boolean;
      state?: string;
    }>, stories.TypeAllStories> {
    CONSTRUCTOR_ID: 4004566565;
    SUBCLASS_OF_ID: 2120274125;
    classType: "request";
    className: "stories.GetAllStories";
    static fromReader(reader: Reader): GetAllStories;
      // flags: null;
      next?: boolean;
      hidden?: boolean;
      state?: string;
    }
    export class GetPinnedStories extends Request<Partial<{
      peer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }>, stories.TypeStories> {
    CONSTRUCTOR_ID: 1478600156;
    SUBCLASS_OF_ID: 622595116;
    classType: "request";
    className: "stories.GetPinnedStories";
    static fromReader(reader: Reader): GetPinnedStories;
      peer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }
    export class GetStoriesArchive extends Request<Partial<{
      peer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }>, stories.TypeStories> {
    CONSTRUCTOR_ID: 3023380502;
    SUBCLASS_OF_ID: 622595116;
    classType: "request";
    className: "stories.GetStoriesArchive";
    static fromReader(reader: Reader): GetStoriesArchive;
      peer: Api.TypeEntityLike;
      offsetId: int;
      limit: int;
    }
    export class GetStoriesByID extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, stories.TypeStories> {
    CONSTRUCTOR_ID: 1467271796;
    SUBCLASS_OF_ID: 622595116;
    classType: "request";
    className: "stories.GetStoriesByID";
    static fromReader(reader: Reader): GetStoriesByID;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class ToggleAllStoriesHidden extends Request<Partial<{
      hidden: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 2082822084;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stories.ToggleAllStoriesHidden";
    static fromReader(reader: Reader): ToggleAllStoriesHidden;
      hidden: Bool;
    }
    export class ReadStories extends Request<Partial<{
      peer: Api.TypeEntityLike;
      maxId: int;
    }>, int[]> {
    CONSTRUCTOR_ID: 2773932744;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "stories.ReadStories";
    static fromReader(reader: Reader): ReadStories;
      peer: Api.TypeEntityLike;
      maxId: int;
    }
    export class IncrementStoryViews extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 2986511099;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stories.IncrementStoryViews";
    static fromReader(reader: Reader): IncrementStoryViews;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class GetStoryViewsList extends Request<Partial<{
      // flags: null;
      justContacts?: boolean;
      reactionsFirst?: boolean;
      forwardsFirst?: boolean;
      peer: Api.TypeEntityLike;
      q?: string;
      id: int;
      offset: string;
      limit: int;
    }>, stories.TypeStoryViewsList> {
    CONSTRUCTOR_ID: 2127707223;
    SUBCLASS_OF_ID: 3108205920;
    classType: "request";
    className: "stories.GetStoryViewsList";
    static fromReader(reader: Reader): GetStoryViewsList;
      // flags: null;
      justContacts?: boolean;
      reactionsFirst?: boolean;
      forwardsFirst?: boolean;
      peer: Api.TypeEntityLike;
      q?: string;
      id: int;
      offset: string;
      limit: int;
    }
    export class GetStoriesViews extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, stories.TypeStoryViews> {
    CONSTRUCTOR_ID: 685862088;
    SUBCLASS_OF_ID: 1262470330;
    classType: "request";
    className: "stories.GetStoriesViews";
    static fromReader(reader: Reader): GetStoriesViews;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class ExportStoryLink extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int;
    }>, Api.TypeExportedStoryLink> {
    CONSTRUCTOR_ID: 2072899360;
    SUBCLASS_OF_ID: 264585638;
    classType: "request";
    className: "stories.ExportStoryLink";
    static fromReader(reader: Reader): ExportStoryLink;
      peer: Api.TypeEntityLike;
      id: int;
    }
    export class Report extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
      option: bytes;
      message: string;
    }>, Api.TypeReportResult> {
    CONSTRUCTOR_ID: 433646405;
    SUBCLASS_OF_ID: 2899571768;
    classType: "request";
    className: "stories.Report";
    static fromReader(reader: Reader): Report;
      peer: Api.TypeEntityLike;
      id: int[];
      option: bytes;
      message: string;
    }
    export class ActivateStealthMode extends Request<Partial<{
      // flags: null;
      past?: boolean;
      future?: boolean;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 1471926630;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "stories.ActivateStealthMode";
    static fromReader(reader: Reader): ActivateStealthMode;
      // flags: null;
      past?: boolean;
      future?: boolean;
    }
    export class SendReaction extends Request<Partial<{
      // flags: null;
      addToRecent?: boolean;
      peer: Api.TypeEntityLike;
      storyId: int;
      reaction: Api.TypeReaction;
    }>, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2144810674;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "stories.SendReaction";
    static fromReader(reader: Reader): SendReaction;
      // flags: null;
      addToRecent?: boolean;
      peer: Api.TypeEntityLike;
      storyId: int;
      reaction: Api.TypeReaction;
    }
    export class GetPeerStories extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, stories.TypePeerStories> {
    CONSTRUCTOR_ID: 743103056;
    SUBCLASS_OF_ID: 2639712208;
    classType: "request";
    className: "stories.GetPeerStories";
    static fromReader(reader: Reader): GetPeerStories;
      peer: Api.TypeEntityLike;
    }
    export class GetAllReadPeerStories extends Request<void, Api.TypeUpdates> {
    CONSTRUCTOR_ID: 2606426105;
    SUBCLASS_OF_ID: 2331323052;
    classType: "request";
    className: "stories.GetAllReadPeerStories";
    static fromReader(reader: Reader): GetAllReadPeerStories;
}
    export class GetPeerMaxIDs extends Request<Partial<{
      id: Api.TypeEntityLike[];
    }>, int[]> {
    CONSTRUCTOR_ID: 1398375363;
    SUBCLASS_OF_ID: 1344696591;
    classType: "request";
    className: "stories.GetPeerMaxIDs";
    static fromReader(reader: Reader): GetPeerMaxIDs;
      id: Api.TypeEntityLike[];
    }
    export class GetChatsToSend extends Request<void, messages.TypeChats> {
    CONSTRUCTOR_ID: 2775223136;
    SUBCLASS_OF_ID: 2580925204;
    classType: "request";
    className: "stories.GetChatsToSend";
    static fromReader(reader: Reader): GetChatsToSend;
}
    export class TogglePeerStoriesHidden extends Request<Partial<{
      peer: Api.TypeEntityLike;
      hidden: Bool;
    }>, Bool> {
    CONSTRUCTOR_ID: 3171161540;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stories.TogglePeerStoriesHidden";
    static fromReader(reader: Reader): TogglePeerStoriesHidden;
      peer: Api.TypeEntityLike;
      hidden: Bool;
    }
    export class GetStoryReactionsList extends Request<Partial<{
      // flags: null;
      forwardsFirst?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      reaction?: Api.TypeReaction;
      offset?: string;
      limit: int;
    }>, stories.TypeStoryReactionsList> {
    CONSTRUCTOR_ID: 3115485215;
    SUBCLASS_OF_ID: 74420707;
    classType: "request";
    className: "stories.GetStoryReactionsList";
    static fromReader(reader: Reader): GetStoryReactionsList;
      // flags: null;
      forwardsFirst?: boolean;
      peer: Api.TypeEntityLike;
      id: int;
      reaction?: Api.TypeReaction;
      offset?: string;
      limit: int;
    }
    export class TogglePinnedToTop extends Request<Partial<{
      peer: Api.TypeEntityLike;
      id: int[];
    }>, Bool> {
    CONSTRUCTOR_ID: 187268763;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "stories.TogglePinnedToTop";
    static fromReader(reader: Reader): TogglePinnedToTop;
      peer: Api.TypeEntityLike;
      id: int[];
    }
    export class SearchPosts extends Request<Partial<{
      // flags: null;
      hashtag?: string;
      area?: Api.TypeMediaArea;
      peer?: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }>, stories.TypeFoundStories> {
    CONSTRUCTOR_ID: 3514894599;
    SUBCLASS_OF_ID: 393808693;
    classType: "request";
    className: "stories.SearchPosts";
    static fromReader(reader: Reader): SearchPosts;
      // flags: null;
      hashtag?: string;
      area?: Api.TypeMediaArea;
      peer?: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }
  }

  export namespace premium {
    export class GetBoostsList extends Request<Partial<{
      // flags: null;
      gifts?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }>, premium.TypeBoostsList> {
    CONSTRUCTOR_ID: 1626764896;
    SUBCLASS_OF_ID: 573941949;
    classType: "request";
    className: "premium.GetBoostsList";
    static fromReader(reader: Reader): GetBoostsList;
      // flags: null;
      gifts?: boolean;
      peer: Api.TypeEntityLike;
      offset: string;
      limit: int;
    }
    export class GetMyBoosts extends Request<void, premium.TypeMyBoosts> {
    CONSTRUCTOR_ID: 199719754;
    SUBCLASS_OF_ID: 2905936603;
    classType: "request";
    className: "premium.GetMyBoosts";
    static fromReader(reader: Reader): GetMyBoosts;
}
    export class ApplyBoost extends Request<Partial<{
      // flags: null;
      slots?: int[];
      peer: Api.TypeEntityLike;
    }>, premium.TypeMyBoosts> {
    CONSTRUCTOR_ID: 1803396934;
    SUBCLASS_OF_ID: 2905936603;
    classType: "request";
    className: "premium.ApplyBoost";
    static fromReader(reader: Reader): ApplyBoost;
      // flags: null;
      slots?: int[];
      peer: Api.TypeEntityLike;
    }
    export class GetBoostsStatus extends Request<Partial<{
      peer: Api.TypeEntityLike;
    }>, premium.TypeBoostsStatus> {
    CONSTRUCTOR_ID: 70197089;
    SUBCLASS_OF_ID: 3273333433;
    classType: "request";
    className: "premium.GetBoostsStatus";
    static fromReader(reader: Reader): GetBoostsStatus;
      peer: Api.TypeEntityLike;
    }
    export class GetUserBoosts extends Request<Partial<{
      peer: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
    }>, premium.TypeBoostsList> {
    CONSTRUCTOR_ID: 965037343;
    SUBCLASS_OF_ID: 573941949;
    classType: "request";
    className: "premium.GetUserBoosts";
    static fromReader(reader: Reader): GetUserBoosts;
      peer: Api.TypeEntityLike;
      userId: Api.TypeEntityLike;
    }
  }

  export namespace smsjobs {
    export class IsEligibleToJoin extends Request<void, smsjobs.TypeEligibilityToJoin> {
    CONSTRUCTOR_ID: 249313744;
    SUBCLASS_OF_ID: 1589076134;
    classType: "request";
    className: "smsjobs.IsEligibleToJoin";
    static fromReader(reader: Reader): IsEligibleToJoin;
}
    export class Join extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2806959661;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "smsjobs.Join";
    static fromReader(reader: Reader): Join;
}
    export class Leave extends Request<void, Bool> {
    CONSTRUCTOR_ID: 2560142707;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "smsjobs.Leave";
    static fromReader(reader: Reader): Leave;
}
    export class UpdateSettings extends Request<Partial<{
      // flags: null;
      allowInternational?: boolean;
    }>, Bool> {
    CONSTRUCTOR_ID: 155164863;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "smsjobs.UpdateSettings";
    static fromReader(reader: Reader): UpdateSettings;
      // flags: null;
      allowInternational?: boolean;
    }
    export class GetStatus extends Request<void, smsjobs.TypeStatus> {
    CONSTRUCTOR_ID: 279353576;
    SUBCLASS_OF_ID: 3448711973;
    classType: "request";
    className: "smsjobs.GetStatus";
    static fromReader(reader: Reader): GetStatus;
}
    export class GetSmsJob extends Request<Partial<{
      jobId: string;
    }>, Api.TypeSmsJob> {
    CONSTRUCTOR_ID: 2005766191;
    SUBCLASS_OF_ID: 522459262;
    classType: "request";
    className: "smsjobs.GetSmsJob";
    static fromReader(reader: Reader): GetSmsJob;
      jobId: string;
    }
    export class FinishJob extends Request<Partial<{
      // flags: null;
      jobId: string;
      error?: string;
    }>, Bool> {
    CONSTRUCTOR_ID: 1327415076;
    SUBCLASS_OF_ID: 4122188204;
    classType: "request";
    className: "smsjobs.FinishJob";
    static fromReader(reader: Reader): FinishJob;
      // flags: null;
      jobId: string;
      error?: string;
    }
  }

  export namespace fragment {
    export class GetCollectibleInfo extends Request<Partial<{
      collectible: Api.TypeInputCollectible;
    }>, fragment.TypeCollectibleInfo> {
    CONSTRUCTOR_ID: 3189671354;
    SUBCLASS_OF_ID: 3572127632;
    classType: "request";
    className: "fragment.GetCollectibleInfo";
    static fromReader(reader: Reader): GetCollectibleInfo;
      collectible: Api.TypeInputCollectible;
    }
  }
// Types
  export type TypeEntityLike = EntityLike;
  export type TypeInputPeer = InputPeerEmpty | InputPeerSelf | InputPeerChat | InputPeerUser | InputPeerChannel | InputPeerUserFromMessage | InputPeerChannelFromMessage;
  export type TypeInputUser = InputUserEmpty | InputUserSelf | InputUser | InputUserFromMessage;
  export type TypeInputContact = InputPhoneContact;
  export type TypeInputFile = InputFile | InputFileBig | InputFileStoryDocument;
  export type TypeInputMedia = InputMediaEmpty | InputMediaUploadedPhoto | InputMediaPhoto | InputMediaGeoPoint | InputMediaContact | InputMediaUploadedDocument | InputMediaDocument | InputMediaVenue | InputMediaPhotoExternal | InputMediaDocumentExternal | InputMediaGame | InputMediaInvoice | InputMediaGeoLive | InputMediaPoll | InputMediaDice | InputMediaStory | InputMediaWebPage | InputMediaPaidMedia;
  export type TypeInputChatPhoto = InputChatPhotoEmpty | InputChatUploadedPhoto | InputChatPhoto;
  export type TypeInputGeoPoint = InputGeoPointEmpty | InputGeoPoint;
  export type TypeInputPhoto = InputPhotoEmpty | InputPhoto;
  export type TypeInputFileLocation = InputFileLocation | InputEncryptedFileLocation | InputDocumentFileLocation | InputSecureFileLocation | InputTakeoutFileLocation | InputPhotoFileLocation | InputPhotoLegacyFileLocation | InputPeerPhotoFileLocation | InputStickerSetThumb | InputGroupCallStream;
  export type TypePeer = PeerUser | PeerChat | PeerChannel;
  export type TypeUser = UserEmpty | User;
  export type TypeUserProfilePhoto = UserProfilePhotoEmpty | UserProfilePhoto;
  export type TypeUserStatus = UserStatusEmpty | UserStatusOnline | UserStatusOffline | UserStatusRecently | UserStatusLastWeek | UserStatusLastMonth;
  export type TypeChat = ChatEmpty | Chat | ChatForbidden | Channel | ChannelForbidden;
  export type TypeChatFull = ChatFull | ChannelFull;
  export type TypeChatParticipant = ChatParticipant | ChatParticipantCreator | ChatParticipantAdmin;
  export type TypeChatParticipants = ChatParticipantsForbidden | ChatParticipants;
  export type TypeChatPhoto = ChatPhotoEmpty | ChatPhoto;
  export type TypeMessage = MessageEmpty | Message | MessageService;
  export type TypeMessageMedia = MessageMediaEmpty | MessageMediaPhoto | MessageMediaGeo | MessageMediaContact | MessageMediaUnsupported | MessageMediaDocument | MessageMediaWebPage | MessageMediaVenue | MessageMediaGame | MessageMediaInvoice | MessageMediaGeoLive | MessageMediaPoll | MessageMediaDice | MessageMediaStory | MessageMediaGiveaway | MessageMediaGiveawayResults | MessageMediaPaidMedia;
  export type TypeMessageAction = MessageActionEmpty | MessageActionChatCreate | MessageActionChatEditTitle | MessageActionChatEditPhoto | MessageActionChatDeletePhoto | MessageActionChatAddUser | MessageActionChatDeleteUser | MessageActionChatJoinedByLink | MessageActionChannelCreate | MessageActionChatMigrateTo | MessageActionChannelMigrateFrom | MessageActionPinMessage | MessageActionHistoryClear | MessageActionGameScore | MessageActionPaymentSentMe | MessageActionPaymentSent | MessageActionPhoneCall | MessageActionScreenshotTaken | MessageActionCustomAction | MessageActionBotAllowed | MessageActionSecureValuesSentMe | MessageActionSecureValuesSent | MessageActionContactSignUp | MessageActionGeoProximityReached | MessageActionGroupCall | MessageActionInviteToGroupCall | MessageActionSetMessagesTTL | MessageActionGroupCallScheduled | MessageActionSetChatTheme | MessageActionChatJoinedByRequest | MessageActionWebViewDataSentMe | MessageActionWebViewDataSent | MessageActionGiftPremium | MessageActionTopicCreate | MessageActionTopicEdit | MessageActionSuggestProfilePhoto | MessageActionRequestedPeer | MessageActionSetChatWallPaper | MessageActionGiftCode | MessageActionGiveawayLaunch | MessageActionGiveawayResults | MessageActionBoostApply | MessageActionRequestedPeerSentMe | MessageActionPaymentRefunded | MessageActionGiftStars | MessageActionPrizeStars | MessageActionStarGift | MessageActionStarGiftUnique;
  export type TypeDialog = Dialog | DialogFolder;
  export type TypePhoto = PhotoEmpty | Photo;
  export type TypePhotoSize = PhotoSizeEmpty | PhotoSize | PhotoCachedSize | PhotoStrippedSize | PhotoSizeProgressive | PhotoPathSize;
  export type TypeGeoPoint = GeoPointEmpty | GeoPoint;
  export type TypeInputNotifyPeer = InputNotifyPeer | InputNotifyUsers | InputNotifyChats | InputNotifyBroadcasts | InputNotifyForumTopic;
  export type TypeInputPeerNotifySettings = InputPeerNotifySettings;
  export type TypePeerNotifySettings = PeerNotifySettings;
  export type TypePeerSettings = PeerSettings;
  export type TypeWallPaper = WallPaper | WallPaperNoFile;
  export type TypeReportReason = InputReportReasonSpam | InputReportReasonViolence | InputReportReasonPornography | InputReportReasonChildAbuse | InputReportReasonOther | InputReportReasonCopyright | InputReportReasonGeoIrrelevant | InputReportReasonFake | InputReportReasonIllegalDrugs | InputReportReasonPersonalDetails;
  export type TypeUserFull = UserFull;
  export type TypeContact = Contact;
  export type TypeImportedContact = ImportedContact;
  export type TypeContactStatus = ContactStatus;
  export type TypeMessagesFilter = InputMessagesFilterEmpty | InputMessagesFilterPhotos | InputMessagesFilterVideo | InputMessagesFilterPhotoVideo | InputMessagesFilterDocument | InputMessagesFilterUrl | InputMessagesFilterGif | InputMessagesFilterVoice | InputMessagesFilterMusic | InputMessagesFilterChatPhotos | InputMessagesFilterPhoneCalls | InputMessagesFilterRoundVoice | InputMessagesFilterRoundVideo | InputMessagesFilterMyMentions | InputMessagesFilterGeo | InputMessagesFilterContacts | InputMessagesFilterPinned;
  export type TypeUpdate = UpdateNewMessage | UpdateMessageID | UpdateDeleteMessages | UpdateUserTyping | UpdateChatUserTyping | UpdateChatParticipants | UpdateUserStatus | UpdateUserName | UpdateNewAuthorization | UpdateNewEncryptedMessage | UpdateEncryptedChatTyping | UpdateEncryption | UpdateEncryptedMessagesRead | UpdateChatParticipantAdd | UpdateChatParticipantDelete | UpdateDcOptions | UpdateNotifySettings | UpdateServiceNotification | UpdatePrivacy | UpdateUserPhone | UpdateReadHistoryInbox | UpdateReadHistoryOutbox | UpdateWebPage | UpdateReadMessagesContents | UpdateChannelTooLong | UpdateChannel | UpdateNewChannelMessage | UpdateReadChannelInbox | UpdateDeleteChannelMessages | UpdateChannelMessageViews | UpdateChatParticipantAdmin | UpdateNewStickerSet | UpdateStickerSetsOrder | UpdateStickerSets | UpdateSavedGifs | UpdateBotInlineQuery | UpdateBotInlineSend | UpdateEditChannelMessage | UpdateBotCallbackQuery | UpdateEditMessage | UpdateInlineBotCallbackQuery | UpdateReadChannelOutbox | UpdateDraftMessage | UpdateReadFeaturedStickers | UpdateRecentStickers | UpdateConfig | UpdatePtsChanged | UpdateChannelWebPage | UpdateDialogPinned | UpdatePinnedDialogs | UpdateBotWebhookJSON | UpdateBotWebhookJSONQuery | UpdateBotShippingQuery | UpdateBotPrecheckoutQuery | UpdatePhoneCall | UpdateLangPackTooLong | UpdateLangPack | UpdateFavedStickers | UpdateChannelReadMessagesContents | UpdateContactsReset | UpdateChannelAvailableMessages | UpdateDialogUnreadMark | UpdateMessagePoll | UpdateChatDefaultBannedRights | UpdateFolderPeers | UpdatePeerSettings | UpdatePeerLocated | UpdateNewScheduledMessage | UpdateDeleteScheduledMessages | UpdateTheme | UpdateGeoLiveViewed | UpdateLoginToken | UpdateMessagePollVote | UpdateDialogFilter | UpdateDialogFilterOrder | UpdateDialogFilters | UpdatePhoneCallSignalingData | UpdateChannelMessageForwards | UpdateReadChannelDiscussionInbox | UpdateReadChannelDiscussionOutbox | UpdatePeerBlocked | UpdateChannelUserTyping | UpdatePinnedMessages | UpdatePinnedChannelMessages | UpdateChat | UpdateGroupCallParticipants | UpdateGroupCall | UpdatePeerHistoryTTL | UpdateChatParticipant | UpdateChannelParticipant | UpdateBotStopped | UpdateGroupCallConnection | UpdateBotCommands | UpdatePendingJoinRequests | UpdateBotChatInviteRequester | UpdateMessageReactions | UpdateAttachMenuBots | UpdateWebViewResultSent | UpdateBotMenuButton | UpdateSavedRingtones | UpdateTranscribedAudio | UpdateReadFeaturedEmojiStickers | UpdateUserEmojiStatus | UpdateRecentEmojiStatuses | UpdateRecentReactions | UpdateMoveStickerSetToTop | UpdateMessageExtendedMedia | UpdateChannelPinnedTopic | UpdateChannelPinnedTopics | UpdateUser | UpdateAutoSaveSettings | UpdateStory | UpdateReadStories | UpdateStoryID | UpdateStoriesStealthMode | UpdateSentStoryReaction | UpdateBotChatBoost | UpdateChannelViewForumAsMessages | UpdatePeerWallpaper | UpdateBotMessageReaction | UpdateBotMessageReactions | UpdateSavedDialogPinned | UpdatePinnedSavedDialogs | UpdateSavedReactionTags | UpdateSmsJob | UpdateQuickReplies | UpdateNewQuickReply | UpdateDeleteQuickReply | UpdateQuickReplyMessage | UpdateDeleteQuickReplyMessages | UpdateBotBusinessConnect | UpdateBotNewBusinessMessage | UpdateBotEditBusinessMessage | UpdateBotDeleteBusinessMessage | UpdateNewStoryReaction | UpdateBroadcastRevenueTransactions | UpdateStarsBalance | UpdateBusinessBotCallbackQuery | UpdateStarsRevenueStatus | UpdateBotPurchasedPaidMedia | UpdatePaidReactionPrivacy;
  export type TypeUpdates = UpdatesTooLong | UpdateShortMessage | UpdateShortChatMessage | UpdateShort | UpdatesCombined | Updates | UpdateShortSentMessage;
  export type TypeDcOption = DcOption;
  export type TypeConfig = Config;
  export type TypeNearestDc = NearestDc;
  export type TypeEncryptedChat = EncryptedChatEmpty | EncryptedChatWaiting | EncryptedChatRequested | EncryptedChat | EncryptedChatDiscarded;
  export type TypeInputEncryptedChat = InputEncryptedChat;
  export type TypeEncryptedFile = EncryptedFileEmpty | EncryptedFile;
  export type TypeInputEncryptedFile = InputEncryptedFileEmpty | InputEncryptedFileUploaded | InputEncryptedFile | InputEncryptedFileBigUploaded;
  export type TypeEncryptedMessage = EncryptedMessage | EncryptedMessageService;
  export type TypeInputDocument = InputDocumentEmpty | InputDocument;
  export type TypeDocument = DocumentEmpty | Document;
  export type TypeNotifyPeer = NotifyPeer | NotifyUsers | NotifyChats | NotifyBroadcasts | NotifyForumTopic;
  export type TypeSendMessageAction = SendMessageTypingAction | SendMessageCancelAction | SendMessageRecordVideoAction | SendMessageUploadVideoAction | SendMessageRecordAudioAction | SendMessageUploadAudioAction | SendMessageUploadPhotoAction | SendMessageUploadDocumentAction | SendMessageGeoLocationAction | SendMessageChooseContactAction | SendMessageGamePlayAction | SendMessageRecordRoundAction | SendMessageUploadRoundAction | SpeakingInGroupCallAction | SendMessageHistoryImportAction | SendMessageChooseStickerAction | SendMessageEmojiInteraction | SendMessageEmojiInteractionSeen;
  export type TypeInputPrivacyKey = InputPrivacyKeyStatusTimestamp | InputPrivacyKeyChatInvite | InputPrivacyKeyPhoneCall | InputPrivacyKeyPhoneP2P | InputPrivacyKeyForwards | InputPrivacyKeyProfilePhoto | InputPrivacyKeyPhoneNumber | InputPrivacyKeyAddedByPhone | InputPrivacyKeyVoiceMessages | InputPrivacyKeyAbout | InputPrivacyKeyBirthday | InputPrivacyKeyStarGiftsAutoSave;
  export type TypePrivacyKey = PrivacyKeyStatusTimestamp | PrivacyKeyChatInvite | PrivacyKeyPhoneCall | PrivacyKeyPhoneP2P | PrivacyKeyForwards | PrivacyKeyProfilePhoto | PrivacyKeyPhoneNumber | PrivacyKeyAddedByPhone | PrivacyKeyVoiceMessages | PrivacyKeyAbout | PrivacyKeyBirthday | PrivacyKeyStarGiftsAutoSave;
  export type TypeInputPrivacyRule = InputPrivacyValueAllowContacts | InputPrivacyValueAllowAll | InputPrivacyValueAllowUsers | InputPrivacyValueDisallowContacts | InputPrivacyValueDisallowAll | InputPrivacyValueDisallowUsers | InputPrivacyValueAllowChatParticipants | InputPrivacyValueDisallowChatParticipants | InputPrivacyValueAllowCloseFriends | InputPrivacyValueAllowPremium | InputPrivacyValueAllowBots | InputPrivacyValueDisallowBots;
  export type TypePrivacyRule = PrivacyValueAllowContacts | PrivacyValueAllowAll | PrivacyValueAllowUsers | PrivacyValueDisallowContacts | PrivacyValueDisallowAll | PrivacyValueDisallowUsers | PrivacyValueAllowChatParticipants | PrivacyValueDisallowChatParticipants | PrivacyValueAllowCloseFriends | PrivacyValueAllowPremium | PrivacyValueAllowBots | PrivacyValueDisallowBots;
  export type TypeAccountDaysTTL = AccountDaysTTL;
  export type TypeDocumentAttribute = DocumentAttributeImageSize | DocumentAttributeAnimated | DocumentAttributeSticker | DocumentAttributeVideo | DocumentAttributeAudio | DocumentAttributeFilename | DocumentAttributeHasStickers | DocumentAttributeCustomEmoji;
  export type TypeStickerPack = StickerPack;
  export type TypeWebPage = WebPageEmpty | WebPagePending | WebPage | WebPageNotModified;
  export type TypeAuthorization = Authorization;
  export type TypeReceivedNotifyMessage = ReceivedNotifyMessage;
  export type TypeExportedChatInvite = ChatInviteExported | ChatInvitePublicJoinRequests;
  export type TypeChatInvite = ChatInviteAlready | ChatInvite | ChatInvitePeek;
  export type TypeInputStickerSet = InputStickerSetEmpty | InputStickerSetID | InputStickerSetShortName | InputStickerSetAnimatedEmoji | InputStickerSetDice | InputStickerSetAnimatedEmojiAnimations | InputStickerSetPremiumGifts | InputStickerSetEmojiGenericAnimations | InputStickerSetEmojiDefaultStatuses | InputStickerSetEmojiDefaultTopicIcons | InputStickerSetEmojiChannelDefaultStatuses;
  export type TypeStickerSet = StickerSet;
  export type TypeBotCommand = BotCommand;
  export type TypeBotInfo = BotInfo;
  export type TypeKeyboardButton = KeyboardButton | KeyboardButtonUrl | KeyboardButtonCallback | KeyboardButtonRequestPhone | KeyboardButtonRequestGeoLocation | KeyboardButtonSwitchInline | KeyboardButtonGame | KeyboardButtonBuy | KeyboardButtonUrlAuth | InputKeyboardButtonUrlAuth | KeyboardButtonRequestPoll | InputKeyboardButtonUserProfile | KeyboardButtonUserProfile | KeyboardButtonWebView | KeyboardButtonSimpleWebView | KeyboardButtonRequestPeer | InputKeyboardButtonRequestPeer | KeyboardButtonCopy;
  export type TypeKeyboardButtonRow = KeyboardButtonRow;
  export type TypeReplyMarkup = ReplyKeyboardHide | ReplyKeyboardForceReply | ReplyKeyboardMarkup | ReplyInlineMarkup;
  export type TypeMessageEntity = MessageEntityUnknown | MessageEntityMention | MessageEntityHashtag | MessageEntityBotCommand | MessageEntityUrl | MessageEntityEmail | MessageEntityBold | MessageEntityItalic | MessageEntityCode | MessageEntityPre | MessageEntityTextUrl | MessageEntityMentionName | InputMessageEntityMentionName | MessageEntityPhone | MessageEntityCashtag | MessageEntityUnderline | MessageEntityStrike | MessageEntityBankCard | MessageEntitySpoiler | MessageEntityCustomEmoji | MessageEntityBlockquote;
  export type TypeInputChannel = InputChannelEmpty | InputChannel | InputChannelFromMessage;
  export type TypeMessageRange = MessageRange;
  export type TypeChannelMessagesFilter = ChannelMessagesFilterEmpty | ChannelMessagesFilter;
  export type TypeChannelParticipant = ChannelParticipant | ChannelParticipantSelf | ChannelParticipantCreator | ChannelParticipantAdmin | ChannelParticipantBanned | ChannelParticipantLeft;
  export type TypeChannelParticipantsFilter = ChannelParticipantsRecent | ChannelParticipantsAdmins | ChannelParticipantsKicked | ChannelParticipantsBots | ChannelParticipantsBanned | ChannelParticipantsSearch | ChannelParticipantsContacts | ChannelParticipantsMentions;
  export type TypeInputBotInlineMessage = InputBotInlineMessageMediaAuto | InputBotInlineMessageText | InputBotInlineMessageMediaGeo | InputBotInlineMessageMediaVenue | InputBotInlineMessageMediaContact | InputBotInlineMessageGame | InputBotInlineMessageMediaInvoice | InputBotInlineMessageMediaWebPage;
  export type TypeInputBotInlineResult = InputBotInlineResult | InputBotInlineResultPhoto | InputBotInlineResultDocument | InputBotInlineResultGame;
  export type TypeBotInlineMessage = BotInlineMessageMediaAuto | BotInlineMessageText | BotInlineMessageMediaGeo | BotInlineMessageMediaVenue | BotInlineMessageMediaContact | BotInlineMessageMediaInvoice | BotInlineMessageMediaWebPage;
  export type TypeBotInlineResult = BotInlineResult | BotInlineMediaResult;
  export type TypeExportedMessageLink = ExportedMessageLink;
  export type TypeMessageFwdHeader = MessageFwdHeader;
  export type TypeInputBotInlineMessageID = InputBotInlineMessageID | InputBotInlineMessageID64;
  export type TypeInlineBotSwitchPM = InlineBotSwitchPM;
  export type TypeTopPeer = TopPeer;
  export type TypeTopPeerCategory = TopPeerCategoryBotsPM | TopPeerCategoryBotsInline | TopPeerCategoryCorrespondents | TopPeerCategoryGroups | TopPeerCategoryChannels | TopPeerCategoryPhoneCalls | TopPeerCategoryForwardUsers | TopPeerCategoryForwardChats | TopPeerCategoryBotsApp;
  export type TypeTopPeerCategoryPeers = TopPeerCategoryPeers;
  export type TypeDraftMessage = DraftMessageEmpty | DraftMessage;
  export type TypeStickerSetCovered = StickerSetCovered | StickerSetMultiCovered | StickerSetFullCovered | StickerSetNoCovered;
  export type TypeMaskCoords = MaskCoords;
  export type TypeInputStickeredMedia = InputStickeredMediaPhoto | InputStickeredMediaDocument;
  export type TypeGame = Game;
  export type TypeInputGame = InputGameID | InputGameShortName;
  export type TypeHighScore = HighScore;
  export type TypeRichText = TextEmpty | TextPlain | TextBold | TextItalic | TextUnderline | TextStrike | TextFixed | TextUrl | TextEmail | TextConcat | TextSubscript | TextSuperscript | TextMarked | TextPhone | TextImage | TextAnchor;
  export type TypePageBlock = PageBlockUnsupported | PageBlockTitle | PageBlockSubtitle | PageBlockAuthorDate | PageBlockHeader | PageBlockSubheader | PageBlockParagraph | PageBlockPreformatted | PageBlockFooter | PageBlockDivider | PageBlockAnchor | PageBlockList | PageBlockBlockquote | PageBlockPullquote | PageBlockPhoto | PageBlockVideo | PageBlockCover | PageBlockEmbed | PageBlockEmbedPost | PageBlockCollage | PageBlockSlideshow | PageBlockChannel | PageBlockAudio | PageBlockKicker | PageBlockTable | PageBlockOrderedList | PageBlockDetails | PageBlockRelatedArticles | PageBlockMap;
  export type TypePhoneCallDiscardReason = PhoneCallDiscardReasonMissed | PhoneCallDiscardReasonDisconnect | PhoneCallDiscardReasonHangup | PhoneCallDiscardReasonBusy | PhoneCallDiscardReasonAllowGroupCall;
  export type TypeDataJSON = DataJSON;
  export type TypeLabeledPrice = LabeledPrice;
  export type TypeInvoice = Invoice;
  export type TypePaymentCharge = PaymentCharge;
  export type TypePostAddress = PostAddress;
  export type TypePaymentRequestedInfo = PaymentRequestedInfo;
  export type TypePaymentSavedCredentials = PaymentSavedCredentialsCard;
  export type TypeWebDocument = WebDocument | WebDocumentNoProxy;
  export type TypeInputWebDocument = InputWebDocument;
  export type TypeInputWebFileLocation = InputWebFileLocation | InputWebFileGeoPointLocation | InputWebFileAudioAlbumThumbLocation;
  export type TypeInputPaymentCredentials = InputPaymentCredentialsSaved | InputPaymentCredentials | InputPaymentCredentialsApplePay | InputPaymentCredentialsGooglePay;
  export type TypeShippingOption = ShippingOption;
  export type TypeInputStickerSetItem = InputStickerSetItem;
  export type TypeInputPhoneCall = InputPhoneCall;
  export type TypePhoneCall = PhoneCallEmpty | PhoneCallWaiting | PhoneCallRequested | PhoneCallAccepted | PhoneCall | PhoneCallDiscarded;
  export type TypePhoneConnection = PhoneConnection | PhoneConnectionWebrtc;
  export type TypePhoneCallProtocol = PhoneCallProtocol;
  export type TypeCdnPublicKey = CdnPublicKey;
  export type TypeCdnConfig = CdnConfig;
  export type TypeLangPackString = LangPackString | LangPackStringPluralized | LangPackStringDeleted;
  export type TypeLangPackDifference = LangPackDifference;
  export type TypeLangPackLanguage = LangPackLanguage;
  export type TypeChannelAdminLogEventAction = ChannelAdminLogEventActionChangeTitle | ChannelAdminLogEventActionChangeAbout | ChannelAdminLogEventActionChangeUsername | ChannelAdminLogEventActionChangePhoto | ChannelAdminLogEventActionToggleInvites | ChannelAdminLogEventActionToggleSignatures | ChannelAdminLogEventActionUpdatePinned | ChannelAdminLogEventActionEditMessage | ChannelAdminLogEventActionDeleteMessage | ChannelAdminLogEventActionParticipantJoin | ChannelAdminLogEventActionParticipantLeave | ChannelAdminLogEventActionParticipantInvite | ChannelAdminLogEventActionParticipantToggleBan | ChannelAdminLogEventActionParticipantToggleAdmin | ChannelAdminLogEventActionChangeStickerSet | ChannelAdminLogEventActionTogglePreHistoryHidden | ChannelAdminLogEventActionDefaultBannedRights | ChannelAdminLogEventActionStopPoll | ChannelAdminLogEventActionChangeLinkedChat | ChannelAdminLogEventActionChangeLocation | ChannelAdminLogEventActionToggleSlowMode | ChannelAdminLogEventActionStartGroupCall | ChannelAdminLogEventActionDiscardGroupCall | ChannelAdminLogEventActionParticipantMute | ChannelAdminLogEventActionParticipantUnmute | ChannelAdminLogEventActionToggleGroupCallSetting | ChannelAdminLogEventActionParticipantJoinByInvite | ChannelAdminLogEventActionExportedInviteDelete | ChannelAdminLogEventActionExportedInviteRevoke | ChannelAdminLogEventActionExportedInviteEdit | ChannelAdminLogEventActionParticipantVolume | ChannelAdminLogEventActionChangeHistoryTTL | ChannelAdminLogEventActionParticipantJoinByRequest | ChannelAdminLogEventActionToggleNoForwards | ChannelAdminLogEventActionSendMessage | ChannelAdminLogEventActionChangeAvailableReactions | ChannelAdminLogEventActionChangeUsernames | ChannelAdminLogEventActionToggleForum | ChannelAdminLogEventActionCreateTopic | ChannelAdminLogEventActionEditTopic | ChannelAdminLogEventActionDeleteTopic | ChannelAdminLogEventActionPinTopic | ChannelAdminLogEventActionToggleAntiSpam | ChannelAdminLogEventActionChangePeerColor | ChannelAdminLogEventActionChangeProfilePeerColor | ChannelAdminLogEventActionChangeWallpaper | ChannelAdminLogEventActionChangeEmojiStatus | ChannelAdminLogEventActionChangeEmojiStickerSet | ChannelAdminLogEventActionToggleSignatureProfiles | ChannelAdminLogEventActionParticipantSubExtend;
  export type TypeChannelAdminLogEvent = ChannelAdminLogEvent;
  export type TypeChannelAdminLogEventsFilter = ChannelAdminLogEventsFilter;
  export type TypePopularContact = PopularContact;
  export type TypeRecentMeUrl = RecentMeUrlUnknown | RecentMeUrlUser | RecentMeUrlChat | RecentMeUrlChatInvite | RecentMeUrlStickerSet;
  export type TypeInputSingleMedia = InputSingleMedia;
  export type TypeWebAuthorization = WebAuthorization;
  export type TypeInputMessage = InputMessageID | InputMessageReplyTo | InputMessagePinned | InputMessageCallbackQuery;
  export type TypeInputDialogPeer = InputDialogPeer | InputDialogPeerFolder;
  export type TypeDialogPeer = DialogPeer | DialogPeerFolder;
  export type TypeFileHash = FileHash;
  export type TypeInputClientProxy = InputClientProxy;
  export type TypeInputSecureFile = InputSecureFileUploaded | InputSecureFile;
  export type TypeSecureFile = SecureFileEmpty | SecureFile;
  export type TypeSecureData = SecureData;
  export type TypeSecurePlainData = SecurePlainPhone | SecurePlainEmail;
  export type TypeSecureValueType = SecureValueTypePersonalDetails | SecureValueTypePassport | SecureValueTypeDriverLicense | SecureValueTypeIdentityCard | SecureValueTypeInternalPassport | SecureValueTypeAddress | SecureValueTypeUtilityBill | SecureValueTypeBankStatement | SecureValueTypeRentalAgreement | SecureValueTypePassportRegistration | SecureValueTypeTemporaryRegistration | SecureValueTypePhone | SecureValueTypeEmail;
  export type TypeSecureValue = SecureValue;
  export type TypeInputSecureValue = InputSecureValue;
  export type TypeSecureValueHash = SecureValueHash;
  export type TypeSecureValueError = SecureValueErrorData | SecureValueErrorFrontSide | SecureValueErrorReverseSide | SecureValueErrorSelfie | SecureValueErrorFile | SecureValueErrorFiles | SecureValueError | SecureValueErrorTranslationFile | SecureValueErrorTranslationFiles;
  export type TypeSecureCredentialsEncrypted = SecureCredentialsEncrypted;
  export type TypeSavedContact = SavedPhoneContact;
  export type TypePasswordKdfAlgo = PasswordKdfAlgoUnknown | PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow;
  export type TypeSecurePasswordKdfAlgo = SecurePasswordKdfAlgoUnknown | SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000 | SecurePasswordKdfAlgoSHA512;
  export type TypeSecureSecretSettings = SecureSecretSettings;
  export type TypeInputCheckPasswordSRP = InputCheckPasswordEmpty | InputCheckPasswordSRP;
  export type TypeSecureRequiredType = SecureRequiredType | SecureRequiredTypeOneOf;
  export type TypeInputAppEvent = InputAppEvent;
  export type TypeJSONObjectValue = JsonObjectValue;
  export type TypeJSONValue = JsonNull | JsonBool | JsonNumber | JsonString | JsonArray | JsonObject;
  export type TypePageTableCell = PageTableCell;
  export type TypePageTableRow = PageTableRow;
  export type TypePageCaption = PageCaption;
  export type TypePageListItem = PageListItemText | PageListItemBlocks;
  export type TypePageListOrderedItem = PageListOrderedItemText | PageListOrderedItemBlocks;
  export type TypePageRelatedArticle = PageRelatedArticle;
  export type TypePage = Page;
  export type TypePollAnswer = PollAnswer;
  export type TypePoll = Poll;
  export type TypePollAnswerVoters = PollAnswerVoters;
  export type TypePollResults = PollResults;
  export type TypeChatOnlines = ChatOnlines;
  export type TypeStatsURL = StatsURL;
  export type TypeChatAdminRights = ChatAdminRights;
  export type TypeChatBannedRights = ChatBannedRights;
  export type TypeInputWallPaper = InputWallPaper | InputWallPaperSlug | InputWallPaperNoFile;
  export type TypeCodeSettings = CodeSettings;
  export type TypeWallPaperSettings = WallPaperSettings;
  export type TypeAutoDownloadSettings = AutoDownloadSettings;
  export type TypeEmojiKeyword = EmojiKeyword | EmojiKeywordDeleted;
  export type TypeEmojiKeywordsDifference = EmojiKeywordsDifference;
  export type TypeEmojiURL = EmojiURL;
  export type TypeEmojiLanguage = EmojiLanguage;
  export type TypeFolder = Folder;
  export type TypeInputFolderPeer = InputFolderPeer;
  export type TypeFolderPeer = FolderPeer;
  export type TypeUrlAuthResult = UrlAuthResultRequest | UrlAuthResultAccepted | UrlAuthResultDefault;
  export type TypeChannelLocation = ChannelLocationEmpty | ChannelLocation;
  export type TypePeerLocated = PeerLocated | PeerSelfLocated;
  export type TypeRestrictionReason = RestrictionReason;
  export type TypeInputTheme = InputTheme | InputThemeSlug;
  export type TypeTheme = Theme;
  export type TypeBaseTheme = BaseThemeClassic | BaseThemeDay | BaseThemeNight | BaseThemeTinted | BaseThemeArctic;
  export type TypeInputThemeSettings = InputThemeSettings;
  export type TypeThemeSettings = ThemeSettings;
  export type TypeWebPageAttribute = WebPageAttributeTheme | WebPageAttributeStory | WebPageAttributeStickerSet | WebPageAttributeUniqueStarGift;
  export type TypeBankCardOpenUrl = BankCardOpenUrl;
  export type TypeDialogFilter = DialogFilter | DialogFilterDefault | DialogFilterChatlist;
  export type TypeDialogFilterSuggested = DialogFilterSuggested;
  export type TypeStatsDateRangeDays = StatsDateRangeDays;
  export type TypeStatsAbsValueAndPrev = StatsAbsValueAndPrev;
  export type TypeStatsPercentValue = StatsPercentValue;
  export type TypeStatsGraph = StatsGraphAsync | StatsGraphError | StatsGraph;
  export type TypeVideoSize = VideoSize | VideoSizeEmojiMarkup | VideoSizeStickerMarkup;
  export type TypeStatsGroupTopPoster = StatsGroupTopPoster;
  export type TypeStatsGroupTopAdmin = StatsGroupTopAdmin;
  export type TypeStatsGroupTopInviter = StatsGroupTopInviter;
  export type TypeGlobalPrivacySettings = GlobalPrivacySettings;
  export type TypeMessageViews = MessageViews;
  export type TypeMessageReplyHeader = MessageReplyHeader | MessageReplyStoryHeader;
  export type TypeMessageReplies = MessageReplies;
  export type TypePeerBlocked = PeerBlocked;
  export type TypeGroupCall = GroupCallDiscarded | GroupCall;
  export type TypeInputGroupCall = InputGroupCall;
  export type TypeGroupCallParticipant = GroupCallParticipant;
  export type TypeInlineQueryPeerType = InlineQueryPeerTypeSameBotPM | InlineQueryPeerTypePM | InlineQueryPeerTypeChat | InlineQueryPeerTypeMegagroup | InlineQueryPeerTypeBroadcast | InlineQueryPeerTypeBotPM;
  export type TypeChatInviteImporter = ChatInviteImporter;
  export type TypeChatAdminWithInvites = ChatAdminWithInvites;
  export type TypeGroupCallParticipantVideoSourceGroup = GroupCallParticipantVideoSourceGroup;
  export type TypeGroupCallParticipantVideo = GroupCallParticipantVideo;
  export type TypeBotCommandScope = BotCommandScopeDefault | BotCommandScopeUsers | BotCommandScopeChats | BotCommandScopeChatAdmins | BotCommandScopePeer | BotCommandScopePeerAdmins | BotCommandScopePeerUser;
  export type TypeSponsoredMessage = SponsoredMessage;
  export type TypeSearchResultsCalendarPeriod = SearchResultsCalendarPeriod;
  export type TypeSearchResultsPosition = SearchResultPosition;
  export type TypeReactionCount = ReactionCount;
  export type TypeMessageReactions = MessageReactions;
  export type TypeAvailableReaction = AvailableReaction;
  export type TypeMessagePeerReaction = MessagePeerReaction;
  export type TypeGroupCallStreamChannel = GroupCallStreamChannel;
  export type TypeAttachMenuBotIconColor = AttachMenuBotIconColor;
  export type TypeAttachMenuBotIcon = AttachMenuBotIcon;
  export type TypeAttachMenuBot = AttachMenuBot;
  export type TypeAttachMenuBots = AttachMenuBotsNotModified | AttachMenuBots;
  export type TypeAttachMenuBotsBot = AttachMenuBotsBot;
  export type TypeWebViewResult = WebViewResultUrl;
  export type TypeWebViewMessageSent = WebViewMessageSent;
  export type TypeBotMenuButton = BotMenuButtonDefault | BotMenuButtonCommands | BotMenuButton;
  export type TypeNotificationSound = NotificationSoundDefault | NotificationSoundNone | NotificationSoundLocal | NotificationSoundRingtone;
  export type TypeAttachMenuPeerType = AttachMenuPeerTypeSameBotPM | AttachMenuPeerTypeBotPM | AttachMenuPeerTypePM | AttachMenuPeerTypeChat | AttachMenuPeerTypeBroadcast;
  export type TypeInputInvoice = InputInvoiceMessage | InputInvoiceSlug | InputInvoicePremiumGiftCode | InputInvoiceStars | InputInvoiceChatInviteSubscription | InputInvoiceStarGift | InputInvoiceStarGiftUpgrade | InputInvoiceStarGiftTransfer;
  export type TypeInputStorePaymentPurpose = InputStorePaymentPremiumSubscription | InputStorePaymentGiftPremium | InputStorePaymentPremiumGiftCode | InputStorePaymentPremiumGiveaway | InputStorePaymentStarsTopup | InputStorePaymentStarsGift | InputStorePaymentStarsGiveaway;
  export type TypePremiumGiftOption = PremiumGiftOption;
  export type TypePaymentFormMethod = PaymentFormMethod;
  export type TypeEmojiStatus = EmojiStatusEmpty | EmojiStatus | EmojiStatusCollectible | InputEmojiStatusCollectible;
  export type TypeReaction = ReactionEmpty | ReactionEmoji | ReactionCustomEmoji | ReactionPaid;
  export type TypeChatReactions = ChatReactionsNone | ChatReactionsAll | ChatReactionsSome;
  export type TypeEmailVerifyPurpose = EmailVerifyPurposeLoginSetup | EmailVerifyPurposeLoginChange | EmailVerifyPurposePassport;
  export type TypeEmailVerification = EmailVerificationCode | EmailVerificationGoogle | EmailVerificationApple;
  export type TypePremiumSubscriptionOption = PremiumSubscriptionOption;
  export type TypeSendAsPeer = SendAsPeer;
  export type TypeMessageExtendedMedia = MessageExtendedMediaPreview | MessageExtendedMedia;
  export type TypeStickerKeyword = StickerKeyword;
  export type TypeUsername = Username;
  export type TypeForumTopic = ForumTopicDeleted | ForumTopic;
  export type TypeDefaultHistoryTTL = DefaultHistoryTTL;
  export type TypeExportedContactToken = ExportedContactToken;
  export type TypeRequestPeerType = RequestPeerTypeUser | RequestPeerTypeChat | RequestPeerTypeBroadcast;
  export type TypeEmojiList = EmojiListNotModified | EmojiList;
  export type TypeEmojiGroup = EmojiGroup | EmojiGroupGreeting | EmojiGroupPremium;
  export type TypeTextWithEntities = TextWithEntities;
  export type TypeAutoSaveSettings = AutoSaveSettings;
  export type TypeAutoSaveException = AutoSaveException;
  export type TypeInputBotApp = InputBotAppID | InputBotAppShortName;
  export type TypeBotApp = BotAppNotModified | BotApp;
  export type TypeInlineBotWebView = InlineBotWebView;
  export type TypeReadParticipantDate = ReadParticipantDate;
  export type TypeInputChatlist = InputChatlistDialogFilter;
  export type TypeExportedChatlistInvite = ExportedChatlistInvite;
  export type TypeMessagePeerVote = MessagePeerVote | MessagePeerVoteInputOption | MessagePeerVoteMultiple;
  export type TypeStoryViews = StoryViews;
  export type TypeStoryItem = StoryItemDeleted | StoryItemSkipped | StoryItem;
  export type TypeStoryView = StoryView | StoryViewPublicForward | StoryViewPublicRepost;
  export type TypeInputReplyTo = InputReplyToMessage | InputReplyToStory;
  export type TypeExportedStoryLink = ExportedStoryLink;
  export type TypeStoriesStealthMode = StoriesStealthMode;
  export type TypeMediaAreaCoordinates = MediaAreaCoordinates;
  export type TypeMediaArea = MediaAreaVenue | InputMediaAreaVenue | MediaAreaGeoPoint | MediaAreaSuggestedReaction | MediaAreaChannelPost | InputMediaAreaChannelPost | MediaAreaUrl | MediaAreaWeather | MediaAreaStarGift;
  export type TypePeerStories = PeerStories;
  export type TypePremiumGiftCodeOption = PremiumGiftCodeOption;
  export type TypePrepaidGiveaway = PrepaidGiveaway | PrepaidStarsGiveaway;
  export type TypeBoost = Boost;
  export type TypeMyBoost = MyBoost;
  export type TypeStoryFwdHeader = StoryFwdHeader;
  export type TypePostInteractionCounters = PostInteractionCountersMessage | PostInteractionCountersStory;
  export type TypePublicForward = PublicForwardMessage | PublicForwardStory;
  export type TypePeerColor = PeerColor;
  export type TypeStoryReaction = StoryReaction | StoryReactionPublicForward | StoryReactionPublicRepost;
  export type TypeSavedDialog = SavedDialog;
  export type TypeSavedReactionTag = SavedReactionTag;
  export type TypeOutboxReadDate = OutboxReadDate;
  export type TypeSmsJob = SmsJob;
  export type TypeBusinessWeeklyOpen = BusinessWeeklyOpen;
  export type TypeBusinessWorkHours = BusinessWorkHours;
  export type TypeBusinessLocation = BusinessLocation;
  export type TypeInputBusinessRecipients = InputBusinessRecipients;
  export type TypeBusinessRecipients = BusinessRecipients;
  export type TypeBusinessAwayMessageSchedule = BusinessAwayMessageScheduleAlways | BusinessAwayMessageScheduleOutsideWorkHours | BusinessAwayMessageScheduleCustom;
  export type TypeInputBusinessGreetingMessage = InputBusinessGreetingMessage;
  export type TypeBusinessGreetingMessage = BusinessGreetingMessage;
  export type TypeInputBusinessAwayMessage = InputBusinessAwayMessage;
  export type TypeBusinessAwayMessage = BusinessAwayMessage;
  export type TypeTimezone = Timezone;
  export type TypeQuickReply = QuickReply;
  export type TypeInputQuickReplyShortcut = InputQuickReplyShortcut | InputQuickReplyShortcutId;
  export type TypeConnectedBot = ConnectedBot;
  export type TypeBirthday = Birthday;
  export type TypeBotBusinessConnection = BotBusinessConnection;
  export type TypeInputBusinessIntro = InputBusinessIntro;
  export type TypeBusinessIntro = BusinessIntro;
  export type TypeInputCollectible = InputCollectibleUsername | InputCollectiblePhone;
  export type TypeInputBusinessBotRecipients = InputBusinessBotRecipients;
  export type TypeBusinessBotRecipients = BusinessBotRecipients;
  export type TypeContactBirthday = ContactBirthday;
  export type TypeMissingInvitee = MissingInvitee;
  export type TypeInputBusinessChatLink = InputBusinessChatLink;
  export type TypeBusinessChatLink = BusinessChatLink;
  export type TypeRequestedPeer = RequestedPeerUser | RequestedPeerChat | RequestedPeerChannel;
  export type TypeSponsoredMessageReportOption = SponsoredMessageReportOption;
  export type TypeBroadcastRevenueTransaction = BroadcastRevenueTransactionProceeds | BroadcastRevenueTransactionWithdrawal | BroadcastRevenueTransactionRefund;
  export type TypeReactionNotificationsFrom = ReactionNotificationsFromContacts | ReactionNotificationsFromAll;
  export type TypeReactionsNotifySettings = ReactionsNotifySettings;
  export type TypeBroadcastRevenueBalances = BroadcastRevenueBalances;
  export type TypeAvailableEffect = AvailableEffect;
  export type TypeFactCheck = FactCheck;
  export type TypeStarsTransactionPeer = StarsTransactionPeerUnsupported | StarsTransactionPeerAppStore | StarsTransactionPeerPlayMarket | StarsTransactionPeerPremiumBot | StarsTransactionPeerFragment | StarsTransactionPeer | StarsTransactionPeerAds | StarsTransactionPeerAPI;
  export type TypeStarsTopupOption = StarsTopupOption;
  export type TypeStarsTransaction = StarsTransaction;
  export type TypeFoundStory = FoundStory;
  export type TypeGeoPointAddress = GeoPointAddress;
  export type TypeStarsRevenueStatus = StarsRevenueStatus;
  export type TypeInputStarsTransaction = InputStarsTransaction;
  export type TypeStarsGiftOption = StarsGiftOption;
  export type TypeBotPreviewMedia = BotPreviewMedia;
  export type TypeStarsSubscriptionPricing = StarsSubscriptionPricing;
  export type TypeStarsSubscription = StarsSubscription;
  export type TypeMessageReactor = MessageReactor;
  export type TypeStarsGiveawayOption = StarsGiveawayOption;
  export type TypeStarsGiveawayWinnersOption = StarsGiveawayWinnersOption;
  export type TypeStarGift = StarGift | StarGiftUnique;
  export type TypeMessageReportOption = MessageReportOption;
  export type TypeReportResult = ReportResultChooseOption | ReportResultAddComment | ReportResultReported;
  export type TypeBotAppSettings = BotAppSettings;
  export type TypeStarRefProgram = StarRefProgram;
  export type TypeConnectedBotStarRef = ConnectedBotStarRef;
  export type TypeStarsAmount = StarsAmount;
  export type TypeBotVerifierSettings = BotVerifierSettings;
  export type TypeBotVerification = BotVerification;
  export type TypeStarGiftAttribute = StarGiftAttributeModel | StarGiftAttributePattern | StarGiftAttributeBackdrop | StarGiftAttributeOriginalDetails;
  export type TypeSavedStarGift = SavedStarGift;
  export type TypeInputSavedStarGift = InputSavedStarGiftUser | InputSavedStarGiftChat;
  export type TypeResPQ = ResPQ;
  export type TypeP_Q_inner_data = PQInnerData | PQInnerDataDc | PQInnerDataTemp | PQInnerDataTempDc;
  export type TypeBindAuthKeyInner = BindAuthKeyInner;
  export type TypeServer_DH_Params = ServerDHParamsFail | ServerDHParamsOk;
  export type TypeServer_DH_inner_data = ServerDHInnerData;
  export type TypeClient_DH_Inner_Data = ClientDHInnerData;
  export type TypeSet_client_DH_params_answer = DhGenOk | DhGenRetry | DhGenFail;
  export type TypeDestroyAuthKeyRes = DestroyAuthKeyOk | DestroyAuthKeyNone | DestroyAuthKeyFail;
  export type TypeMsgsAck = MsgsAck;
  export type TypeBadMsgNotification = BadMsgNotification | BadServerSalt;
  export type TypeMsgsStateReq = MsgsStateReq;
  export type TypeMsgsStateInfo = MsgsStateInfo;
  export type TypeMsgsAllInfo = MsgsAllInfo;
  export type TypeMsgDetailedInfo = MsgDetailedInfo | MsgNewDetailedInfo;
  export type TypeMsgResendReq = MsgResendReq;
  export type TypeRpcError = RpcError;
  export type TypeRpcDropAnswer = RpcAnswerUnknown | RpcAnswerDroppedRunning | RpcAnswerDropped;
  export type TypeFutureSalt = FutureSalt;
  export type TypeFutureSalts = FutureSalts;
  export type TypePong = Pong;
  export type TypeDestroySessionRes = DestroySessionOk | DestroySessionNone;
  export type TypeNewSession = NewSessionCreated;
  export type TypeHttpWait = HttpWait;
  export type TypeIpPort = IpPort | IpPortSecret;
  export type TypeAccessPointRule = AccessPointRule;
  export type TypeTlsClientHello = TlsClientHello;
  export type TypeTlsBlock = TlsBlockString | TlsBlockRandom | TlsBlockZero | TlsBlockDomain | TlsBlockGrease | TlsBlockPublicKey | TlsBlockScope | TlsBlockPermutation;
// All requests
  export type AnyRequest = InvokeAfterMsg | InvokeAfterMsgs | InitConnection | InvokeWithLayer | InvokeWithoutUpdates | InvokeWithMessagesRange | InvokeWithTakeout | InvokeWithBusinessConnection | InvokeWithGooglePlayIntegrity | InvokeWithApnsSecret | ReqPq | ReqPqMulti | ReqDHParams | SetClientDHParams | DestroyAuthKey | RpcDropAnswer | GetFutureSalts | Ping | PingDelayDisconnect | DestroySession
    | auth.SendCode | auth.SignUp | auth.SignIn | auth.LogOut | auth.ResetAuthorizations | auth.ExportAuthorization | auth.ImportAuthorization | auth.BindTempAuthKey | auth.ImportBotAuthorization | auth.CheckPassword | auth.RequestPasswordRecovery | auth.RecoverPassword | auth.ResendCode | auth.CancelCode | auth.DropTempAuthKeys | auth.ExportLoginToken | auth.ImportLoginToken | auth.AcceptLoginToken | auth.CheckRecoveryPassword | auth.ImportWebTokenAuthorization | auth.RequestFirebaseSms | auth.ResetLoginEmail | auth.ReportMissingCode
    | account.RegisterDevice | account.UnregisterDevice | account.UpdateNotifySettings | account.GetNotifySettings | account.ResetNotifySettings | account.UpdateProfile | account.UpdateStatus | account.GetWallPapers | account.ReportPeer | account.CheckUsername | account.UpdateUsername | account.GetPrivacy | account.SetPrivacy | account.DeleteAccount | account.GetAccountTTL | account.SetAccountTTL | account.SendChangePhoneCode | account.ChangePhone | account.UpdateDeviceLocked | account.GetAuthorizations | account.ResetAuthorization | account.GetPassword | account.GetPasswordSettings | account.UpdatePasswordSettings | account.SendConfirmPhoneCode | account.ConfirmPhone | account.GetTmpPassword | account.GetWebAuthorizations | account.ResetWebAuthorization | account.ResetWebAuthorizations | account.GetAllSecureValues | account.GetSecureValue | account.SaveSecureValue | account.DeleteSecureValue | account.GetAuthorizationForm | account.AcceptAuthorization | account.SendVerifyPhoneCode | account.VerifyPhone | account.SendVerifyEmailCode | account.VerifyEmail | account.InitTakeoutSession | account.FinishTakeoutSession | account.ConfirmPasswordEmail | account.ResendPasswordEmail | account.CancelPasswordEmail | account.GetContactSignUpNotification | account.SetContactSignUpNotification | account.GetNotifyExceptions | account.GetWallPaper | account.UploadWallPaper | account.SaveWallPaper | account.InstallWallPaper | account.ResetWallPapers | account.GetAutoDownloadSettings | account.SaveAutoDownloadSettings | account.UploadTheme | account.CreateTheme | account.UpdateTheme | account.SaveTheme | account.InstallTheme | account.GetTheme | account.GetThemes | account.SetContentSettings | account.GetContentSettings | account.GetMultiWallPapers | account.GetGlobalPrivacySettings | account.SetGlobalPrivacySettings | account.ReportProfilePhoto | account.ResetPassword | account.DeclinePasswordReset | account.GetChatThemes | account.SetAuthorizationTTL | account.ChangeAuthorizationSettings | account.GetSavedRingtones | account.SaveRingtone | account.UploadRingtone | account.UpdateEmojiStatus | account.GetDefaultEmojiStatuses | account.GetRecentEmojiStatuses | account.ClearRecentEmojiStatuses | account.ReorderUsernames | account.ToggleUsername | account.GetDefaultProfilePhotoEmojis | account.GetDefaultGroupPhotoEmojis | account.GetAutoSaveSettings | account.SaveAutoSaveSettings | account.DeleteAutoSaveExceptions | account.InvalidateSignInCodes | account.UpdateColor | account.GetDefaultBackgroundEmojis | account.GetChannelDefaultEmojiStatuses | account.GetChannelRestrictedStatusEmojis | account.UpdateBusinessWorkHours | account.UpdateBusinessLocation | account.UpdateBusinessGreetingMessage | account.UpdateBusinessAwayMessage | account.UpdateConnectedBot | account.GetConnectedBots | account.GetBotBusinessConnection | account.UpdateBusinessIntro | account.ToggleConnectedBotPaused | account.DisablePeerConnectedBot | account.UpdateBirthday | account.CreateBusinessChatLink | account.EditBusinessChatLink | account.DeleteBusinessChatLink | account.GetBusinessChatLinks | account.ResolveBusinessChatLink | account.UpdatePersonalChannel | account.ToggleSponsoredMessages | account.GetReactionsNotifySettings | account.SetReactionsNotifySettings | account.GetCollectibleEmojiStatuses
    | users.GetUsers | users.GetFullUser | users.SetSecureValueErrors | users.GetIsPremiumRequiredToContact
    | contacts.GetContactIDs | contacts.GetStatuses | contacts.GetContacts | contacts.ImportContacts | contacts.DeleteContacts | contacts.DeleteByPhones | contacts.Block | contacts.Unblock | contacts.GetBlocked | contacts.Search | contacts.ResolveUsername | contacts.GetTopPeers | contacts.ResetTopPeerRating | contacts.ResetSaved | contacts.GetSaved | contacts.ToggleTopPeers | contacts.AddContact | contacts.AcceptContact | contacts.GetLocated | contacts.BlockFromReplies | contacts.ResolvePhone | contacts.ExportContactToken | contacts.ImportContactToken | contacts.EditCloseFriends | contacts.SetBlocked | contacts.GetBirthdays
    | messages.GetMessages | messages.GetDialogs | messages.GetHistory | messages.Search | messages.ReadHistory | messages.DeleteHistory | messages.DeleteMessages | messages.ReceivedMessages | messages.SetTyping | messages.SendMessage | messages.SendMedia | messages.ForwardMessages | messages.ReportSpam | messages.GetPeerSettings | messages.Report | messages.GetChats | messages.GetFullChat | messages.EditChatTitle | messages.EditChatPhoto | messages.AddChatUser | messages.DeleteChatUser | messages.CreateChat | messages.GetDhConfig | messages.RequestEncryption | messages.AcceptEncryption | messages.DiscardEncryption | messages.SetEncryptedTyping | messages.ReadEncryptedHistory | messages.SendEncrypted | messages.SendEncryptedFile | messages.SendEncryptedService | messages.ReceivedQueue | messages.ReportEncryptedSpam | messages.ReadMessageContents | messages.GetStickers | messages.GetAllStickers | messages.GetWebPagePreview | messages.ExportChatInvite | messages.CheckChatInvite | messages.ImportChatInvite | messages.GetStickerSet | messages.InstallStickerSet | messages.UninstallStickerSet | messages.StartBot | messages.GetMessagesViews | messages.EditChatAdmin | messages.MigrateChat | messages.SearchGlobal | messages.ReorderStickerSets | messages.GetDocumentByHash | messages.GetSavedGifs | messages.SaveGif | messages.GetInlineBotResults | messages.SetInlineBotResults | messages.SendInlineBotResult | messages.GetMessageEditData | messages.EditMessage | messages.EditInlineBotMessage | messages.GetBotCallbackAnswer | messages.SetBotCallbackAnswer | messages.GetPeerDialogs | messages.SaveDraft | messages.GetAllDrafts | messages.GetFeaturedStickers | messages.ReadFeaturedStickers | messages.GetRecentStickers | messages.SaveRecentSticker | messages.ClearRecentStickers | messages.GetArchivedStickers | messages.GetMaskStickers | messages.GetAttachedStickers | messages.SetGameScore | messages.SetInlineGameScore | messages.GetGameHighScores | messages.GetInlineGameHighScores | messages.GetCommonChats | messages.GetWebPage | messages.ToggleDialogPin | messages.ReorderPinnedDialogs | messages.GetPinnedDialogs | messages.SetBotShippingResults | messages.SetBotPrecheckoutResults | messages.UploadMedia | messages.SendScreenshotNotification | messages.GetFavedStickers | messages.FaveSticker | messages.GetUnreadMentions | messages.ReadMentions | messages.GetRecentLocations | messages.SendMultiMedia | messages.UploadEncryptedFile | messages.SearchStickerSets | messages.GetSplitRanges | messages.MarkDialogUnread | messages.GetDialogUnreadMarks | messages.ClearAllDrafts | messages.UpdatePinnedMessage | messages.SendVote | messages.GetPollResults | messages.GetOnlines | messages.EditChatAbout | messages.EditChatDefaultBannedRights | messages.GetEmojiKeywords | messages.GetEmojiKeywordsDifference | messages.GetEmojiKeywordsLanguages | messages.GetEmojiURL | messages.GetSearchCounters | messages.RequestUrlAuth | messages.AcceptUrlAuth | messages.HidePeerSettingsBar | messages.GetScheduledHistory | messages.GetScheduledMessages | messages.SendScheduledMessages | messages.DeleteScheduledMessages | messages.GetPollVotes | messages.ToggleStickerSets | messages.GetDialogFilters | messages.GetSuggestedDialogFilters | messages.UpdateDialogFilter | messages.UpdateDialogFiltersOrder | messages.GetOldFeaturedStickers | messages.GetReplies | messages.GetDiscussionMessage | messages.ReadDiscussion | messages.UnpinAllMessages | messages.DeleteChat | messages.DeletePhoneCallHistory | messages.CheckHistoryImport | messages.InitHistoryImport | messages.UploadImportedMedia | messages.StartHistoryImport | messages.GetExportedChatInvites | messages.GetExportedChatInvite | messages.EditExportedChatInvite | messages.DeleteRevokedExportedChatInvites | messages.DeleteExportedChatInvite | messages.GetAdminsWithInvites | messages.GetChatInviteImporters | messages.SetHistoryTTL | messages.CheckHistoryImportPeer | messages.SetChatTheme | messages.GetMessageReadParticipants | messages.GetSearchResultsCalendar | messages.GetSearchResultsPositions | messages.HideChatJoinRequest | messages.HideAllChatJoinRequests | messages.ToggleNoForwards | messages.SaveDefaultSendAs | messages.SendReaction | messages.GetMessagesReactions | messages.GetMessageReactionsList | messages.SetChatAvailableReactions | messages.GetAvailableReactions | messages.SetDefaultReaction | messages.TranslateText | messages.GetUnreadReactions | messages.ReadReactions | messages.SearchSentMedia | messages.GetAttachMenuBots | messages.GetAttachMenuBot | messages.ToggleBotInAttachMenu | messages.RequestWebView | messages.ProlongWebView | messages.RequestSimpleWebView | messages.SendWebViewResultMessage | messages.SendWebViewData | messages.TranscribeAudio | messages.RateTranscribedAudio | messages.GetCustomEmojiDocuments | messages.GetEmojiStickers | messages.GetFeaturedEmojiStickers | messages.ReportReaction | messages.GetTopReactions | messages.GetRecentReactions | messages.ClearRecentReactions | messages.GetExtendedMedia | messages.SetDefaultHistoryTTL | messages.GetDefaultHistoryTTL | messages.SendBotRequestedPeer | messages.GetEmojiGroups | messages.GetEmojiStatusGroups | messages.GetEmojiProfilePhotoGroups | messages.SearchCustomEmoji | messages.TogglePeerTranslations | messages.GetBotApp | messages.RequestAppWebView | messages.SetChatWallPaper | messages.SearchEmojiStickerSets | messages.GetSavedDialogs | messages.GetSavedHistory | messages.DeleteSavedHistory | messages.GetPinnedSavedDialogs | messages.ToggleSavedDialogPin | messages.ReorderPinnedSavedDialogs | messages.GetSavedReactionTags | messages.UpdateSavedReactionTag | messages.GetDefaultTagReactions | messages.GetOutboxReadDate | messages.GetQuickReplies | messages.ReorderQuickReplies | messages.CheckQuickReplyShortcut | messages.EditQuickReplyShortcut | messages.DeleteQuickReplyShortcut | messages.GetQuickReplyMessages | messages.SendQuickReplyMessages | messages.DeleteQuickReplyMessages | messages.ToggleDialogFilterTags | messages.GetMyStickers | messages.GetEmojiStickerGroups | messages.GetAvailableEffects | messages.EditFactCheck | messages.DeleteFactCheck | messages.GetFactCheck | messages.RequestMainWebView | messages.SendPaidReaction | messages.TogglePaidReactionPrivacy | messages.GetPaidReactionPrivacy | messages.ViewSponsoredMessage | messages.ClickSponsoredMessage | messages.ReportSponsoredMessage | messages.GetSponsoredMessages | messages.SavePreparedInlineMessage | messages.GetPreparedInlineMessage | messages.SearchStickers | messages.ReportMessagesDelivery
    | updates.GetState | updates.GetDifference | updates.GetChannelDifference
    | photos.UpdateProfilePhoto | photos.UploadProfilePhoto | photos.DeletePhotos | photos.GetUserPhotos | photos.UploadContactProfilePhoto
    | upload.SaveFilePart | upload.GetFile | upload.SaveBigFilePart | upload.GetWebFile | upload.GetCdnFile | upload.ReuploadCdnFile | upload.GetCdnFileHashes | upload.GetFileHashes
    | help.GetConfig | help.GetNearestDc | help.GetAppUpdate | help.GetInviteText | help.GetSupport | help.SetBotUpdatesStatus | help.GetCdnConfig | help.GetRecentMeUrls | help.GetTermsOfServiceUpdate | help.AcceptTermsOfService | help.GetDeepLinkInfo | help.GetAppConfig | help.SaveAppLog | help.GetPassportConfig | help.GetSupportName | help.GetUserInfo | help.EditUserInfo | help.GetPromoData | help.HidePromoData | help.DismissSuggestion | help.GetCountriesList | help.GetPremiumPromo | help.GetPeerColors | help.GetPeerProfileColors | help.GetTimezonesList
    | channels.ReadHistory | channels.DeleteMessages | channels.ReportSpam | channels.GetMessages | channels.GetParticipants | channels.GetParticipant | channels.GetChannels | channels.GetFullChannel | channels.CreateChannel | channels.EditAdmin | channels.EditTitle | channels.EditPhoto | channels.CheckUsername | channels.UpdateUsername | channels.JoinChannel | channels.LeaveChannel | channels.InviteToChannel | channels.DeleteChannel | channels.ExportMessageLink | channels.ToggleSignatures | channels.GetAdminedPublicChannels | channels.EditBanned | channels.GetAdminLog | channels.SetStickers | channels.ReadMessageContents | channels.DeleteHistory | channels.TogglePreHistoryHidden | channels.GetLeftChannels | channels.GetGroupsForDiscussion | channels.SetDiscussionGroup | channels.EditCreator | channels.EditLocation | channels.ToggleSlowMode | channels.GetInactiveChannels | channels.ConvertToGigagroup | channels.GetSendAs | channels.DeleteParticipantHistory | channels.ToggleJoinToSend | channels.ToggleJoinRequest | channels.ReorderUsernames | channels.ToggleUsername | channels.DeactivateAllUsernames | channels.ToggleForum | channels.CreateForumTopic | channels.GetForumTopics | channels.GetForumTopicsByID | channels.EditForumTopic | channels.UpdatePinnedForumTopic | channels.DeleteTopicHistory | channels.ReorderPinnedForumTopics | channels.ToggleAntiSpam | channels.ReportAntiSpamFalsePositive | channels.ToggleParticipantsHidden | channels.UpdateColor | channels.ToggleViewForumAsMessages | channels.GetChannelRecommendations | channels.UpdateEmojiStatus | channels.SetBoostsToUnblockRestrictions | channels.SetEmojiStickers | channels.RestrictSponsoredMessages | channels.SearchPosts
    | bots.SendCustomRequest | bots.AnswerWebhookJSONQuery | bots.SetBotCommands | bots.ResetBotCommands | bots.GetBotCommands | bots.SetBotMenuButton | bots.GetBotMenuButton | bots.SetBotBroadcastDefaultAdminRights | bots.SetBotGroupDefaultAdminRights | bots.SetBotInfo | bots.GetBotInfo | bots.ReorderUsernames | bots.ToggleUsername | bots.CanSendMessage | bots.AllowSendMessage | bots.InvokeWebViewCustomMethod | bots.GetPopularAppBots | bots.AddPreviewMedia | bots.EditPreviewMedia | bots.DeletePreviewMedia | bots.ReorderPreviewMedias | bots.GetPreviewInfo | bots.GetPreviewMedias | bots.UpdateUserEmojiStatus | bots.ToggleUserEmojiStatusPermission | bots.CheckDownloadFileParams | bots.GetAdminedBots | bots.UpdateStarRefProgram | bots.SetCustomVerification | bots.GetBotRecommendations
    | payments.GetPaymentForm | payments.GetPaymentReceipt | payments.ValidateRequestedInfo | payments.SendPaymentForm | payments.GetSavedInfo | payments.ClearSavedInfo | payments.GetBankCardData | payments.ExportInvoice | payments.AssignAppStoreTransaction | payments.AssignPlayMarketTransaction | payments.CanPurchasePremium | payments.GetPremiumGiftCodeOptions | payments.CheckGiftCode | payments.ApplyGiftCode | payments.GetGiveawayInfo | payments.LaunchPrepaidGiveaway | payments.GetStarsTopupOptions | payments.GetStarsStatus | payments.GetStarsTransactions | payments.SendStarsForm | payments.RefundStarsCharge | payments.GetStarsRevenueStats | payments.GetStarsRevenueWithdrawalUrl | payments.GetStarsRevenueAdsAccountUrl | payments.GetStarsTransactionsByID | payments.GetStarsGiftOptions | payments.GetStarsSubscriptions | payments.ChangeStarsSubscription | payments.FulfillStarsSubscription | payments.GetStarsGiveawayOptions | payments.GetStarGifts | payments.SaveStarGift | payments.ConvertStarGift | payments.BotCancelStarsSubscription | payments.GetConnectedStarRefBots | payments.GetConnectedStarRefBot | payments.GetSuggestedStarRefBots | payments.ConnectStarRefBot | payments.EditConnectedStarRefBot | payments.GetStarGiftUpgradePreview | payments.UpgradeStarGift | payments.TransferStarGift | payments.GetUniqueStarGift | payments.GetSavedStarGifts | payments.GetSavedStarGift | payments.GetStarGiftWithdrawalUrl | payments.ToggleChatStarGiftNotifications
    | stickers.CreateStickerSet | stickers.RemoveStickerFromSet | stickers.ChangeStickerPosition | stickers.AddStickerToSet | stickers.SetStickerSetThumb | stickers.CheckShortName | stickers.SuggestShortName | stickers.ChangeSticker | stickers.RenameStickerSet | stickers.DeleteStickerSet | stickers.ReplaceSticker
    | phone.GetCallConfig | phone.RequestCall | phone.AcceptCall | phone.ConfirmCall | phone.ReceivedCall | phone.DiscardCall | phone.SetCallRating | phone.SaveCallDebug | phone.SendSignalingData | phone.CreateGroupCall | phone.JoinGroupCall | phone.LeaveGroupCall | phone.InviteToGroupCall | phone.DiscardGroupCall | phone.ToggleGroupCallSettings | phone.GetGroupCall | phone.GetGroupParticipants | phone.CheckGroupCall | phone.ToggleGroupCallRecord | phone.EditGroupCallParticipant | phone.EditGroupCallTitle | phone.GetGroupCallJoinAs | phone.ExportGroupCallInvite | phone.ToggleGroupCallStartSubscription | phone.StartScheduledGroupCall | phone.SaveDefaultGroupCallJoinAs | phone.JoinGroupCallPresentation | phone.LeaveGroupCallPresentation | phone.GetGroupCallStreamChannels | phone.GetGroupCallStreamRtmpUrl | phone.SaveCallLog | phone.CreateConferenceCall
    | langpack.GetLangPack | langpack.GetStrings | langpack.GetDifference | langpack.GetLanguages | langpack.GetLanguage
    | folders.EditPeerFolders
    | stats.GetBroadcastStats | stats.LoadAsyncGraph | stats.GetMegagroupStats | stats.GetMessagePublicForwards | stats.GetMessageStats | stats.GetStoryStats | stats.GetStoryPublicForwards | stats.GetBroadcastRevenueStats | stats.GetBroadcastRevenueWithdrawalUrl | stats.GetBroadcastRevenueTransactions
    | chatlists.ExportChatlistInvite | chatlists.DeleteExportedInvite | chatlists.EditExportedInvite | chatlists.GetExportedInvites | chatlists.CheckChatlistInvite | chatlists.JoinChatlistInvite | chatlists.GetChatlistUpdates | chatlists.JoinChatlistUpdates | chatlists.HideChatlistUpdates | chatlists.GetLeaveChatlistSuggestions | chatlists.LeaveChatlist
    | stories.CanSendStory | stories.SendStory | stories.EditStory | stories.DeleteStories | stories.TogglePinned | stories.GetAllStories | stories.GetPinnedStories | stories.GetStoriesArchive | stories.GetStoriesByID | stories.ToggleAllStoriesHidden | stories.ReadStories | stories.IncrementStoryViews | stories.GetStoryViewsList | stories.GetStoriesViews | stories.ExportStoryLink | stories.Report | stories.ActivateStealthMode | stories.SendReaction | stories.GetPeerStories | stories.GetAllReadPeerStories | stories.GetPeerMaxIDs | stories.GetChatsToSend | stories.TogglePeerStoriesHidden | stories.GetStoryReactionsList | stories.TogglePinnedToTop | stories.SearchPosts
    | premium.GetBoostsList | premium.GetMyBoosts | premium.ApplyBoost | premium.GetBoostsStatus | premium.GetUserBoosts
    | smsjobs.IsEligibleToJoin | smsjobs.Join | smsjobs.Leave | smsjobs.UpdateSettings | smsjobs.GetStatus | smsjobs.GetSmsJob | smsjobs.FinishJob
    | fragment.GetCollectibleInfo;
}
