/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.TutorialTrigger;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/tilegroups/StatusTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "city", "Lcom/unciv/logic/city/City;", "iconSize", "", "<init>", "(Lcom/unciv/logic/city/City;F)V", "core"})
final class StatusTable
extends Table {
    public StatusTable(@NotNull City city, float iconSize) {
        Intrinsics.checkNotNullParameter(city, "city");
        float padBetween = 2.0f;
        Civilization selectedCiv = GUI.INSTANCE.getSelectedPlayer();
        if (Intrinsics.areEqual(city.getCiv(), selectedCiv)) {
            Image connectionImage;
            if (city.isBlockaded()) {
                connectionImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Blockade", null, 2, null);
                this.add((Actor)connectionImage).size(iconSize);
                BaseScreen.displayTutorial$default(GUI.INSTANCE.getWorldScreen(), TutorialTrigger.CityBlockade, null, 2, null);
            } else if (!city.isCapital() && city.isConnectedToCapital()) {
                connectionImage = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "CityConnection", 0.0f, 2, null);
                this.add((Actor)connectionImage).size(iconSize);
            }
        }
        if (city.isInResistance()) {
            Image resistanceImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "StatIcons/Resistance", null, 2, null);
            this.add((Actor)resistanceImage).size(iconSize).padLeft(padBetween);
        }
        if (city.isPuppet()) {
            Image puppetImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Puppet", null, 2, null);
            this.add((Actor)puppetImage).size(iconSize).padLeft(padBetween);
        }
        if (city.isBeingRazed()) {
            Image fireImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Fire", null, 2, null);
            this.add((Actor)fireImage).size(iconSize).padLeft(padBetween);
        }
        if (Intrinsics.areEqual(city.getCiv(), selectedCiv) && city.isWeLoveTheKingDayActive()) {
            Image wltkdImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/WLTKD", null, 2, null);
            this.add((Actor)wltkdImage).size(iconSize).padLeft(padBetween);
        }
    }

    public /* synthetic */ StatusTable(City city, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 18.0f;
        }
        this(city, f);
    }
}

