/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.utils.DebugUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo;", "", "<init>", "()V", "shouldBeDisplayed", "", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "wonder", "Lcom/unciv/models/ruleset/Building;", "wonderEra", "", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/models/ruleset/Building;Ljava/lang/Integer;)Z", "knownFromQuest", "name", "", "collectInfo", "", "Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "(Lcom/unciv/logic/civilization/Civilization;)[Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "WonderStatus", "WonderInfo", "core"})
@SourceDebugExtension(value={"SMAP\nWonderOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WonderOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/WonderInfo\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n666#2:262\n747#2,4:263\n666#2:267\n747#2,4:268\n682#2:276\n712#2,4:277\n608#2:287\n126#3:272\n153#3,3:273\n1193#4,2:281\n1267#4,4:283\n*S KotlinDebug\n*F\n+ 1 WonderOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/WonderInfo\n*L\n168#1:262\n168#1:263,4\n177#1:267\n177#1:268,4\n187#1:276\n187#1:277,4\n250#1:287\n181#1:272\n181#1:273,3\n194#1:281,2\n194#1:283,4\n*E\n"})
public final class WonderInfo {
    private final boolean shouldBeDisplayed(Civilization viewingPlayer, Building wonder, Integer wonderEra) {
        return !IHasUniques.isHiddenFromCivilopedia$default(wonder, viewingPlayer.getGameInfo(), null, 2, null) && (wonderEra == null || wonderEra <= viewingPlayer.getEraNumber());
    }

    private final boolean knownFromQuest(Civilization viewingPlayer, String name) {
        Iterator<Civilization> iterator2 = viewingPlayer.getGameInfo().getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Iterator<AssignedQuest> iterator4 = civ.getQuestManager().getAssignedQuestsFor(viewingPlayer).iterator();
            while (iterator4.hasNext()) {
                AssignedQuest quest = iterator4.next();
                if (!Intrinsics.areEqual(quest.getQuestName(), QuestName.FindNaturalWonder.getValue()) || !Intrinsics.areEqual(quest.getData1(), name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WonderInfo[] collectInfo(@NotNull Civilization viewingPlayer) {
        WonderStatus status;
        Sequence<City> it;
        Object object;
        WonderInfo[] $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object2;
        void $this$mapTo$iv$iv;
        void $this$associateTo$iv$iv2;
        void $this$associate$iv2;
        void $this$associateTo$iv$iv3;
        void $this$associate$iv3;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Collator collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        Ruleset ruleset = viewingPlayer.getGameInfo().getRuleset();
        Collection<Building> collection = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence<Building> sequence = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), WonderInfo::collectInfo$lambda$0);
        boolean $i$f$associate232 = false;
        void var7_8 = $this$associate$iv3;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv3) {
            Map map2 = destination$iv$iv;
            Building building = (Building)element$iv$iv;
            boolean bl = false;
            Pair<String, Era> pair = TuplesKt.to(building.getName(), building.era(ruleset));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map wonderEraMap = destination$iv$iv;
        Collection<Building> collection2 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Object $i$f$associate232 = new Comparator(wonderEraMap){
            final /* synthetic */ Map $wonderEraMap$inlined;
            {
                this.$wonderEraMap$inlined = map2;
            }

            public final int compare(T a, T b) {
                Building it = (Building)a;
                boolean bl = false;
                Era era = (Era)this.$wonderEraMap$inlined.get(it.getName());
                it = (Building)b;
                Comparable comparable = era != null ? (Comparable)Integer.valueOf(era.getEraNumber()) : (Comparable)Integer.valueOf(100);
                bl = false;
                Era era2 = (Era)this.$wonderEraMap$inlined.get(it.getName());
                return ComparisonsKt.compareValues(comparable, era2 != null ? (Comparable)Integer.valueOf(era2.getEraNumber()) : (Comparable)Integer.valueOf(100));
            }
        };
        $i$f$associate232 = SequencesKt.withIndex(SequencesKt.sortedWith(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), WonderInfo::collectInfo$lambda$2), new Comparator((Comparator)$i$f$associate232, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Building building = (Building)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Building it = (Building)b;
                    String string = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }));
        boolean $i$f$associate = false;
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateTo232 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map2 = destination$iv$iv2;
            Object it3 = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it3 = TuplesKt.to(((IndexedValue)it3).getIndex(), ((Building)((IndexedValue)it3).getValue()).getName());
            map2.put(((Pair)it3).getFirst(), ((Pair)it3).getSecond());
        }
        Map allWonderMap = destination$iv$iv2;
        int wonderCount = allWonderMap.size();
        Map $this$map$iv = allWonderMap;
        boolean $i$f$map232 = false;
        Map $i$f$associateTo232 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator entry = $this$mapTo$iv$iv.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = entry.next();
            object2 = destination$iv$iv3;
            boolean bl2 = false;
            object2.add(TuplesKt.to(entry2.getValue(), entry2.getKey()));
        }
        Map wonderIndexMap = MapsKt.toMap((List)destination$iv$iv3);
        Sequence<Tile> $i$f$map232 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)viewingPlayer.getGameInfo().getTileMap().getValues()), WonderInfo::collectInfo$lambda$7);
        boolean $i$f$associateBy = false;
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv4 = new LinkedHashMap();
        boolean bl = false;
        for (Object t : $this$associateByTo$iv$iv) {
            void it5;
            Tile bl2 = (Tile)t;
            object2 = destination$iv$iv4;
            boolean bl3 = false;
            String string = it5.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            object2.put(string, t);
        }
        Map allNaturalsMap = destination$iv$iv4;
        int naturalsCount = allNaturalsMap.size();
        $this$associateByTo$iv$iv = CollectionsKt.withIndex(CollectionsKt.sortedWith(allNaturalsMap.keySet(), new Comparator(collator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                String string = (String)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                String it = (String)b;
                String string2 = TranslationsKt.tr$default(it, false, false, 3, null);
                bl = false;
                String string3 = TranslationsKt.tr$default(it, false, false, 3, null);
                return comparator.compare(string2, string3);
            }
        }));
        boolean $i$f$associate3 = false;
        int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterator item$iv$iv = $this$associate$iv;
        Map map3 = new LinkedHashMap(n);
        boolean $i$f$associateTo3 = false;
        Iterator bl3 = $this$associateTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            object = map3;
            it = (IndexedValue)element$iv$iv;
            boolean bl32 = false;
            it = TuplesKt.to(((IndexedValue)((Object)it)).getIndex(), ((IndexedValue)((Object)it)).getValue());
            object.put(((Pair)((Object)it)).getFirst(), ((Pair)((Object)it)).getSecond());
        }
        Map naturalsIndexMap = map3;
        int n2 = wonderCount + naturalsCount;
        $this$associateTo$iv$iv = new WonderInfo[n2];
        for (int i = 0; i < n2; ++i) {
            WonderInfo wonderInfo;
            int n3 = i;
            if (n3 < wonderCount) {
                Object object3;
                Building wonder;
                Era era;
                LinkedHashMap<String, Building> linkedHashMap = ruleset.getBuildings();
                Object v = allWonderMap.get(n3);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNull(linkedHashMap.get(v));
                Era era2 = era = (Era)wonderEraMap.get(wonder.getName());
                status = this.shouldBeDisplayed(viewingPlayer, wonder, era2 != null ? Integer.valueOf(era2.getEraNumber()) : null) ? WonderStatus.Unbuilt : WonderStatus.Hidden;
                Object v2 = allWonderMap.get(n3);
                Intrinsics.checkNotNull(v2);
                String string = (String)v2;
                Object object4 = era;
                if (object4 == null || (object4 = ((RulesetObject)object4).getName()) == null) {
                    object4 = "Other";
                }
                if ((object3 = era) == null || (object3 = ((Era)object3).getColor()) == null) {
                    object3 = Color.WHITE;
                }
                object = object3;
                Intrinsics.checkNotNull(object);
                wonderInfo = new WonderInfo(string, CivilopediaCategories.Wonder, (String)object4, (Color)object, status, null, null, null);
            } else {
                Object v = naturalsIndexMap.get(n3 - wonderCount);
                Intrinsics.checkNotNull(v);
                String string = (String)v;
                Color color = Color.FOREST;
                Intrinsics.checkNotNullExpressionValue(color, "FOREST");
                wonderInfo = new WonderInfo(string, CivilopediaCategories.Terrain, "Natural Wonders", color, WonderStatus.Unknown, null, null, null);
            }
            $this$associateTo$iv$iv[n3] = wonderInfo;
        }
        WonderInfo[] wonders = $this$associateTo$iv$iv;
        Iterator<Object> iterator2 = viewingPlayer.getGameInfo().getCities().iterator();
        while (iterator2.hasNext()) {
            City city = iterator2.next();
            for (String string : CollectionsKt.intersect((Iterable)SequencesKt.toList(SequencesKt.map(city.getCityConstructions().getBuiltBuildings(), WonderInfo::collectInfo$lambda$11)), wonderIndexMap.keySet())) {
                Object v = wonderIndexMap.get(string);
                Intrinsics.checkNotNull(v);
                int index = ((Number)v).intValue();
                WonderStatus status2 = Intrinsics.areEqual(viewingPlayer, city.getCiv()) ? WonderStatus.Owned : (viewingPlayer.hasExplored(city.getCenterTile()) ? WonderStatus.Known : WonderStatus.NotFound);
                wonders[index] = new WonderInfo(string, CivilopediaCategories.Wonder, wonders[index].getGroupName(), wonders[index].getGroupColor(), status2, city.getCiv(), city, city.getCenterTile());
            }
        }
        for (Map.Entry entry3 : naturalsIndexMap.entrySet()) {
            City city;
            int index = ((Number)entry3.getKey()).intValue();
            String string = (String)entry3.getValue();
            Object v = allNaturalsMap.get(string);
            Intrinsics.checkNotNull(v);
            Tile tile = (Tile)v;
            Civilization civ = tile.getOwner();
            WonderStatus wonderStatus = Intrinsics.areEqual(civ, viewingPlayer) ? WonderStatus.Owned : (status = viewingPlayer.getNaturalWonders().contains(string) ? WonderStatus.Known : WonderStatus.NotFound);
            if (status == WonderStatus.NotFound && !this.knownFromQuest(viewingPlayer, string)) continue;
            if (status == WonderStatus.NotFound) {
                city = null;
            } else {
                void $this$sortedBy$iv;
                it = SequencesKt.filter(viewingPlayer.getGameInfo().getCities(), arg_0 -> WonderInfo.collectInfo$lambda$12(tile, viewingPlayer, arg_0));
                boolean $i$f$sortedBy = false;
                city = (City)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(tile){
                    final /* synthetic */ Tile $tile$inlined;
                    {
                        this.$tile$inlined = tile;
                    }

                    public final int compare(T a, T b) {
                        City it = (City)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$tile$inlined));
                        it = (City)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$tile$inlined));
                    }
                }));
            }
            City city2 = city;
            Color color = Color.FOREST;
            Intrinsics.checkNotNullExpressionValue(color, "FOREST");
            wonders[index + wonderCount] = new WonderInfo(string, CivilopediaCategories.Terrain, "Natural Wonders", color, status, civ, city2, tile);
        }
        return wonders;
    }

    private static final boolean collectInfo$lambda$0(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isWonder();
    }

    private static final boolean collectInfo$lambda$2(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isWonder();
    }

    private static final boolean collectInfo$lambda$7(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isNaturalWonder();
    }

    private static final String collectInfo$lambda$11(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final boolean collectInfo$lambda$12(Tile $tile, Civilization $viewingPlayer, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().aerialDistanceTo($tile) <= 5 && $viewingPlayer.knows(it.getCiv()) && $viewingPlayer.hasExplored(it.getCenterTile());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010$\u001a\u0004\u0018\u00010%J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "", "name", "", "category", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "groupName", "groupColor", "Lcom/badlogic/gdx/graphics/Color;", "status", "Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "location", "Lcom/unciv/logic/map/tile/Tile;", "<init>", "(Ljava/lang/String;Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;Ljava/lang/String;Lcom/badlogic/gdx/graphics/Color;Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;)V", "getName", "()Ljava/lang/String;", "getCategory", "()Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "getGroupName", "getGroupColor", "()Lcom/badlogic/gdx/graphics/Color;", "getStatus", "()Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "getCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getCity", "()Lcom/unciv/logic/city/City;", "getLocation", "()Lcom/unciv/logic/map/tile/Tile;", "viewEntireMapForDebug", "", "getImage", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getNameColumn", "getStatusColumn", "getLocationColumn", "makeLink", "core"})
    public static final class WonderInfo {
        @NotNull
        private final String name;
        @NotNull
        private final CivilopediaCategories category;
        @NotNull
        private final String groupName;
        @NotNull
        private final Color groupColor;
        @NotNull
        private final WonderStatus status;
        @Nullable
        private final Civilization civ;
        @Nullable
        private final City city;
        @Nullable
        private final Tile location;
        private final boolean viewEntireMapForDebug;

        public WonderInfo(@NotNull String name, @NotNull CivilopediaCategories category, @NotNull String groupName, @NotNull Color groupColor, @NotNull WonderStatus status, @Nullable Civilization civ, @Nullable City city, @Nullable Tile location) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter((Object)category, "category");
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Intrinsics.checkNotNullParameter(groupColor, "groupColor");
            Intrinsics.checkNotNullParameter((Object)status, "status");
            this.name = name;
            this.category = category;
            this.groupName = groupName;
            this.groupColor = groupColor;
            this.status = status;
            this.civ = civ;
            this.city = city;
            this.location = location;
            this.viewEntireMapForDebug = DebugUtils.INSTANCE.getVISIBLE_MAP();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final CivilopediaCategories getCategory() {
            return this.category;
        }

        @NotNull
        public final String getGroupName() {
            return this.groupName;
        }

        @NotNull
        public final Color getGroupColor() {
            return this.groupColor;
        }

        @NotNull
        public final WonderStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final Civilization getCiv() {
            return this.civ;
        }

        @Nullable
        public final City getCity() {
            return this.city;
        }

        @Nullable
        public final Tile getLocation() {
            return this.location;
        }

        @Nullable
        public final Actor getImage() {
            Actor actor;
            if (this.status == WonderStatus.Unknown && !this.viewEntireMapForDebug) {
                actor = null;
            } else {
                Function2<String, Float, Actor> function2 = this.category.getGetImage();
                actor = function2 != null ? function2.invoke(this.name, Float.valueOf(this.category == CivilopediaCategories.Terrain ? 50.0f : 45.0f)) : null;
            }
            return actor;
        }

        @NotNull
        public final String getNameColumn() {
            return this.viewEntireMapForDebug ? this.name : (this.status == WonderStatus.Unknown ? this.status.getLabel() : this.name);
        }

        @NotNull
        public final String getStatusColumn() {
            return this.status != WonderStatus.Known ? this.status.getLabel() : (this.civ == null ? this.status.getLabel() : this.civ.getCivName());
        }

        @NotNull
        public final String getLocationColumn() {
            String string;
            if (this.status.compareTo((Enum)WonderStatus.NotFound) <= 0) {
                string = "";
            } else if (this.location == null) {
                string = "";
            } else if (this.location.isCityCenter()) {
                City city = this.location.getCity();
                Intrinsics.checkNotNull(city);
                string = city.getName();
            } else if (this.location.getCity() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Near [");
                City city = this.location.getCity();
                Intrinsics.checkNotNull(city);
                string = stringBuilder.append(city).append(']').toString();
            } else {
                string = this.city != null ? "Somewhere around [" + this.city + ']' : (this.viewEntireMapForDebug ? this.location.getPosition().toString() : "Far away");
            }
            return string;
        }

        @NotNull
        public final String makeLink() {
            return this.category.name() + '/' + this.name;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "", "label", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "Hidden", "Unknown", "Unbuilt", "NotFound", "Known", "Owned", "core"})
    public static final class WonderStatus
    extends Enum<WonderStatus> {
        @NotNull
        private final String label;
        public static final /* enum */ WonderStatus Hidden = new WonderStatus("");
        public static final /* enum */ WonderStatus Unknown = new WonderStatus("Unknown");
        public static final /* enum */ WonderStatus Unbuilt = new WonderStatus("Not built");
        public static final /* enum */ WonderStatus NotFound = new WonderStatus("Not found");
        public static final /* enum */ WonderStatus Known = new WonderStatus("Known");
        public static final /* enum */ WonderStatus Owned = new WonderStatus("Owned");
        private static final /* synthetic */ WonderStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private WonderStatus(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static WonderStatus[] values() {
            return (WonderStatus[])$VALUES.clone();
        }

        public static WonderStatus valueOf(String value) {
            return Enum.valueOf(WonderStatus.class, value);
        }

        @NotNull
        public static EnumEntries<WonderStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = wonderStatusArray = new WonderStatus[]{WonderStatus.Hidden, WonderStatus.Unknown, WonderStatus.Unbuilt, WonderStatus.NotFound, WonderStatus.Known, WonderStatus.Owned};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

