/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.utils;

import com.unciv.utils.Log;
import com.unciv.utils.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001aU\u0010\r\u001a\u00020\u00012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0003\u001a\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a)\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\b\u0010\u0016\u001a\u00020\tH\u0003\u001a\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0003\"\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"debug", "", "msg", "", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "tag", "Lcom/unciv/utils/Tag;", "(Lcom/unciv/utils/Tag;Ljava/lang/String;[Ljava/lang/Object;)V", "throwable", "", "doLog", "logger", "Lkotlin/Function3;", "(Lkotlin/jvm/functions/Function3;Lcom/unciv/utils/Tag;Ljava/lang/String;[Ljava/lang/Object;)V", "isTagDisabled", "", "buildThrowableMessage", "replaceLambdasWithValues", "([Ljava/lang/Object;)[Ljava/lang/Object;", "getTag", "ANONYMOUS_CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "removeAnonymousSuffix", "core"})
@SourceDebugExtension(value={"SMAP\nLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Log.kt\ncom/unciv/utils/LogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,259:1\n1761#2,3:260\n2746#2,3:263\n1227#3,2:266\n*S KotlinDebug\n*F\n+ 1 Log.kt\ncom/unciv/utils/LogKt\n*L\n220#1:260,3\n221#1:263,3\n244#1:266,2\n*E\n"})
public final class LogKt {
    private static final Pattern ANONYMOUS_CLASS_PATTERN = Pattern.compile("(\\$\\d+)+$");

    public static final void debug(@NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        Log.INSTANCE.debug(msg, Arrays.copyOf(params, params.length));
    }

    public static final void debug(@NotNull Tag tag, @NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        Log.INSTANCE.debug(tag, msg, Arrays.copyOf(params, params.length));
    }

    public static final void debug(@NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        Log.INSTANCE.debug(msg, throwable);
    }

    public static final void debug(@NotNull Tag tag, @NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        Log.INSTANCE.debug(tag, msg, throwable);
    }

    private static final void doLog(Function3<? super Tag, ? super String, ? super String, Unit> logger, Tag tag, String msg, Object ... params) {
        String string;
        if (params.length == 0) {
            string = msg;
        } else {
            Object[] objectArray = Arrays.copyOf(params, params.length);
            String string2 = String.format(msg, Arrays.copyOf(objectArray, objectArray.length));
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        }
        String formattedMessage = string;
        String string3 = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        logger.invoke(tag, string3, formattedMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Pure
    private static final boolean isTagDisabled(Tag tag) {
        String it;
        boolean bl;
        Iterable $this$any$iv = Log.INSTANCE.getDisableLogsFrom();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)tag.getName(), it, false, 2, null)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (((Collection)Log.INSTANCE.getEnableLogsFrom()).isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$none$iv = Log.INSTANCE.getEnableLogsFrom();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl4 = false;
        } while (!StringsKt.contains$default((CharSequence)tag.getName(), it, false, 2, null));
        return false;
    }

    private static final String buildThrowableMessage(String msg, Throwable throwable) {
        return msg + " | " + ExceptionsKt.stackTraceToString(throwable);
    }

    private static final Object[] replaceLambdasWithValues(Object[] params) {
        Object[] out = null;
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            Object param = params[i];
            if (!TypeIntrinsics.isFunctionOfArity(param, 0)) continue;
            if (out == null) {
                out = Arrays.copyOf(params, params.length);
            }
            out[i] = ((Function0)param).invoke();
        }
        Object[] objectArray = out;
        if (out == null) {
            objectArray = params;
        }
        return objectArray;
    }

    @Readonly
    private static final Tag getTag() {
        Object element$iv2;
        block2: {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
            Object[] $this$first$iv = stackTraceElementArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                StackTraceElement it = (StackTraceElement)element$iv2;
                boolean bl = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
                if (!(!StringsKt.contains$default((CharSequence)string, "com.unciv.utils.Log", false, 2, null))) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        StackTraceElement firstOutsideStacktrace = (StackTraceElement)element$iv2;
        String string = firstOutsideStacktrace.getClassName();
        Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
        String simpleClassName = StringsKt.substringAfterLast$default(string, '.', null, 2, null);
        return new Tag(LogKt.removeAnonymousSuffix(simpleClassName));
    }

    @Pure
    private static final String removeAnonymousSuffix(String tag) {
        String string;
        Matcher matcher = ANONYMOUS_CLASS_PATTERN.matcher(tag);
        if (matcher.find()) {
            String string2 = matcher.replaceAll("");
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            string = tag;
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isTagDisabled(Tag tag) {
        return LogKt.isTagDisabled(tag);
    }

    public static final /* synthetic */ Tag access$getTag() {
        return LogKt.getTag();
    }

    public static final /* synthetic */ Object[] access$replaceLambdasWithValues(Object[] params) {
        return LogKt.replaceLambdasWithValues(params);
    }

    public static final /* synthetic */ void access$doLog(Function3 logger, Tag tag, String msg, Object ... params) {
        LogKt.doLog(logger, tag, msg, params);
    }

    public static final /* synthetic */ String access$buildThrowableMessage(String msg, Throwable throwable) {
        return LogKt.buildThrowableMessage(msg, throwable);
    }
}

