/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.general.ContinuousTestingEntropySource;
import org.bouncycastle.crypto.general.ContinuousTestingPseudoRNG;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralSecureRandom;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.X931PseudoRandom;
import org.bouncycastle.crypto.general.X931RNG;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class X931PRNG {
    public static final Base Triple_DES_168 = new Base(new GeneralAlgorithm("TRIPLEDES", (Enum)Variations.Triple_DES_168));
    public static final Base AES_128 = new Base(new GeneralAlgorithm("AES-128", (Enum)Variations.AES_128));
    public static final Base AES_192 = new Base(new GeneralAlgorithm("AES-192", (Enum)Variations.AES_192));
    public static final Base AES_256 = new Base(new GeneralAlgorithm("AES-256", (Enum)Variations.AES_256));

    private X931PRNG() {
    }

    public static class Base
    implements Parameters {
        private final GeneralAlgorithm algorithm;

        private Base(GeneralAlgorithm generalAlgorithm) {
            this.algorithm = generalAlgorithm;
        }

        public Builder fromDefaultEntropy() {
            SecureRandom secureRandom = new SecureRandom();
            return new Builder(this.algorithm, secureRandom, new BasicEntropySourceProvider(secureRandom, false), null);
        }

        public Builder fromEntropySource(SecureRandom secureRandom, boolean bl) {
            return new Builder(this.algorithm, secureRandom, new BasicEntropySourceProvider(secureRandom, bl), null);
        }

        public Builder fromEntropySource(EntropySourceProvider entropySourceProvider) {
            return new Builder(this.algorithm, null, entropySourceProvider, null);
        }

        @Override
        public Algorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class Builder {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;
        private final EntropySourceProvider entropySourceProvider;
        private byte[] dateTimeVector;

        Builder(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom, EntropySourceProvider entropySourceProvider, byte[] byArray) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
            this.entropySourceProvider = entropySourceProvider;
            this.dateTimeVector = byArray;
        }

        public Builder setDateTimeVector(byte[] byArray) {
            this.dateTimeVector = Arrays.clone(byArray);
            return this;
        }

        public GeneralSecureRandom build(SymmetricKey symmetricKey, boolean bl) {
            byte[] byArray;
            int n;
            BlockCipher blockCipher;
            switch ((Variations)this.algorithm.basicVariation()) {
                case AES_128: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n = 128;
                    break;
                }
                case AES_192: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n = 192;
                    break;
                }
                case AES_256: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    n = 256;
                    break;
                }
                case Triple_DES_168: {
                    blockCipher = (BlockCipher)FipsRegister.getProvider(FipsTripleDES.ALGORITHM).createEngine();
                    n = 192;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to build(): " + this.algorithm.getName());
                }
            }
            byte[] byArray2 = this.dateTimeVector;
            if (byArray2 == null) {
                byArray2 = new byte[blockCipher.getBlockSize()];
                Pack.longToBigEndian(System.currentTimeMillis(), byArray2, 0);
            }
            if (n != (byArray = PrivilegedUtils.getKeyBytes(symmetricKey)).length * 8) {
                throw new IllegalKeyException("FIPS key not correct length - should be " + byArray.length + " bytes long.");
            }
            blockCipher.init(true, new KeyParameterImpl(byArray));
            ContinuousTestingEntropySource continuousTestingEntropySource = new ContinuousTestingEntropySource(this.entropySourceProvider.get(blockCipher.getBlockSize() * 8));
            return new GeneralSecureRandom(this.random, this.getAlgorithmName(blockCipher, n), new ContinuousTestingPseudoRNG(new X931PseudoRandom(new X931RNG(blockCipher, byArray2, continuousTestingEntropySource)), null), continuousTestingEntropySource, bl);
        }

        String getAlgorithmName(BlockCipher blockCipher, int n) {
            if (blockCipher.getAlgorithmName().equals("AES")) {
                return "X9.31-PRNG-" + blockCipher.getAlgorithmName() + n;
            }
            return "X9.31-PRNG-3KEY-TDES";
        }
    }

    private static enum Variations {
        Triple_DES_168,
        AES_128,
        AES_192,
        AES_256;

    }
}

