/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class DaemonRegistryUnavailableExpirationStrategy
implements DaemonExpirationStrategy {
    private static final Logger LOG = Logging.getLogger(DaemonRegistryUnavailableExpirationStrategy.class);
    public static final String REGISTRY_BECAME_UNREADABLE = "after the daemon registry became unreadable";
    public static final String REGISTRY_ENTRY_UNEXPECTEDLY_LOST = "after the daemon was no longer found in the daemon registry";
    public static final String REGISTRY_BECAME_INACCESSIBLE = "after the daemon registry became inaccessible";
    private final Daemon daemon;
    private long lastModified = -1L;

    public DaemonRegistryUnavailableExpirationStrategy(Daemon daemon) {
        this.daemon = daemon;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        try {
            DaemonContext daemonContext = this.daemon.getDaemonContext();
            File daemonRegistryDir = daemonContext.getDaemonRegistryDir();
            File registry = new DaemonDir(daemonRegistryDir).getRegistry();
            long newLastModified = registry.lastModified();
            if (this.lastModified != newLastModified) {
                this.lastModified = newLastModified;
                if (!registry.canRead()) {
                    LOG.warn("Daemon registry {} became unreadable. Expiring daemon.", (Object)daemonRegistryDir);
                    return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, REGISTRY_BECAME_UNREADABLE);
                }
                List allDaemonPids = Lists.transform((List)this.daemon.getDaemonRegistry().getAll(), (Function)new Function<DaemonInfo, Long>(){

                    public Long apply(DaemonInfo info) {
                        return info.getPid();
                    }
                });
                if (!allDaemonPids.contains(daemonContext.getPid())) {
                    return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, REGISTRY_ENTRY_UNEXPECTEDLY_LOST);
                }
            }
        }
        catch (SecurityException se) {
            LOG.warn("Daemon registry became inaccessible. Expiring daemon. Error message is '{}'", (Object)se.getMessage());
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, REGISTRY_BECAME_INACCESSIBLE);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

