/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.auth;

import io.swagger.models.auth.AbstractSecuritySchemeDefinition;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuth2Definition
extends AbstractSecuritySchemeDefinition {
    private String type = "oauth2";
    private String authorizationUrl;
    private String tokenUrl;
    private String flow;
    private Map<String, String> scopes;

    public OAuth2Definition implicit(String authorizationUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        this.setFlow("implicit");
        return this;
    }

    public OAuth2Definition password(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("password");
        return this;
    }

    public OAuth2Definition application(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("application");
        return this;
    }

    public OAuth2Definition accessCode(String authorizationUrl, String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setAuthorizationUrl(authorizationUrl);
        this.setFlow("accessCode");
        return this;
    }

    public OAuth2Definition scope(String name, String description) {
        this.addScope(name, description);
        return this;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
    }

    public void addScope(String name, String description) {
        if (this.scopes == null) {
            this.scopes = new LinkedHashMap<String, String>();
        }
        this.scopes.put(name, description);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.authorizationUrl == null ? 0 : this.authorizationUrl.hashCode());
        result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = 31 * result + (this.tokenUrl == null ? 0 : this.tokenUrl.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2Definition other = (OAuth2Definition)obj;
        if (this.authorizationUrl == null ? other.authorizationUrl != null : !this.authorizationUrl.equals(other.authorizationUrl)) {
            return false;
        }
        if (this.flow == null ? other.flow != null : !this.flow.equals(other.flow)) {
            return false;
        }
        if (this.scopes == null ? other.scopes != null : !this.scopes.equals(other.scopes)) {
            return false;
        }
        if (this.tokenUrl == null ? other.tokenUrl != null : !this.tokenUrl.equals(other.tokenUrl)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

