/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoSettingsNode
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoSettingsNode> {
    @Nonnull
    private final Map<String, JsonData> attr;
    @Nullable
    private final String maxLocalStorageNodes;
    @Nonnull
    private final String name;
    public static final JsonpDeserializer<NodeInfoSettingsNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsNode::setupNodeInfoSettingsNodeDeserializer);

    private NodeInfoSettingsNode(Builder builder) {
        this.attr = ApiTypeHelper.unmodifiable(builder.attr);
        this.maxLocalStorageNodes = builder.maxLocalStorageNodes;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static NodeInfoSettingsNode of(Function<Builder, ObjectBuilder<NodeInfoSettingsNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> attr() {
        return this.attr;
    }

    @Nullable
    public final String maxLocalStorageNodes() {
        return this.maxLocalStorageNodes;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attr)) {
            generator.writeKey("attr");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.attr.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxLocalStorageNodes != null) {
            generator.writeKey("max_local_storage_nodes");
            generator.write(this.maxLocalStorageNodes);
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoSettingsNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attr, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "attr");
        op.add(Builder::maxLocalStorageNodes, JsonpDeserializer.stringDeserializer(), "max_local_storage_nodes");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.attr);
        result = 31 * result + Objects.hashCode(this.maxLocalStorageNodes);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoSettingsNode other = (NodeInfoSettingsNode)o;
        return Objects.equals(this.attr, other.attr) && Objects.equals(this.maxLocalStorageNodes, other.maxLocalStorageNodes) && this.name.equals(other.name);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoSettingsNode> {
        @Nullable
        private Map<String, JsonData> attr;
        @Nullable
        private String maxLocalStorageNodes;
        private String name;

        public Builder() {
        }

        private Builder(NodeInfoSettingsNode o) {
            this.attr = Builder._mapCopy(o.attr);
            this.maxLocalStorageNodes = o.maxLocalStorageNodes;
            this.name = o.name;
        }

        private Builder(Builder o) {
            this.attr = Builder._mapCopy(o.attr);
            this.maxLocalStorageNodes = o.maxLocalStorageNodes;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder attr(Map<String, JsonData> map) {
            this.attr = Builder._mapPutAll(this.attr, map);
            return this;
        }

        @Nonnull
        public final Builder attr(String key, JsonData value) {
            this.attr = Builder._mapPut(this.attr, key, value);
            return this;
        }

        @Nonnull
        public final Builder maxLocalStorageNodes(@Nullable String value) {
            this.maxLocalStorageNodes = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeInfoSettingsNode build() {
            this._checkSingleUse();
            return new NodeInfoSettingsNode(this);
        }
    }
}

