/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.TransactionContext;
import org.jooq.TransactionListener;
import org.jooq.TransactionListenerProvider;

class TransactionListeners
implements TransactionListener {
    private final TransactionListener[] listeners;

    TransactionListeners(Configuration configuration) {
        TransactionListenerProvider[] providers = configuration.transactionListenerProviders();
        this.listeners = new TransactionListener[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            this.listeners[i] = providers[i].provide();
        }
    }

    @Override
    public final void beginStart(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.beginStart(ctx);
        }
    }

    @Override
    public final void beginEnd(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.beginEnd(ctx);
        }
    }

    @Override
    public final void commitStart(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.commitStart(ctx);
        }
    }

    @Override
    public final void commitEnd(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.commitEnd(ctx);
        }
    }

    @Override
    public final void rollbackStart(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.rollbackStart(ctx);
        }
    }

    @Override
    public final void rollbackEnd(TransactionContext ctx) {
        for (TransactionListener listener : this.listeners) {
            listener.rollbackEnd(ctx);
        }
    }
}

