/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;

public class LifeEventTile
extends AbstractTile {
    private final LifeEvent lifeEvent;
    private final TileArguments tileArguments;
    private final LivingSpace livingSpace;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final YGauge yGauge;

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
        this.livingSpace.addStepForLivebox(this.getEvent(), y.getValue());
    }

    @Override
    public Event getEvent() {
        return this.lifeEvent;
    }

    @Override
    public double getContactPointRelative() {
        return 0.0;
    }

    public LifeEventTile(LifeEvent lifeEvent, TileArguments tileArguments, LivingSpace livingSpace, Rose skin, ISkinParam skinParam, YGauge currentY) {
        super(tileArguments.getStringBounder(), currentY);
        this.lifeEvent = lifeEvent;
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.skin = skin;
        this.skinParam = skinParam;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    private StyleSignature getStyleSignature() {
        return ComponentType.DESTROY.getStyleSignature();
    }

    private Style[] getUsedStyle() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return new Style[]{style};
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.isDestroyWithoutMessage()) {
            Component cross = this.skin.createComponent(this.getUsedStyle(), ComponentType.DESTROY, null, this.skinParam, null);
            XDimension2D dimCross = cross.getPreferredDimension(ug.getStringBounder());
            double x = this.livingSpace.getPosC(ug.getStringBounder()).getCurrentValue();
            cross.drawU(ug.apply(UTranslate.dx(x - dimCross.getWidth() / 2.0)), null, (Context2D)((Object)ug));
        }
    }

    public boolean isDestroyWithoutMessage() {
        return this.lifeEvent.getMessage() == null && this.lifeEvent.getType() == LifeEventType.DESTROY;
    }

    @Override
    public double getPreferredHeight() {
        if (this.isDestroyWithoutMessage()) {
            Component cross = this.skin.createComponent(this.getUsedStyle(), ComponentType.DESTROY, null, this.skinParam, null);
            XDimension2D dimCross = cross.getPreferredDimension(this.getStringBounder());
            return dimCross.getHeight();
        }
        return 0.0;
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        int levelAt = this.livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_ACTIVATE);
        double liveDeltaWidthAdjustment = levelAt > 0 ? 5.0 : 0.0;
        return this.livingSpace.getPosC(this.getStringBounder()).addFixed(-liveDeltaWidthAdjustment);
    }

    @Override
    public Real getMaxX() {
        int levelAt = this.livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_ACTIVATE);
        double liveDeltaWidthAdjustment = levelAt > 0 ? (double)levelAt * 5.0 : 0.0;
        return this.livingSpace.getPosC(this.getStringBounder()).addFixed(liveDeltaWidthAdjustment);
    }
}

