"""Darwin (macOS) logo"""

from archey.colors import Colors, Colors8Bit

COLORS = [Colors.WHITE_NORMAL]

LOGO = [
    """{c[0]}                     c.'       """,
    """{c[0]}                  ,xNMM.       """,
    """{c[0]}                .OMMMMo        """,
    """{c[0]}                lMMM"          """,
    """{c[0]}      .;loddo:.  .olloddol;.   """,
    """{c[0]}    cKMMMMMMMMMMNWMMMMMMMMMM0: """,
    """{c[0]}  .KMMMMMMMMMMMMMMMMMMMMMMMWd. """,
    """{c[0]}  XMMMMMMMMMMMMMMMMMMMMMMMX.   """,
    """{c[0]}  MMMMMMMMMMMMMMMMMMMMMMMM:    """,
    """{c[0]}  MMMMMMMMMMMMMMMMMMMMMMMM:    """,
    """{c[0]}  MMMMMMMMMMMMMMMMMMMMMMMMX.   """,
    """{c[0]}  kMMMMMMMMMMMMMMMMMMMMMMMMWd. """,
    """{c[0]}  'XMMMMMMMMMMMMMMMMMMMMMMMMMMk""",
    """{c[0]}   'XMMMMMMMMMMMMMMMMMMMMMMMMK.""",
    """{c[0]}     kMMMMMMMMMMMMMMMMMMMMMMd  """,
    """{c[0]}      ;KMMMMMMMWXXWMMMMMMMk.   """,
    """{c[0]}        "cooc*"    "*coo'"     """,
]

# Alternative logo : Apple's "retro" logo.

COLORS_RETRO = [
    Colors.CYAN_BRIGHT,
    Colors.GREEN_BRIGHT,
    Colors.YELLOW_BRIGHT,
    Colors.YELLOW_NORMAL,
    Colors.RED_BRIGHT,
    Colors.MAGENTA_BRIGHT,
    Colors.BLUE_BRIGHT,
]

LOGO_RETRO = [
    """{c[0]}               {c[1]}###{c[0]}       """,
    """{c[0]}             {c[1]}####{c[0]}        """,
    """{c[0]}             {c[1]}###{c[0]}         """,
    """{c[0]}     {c[1]}#######{c[0]}    {c[1]}#######{c[0]}  """,
    """{c[0]}   {c[2]}######################{c[0]}""",
    """{c[0]}  {c[2]}#####################{c[0]}  """,
    """{c[0]}  {c[4]}####################{c[0]}   """,
    """{c[0]}  {c[4]}####################{c[0]}   """,
    """{c[0]}  {c[4]}#####################{c[0]}  """,
    """{c[0]}   {c[5]}######################{c[0]}""",
    """{c[0]}    {c[5]}####################{c[0]} """,
    """{c[0]}      {c[6]}################{c[0]}   """,
    """{c[0]}       {c[6]}####{c[0]}     {c[6]}#####{c[0]}    """,
]

# Alternative logo : Apple's "retro" logo (low intensity).

COLORS_RETRO_LOW = [
    Colors.CYAN_NORMAL,
    Colors.GREEN_NORMAL,
    Colors.YELLOW_NORMAL,
    Colors.YELLOW_NORMAL,
    Colors.RED_NORMAL,
    Colors.MAGENTA_NORMAL,
    Colors.BLUE_NORMAL,
]

LOGO_RETRO_LOW = LOGO_RETRO

# Alternative logo: WWDC 2020 logo
COLORS_WWDC20 = [
    Colors8Bit(1, 231),  # bright white
    Colors8Bit(1, 197),  # bright red
    Colors8Bit(1, 103),  # bright lavender
    Colors8Bit(1, 71),  # bright green
    Colors8Bit(1, 133),  # bright purple
    Colors8Bit(1, 172),  # bright orange
    Colors8Bit(1, 30),  # bright cyan
]

# pylint: disable=line-too-long
LOGO_WWDC20 = [
    """{c[6]}                                         {c[4]}_.{c[1]}                    """,
    """{c[5]}                                     {c[0]}_/=\\{c[6]}~{c[5]}<                    """,
    """{c[1]}                                   {c[0]}.{c[2]}##>{c[4]}(./}}{c[2]}                    """,
    """{c[0]}                                 {c[2]}//]@{c[0]})(={c[5]}>{c[3]}[{c[4]}/                    """,
    """{c[2]}                                {c[0]}try{c[6]}*;"{c[0]}]{c[2]}]~/                     """,
    """{c[1]}                               {c[0]}*_{c[2]}(>}}{c[0]}+{c[1]}~{c[6]}/"#{c[0]}                      """,
    """{c[1]}                               {c[6]}<<<{c[5]}~{c[0]}#/]*/                       """,
    """{c[0]}                              {c[6]}(<{c[1]}_~;{c[5]}/{c[0]}+/{c[1]}                         """,
    """{c[2]}                              /={{+{c[4]}|                            """,
    """{c[5]}              _.:{c[1]}+*{c[3]}|or{c[0]}~=._           {c[6]}_{c[3]}.]@{c[0]}~{c[5]}:{c[3]}var_{c[4]}[._             """,
    """{c[0]}           .*{c[6]}(;{c[0]}or{c[6]};{c[1]}_{c[2]}<(}}{c[6]}as>#{c[0]}>\\{c[4]}=.{c[3]}__.{c[4]}<>/{c[2]}#}}{c[0]}}}={c[5]}({{{c[0]}/@{c[4]}|do_{c[3]}>/*~.          """,
    """{c[0]}         {c[2]}/-{c[0]}(+>.{c[4]}or{c[5]}/;=]?{c[6]}])+{c[0]}[(;<{c[3]}?}}({c[0]}for{c[3]}[~}}{c[6]}?{c[2]}(~}}-{c[4]}+{c[0]}_{c[2]}/{c[5]}.{c[0]}-{c[3]}#)!{c[2]}]~          """,
    """{c[0]}        {c[1]}[|[{c[0]}({c[5]};}}in{c[2]};/~{c[0]}*/.{c[5]}<(?{c[4]}\\_{c[1]}"<?/{c[0]}!|({c[4]}[{c[0]}[{c[2]}_}}@"{c[3]}/_{{{c[2]}(>{c[1]}]-{c[4]}/}}{c[6]}_{c[0]}[){c[1]}{{({c[2]}={c[5]}.{c[0]}       """,
    """{c[4]}      {c[5]}#or{c[1]}){c[4]}@{c[0]}"_~|*{c[6]}(~?{c[1]}"{c[0]}~@@_?.:.{c[2]}#~~{c[0]}+{c[2]}{{_{c[5]}+~{c[0]}"{c[3]}var:<}}{c[2]}#*[{c[5]}or{{{c[0]}|+}}{c[2]}!{c[3]}>         """,
    """{c[5]}     {c[2]}={c[4]}#{c[1]}/{c[2]}"{c[5]}#{c[3]}[<=:>{c[2]}}}</{c[4]}\\><{c[0]}!{c[2]}or{c[4]}[)\\{c[2]}{{!{c[0]}{{{c[2]};=>{c[6]}<{c[2]}{{{c[0]}"{c[4]}]>{c[3]}_{c[5]}+~{c[2]}:*{c[0]}!)+({c[2]}".<>{c[0]}|:{c[4]}          """,
    """{c[5]}    {c[2]}@<{c[0]}?{c[6]}({c[0]}(-{c[6]}{{{c[4]}-{c[0]};;{c[5]}-]{c[4]};"!{c[0]}_"({c[3]})+{c[1]}/#{c[2]}:.{c[5]}\\{{{{{c[0]}(""*#;~{c[6]}+{c[0]};]@<;as?\\{c[3]}*{c[4]}*}}{c[0]}/           """,
    """{c[6]}    {c[5]}:=>{c[3]}[{c[2]}\\<=:{c[3]}+.{c[0]}<{c[2]}.>{c[0]}[-|{c[6]}}}~{c[0]}_{{#\\}}>?[["*|{c[2]}"@<.{c[3]}@{c[6]}).{c[0]}:{c[2]}!<{c[5]}@var{c[0]}|"{c[6]}~            """,
    """{c[0]}   (-:{c[6]}~;{c[0]}_|//{c[5]}-=#{c[0]}]-{c[2]}_}};{c[0]}!@{c[3]}?{{<{c[0]}?*.{c[4]};{c[3]};[:{c[6]};{c[0]}\\""{c[6]}{{/{c[2]}_{c[4]})@:{c[0]}/{c[3]}~{c[0]}._-{c[1]}>{c[2]};{c[6]}){c[0]}             """,
    """{c[0]}   {c[1]}~*\\/@{c[0]}@?{c[6]}?;]{c[0]}+{c[6]}@]@/in{c[1]}>{c[2]}~?{c[3]}={c[6]}~{c[5]};;{c[3]}.{{{c[6]}-/<{c[0]}:*{c[2]}~{c[5]}@{c[6]}//{c[0]}"|{c[2]}+{c[5]}|{c[0]}-;!{c[2]}._{c[0]}#=}}             """,
    """{c[0]}   {c[3]}{{?{c[5]}__{c[2]}!![{c[3]}>{c[6]}<{c[0]}_{c[4]}({c[0]});{c[2]}.[{c[0]}<?~{c[6]}+-{c[4]}){{|{c[3]}\\{c[1]}+?*{c[2]}:{c[1]}@={c[0]}}}<{c[4]}~\\!{c[2]}/|<{c[6]}]"{c[4]}@let@-({c[3]}             """,
    """{c[5]}   {{@{c[3]}.@{c[1]}}}!]{c[4]}<{c[0]}}}~({c[2]};{c[0]}.-){c[3]}~*={c[0]}?.\\{c[2]}!{c[0]}=>{c[2]}~{c[0]}-+?=_~!{{{c[3]}|*){c[0]}|{c[2]}~(\\{c[4]}@{c[3]}[!"{c[0]}])={c[3]}             """,
    """{c[0]}   {c[4]}if.{c[6]}_>{c[0]}."*{c[4]}?_.{c[0]}\\:{c[5]};\\){c[2]}*+<{c[1]}/\\{c[0]}-{c[5]}<={c[3]}>{c[0]}=:}}{c[2]}]in{c[0]};{c[3]}}}{c[0]}+var}}{c[2]}:.{c[1]}#{c[4]}@{c[0]}<{c[1]}}}{{{{>{c[0]}             """,
    """{c[3]}    {c[0]}*-(~{c[2]}/!{c[0]}=+{c[2]}@{c[5]}:{c[1]}}}}}|{c[2]}@?"{c[5]}).{c[0]};<!{c[6]}>]<?{c[1]}~!:{c[3]}{{"*{c[0]}+{{{c[6]}->{c[4]}@>_?{c[5]}@{c[0]}#@_}}<"{c[2]}\\{c[1]}            """,
    """{c[4]}    {c[0]}=}}{{<#{c[5]}-{c[2]}@-_{c[0]}\\.){c[2]}[:{c[0]}_={c[2]}-~;{c[6]}[-{c[5]}}}{c[0]}|#+{c[5]}}}!}}{c[1]}}}|{c[2]}/{c[1]}{{{c[0]}(#*{c[1]}"!={c[0]})@{c[6]}-._{c[2]}({c[4]}#|*.           """,
    """{c[2]}    {c[6]}[{c[0]};"{c[1]}!\\{c[4]}+!{c[0]}!]["{c[1]}]|{c[5]}@{c[2]}~{{{c[5]}*{c[0]}:"{c[1]}>{c[0]}=_{c[4]}-\\({c[2]}/{c[4]}.{c[2]}_{c[1]}><}}>{c[0]}~=.{c[3]}(:{c[2]}?";{c[5]}{{;!{c[1]};;if{c[0]}.={c[5]}          """,
    """{c[2]}     {c[6]}/#{c[2]}_{c[5]};/@{c[2]}@{c[1]}(;{c[0]}!>{{{c[3]}(]-{c[4]}[#"{c[0]}\\</{c[5]}"}}|{c[0]}!{c[2]}=~{c[4]};:;{c[1]};{c[5]}/!|{c[6]}\\~{{#?.{c[1]}_\\*{c[3]}.;#{c[0]}\\;{c[2]})_{c[4]}        """,
    """{c[0]}     {c[3]}*!+|;{c[0]}]}}{c[5]}:{c[0]}\\_~{c[2]}"{c[4]}|].{c[2]};{c[1]}_="#{c[2]}/!\\!{c[0]}\\{c[5]}[{c[2]}[}}[_{c[0]}.:{c[1]}/\\?{c[2]}<>/{c[3]}()({c[0]}-=!*var{c[6]}:/={c[0]}\\.     """,
    """{c[2]}      as#{c[0]}~{c[5]})(.{c[4]}>{c[2]}.{c[1]}/\\{c[5]};}}-{c[1]}@#]{c[2]}={c[4]}<){c[1]}{{{c[0]})>_={c[6]}>=}}{c[0]}|>:{c[4]}.{c[6]}/"@{c[2]}]@@{c[0]}if({c[2]}[{c[3]}+]*{c[4]}}}>{c[3]}<({c[1]}.={c[0]}      """,
    """{c[6]}       {c[0]}={c[2]}{{->{c[0]}/\\}}{c[2]}@/{c[0]}"]/{c[1]}[@!{c[0]}|}}{c[5]}{{"|{c[2]};#{c[4]}\\.\\|_{c[3]}{{{c[6]}{{<{c[2]}-{{{c[6]})~{c[0]}<!{c[4]}/={c[2]}.{c[3]}!~\\{c[2]}=={c[1]}?|{c[2]}"={c[3]}/*{c[4]}      """,
    """{c[2]}       {{.-({c[5]}!/.{c[4]}.{c[6]}_{c[0]}(:{c[1]}\\".{c[6]}~+{c[4]}!|{c[0]}@{c[6]}?":{c[5]}]={c[2]};!{c[5]}\\{c[2]}[=|{c[1]}#;/{c[5]}-{c[0]}try{c[2]}/<{c[5]};{c[2]}<{c[1]}var{c[5]}#do;{c[0]}>{c[6]}       """,
    """{c[0]}        \\.{{{c[5]}let{c[0]}({{*{c[2]}/!:{c[3]}><{c[1]}/_*{c[0]}|/?"/{c[3]})or{c[0]}.;(){c[1]}~<({c[5]}>{c[0]}:\\+*{{{c[2]}\\{c[0]}]_}};{c[1]}>:~{c[0]}?        """,
    """{c[2]}          {c[1]}var{c[0]}:<={c[5]}#{c[2]}.{c[6]}+;-{c[0]}/{c[3]}-\\{c[1]}>+|{c[2]}=!{c[5]}?#{c[3]}try{c[6]}]{c[3]}[(/{c[5]}-={c[6]}\\?:{c[4]}}}@!{c[1]}!]+{c[4]}.@\\{c[1]}:/{c[2]}         """,
    """{c[5]}           {c[0]}+_+"\\?{c[5]}(.|{c[2]}[@]{c[5]}#{c[4]})[{c[0]}=#{c[6]}{{;"{c[0]}|:{c[2]}for{c[1]}{{{c[2]}!#{c[6]}){c[0]}?{c[4]}]\\{c[0]}"]{c[3]}.}}{{{c[0]}}}(.#"          """,
    """{c[2]}            {{}}{c[0]}}}+?{c[2]}"|{c[6]};{c[4]}<>({c[2]}-="+<_{c[0]}>{c[3]}/}}-{c[1]}."}}{c[2]}\\>@{c[3]}-{c[2]}|_<*{c[0]}@{c[3]}@{c[2]}:;{c[6]}!{{<{c[0]}            """,
    """{c[5]}              {c[2]}<({c[6]}-[{{{c[0]}\\{c[2]}-"[{{[{c[4]}+({c[5]}<>.{c[1]}~"_{c[4]}"~.let{c[6]}"~]{c[0]}}}{c[3]}?"do{c[4]}{{>/             """,
    """{c[4]}                {c[0]}"{{{c[6]}}}<){c[2]}do{c[4]}|:"{c[3]}            "{c[4]}*)}}{c[1]}*in{c[2]}[>"{c[1]}               """,
]
