/**
* ESPromiseScheduler.ts
* @author Nev Wylie (newylie)
* @copyright Microsoft 2019
*/
import ESPromise from "./ESPromise";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
export type ESPromiseSchedulerEvent<T> = (eventId?: string) => ESPromise<T>;
export interface IScheduledEventDetails {
    evt: ESPromise<any>;
    tm: number;
    wTm?: number;
    id: string;
    to?: any;
    isRunning: boolean;
    isAborted: boolean;
    abort?: (message: string) => void;
}
/**
 * Provides a simple mechanism queueing mechanism for scheduling events based on the ESPromise callbacks, this is used to ensure
 * order of async operations that are required to be executed in a specific order.
 */
export default class ESPromiseScheduler {
    static incomplete(): IScheduledEventDetails[];
    static waitingToStart(): IScheduledEventDetails[];
    constructor(name?: string, diagLog?: IDiagnosticLogger);
    /**
     * Schedule an event that will execute the startEvent after all outstanding events are resolved or rejected. This is used to ensure
     * order of async operations that are required to be executed in a specific order.
     * The returned promise will be resolve or rejected based on the values returned from the doAction.
     * @param startEventAction The function to execute to start the event after all outstanding events have completed, will be called asynchronously.
     * @param eventName An [Optional] event name to assist with debbuging to understand what events are either waiting to start or still running (incomplete).
     * @param timeout An [Optional] timeout
     */
    scheduleEvent<T>(startEventAction: ESPromiseSchedulerEvent<T>, eventName?: string, timeout?: number): ESPromise<T>;
}
