import { INotificationManager } from "../JavaScriptSDK.Interfaces/INotificationManager";
import { IPerfEvent } from "../JavaScriptSDK.Interfaces/IPerfEvent";
import { IPerfManager, IPerfManagerProvider } from "../JavaScriptSDK.Interfaces/IPerfManager";
export declare class PerfEvent implements IPerfEvent {
    static ParentContextKey: string;
    static ChildrenContextKey: string;
    /**
     * The name of the event
     */
    name: string;
    /**
     * The start time of the event in ms
     */
    start: number;
    /**
     * The payload (contents) of the perfEvent, may be null or only set after the event has completed depending on
     * the runtime environment.
     */
    payload: any;
    /**
     * Is this occurring from an asynchronous event
     */
    isAsync: boolean;
    /**
     * Identifies the total inclusive time spent for this event, including the time spent for child events,
     * this will be undefined until the event is completed
     */
    time?: number;
    /**
     * Identifies the exclusive time spent in for this event (not including child events),
     * this will be undefined until the event is completed.
     */
    exTime?: number;
    /**
     * Identifies whether this event is a child event of a parent
     */
    isChildEvt: () => boolean;
    getCtx?: (key: string) => any | null | undefined;
    setCtx?: (key: string, value: any) => void;
    complete: () => void;
    constructor(name: string, payloadDetails: () => any, isAsync: boolean);
}
export declare class PerfManager implements IPerfManager {
    /**
     * General bucket used for execution context set and retrieved via setCtx() and getCtx.
     * Defined as private so it can be visualized via the DebugPlugin
     */
    private ctx;
    constructor(manager?: INotificationManager);
    /**
     * Create a new event and start timing, the manager may return null/undefined to indicate that it does not
     * want to monitor this source event.
     * @param src The source name of the event
     * @param payloadDetails - An optional callback function to fetch the payload details for the event.
     * @param isAsync - Is the event occurring from a async event
     */
    create(src: string, payload?: any, isAsync?: boolean): IPerfEvent | null | undefined;
    /**
     * Complete the perfEvent and fire any notifications.
     * @param perfEvent Fire the event which will also complete the passed event
     */
    fire(perfEvent: IPerfEvent): void;
    /**
     * Set an execution context value
     * @param key - The context key name
     * @param value - The value
     */
    setCtx(key: string, value: any): void;
    /**
     * Get the execution context value
     * @param key - The context key
     */
    getCtx(key: string): any;
}
/**
 * Helper function to wrap a function with a perf event
 * @param mgrSource - The Performance Manager or a Performance provider source (may be null)
 * @param getSource - The callback to create the source name for the event (if perf monitoring is enabled)
 * @param func - The function to call and measure
 * @param details - A function to return the payload details
 * @param isAsync - Is the event / function being call asynchronously or synchronously
 */
export declare function doPerf<T>(mgrSource: IPerfManagerProvider | IPerfManager, getSource: () => string, func: (perfEvt?: IPerfEvent) => T, details?: () => any, isAsync?: boolean): T;
/**
 * Set the global performance manager to use when there is no core instance or it has not been initialized yet.
 * @param perfManager - The IPerfManager instance to use when no performance manager is supplied.
 */
export declare function setGblPerfMgr(perfManager: IPerfManager): void;
/**
 * Get the current global performance manager that will be used with no performance manager is supplied.
 * @returns - The current default manager
 */
export declare function getGblPerfMgr(): IPerfManager;
