import '@tensorflow/tfjs-backend-cpu';
export interface ModelResult {
    languageId: string;
    confidence: number;
}
export interface ModelOperationsOptions {
    modelJsonLoaderFunc?: () => Promise<{
        [key: string]: any;
    }>;
    weightsLoaderFunc?: () => Promise<ArrayBuffer>;
    minContentSize?: number;
    maxContentSize?: number;
    normalizeNewline?: boolean;
}
export declare class ModelOperations {
    private static DEFAULT_MAX_CONTENT_SIZE;
    private static DEFAULT_MIN_CONTENT_SIZE;
    private static NODE_MODEL_JSON_FUNC;
    private static NODE_WEIGHTS_FUNC;
    private _model;
    private _modelJson;
    private _weights;
    private readonly _minContentSize;
    private readonly _maxContentSize;
    private readonly _modelJsonLoaderFunc;
    private readonly _weightsLoaderFunc;
    private readonly _normalizeNewline;
    constructor(modelOptions?: ModelOperationsOptions);
    private getModelJSON;
    private getWeights;
    private loadModel;
    runModel(content: string): Promise<Array<ModelResult>>;
    dispose(): void;
}
