/**
 * Copyright (c) 2018 The xterm.js authors. All rights reserved.
 * @license MIT
 */

// This file contains strings that get exported in the API so they can be localized

let promptLabelInternal = 'Terminal input';
const promptLabel = {
  get: () => promptLabelInternal,
  set: (value: string) => promptLabelInternal = value
};

let tooMuchOutputInternal = 'Too much output to announce, navigate to rows manually to read';
const tooMuchOutput = {
  get: () => tooMuchOutputInternal,
  set: (value: string) => tooMuchOutputInternal = value
};

export {
  promptLabel,
  tooMuchOutput
};
