import { getIPC } from './ipc.js';

/**
 * Enables the sending of ANR messages to the main process.
 */
function enableAnrRendererMessages(options) {
    const config = Object.assign({ pollInterval: 1000, anrThreshold: 5000, captureStackTrace: false }, options);
    const ipc = getIPC();
    document.addEventListener('visibilitychange', () => {
        ipc.sendStatus({ status: document.visibilityState, config });
    });
    ipc.sendStatus({ status: document.visibilityState, config });
    setInterval(() => {
        ipc.sendStatus({ status: 'alive', config });
    }, config.pollInterval);
}

export { enableAnrRendererMessages };
//# sourceMappingURL=anr.js.map
