import { __awaiter } from 'tslib';
import { createTransport } from '@sentry/core';
import { getIPC } from './ipc.js';

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    const ipc = getIPC();
    return createTransport(options, (request) => __awaiter(this, void 0, void 0, function* () {
        ipc.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    }));
}

export { makeRendererTransport };
//# sourceMappingURL=transport.js.map
