const node = require('@sentry/node');
const utils = require('@sentry/utils');
const electron = require('electron');
const normalize = require('../common/normalize.js');

/** Parses the module name form a filename */
function getModuleFromFilename(filename) {
    if (!filename) {
        return;
    }
    const normalizedFilename = normalize.normalizeUrl(filename, electron.app.getAppPath());
    return node.getModuleFromFilename(normalizedFilename);
}
// node.js stack parser but filename normalized before parsing the module
const defaultStackParser = utils.createStackParser(utils.nodeStackLineParser(getModuleFromFilename));

exports.defaultStackParser = defaultStackParser;
//# sourceMappingURL=stack-parse.js.map
