/* malevic@0.20.2 - Aug 10, 2024 */
import { plugins } from 'malevic/dom';

function withForms(type) {
    plugins.setAttribute.add(type, ({ element, attr, value }) => {
        if (attr === 'value' && element instanceof HTMLInputElement) {
            const text = (element.value = value == null ? '' : value);
            element.value = text;
            return true;
        }
        return null;
    });
    return type;
}

export { withForms };
