/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import pro.javacard.tlv.TLVEncoder;
import pro.javacard.tlv.TLVParser;
import pro.javacard.tlv.Tag;

public final class TLV {
    private final Tag tag;
    private final byte[] value;
    private final List<TLV> children;
    private TLV parent;

    TLV(Tag tag, byte[] value, List<TLV> children) {
        this(tag, value, children, null);
    }

    private TLV(Tag tag, byte[] value, List<TLV> children, TLV parent) {
        this.tag = Objects.requireNonNull(tag, "tag cannot be null");
        this.value = value;
        this.children = children == null ? new ArrayList() : children;
        this.parent = parent;
    }

    public static TLV of(Tag tag, byte[] value) {
        return new TLV(tag, (byte[])value.clone(), null, null);
    }

    public static TLV of(String tag, byte[] value) {
        return new TLV(Tag.ber(tag), (byte[])value.clone(), null, null);
    }

    public static TLV of(Tag tag, TLV ... tlvs) {
        return TLV.of(tag, Arrays.asList(tlvs));
    }

    public static TLV of(Tag tag, Collection<TLV> tlvs) {
        Objects.requireNonNull(tag, "tag");
        ArrayList<TLV> children = new ArrayList<TLV>(tlvs.size());
        TLV parent = new TLV(tag, null, children, null);
        for (TLV tlv : tlvs) {
            Objects.requireNonNull(tlv, "child TLV");
            tlv.parent = parent;
            children.add(tlv);
        }
        return parent;
    }

    public static TLV build(Tag tag) {
        Objects.requireNonNull(tag, "tag");
        return new TLV(tag, null, new ArrayList<TLV>(), null);
    }

    public static TLV build(String tagHex) {
        return TLV.build(Tag.ber(tagHex));
    }

    public Tag tag() {
        return this.tag;
    }

    public byte[] value() {
        return this.value == null ? null : (byte[])this.value.clone();
    }

    public List<TLV> children() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TLV find(Tag tag) {
        if (this.tag.equals(tag)) {
            return this;
        }
        for (TLV t : this.children) {
            TLV r = t.find(tag);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public TLV find(Tag tag, int maxDepth) {
        return this.find(tag, maxDepth, 0);
    }

    private TLV find(Tag tag, int maxDepth, int depth) {
        if (this.tag.equals(tag)) {
            return this;
        }
        if (maxDepth >= 0 && depth >= maxDepth) {
            return null;
        }
        for (TLV t : this.children) {
            TLV r = t.find(tag, maxDepth, depth + 1);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public List<TLV> findAll(Tag t) {
        ArrayList<TLV> result = new ArrayList<TLV>();
        if (this.tag.equals(t)) {
            result.add(this);
            return result;
        }
        for (TLV tlv : this.children) {
            result.addAll(tlv.findAll(t));
        }
        return result;
    }

    public static Optional<TLV> find(List<TLV> list, Tag tag) {
        for (TLV tlv : list) {
            TLV r = tlv.find(tag);
            if (r == null) continue;
            return Optional.of(r);
        }
        return Optional.empty();
    }

    public static List<TLV> findAll(List<TLV> list, Tag tag) {
        ArrayList<TLV> result = new ArrayList<TLV>();
        for (TLV tlv : list) {
            result.addAll(tlv.findAll(tag));
        }
        return result;
    }

    public TLV add(TLV tlv) {
        Objects.requireNonNull(tlv, "tlv");
        if (this.value != null) {
            throw new IllegalStateException("Cannot add children to primitive TLV");
        }
        tlv.parent = this;
        this.children.add(tlv);
        return this;
    }

    public TLV add(Tag childTag, byte[] value) {
        Objects.requireNonNull(childTag, "childTag");
        Objects.requireNonNull(value, "value");
        return this.add(TLV.of(childTag, value));
    }

    public TLV add(String childTagHex, byte[] value) {
        Objects.requireNonNull(childTagHex, "childTagHex");
        Objects.requireNonNull(value, "value");
        return this.add(TLV.of(childTagHex, value));
    }

    public TLV add(byte[] childTagBytes, byte[] value) {
        Objects.requireNonNull(childTagBytes, "childTagBytes");
        Objects.requireNonNull(value, "value");
        return this.add(TLV.of(Tag.ber(childTagBytes), value));
    }

    public TLV addByte(Tag tag, byte value) {
        return this.add(tag, new byte[]{value});
    }

    public TLV addByte(String tag, byte value) {
        return this.add(tag, new byte[]{value});
    }

    public TLV end() {
        if (this.parent == null) {
            throw new IllegalStateException("No parent to return to");
        }
        return this.parent;
    }

    public byte[] encode() {
        return TLVEncoder.encode(this);
    }

    public static List<TLV> parse(byte[] data) {
        return TLVParser.parse(data, Tag.Type.BER);
    }

    public static List<TLV> parse(ByteBuffer buffer) {
        return TLVParser.parse(buffer, Tag.Type.BER);
    }

    public static TLV parseSingle(ByteBuffer buffer) {
        return TLVParser.parseOne(buffer, Tag.Type.BER);
    }

    private static void visualize(TLV tlv, int indent, List<String> list) {
        if (tlv.hasChildren()) {
            list.add(" ".repeat(indent) + String.valueOf(tlv.tag));
            int tagLen = tlv.tag.bytes().length;
            for (TLV t : tlv.children) {
                TLV.visualize(t, indent + tagLen * 2 + 2, list);
            }
        } else {
            list.add(" ".repeat(indent) + String.valueOf(tlv.tag) + " " + HexFormat.of().withUpperCase().formatHex(tlv.value));
        }
    }

    public List<String> visualize() {
        ArrayList<String> result = new ArrayList<String>();
        TLV.visualize(this, 0, result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TLV)) return false;
        TLV other = (TLV)obj;
        if (!this.tag.equals(other.tag)) return false;
        if (!Arrays.equals(this.value, other.value)) return false;
        if (!this.children.equals(other.children)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tag, Arrays.hashCode(this.value), this.children);
    }
}

